# Generated by Django 3.2.15 on 2022-11-25 09:26

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import cms.models.fields

import djangocms_attributes_field.fields
import filer.fields.folder

import cms_forms.sizefield.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('filer', '0014_folder_permission_choices'),
        ('cms', '0022_auto_20180620_1551'),
    ]

    operations = [
        migrations.CreateModel(
            name='EmailFieldPlugin',
            fields=[
                ('name', models.CharField(blank=True,
                                          help_text='Used to set the field name',
                                          max_length=255,
                                          verbose_name='Name')),
                ('label', models.CharField(blank=True, max_length=255,
                                           verbose_name='Label')),
                ('required', models.BooleanField(default=False,
                                                 verbose_name='Field is required')),
                ('required_message', models.TextField(blank=True,
                                                      help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                                                      null=True,
                                                      verbose_name='Error message')),
                ('placeholder_text', models.CharField(blank=True,
                                                      help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                                                      max_length=255,
                                                      verbose_name='Placeholder text')),
                ('help_text', models.TextField(blank=True,
                                               help_text='Explanatory text displayed next to input field. Just like this one.',
                                               null=True,
                                               verbose_name='Help text')),
                ('attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('min_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Min value')),
                ('max_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Max value')),
                ('initial_value', models.CharField(blank=True,
                                                   help_text='Default value of field.',
                                                   max_length=255,
                                                   verbose_name='Initial value')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_emailfieldplugin', serialize=False,
                    to='cms.cmsplugin')),
                ('email_send_notification', models.BooleanField(default=False,
                                                                help_text='When checked, the value of this field will be used to send an email notification.',
                                                                verbose_name='send notification when form is submitted')),
                ('email_subject', models.CharField(blank=True, default='',
                                                   help_text='Used as the email subject when email_send_notification is checked.',
                                                   max_length=255,
                                                   verbose_name='email subject')),
                ('email_body', models.TextField(blank=True, default='',
                                                help_text='Additional body text used when email notifications are active.',
                                                verbose_name='Additional email body')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FieldPlugin',
            fields=[
                ('name', models.CharField(blank=True,
                                          help_text='Used to set the field name',
                                          max_length=255,
                                          verbose_name='Name')),
                ('label', models.CharField(blank=True, max_length=255,
                                           verbose_name='Label')),
                ('required', models.BooleanField(default=False,
                                                 verbose_name='Field is required')),
                ('required_message', models.TextField(blank=True,
                                                      help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                                                      null=True,
                                                      verbose_name='Error message')),
                ('placeholder_text', models.CharField(blank=True,
                                                      help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                                                      max_length=255,
                                                      verbose_name='Placeholder text')),
                ('help_text', models.TextField(blank=True,
                                               help_text='Explanatory text displayed next to input field. Just like this one.',
                                               null=True,
                                               verbose_name='Help text')),
                ('attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('min_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Min value')),
                ('max_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Max value')),
                ('initial_value', models.CharField(blank=True,
                                                   help_text='Default value of field.',
                                                   max_length=255,
                                                   verbose_name='Initial value')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_fieldplugin', serialize=False,
                    to='cms.cmsplugin')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FieldsetPlugin',
            fields=[
                ('legend', models.CharField(blank=True, max_length=255,
                                            verbose_name='Legend')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_fieldsetplugin', serialize=False,
                    to='cms.cmsplugin')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FormButtonPlugin',
            fields=[
                ('label',
                 models.CharField(max_length=255, verbose_name='Label')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_formbuttonplugin', serialize=False,
                    to='cms.cmsplugin')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True,
                                        serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, editable=False,
                                          max_length=255,
                                          verbose_name='form name')),
                ('data', models.TextField(blank=True, editable=False)),
                ('recipients', models.TextField(blank=True, editable=False,
                                                help_text='People who got a notification when form was submitted.',
                                                verbose_name='users notified')),
                ('language',
                 models.CharField(choices=[('nl', 'Dutch')], default='nl',
                                  max_length=10,
                                  verbose_name='form language')),
                ('form_url', models.CharField(blank=True, max_length=255,
                                              verbose_name='form url')),
                ('sent_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Form submission',
                'verbose_name_plural': 'Form submissions',
                'ordering': ['-sent_at'],
            },
        ),
        migrations.CreateModel(
            name='TextAreaFieldPlugin',
            fields=[
                ('name', models.CharField(blank=True,
                                          help_text='Used to set the field name',
                                          max_length=255,
                                          verbose_name='Name')),
                ('label', models.CharField(blank=True, max_length=255,
                                           verbose_name='Label')),
                ('required', models.BooleanField(default=False,
                                                 verbose_name='Field is required')),
                ('required_message', models.TextField(blank=True,
                                                      help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                                                      null=True,
                                                      verbose_name='Error message')),
                ('placeholder_text', models.CharField(blank=True,
                                                      help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                                                      max_length=255,
                                                      verbose_name='Placeholder text')),
                ('help_text', models.TextField(blank=True,
                                               help_text='Explanatory text displayed next to input field. Just like this one.',
                                               null=True,
                                               verbose_name='Help text')),
                ('attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('min_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Min value')),
                ('max_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Max value')),
                ('initial_value', models.CharField(blank=True,
                                                   help_text='Default value of field.',
                                                   max_length=255,
                                                   verbose_name='Initial value')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_textareafieldplugin',
                    serialize=False, to='cms.cmsplugin')),
                ('text_area_columns',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='columns')),
                ('text_area_rows',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='rows')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Option',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True,
                                        serialize=False, verbose_name='ID')),
                ('value',
                 models.CharField(max_length=255, verbose_name='Value')),
                ('default_value',
                 models.BooleanField(default=False, verbose_name='Default')),
                ('position', models.PositiveIntegerField(blank=True,
                                                         verbose_name='Position')),
                ('field', models.ForeignKey(editable=False,
                                            on_delete=django.db.models.deletion.CASCADE,
                                            to='cms_forms.fieldplugin')),
            ],
            options={
                'verbose_name': 'Option',
                'verbose_name_plural': 'Options',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='ImageUploadFieldPlugin',
            fields=[
                ('name', models.CharField(blank=True,
                                          help_text='Used to set the field name',
                                          max_length=255,
                                          verbose_name='Name')),
                ('label', models.CharField(blank=True, max_length=255,
                                           verbose_name='Label')),
                ('required', models.BooleanField(default=False,
                                                 verbose_name='Field is required')),
                ('required_message', models.TextField(blank=True,
                                                      help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                                                      null=True,
                                                      verbose_name='Error message')),
                ('placeholder_text', models.CharField(blank=True,
                                                      help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                                                      max_length=255,
                                                      verbose_name='Placeholder text')),
                ('help_text', models.TextField(blank=True,
                                               help_text='Explanatory text displayed next to input field. Just like this one.',
                                               null=True,
                                               verbose_name='Help text')),
                ('attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('min_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Min value')),
                ('max_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Max value')),
                ('initial_value', models.CharField(blank=True,
                                                   help_text='Default value of field.',
                                                   max_length=255,
                                                   verbose_name='Initial value')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_imageuploadfieldplugin',
                    serialize=False, to='cms.cmsplugin')),
                ('max_size',
                 cms_forms.sizefield.models.FileSizeField(blank=True,
                                                          help_text='The maximum file size of the upload, in bytes. You can use common size suffixes (kB, MB, GB, ...).',
                                                          null=True,
                                                          verbose_name='Maximum file size')),
                ('max_width', models.PositiveIntegerField(blank=True,
                                                          help_text='The maximum width of the uploaded image, in pixels.',
                                                          null=True,
                                                          verbose_name='Maximum image width')),
                ('max_height', models.PositiveIntegerField(blank=True,
                                                           help_text='The maximum height of the uploaded image, in pixels.',
                                                           null=True,
                                                           verbose_name='Maximum image height')),
                ('upload_to', filer.fields.folder.FilerFolderField(
                    help_text='Select a folder to which all files submitted through this field will be uploaded to.',
                    on_delete=django.db.models.deletion.CASCADE,
                    to='filer.folder', verbose_name='Upload files to')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FormPlugin',
            fields=[
                ('name', models.CharField(
                    help_text='Used to filter out form submissions.',
                    max_length=255, verbose_name='Name')),
                ('error_message', models.TextField(blank=True,
                                                   help_text="An error message that will be displayed if the form doesn't validate.",
                                                   null=True,
                                                   verbose_name='Error message')),
                ('success_message', models.TextField(blank=True,
                                                     help_text='An success message that will be displayed.',
                                                     null=True,
                                                     verbose_name='Success message')),
                ('redirect_type', models.CharField(blank=True, choices=[
                    ('redirect_to_page', 'CMS Page'),
                    ('redirect_to_url', 'Absolute URL')],
                                                   help_text='Where to redirect the user when the form has been successfully sent?',
                                                   max_length=20,
                                                   verbose_name='Redirect to')),
                ('url', models.URLField(blank=True, null=True,
                                        verbose_name='Absolute URL')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('form_template',
                 models.CharField(choices=[('cms_forms/form.html', 'Default')],
                                  default='cms_forms/form.html',
                                  max_length=255,
                                  verbose_name='form template')),
                ('action_backend', models.CharField(
                    choices=[('default', 'Default'),
                             ('email_only', 'Email only'), ('none', 'None')],
                    default='default', max_length=15,
                    verbose_name='Action backend')),
                ('form_attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_formplugin', serialize=False,
                    to='cms.cmsplugin')),
                ('recipients', models.ManyToManyField(blank=True,
                                                      help_text='People who will get the form content via e-mail.',
                                                      limit_choices_to={
                                                          'is_staff': True},
                                                      to=settings.AUTH_USER_MODEL,
                                                      verbose_name='Recipients')),
                ('redirect_page',
                 cms.models.fields.PageField(blank=True, null=True,
                                             on_delete=django.db.models.deletion.SET_NULL,
                                             to='cms.page',
                                             verbose_name='CMS Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FileUploadFieldPlugin',
            fields=[
                ('name', models.CharField(blank=True,
                                          help_text='Used to set the field name',
                                          max_length=255,
                                          verbose_name='Name')),
                ('label', models.CharField(blank=True, max_length=255,
                                           verbose_name='Label')),
                ('required', models.BooleanField(default=False,
                                                 verbose_name='Field is required')),
                ('required_message', models.TextField(blank=True,
                                                      help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                                                      null=True,
                                                      verbose_name='Error message')),
                ('placeholder_text', models.CharField(blank=True,
                                                      help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                                                      max_length=255,
                                                      verbose_name='Placeholder text')),
                ('help_text', models.TextField(blank=True,
                                               help_text='Explanatory text displayed next to input field. Just like this one.',
                                               null=True,
                                               verbose_name='Help text')),
                ('attributes',
                 djangocms_attributes_field.fields.AttributesField(blank=True,
                                                                   default=dict,
                                                                   verbose_name='Attributes')),
                ('min_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Min value')),
                ('max_value',
                 models.PositiveIntegerField(blank=True, null=True,
                                             verbose_name='Max value')),
                ('initial_value', models.CharField(blank=True,
                                                   help_text='Default value of field.',
                                                   max_length=255,
                                                   verbose_name='Initial value')),
                ('custom_classes', models.CharField(blank=True, max_length=255,
                                                    verbose_name='custom css classes')),
                ('cmsplugin_ptr', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True,
                    related_name='cms_forms_fileuploadfieldplugin',
                    serialize=False, to='cms.cmsplugin')),
                ('max_size',
                 cms_forms.sizefield.models.FileSizeField(blank=True,
                                                          help_text='The maximum file size of the upload, in bytes. You can use common size suffixes (kB, MB, GB, ...).',
                                                          null=True,
                                                          verbose_name='Maximum file size')),
                ('upload_to', filer.fields.folder.FilerFolderField(
                    help_text='Select a folder to which all files submitted through this field will be uploaded to.',
                    on_delete=django.db.models.deletion.CASCADE,
                    to='filer.folder', verbose_name='Upload files to')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
