# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sanic_jwt_extended']

package_data = \
{'': ['*']}

install_requires = \
['PyJWT>=1.6.4,<2.0.0',
 'aioredis>=1.3,<2.0',
 'flatten-dict>=0.2.0,<0.3.0',
 'sanic>=18.12.0']

extras_require = \
{':python_version >= "3.6.0" and python_version < "3.7.0"': ['dataclasses']}

setup_kwargs = {
    'name': 'sanic-jwt-extended',
    'version': '1.0.dev10',
    'description': 'Extended JWT integration with Sanic',
    'long_description': '<h1 align="center">🛡 Sanic-JWT-Extended 🛡</h1>\n\n<div align="center"> \n\n\n|           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n|:----------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| Buiild    | [![Tests](https://github.com/NovemberOscar/Sanic-JWT-Extended/workflows/Tests/badge.svg)](https://github.com/NovemberOscar/Sanic-JWT-Extended/actions?query=workflow%3ATests) [![Deploy](https://github.com/NovemberOscar/Sanic-JWT-Extended/workflows/Upload%20to%20PyPI/badge.svg)](https://github.com/NovemberOscar/Sanic-JWT-Extended/actions?query=workflow%3A%22Upload+to+PyPI%22) [![Netlify](https://img.shields.io/netlify/c2cf1ea1-bae1-448f-b52c-0dea6516446a?label=docs)](https://app.netlify.com/sites/sanic-jwt-extended/deploys)                                                                                         |\n| Quality   | [![codecov](https://codecov.io/gh/NovemberOscar/Sanic-JWT-Extended/branch/master/graph/badge.svg)](https://codecov.io/gh/NovemberOscar/Sanic-JWT-Extended) [![Codacy Badge](https://api.codacy.com/project/badge/Grade/5fe125514047445b80d6e3e75c2a7dbe)](https://www.codacy.com/manual/NovemberOscar/Sanic-JWT-Extended?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=NovemberOscar/Sanic-JWT-Extended&amp;utm_campaign=Badge_Grade) [![Maintainability](https://api.codeclimate.com/v1/badges/368dbc256c4837087c1e/maintainability)](https://codeclimate.com/github/NovemberOscar/Sanic-JWT-Extended/maintainability) |\n| Package   | ![PyPI](https://img.shields.io/pypi/v/sanic-jwt-extended.svg?label=stable) ![GitHub release (latest SemVer including pre-releases)](https://img.shields.io/github/v/release/NovemberOscar/Sanic-JWT-Extended?include_prereleases&label=latest) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/sanic-jwt-extended.svg)                                                                                                                                                                                                                                                                                                  |\n| Stats     | [![Downloads](https://pepy.tech/badge/sanic-jwt-extended)](https://pepy.tech/project/sanic-jwt-extended)    [![Downloads](https://pepy.tech/badge/sanic-jwt-extended/month)](https://pepy.tech/project/sanic-jwt-extended/month)                                                                                                                                                                                                                                                                                                                                                                                                        |\n| Community | [![Gitter](https://badges.gitter.im/Sanic-JWT-Extended/community.svg)](https://gitter.im/Sanic-JWT-Extended/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)                                                                                                                                                                                                                                                                                                                                                                                                                                                          |\n</div>\n\n> **☢️\xa0This is README of 1.0 version. [Click here](https://github.com/NovemberOscar/Sanic-JWT-Extended/tree/v0.4.4) to checkout legacy version(v0.4.4)**\n\n## 🚀 What is Sanic-JWT-Extended?\nSanic-JWT-Extended is an open source Sanic extension that provides JWT support (comply with RFC standard)\n\n## 💡 Why Sanic-JWT-Extended?\nSanic-JWT-Extended not only adds support for using JSON Web Tokens (JWT) to Sanic for protecting views,\nbut also many helpful (and **optional**) features  built in to make working with JSON Web Tokens\neasier. These include:\n\n* Support for adding public claims with [namespacing](https://auth0.com/docs/tokens/concepts/claims-namespacing)\n* Support for adding private claims\n* [Refresh tokens](https://auth0.com/blog/refresh-tokens-what-are-they-and-when-to-use-them/)\n* Token freshness and separate view decorators to only allow fresh tokens\n* Access control\n* blacklist support with some built-in blacklist\n* Provides Token object for easier jwt manifulation\n\n## ⚡️ Installation\n```shell script\n$ pip install sanic-jwt-extended --pre\n```\n```shell script\n$ poetry add sanic-jwt-extended --git https://github.com/NovemberOscar/Sanic-JWT-Extended.git\n```\n```shell script\n$ pipenv install sanic-jwt-extended --pre\n```\n\n## 📚 Documentation\n<a href="https://sanic-jwt-extended.seonghyeon.dev">\n<img src="https://i.imgur.com/eXRmcKO.png)](https://sanic-jwt-extended.seonghyeon.dev/" width="300" />\n</a>\n\n\n## 🛠 Developing Sanic-JWT-Extended\n\n### Prerequesties\n- [poetry](https://github.com/sdispater/poetry)\n\n### Installaion\n```shell script\n$ make env\n```\nthis will install dependencies with poetry. if poetry not found, will install poetry.\n\n### Development\n- `make format`: this will format your code with `isort` and `black`\n- `make check`: this will lint your code with `isort`, `black`, `mypy` and `pylint`\n- `make clean`: this will remove temporary things.\n\n### Commit Convention\n```\n<{verb}>({scope}): {summary}\n```\n#### Example\n- test: `<test>(foobar): Add TCs about FooBar`\n- fix: `<fix>(#12): Fix SpamEgg`\n- normal: `<feat>(cookie): Add cookie writer`\n\n### Testing\n```shell script\n$ make check  # check convention and type\n$ poetry run pytest\n```\n\nwith coverage:\n```shell script\n$ poetry run pytest --cov=sanic_jwt_extended tests/\n```\n\n**Make sure you wrote TCs about your work!**',
    'author': 'Seonghyeon Kim',
    'author_email': 'kim@seonghyeon.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/NovemberOscar/Sanic-JWT-Extended',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
