# -*- coding: utf-8 -*-
# Copyright 2021, SERTIT-ICube - France, https://sertit.unistra.fr/
# This file is part of eoreader project
#     https://github.com/sertit/eoreader
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""
**EOReader** library
"""

# Python 3.9
try:
    from functools import cache  # noqa
except ImportError:
    from functools import lru_cache, wraps
    from typing import Callable

    def cache(func: Callable) -> Callable:
        @lru_cache(maxsize=None)
        @wraps(func)
        def wrapper(*args, **kwargs):
            return func(*args, **kwargs)

        return wrapper


# Python 3.8
try:
    from functools import cached_property  # noqa
except ImportError:
    from typing import Callable

    def cached_property(func: Callable) -> property:
        @property
        @lru_cache(maxsize=None)
        @wraps(func)
        def wrapper(*args, **kwargs):
            return func(*args, **kwargs)

        return wrapper


__version__ = "0.8.0"
__title__ = "eoreader"
__description__ = (
    "Remote-sensing opensource python library reading optical and SAR sensors, "
    "loading and stacking bands, clouds, DEM and index in a sensor-agnostic way."
)
__author__ = "ICube-SERTIT"
__author_email__ = "dev-sertit@unistra.fr"
__url__ = "https://github.com/sertit/eoreader"
__license__ = "Apache 2.0"
__copyright__ = "Copyright 2021, SERTIT-ICube - France, https://sertit.unistra.fr/"
__documentation__ = "https://eoreader.readthedocs.io"
