# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bigeye_cli',
 'bigeye_cli.bigconfig',
 'bigeye_cli.catalog',
 'bigeye_cli.collections',
 'bigeye_cli.deltas',
 'bigeye_cli.exceptions',
 'bigeye_cli.issues',
 'bigeye_cli.lineage',
 'bigeye_cli.metric',
 'bigeye_cli.model',
 'bigeye_cli.sla',
 'bigeye_cli.workspace']

package_data = \
{'': ['*']}

install_requires = \
['bigeye-sdk>=0.4.45,<0.5.0',
 'click>=8.0.4,<9.0.0',
 'rich>=12.4.4,<13.0.0',
 'typer>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['bigeye = bigeye_cli.__main__:app']}

setup_kwargs = {
    'name': 'bigeye-cli',
    'version': '0.3.30',
    'description': 'Bigeye CLI offers developer tools for maintaining your developer workspace.',
    'long_description': '# **Bigeye CLI**\nVersion: 0.3.30\n\n## Installation\n### Setting up your local/build environment\n#### Mac with Pyenv\n1. Install [brew](https://brew.sh/)\n2. Install [pyenv](https://formulae.brew.sh/formula/pyenv)\n3. Install python and define a default global:\n```shell\npyenv install 3.8.10\npyenv global 3.8.10\n```\n\n#### Conda\n1. Install [conda](https://conda.io/projects/conda/en/latest/user-guide/install/index.html)\n2. Create environment with python3.8\n```shell\nconda create -n bigeye_env python=3.8\nconda activate bigeye_env\n```\n\n#### Linux\nMost linux distributes include a default python distribution and we recommend using that default.\n\n### Installing bigeye\nYou can install the Bigeye CLI from your command line with the following command:\n```shell\npip3 install bigeye-cli\n```\n## Credential\nRun the following command to get logged into your Bigeye workspace from the CLI:\n\n```console\nbigeye credential\n```\n\nThere are two ways to authenticate: basic authentication and browser authentication.\n\n### Basic Authentication\nIf you select basic authentication, the CLI will prompt you to enter your Bigeye username and password. This will\ncreate a default credential file at ~/.bigeye/default_cred.json. This credential will be used for all CLI commands\ncalls unless an environment variable is explicitly provided.\n\n```yaml\nbase_url: "https://app.bigeye.com",\nuser: "some_user+some_company@bigeye.com",\npassword: "fakepassword1234"\n```\n\nYou can create an environment variable for your workspace credential file, this is helpful if you are managing\nmultiple workspaces and need to flip between them. Add the following to your ~/.bashrc or ~/.zshrc file:\n\n```shell\nexport BIGEYE_API_CRED_FILE=/some/path/to/bigeye_cred_file.json\n```\n\nLastly, if you want to specify the credential per command, you can always pass a -b parameter with the file path for\nthe desired credential.\n\n### Browser Authentication\nAlternatively, you can use browser authentication. Login to your bigeye workspace on a Chrome, Chromium or\nFirefox browser. Run **bigeye credential** and select browser_auth when prompted in the CLI and follow the\ninstructions. If you use Chrome profiles, make sure to specify the profile email address you are logged into.\n\nNote: your authentication will only be valid so long as your browser session is active.\n\n## Basic Usage\n```console\n$ bigeye --help\n```\n## Tab/Auto Completion\nBigeye supports tab/auto completion for many different shells.  For example, run:\n```console\n$ bigeye --install-completion zsh\n```\n### ZSH Completion\nVerify that the following has been added to your shell rc file:\n```shell\nautoload -Uz compinit\nzstyle :completion:* menu select\nfpath+=~/.zfunc\n```\nIf you are having trouble with auto complete then add the following below the 3 lines above.\n```shell\ncompinit\n```\n# CLI Documentation\n\n# `bigeye workspace`\n\nWorkspace Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye workspace [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `create-named-schedule`: Create a named, cron based schedule\n* `delete-named-schedule`: Delete a named schedule.\n* `delete-user`: Remove user from workspace.\n* `edit-user-role`: Change user role.\n* `invite-user`: Invite a user.\n* `schedule-all-metrics`: Schedule all metrics in a workspace.\n* `unschedule-all-metrics`: Unschedule all metrics in a workspace.\n\n## `bigeye workspace create-named-schedule`\n\nCreate a named, cron based schedule\n\n**Usage**:\n\n```console\n$ bigeye workspace create-named-schedule [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-sn, --name TEXT`: The user defined name of the schedule  [required]\n* `-c, --cron TEXT`: The cron string to define the schedule  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace delete-named-schedule`\n\nDelete a named schedule.\n\n**Usage**:\n\n```console\n$ bigeye workspace delete-named-schedule [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-sn, --name TEXT`: The user defined name of the schedule  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace delete-user`\n\nRemove user from workspace. Only supports basic auth conf\n\n**Usage**:\n\n```console\n$ bigeye workspace delete-user [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration. (browser auth not supported)  [required]\n* `-un, --user_name TEXT`: User name.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace edit-user-role`\n\nChange user role. Only supports basic auth conf\n\n**Usage**:\n\n```console\n$ bigeye workspace edit-user-role [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration. (browser auth not supported)  [required]\n* `-un, --user_name TEXT`: User name.  [required]\n* `-role, --user_role TEXT`: The role to assign the user, i.e. OWNER, ADMIN, USER.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace invite-user`\n\nInvite a user. Only supports basic auth conf\n\n**Usage**:\n\n```console\n$ bigeye workspace invite-user [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration. (browser auth not supported)  [required]\n* `-un, --user_name TEXT`: User name.  [required]\n* `-email, --user_email TEXT`: Email where invite will be sent.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace schedule-all-metrics`\n\nSchedule all metrics in a workspace.\n\n**Usage**:\n\n```console\n$ bigeye workspace schedule-all-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-type, --time_interval_type INTEGER`: Time interval type.\n UNDEFINED_TIME_INTERVAL_TYPE:0\nHOURS_TIME_INTERVAL_TYPE:1\nMINUTES_TIME_INTERVAL_TYPE:2\nSECONDS_TIME_INTERVAL_TYPE:3\nDAYS_TIME_INTERVAL_TYPE:4\nWEEKDAYS_TIME_INTERVAL_TYPE:5\nMARKET_DAYS_TIME_INTERVAL_TYPE:6  [default: 1]\n* `-value, --interval_value INTEGER`: Number of intervals to set on all metric schedules.  If 0 use unschedule all metrics.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye workspace unschedule-all-metrics`\n\nUnschedule all metrics in a workspace.\n\n**Usage**:\n\n```console\n$ bigeye workspace unschedule-all-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `--help`: Show this message and exit.\n\n# `bigeye bigconfig`\n\nBigconfig Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye bigconfig [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `apply`: Applies a purge of deployed metrics or...\n* `plan`: Executes a plan for purging sources or...\n\n## `bigeye bigconfig apply`\n\nApplies a purge of deployed metrics or applies Bigconfig files from the input path/current working directory to\nthe Bigeye workspace.\n\n**Usage**:\n\n```console\n$ bigeye bigconfig apply [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Auth Configuration\n* `-ip, --input_path TEXT`: List of paths containing Bigconfig files or pointing to a Bigconfig file. E.g. -ip path1 -ip path2. If no input path is defined then current working directory will be used.\n* `-op, --output_path TEXT`: Output path where reports and fixme files will be saved. If no output path is defined then current working directory will be used.\n* `-psn, --purge_source_name TEXT`: List of source names to purge  E.g. -psn source_1 -psn source_2.\n* `-purge_all, --purge_all_sources`: Purge all sources: True or False.\n* `-nq, --no_queue`: Don\'t submit to queue: True or False.\n* `-r, --recursive`: Search all input directories recursively.\n* `--help`: Show this message and exit.\n\n## `bigeye bigconfig plan`\n\nExecutes a plan for purging sources or processing bigconfig files in the input path/current\nworking directory.\n\n**Usage**:\n\n```console\n$ bigeye bigconfig plan [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Auth Configuration\n* `-ip, --input_path TEXT`: List of paths containing Bigconfig files or pointing to a Bigconfig file. E.g. -ip path1 -ip path2. If no input path is defined then current working directory will be used.\n* `-op, --output_path TEXT`: Output path where reports and fixme files will be saved. If no output path is defined then current working directory will be used.\n* `-psn, --purge_source_name TEXT`: List of source names to purge  E.g. -psn source_1 -psn source_2.\n* `-purge_all, --purge_all_sources`: Purge all sources: True or False.\n* `-r, --recursive`: Search all input directories recursively.\n* `--help`: Show this message and exit.\n\n# `bigeye catalog`\n\nCatalog Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye catalog [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `add-source`: Adds a source to specified Bigeye workspace.\n* `backfill-autothresholds`: Backfills autothresholds by warehouse id,...\n* `backfill-metrics`: Backfills metrics by warehouse id, schema...\n* `delete-metrics`: Delete metrics in a warehouse id, by...\n* `delete-source`: Delete a source from specified Bigeye...\n* `delete-template`: Delete a template.\n* `delete-virtual-table`: Delete a virtual table.\n* `deploy-all-autometrics`: Deploys all Autometrics to specified...\n* `get-all-metric-templates`: Retrieve all metric templates and output...\n* `get-metric-info`: Outputs metric info to a file.\n* `get-metric-queries`: Gets the debug queries for all metrics by...\n* `get-table-info`: Outputs table info to a file for an entire...\n* `rebuild`: Rebuilds/Reprofiles a source by warehouse...\n* `regen-autometrics`: Regenerates Autometrics by warehouse id OR...\n* `run-metrics`: Runs metrics by warehouse id, schema...\n* `schedule-all-metrics`: Updates schedule for all metrics in a...\n* `set-metric-time`: Sets metric times from a list of possible...\n* `unschedule-all-metrics`: Unschedule all metrics by warehouse,...\n* `unset-metric-time`: Unsets metric times for whole warehouse or...\n* `upsert-template`: Create or update a template for a source.\n* `upsert-virtual-table`: Create or update a virtual table.\n\n## `bigeye catalog add-source`\n\nAdds a source to specified Bigeye workspace.  Supports either source configs stored in AWS Secrets manager OR\nlocally in file.\n\n**Usage**:\n\n```console\n$ bigeye catalog add-source [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-sn, --secret_name TEXT`: The name of the secret to retrieve from AWS Secrets Manager\n* `-srn, --secret_region_name TEXT`: AWS Secret Manager Region Name  [default: us-west-2]\n* `-sccf, --source_catalog_config_file TEXT`: The file containing the necessary parameters for adding a source to Bigeye.\n* `--help`: Show this message and exit.\n\n## `bigeye catalog backfill-autothresholds`\n\nBackfills autothresholds by warehouse id, schema names, and/or table ids.\n\n**Usage**:\n\n```console\n$ bigeye catalog backfill-autothresholds [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `--help`: Show this message and exit.\n\n## `bigeye catalog backfill-metrics`\n\nBackfills metrics by warehouse id, schema names, and/or table ids.\n\n**Usage**:\n\n```console\n$ bigeye catalog backfill-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `--delete_history`: Delete metric run history\n* `--help`: Show this message and exit.\n\n## `bigeye catalog delete-metrics`\n\nDelete metrics in a warehouse id, by schema names, or by table_ids.  Also, can filter by multipe\nmetric types.\n\n**Usage**:\n\n```console\n$ bigeye catalog delete-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `-m, --metric_type TEXT`: Delete by name of the metric type.UNDEFINED_PREDEFINED_METRIC_NAME, PERCENT_NULL, COUNT_NULL, PERCENT_EMPTY_STRING, COUNT_EMPTY_STRING, PERCENT_UNIQUE, PERCENT_VALUE_IN_LIST, AVERAGE, MIN, MAX, SUM, COUNT_ROWS, COUNT_DISTINCT, HOURS_SINCE_MAX_DATE, HOURS_SINCE_MAX_TIMESTAMP, COUNT_TRUE, PERCENT_TRUE, COUNT_FALSE, PERCENT_FALSE, COUNT_USA_PHONE, PERCENT_USA_PHONE, COUNT_USA_ZIP_CODE, PERCENT_USA_ZIP_CODE, PERCENT_UUID, COUNT_TIMESTAMP_STRING, PERCENT_TIMESTAMP_STRING, COUNT_DUPLICATES, COUNT_USA_STATE_CODE, PERCENT_USA_STATE_CODE, VARIANCE, SKEW, KURTOSIS, GEOMETRIC_MEAN, HARMONIC_MEAN, COUNT_UUID, COUNT_CUSIP, PERCENT_CUSIP, COUNT_SEDOL, PERCENT_SEDOL, COUNT_ISIN, PERCENT_ISIN, COUNT_LEI, PERCENT_LEI, COUNT_FIGI, PERCENT_FIGI, COUNT_PERM_ID, PERCENT_PERM_ID, COUNT_NAN, PERCENT_NAN, COUNT_LONGITUDE, PERCENT_LONGITUDE, COUNT_LATITUDE, PERCENT_LATITUDE, COUNT_NOT_IN_FUTURE, PERCENT_NOT_IN_FUTURE, COUNT_DATE_NOT_IN_FUTURE, PERCENT_DATE_NOT_IN_FUTURE, MEDIAN, PERCENTILE, COUNT_NOT_NULL, STRING_LENGTH_AVERAGE, STRING_LENGTH_MIN, STRING_LENGTH_MAX, COUNT_SSN, PERCENT_SSN, COUNT_EMAIL, PERCENT_EMAIL, ROWS_INSERTED, HOURS_SINCE_LAST_LOAD, COUNT_READ_QUERIES, PERCENT_NOT_NULL, FRESHNESS, VOLUME\n* `--help`: Show this message and exit.\n\n## `bigeye catalog delete-source`\n\nDelete a source from specified Bigeye workspace.\n\n**Usage**:\n\n```console\n$ bigeye catalog delete-source [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: The ID of the warehouse to delete.\n* `--help`: Show this message and exit.\n\n## `bigeye catalog delete-template`\n\nDelete a template.\n\n**Usage**:\n\n```console\n$ bigeye catalog delete-template [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-tid, --template_id INTEGER`: The ID of the metric template  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog delete-virtual-table`\n\nDelete a virtual table.\n\n**Usage**:\n\n```console\n$ bigeye catalog delete-virtual-table [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-vtn, --table_name TEXT`: The name of the virtual table  [required]\n* `-sn, --source_name TEXT`: The name of the source where the template will be defined  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog deploy-all-autometrics`\n\nDeploys all Autometrics to specified warehouse OR warehouse and list of schema names OR warehouse and list of\ntable ids.\n\n**Usage**:\n\n```console\n$ bigeye catalog deploy-all-autometrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Deploy autometrics to all tables in warehouse.\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `-lbd, --lookback_days INTEGER`: Look back days for the metrics.  [default: 7]\n* `--ops_only`: Deploy only operational metrics  [default: True]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog get-all-metric-templates`\n\nRetrieve all metric templates and output to a file.\n\n**Usage**:\n\n```console\n$ bigeye catalog get-all-metric-templates [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-ps, --page_size INTEGER`: How many results to return per page  [default: 0]\n* `-s, --search TEXT`: A search string to narrow results\n* `-op, --output_path TEXT`: The path to output templates\n* `-fn, --file_name TEXT`: User defined file name\n* `--help`: Show this message and exit.\n\n## `bigeye catalog get-metric-info`\n\nOutputs metric info to a file.  Includes metric configuration and details about recent runs.\n\n**Usage**:\n\n```console\n$ bigeye catalog get-metric-info [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs. E.g. -tid 123 -tid 124or schema names.\n* `-ms, --metric_status [HEALTHY|ALERTING|UNKNOWN]`: Used to query metric of particular status.\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--conf_only`: Output only the metric configuration.\n* `--help`: Show this message and exit.\n\n## `bigeye catalog get-metric-queries`\n\nGets the debug queries for all metrics by warehouse id, schema names, or table ids.\n\n**Usage**:\n\n```console\n$ bigeye catalog get-metric-queries [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog get-table-info`\n\nOutputs table info to a file for an entire warehouse, certain schemas, or certain tables.\n\n**Usage**:\n\n```console\n$ bigeye catalog get-table-info [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs. E.g. -tid 123 -tid 124\n* `-tn, --table_name TEXT`: Table Namess. E.g. -tn some_table -tn some_other_table\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog rebuild`\n\nRebuilds/Reprofiles a source by warehouse id or a schema by warehouse id and schema name.\n\n**Usage**:\n\n```console\n$ bigeye catalog rebuild [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID  [required]\n* `-sn, --schema_name TEXT`: Schema Name\n* `--help`: Show this message and exit.\n\n## `bigeye catalog regen-autometrics`\n\nRegenerates Autometrics by warehouse id OR warehouse id and list of schema names OR list of table ids.\n\n**Usage**:\n\n```console\n$ bigeye catalog regen-autometrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID.  If none will look for Table IDs.  If value then will pull all table ids for warehouse\n* `-sn, --schema_name TEXT`: List of Schema Names  E.g. -sn schema_1 -sn schema_2.  Do not include warehouse name -- GREENE_HOMES_DEMO_STANDARD.CONFORMED is fully qualified and CONFORMED is the schema name.\n* `-tid, --table_id INTEGER`: List of Table IDs.  E.g. -tid 123 -tid 124\n* `--help`: Show this message and exit.\n\n## `bigeye catalog run-metrics`\n\nRuns metrics by warehouse id, schema names, and/or table ids\n\n**Usage**:\n\n```console\n$ bigeye catalog run-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `--help`: Show this message and exit.\n\n## `bigeye catalog schedule-all-metrics`\n\nUpdates schedule for all metrics in a warehouse.\n\n**Usage**:\n\n```console\n$ bigeye catalog schedule-all-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-type, --time_interval_type INTEGER`: Time interval type.\n UNDEFINED_TIME_INTERVAL_TYPE:0\nHOURS_TIME_INTERVAL_TYPE:1\nMINUTES_TIME_INTERVAL_TYPE:2\nSECONDS_TIME_INTERVAL_TYPE:3\nDAYS_TIME_INTERVAL_TYPE:4\nWEEKDAYS_TIME_INTERVAL_TYPE:5\nMARKET_DAYS_TIME_INTERVAL_TYPE:6  [default: 1]\n* `-value, --interval_value INTEGER`: Number of intervals to set on all metric schedules.  If 0 use unschedule all metrics.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog set-metric-time`\n\nSets metric times from a list of possible metric column names.  Can set for whole warehouse or for a list of\ntable IDs.\n\n**Usage**:\n\n```console\n$ bigeye catalog set-metric-time [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sid, --schema_id INTEGER`: Schema ID\n* `-tid, --table_id INTEGER`: List of table IDs.\n* `-cn, --metric_column_name TEXT`: Possible metric column names.  [required]\n* `-r, --replace`: replace metric times if already present on tables?  Default is false.\n* `--help`: Show this message and exit.\n\n## `bigeye catalog unschedule-all-metrics`\n\nUnschedule all metrics by warehouse, schema or tables.\n\n**Usage**:\n\n```console\n$ bigeye catalog unschedule-all-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-sn, --schema_name TEXT`: List of Schema Name.  E.g. -sn schema_1.\n* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124\n* `--help`: Show this message and exit.\n\n## `bigeye catalog unset-metric-time`\n\nUnsets metric times for whole warehouse or for a list og table IDs.\n\n**Usage**:\n\n```console\n$ bigeye catalog unset-metric-time [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-wid, --warehouse_id INTEGER`: Warehouse ID\n* `-tid, --table_id INTEGER`: List of table IDs.\n* `--help`: Show this message and exit.\n\n## `bigeye catalog upsert-template`\n\nCreate or update a template for a source.\n\n**Usage**:\n\n```console\n$ bigeye catalog upsert-template [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-sn, --source_name TEXT`: The name of the source where the template will be defined  [required]\n* `-tn, --name TEXT`: The user defined name of the template  [required]\n* `-tb, --body TEXT`: The string to define the template  [required]\n* `-rt, --returns [BOOLEAN|NUMERIC]`: The data type returned by the template; i.e. NUMERIC, BOOLEAN  [required]\n* `-p, --params TEXT`: A list of key/value pairs for parameters; ex. -p column=COLUMN_REFERENCE -p table=STRING  [required]\n* `-id, --template_id INTEGER`: The template ID (Only required when updating a template).  [default: 0]\n* `--help`: Show this message and exit.\n\n## `bigeye catalog upsert-virtual-table`\n\nCreate or update a virtual table.\n\n**Usage**:\n\n```console\n$ bigeye catalog upsert-virtual-table [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-vtn, --table_name TEXT`: The name of the virtual table  [required]\n* `-s, --sql TEXT`: The SQL to define the table  [required]\n* `-sn, --source_name TEXT`: The name of the source where the virtual table will be defined  [required]\n* `-u, --update`: Create if false. Update if true.\n* `--help`: Show this message and exit.\n\n# `bigeye metric`\n\nMetric Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye metric [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get-info`: Outputs metric info to a file.\n* `get-metric-queries`: Gets the debug queries for all metrics by...\n* `run`: Run metric by id(s)\n* `upsert`: Upsert single metric from file.\n* `upsert-from-path`: Upsert multiple metrics from files stored...\n\n## `bigeye metric get-info`\n\nOutputs metric info to a file.  Includes metric configuration and details about recent runs.\n\n**Usage**:\n\n```console\n$ bigeye metric get-info [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-mid, --metric_id INTEGER`: Metric Ids.  [required]\n* `-ms, --metric_status [HEALTHY|ALERTING|UNKNOWN]`: Used to query metric of particular status.\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--conf_only`: Output only the metric configuration.\n* `--help`: Show this message and exit.\n\n## `bigeye metric get-metric-queries`\n\nGets the debug queries for all metrics by warehouse id, schema names, or table ids.\n\n**Usage**:\n\n```console\n$ bigeye metric get-metric-queries [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-mid, --metric_id INTEGER`: Metric Ids.  [required]\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye metric run`\n\nRun metric by id(s)\n\n**Usage**:\n\n```console\n$ bigeye metric run [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-mid, --metric_id INTEGER`: Metric Ids.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye metric upsert`\n\nUpsert single metric from file.\n\n**Usage**:\n\n```console\n$ bigeye metric upsert [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-f, --file TEXT`: File containing SimpleUpsedrtMetricRequest or MetricConfiguration  [required]\n* `-t, --file_type [SIMPLE|FULL]`: Metric File Type.  Simple conforms to SimpleUpsertMetricRequest and Full conforms to MetricConfiguration  [required]\n* `-wid, --warehouse_id INTEGER`: (Optional) Warehouse ID.  If specified it will reduce the text based search for the table.warehouse\n* `-mid, --metric_id INTEGER`: (Optional) Metric Id.  If specified it will reduce the text based search for existing metric.\n* `--help`: Show this message and exit.\n\n## `bigeye metric upsert-from-path`\n\nUpsert multiple metrics from files stored in path.\n\n**Usage**:\n\n```console\n$ bigeye metric upsert-from-path [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-twid, --target_warehouse_id INTEGER`: Deploy Metrics to target Warehouse ID.  [required]\n* `-sp, --source_path TEXT`: Source path file containing the metrics to migrate.  [required]\n* `--help`: Show this message and exit.\n\n# `bigeye issues`\n\nIssues Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye issues [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `get-issues`: Gets issues and writes info to files.\n* `update-issue`: Updates an issue in Bigeye and returns the...\n\n## `bigeye issues get-issues`\n\nGets issues and writes info to files.\n\n**Usage**:\n\n```console\n$ bigeye issues get-issues [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-wid, --warehouse_id INTEGER`: Warehouse IDs.\n* `-sn, --schema_name TEXT`: Schema names\n* `-mid, --metric_id INTEGER`: Metric IDs.\n* `-cid, --collection_id INTEGER`: Collection IDs\n* `-iid, --issue_id INTEGER`: Issue IDs\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye issues update-issue`\n\nUpdates an issue in Bigeye and returns the Issue object from the protobuff.\n\n**Usage**:\n\n```console\n$ bigeye issues update-issue [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-iid, --issue_id INTEGER`: Issue ID  [required]\n* `-status, --issue_status TEXT`: The status update. Options are ACKNOWLEDGED or CLOSED.\n* `-by, --updated_by TEXT`: The user providing the update.\n* `-m, --message TEXT`: The message to attach to the issue.\n* `-cl, --closing_label TEXT`: Used to train Bigeye when closing an issue. Options are TRUE_POSITIVE, FALSE_POSITIVE, EXPECTED.\n* `--help`: Show this message and exit.\n\n# `bigeye deltas`\n\nDeltas Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye deltas [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `cicd`: Creates a delta based on...\n* `create-delta`: Creates deltas between tables from a...\n* `run-delta`: Runs a delta by Delta ID.\n* `suggest-deltas`: Suggests and creates Deltas with default...\n\n## `bigeye deltas cicd`\n\nCreates a delta based on SimpleDeltaConfiguration and integrates the results with the provided VCS vendor.\n\n**Usage**:\n\n```console\n$ bigeye deltas cicd [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration as a base64 encoded string  [required]\n* `-dcc, --delta_cicd_config TEXT`: The yaml file containing the parameters for the DeltaCICDConfig class  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye deltas create-delta`\n\nCreates deltas between tables from a Simple Delta configuration file that contains multiple delta configurations.\nEnforces 1:1 column comparisons by case-insensitive column names if no column mappings are declared in\nconfiguration.\n\n**Usage**:\n\n```console\n$ bigeye deltas create-delta [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-dc, --delta_conf TEXT`: Simple Delta configuration file.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye deltas run-delta`\n\nRuns a delta by Delta ID.\n\n**Usage**:\n\n```console\n$ bigeye deltas run-delta [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-did, --delta_id INTEGER`: Id of delta.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye deltas suggest-deltas`\n\nSuggests and creates Deltas with default behavior and outputs all Simple Delta Configurations to a file.\n\n**Usage**:\n\n```console\n$ bigeye deltas suggest-deltas [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-swid, --source_warehouse_id INTEGER`: Source Warehouse ID\n* `-twid, --target_warehouse_id INTEGER`: Source Warehouse ID\n* `-swn, --source_warehouse_name TEXT`: Source Warehouse Name\n* `-twn, --target_warehouse_name TEXT`: Source Warehouse Name\n* `-snp, --schema_name_pair TEXT`: Fully qualified schema name pairs.  e.g. -snp source_schema_1:target_schema_1 -snp source_warehouse.source_schema:target_warehouse.target_schema\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n# `(Deprecated) bigeye sla`\n\nSLA Commands for Bigeye CLI (use collections command instead)\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `add-metric`: Add metric to an SLA.\n* `backfill-metrics`: Backfill all metrics in an SLA.\n* `get-metric-info`: Get metric info for all metrics in SLA.\n* `get-metric-queries`: Gets the debug queries for all metrics by...\n* `migrate-from-json`: Loads metrics from SLA oriented metric...\n* `run-metrics`: Run all metrics in an SLA.\n\n## `(Deprecated) bigeye sla add-metric`\n\nAdd metric to an SLA.\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla add-metric [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-mid, --metric_id INTEGER`: Metric ID  [required]\n* `-sid, --sla_id INTEGER`: SLA ID  [required]\n* `--help`: Show this message and exit.\n\n## `(Deprecated) bigeye sla backfill-metrics`\n\nBackfill all metrics in an SLA.\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla backfill-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `--from_slas`: Scrapes all SLAs in customer workspace for Metric Info.\n* `--sla_ids INTEGER`: SLA IDs.  Scrape certain SLAs for Metric Info.\n* `--delete_history`: Delete metric run history\n* `--help`: Show this message and exit.\n\n## `(Deprecated) bigeye sla get-metric-info`\n\nGet metric info for all metrics in SLA.\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla get-metric-info [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `--from_slas`: Scrapes all SLAs in customer workspace for Metric Info.\n* `--sla_ids INTEGER`: SLA IDs.  Scrape certain SLAs for Metric Info.\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `(Deprecated) bigeye sla get-metric-queries`\n\nGets the debug queries for all metrics by warehouse id, schema names, or table ids.\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla get-metric-queries [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-sid, --sla_id INTEGER`: SLA ID  [required]\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `(Deprecated) bigeye sla migrate-from-json`\n\nLoads metrics from SLA oriented metric info output.  Used to migrate metrics from one warehouse to\nanother, identical, warehouse\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla migrate-from-json [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-twid, --target_warehouse_id INTEGER`: Deploy Metrics to target Warehouse ID.  [required]\n* `-ip, --input_path TEXT`: Path to read from.  [required]\n* `-kn, --keep_notifications`: Keep Notifications from versioned or templated metric configuration.\n* `-kid, --keep_ids`: Keep Metric and SLA IDs from versioned or templated metric configuration.  If kept this would update existing metrics and slas.  If not kept it would create new.\n* `--help`: Show this message and exit.\n\n## `(Deprecated) bigeye sla run-metrics`\n\nRun all metrics in an SLA.\n\n**Usage**:\n\n```console\n$ (Deprecated) bigeye sla run-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-sid, --sla_id INTEGER`: SLA ID  [required]\n* `--help`: Show this message and exit.\n\n# `bigeye collections`\n\nCollections Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye collections [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `add-metric`: Add metric to a Collection.\n* `backfill-metrics`: Backfill all metrics in a Collection.\n* `get-metric-info`: Get metric info for all metrics in...\n* `get-metric-queries`: Gets the debug queries for all metrics by...\n* `migrate-from-json`: Loads metrics from Collection oriented...\n* `run-metrics`: Run all metrics in a Collection.\n\n## `bigeye collections add-metric`\n\nAdd metric to a Collection.\n\n**Usage**:\n\n```console\n$ bigeye collections add-metric [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-mid, --metric_id INTEGER`: Metric ID  [required]\n* `-cid, --collection_id INTEGER`: Collection ID  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye collections backfill-metrics`\n\nBackfill all metrics in a Collection.\n\n**Usage**:\n\n```console\n$ bigeye collections backfill-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `--from_collections`: Scrapes all Collections in customer workspace for Metric Info.\n* `--collection_ids INTEGER`: Collection IDs.  Scrape certain Collections for Metric Info.\n* `--delete_history`: Delete metric run history\n* `--help`: Show this message and exit.\n\n## `bigeye collections get-metric-info`\n\nGet metric info for all metrics in Collection.\n\n**Usage**:\n\n```console\n$ bigeye collections get-metric-info [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `--from_collections`: Scrapes all Collections in customer workspace for Metric Info.\n* `--collection_ids INTEGER`: Collection IDs.  Scrape certain Collections for Metric Info.\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye collections get-metric-queries`\n\nGets the debug queries for all metrics by warehouse id, schema names, or table ids.\n\n**Usage**:\n\n```console\n$ bigeye collections get-metric-queries [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-cid, --collection_id INTEGER`: Collection ID  [required]\n* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye collections migrate-from-json`\n\nLoads metrics from Collection oriented metric info output.  Used to migrate metrics from one warehouse to\nanother, identical, warehouse\n\n**Usage**:\n\n```console\n$ bigeye collections migrate-from-json [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-twid, --target_warehouse_id INTEGER`: Deploy Metrics to target Warehouse ID.  [required]\n* `-ip, --input_path TEXT`: Path to read from.  [required]\n* `-kn, --keep_notifications`: Keep Notifications from versioned or templated metric configuration.\n* `-kid, --keep_ids`: Keep Metric and Collection IDs from versioned or templated metric configuration.  If kept this would update existing metrics and collections.  If not kept it would create new.\n* `--help`: Show this message and exit.\n\n## `bigeye collections run-metrics`\n\nRun all metrics in a Collection.\n\n**Usage**:\n\n```console\n$ bigeye collections run-metrics [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration File\n* `-cid, --collection_id INTEGER`: Collection ID  [required]\n* `--help`: Show this message and exit.\n\n# `bigeye lineage`\n\nLineage Commands for Bigeye CLI\n\n**Usage**:\n\n```console\n$ bigeye lineage [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `create-node`: Create a lineage node for an entity\n* `create-relation`: Create a lineage relationship for 2 entities\n* `delete-node`: Delete a lineage node for an entity\n* `delete-relation`: Deletes a single relationship based on...\n\n## `bigeye lineage create-node`\n\nCreate a lineage node for an entity\n\n**Usage**:\n\n```console\n$ bigeye lineage create-node [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook  [required]\n* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)\n* `--help`: Show this message and exit.\n\n## `bigeye lineage create-relation`\n\nCreate a lineage relationship for 2 entities\n\n**Usage**:\n\n```console\n$ bigeye lineage create-relation [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-up, --upstream TEXT`: The fully qualified table name  [required]\n* `-down, --downstream TEXT`: The fully qualified table name  [required]\n* `--help`: Show this message and exit.\n\n## `bigeye lineage delete-node`\n\nDelete a lineage node for an entity\n\n**Usage**:\n\n```console\n$ bigeye lineage delete-node [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook  [required]\n* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)\n* `--help`: Show this message and exit.\n\n## `bigeye lineage delete-relation`\n\nDeletes a single relationship based on relation ID or all relationships for a node by name.\n\n**Usage**:\n\n```console\n$ bigeye lineage delete-relation [OPTIONS]\n```\n\n**Options**:\n\n* `-b, --bigeye_conf TEXT`: Bigeye Basic Auth Configuration\n* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook\n* `-rid, --relation_id INTEGER`: The relationship ID to delete  [default: 0]\n* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)\n* `--help`: Show this message and exit.\n\n',
    'author': 'Bigeye',
    'author_email': 'support@bigeye.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://docs.bigeye.com/docs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.2,<4.0.0',
}


setup(**setup_kwargs)
