class _Constant():

    PROTOCOL_VERSION = 65

    # Message function code
    MESSAGE_CONNECT = b'Y0'
    MESSAGE_DISCONNECT = b'Y4'
    MESSAGE_SHUTDOWN = b'Y6'
    MESSAGE_PING = b'YQ'
    MESSAGE_BENCHMARK_ECHO = b'YY'
    MESSAGE_LOAD_MODULES = b'YP'
    MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR = b'YA'
    MESSAGE_DYNAMIC_EXECUTE_METHOD = b'YU'
    MESSAGE_DYNAMIC_EXECUTE_GET = b'YV'
    MESSAGE_DYNAMIC_EXECUTE_SET = b'YB'
    MESSAGE_CREATE_OBJECT = b'Y9'
    MESSAGE_EXCEPTION_RAISED = b'Y5'
    MESSAGE_GET_LIST = b'YG'
    MESSAGE_GET_STREAM = b'YH'

    @staticmethod
    def __convert(code):
        return code[0]*256+code[1]-22832

    ENUM_MESSAGE_PASSPHRASE = -48
    ENUM_MESSAGE_CONNECT = __convert.__func__(MESSAGE_CONNECT)
    ENUM_MESSAGE_DISCONNECT = __convert.__func__(MESSAGE_DISCONNECT)
    ENUM_MESSAGE_SHUTDOWN = __convert.__func__(MESSAGE_SHUTDOWN)
    ENUM_MESSAGE_PING = __convert.__func__(MESSAGE_PING)
    ENUM_MESSAGE_BENCHMARK_ECHO = __convert.__func__(MESSAGE_BENCHMARK_ECHO)
    ENUM_MESSAGE_LOAD_MODULES = __convert.__func__(MESSAGE_LOAD_MODULES)
    ENUM_MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR = __convert.__func__(MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR)
    ENUM_MESSAGE_DYNAMIC_EXECUTE_METHOD = __convert.__func__(MESSAGE_DYNAMIC_EXECUTE_METHOD)
    ENUM_MESSAGE_DYNAMIC_EXECUTE_GET = __convert.__func__(MESSAGE_DYNAMIC_EXECUTE_GET)
    ENUM_MESSAGE_DYNAMIC_EXECUTE_SET = __convert.__func__(MESSAGE_DYNAMIC_EXECUTE_SET)

    # IRISNative messages
    