[![Documentation Status](https://readthedocs.org/projects/pyfas/badge/?version=latest)](http://pyfas.readthedocs.io/en/latest/?badge=latest)
[![Binder](http://mybinder.org/badge.svg)](http://mybinder.org:/repo/gpagliuca/pyfas)

# Pyfas

Pyfas is a python toolbox for flow assurance engineers.

### Wrappers
At this moment in time the toolbox contains wrappers for:

* OLGA 
* Unisim Design
* GAP 
* Pipesim (via OpenLink, for all the versions <= 2012.4)

**Olga** is the standard de facto for the dynamic simulations of multiphase
systems (single pipelines or complex network) in the oil and gas indistry. The
simulator has text input and output files; with pyfas you can expose Olga
results to python (both trends and profiles) or dump all the results to excel/csv
for your post-precessing.

**UnisimDesign** is mainly a process simulator but can be used also to simulate
pipelines or networks in particular providing some external components.
Differently from Olga Unisim (unfortunately) does not use text input or
output files, the only way to communicate with the software is via a COM interface
using pywin32.  Pyfas does not pretend to exposes all the possible
functionalities of Unisim, only a very limited subset is available at the
moment.

**PipeSim** is a steady state simulator for both single branches or networks

### Utilities

* Tab files processing
* Surge volume calculation
* PIRead functionality

**Tab files** are look-up tables with specific thermodynamic properties at
given pressure and temperature intervals used for flash calculations by dynamic
simulators. These files are generated by thermodynamic simulators (like
PTVTsim) and it is good practice to have a look on this information *before*
a dynamic simulation. With pyfas it is possible to generate 3d plots of all the
properties and examine more in detail critical ones. 

The **surge volume calculation** utility returns the surge volume given a drain
rate and a liquid flowrate time series. Not more than a simple discrete
integration.

With **PIRead** it is possible to retrieve PI values from a PI server.

A live demo should be available here below (no installation required)

[![Binder](http://mybinder.org/badge.svg)](http://mybinder.org:/repo/gpagliuca/pyfas)

# Installation 
`pip install pyfas`

# Examples and documentation

[![Documentation Status](https://readthedocs.org/projects/pyfas/badge/?version=latest)](http://pyfas.readthedocs.io/en/latest/?badge=latest)
