# [mssdk](https://pypi.org/project/mssdk/)

## [mssdk](https://pypi.org/project/mssdk/) 的介绍

[mssdk](https://pypi.org/project/mssdk/) 是 **麦思多维科技** 提供的基于 Python 的 SDK 库, 您可以通过 [麦思多维科技机构VIP接口文档](https://mssdk.readthedocs.io/en/latest/) 了解和查询详细数据接口！

## [mssdk](https://pypi.org/project/mssdk/) 服务于 **麦思多维科技**

## [mssdk](https://pypi.org/project/mssdk/) 的特色

[mssdk](https://pypi.org/project/mssdk/) 主要改进如下:

1. [mssdk](https://pypi.org/project/mssdk/)支持 **Python 3.7** 及以上版本;
2. 目前提供已提供**麦思多维科技**部分数据接口;
3. 提供完善的接口文档支持, 提高 [mssdk](https://pypi.org/project/mssdk/) 的易用性;

# 安装方法

```
pip install mssdk
```

# 升级方法

```
pip install mssdk --upgrade
```

# 快速入门

目标数据: 麦思多维科技-商品-持仓数据接口

示例代码:

```python
import mssdk as ms
pro = ms.pro_api(token="此处输入您的token, 请联系麦思多维科技获取！")
variety_positions_df = pro.variety_positions(fields="shorts", code="rb1810", date="2018-08-08")
print(variety_positions_df)
```

示例结果:

```
   broker  short  short_chge
0    银河期货  60987       -4228
1    永安期货  57520       -1071
2    中信期货  38120        -620
3    国泰君安  36498         528
4    方正中期  32105        4444
5    海通期货  29638       -2783
6    东海期货  29250         450
7    光大期货  28458         -84
8    南华期货  27853        -144
9    中辉期货  26101        -553
10   中大期货  23761        1572
11   鲁证期货  22501        -598
12   兴证期货  22262        -842
13   东证期货  21675        -686
14   徽商期货  18966        -607
15   中信建投  18583        -625
16   华泰期货  17076       -5797
17   国投安信  16808         349
18   申银万国  14876         376
19   广发期货  14588       -2196
20   大地期货      0      -14603
```

# 特别说明

## 声明

1. [mssdk](https://pypi.org/project/mssdk) 提供的数据仅供参考, 不构成任何投资建议;
2. 任何基于 [mssdk](https://pypi.org/project/mssdk) 进行研究的投资者请注意数据风险;
3. [mssdk](https://pypi.org/project/mssdk) 的使用请遵循麦思多维科技网站的用户协议;
4. [mssdk](https://pypi.org/project/mssdk) 使用产生的所有问题的最终解释权归麦思多维科技网站所有;

# 版本更新说明

```
0.0.1: 发布测试版本 v0.0.1
0.0.2: 发布测试版本 v0.0.2
```
