"""
Constants for platonic ham.
"""
from random import randint


"""
Mapping of colors (UPPERCASE) and styles (lowercase) to rgb values.
"""
colors = {
    'inactive': (20, 20, 20),
    'active_0': (128, 255, 191),
    'active_1': (102, 255, 51),
    'active_2': (255, 153, 255),
    'active_3': (255, 153, 102),
    'active_4': (0, 0, 190),
    'active_5': (163, 163, 194),
    'active_6': (230, 153, 0),
    'blink': (255, 255, 0),
    'dashed': (0, 255, 0),
    'head': (0, 255, 155),
    'head_other': (60, 150, 155),
    'losing': (255, 0, 0),
    'origin': (120, 0, 150),
    'origin_other': (120, 200, 32),
    'pivot': (204, 255, 153),
    'random': (randint(0, 255), randint(0, 255), randint(0, 255)),
    'winning': (0, 255, 30),
    'BLACK': (0, 0, 0),
    'BLUE': (0, 0, 255),
    'GRAY': (105, 105, 105),
    'GREEN': (0, 255, 0),
    'NODEGREEN': (0, 255, 0),
    'ORANGE': (255, 148, 0),
    'RED': (255, 0, 0),
    'WHITE': (255, 255, 255),
}

G_TYPES = "TETRA OCTA CUBE ICOSA DODECA DISCO".split()
G_POLYHEDRA = {
    'TETRA': {
        'V': [(500, 520), (500, 230), (260, 650), (740, 650)],
        'A': {0: {1, 2, 3}, 1: {0, 2, 3}, 2: {0, 1, 3}, 3: {0, 1, 2}},
        'E': ((0, 1), (0, 2), (0, 3), (1, 2), (1, 3), (2, 3))
    },
    'OCTA': {
        'V': [(430, 470), (570, 470), (500, 600), (500, 230), (260, 650), (740, 650)],
        'A': {0: {1, 2, 3, 4}, 1: {0, 2, 3, 5}, 2: {0, 1, 4, 5}, 3: {0, 1, 4, 5}, 4: {0, 2, 3, 5}, 5: {1, 2, 3, 4}},
        'E': ((0, 1), (0, 2), (0, 3), (0, 4), (1, 2), (1, 3), (1, 5), (2, 5), (2, 4), (3, 4), (5, 4), (5, 3))
    },
    'CUBE': {
        'V': [(420, 360), (580, 360), (580, 520), (420, 520), (300, 640), (300, 240), (700, 240), (700, 640)],
        'A': {0: {1, 3, 5}, 1: {0, 2, 6}, 2: {1, 3, 7}, 3: {0, 2, 4}, 4: {7, 3, 5}, 5: {0, 4, 6}, 6: {1, 5, 7}, 7: {2, 4, 6}},
        'E': ((0, 1), (0, 5), (0, 3), (5, 4), (1, 2), (2, 3), (1, 6), (2, 7), (3, 4), (5, 6), (6, 7), (4, 7))
    },
    'ICOSA': {
        'V': [(500, 230), (260, 650), (740, 650), (580, 470), (500, 390), (420, 470), (390, 570), (500, 600), (610, 570), (530, 490), (500, 550), (470, 490)],
        'A': {0: {1, 3, 5, 4, 2}, 1: {2, 7, 6, 5, 0}, 2: {0, 7, 8, 3, 1}, 3: {0, 2, 4, 8, 9}, 4: {0, 11, 3, 5, 9}, 5: {0, 1, 4, 11, 6}, 6: {1, 5, 7, 10, 11}, 7: {8, 1, 2, 10, 6}, 8: {9, 10, 7, 2, 3}, 9: {8, 10, 3, 4, 11}, 10: {6, 7, 8, 11, 9}, 11: {4, 5, 6, 10, 9}},
        'E': [(10, 7), (0, 1), (1, 2), (2, 0), (1, 7), (2, 7), (0, 4), (0, 3), (0, 5), (1, 6), (2, 8), (2, 3), (1, 5), (6, 7), (7, 8), (8, 9), (9, 10), (10, 11), (5, 6), (5, 11), (6, 11), (6, 10), (8, 10), (3, 8), (3, 9), (9, 11), (3, 4), (4, 5), (4, 11), (4, 9)],
    },
    'DODECA': {
        'V': [(470, 420), (530, 420), (560, 490), (500, 530), (440, 490), (400, 500), (400, 610), (500, 580), (600, 610), (600, 500), (670, 410), (560, 380), (500, 290), (440, 380), (330, 410), (270, 390), (500, 230), (730, 390), (640, 660), (360, 660)],
        'E': ((16, 12), (16, 15), (16, 17), (17, 18), (17, 10), (18, 8), (18, 19), (19, 6), (19, 15), (15, 14), (14, 13), (14, 5), (5, 6), (6, 7), (7, 8), (8, 9), (9, 10), (10, 11), (11, 12), (12, 13), (13, 0), (11, 1), (9, 2), (7, 3), (4, 5), (0, 1), (1, 2), (0, 4), (4, 3), (3, 2)),
        'A': {0: {1, 4, 13}, 1: {0, 2, 11}, 2: {9, 3, 1}, 3: {2, 4, 7}, 4: {0, 3, 5}, 5: {4, 14, 6}, 6: {19, 5, 7}, 7: {8, 3, 6}, 8: {9, 18, 7}, 9: {8, 10, 2}, 10: {17, 11, 9}, 11: {1, 10, 12}, 12: {16, 11, 13}, 13: {0, 12, 14}, 14: {5, 13, 15}, 15: {16, 19, 14}, 16: {17, 12, 15}, 17: {16, 18, 10}, 18: {8, 17, 19}, 19: {18, 6, 15}}
    },
    'DISCO': {
        'V': [(430, 510), (325, 615), (430, 370), (325, 265), (570, 510), (675, 615), (570, 370), (675, 265), (395, 475), (360, 510), (395, 405), (360, 370), (465, 545), (430, 580), (465, 475), (290, 650), (465, 405), (290, 230), (465, 335), (430, 300), (535, 545), (570, 580), (535, 475), (710, 650), (535, 405), (710, 230), (535, 335), (570, 300), (605, 475), (640, 510), (605, 405), (640, 370)],
        'A': {0: {4, 8, 2, 12, 1, 14}, 1: {5, 9, 3, 13, 15, 0}, 2: {6, 10, 18, 0, 3, 16}, 3: {7, 11, 19, 1, 17, 2}, 4: {28, 0, 6, 20, 5, 22}, 5: {29, 1, 7, 21, 23, 4}, 6: {30, 2, 26, 4, 7, 24}, 7: {31, 3, 27, 5, 25, 6}, 8: {0, 10, 9}, 9: {1, 11, 8}, 10: {2, 8, 11}, 11: {3, 9, 10}, 12: {20, 0, 13}, 13: {21, 1, 12}, 14: {22, 16, 0}, 15: {23, 17, 1}, 16: {24, 14, 2}, 17: {25, 15, 3}, 18: {26, 2, 19}, 19: {27, 3, 18}, 20: {12, 4, 21}, 21: {13, 5, 20}, 22: {14, 24, 4}, 23: {15, 25, 5}, 24: {16, 22, 6}, 25: {17, 23, 7}, 26: {18, 6, 27}, 27: {19, 7, 26}, 28: {4, 30, 29}, 29: {5, 31, 28}, 30: {6, 28, 31}, 31: {7, 29, 30}},
        'E': {(0, 4), (0, 8), (0, 2), (0, 12), (0, 1), (0, 14), (1, 5), (1, 9), (1, 3), (1, 13), (1, 15), (2, 6), (2, 10), (2, 18), (2, 3), (2, 16), (3, 7), (3, 11), (3, 19), (3, 17), (4, 28), (4, 6), (4, 20), (4, 5), (4, 22), (5, 29), (5, 7), (5, 21), (5, 23), (6, 30), (6, 26), (6, 7), (6, 24), (7, 31), (7, 27), (7, 25), (8, 10), (8, 9), (9, 11), (10, 11), (12, 20), (12, 13), (13, 21), (14, 22), (14, 16), (15, 23), (15, 17), (16, 24), (17, 25), (18, 26), (18, 19), (19, 27), (20, 21), (22, 24), (23, 25), (26, 27), (28, 30), (28, 29), (29, 31), (30, 31)}
    }
}

g32 = {
    'A': {0: {1, 2, 4, 8, 12, 14}, 1: {0, 3, 5, 9, 13, 15}, 2: {0, 3, 6, 10, 16, 18}, 3: {1, 2, 7, 11, 17, 19}, 4: {0, 5, 6, 20, 22, 28}, 5: {1, 4, 7, 21, 23, 29}, 6: {2, 4, 7, 24, 26, 30}, 7: {3, 5, 6, 25, 27, 31}, 8: {0, 9, 10}, 9: {8, 1, 11}, 10: {8, 2, 11}, 11: {9, 10, 3}, 12: {0, 20, 13}, 13: {1, 12, 21}, 14: {0, 16, 22}, 15: {1, 17, 23}, 16: {24, 2, 14}, 17: {25, 3, 15}, 18: {19, 2, 26}, 19: {27, 18, 3}, 20: {21, 4, 12}, 21: {13, 20, 5}, 22: {24, 4, 14}, 23: {25, 5, 15}, 24: {16, 6, 22}, 25: {17, 23, 7}, 26: {18, 27, 6}, 27: {26, 19, 7}, 28: {4, 29, 30}, 29: {28, 5, 31}, 30: {28, 6, 31}, 31: {29, 30, 7}},  # noqa
    'E': [[0, 4], [0, 8], [0, 2], [0, 12], [0, 1], [0, 14], [1, 5], [1, 9], [1, 3], [1, 13], [1, 15], [1, 0], [2, 6], [2, 10], [2, 18], [2, 0], [2, 3], [2, 16], [3, 7], [3, 11], [3, 19], [3, 1], [3, 17], [3, 2], [4, 28], [4, 0], [4, 6], [4, 20], [4, 5], [4, 22], [5, 29], [5, 1], [5, 7], [5, 21], [5, 23], [5, 4], [6, 30], [6, 2], [6, 26], [6, 4], [6, 7], [6, 24], [7, 31], [7, 3], [7, 27], [7, 5], [7, 25], [7, 6], [8, 0], [8, 10], [8, 9], [9, 1], [9, 11], [9, 8], [10, 2], [10, 8], [10, 11], [11, 3], [11, 9], [11, 10], [12, 20], [12, 0], [12, 13], [13, 21], [13, 1], [13, 12], [14, 22], [14, 16], [14, 0], [15, 23], [15, 17], [15, 1], [16, 24], [16, 14], [16, 2], [17, 25], [17, 15], [17, 3], [18, 26], [18, 2], [18, 19], [19, 27], [19, 3], [19, 18], [20, 12], [20, 4], [20, 21], [21, 13], [21, 5], [21, 20], [22, 14], [22, 24], [22, 4], [23, 15], [23, 25], [23, 5], [24, 16], [24, 22], [24, 6], [25, 17], [25, 23], [25, 7], [26, 18], [26, 6], [26, 27], [27, 19], [27, 7], [27, 26], [28, 4], [28, 30], [28, 29], [29, 5], [29, 31], [29, 28], [30, 6], [30, 28], [30, 31], [31, 7], [31, 29], [31, 30]],  # noqa
    'V': [(705.12, 734.56), (738.38, 702.02), (705.12, 891.06), (738.38, 858.52), (861.62, 741.48), (894.88, 708.94), (861.62, 897.98), (894.88, 865.44), (548.61, 727.64), (581.88, 695.1), (548.61, 884.15), (581.88, 851.61), (705.12, 578.06), (738.38, 545.52), (671.85, 767.1), (771.65, 669.48), (671.85, 923.6), (771.65, 825.99), (705.12, 1047.57), (738.38, 1015.03), (861.62, 584.97), (894.88, 552.43), (828.35, 774.01), (928.15, 676.4), (828.35, 930.52), (928.15, 832.9), (861.62, 1054.48), (894.88, 1021.94), (1018.12, 748.39), (1051.39, 715.85), (1018.12, 904.9), (1051.39, 872.36)]  # noqa
}
