"""
    CryptoAPIs

    Crypto APIs is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2021-03-20
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.convert_bitcoin_cash_address402_response import ConvertBitcoinCashAddress402Response
from cryptoapis.model.convert_bitcoin_cash_address409_response import ConvertBitcoinCashAddress409Response
from cryptoapis.model.convert_bitcoin_cash_address415_response import ConvertBitcoinCashAddress415Response
from cryptoapis.model.convert_bitcoin_cash_address422_response import ConvertBitcoinCashAddress422Response
from cryptoapis.model.convert_bitcoin_cash_address429_response import ConvertBitcoinCashAddress429Response
from cryptoapis.model.convert_bitcoin_cash_address500_response import ConvertBitcoinCashAddress500Response
from cryptoapis.model.get_latest_mined_zilliqa_block400_response import GetLatestMinedZilliqaBlock400Response
from cryptoapis.model.get_latest_mined_zilliqa_block401_response import GetLatestMinedZilliqaBlock401Response
from cryptoapis.model.get_latest_mined_zilliqa_block403_response import GetLatestMinedZilliqaBlock403Response
from cryptoapis.model.get_latest_mined_zilliqa_block_r import GetLatestMinedZilliqaBlockR
from cryptoapis.model.get_transaction_details_by_transaction_id404_response import GetTransactionDetailsByTransactionID404Response
from cryptoapis.model.get_zilliqa_address_details400_response import GetZilliqaAddressDetails400Response
from cryptoapis.model.get_zilliqa_address_details401_response import GetZilliqaAddressDetails401Response
from cryptoapis.model.get_zilliqa_address_details403_response import GetZilliqaAddressDetails403Response
from cryptoapis.model.get_zilliqa_address_details_r import GetZilliqaAddressDetailsR
from cryptoapis.model.get_zilliqa_block_details_by_block_hash400_response import GetZilliqaBlockDetailsByBlockHash400Response
from cryptoapis.model.get_zilliqa_block_details_by_block_hash401_response import GetZilliqaBlockDetailsByBlockHash401Response
from cryptoapis.model.get_zilliqa_block_details_by_block_hash403_response import GetZilliqaBlockDetailsByBlockHash403Response
from cryptoapis.model.get_zilliqa_block_details_by_block_hash_r import GetZilliqaBlockDetailsByBlockHashR
from cryptoapis.model.get_zilliqa_block_details_by_block_height400_response import GetZilliqaBlockDetailsByBlockHeight400Response
from cryptoapis.model.get_zilliqa_block_details_by_block_height401_response import GetZilliqaBlockDetailsByBlockHeight401Response
from cryptoapis.model.get_zilliqa_block_details_by_block_height403_response import GetZilliqaBlockDetailsByBlockHeight403Response
from cryptoapis.model.get_zilliqa_block_details_by_block_height_r import GetZilliqaBlockDetailsByBlockHeightR
from cryptoapis.model.get_zilliqa_transaction_details_by_transaction_id400_response import GetZilliqaTransactionDetailsByTransactionID400Response
from cryptoapis.model.get_zilliqa_transaction_details_by_transaction_id401_response import GetZilliqaTransactionDetailsByTransactionID401Response
from cryptoapis.model.get_zilliqa_transaction_details_by_transaction_id403_response import GetZilliqaTransactionDetailsByTransactionID403Response
from cryptoapis.model.get_zilliqa_transaction_details_by_transaction_idr import GetZilliqaTransactionDetailsByTransactionIDR
from cryptoapis.model.list_transactions_by_block_height404_response import ListTransactionsByBlockHeight404Response
from cryptoapis.model.list_zilliqa_transactions_by_address400_response import ListZilliqaTransactionsByAddress400Response
from cryptoapis.model.list_zilliqa_transactions_by_address401_response import ListZilliqaTransactionsByAddress401Response
from cryptoapis.model.list_zilliqa_transactions_by_address403_response import ListZilliqaTransactionsByAddress403Response
from cryptoapis.model.list_zilliqa_transactions_by_address_r import ListZilliqaTransactionsByAddressR
from cryptoapis.model.list_zilliqa_transactions_by_block_hash400_response import ListZilliqaTransactionsByBlockHash400Response
from cryptoapis.model.list_zilliqa_transactions_by_block_hash401_response import ListZilliqaTransactionsByBlockHash401Response
from cryptoapis.model.list_zilliqa_transactions_by_block_hash403_response import ListZilliqaTransactionsByBlockHash403Response
from cryptoapis.model.list_zilliqa_transactions_by_block_hash_r import ListZilliqaTransactionsByBlockHashR
from cryptoapis.model.list_zilliqa_transactions_by_block_height400_response import ListZilliqaTransactionsByBlockHeight400Response
from cryptoapis.model.list_zilliqa_transactions_by_block_height401_response import ListZilliqaTransactionsByBlockHeight401Response
from cryptoapis.model.list_zilliqa_transactions_by_block_height403_response import ListZilliqaTransactionsByBlockHeight403Response
from cryptoapis.model.list_zilliqa_transactions_by_block_height_r import ListZilliqaTransactionsByBlockHeightR


class ZilliqaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_latest_mined_zilliqa_block_endpoint = _Endpoint(
            settings={
                'response_type': (GetLatestMinedZilliqaBlockR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/blocks/last',
                'operation_id': 'get_latest_mined_zilliqa_block',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'context',
                ],
                'required': [
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_zilliqa_address_details_endpoint = _Endpoint(
            settings={
                'response_type': (GetZilliqaAddressDetailsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/addresses/{address}',
                'operation_id': 'get_zilliqa_address_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'address',
                    'context',
                ],
                'required': [
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_zilliqa_block_details_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (GetZilliqaBlockDetailsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}',
                'operation_id': 'get_zilliqa_block_details_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_hash',
                    'context',
                ],
                'required': [
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_zilliqa_block_details_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (GetZilliqaBlockDetailsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}',
                'operation_id': 'get_zilliqa_block_details_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_height',
                    'context',
                ],
                'required': [
                    'network',
                    'block_height',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_height':
                        (int,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_height': 'blockHeight',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'block_height': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_zilliqa_transaction_details_by_transaction_id_endpoint = _Endpoint(
            settings={
                'response_type': (GetZilliqaTransactionDetailsByTransactionIDR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/transactions/{transactionHash}',
                'operation_id': 'get_zilliqa_transaction_details_by_transaction_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'transaction_hash',
                    'context',
                ],
                'required': [
                    'network',
                    'transaction_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'transaction_hash':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'transaction_hash': 'transactionHash',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'transaction_hash': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_zilliqa_transactions_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (ListZilliqaTransactionsByAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/addresses/{address}/transactions',
                'operation_id': 'list_zilliqa_transactions_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'address',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_zilliqa_transactions_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (ListZilliqaTransactionsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}/transactions',
                'operation_id': 'list_zilliqa_transactions_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_hash',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_zilliqa_transactions_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (ListZilliqaTransactionsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}/transactions',
                'operation_id': 'list_zilliqa_transactions_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'block_height',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'network',
                    'block_height',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'block_height':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'network': 'network',
                    'block_height': 'blockHeight',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'network': 'path',
                    'block_height': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_latest_mined_zilliqa_block(
        self,
        network="mainnet",
        **kwargs
    ):
        """Get Latest Mined Zilliqa Block  # noqa: E501

        Through this endpoint users can obtain information on the latest block that has been mined on the Zilliqa blockchain. Data could include the current and previous block hashes, transaction count, and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_mined_zilliqa_block(network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetLatestMinedZilliqaBlockR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        return self.get_latest_mined_zilliqa_block_endpoint.call_with_http_info(**kwargs)

    def get_zilliqa_address_details(
        self,
        address,
        network="mainnet",
        **kwargs
    ):
        """Get Zilliqa Address Details  # noqa: E501

        Through this endpoint customers can obtain information address details from the Zilliqa blockchain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zilliqa_address_details(address, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Defines the specific transaction's address.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetZilliqaAddressDetailsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.get_zilliqa_address_details_endpoint.call_with_http_info(**kwargs)

    def get_zilliqa_block_details_by_block_hash(
        self,
        block_hash,
        network="mainnet",
        **kwargs
    ):
        """Get Zilliqa Block Details By Block Hash  # noqa: E501

        Through this endpoint customers can obtain block details from the Zilliqa blockchain by providing the block Hash parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zilliqa_block_details_by_block_hash(block_hash, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetZilliqaBlockDetailsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.get_zilliqa_block_details_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def get_zilliqa_block_details_by_block_height(
        self,
        block_height,
        network="mainnet",
        **kwargs
    ):
        """Get Zilliqa Block Details By Block Height  # noqa: E501

        Through this endpoint customers can obtain block details from the Zilliqa blockchain by providing the block Height parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zilliqa_block_details_by_block_height(block_height, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            block_height (int): Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetZilliqaBlockDetailsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_height'] = \
            block_height
        return self.get_zilliqa_block_details_by_block_height_endpoint.call_with_http_info(**kwargs)

    def get_zilliqa_transaction_details_by_transaction_id(
        self,
        transaction_hash,
        network="mainnet",
        **kwargs
    ):
        """Get Zilliqa Transaction Details by Transaction ID  # noqa: E501

        Through this endpoint customers can obtain transaction details on the Zilliqa blockchain by providing a Transaction ID parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zilliqa_transaction_details_by_transaction_id(transaction_hash, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            transaction_hash (str): String identifier of the transaction
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetZilliqaTransactionDetailsByTransactionIDR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['transaction_hash'] = \
            transaction_hash
        return self.get_zilliqa_transaction_details_by_transaction_id_endpoint.call_with_http_info(**kwargs)

    def list_zilliqa_transactions_by_address(
        self,
        address,
        network="mainnet",
        **kwargs
    ):
        """List Zilliqa Transactions by Address  # noqa: E501

        Through this endpoint customers can list transactions on the Zilliqa blockchain by the address parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_zilliqa_transactions_by_address(address, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            address (str): Defines the specific address of the sender.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListZilliqaTransactionsByAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.list_zilliqa_transactions_by_address_endpoint.call_with_http_info(**kwargs)

    def list_zilliqa_transactions_by_block_hash(
        self,
        block_hash,
        network="mainnet",
        **kwargs
    ):
        """List Zilliqa Transactions By Block Hash  # noqa: E501

        Through this endpoint customers can list transactions on the Zilliqa blockchain by the block hash parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_zilliqa_transactions_by_block_hash(block_hash, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListZilliqaTransactionsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.list_zilliqa_transactions_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def list_zilliqa_transactions_by_block_height(
        self,
        block_height,
        network="mainnet",
        **kwargs
    ):
        """List Zilliqa Transactions By Block Height  # noqa: E501

        Through this endpoint customers can list transactions on the Zilliqa blockchain by the block height parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_zilliqa_transactions_by_block_height(block_height, network="mainnet", async_req=True)
        >>> result = thread.get()

        Args:
            block_height (int): Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.. defaults to "mainnet", must be one of ["mainnet"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListZilliqaTransactionsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['block_height'] = \
            block_height
        return self.list_zilliqa_transactions_by_block_height_endpoint.call_with_http_info(**kwargs)

