"""
    CryptoAPIs

    Crypto APIs is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2021-03-20
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.convert_bitcoin_cash_address402_response import ConvertBitcoinCashAddress402Response
from cryptoapis.model.convert_bitcoin_cash_address409_response import ConvertBitcoinCashAddress409Response
from cryptoapis.model.convert_bitcoin_cash_address415_response import ConvertBitcoinCashAddress415Response
from cryptoapis.model.convert_bitcoin_cash_address422_response import ConvertBitcoinCashAddress422Response
from cryptoapis.model.convert_bitcoin_cash_address429_response import ConvertBitcoinCashAddress429Response
from cryptoapis.model.convert_bitcoin_cash_address500_response import ConvertBitcoinCashAddress500Response
from cryptoapis.model.estimate_transaction_smart_fee400_response import EstimateTransactionSmartFee400Response
from cryptoapis.model.estimate_transaction_smart_fee401_response import EstimateTransactionSmartFee401Response
from cryptoapis.model.estimate_transaction_smart_fee403_response import EstimateTransactionSmartFee403Response
from cryptoapis.model.estimate_transaction_smart_fee501_response import EstimateTransactionSmartFee501Response
from cryptoapis.model.estimate_transaction_smart_fee_r import EstimateTransactionSmartFeeR
from cryptoapis.model.get_address_balance400_response import GetAddressBalance400Response
from cryptoapis.model.get_address_balance401_response import GetAddressBalance401Response
from cryptoapis.model.get_address_balance403_response import GetAddressBalance403Response
from cryptoapis.model.get_address_balance_r import GetAddressBalanceR
from cryptoapis.model.get_address_details400_response import GetAddressDetails400Response
from cryptoapis.model.get_address_details401_response import GetAddressDetails401Response
from cryptoapis.model.get_address_details403_response import GetAddressDetails403Response
from cryptoapis.model.get_address_details_r import GetAddressDetailsR
from cryptoapis.model.get_block_details_by_block_hash400_response import GetBlockDetailsByBlockHash400Response
from cryptoapis.model.get_block_details_by_block_hash401_response import GetBlockDetailsByBlockHash401Response
from cryptoapis.model.get_block_details_by_block_hash403_response import GetBlockDetailsByBlockHash403Response
from cryptoapis.model.get_block_details_by_block_hash_r import GetBlockDetailsByBlockHashR
from cryptoapis.model.get_block_details_by_block_height400_response import GetBlockDetailsByBlockHeight400Response
from cryptoapis.model.get_block_details_by_block_height401_response import GetBlockDetailsByBlockHeight401Response
from cryptoapis.model.get_block_details_by_block_height403_response import GetBlockDetailsByBlockHeight403Response
from cryptoapis.model.get_block_details_by_block_height_r import GetBlockDetailsByBlockHeightR
from cryptoapis.model.get_fee_recommendations400_response import GetFeeRecommendations400Response
from cryptoapis.model.get_fee_recommendations401_response import GetFeeRecommendations401Response
from cryptoapis.model.get_fee_recommendations403_response import GetFeeRecommendations403Response
from cryptoapis.model.get_fee_recommendations_r import GetFeeRecommendationsR
from cryptoapis.model.get_last_mined_block400_response import GetLastMinedBlock400Response
from cryptoapis.model.get_last_mined_block401_response import GetLastMinedBlock401Response
from cryptoapis.model.get_last_mined_block403_response import GetLastMinedBlock403Response
from cryptoapis.model.get_last_mined_block_r import GetLastMinedBlockR
from cryptoapis.model.get_next_available_nonce400_response import GetNextAvailableNonce400Response
from cryptoapis.model.get_next_available_nonce401_response import GetNextAvailableNonce401Response
from cryptoapis.model.get_next_available_nonce403_response import GetNextAvailableNonce403Response
from cryptoapis.model.get_next_available_nonce_r import GetNextAvailableNonceR
from cryptoapis.model.get_raw_transaction_data400_response import GetRawTransactionData400Response
from cryptoapis.model.get_raw_transaction_data401_response import GetRawTransactionData401Response
from cryptoapis.model.get_raw_transaction_data403_response import GetRawTransactionData403Response
from cryptoapis.model.get_raw_transaction_data_r import GetRawTransactionDataR
from cryptoapis.model.get_transaction_details_by_transaction_id400_response import GetTransactionDetailsByTransactionID400Response
from cryptoapis.model.get_transaction_details_by_transaction_id401_response import GetTransactionDetailsByTransactionID401Response
from cryptoapis.model.get_transaction_details_by_transaction_id403_response import GetTransactionDetailsByTransactionID403Response
from cryptoapis.model.get_transaction_details_by_transaction_id404_response import GetTransactionDetailsByTransactionID404Response
from cryptoapis.model.get_transaction_details_by_transaction_idr import GetTransactionDetailsByTransactionIDR
from cryptoapis.model.get_xrp_ripple_transaction_details_by_transaction_id404_response import GetXRPRippleTransactionDetailsByTransactionID404Response
from cryptoapis.model.list_confirmed_tokens_transfers_by_address_and_time_range400_response import ListConfirmedTokensTransfersByAddressAndTimeRange400Response
from cryptoapis.model.list_confirmed_tokens_transfers_by_address_and_time_range401_response import ListConfirmedTokensTransfersByAddressAndTimeRange401Response
from cryptoapis.model.list_confirmed_tokens_transfers_by_address_and_time_range403_response import ListConfirmedTokensTransfersByAddressAndTimeRange403Response
from cryptoapis.model.list_confirmed_tokens_transfers_by_address_and_time_range_r import ListConfirmedTokensTransfersByAddressAndTimeRangeR
from cryptoapis.model.list_confirmed_transactions_by_address400_response import ListConfirmedTransactionsByAddress400Response
from cryptoapis.model.list_confirmed_transactions_by_address401_response import ListConfirmedTransactionsByAddress401Response
from cryptoapis.model.list_confirmed_transactions_by_address403_response import ListConfirmedTransactionsByAddress403Response
from cryptoapis.model.list_confirmed_transactions_by_address_and_time_range400_response import ListConfirmedTransactionsByAddressAndTimeRange400Response
from cryptoapis.model.list_confirmed_transactions_by_address_and_time_range401_response import ListConfirmedTransactionsByAddressAndTimeRange401Response
from cryptoapis.model.list_confirmed_transactions_by_address_and_time_range403_response import ListConfirmedTransactionsByAddressAndTimeRange403Response
from cryptoapis.model.list_confirmed_transactions_by_address_and_time_range_r import ListConfirmedTransactionsByAddressAndTimeRangeR
from cryptoapis.model.list_confirmed_transactions_by_address_r import ListConfirmedTransactionsByAddressR
from cryptoapis.model.list_internal_transactions_by_address_and_time_range400_response import ListInternalTransactionsByAddressAndTimeRange400Response
from cryptoapis.model.list_internal_transactions_by_address_and_time_range401_response import ListInternalTransactionsByAddressAndTimeRange401Response
from cryptoapis.model.list_internal_transactions_by_address_and_time_range403_response import ListInternalTransactionsByAddressAndTimeRange403Response
from cryptoapis.model.list_internal_transactions_by_address_and_time_range_r import ListInternalTransactionsByAddressAndTimeRangeR
from cryptoapis.model.list_latest_mined_blocks400_response import ListLatestMinedBlocks400Response
from cryptoapis.model.list_latest_mined_blocks401_response import ListLatestMinedBlocks401Response
from cryptoapis.model.list_latest_mined_blocks403_response import ListLatestMinedBlocks403Response
from cryptoapis.model.list_latest_mined_blocks_r import ListLatestMinedBlocksR
from cryptoapis.model.list_transactions_by_block_hash400_response import ListTransactionsByBlockHash400Response
from cryptoapis.model.list_transactions_by_block_hash401_response import ListTransactionsByBlockHash401Response
from cryptoapis.model.list_transactions_by_block_hash403_response import ListTransactionsByBlockHash403Response
from cryptoapis.model.list_transactions_by_block_hash_r import ListTransactionsByBlockHashR
from cryptoapis.model.list_transactions_by_block_height400_response import ListTransactionsByBlockHeight400Response
from cryptoapis.model.list_transactions_by_block_height401_response import ListTransactionsByBlockHeight401Response
from cryptoapis.model.list_transactions_by_block_height403_response import ListTransactionsByBlockHeight403Response
from cryptoapis.model.list_transactions_by_block_height404_response import ListTransactionsByBlockHeight404Response
from cryptoapis.model.list_transactions_by_block_height_r import ListTransactionsByBlockHeightR
from cryptoapis.model.list_unconfirmed_transactions_by_address400_response import ListUnconfirmedTransactionsByAddress400Response
from cryptoapis.model.list_unconfirmed_transactions_by_address401_response import ListUnconfirmedTransactionsByAddress401Response
from cryptoapis.model.list_unconfirmed_transactions_by_address403_response import ListUnconfirmedTransactionsByAddress403Response
from cryptoapis.model.list_unconfirmed_transactions_by_address_r import ListUnconfirmedTransactionsByAddressR
from cryptoapis.model.list_unspent_transaction_outputs_by_address400_response import ListUnspentTransactionOutputsByAddress400Response
from cryptoapis.model.list_unspent_transaction_outputs_by_address401_response import ListUnspentTransactionOutputsByAddress401Response
from cryptoapis.model.list_unspent_transaction_outputs_by_address403_response import ListUnspentTransactionOutputsByAddress403Response
from cryptoapis.model.list_unspent_transaction_outputs_by_address_r import ListUnspentTransactionOutputsByAddressR


class UnifiedEndpointsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.estimate_transaction_smart_fee_endpoint = _Endpoint(
            settings={
                'response_type': (EstimateTransactionSmartFeeR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/estimate-transaction-smart-fee',
                'operation_id': 'estimate_transaction_smart_fee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'confirmation_target',
                    'estimate_mode',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'estimate_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "LITECOIN": "litecoin",
                        "DASH": "dash"
                    },
                    ('network',): {

                        "TESTNET": "testnet",
                        "MAINNET": "mainnet"
                    },
                    ('estimate_mode',): {

                        "ECONOMICAL": "economical",
                        "CONSERVATIVE": "conservative"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'confirmation_target':
                        (int,),
                    'estimate_mode':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                    'confirmation_target': 'confirmationTarget',
                    'estimate_mode': 'estimateMode',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'confirmation_target': 'query',
                    'estimate_mode': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_address_balance_endpoint = _Endpoint(
            settings={
                'response_type': (GetAddressBalanceR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/balance',
                'operation_id': 'get_address_balance',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DASH": "dash",
                        "DOGECOIN": "dogecoin",
                        "XRP": "xrp",
                        "TRON": "tron"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "NILE": "nile",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_address_details_endpoint = _Endpoint(
            settings={
                'response_type': (GetAddressDetailsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}',
                'operation_id': 'get_address_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_block_details_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (GetBlockDetailsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}',
                'operation_id': 'get_block_details_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'block_hash',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash",
                        "ZILLIQA": "zilliqa"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_block_details_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (GetBlockDetailsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/height/{height}',
                'operation_id': 'get_block_details_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'height',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'height',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash",
                        "ZILLIQA": "zilliqa"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'height':
                        (int,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'height': 'height',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'height': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_fee_recommendations_endpoint = _Endpoint(
            settings={
                'response_type': (GetFeeRecommendationsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/mempool/fees',
                'operation_id': 'get_fee_recommendations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "LITECOIN": "litecoin",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash",
                        "XRP": "xrp"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_last_mined_block_endpoint = _Endpoint(
            settings={
                'response_type': (GetLastMinedBlockR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/last',
                'operation_id': 'get_last_mined_block',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash",
                        "ZILLIQA": "zilliqa"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_next_available_nonce_endpoint = _Endpoint(
            settings={
                'response_type': (GetNextAvailableNonceR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/next-available-nonce',
                'operation_id': 'get_next_available_nonce',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_raw_transaction_data_endpoint = _Endpoint(
            settings={
                'response_type': (GetRawTransactionDataR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/transactions/{transactionId}/raw-data',
                'operation_id': 'get_raw_transaction_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'transaction_id',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'transaction_id':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'transaction_id': 'transactionId',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'transaction_id': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_transaction_details_by_transaction_id_endpoint = _Endpoint(
            settings={
                'response_type': (GetTransactionDetailsByTransactionIDR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/transactions/{transactionId}',
                'operation_id': 'get_transaction_details_by_transaction_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'transaction_id',
                    'context',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'transaction_id':
                        (str,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'transaction_id': 'transactionId',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'transaction_id': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_confirmed_tokens_transfers_by_address_and_time_range_endpoint = _Endpoint(
            settings={
                'response_type': (ListConfirmedTokensTransfersByAddressAndTimeRangeR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers-by-time-range',
                'operation_id': 'list_confirmed_tokens_transfers_by_address_and_time_range',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'from_timestamp':
                        (int,),
                    'to_timestamp':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'from_timestamp': 'fromTimestamp',
                    'to_timestamp': 'toTimestamp',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'from_timestamp': 'query',
                    'to_timestamp': 'query',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_confirmed_transactions_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (ListConfirmedTransactionsByAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/transactions',
                'operation_id': 'list_confirmed_transactions_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "ETHEREUM": "ethereum",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_confirmed_transactions_by_address_and_time_range_endpoint = _Endpoint(
            settings={
                'response_type': (ListConfirmedTransactionsByAddressAndTimeRangeR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/transactions-by-time-range',
                'operation_id': 'list_confirmed_transactions_by_address_and_time_range',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "ETHEREUM": "ethereum",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'from_timestamp':
                        (int,),
                    'to_timestamp':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'from_timestamp': 'fromTimestamp',
                    'to_timestamp': 'toTimestamp',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'from_timestamp': 'query',
                    'to_timestamp': 'query',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_internal_transactions_by_address_and_time_range_endpoint = _Endpoint(
            settings={
                'response_type': (ListInternalTransactionsByAddressAndTimeRangeR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/internal-by-time-range',
                'operation_id': 'list_internal_transactions_by_address_and_time_range',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                    'from_timestamp',
                    'to_timestamp',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "MORDOR": "mordor",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'from_timestamp':
                        (int,),
                    'to_timestamp':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'from_timestamp': 'fromTimestamp',
                    'to_timestamp': 'toTimestamp',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'from_timestamp': 'query',
                    'to_timestamp': 'query',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_latest_mined_blocks_endpoint = _Endpoint(
            settings={
                'response_type': (ListLatestMinedBlocksR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/last/{count}',
                'operation_id': 'list_latest_mined_blocks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'network',
                    'blockchain',
                    'count',
                    'context',
                ],
                'required': [
                    'network',
                    'blockchain',
                    'count',
                ],
                'nullable': [
                ],
                'enum': [
                    'network',
                    'blockchain',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('network',): {

                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "MAINNET": "mainnet",
                        "GOERLI": "goerli"
                    },
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "ETHEREUM": "ethereum",
                        "LITECOIN": "litecoin",
                        "DASH": "dash",
                        "DOGECOIN": "dogecoin",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZILLIQA": "zilliqa",
                        "ZCASH": "zcash",
                        "XRP": "xrp"
                    },
                },
                'openapi_types': {
                    'network':
                        (str,),
                    'blockchain':
                        (str,),
                    'count':
                        (int,),
                    'context':
                        (str,),
                },
                'attribute_map': {
                    'network': 'network',
                    'blockchain': 'blockchain',
                    'count': 'count',
                    'context': 'context',
                },
                'location_map': {
                    'network': 'path',
                    'blockchain': 'path',
                    'count': 'path',
                    'context': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_by_block_hash_endpoint = _Endpoint(
            settings={
                'response_type': (ListTransactionsByBlockHashR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions',
                'operation_id': 'list_transactions_by_block_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'block_hash',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'block_hash',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "TESTNET": "testnet",
                        "MAINNET": "mainnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'block_hash':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'block_hash': 'blockHash',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'block_hash': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_by_block_height_endpoint = _Endpoint(
            settings={
                'response_type': (ListTransactionsByBlockHeightR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions',
                'operation_id': 'list_transactions_by_block_height',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'height',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'height',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum",
                        "DASH": "dash",
                        "DOGECOIN": "dogecoin",
                        "LITECOIN": "litecoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'height':
                        (int,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'height': 'height',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'height': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_unconfirmed_transactions_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (ListUnconfirmedTransactionsByAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/address-transactions-unconfirmed/{address}',
                'operation_id': 'list_unconfirmed_transactions_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "ZCASH": "zcash",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_unspent_transaction_outputs_by_address_endpoint = _Endpoint(
            settings={
                'response_type': (ListUnspentTransactionOutputsByAddressR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/addresses/{address}/unspent-outputs',
                'operation_id': 'list_unspent_transaction_outputs_by_address',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'address',
                    'context',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'network',
                    'address',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DASH": "dash",
                        "DOGECOIN": "dogecoin",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "TESTNET": "testnet",
                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'address':
                        (str,),
                    'context':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'address': 'address',
                    'context': 'context',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'address': 'path',
                    'context': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def estimate_transaction_smart_fee(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Estimate Transaction Smart Fee  # noqa: E501

        Through this endpoint, customers can estimate the approximate fee per kilobyte needed for a transaction to begin confirmation within the `confirmationTarget` blocks when possible. After which it will return the number of blocks for which the estimate is valid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.estimate_transaction_smart_fee(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str):
            network (str):

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            confirmation_target (int): Integer representation of confirmation target in blocks that estimation will be valid for. [optional]
            estimate_mode (str): String representation of the address. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EstimateTransactionSmartFeeR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.estimate_transaction_smart_fee_endpoint.call_with_http_info(**kwargs)

    def get_address_balance(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """Get Address Balance  # noqa: E501

        Through this endpoint the customer can receive the balance of a given address based on confirmed/synced blocks only. In the case where there are any incoming or outgoing unconfirmed transactions for the specific address, they will not be counted or calculated here. Applies only for coins.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_address_balance(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAddressBalanceR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.get_address_balance_endpoint.call_with_http_info(**kwargs)

    def get_address_details(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """Get Address Details  # noqa: E501

        Through this endpoint the customer can receive basic information about a given address based on confirmed/synced blocks only. In the case where there are any incoming or outgoing **unconfirmed** transactions for the specific address, they **will not** be counted or calculated here. Applies only for coins.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_address_details(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetAddressDetailsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.get_address_details_endpoint.call_with_http_info(**kwargs)

    def get_block_details_by_block_hash(
        self,
        blockchain,
        network,
        block_hash,
        **kwargs
    ):
        """Get Block Details By Block Hash  # noqa: E501

        Through this endpoint customers can obtain basic information about a given mined block, specifically by using the `hash` parameter. These block details could include the hash of the specific, the previous and the next block, its transactions count, its height, etc.     Blockchain specific data is information such as version, nonce, size, bits, merkleroot, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_block_details_by_block_hash(blockchain, network, block_hash, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetBlockDetailsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.get_block_details_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def get_block_details_by_block_height(
        self,
        blockchain,
        network,
        height,
        **kwargs
    ):
        """Get Block Details By Block Height  # noqa: E501

        Through this endpoint customers can obtain basic information about a given mined block, specifically by using the `height` parameter. These block details could include the hash of the specific, the previous and the next block, its transactions count, its height, etc.     Blockchain specific data is information such as version, nonce, size, bits, merkleroot, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_block_details_by_block_height(blockchain, network, height, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            height (int): Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetBlockDetailsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['height'] = \
            height
        return self.get_block_details_by_block_height_endpoint.call_with_http_info(**kwargs)

    def get_fee_recommendations(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Get Fee Recommendations  # noqa: E501

        Through this endpoint customers can obtain fee recommendations. Our fees recommendations are based on Mempool data which makes them much more accurate than fees based on already mined blocks. Calculations are done in real time live. Using this endpoint customers can get gas price for Ethereum, fee per byte for Bitcoin, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fee_recommendations(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetFeeRecommendationsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.get_fee_recommendations_endpoint.call_with_http_info(**kwargs)

    def get_last_mined_block(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Get Last Mined Block  # noqa: E501

        Through this endpoint customers can fetch the last mined block in a specific blockchain network, along with its details. These could include the hash of the specific, the previous and the next block, its transactions count, its height, etc.     Blockchain specific data is information such as version, nonce, size, bits, merkleroot, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_last_mined_block(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetLastMinedBlockR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.get_last_mined_block_endpoint.call_with_http_info(**kwargs)

    def get_next_available_nonce(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """Get Next Available Nonce  # noqa: E501

        Through this endpoint customers can get information about the next available nonce by providing the specific blockchain, network and address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_next_available_nonce(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetNextAvailableNonceR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.get_next_available_nonce_endpoint.call_with_http_info(**kwargs)

    def get_raw_transaction_data(
        self,
        blockchain,
        network,
        transaction_id,
        **kwargs
    ):
        """Get Raw Transaction Data  # noqa: E501

        Through this endpoint customers can get information on a transaction in its raw format by providing its `transactionId`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_raw_transaction_data(blockchain, network, transaction_id, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            transaction_id (str): Represents the unique identifier of a transaction, i.e. it could be transactionId in UTXO-based protocols like Bitcoin, and transaction hash in Ethereum blockchain.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetRawTransactionDataR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['transaction_id'] = \
            transaction_id
        return self.get_raw_transaction_data_endpoint.call_with_http_info(**kwargs)

    def get_transaction_details_by_transaction_id(
        self,
        blockchain,
        network,
        transaction_id,
        **kwargs
    ):
        """Get Transaction Details By Transaction ID  # noqa: E501

        Through this endpoint customers can obtain details about a transaction by the transaction's unique identifier. In UTXO-based protocols like BTC there are attributes such as `transactionId` and transaction `hash`. They still could be different. In protocols like Ethereum there is only one unique value and it's `hash`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transaction_details_by_transaction_id(blockchain, network, transaction_id, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            transaction_id (str): Represents the unique identifier of a transaction, i.e. it could be `transactionId` in UTXO-based protocols like Bitcoin, and transaction `hash` in Ethereum blockchain.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetTransactionDetailsByTransactionIDR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['transaction_id'] = \
            transaction_id
        return self.get_transaction_details_by_transaction_id_endpoint.call_with_http_info(**kwargs)

    def list_confirmed_tokens_transfers_by_address_and_time_range(
        self,
        blockchain,
        network,
        address,
        from_timestamp,
        to_timestamp,
        **kwargs
    ):
        """List Confirmed Tokens Transfers By Address And Time Range  # noqa: E501

        Through this endpoint customers can obtain a list with **confirmed** token transfers by the `address` attribute and the query parameters `fromTimestamp` and `toTimestamp` which gives customers the opportunity to filter the results by a specified time period.    {note}This refers only to transfers done for **confirmed tokens** not coins.{/note}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_confirmed_tokens_transfers_by_address_and_time_range(blockchain, network, address, from_timestamp, to_timestamp, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Ethereum Classic, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.
            from_timestamp (int): Defines the specific time/date from which the results will start being listed.
            to_timestamp (int): Defines the specific time/date to which the results will be listed.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListConfirmedTokensTransfersByAddressAndTimeRangeR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        kwargs['from_timestamp'] = \
            from_timestamp
        kwargs['to_timestamp'] = \
            to_timestamp
        return self.list_confirmed_tokens_transfers_by_address_and_time_range_endpoint.call_with_http_info(**kwargs)

    def list_confirmed_transactions_by_address(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """List Confirmed Transactions By Address  # noqa: E501

        This endpoint will list transactions by an attribute `address`. The transactions listed will detail additional information such as hash, height, time of creation in Unix timestamp, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_confirmed_transactions_by_address(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListConfirmedTransactionsByAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.list_confirmed_transactions_by_address_endpoint.call_with_http_info(**kwargs)

    def list_confirmed_transactions_by_address_and_time_range(
        self,
        blockchain,
        network,
        address,
        from_timestamp,
        to_timestamp,
        **kwargs
    ):
        """List Confirmed Transactions By Address And Time Range  # noqa: E501

        This endpoint will list confirmed transactions by the attribute `address` and the query parameters `fromTimestamp` and `toTimestamp` which gives customers the opportunity to filter the results by a specified time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_confirmed_transactions_by_address_and_time_range(blockchain, network, address, from_timestamp, to_timestamp, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.
            from_timestamp (int): Defines the specific time/date from which the results will start being listed.
            to_timestamp (int): Defines the specific time/date to which the results will be listed.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListConfirmedTransactionsByAddressAndTimeRangeR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        kwargs['from_timestamp'] = \
            from_timestamp
        kwargs['to_timestamp'] = \
            to_timestamp
        return self.list_confirmed_transactions_by_address_and_time_range_endpoint.call_with_http_info(**kwargs)

    def list_internal_transactions_by_address_and_time_range(
        self,
        blockchain,
        network,
        address,
        from_timestamp,
        to_timestamp,
        **kwargs
    ):
        """List Internal Transactions By Address And Time Range  # noqa: E501

        Through this endpoint customers can list internal transactions by the `address` attribute and the query parameters `fromTimestamp` and `toTimestamp`  which gives customers the opportunity to filter the results by a specified time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_internal_transactions_by_address_and_time_range(blockchain, network, address, from_timestamp, to_timestamp, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): String identifier of the address document represented in CryptoAPIs
            from_timestamp (int): Defines the specific time/date from which the results will start being listed.
            to_timestamp (int): Defines the specific time/date to which the results will be listed.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListInternalTransactionsByAddressAndTimeRangeR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        kwargs['from_timestamp'] = \
            from_timestamp
        kwargs['to_timestamp'] = \
            to_timestamp
        return self.list_internal_transactions_by_address_and_time_range_endpoint.call_with_http_info(**kwargs)

    def list_latest_mined_blocks(
        self,
        network,
        blockchain,
        count,
        **kwargs
    ):
        """List Latest Mined Blocks  # noqa: E501

        Through this endpoint customers can list **up to 50** from the latest blocks that were mined.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_latest_mined_blocks(network, blockchain, count, async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            count (int): Specifies how many records were requested.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListLatestMinedBlocksR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['network'] = \
            network
        kwargs['blockchain'] = \
            blockchain
        kwargs['count'] = \
            count
        return self.list_latest_mined_blocks_endpoint.call_with_http_info(**kwargs)

    def list_transactions_by_block_hash(
        self,
        blockchain,
        network,
        block_hash,
        **kwargs
    ):
        """List Transactions by Block Hash  # noqa: E501

        This endpoint will list transactions by an attribute `transactionHash`. The transactions listed will detail additional information such as addresses, height, time of creation in Unix timestamp, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_block_hash(blockchain, network, block_hash, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            block_hash (str): Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListTransactionsByBlockHashR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['block_hash'] = \
            block_hash
        return self.list_transactions_by_block_hash_endpoint.call_with_http_info(**kwargs)

    def list_transactions_by_block_height(
        self,
        blockchain,
        network,
        height,
        **kwargs
    ):
        """List Transactions by Block Height  # noqa: E501

        This endpoint will list transactions by an attribute `blockHeight`. The transactions listed will detail additional information such as hash, addresses, time of creation in Unix timestamp, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_block_height(blockchain, network, height, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            height (int): Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListTransactionsByBlockHeightR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['height'] = \
            height
        return self.list_transactions_by_block_height_endpoint.call_with_http_info(**kwargs)

    def list_unconfirmed_transactions_by_address(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """List Unconfirmed Transactions by Address  # noqa: E501

        Through this endpoint customers can list transactions by `address` that are **unconfirmed**.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_unconfirmed_transactions_by_address(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the public address, which is a compressed and shortened form of a public key.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListUnconfirmedTransactionsByAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.list_unconfirmed_transactions_by_address_endpoint.call_with_http_info(**kwargs)

    def list_unspent_transaction_outputs_by_address(
        self,
        blockchain,
        network,
        address,
        **kwargs
    ):
        """List Unspent Transaction Outputs By Address  # noqa: E501

        Through this endpoint customers can list their transactions' unspent outputs by `address`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_unspent_transaction_outputs_by_address(blockchain, network, address, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            address (str): Represents the address that has unspend funds per which the result is returned.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListUnspentTransactionOutputsByAddressR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        kwargs['address'] = \
            address
        return self.list_unspent_transaction_outputs_by_address_endpoint.call_with_http_info(**kwargs)

