"""
    CryptoAPIs

    Crypto APIs is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2021-03-20
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.convert_bitcoin_cash_address402_response import ConvertBitcoinCashAddress402Response
from cryptoapis.model.convert_bitcoin_cash_address409_response import ConvertBitcoinCashAddress409Response
from cryptoapis.model.convert_bitcoin_cash_address415_response import ConvertBitcoinCashAddress415Response
from cryptoapis.model.convert_bitcoin_cash_address422_response import ConvertBitcoinCashAddress422Response
from cryptoapis.model.convert_bitcoin_cash_address429_response import ConvertBitcoinCashAddress429Response
from cryptoapis.model.convert_bitcoin_cash_address500_response import ConvertBitcoinCashAddress500Response
from cryptoapis.model.derive_and_sync_new_change_addresses400_response import DeriveAndSyncNewChangeAddresses400Response
from cryptoapis.model.derive_and_sync_new_change_addresses401_response import DeriveAndSyncNewChangeAddresses401Response
from cryptoapis.model.derive_and_sync_new_change_addresses403_response import DeriveAndSyncNewChangeAddresses403Response
from cryptoapis.model.derive_and_sync_new_change_addresses_r import DeriveAndSyncNewChangeAddressesR
from cryptoapis.model.derive_and_sync_new_change_addresses_rb import DeriveAndSyncNewChangeAddressesRB
from cryptoapis.model.derive_and_sync_new_receiving_addresses400_response import DeriveAndSyncNewReceivingAddresses400Response
from cryptoapis.model.derive_and_sync_new_receiving_addresses401_response import DeriveAndSyncNewReceivingAddresses401Response
from cryptoapis.model.derive_and_sync_new_receiving_addresses403_response import DeriveAndSyncNewReceivingAddresses403Response
from cryptoapis.model.derive_and_sync_new_receiving_addresses_r import DeriveAndSyncNewReceivingAddressesR
from cryptoapis.model.derive_and_sync_new_receiving_addresses_rb import DeriveAndSyncNewReceivingAddressesRB
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_assets400_response import GetHDWalletXPubYPubZPubAssets400Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_assets401_response import GetHDWalletXPubYPubZPubAssets401Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_assets403_response import GetHDWalletXPubYPubZPubAssets403Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_assets422_response import GetHDWalletXPubYPubZPubAssets422Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_assets_r import GetHDWalletXPubYPubZPubAssetsR
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_details400_response import GetHDWalletXPubYPubZPubDetails400Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_details401_response import GetHDWalletXPubYPubZPubDetails401Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_details403_response import GetHDWalletXPubYPubZPubDetails403Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_details422_response import GetHDWalletXPubYPubZPubDetails422Response
from cryptoapis.model.get_hd_wallet_x_pub_y_pub_z_pub_details_r import GetHDWalletXPubYPubZPubDetailsR
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_transactions400_response import ListHDWalletXPubYPubZPubTransactions400Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_transactions401_response import ListHDWalletXPubYPubZPubTransactions401Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_transactions403_response import ListHDWalletXPubYPubZPubTransactions403Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_transactions422_response import ListHDWalletXPubYPubZPubTransactions422Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_transactions_r import ListHDWalletXPubYPubZPubTransactionsR
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_utxos400_response import ListHDWalletXPubYPubZPubUTXOs400Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_utxos401_response import ListHDWalletXPubYPubZPubUTXOs401Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_utxos403_response import ListHDWalletXPubYPubZPubUTXOs403Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_utxos422_response import ListHDWalletXPubYPubZPubUTXOs422Response
from cryptoapis.model.list_hd_wallet_x_pub_y_pub_z_pub_utxos_r import ListHDWalletXPubYPubZPubUTXOsR
from cryptoapis.model.list_synced_addresses400_response import ListSyncedAddresses400Response
from cryptoapis.model.list_synced_addresses401_response import ListSyncedAddresses401Response
from cryptoapis.model.list_synced_addresses403_response import ListSyncedAddresses403Response
from cryptoapis.model.list_synced_addresses_r import ListSyncedAddressesR
from cryptoapis.model.prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub400_response import PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPub400Response
from cryptoapis.model.prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub401_response import PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPub401Response
from cryptoapis.model.prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub403_response import PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPub403Response
from cryptoapis.model.prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_r import PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubR
from cryptoapis.model.prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb import PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubRB
from cryptoapis.model.prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub400_response import PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPub400Response
from cryptoapis.model.prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub401_response import PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPub401Response
from cryptoapis.model.prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub403_response import PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPub403Response
from cryptoapis.model.prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_r import PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubR
from cryptoapis.model.prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb import PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubRB
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub400_response import SyncHDWalletXPubYPubZPub400Response
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub401_response import SyncHDWalletXPubYPubZPub401Response
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub403_response import SyncHDWalletXPubYPubZPub403Response
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub409_response import SyncHDWalletXPubYPubZPub409Response
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub422_response import SyncHDWalletXPubYPubZPub422Response
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub_r import SyncHDWalletXPubYPubZPubR
from cryptoapis.model.sync_hd_wallet_x_pub_y_pub_z_pub_rb import SyncHDWalletXPubYPubZPubRB
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub400_response import SyncNewHDWalletXPubYPubZPub400Response
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub401_response import SyncNewHDWalletXPubYPubZPub401Response
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub403_response import SyncNewHDWalletXPubYPubZPub403Response
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub409_response import SyncNewHDWalletXPubYPubZPub409Response
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub422_response import SyncNewHDWalletXPubYPubZPub422Response
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub_r import SyncNewHDWalletXPubYPubZPubR
from cryptoapis.model.sync_new_hd_wallet_x_pub_y_pub_z_pub_rb import SyncNewHDWalletXPubYPubZPubRB


class HDWalletsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.derive_and_sync_new_change_addresses_endpoint = _Endpoint(
            settings={
                'response_type': (DeriveAndSyncNewChangeAddressesR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/derive-sync-change',
                'operation_id': 'derive_and_sync_new_change_addresses',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'derive_and_sync_new_change_addresses_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derive_and_sync_new_change_addresses_rb':
                        (DeriveAndSyncNewChangeAddressesRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derive_and_sync_new_change_addresses_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.derive_and_sync_new_receiving_addresses_endpoint = _Endpoint(
            settings={
                'response_type': (DeriveAndSyncNewReceivingAddressesR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/derive-and-sync',
                'operation_id': 'derive_and_sync_new_receiving_addresses',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'derive_and_sync_new_receiving_addresses_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derive_and_sync_new_receiving_addresses_rb':
                        (DeriveAndSyncNewReceivingAddressesRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derive_and_sync_new_receiving_addresses_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_hd_wallet__x_pub_y_pub_z_pub_assets_endpoint = _Endpoint(
            settings={
                'response_type': (GetHDWalletXPubYPubZPubAssetsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/assets',
                'operation_id': 'get_hd_wallet__x_pub_y_pub_z_pub_assets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                    'context',
                    'derivation',
                ],
                'required': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'derivation',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ZCASH": "zcash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "XRP": "xrp"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                    ('derivation',): {

                        "ACCOUNT": "account",
                        "BIP32": "bip32"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'extended_public_key':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derivation':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'extended_public_key': 'extendedPublicKey',
                    'network': 'network',
                    'context': 'context',
                    'derivation': 'derivation',
                },
                'location_map': {
                    'blockchain': 'path',
                    'extended_public_key': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derivation': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_hd_wallet__x_pub_y_pub_z_pub_details_endpoint = _Endpoint(
            settings={
                'response_type': (GetHDWalletXPubYPubZPubDetailsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details',
                'operation_id': 'get_hd_wallet__x_pub_y_pub_z_pub_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                    'context',
                    'derivation',
                ],
                'required': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'derivation',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ZCASH": "zcash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "XRP": "xrp"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                    ('derivation',): {

                        "ACCOUNT": "account",
                        "BIP32": "bip32"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'extended_public_key':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derivation':
                        (str,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'extended_public_key': 'extendedPublicKey',
                    'network': 'network',
                    'context': 'context',
                    'derivation': 'derivation',
                },
                'location_map': {
                    'blockchain': 'path',
                    'extended_public_key': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derivation': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_hd_wallet__x_pub_y_pub_z_pub_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (ListHDWalletXPubYPubZPubTransactionsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions',
                'operation_id': 'list_hd_wallet__x_pub_y_pub_z_pub_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                    'context',
                    'derivation',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'derivation',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ZCASH": "zcash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "XRP": "xrp"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                    ('derivation',): {

                        "ACCOUNT": "account",
                        "BIP32": "bip32"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'extended_public_key':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derivation':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'extended_public_key': 'extendedPublicKey',
                    'network': 'network',
                    'context': 'context',
                    'derivation': 'derivation',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'extended_public_key': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derivation': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_hd_wallet__x_pub_y_pub_z_pub_utxos_endpoint = _Endpoint(
            settings={
                'response_type': (ListHDWalletXPubYPubZPubUTXOsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/utxos',
                'operation_id': 'list_hd_wallet__x_pub_y_pub_z_pub_utxos',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                    'context',
                    'derivation',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'derivation',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ZCASH": "zcash"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet"
                    },
                    ('derivation',): {

                        "ACCOUNT": "account",
                        "BIP32": "bip32"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'extended_public_key':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'derivation':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'extended_public_key': 'extendedPublicKey',
                    'network': 'network',
                    'context': 'context',
                    'derivation': 'derivation',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'extended_public_key': 'path',
                    'network': 'path',
                    'context': 'query',
                    'derivation': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_synced_addresses_endpoint = _Endpoint(
            settings={
                'response_type': (ListSyncedAddressesR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/synced-addresses',
                'operation_id': 'list_synced_addresses',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                    'context',
                    'address_format',
                    'is_change_address',
                    'limit',
                    'offset',
                ],
                'required': [
                    'blockchain',
                    'extended_public_key',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                    'address_format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                    ('address_format',): {

                        "P2PKH": "p2pkh",
                        "P2SH": "p2sh",
                        "P2WPKH": "p2wpkh",
                        "P2PKH-CASH": "p2pkh-cash",
                        "P2SH-CASH": "p2sh-cash",
                        "STANDARD": "standard",
                        "CLASSIC": "classic"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'extended_public_key':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'address_format':
                        (str,),
                    'is_change_address':
                        (bool,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'extended_public_key': 'extendedPublicKey',
                    'network': 'network',
                    'context': 'context',
                    'address_format': 'addressFormat',
                    'is_change_address': 'isChangeAddress',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'blockchain': 'path',
                    'extended_public_key': 'path',
                    'network': 'path',
                    'context': 'query',
                    'address_format': 'query',
                    'is_change_address': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.prepare_a_utxo_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub_endpoint = _Endpoint(
            settings={
                'response_type': (PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/transactions/prepare-utxo-transaction',
                'operation_id': 'prepare_a_utxo_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin"
                    },
                    ('network',): {

                        "TESTNET": "testnet",
                        "MAINNET": "mainnet"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb':
                        (PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.prepare_an_account_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub_endpoint = _Endpoint(
            settings={
                'response_type': (PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/transactions/prepare-account-based-transaction',
                'operation_id': 'prepare_an_account_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "ETHEREUM": "ethereum"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb':
                        (PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.sync_hd_wallet__x_pub_y_pub_z_pub_endpoint = _Endpoint(
            settings={
                'response_type': (SyncHDWalletXPubYPubZPubR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/sync',
                'operation_id': 'sync_hd_wallet__x_pub_y_pub_z_pub',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'sync_hd_wallet_x_pub_y_pub_z_pub_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "BITCOIN-CASH": "bitcoin-cash",
                        "LITECOIN": "litecoin",
                        "DOGECOIN": "dogecoin",
                        "DASH": "dash",
                        "ETHEREUM": "ethereum",
                        "ZCASH": "zcash",
                        "ETHEREUM-CLASSIC": "ethereum-classic",
                        "BINANCE-SMART-CHAIN": "binance-smart-chain",
                        "XRP": "xrp"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "MORDOR": "mordor",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'sync_hd_wallet_x_pub_y_pub_z_pub_rb':
                        (SyncHDWalletXPubYPubZPubRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'sync_hd_wallet_x_pub_y_pub_z_pub_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.sync_new_hd_wallet__x_pub_y_pub_z_pub_endpoint = _Endpoint(
            settings={
                'response_type': (SyncNewHDWalletXPubYPubZPubR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/blockchain-data/{blockchain}/{network}/hd/sync-new',
                'operation_id': 'sync_new_hd_wallet__x_pub_y_pub_z_pub',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'blockchain',
                    'network',
                    'context',
                    'sync_new_hd_wallet_x_pub_y_pub_z_pub_rb',
                ],
                'required': [
                    'blockchain',
                    'network',
                ],
                'nullable': [
                ],
                'enum': [
                    'blockchain',
                    'network',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('blockchain',): {

                        "BITCOIN": "bitcoin",
                        "ETHEREUM": "ethereum"
                    },
                    ('network',): {

                        "MAINNET": "mainnet",
                        "TESTNET": "testnet",
                        "GOERLI": "goerli"
                    },
                },
                'openapi_types': {
                    'blockchain':
                        (str,),
                    'network':
                        (str,),
                    'context':
                        (str,),
                    'sync_new_hd_wallet_x_pub_y_pub_z_pub_rb':
                        (SyncNewHDWalletXPubYPubZPubRB,),
                },
                'attribute_map': {
                    'blockchain': 'blockchain',
                    'network': 'network',
                    'context': 'context',
                },
                'location_map': {
                    'blockchain': 'path',
                    'network': 'path',
                    'context': 'query',
                    'sync_new_hd_wallet_x_pub_y_pub_z_pub_rb': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def derive_and_sync_new_change_addresses(
        self,
        network,
        blockchain="bitcoin",
        **kwargs
    ):
        """Derive And Sync New Change Addresses  # noqa: E501

        Through this endpoint users can derive 100 change addresses, starting from the last index we have data for, which are then added to the xPub, subscribed for syncing, and start recording data. If no data is available, it will start from index 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.derive_and_sync_new_change_addresses(network, blockchain="bitcoin", async_req=True)
        >>> result = thread.get()

        Args:
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.. defaults to "bitcoin", must be one of ["bitcoin"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derive_and_sync_new_change_addresses_rb (DeriveAndSyncNewChangeAddressesRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeriveAndSyncNewChangeAddressesR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.derive_and_sync_new_change_addresses_endpoint.call_with_http_info(**kwargs)

    def derive_and_sync_new_receiving_addresses(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Derive And Sync New Receiving Addresses  # noqa: E501

        Through this endpoint users can derive 100 receiving addresses, starting from the last index we have data for, which are then added to the xPub, subscribed for syncing, and start recording data. If no data is available, it will start from index 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.derive_and_sync_new_receiving_addresses(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derive_and_sync_new_receiving_addresses_rb (DeriveAndSyncNewReceivingAddressesRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeriveAndSyncNewReceivingAddressesR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.derive_and_sync_new_receiving_addresses_endpoint.call_with_http_info(**kwargs)

    def get_hd_wallet__x_pub_y_pub_z_pub_assets(
        self,
        blockchain,
        extended_public_key,
        network,
        **kwargs
    ):
        """Get HD Wallet (xPub, yPub, zPub) Assets  # noqa: E501

        This endpoint will return details on assets we support for a specified from the customer extended public key (xPub). These could be cryptocurrencies, fungible or non-fungible (NFT) tokens. Each asset has a unique identifier - assetId, and a unique symbol in the form of a string, e.g. \"USDT\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hd_wallet__x_pub_y_pub_z_pub_assets(blockchain, extended_public_key, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            extended_public_key (str): Defines the account extended publicly known key which is used to derive all child public keys.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derivation (str): The way how the HD walled derives, for example when the type is ACCOUNT, it derives change and receive addresses while when the type is BIP32 it derives directly.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetHDWalletXPubYPubZPubAssetsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['extended_public_key'] = \
            extended_public_key
        kwargs['network'] = \
            network
        return self.get_hd_wallet__x_pub_y_pub_z_pub_assets_endpoint.call_with_http_info(**kwargs)

    def get_hd_wallet__x_pub_y_pub_z_pub_details(
        self,
        blockchain,
        extended_public_key,
        network,
        **kwargs
    ):
        """Get HD Wallet (xPub, yPub, zPub) Details  # noqa: E501

        HD wallet details is useful endpoint to get the most important data about HD wallet without the need to do a lot of calculations, once the HD Wallet is synced using Sync endpoint we keep it up to date and we calculate these details in advance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hd_wallet__x_pub_y_pub_z_pub_details(blockchain, extended_public_key, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            extended_public_key (str): Defines the account extended publicly known key which is used to derive all child public keys.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derivation (str): The way how the HD walled derives, for example when the type is ACCOUNT, it derives change and receive addresses while when the type is BIP32 it derives directly.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetHDWalletXPubYPubZPubDetailsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['extended_public_key'] = \
            extended_public_key
        kwargs['network'] = \
            network
        return self.get_hd_wallet__x_pub_y_pub_z_pub_details_endpoint.call_with_http_info(**kwargs)

    def list_hd_wallet__x_pub_y_pub_z_pub_transactions(
        self,
        blockchain,
        extended_public_key,
        network,
        **kwargs
    ):
        """List HD Wallet (xPub, yPub, zPub) Transactions  # noqa: E501

        This endpoint will list HD Wallet transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_hd_wallet__x_pub_y_pub_z_pub_transactions(blockchain, extended_public_key, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain.
            extended_public_key (str): Defines the master public key (xPub) of the account.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derivation (str): The way how the HD walled derives, for example when the type is ACCOUNT, it derives change and receive addresses while when the type is BIP32 it derives directly.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListHDWalletXPubYPubZPubTransactionsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['extended_public_key'] = \
            extended_public_key
        kwargs['network'] = \
            network
        return self.list_hd_wallet__x_pub_y_pub_z_pub_transactions_endpoint.call_with_http_info(**kwargs)

    def list_hd_wallet__x_pub_y_pub_z_pub_utxos(
        self,
        blockchain,
        extended_public_key,
        network,
        **kwargs
    ):
        """List HD Wallet (xPub, yPub, zPub) UTXOs  # noqa: E501

        Through this endpoint you can list HD wallet's UTXOs (Unspent Transaction Outputs) by providing extended public key of an already synced HD wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_hd_wallet__x_pub_y_pub_z_pub_utxos(blockchain, extended_public_key, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            extended_public_key (str): Defines the account extended publicly known key which is used to derive all child public keys.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            derivation (str): The way how the HD walled derives, for example when the type is ACCOUNT, it derives change and receive addresses while when the type is BIP32 it derives directly.. [optional]
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListHDWalletXPubYPubZPubUTXOsR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['extended_public_key'] = \
            extended_public_key
        kwargs['network'] = \
            network
        return self.list_hd_wallet__x_pub_y_pub_z_pub_utxos_endpoint.call_with_http_info(**kwargs)

    def list_synced_addresses(
        self,
        blockchain,
        extended_public_key,
        network,
        **kwargs
    ):
        """List Synced Addresses  # noqa: E501

        Through this endpoint users can list all addresses that Crypto APIs has synced for a specific xPub. This includes previous and current/new xPubs, what addresses we’ve synced for them, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_synced_addresses(blockchain, extended_public_key, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            extended_public_key (str): Defines the account extended publicly known key which is used to derive all child public keys.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            address_format (str): Defines the address format value.. [optional]
            is_change_address (bool): Defines if the address is change addres or not.. [optional] if omitted the server will use the default value of True
            limit (int): Defines how many items should be returned in the response per page basis.. [optional] if omitted the server will use the default value of 50
            offset (int): The starting index of the response items, i.e. where the response should start listing the returned items.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListSyncedAddressesR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['extended_public_key'] = \
            extended_public_key
        kwargs['network'] = \
            network
        return self.list_synced_addresses_endpoint.call_with_http_info(**kwargs)

    def prepare_a_utxo_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub(
        self,
        network,
        blockchain="bitcoin",
        **kwargs
    ):
        """Prepare A UTXO-Based Transaction From HD Wallet (xPub, yPub, zPub)  # noqa: E501

        Through the “Prepare a UTXO-based transaction from xPub” endpoint users can prepare a transaction for signing from all synced with Crypto APIs addresses for the specific xPub. This is based on the `selectionStrategy` and the addresses’ balances. In the case a user has an address not synced with Crypto APIs, it will not be included. This endpoint applies to all supported UTXO-based blockchain protocols, e.g. Bitcoin, Litecoin, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prepare_a_utxo_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub(network, blockchain="bitcoin", async_req=True)
        >>> result = thread.get()

        Args:
            network (str):
            blockchain (str): defaults to "bitcoin", must be one of ["bitcoin"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            prepare_autxo_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb (PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PrepareAUTXOBasedTransactionFromHDWalletXPubYPubZPubR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.prepare_a_utxo_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub_endpoint.call_with_http_info(**kwargs)

    def prepare_an_account_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub(
        self,
        network,
        blockchain="ethereum",
        **kwargs
    ):
        """Prepare An Account-Based Transaction From HD Wallet (xPub, yPub, zPub)  # noqa: E501

        Through the “Prepare an account-based transaction from xPub” endpoint users can prepare a transaction for signing from a synced with Crypto APIs address from the specific xPub. This endpoint applies to all supported account-based blockchain protocols, e.g. Ethereum, BSC, etc  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prepare_an_account_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub(network, blockchain="ethereum", async_req=True)
        >>> result = thread.get()

        Args:
            network (str):
            blockchain (str): defaults to "ethereum", must be one of ["ethereum"]

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            prepare_an_account_based_transaction_from_hd_wallet_x_pub_y_pub_z_pub_rb (PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PrepareAnAccountBasedTransactionFromHDWalletXPubYPubZPubR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.prepare_an_account_based_transaction_from_hd_wallet__x_pub_y_pub_z_pub_endpoint.call_with_http_info(**kwargs)

    def sync_hd_wallet__x_pub_y_pub_z_pub(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Sync HD Wallet (xPub, yPub, zPub)  # noqa: E501

        HD wallets usually have a lot of addresses and transactions, getting the data on demand is a heavy operation. That's why we have created this feature, to be able to get HD wallet details or transactions this HD wallet must be synced first. In addition to the initial sync we keep updating the synced HD wallets all the time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sync_hd_wallet__x_pub_y_pub_z_pub(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            sync_hd_wallet_x_pub_y_pub_z_pub_rb (SyncHDWalletXPubYPubZPubRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SyncHDWalletXPubYPubZPubR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.sync_hd_wallet__x_pub_y_pub_z_pub_endpoint.call_with_http_info(**kwargs)

    def sync_new_hd_wallet__x_pub_y_pub_z_pub(
        self,
        blockchain,
        network,
        **kwargs
    ):
        """Sync New HD Wallet (xPub, yPub, zPub)  # noqa: E501

        Through this endpoint users can add a brand new xPub to the Crypto APIs system to be ready for deriving. Unlike our other similar endpoint “Sync HD Wallet (xPub, yPub, zPub)”, this endpoint does not create new addresses nor syncs old data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sync_new_hd_wallet__x_pub_y_pub_z_pub(blockchain, network, async_req=True)
        >>> result = thread.get()

        Args:
            blockchain (str): Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.
            network (str): Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\" are test networks.

        Keyword Args:
            context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
            sync_new_hd_wallet_x_pub_y_pub_z_pub_rb (SyncNewHDWalletXPubYPubZPubRB): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SyncNewHDWalletXPubYPubZPubR
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['blockchain'] = \
            blockchain
        kwargs['network'] = \
            network
        return self.sync_new_hd_wallet__x_pub_y_pub_z_pub_endpoint.call_with_http_info(**kwargs)

