#!/usr/bin/env python3
# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

TS_MIN_WEIGHT_ERROR = """
No arms generated by Thompson Sampling had weight > min_weight.
The minimum weight required is {min_weight:2.4}, and the
maximum weight of any arm generated is {max_weight:2.4}.
"""

TS_NO_FEASIBLE_ARMS_ERROR = """
Less than 1% of samples have a feasible arm.
Check your outcome constraints.
"""

CHOLESKY_ERROR_ANNOTATION = (
    "Cholesky errors typically occur when the same or very similar "
    "arms are suggested repeatedly. This can mean the model has "
    "already converged and you should avoid running further trials. "
    "It will also help to convert integer or categorical parameters "
    "to float ranges where reasonable.\nOriginal error: "
)
