# Schema Docs

- [1. [Optional] Property `root > a_gift`](#a_gift)
- [2. [Optional] Property `root > anchor_with_slash`](#anchor_with_slash)
  - [2.1. [Optional] Property `root > anchor_with_slash > propertyA`](#anchor_with_slash_propertyA)
- [3. [Optional] Property `root > anchor_no_slash`](#anchor_no_slash)
  - [3.1. root > anchor_no_slash > items](#autogenerated_heading_2)
- [4. [Optional] Property `root > anchor_nested_reference`](#anchor_nested_reference)
- [5. [Optional] Property `root > same_file_anchor_with_slash`](#same_file_anchor_with_slash)
- [6. [Optional] Property `root > same_file_anchor_no_slash`](#same_file_anchor_no_slash)
- [7. [Optional] Property `root > same_file_nested_reference`](#same_file_nested_reference)
- [8. [Optional] Property `root > other_file_anchor`](#other_file_anchor)
  - [8.1. [Optional] Property `root > other_file_anchor > with_wrap`](#other_file_anchor_with_wrap)
- [9. [Optional] Property `root > other_file_dot_anchor`](#other_file_dot_anchor)
- [10. [Optional] Property `root > other_file_dot_dot_anchor`](#other_file_dot_dot_anchor)
- [11. [Optional] Property `root > other_file_only`](#other_file_only)
  - [11.1. [Required] Property `root > other_file_only > not_a_string`](#other_file_only_not_a_string)
    - [11.1.1. Must **not** be](#autogenerated_heading_3)
- [12. [Optional] Property `root > multi_hierarchy_reference`](#multi_hierarchy_reference)
  - [12.1. [Optional] Property `root > multi_hierarchy_reference > propertyA`](#multi_hierarchy_reference_propertyA)

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

**Description:** Testing $ref

| Property                                                       | Pattern | Type            | Deprecated | Definition                                                              | Title/Description                           |
| -------------------------------------------------------------- | ------- | --------------- | ---------- | ----------------------------------------------------------------------- | ------------------------------------------- |
| - [a_gift](#a_gift )                                           | No      | string          | No         | In #/definitions/gift                                                   | A gift, or is it?                           |
| - [anchor_with_slash](#anchor_with_slash )                     | No      | object          | No         | In #/definitions/object_def                                             | -                                           |
| - [anchor_no_slash](#anchor_no_slash )                         | No      | array of string | No         | In #definitions/array_def                                               | Description for array_def                   |
| - [anchor_nested_reference](#anchor_nested_reference )         | No      | string          | No         | In #/definitions/reference_def                                          | -                                           |
| - [same_file_anchor_with_slash](#same_file_anchor_with_slash ) | No      | string          | No         | In references.json#/definitions/string_def                              | Description for string_def                  |
| - [same_file_anchor_no_slash](#same_file_anchor_no_slash )     | No      | object          | No         | Same as [anchor_with_slash](#anchor_with_slash )                        | -                                           |
| - [same_file_nested_reference](#same_file_nested_reference )   | No      | string          | No         | Same as [anchor_nested_reference](#anchor_nested_reference )            | -                                           |
| - [other_file_anchor](#other_file_anchor )                     | No      | object          | No         | In with_descriptions.json#/definitions/gift                             | The delivery is a gift, no prices displayed |
| - [other_file_dot_anchor](#other_file_dot_anchor )             | No      | object          | No         | Same as [other_file_anchor](#other_file_anchor )                        | The delivery is a gift, no prices displayed |
| - [other_file_dot_dot_anchor](#other_file_dot_dot_anchor )     | No      | object          | No         | Same as [other_file_anchor](#other_file_anchor )                        | The delivery is a gift, no prices displayed |
| - [other_file_only](#other_file_only )                         | No      | object          | No         | In combining_not.json                                                   | Test schema with a not                      |
| - [multi_hierarchy_reference](#multi_hierarchy_reference )     | No      | object          | No         | In reference_schemas/intermediate.json#/properties/cross_file_reference | -                                           |
|                                                                |         |                 |            |                                                                         |                                             |

## <a name="a_gift"></a>1. [Optional] Property `root > a_gift`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/definitions/gift                                                        |
|                           |                                                                           |

**Description:** A gift, or is it?

## <a name="anchor_with_slash"></a>2. [Optional] Property `root > anchor_with_slash`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/definitions/object_def                                                  |
|                           |                                                                           |

| Property                                     | Pattern | Type   | Deprecated | Definition | Title/Description                          |
| -------------------------------------------- | ------- | ------ | ---------- | ---------- | ------------------------------------------ |
| - [propertyA](#anchor_with_slash_propertyA ) | No      | string | No         | -          | Description for object_def/items/propertyA |
|                                              |         |        |            |            |                                            |

### <a name="anchor_with_slash_propertyA"></a>2.1. [Optional] Property `root > anchor_with_slash > propertyA`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

**Description:** Description for object_def/items/propertyA

## <a name="anchor_no_slash"></a>3. [Optional] Property `root > anchor_no_slash`

| Type                      | `array of string`                                                         |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #definitions/array_def                                                    |
|                           |                                                                           |

**Description:** Description for array_def

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |
|                      |                    |

| Each item of this array must be | Description |
| ------------------------------- | ----------- |
| [items](#anchor_no_slash_items) | -           |
|                                 |             |

### <a name="autogenerated_heading_2"></a>3.1. root > anchor_no_slash > items

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

## <a name="anchor_nested_reference"></a>4. [Optional] Property `root > anchor_nested_reference`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/definitions/reference_def                                               |
|                           |                                                                           |

## <a name="same_file_anchor_with_slash"></a>5. [Optional] Property `root > same_file_anchor_with_slash`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | references.json#/definitions/string_def                                   |
|                           |                                                                           |

**Description:** Description for string_def

## <a name="same_file_anchor_no_slash"></a>6. [Optional] Property `root > same_file_anchor_no_slash`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Same definition as**    | [anchor_with_slash](#anchor_with_slash)                                   |
|                           |                                                                           |

## <a name="same_file_nested_reference"></a>7. [Optional] Property `root > same_file_nested_reference`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Same definition as**    | [anchor_nested_reference](#anchor_nested_reference)                       |
|                           |                                                                           |

## <a name="other_file_anchor"></a>8. [Optional] Property `root > other_file_anchor`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | with_descriptions.json#/definitions/gift                                  |
|                           |                                                                           |

**Description:** The delivery is a gift, no prices displayed

| Property                                     | Pattern | Type    | Deprecated | Definition | Title/Description |
| -------------------------------------------- | ------- | ------- | ---------- | ---------- | ----------------- |
| - [with_wrap](#other_file_anchor_with_wrap ) | No      | boolean | No         | -          | -                 |
|                                              |         |         |            |            |                   |

### <a name="other_file_anchor_with_wrap"></a>8.1. [Optional] Property `root > other_file_anchor > with_wrap`

| Type                      | `boolean`                                                                 |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

## <a name="other_file_dot_anchor"></a>9. [Optional] Property `root > other_file_dot_anchor`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Same definition as**    | [other_file_anchor](#other_file_anchor)                                   |
|                           |                                                                           |

**Description:** The delivery is a gift, no prices displayed

## <a name="other_file_dot_dot_anchor"></a>10. [Optional] Property `root > other_file_dot_dot_anchor`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Same definition as**    | [other_file_anchor](#other_file_anchor)                                   |
|                           |                                                                           |

**Description:** The delivery is a gift, no prices displayed

## <a name="other_file_only"></a>11. [Optional] Property `root > other_file_only`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | combining_not.json                                                        |
|                           |                                                                           |

**Description:** Test schema with a not

| Property                                         | Pattern | Type        | Deprecated | Definition | Title/Description |
| ------------------------------------------------ | ------- | ----------- | ---------- | ---------- | ----------------- |
| + [not_a_string](#other_file_only_not_a_string ) | No      | Combination | No         | -          | -                 |
|                                                  |         |             |            |            |                   |

### <a name="other_file_only_not_a_string"></a>11.1. [Required] Property `root > other_file_only > not_a_string`

| Type                      | `combining`                                                               |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

#### <a name="autogenerated_heading_3"></a>11.1.1. Must **not** be

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

## <a name="multi_hierarchy_reference"></a>12. [Optional] Property `root > multi_hierarchy_reference`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | reference_schemas/intermediate.json#/properties/cross_file_reference      |
|                           |                                                                           |

| Property                                             | Pattern | Type   | Deprecated | Definition | Title/Description                   |
| ---------------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------------------------- |
| - [propertyA](#multi_hierarchy_reference_propertyA ) | No      | string | No         | -          | Contents of propertyA in final.json |
|                                                      |         |        |            |            |                                     |

### <a name="multi_hierarchy_reference_propertyA"></a>12.1. [Optional] Property `root > multi_hierarchy_reference > propertyA`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

**Description:** Contents of propertyA in final.json

----------------------------------------------------------------------------------------------------------------------------
Generated using [json-schema-for-humans](https://github.com/coveooss/json-schema-for-humans) on date