// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../../../utils/classNames';
import Col from '../../../spacing/Col';
import Row from '../../../spacing/Row';
import '../../../../../css/taskpanes/ControlPanel/SortCard.css';
import useSyncedParams from '../../../../hooks/useSyncedParams';
export var SortDirection;
(function (SortDirection) {
    SortDirection["ASCENDING"] = "ascending";
    SortDirection["DESCENDING"] = "descending";
    SortDirection["NONE"] = "none";
})(SortDirection || (SortDirection = {}));
/*
    A modal that allows a user to sort a column
*/
const SortCard = (props) => {
    const { params, setParams } = useSyncedParams(undefined, 'sort', props.mitoAPI, props.analysisData, 0);
    const updateSortDirection = (newSortDirection) => {
        setParams(prevSortParams => {
            // If the user toggled the button that was already selected, turn off the sort
            let finalSortDirection = newSortDirection;
            if (prevSortParams && newSortDirection == prevSortParams.sort_direction) {
                finalSortDirection = SortDirection.NONE;
            }
            return {
                sheet_index: props.selectedSheetIndex,
                column_id: props.columnID,
                sort_direction: finalSortDirection
            };
        });
    };
    // Determine css styling of sort buttons
    const ascendingButtonClass = params && params.sort_direction == SortDirection.ASCENDING ? 'sort-button-selected' : '';
    const descendingButtonClass = params && params.sort_direction == SortDirection.DESCENDING ? 'sort-button-selected' : '';
    return (React.createElement(Row, { justify: 'space-between', align: 'center' },
        React.createElement(Col, { span: 4 },
            React.createElement("p", { className: 'text-header-3' }, "Sort")),
        React.createElement(Col, { offset: 2, flex: '1' },
            React.createElement(Row, { suppressTopBottomMargin: true },
                React.createElement(Col, { flex: '1' },
                    React.createElement("button", { className: classNames('sort-button', ascendingButtonClass), onClick: () => updateSortDirection(SortDirection.ASCENDING) }, "Ascending")),
                React.createElement(Col, { offset: 1, flex: '1' },
                    React.createElement("button", { className: classNames('sort-button', descendingButtonClass), onClick: () => updateSortDirection(SortDirection.DESCENDING) }, "Descending"))))));
};
export default SortCard;
//# sourceMappingURL=SortCard.js.map