# Special code related to the {{place|...} tag used to annotate place names.
#
# Copyright (c) 2018-2020 Tatu Ylonen.  See file LICENSE and https://ylonen.org

# Mapping from place prefixes in {{place|...}} templates to the type of place.
# Administrative divisions
#   - country
#   - province  (e.g. state, territory, prefecture, canton, voivodeship, oblast)
#   - municipality, city  (incl. borough, town, village, community)
# Geographic divisions
#   - space  (a region of space outside a planet, such as a solar system)
#   - planet
#   - continent (a continent on a planet)
#   - region (generally within a continent)
#   - area   (generally smaller than a region)
#   - place  (generally well-defined relatively small area/point)
# Types of geographic formations
#   - archipelago
#   - body-of-water  (includes seas, lakes, rivers)
place_prefixes = {
    "Hui and Tu autonomous county": "municipality",
    "Hui autonomous county": "municipality",
    "Korean autonomous prefecture": "province",
    "P": "province",
    "Tibetan autonomous prefecture": "province",
    "Yi autonomous prefecture": "province",
    "acomm": "municipality",
    "administrative region": "municipality",
    "adr": "municipality",
    "aobl": "province",
    "aokr": "province",
    "ap": "municipality",
    "ar": "archipelago",
    "arch": "archipelago",
    "archipelago": "archipelago",
    "area": "area",
    "arep": "province",
    "aterr": "province",
    "atoll": "island",
    "autonomous community": "municipality",
    "autonomous county": "municipality",
    "autonomous prefecture": "province",
    "autonomous province": "province",
    "autonomous region": "municipality",
    "autonomous republic": "province",
    "autonomous territory": "province",
    "bar": "municipality",
    "barony": "municipality",
    "barrio": "municipality",
    "baryon": "municipality",
    "bay": "body-of-water",
    "bor": "municipality",
    "borough": "municipality",
    "c": "country",
    "c2": "country",
    "can": "province",
    "canton": "province",
    "carea": "municipality",
    "cc": "country",
    "cdblock": "municipality",
    "cdep": "province",
    "cdiv": "municipality",
    "cdp": "municipality",
    "CDP": "municipality",
    "census area": "municipality",
    "city": "city",
    "civil parish": "municipality",
    "co": "municipality",
    "coast": "area",
    "cobor": "municipality",
    "colcity": "city",
    "colony": "province",
    "comarca": "municipality",
    "commune": "municipality",
    "community": "municipality",
    "community development block": "municipality",
    "cont": "continent",
    "continent": "continent",
    "contregion": "region",
    "council area": "municipality",
    "country": "country",
    "county borough": "municipality",
    "county": "municipality",
    "county-level city": "city",
    "cpar": "municipality",
    "cty": "municipality",
    "department": "province",
    "dept": "province",
    "direct-administered municipality": "municipality",
    "direct-administered municipality ": "municipality",
    "dist": "municipality",
    "distmun": "municipality",
    "district": "municipality",
    "district municipality": "municipality",
    "div": "province",
    "emirate": "country",
    "empire": "country",
    "en:continent": "continent",
    "en:country": "country",
    "en:island": "island",
    "en:province": "province",
    "en:state": "province",
    "glen": "village",
    "governorate": "municipality",
    "gulf": "body-of-water",
    "federal subject": "province",
    "forestry district": "area",
    "forest": "area",
    "former township": "municipality",
    "house": "place",
    "hundred": "municipality",
    "i": "island",
    "isl": "island",
    "island": "island",
    "islands": "archipelago",
    "kingdom": "country",
    "krai": "province",
    "lake": "body-of-water",
    "league": "province",
    "lbor": "municipality",
    "lgarea": "area",
    "lgdist": "municipality",
    "lieutenancy area": "municipality",
    "local government district": "municipality",
    "m": "municipality",
    "macroregion": "region",
    "metarea": "municipality",
    "metbor": "municipality",
    "metcity": "city",
    "metropolis": "city",
    "metropolitan borough": "municipality",
    "moor": "municipality",
    "moorland": "municipality",
    "mountain": "place",
    "mountain range": "area",
    "mtn": "place",
    "mun": "municipality",
    "mundist": "municipality",
    "municipality": "municipality",
    "muniplacity": "municipality",
    "neighborhood": "municipality",
    "no": "municipality",
    "obl": "province",
    "oblast": "province",
    "ocean": "body-of-water",
    "overseas department": "province",
    "overseas territory": "province",
    "p": "province",
    "park": "place",
    "par": "municipality",
    "parish": "municipality",
    "pen": "area",
    "penisula": "area",
    "place": "place",
    "planet": "planet",
    "plateau": "area",
    "pref": "province",
    "prefecture": "province",
    "prefecture-level": "city",
    "prefecture-level city": "city",
    "preflcity": "city",
    "prov": "province",
    "prov;": "province",
    "province": "province",
    "r": "region",
    "r:Suf": "region",
    "raion": "municipality",
    "range": "area",
    "rcomun": "municipality",
    "region": "region",
    "regional municipality": "municipality",
    "regional unit": "municipality",
    "rep": "country",
    "republic": "country",
    "rdist": "municipality",
    "riv": "body-of-water",
    "river": "body-of-water",
    "rmun": "municipality",
    "road": "place",
    "robor": "municipality",
    "runit": "municipality",
    "rurmun": "municipality",
    "rural township": "municipality",
    "s": "province",
    "sar": "municipality",
    "sea": "body-of-water",
    "sheading": "municipality",
    "space": "space",
    "special municipality": "municipality",
    "state": "province",
    "strait": "body-of-water",
    "sub": "municipality",
    "sub-prefecture level city": "city",
    "sub-prefecture-level city": "city",
    "sub-provincial city": "city",
    "subdistrict": "municipality",
    "subdiv": "municipality",
    "subprefecture": "province",
    "suburb": "municipality",
    "tehsil": "province",
    "terr": "province",
    "territory": "province",
    "tjarea": "municipality",
    "town": "municipality",
    "township": "municipality",
    "twp": "municipality",
    "uauth": "municipality",
    "unincorporated community": "municipality",
    "union territory": "municipality",
    "unitary authority": "municipality",
    "unorganized territory": "municipality",
    "urban area": "municipality",
    "urban township": "municipality",
    "uterr": "municipality",
    "val": "area",
    "valley": "area",
    "vill": "municipality",
    "village": "municipality",
    "voi": "province",
    "voivodeship": "province",
    "ward": "municipality",
}
