# Maps the type in a head to part-of-speech and tags
#
# Copyright (c) 2020 Tatu Ylonen.  See file LICENSE and https://ylonen.org

head_pos_map = {
    "Han char": "character",
    "Han character": "character",
    "Han characters": "character",
    "abbreviation": "abbrev",
    "abbreviations": "abbrev",
    "acronym": "abbrev",
    "acronyms": "abbrev",
    "adjective comparative form": "adj",
    "adjective comparative forms": "adj",
    "adjective form": "adj",
    "adjective forms": "adj",
    "adjective": "adj",
    "adjectives": "adj",
    "adverb": "adv",
    "adverb comparative form": "adv",
    "adverb comparative forms": "adv",
    "adverb superlative form": "adv",
    "adverb superlative forms": "adv",
    "adverbs": "adv",
    "adverb form": "adv",
    "affix": "affix",
    "affixes": "affix",
    "agent participle": "verb",
    "article form": "article",
    "article forms": "article",
    "article": "article",
    "articles": "article",
    "character": "character",
    "characters": "character",
    "circumfix": "circumfix",
    "circumfixes": "circumfix",
    "classifier": "classifier",
    "classifiers": "classifier",
    "clitic": "clitic",
    "clitics": "clitic",
    "combined form": "verb",
    "combined forms": "verb",
    "combining form": "combining_form",
    "combining forms": "combining_form",
    "comparative adjective": "adj",
    "comparative adjectives": "adj",
    "comparative adjective form": "adj",
    "comparative adverb": "adv",
    "comparative adverb form": "adv",
    "comparative adverbs": "adv",
    "conjunction": "conj",
    "conjunctions": "conj",
    "contraction": "abbrev",
    "contractions": "abbrev",
    "counter": "counter",
    "counters": "counter",
    "determiner form": "det",
    "determiner forms": "det",
    "determiner": "det",
    "determiners": "det",
    "diacritical mark": "symbol",
    "diacritical marks": "symbol",
    "gerund": "verb",
    "gerunds": "verb",
    "glyph": "character",
    "glyphs": "glyph",
    "idioms": "phrase",
    "infinitive": "verb",
    "infinitives": "verb",
    "infix": "infix",
    "infixes": "infix",
    "initialism": "abbrev",
    "initialisms": "abbrev",
    "interfix": "interfix",
    "interfix": "interfix",
    "interjection": "intj",
    "interjections": "intj",
    "kanji": "character",
    "letter": "letter",
    "letters": "letter",
    "ligature": "symbol",
    "ligatures": "symbol",
    "logogram": "symbol",
    "misconstruction": "misspelling",
    "misspelling": "misspelling",
    "misspellings": "misspelling",
    "mutated adjective": "adj",
    "mutated adjectives": "adj",
    "mutated noun": "noun",
    "mutated nouns": "noun",
    "mutated verb": "verb",
    "mutated verbs": "verb",
    "negative participle": "verb",
    "non-constituent": "intj",
    "non-constituents": "intj",
    "noun form": "noun",
    "noun forms": "noun",
    "noun plural form": "noun",
    "noun plural forms": "noun",
    "noun possessive form": "noun",
    "noun": "noun",
    "nouns": "noun",
    "number": "num",
    "numbers": "num",
    "numeral symbol": "num",
    "numeral symbols": "num",
    "numeral": "num",
    "numerals": "num",
    "numeral form": "num",
    "obsolete verb form": "verb",
    "obsolete verb forms": "verb",
    "participle form": "verb",
    "participle forms": "verb",
    "participle": "verb",
    "participles": "verb",
    "particle form": "particle",
    "particle forms": "particle",
    "particle": "particle",
    "particles": "particle",
    "past active participle": "verb",
    "past passive participle": "verb",
    "past participle form": "verb",
    "past participle forms": "verb",
    "past participle": "verb",
    "past participles": "verb",
    "phrase": "phrase",
    "phrases": "phrase",
    "postposition": "postp",
    "postposition form": "postp",
    "postpositions": "postp",
    "prefix": "prefix",
    "prefixes": "prefix",
    "preposition": "prep",
    "prepositional phrase": "phrase",
    "prepositional phrases": "phrase",
    "prepositional pronoun": "pron",  # XXX or preposition?
    "prepositional pronouns": "pron",
    "prepositions": "prep",
    "present active participle": "verb",
    "present passive participle": "verb",
    "present participle form": "verb",
    "present participle forms": "verb",
    "present participle": "verb",
    "present participles": "verb",
    "pronominal adverb": "adv",
    "pronominal adverbs": "adv",
    "pronoun form": "pron",
    "pronoun forms": "pron",
    "pronoun": "pron",
    "pronoun": "pron",
    "pronouns": "pron",
    "pronouns": "pron",
    "proper noun form": "name",
    "proper noun forms": "name",
    "proper noun plural form": "name",
    "proper noun plural forms": "name",
    "proper noun": "name",
    "proper nouns": "name",
    "proverb": "proverb",
    "proverbs": "proverb",
    "punctuation mark": "punct",
    "punctuation marks": "punct",
    "punctuation": "punct",
    "punctuations": "punct",
    "suffix form": "suffix",
    "suffix forms": "suffix",
    "suffix": "suffix",
    "suffixes": "suffix",
    "superlative adjective": "adj",
    "superlative adjectives": "adj",
    "superlative adjective form": "adj",
    "superlative adverb": "adv",
    "superlative adverb form": "adv",
    "superlative adverbs": "adv",
    "syllable": "syllable",
    "syllables": "syllable",
    "symbol": "symbol",
    "symbols": "symbol",
    "verb form": "verb",
    "verb forms": "verb",
    "verb": "verb",
    "verbs": "verb",
}
