"use strict";
(self["webpackChunkjupyterlab_optumi"] = self["webpackChunkjupyterlab_optumi"] || []).push([["lib_index_js"],{

/***/ "./lib/Colors.js":
/*!***********************!*\
  !*** ./lib/Colors.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Colors": () => (/* binding */ Colors)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
// Network: #10A0F9
// Disk: #00c650
// Swap: #575A4B
// RAM: #ba9fd1
// CPU: #f48f8d
// vRAM: #964A71
// GPU: #ffba7d
class Colors {
}
// All these colors need to be hex colors, since we sometimes add an alpha channel by appending 2 characters
// TODO:JJ Change these places to use the alpha() MUI function
Colors.refresh = null;
Colors.PRIMARY = '#10A0F9';
Colors.SECONDARY = '#afaab0';
Colors.ERROR = '#f48f8d';
Colors.WARNING = '#ffba7d';
Colors.SUCCESS = '#00c650';
Colors.DISABLED = '#89858b';
Colors.NETWORK = '#88AFFF';
Colors.DISK = '#ADEBAD';
Colors.SWAP = '#FEED85';
Colors.RAM = '#BA9FCF';
Colors.CPU = '#F48F8D';
Colors.VRAM = '#B9C7E3';
Colors.GPU = '#FFBA7D';
Colors.CHIP_GREY = '#989898';


/***/ }),

/***/ "./lib/Global.js":
/*!***********************!*\
  !*** ./lib/Global.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DIV": () => (/* binding */ DIV),
/* harmony export */   "Global": () => (/* binding */ Global),
/* harmony export */   "LI": () => (/* binding */ LI),
/* harmony export */   "P": () => (/* binding */ P),
/* harmony export */   "PRE": () => (/* binding */ PRE),
/* harmony export */   "PermanentPopup": () => (/* binding */ PermanentPopup),
/* harmony export */   "SPAN": () => (/* binding */ SPAN),
/* harmony export */   "SkinnyButton": () => (/* binding */ SkinnyButton),
/* harmony export */   "StyledAccordion": () => (/* binding */ StyledAccordion),
/* harmony export */   "StyledAccordionDetails": () => (/* binding */ StyledAccordionDetails),
/* harmony export */   "StyledAccordionSummary": () => (/* binding */ StyledAccordionSummary),
/* harmony export */   "StyledMenuItem": () => (/* binding */ StyledMenuItem),
/* harmony export */   "StyledSelect": () => (/* binding */ StyledSelect),
/* harmony export */   "TEXTAREA": () => (/* binding */ TEXTAREA),
/* harmony export */   "UL": () => (/* binding */ UL),
/* harmony export */   "WhiteTextButton": () => (/* binding */ WhiteTextButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/system */ "./node_modules/@mui/system/esm/Box/Box.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _models_OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./models/OptumiMetadataTracker */ "./lib/models/OptumiMetadataTracker.js");
/* harmony import */ var _models_machine_Machine__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./models/machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_4__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};








class Global {
    /**
     * This will change the view of the extension to show the specified target
     * @param target which target to open to
     */
    static async followLink(target) {
        // If things start failing all of a sudden, the solution may be to have the links
        // only return once the setState has returned (the optional callback)
        // If we have a parent, fun their link method first
        if (target.parent)
            await Global.followLink(target.parent);
        // Force javascript to context switch away to allow the dom to update and
        // child link methods to be initialized before we call them
        await new Promise(resolve => resolve(0));
        // Call link if it exists, and wait for it if it is asynchronous
        if (target.link)
            Promise.resolve(target.link());
    }
    /**
     * Initialize a target with a method to achieve that view
     * @param target the target to setup
     * @param link the method to be run to change the view to the target
     */
    static setLink(target, link) {
        target.link = link;
        for (const [key, value] of Object.entries(target)) {
            if (key === 'parent' || key === 'link')
                continue;
            // This code will run for all child targets under 'target'
            value.parent = target;
        }
    }
    /**
     * Deletes the method to change to this view, presumably because the component unmounted
     * @param target the target to delete
     */
    static deleteLink(target) {
        delete target.link;
        // we don't delete out children's parent because their great grandparent may be the
        // only one actually mounted, and we need to be able to find them
    }
    /**
     * Helpful function for removing all links specified under a target
     * @param target the target to delete under
     */
    static deleteLinksUnder(target) {
        for (const [key, value] of Object.entries(target)) {
            if (key === 'parent' || key === 'link')
                continue;
            // This code will run for all child targets under 'target'
            Global.deleteLink(value);
        }
    }
    static get version() { return Global._version; }
    static set version(version) {
        Global._version = version;
        if (Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        Global._onVersionSet.emit(version);
    }
    static get isDevVersion() { return Global._version.toLocaleLowerCase().includes('dev'); }
    static get onVersionSet() { return Global._onVersionSet; }
    static getStringWidth(text, font) {
        if (text == "" || text == undefined)
            return 0;
        // re-use canvas object for better performance
        var context = this.canvas.getContext("2d");
        context.font = font;
        var metrics = context.measureText(text + ' ');
        return metrics.width + 1;
    }
    static get shouldLogOnRender() { return Global._shouldLogOnRender; }
    static __setShouldLogOnRender(shouldLogOnRender) {
        Global._shouldLogOnRender = shouldLogOnRender;
        return 'shouldLogOnRender is now set to ' + Global._shouldLogOnRender;
    }
    static get shouldLogOnEmit() { return Global._shouldLogOnEmit; }
    static __setShouldLogOnEmit(shouldLogOnEmit) {
        Global._shouldLogOnEmit = shouldLogOnEmit;
        return 'shouldLogOnEmit is now set to ' + Global._shouldLogOnEmit;
    }
    static get shouldLogOnPoll() { return Global._shouldLogOnPoll; }
    static __setShouldLogOnPoll(shouldLogOnPoll) {
        Global._shouldLogOnPoll = shouldLogOnPoll;
        return 'shouldLogOnPoll is now set to ' + Global._shouldLogOnPoll;
    }
    static get shouldLogOnSafeSetState() { return Global._shouldLogOnSafeSetState; }
    static __setShouldLogOnSafeSetState(shouldLogOnSafeSetState) {
        Global._shouldLogOnSafeSetState = shouldLogOnSafeSetState;
        return 'shouldLogOnSafeSetState is now set to ' + Global._shouldLogOnSafeSetState;
    }
    static get inQuestionMode() { return Global._inQuestionMode; }
    static set inQuestionMode(inQuestionMode) {
        Global._inQuestionMode = inQuestionMode;
        if (Global.shouldLogOnEmit)
            console.log('SignalEmit (' + new Date().getSeconds() + ')');
        Global._onInQuestionModeChange.emit(inQuestionMode);
    }
    static get jobLaunched() { return Global._jobLaunched; }
    static get onInQuestionModeChange() { return Global._onInQuestionModeChange; }
    static get lab() { return Global._lab; }
    static set lab(lab) { Global._lab = lab; }
    static get labShell() { return Global._labShell; }
    static set labShell(labShell) { Global._labShell = labShell; }
    static get themeManager() { return Global._themeManager; }
    static set themeManager(themeManager) { Global._themeManager = themeManager; }
    static get tracker() { return Global._tracker; }
    static set tracker(tracker) { Global._tracker = tracker; }
    static get metadata() { return Global._metadata; }
    static set metadata(metadata) {
        Global._metadata = metadata;
        // if (Global._metadata.getMetadata().metadata.version === 'DEV') {
        //     (window as any).setShouldLogOnRender = Global.__setShouldLogOnRender;
        //     (window as any).setShouldLogOnEmit = Global.__setShouldLogOnEmit;
        //     (window as any).setShouldLogOnPoll = Global.__setShouldLogOnPoll;
        //     (window as any).setShouldLogOnSafeSetState = Global.__setShouldLogOnSafeSetState;
        // } else {
        //     (window as any).setShouldLogOnRender = undefined;
        //     (window as any).setShouldLogOnEmit = undefined;
        //     (window as any).setShouldLogOnPoll = undefined;
        //     (window as any).setShouldLogOnSafeSetState = undefined;
        // }
    }
    static get docManager() { return Global._docManager; }
    static set docManager(docManager) { Global._docManager = docManager; }
    static get user() { return Global._user; }
    static set user(user) {
        if (user == null && this._user != null) {
            this._user.fileTracker.stopPolling();
            this._user.fileChecker.stop();
            this._user.appTracker.stopPolling();
            this._metadata = null;
            this.snackbarClose.emit(null);
            if (Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            Global._onNullUser.emit(null);
            Global.labShell.collapseLeft();
            Global.labShell.collapseRight();
        }
        // Always create a new metadata tracker
        // TODO:JJ:NOW The user is not yet null, but the user is logged out, so initializing a new metadata tracker causes problems
        this._metadata = new _models_OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_5__.OptumiMetadataTracker(this._tracker, user == null);
        setTimeout(() => {
            Global._user = user;
            // Reset 401 counter
            Global.consecutive401s = 0;
            // Reset cached info
            Global.lastMachineRate = 0;
            Global.lastCreditsBalance = 0;
            Global.lastIntegrations = [];
            Global.lastMachine = new _models_machine_Machine__WEBPACK_IMPORTED_MODULE_6__.NoMachine();
            if (user != null && !user.unsignedAgreement) {
                // Refresh the metadata before continuing with the login
                this._metadata.refreshMetadata().then(() => {
                    // Wait to signal the change until the metadata has been set properly
                    if (Global.shouldLogOnEmit)
                        console.log('SignalEmit (' + new Date().getSeconds() + ')');
                    Global._onUserChange.emit(user);
                });
            }
            Global._onUserChange.emit(user);
        }, 1000);
    }
    static get onNullUser() { return Global._onNullUser; }
    static get onUserChange() { return Global._onUserChange; }
}
// The members in Target can be for dependency (we must switch to the deploy tab before switching to expert mode) or they
// can be for organization (the settings popup doesn't do anything to prep its children, but it makes it easier to read)
Global.Target = {
    SettingsPopup: {
        PreferencesTab: {},
        LimitsTab: {},
        IntegrationsTab: {},
        StorageTab: {},
        BillingTab: {},
    },
    DeployTab: {
        PackagesAccordion: {},
        FilesAccordion: {
            UploadPopup: {},
            ConnectorPopup: {},
        },
        NotificationsPopup: {},
        LaunchAccordion: {
            SessionMode: {},
            JobMode: {},
        },
        BasicMode: {},
        ExpertMode: {},
    },
    MonitorTab: {},
    MachinesTab: {},
};
Global.bounceAnimation = 'all 333ms cubic-bezier(0.33, 1.33, 0.66, 1) 0s';
Global.easeAnimation = 'all 150ms ease 0s';
Global.MAX_UPLOAD_SIZE = 5 * 1024 * 1024 * 1024;
// Which public stripe key we are using
Global.stripe_key = 
// "pk_test_51HIzv8LdDawhowJuVhTKv6KRnt72In8txUs0Dss0eT4KgFFcRfQlkWEDX9kzhAeiTjiYbxgxRvKbR6TfSJcqiD4o00irQVFdtY";
"pk_live_51HIzv8LdDawhowJuSfMFb1yBW8F9VfK87tSAfMF2UdwTNVdaixpy7xjYUcP6d5GGWs1bDfLGEexyjbYj0dkKHJac00HMDHWhxU";
Global.emitter = new Global();
Global._version = undefined;
Global.userHome = undefined;
Global.jupyterHome = undefined;
Global.convertJupyterPathToOptumiPath = (path) => {
    return (Global.jupyterHome + '/' + path).replace(Global.userHome, '~');
};
Global.convertOptumiPathToJupyterPath = (path) => {
    return path.replace('~', Global.userHome).replace(Global.jupyterHome + '/', '');
};
Global._onVersionSet = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.canvas = document.createElement("canvas");
Global._shouldLogOnRender = false;
Global._shouldLogOnEmit = false;
Global._shouldLogOnPoll = false;
Global._shouldLogOnSafeSetState = false;
Global._inQuestionMode = false;
Global._jobLaunched = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global._onInQuestionModeChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global._lab = undefined;
Global._labShell = undefined;
Global._themeManager = undefined;
Global._tracker = undefined;
Global._metadata = undefined;
Global._docManager = undefined;
Global._user = null; // If we are logged in we will have a user, otherwise it will be null
Global._onNullUser = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global._onUserChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.snackbarEnqueue = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.snackbarClose = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.dataConnectorChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.environmentVariableChange = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.forcePackageIntoView = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(Global.emitter);
Global.lastForceCompleted = true;
// We will keep some state here to avoid having no information to show before a request returns
Global.lastMachineRate = 0;
Global.lastCreditsBalance = 0;
Global.lastIntegrations = [];
Global.lastMachine = new _models_machine_Machine__WEBPACK_IMPORTED_MODULE_6__.NoMachine();
Global.packagesAccordionExpanded = false;
Global.environmentVariablesAccordionExpanded = false;
Global.filesAccordionExpanded = false;
Global.launchModeAccordionExpanded = false;
Global.expertModeSelected = false;
Global.dismissalTimeout = 1.44e+7;
Global.consecutive401s = 0;
// This function will update the consecutive 401s properly and throw exceptions if the request failed
Global.handleResponse = (response, ignore = false) => {
    if (response.status == 401 || response.status == 503) {
        Global.consecutive401s++;
        if (Global.consecutive401s > 5) {
            if (Global.user != null)
                Global.user = null;
        }
        throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
    }
    else {
        if (response.status != 204 && !ignore)
            Global.consecutive401s = 0;
        if (response.status >= 300)
            throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
    }
};
const StyledSelect = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        fontSize: "var(--jp-ui-font-size1)",
    },
    iconOutlined: {
        right: '0px'
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Select);
const StyledMenuItem = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        justifyContent: 'center',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.MenuItem);
const StyledAccordion = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        borderWidth: '0px',
        '&.Mui-expanded': {
            margin: '0px',
        },
        '&:before': {
            backgroundColor: 'unset',
        },
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Accordion);
const StyledAccordionSummary = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        cursor: 'default !important',
        padding: '0px',
        minHeight: '0px',
        '&.Mui-expanded': {
            minHeight: '0px',
        },
    },
    content: {
        margin: '0px',
        '&.Mui-expanded': {
            margin: '0px',
        },
    },
    expandIcon: {
        padding: '0px',
        marginRight: '0px',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.AccordionSummary);
const StyledAccordionDetails = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        display: 'flex',
        flexDirection: 'column',
        padding: '0px',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.AccordionDetails);
const WhiteTextButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        color: '#ffffff',
        '&:hover': {
            backgroundColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.alpha)('#ffffff', 0.25)
        },
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button);
const SkinnyButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)({
    root: {
        height: '20px',
        padding: '0px 6px',
        fontSize: '12px',
        lineHeight: '12px',
        minWidth: '0px',
    },
    label: {
        height: '20px',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button);
const PermanentPopup = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_4__.withStyles)((theme) => ({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
        minWidth: '640px',
    },
}))(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Dialog);
class BOX extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    render() {
        const _a = this.props, { children, innerRef } = _a, other = __rest(_a, ["children", "innerRef"]);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_system__WEBPACK_IMPORTED_MODULE_7__["default"], Object.assign({ ref: innerRef }, other), children));
    }
}
class DIV extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'div' }, this.props));
    }
}
class LI extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'li' }, this.props));
    }
}
class P extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'p' }, this.props));
    }
}
class PRE extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'pre' }, this.props));
    }
}
class SPAN extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'span' }, this.props));
    }
}
class UL extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'ul' }, this.props));
    }
}
class TEXTAREA extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => react__WEBPACK_IMPORTED_MODULE_0__.createElement(BOX, Object.assign({ component: 'textarea' }, this.props));
    }
}


/***/ }),

/***/ "./lib/components/Agreement.js":
/*!*************************************!*\
  !*** ./lib/components/Agreement.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Agreement": () => (/* binding */ Agreement)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Agreement extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Log out of the REST interface (Copied from SettingsPage aside from setState call)
        this.logout = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/logout";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user = null;
                this.safeSetState({ open: false });
            });
        };
        this.acceptAgreement = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/sign-agreement";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    timeOfSigning: new Date().toISOString(),
                }),
            };
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
                return response.text();
            }).then((body) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.unsignedAgreement = false;
                this.props.callback();
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { className: 'jp-optumi-logo' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        display: 'flex',
                        flexFlow: 'column',
                        overflow: 'hidden',
                        height: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            padding: '0px',
                            flexGrow: 1,
                            // overflowY: 'auto',
                            overflowY: 'hidden',
                            whiteSpace: 'pre-wrap',
                            backgroundColor: 'white'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("embed", { type: "text/html", src: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.agreementURL, style: { pointerEvents: 'none' }, height: '100%', width: '100%' })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Checkbox, { checked: this.state.agreed, color: 'primary', onClick: () => this.safeSetState({ agreed: !this.state.agreed }), sx: {
                                padding: '6px',
                                margin: '0px',
                                flexGrow: 1,
                            } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                                padding: '6px',
                                margin: 'auto',
                                flexGrow: 1,
                                fontWeight: 'bold',
                                lineHeight: '12px'
                            } }, "I have read and I agree to the Optumi Terms and Conditions of Service")),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '6px', display: 'flex', justifyContent: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.logout, color: 'secondary', sx: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "Logout"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.acceptAgreement, color: 'primary', variant: 'contained', disabled: !this.state.agreed, sx: {
                                padding: '9px',
                                fontWeight: 'bold',
                                fontSize: '14px',
                                lineHeight: '14px',
                                margin: '0px',
                                flexGrow: 1,
                            } }, "I accept")))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            agreed: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/ChipPopper.js":
/*!**************************************!*\
  !*** ./lib/components/ChipPopper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChipPopper": () => (/* binding */ ChipPopper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/system */ "./node_modules/@mui/system/esm/colorManipulator.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core_Popper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/Popper */ "./lib/core/Popper.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







class ChipPopper extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.close = () => { };
        this.stopPropagation = () => { };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const description = this.props.getHeaderDescription();
            const modified = description != 'Any';
            const jpLayoutColor2 = getComputedStyle(document.documentElement).getPropertyValue('--jp-layout-color2').trim();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_Popper__WEBPACK_IMPORTED_MODULE_5__.Popper, { color: this.props.color, onOpen: () => this.safeSetState({ open: true }), onClose: () => this.safeSetState({ open: false }), close: (close) => this.close = close, stopPropagation: (stopPropagation) => this.stopPropagation = stopPropagation, button: react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledChip, { key: this.props.title + 'chip', sx: Object.assign({
                        color: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.theme) ? (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.darken)(modified ? this.props.color : jpLayoutColor2, 0.35) : (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.lighten)(modified ? this.props.color : jpLayoutColor2, 0.35),
                        backgroundColor: modified ? (0,_mui_system__WEBPACK_IMPORTED_MODULE_6__.alpha)(this.props.color, 0.25) : 'var(--jp-layout-color2)' + ' !important'
                    }, this.props.sx), label: this.props.getChipDescription ? this.props.getChipDescription() : this.props.title + ': ' + this.props.getHeaderDescription(), icon: (modified ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: {
                            padding: 0.25,
                            marginTop: -0.25,
                            marginRight: -0.75,
                            marginBottom: -0.25,
                            marginLeft: -0.25,
                            zIndex: 1,
                        }, onClick: () => {
                            this.props.clearValue();
                            this.stopPropagation();
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: { height: '14px', width: '14px', color: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.theme) ? (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.darken)(modified ? this.props.color : jpLayoutColor2, 0.35) : (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.lighten)(modified ? this.props.color : jpLayoutColor2, 0.35) } }))) : this.state.open ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.KeyboardArrowUp, { sx: { height: '14px', width: '14px' } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.KeyboardArrowDown, { sx: { height: '14px', width: '14px' } }))) }), popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        display: 'flex',
                        flexDirection: 'column',
                        margin: 1,
                        fontSize: '15px',
                        lineHeight: '15px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { fontWeight: 'bold' } },
                            this.props.title,
                            ":"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { whiteSpace: 'pre' } }, ` ${description}`),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: '100%' } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: { padding: 0.5, margin: -0.5 }, onClick: this.close },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: { width: '15px', height: '15px' } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { fontSize: '14px' } }, this.props.popperContent)) }));
        };
        this.handleThemeChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            open: false,
        };
        this.StyledChip = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)(theme => ({
            root: {
                height: '20px',
                fontSize: '12px',
                // borderWidth: '2px',
                // borderStyle: 'solid',
                transition: 'all 300ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                transitionProperty: 'background-color',
                '&:active': {
                    boxShadow: 'none',
                }
            },
            icon: {
                position: 'absolute',
                right: theme.spacing(0.75),
            },
            label: {
                position: 'absolute',
                left: theme.spacing(0.5),
                padding: theme.spacing(0),
            },
            clickable: {
                '&:hover': {
                    filter: 'brightness(0.95)',
                    transition: 'filter 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms'
                },
            },
        }))(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip);
    }
}


/***/ }),

/***/ "./lib/components/ChipSlider.js":
/*!**************************************!*\
  !*** ./lib/components/ChipSlider.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChipSlider": () => (/* binding */ ChipSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




var retrievingPreview = false;
var updatePreviewAgain = false;
var latestValue;
class ChipSlider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.close = () => { };
        this.stopPropagation = () => { };
        this.delay = (ms) => { return new Promise(resolve => setTimeout(resolve, ms)); };
        this.slowDownSaveValue = (newValue, bypassLimiter) => {
            if (newValue != null)
                latestValue = newValue;
            if (bypassLimiter || !retrievingPreview) {
                retrievingPreview = true;
                this.delay(100).then(() => {
                    this.props.saveValue(latestValue);
                    if (updatePreviewAgain) {
                        updatePreviewAgain = false;
                        this.slowDownSaveValue(null, true);
                    }
                    else {
                        retrievingPreview = false;
                    }
                }, () => {
                    retrievingPreview = false;
                });
            }
            else {
                updatePreviewAgain = true;
            }
        };
        this.handleChange = async (event, newValue) => {
            if (newValue instanceof Array) {
                const value = [...newValue];
                if (value[0] == this.min)
                    value[0] = -1;
                if (value[1] == this.max)
                    value[1] = -1;
                this.safeSetState({ value: value });
                this.slowDownSaveValue(value);
            }
        };
        this.handleChangeCommitted = async (event, newValue) => {
            if (newValue instanceof Array) {
                const value = [...newValue];
                if (value[0] == this.min)
                    value[0] = -1;
                if (value[1] == this.max)
                    value[1] = -1;
                this.safeSetState({ value: value });
                this.props.saveValue(value);
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const value = [...this.state.value];
            if (value[0] == -1)
                value[0] = this.min;
            if (value[1] == -1)
                value[1] = this.max;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: Object.assign({ marginTop: '12px' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { mx: 0.5, my: 0, height: '18px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSlider, { value: value, min: this.min, max: this.max, step: this.props.step, marks: this.props.marks, onChange: this.handleChange, onChangeCommitted: this.handleChangeCommitted, disabled: this.props.disabled })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'inline-flex', width: '100%', marginTop: '12px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1, textAlign: 'left', fontSize: '13px', color: 'text.disabled' } }, `${this.props.styleValue(this.min)} ${this.props.styleUnit(this.min)}`),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1, textAlign: 'center' } }, `${this.props.label}`),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1, textAlign: 'right', fontSize: '13px', color: 'text.disabled' } }, `${this.props.styleValue(this.max)} ${this.props.styleUnit(this.max)}`))));
        };
        this.handleMetadataChanged = () => {
            this.safeSetState({ value: this.props.getValue() });
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChanged);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChanged);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            value: this.props.getValue(),
        };
        this.StyledSlider = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
            root: {
                color: props.color,
                padding: '6px 0px',
                height: '6px',
            },
            track: {
                height: '6px',
            },
            rail: {
                height: '6px',
                borderRadius: '0px',
                marginLeft: '1px',
            },
            thumb: {
                height: '18px',
                width: '18px',
                '&:focus, &:hover, &$active': {
                    boxShadow: '0px 0px 0px 7px ' + props.color + '29',
                },
                '&.Mui-disabled': {
                    width: '12px',
                    height: '12px',
                    // marginTop: '-3px',
                    // marginLeft: '-6px',
                }
            },
            mark: {
                marginTop: '1px',
                width: '2px',
                height: '4px',
                borderRadius: '0px',
                top: '45%',
            }
        })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Slider);
        this.min = this.props.marks ? this.props.marks[0].value : this.props.min;
        this.max = this.props.marks ? this.props.marks[this.props.marks.length - 1].value : this.props.max;
    }
}


/***/ }),

/***/ "./lib/components/DeployPage.js":
/*!**************************************!*\
  !*** ./lib/components/DeployPage.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeployPage": () => (/* binding */ DeployPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _deploy_PreviewLaunchButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./deploy/PreviewLaunchButton */ "./lib/components/deploy/PreviewLaunchButton.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core */ "./lib/core/IntentSlider.js");
/* harmony import */ var _deploy_FilesPanel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./deploy/FilesPanel */ "./lib/components/deploy/FilesPanel.js");
/* harmony import */ var _deploy_resources_ResourcesPanel__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./deploy/resources/ResourcesPanel */ "./lib/components/deploy/resources/ResourcesPanel.js");
/* harmony import */ var _deploy_resources_LaunchMode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./deploy/resources/LaunchMode */ "./lib/components/deploy/resources/LaunchMode.js");
/* harmony import */ var react_card_flip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-card-flip */ "webpack/sharing/consume/default/react-card-flip/react-card-flip");
/* harmony import */ var react_card_flip__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_card_flip__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/










// import { PackageNotification } from './submit/PackageNotification';


class DeployPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const flipCardHeader = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.SubHeader, { title: 'Resource selection' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.SPAN, { sx: {
                        margin: 'auto 8px',
                        flexGrow: 1,
                        textAlign: 'end',
                        opacity: 0.5,
                        transitionDuration: '217ms',
                        whiteSpace: 'nowrap',
                        fontSize: '12px',
                        fontStyle: 'italic',
                    } }, this.state.isFlipped ? 'expert' : 'basic'),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                        // // We want to set the metadata back to the last history suggestion
                        // // TODO:JJ This doesn't always work for some reason
                        // setTimeout(() => {
                        // 	const pack = Global.metadata.getLastPackage();
                        // 	if (pack) {
                        // 		const optumi = Global.metadata.getMetadata();
                        // 		optumi.config = pack.optimizedConfig;
                        // 		Global.metadata.setMetadata(optumi);
                        // 	}
                        // }, 250);
                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.expertModeSelected = !this.state.isFlipped;
                        this.safeSetState({ isFlipped: !this.state.isFlipped });
                    }, sx: { padding: '0px', marginRight: '-3px', width: '30px', height: '30px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Flip, { sx: { height: '20px' } }))));
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: Object.assign({ overflow: 'auto' }, this.props.sx) }, ((_Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentWidget instanceof _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__.NotebookPanel) && (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentWidget != null) && (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentWidget.context.isReady)) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata == undefined || _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadata() == undefined ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: Object.assign({ display: 'flex', flexFlow: 'column', overflow: 'hidden' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { flexGrow: 1, overflowY: 'auto', padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { textAlign: 'center', margin: '12px' } }, "Fetching configuration...")))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { padding: '6px 10px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_FilesPanel__WEBPACK_IMPORTED_MODULE_7__.FilesPanel, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_resources_LaunchMode__WEBPACK_IMPORTED_MODULE_8__.LaunchMode, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement((react_card_flip__WEBPACK_IMPORTED_MODULE_4___default()), { cardStyles: { front: { transformStyle: 'flat' }, back: { transformStyle: 'flat' } }, isFlipped: this.state.isFlipped, flipSpeedBackToFront: 0.3, flipSpeedFrontToBack: 0.3 },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            flipCardHeader,
                            !this.state.isFlipped && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_PreviewLaunchButton__WEBPACK_IMPORTED_MODULE_9__.PreviewLaunchButton, { key: 'preview-launch', balance: this.props.balance })))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            flipCardHeader,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_resources_ResourcesPanel__WEBPACK_IMPORTED_MODULE_10__.ResourcesPanel, null),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_11__.IntentSlider, { color: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.PRIMARY, getValue: this.getValue, saveValue: this.saveValue }),
                            this.state.isFlipped && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_PreviewLaunchButton__WEBPACK_IMPORTED_MODULE_9__.PreviewLaunchButton, { key: 'preview-launch', balance: this.props.balance })))))))))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { textAlign: 'center', padding: "16px" } }, "Open a notebook to get started..."))));
        };
        this.handleLabShellChange = () => this.forceUpdate();
        this.handleTrackerChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.handlePackageChange = () => this.forceUpdate();
        this.handleUserChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.BasicMode, () => {
                this.safeSetState({ isFlipped: false });
                _Global__WEBPACK_IMPORTED_MODULE_5__.Global.expertModeSelected = false;
            });
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.ExpertMode, () => {
                this.safeSetState({ isFlipped: true });
                _Global__WEBPACK_IMPORTED_MODULE_5__.Global.expertModeSelected = true;
            });
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentChanged.connect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentChanged.connect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.selectionChanged.connect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            // Global.metadata.getPackageChanged().connect(this.handlePackageChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.connect(this.handleUserChange);
            this.handleUserChange();
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentChanged.disconnect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.selectionChanged.disconnect(this.handleTrackerChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            // Global.metadata.getPackageChanged().disconnect(this.handlePackageChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.BasicMode);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.ExpertMode);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentWidget != null) {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.tracker.currentWidget.context.ready.then(() => { if (this._isMounted)
                this.forceUpdate(); });
        }
        this.state = {
            isFlipped: _Global__WEBPACK_IMPORTED_MODULE_5__.Global.expertModeSelected,
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.config.intent;
    }
    async saveValue(intent) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.intent = intent;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/EgressBuckets.js":
/*!*****************************************!*\
  !*** ./lib/components/EgressBuckets.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EgressBuckets": () => (/* binding */ EgressBuckets)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class EgressBuckets extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%', justifyContent: 'center' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { sx: { width: 'fit-content', margin: '6px auto' }, title: "Egress" }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%', justifyContent: 'center' } }, this.props.buckets.map((bucket, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        width: '115px',
                        textAlign: 'center',
                        padding: '12px',
                        margin: index == 0 ? '6px 0px 6px 6px' : (index == this.props.buckets.length - 1 ? '6px 6px 6px 0px' : '6px 0px'),
                        border: '1px solid ' + _Colors__WEBPACK_IMPORTED_MODULE_3__.Colors.SECONDARY,
                        borderRadius: index == 0 ? '6px 0px 0px 6px' : (index == this.props.buckets.length - 1 ? '0px 6px 6px 0px' : '0px'),
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { color: _Colors__WEBPACK_IMPORTED_MODULE_3__.Colors.PRIMARY, fontSize: '20px', fontWeight: 'bold' } }, bucket.cost == 0 ? 'Free' : '$' + bucket.cost),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, null, 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__["default"].styleCapacityUnitValue()(bucket.limit))))))));
        };
        // public shouldComponentUpdate = (nextProps: IProps, nextState: IState): boolean => {
        //     try {
        //         if (JSON.stringify(this.props) != JSON.stringify(nextProps)) return true;
        //         if (JSON.stringify(this.state) != JSON.stringify(nextState)) return true;
        //         if (Global.shouldLogOnRender) console.log('SuppressedRender (' + new Date().getSeconds() + ')');
        //         return false;
        //     } catch (error) {
        //         return true;
        //     }
        // }
    }
}


/***/ }),

/***/ "./lib/components/FileExtensionIcon.js":
/*!*********************************************!*\
  !*** ./lib/components/FileExtensionIcon.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FileExtensionIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const fileTypes = [
    { extension: '.aac', icon: undefined },
    { extension: '.abw', icon: undefined },
    { extension: '.arc', icon: undefined },
    { extension: '.avi', icon: undefined },
    { extension: '.azw', icon: undefined },
    { extension: '.bin', icon: undefined },
    { extension: '.bmp', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.bz', icon: undefined },
    { extension: '.bz2', icon: undefined },
    { extension: '.csh', icon: undefined },
    { extension: '.css', icon: undefined },
    { extension: '.csv', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.doc', icon: undefined },
    { extension: '.docx', icon: undefined },
    { extension: '.eot', icon: undefined },
    { extension: '.gz', icon: undefined },
    { extension: '.gif', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.html', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.html5Icon.react, { display: 'block' }), alternativeExtensions: ['.htm'] },
    { extension: '.ico', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.ics', icon: undefined },
    { extension: '.ipynb', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.notebookIcon.react, { display: 'block' }) },
    { extension: '.jar', icon: undefined },
    { extension: '.jpeg', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.jpg'] },
    { extension: '.js', icon: undefined },
    { extension: '.json', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.jsonIcon.react, { display: 'block' }) },
    { extension: '.md', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.markdownIcon.react, { display: 'block' }) },
    { extension: '.midi', icon: undefined, alternativeExtensions: ['.mid'] },
    { extension: '.mjs', icon: undefined },
    { extension: '.mp3', icon: undefined },
    { extension: '.mpeg', icon: undefined },
    { extension: '.odp', icon: undefined },
    { extension: '.ods', icon: undefined },
    { extension: '.odt', icon: undefined },
    { extension: '.oga', icon: undefined },
    { extension: '.ogv', icon: undefined },
    { extension: '.ogx', icon: undefined },
    { extension: '.opus', icon: undefined },
    { extension: '.otf', icon: undefined },
    { extension: '.png', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.pdf', icon: undefined },
    { extension: '.php', icon: undefined },
    { extension: '.ppt', icon: undefined },
    { extension: '.pptx', icon: undefined },
    { extension: '.py', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.pythonIcon.react, { display: 'block' }) },
    { extension: '.rar', icon: undefined },
    { extension: '.rtf', icon: undefined },
    { extension: '.sh', icon: undefined },
    { extension: '.svg', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.swf', icon: undefined },
    { extension: '.tar', icon: undefined },
    { extension: '.tiff', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.tif'] },
    { extension: '.ts', icon: undefined },
    { extension: '.ttf', icon: undefined },
    { extension: '.txt', icon: undefined },
    { extension: '.vsd', icon: undefined },
    { extension: '.wav', icon: undefined },
    { extension: '.woff', icon: undefined },
    { extension: '.woff2', icon: undefined },
    { extension: '.xhtml', icon: undefined },
    { extension: '.xls', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xlsx', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xml', icon: undefined, alternativeExtensions: undefined },
    { extension: '.xul', icon: undefined },
    { extension: '.yaml', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.yamlIcon.react, { display: 'block' }), alternativeExtensions: ['.yml'] },
    { extension: '.zip', icon: undefined },
    { extension: '.3gp', icon: undefined, alternativeExtensions: undefined },
    { extension: '.3g2', icon: undefined, alternativeExtensions: undefined },
    { extension: '.7z', icon: undefined },
];
class FileExtensionIcon extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const extension = '.' + this.props.path.split('.').pop();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-itemIcon' }, (() => {
                for (const fileType of fileTypes) {
                    if (fileType.extension === extension)
                        return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                    if (fileType.alternativeExtensions !== undefined) {
                        for (const alternativeExtension of fileType.alternativeExtensions) {
                            if (alternativeExtension === extension)
                                return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                        }
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
            })()));
        };
    }
}


/***/ }),

/***/ "./lib/components/FileTree.js":
/*!************************************!*\
  !*** ./lib/components/FileTree.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileTree": () => (/* binding */ FileTree)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/lab */ "webpack/sharing/consume/default/@mui/lab/@mui/lab");
/* harmony import */ var _mui_lab__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_lab__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _FileExtensionIcon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./FileExtensionIcon */ "./lib/components/FileExtensionIcon.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/










const fileTitle = (file) => ('Name: ' + file.metadata[0].name + '\n' +
    (file.metadata[0].size === null ? '' : 'Size: ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(file.metadata[0].size) + (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.isDevVersion ? ' (' + file.metadata[0].size + ' bytes)' : '') + '\n') +
    (file.metadata[0].path === '' ? '' : 'Path: ' + file.metadata[0].path.replace(file.metadata[0].name, '').replace(/\/$/, '') + '\n') +
    'Modified: ' + file.metadata.map(x => moment__WEBPACK_IMPORTED_MODULE_4___default()(x.last_modified).format('YYYY-MM-DD hh:mm:ss')).join(', '));
class FileTree extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.renderTreeItems = (files) => {
            const generateTreeStructure = () => {
                const generatePathStructure = (metadata, path, file) => {
                    var startedWithSquiggleSlash = false;
                    if (file.startsWith('~/')) {
                        file = file.replace('~/', '');
                        startedWithSquiggleSlash = true;
                    }
                    let parts = file.split(/(?<=^\/?[^\/]+)(?=\/)/);
                    if (parts.length > 1) {
                        return {
                            path: path,
                            file: (startedWithSquiggleSlash ? '~/' : '') + parts[0],
                            children: [generatePathStructure(metadata, (startedWithSquiggleSlash ? '~/' : '') + path + parts[0], parts[1])]
                        };
                    }
                    else {
                        return { path: path, file: (startedWithSquiggleSlash ? '~/' : '') + file, metadata: [metadata] };
                    }
                };
                const mergePathStructure = (treeStructure, pathStructure) => {
                    if (treeStructure.children === undefined) {
                        treeStructure.children = [pathStructure];
                        return treeStructure;
                    }
                    else if (pathStructure.children === undefined) {
                        treeStructure.children.push(pathStructure);
                        return treeStructure;
                    }
                    else {
                        for (let i = 0; i < treeStructure.children.length; i++) {
                            let child = treeStructure.children[i];
                            if (child.file === pathStructure.file) {
                                treeStructure.children[i] = mergePathStructure(child, pathStructure.children[0]);
                                return treeStructure;
                            }
                        }
                        treeStructure.children.push(pathStructure);
                        return treeStructure;
                    }
                };
                let treeStructure = { path: '', file: '', children: [] };
                for (let file of files) {
                    let pathStructure = generatePathStructure(file, '', file.path);
                    treeStructure = mergePathStructure(treeStructure, pathStructure);
                }
                return treeStructure;
            };
            const collapseTreeStructure = (structure) => {
                if (structure.children === undefined) {
                    return structure;
                }
                else if (structure.children.length === 1) {
                    let child = structure.children[0];
                    structure.file += child.file;
                    structure.metadata = child.metadata;
                    structure.children = child.children;
                    return collapseTreeStructure(structure);
                }
                else {
                    for (let i = 0; i < structure.children.length; i++) {
                        structure.children[i] = collapseTreeStructure(structure.children[i]);
                    }
                    return structure;
                }
            };
            const combineTreeStructure = (structure) => {
                const newChildren = [];
                // Combine multiple children that are the same file
                if (structure.children) {
                    for (let child of structure.children) {
                        var match = false;
                        for (let newChild of newChildren) {
                            if (child.metadata && newChild.metadata && newChild.metadata[0].path == child.metadata[0].path) {
                                newChild.metadata.push(child.metadata[0]);
                                match = true;
                                break;
                            }
                        }
                        if (!match)
                            newChildren.push(child);
                    }
                    for (let child of newChildren) {
                        if (child.metadata)
                            child.metadata.sort(_utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_8__["default"].sortFiles);
                    }
                    // Update the children in the structure
                    structure.children = newChildren;
                    // Call this recursively for children
                    for (let i = 0; i < structure.children.length; i++) {
                        structure.children[i] = combineTreeStructure(structure.children[i]);
                    }
                }
                return structure;
            };
            const renderTreeStructure = (structure, includeSlash) => {
                let hasChildren = structure.children && structure.children.length > 1;
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(FileTreeItem, { structure: structure, includeSlash: includeSlash, includeReferences: false, title: hasChildren ? ('') : (fileTitle(structure)), hidableIcon: hasChildren ? (this.props.directoryHidableIcon ? this.props.directoryHidableIcon(structure) : undefined) : (this.props.fileHidableIcon ? this.props.fileHidableIcon(structure) : undefined) }, hasChildren ? structure.children.map((child) => renderTreeStructure(child, false)) : []));
            };
            let structure = combineTreeStructure(generateTreeStructure());
            return Array.isArray(structure.children) ? (structure.children.map((child) => renderTreeStructure(collapseTreeStructure(child), true))) : undefined;
        };
        this.i = 0;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const key = (this.i++).toString();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_lab__WEBPACK_IMPORTED_MODULE_1__.TreeView, { key: key, disableSelection: true, defaultCollapseIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.ExpandMore, null), defaultExpandIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.ChevronRight, null), expanded: this.state.expanded, onNodeToggle: (event, nodeIds) => {
                    this.setState({ expanded: nodeIds });
                } }, this.renderTreeItems(this.props.files)));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            expanded: [],
        };
    }
}
FileTree.childrenToMetadata = (directory, includeDuplicateHashes = true) => {
    const metadata = [];
    for (let child of directory.children) {
        if (child.children) {
            metadata.push(...FileTree.childrenToMetadata(child, includeDuplicateHashes));
        }
        else {
            if (includeDuplicateHashes) {
                metadata.push(...child.metadata);
            }
            else {
                metadata.push(child.metadata[0]);
            }
        }
    }
    return metadata;
};
const INITIAL_SIZE = 10;
const PAGE_SIZE = 100;
class FileTreeItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            var _a;
            if (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const structure = this.props.structure;
            const nodeId = structure.path + " " + structure.file + " " + ((_a = structure.metadata) === null || _a === void 0 ? void 0 : _a.length) + " " + (structure.metadata && structure.metadata.length > 0 ? structure.metadata[0].hash : '');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_7__.DIV, { key: nodeId, sx: { display: 'flex', width: '100%', position: 'relative' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledTreeItem, { nodeId: nodeId, endIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FileExtensionIcon__WEBPACK_IMPORTED_MODULE_9__["default"], { path: structure.file }), label: (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_7__.DIV, { onMouseOver: () => this.safeSetState({ hovered: true }), onMouseOut: () => this.safeSetState({ hovered: false }), title: this.props.title, sx: {
                            height: '34px',
                            lineHeight: '34px',
                            flexGrow: 1,
                            fontSize: 'var(--jp-ui-font-size1)',
                            fontFamily: 'var(--jp-ui-font-family)',
                            overflowX: 'hidden',
                            whiteSpace: 'nowrap',
                            textOverflow: 'ellipsis',
                        } },
                        structure.file.replace(this.props.includeSlash ? '' : /^\//, '') /*+ (hasChildren ? '/' : '')*/,
                        this.props.includeReferences && structure.metadata && structure.metadata.length > 1 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_7__.SPAN, { sx: { marginLeft: '6px', opacity: '0.5' } }, 'is referenced by ' + structure.metadata.length + ' workloads')))) }, this.state.visibleChildren.length == 0 ? undefined : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    this.state.visibleChildren,
                    this.props.children.length > INITIAL_SIZE && ((this.state.currentPage * PAGE_SIZE) + INITIAL_SIZE < this.props.children.length) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_5__.Button, { sx: { flexGrow: 1 }, onClick: () => {
                            const newPage = this.state.currentPage + 1;
                            this.setState({ currentPage: newPage, visibleChildren: this.props.children.slice(0, (newPage * PAGE_SIZE) + INITIAL_SIZE) });
                        } }, "Show more"))))),
                this.props.hidableIcon && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_7__.DIV, { sx: {
                        display: 'inline-flex',
                        position: 'absolute',
                        right: '0px',
                        opacity: this.state.hovered ? 1 : 0,
                        transition: 'opacity 300ms ease-in-out'
                    }, onMouseOver: () => this.safeSetState({ hovered: true }), onMouseOut: () => this.safeSetState({ hovered: false }) }, this.props.hidableIcon)),
                structure.metadata && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_7__.DIV, { sx: {
                        display: 'inline-flex',
                        position: 'absolute',
                        right: '12px',
                        opacity: this.state.hovered ? 0 : 0.5,
                        transition: 'opacity 300ms ease-in-out',
                        lineHeight: '36px',
                        fontSize: 'var(--jp-ui-font-size1)',
                        pointerEvents: 'none'
                    } }, moment__WEBPACK_IMPORTED_MODULE_4___default()(structure.metadata[0].last_modified).fromNow()))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_7__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.StyledTreeItem = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
            root: {
                width: '100%',
            },
            label: {
                display: 'flex',
                width: 'calc(100% - 19px)',
                alignItems: 'center',
            }
        })(_mui_lab__WEBPACK_IMPORTED_MODULE_1__.TreeItem);
        this.state = {
            hovered: false,
            visibleChildren: this.props.children.slice(0, INITIAL_SIZE),
            currentPage: 0,
        };
    }
}


/***/ }),

/***/ "./lib/components/InfoSkirt.js":
/*!*************************************!*\
  !*** ./lib/components/InfoSkirt.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InfoSkirt": () => (/* binding */ InfoSkirt)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class InfoSkirt extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 1, sx: Object.assign({
                    width: '100%',
                    padding: '3px',
                    backgroundColor: 'var(--jp-layout-color2)',
                    borderRadius: '3px',
                }, this.props.sx), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            width: '100%',
                            margin: '3px 0px 3px 3px',
                            overflow: 'hidden',
                        } }, this.props.children),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            display: 'inline-flex',
                            minWidth: this.props.leftButton && this.props.rightButton ? '82px' : '50px',
                            margin: '10px 3px 0px 0px',
                        } },
                        this.props.leftButton && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { margin: this.props.rightButton ? 'auto 0 auto auto' : '0px 10px 0px 4px' } }, this.props.leftButton)),
                        this.props.rightButton && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { margin: this.props.leftButton ? 'auto auto auto 0' : '0px 4px 0px 10px' } }, this.props.rightButton)))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                        display: 'inline-flex',
                        flexWrap: 'wrap',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            display: 'inline-flex',
                            flexGrow: 1,
                        } }, this.props.tags.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            minWidth: '74px',
                            height: '20px',
                        } })) : (this.props.tags)))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/LaunchSkirt.js":
/*!***************************************!*\
  !*** ./lib/components/LaunchSkirt.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LaunchSkirt": () => (/* binding */ LaunchSkirt)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class LaunchSkirt extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 1, sx: Object.assign({
                    width: '100%',
                    padding: '3px',
                    backgroundColor: 'var(--jp-layout-color2)',
                    borderRadius: '3px',
                }, this.props.sx), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                        display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            width: '100%',
                            margin: '3px 0px 0px 3px',
                            overflow: 'hidden',
                        } },
                        this.props.children,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                                display: 'inline-flex',
                                flexWrap: 'wrap',
                                width: '100%',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                                    display: 'inline-flex',
                                    flexGrow: 1,
                                    marginTop: '3px',
                                    marginLeft: '-3px',
                                } }, this.props.tags.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                                    minWidth: '74px',
                                    height: '20px',
                                } })) : (this.props.tags)))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            display: 'inline-flex',
                            margin: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { margin: '3px' } }, this.props.launchButton)))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/LeftPanel.js":
/*!*************************************!*\
  !*** ./lib/components/LeftPanel.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptumiLeftPanel": () => (/* binding */ StyledOptumiLeftPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/styled-engine/StyledEngineProvider/StyledEngineProvider.js");
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/system/esm/ThemeProvider/ThemeProvider.js");
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/material/styles/createTheme.js");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _models_User__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../models/User */ "./lib/models/User.js");
/* harmony import */ var _OauthLogin__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./OauthLogin */ "./lib/components/OauthLogin.js");
/* harmony import */ var _Pilot__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Pilot */ "./lib/components/Pilot.js");
/* harmony import */ var _Agreement__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Agreement */ "./lib/components/Agreement.js");
/* harmony import */ var _models_Snackbar__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../models/Snackbar */ "./lib/models/Snackbar.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/













const GlobalThemeDiv = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    '@global': {
        ':root': {
            '--ot-font-family': 'var(--jp-ui-font-family)',
            '--ot-padding': '12px',
            '--ot-padding-half': '6px',
            '--ot-margin': '12px',
            '--ot-margin-half': '6px',
            '--ot-backgroundColor': 'var(--jp-layout-color1)',
            '--ot-backgroundColor-emphasized': 'var(--jp-layout-color2)',
        },
        'button:focus': {
            outline: 'none !important',
        },
        'code': {
            color: 'var(--jp-ui-font-color1) !important',
        },
        'legend': {
            width: 'unset !important',
        }
    }
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box);
class OptumiLeftPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.refresh = () => {
            this.theme = this.getTheme();
            this.forceUpdate();
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { backgroundColor: 'var(--jp-layout-color1)', height: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(GlobalThemeDiv, { component: 'div', sx: {
                        height: '100%',
                        display: 'flex',
                        flexFlow: 'column',
                        overflow: 'hidden',
                        color: 'var(--jp-ui-font-color1)',
                        backgroundColor: 'var(--jp-layout-color1)',
                        fontSize: 'var(--jp-ui-font-size1)',
                        fontFamily: 'var(--jp-ui-font-family)',
                        margin: '0px auto',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CssBaseline, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_styles__WEBPACK_IMPORTED_MODULE_6__["default"], { injectFirst: true },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_styles__WEBPACK_IMPORTED_MODULE_7__["default"], { theme: this.theme },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(notistack__WEBPACK_IMPORTED_MODULE_4__.SnackbarProvider, { maxSnack: 5, domRoot: this.domRoot, classes: {
                                    variantSuccess: this.props.classes.success,
                                    variantError: this.props.classes.error,
                                    variantWarning: this.props.classes.warning,
                                    variantInfo: this.props.classes.info,
                                } }, this.state.initialized ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.state.loggedIn && _Global__WEBPACK_IMPORTED_MODULE_5__.Global.version ?
                                (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.user.unsignedAgreement ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Agreement__WEBPACK_IMPORTED_MODULE_8__.Agreement, { callback: () => {
                                        this.forceUpdate();
                                        // Refresh the metadata before continuing with the login
                                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.metadata.refreshMetadata().then(() => {
                                            // Wait to signal the change until the metadata has been set properly
                                            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnEmit)
                                                console.log('SignalEmit (' + new Date().getSeconds() + ')');
                                            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.emit(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.user);
                                        });
                                    } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Pilot__WEBPACK_IMPORTED_MODULE_9__.Pilot, null))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OauthLogin__WEBPACK_IMPORTED_MODULE_10__.OauthLogin, null)))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { className: 'jp-optumi-logo' }),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Container, { style: { textAlign: 'center', display: 'inline-flex', justifyContent: 'center' }, maxWidth: "xs" },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '14px', thickness: 8 }),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { paddingLeft: '6px', lineHeight: '14px' } }, 'Initializing...'))))))))));
        };
        this.getTheme = () => {
            var themeManager = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager;
            return (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_11__["default"])({
                components: {
                    ////
                    /// Button / Icon
                    //
                    MuiButton: {
                        styleOverrides: {
                            root: {
                                textTransform: 'none',
                                fontWeight: 'bold',
                                height: '36px',
                            },
                            colorInherit: {
                                color: 'var(--jp-ui-font-color2)',
                                borderColor: 'var(--jp-border-color1)',
                                '&:hover': {
                                    backgroundColor: 'rgba(0, 0, 0, 0.04)',
                                },
                            },
                        },
                        defaultProps: {
                            color: 'inherit',
                        },
                    },
                    MuiIconButton: {
                        styleOverrides: {
                            root: {
                                color: 'var(--jp-ui-font-color2)',
                            },
                        },
                    },
                    MuiSvgIcon: {
                        styleOverrides: {
                            root: {
                                display: 'flex',
                                margin: 'auto',
                            },
                        },
                    },
                    ////
                    /// Popup
                    //
                    MuiDialog: {
                        styleOverrides: {
                            paper: {
                                backgroundColor: 'var(--jp-layout-color1)',
                                backgroundImage: 'unset',
                            },
                            paperWidthSm: {
                                maxWidth: '650px',
                            },
                        },
                    },
                    MuiDialogTitle: {
                        styleOverrides: {
                            root: {
                                backgroundColor: 'var(--jp-layout-color2)',
                                borderRadius: '4px 4px 0px 0px',
                            },
                        },
                    },
                    ////
                    /// Textbox / Dropdown
                    //
                    MuiOutlinedInput: {
                        styleOverrides: {
                            root: {
                                lineHeight: '1.1876em',
                            },
                        },
                        defaultProps: {
                            inputProps: {
                                spellCheck: 'false',
                            },
                        },
                    },
                    ////
                    /// Misc
                    //
                    MuiTab: {
                        styleOverrides: {
                            root: {
                                color: 'var(--jp-ui-font-color2)',
                                padding: '6px 12px',
                                textTransform: 'none',
                                fontSize: '13px',
                            },
                        },
                    },
                    MuiBadge: {
                        styleOverrides: {
                            badge: {
                                width: '16px',
                                height: '16px',
                                minWidth: '16px',
                                minHeight: '16px',
                                fontSize: '10px',
                                top: '-3px',
                                right: '2px',
                            }
                        }
                    }
                },
                typography: {
                    fontFamily: 'var(--jp-ui-font-family)',
                    h1: { fontSize: 'calc(var(--jp-ui-font-size1) * 2.98598)' },
                    h2: { fontSize: 'calc(var(--jp-ui-font-size1) * 2.48832)' },
                    h3: { fontSize: 'calc(var(--jp-ui-font-size1) * 2.0736)' },
                    h4: { fontSize: 'calc(var(--jp-ui-font-size1) * 1.728)' },
                    h5: { fontSize: 'calc(var(--jp-ui-font-size1) * 1.44)' },
                    h6: { fontSize: 'calc(var(--jp-ui-font-size1) * 1.2)' },
                    subtitle1: { fontSize: 'var(--jp-ui-font-size1)' },
                    subtitle2: { fontSize: 'var(--jp-ui-font-size1)' },
                    body1: { fontSize: 'var(--jp-ui-font-size1)' },
                    body2: { fontSize: 'var(--jp-ui-font-size1)' },
                    button: { fontSize: 'var(--jp-ui-font-size1)' },
                    caption: { fontSize: 'calc(var(--jp-ui-font-size1) * 0.833333)' },
                    overline: { fontSize: 'calc(var(--jp-ui-font-size1) * 0.833333)' }, // pow(1.2, -1)
                },
                palette: {
                    mode: themeManager.theme == null || themeManager.isLight(themeManager.theme) ? 'light' : 'dark',
                    primary: {
                        // light: will be calculated from palette.primary.main,
                        main: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.PRIMARY,
                        // dark: will be calculated from palette.primary.main,
                        // contrastText: will be calculated to contrast with palette.primary.main
                    },
                    secondary: {
                        // light: will be calculated from palette.secondary.main,
                        main: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.SECONDARY,
                        // dark: will be calculated from palette.secondary.main,
                        // contrastText: will be calculated to contrast with palette.secondary.main
                    },
                    error: {
                        // light: will be calculated from palette.error.main,
                        main: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.ERROR,
                        // dark: will be calculated from palette.error.main,
                        // contrastText: will be calculated to contrast with palette.error.main
                    },
                    warning: {
                        main: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.WARNING,
                    },
                    // info: {
                    // },
                    success: {
                        // light: will be calculated from palette.error.main,
                        main: _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.SUCCESS,
                        // dark: will be calculated from palette.error.main,
                        // contrastText: will be calculated to contrast with palette.error.main
                    },
                    // Used by `getContrastText()` to maximize the contrast between
                    // the background and the text.
                    contrastThreshold: 2.2,
                    // Used by the functions below to shift a color's luminance by approximately
                    // two indexes within its tonal palette.
                    // E.g., shift from Red 500 to Red 300 or Red 700.
                    tonalOffset: 0.2,
                },
                spacing: 12,
            });
        };
        this.theme = this.getTheme();
        this.handleVersionSet = () => this.forceUpdate();
        this.handleUserChange = () => this.safeSetState({ loggedIn: _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user != null, initialized: true });
        this.handleNullUserChange = () => this.safeSetState({ loggedIn: false });
        //TODO:JJ should this be async?
        this.handleThemeChange = async () => {
            this.theme = this.getTheme();
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onVersionSet.connect(this.handleVersionSet);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onNullUser.connect(this.handleNullUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/check-login";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (response.status !== 200 && response.status !== 201) {
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.ResponseError(response);
                }
                return response.json();
            }).then((body) => {
                if (body.loginFailed || body.domainFailed) {
                    // We need to set this to null to signal that the first login attempt completed
                    _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = null;
                }
                else {
                    try {
                        var user = _models_User__WEBPACK_IMPORTED_MODULE_13__.User.handleLogin(body);
                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = user;
                    }
                    catch (err) {
                        console.error(err);
                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = null;
                    }
                }
            }, () => {
                _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = null;
            });
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onVersionSet.disconnect(this.handleVersionSet);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onNullUser.disconnect(this.handleNullUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.onUserChange.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.domRoot = document.getElementById("main");
        this.state = {
            initialized: false,
            loggedIn: false,
        };
        _Colors__WEBPACK_IMPORTED_MODULE_12__.Colors.refresh = this.refresh;
    }
    componentDidCatch(error, info) {
        console.error(error);
        console.info(info);
    }
    static getDerivedStateFromError(error) {
        return { loggedIn: false };
    }
}
const StyledOptumiLeftPanel = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)(_models_Snackbar__WEBPACK_IMPORTED_MODULE_14__.providerOptions)(OptumiLeftPanel);



/***/ }),

/***/ "./lib/components/MachinesPage.js":
/*!****************************************!*\
  !*** ./lib/components/MachinesPage.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MachinesPage": () => (/* binding */ MachinesPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core */ "./lib/core/Label.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Tag */ "./lib/components/Tag.js");
/* harmony import */ var _core_CustomerState__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/CustomerState */ "./lib/core/CustomerState.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class MachinesPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var sorted = [...this.props.machines].sort((m1, m2) => {
                if (m1.time > m2.time) {
                    return -1;
                }
                if (m1.time < m2.time) {
                    return 1;
                }
                return 0;
            });
            var machines = new Array();
            for (var i = 0; i < sorted.length; i++) {
                var machine = sorted[i];
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userExpertise >= 2 || machine.getStateMessage() != 'Releasing') {
                    machines.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { key: machine.uuid, sx: { display: 'inline-flex', width: '100%', padding: '6px 0px' } }, machine.getComponent()));
                }
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: Object.assign({ display: 'flex', flexFlow: 'column', overflow: 'hidden' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Header, { title: 'Machines' })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Current rate', getValue: () => `$${this.props.rate.toFixed(2)}/hr`, lineHeight: '18px', align: 'left', valueAlign: 'right' }),
                    _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.isSubscribed() && !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.lastBillPaid && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'middle' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px', justifyContent: 'center', height: '21px', display: 'inline-flex', width: 'calc(100% - 24px)' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { marginLeft: '-26px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.WarningRounded, { sx: { color: 'error.main', lineHeight: '20px', width: '20px', height: '20px', marginRight: '6px' } })),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { lineHeight: '21px' } }, "Last payment failed, please update"))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1, overflowY: 'auto', padding: '6px' } }, machines.length > 0 && (machines)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px 0px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.Header, { title: 'Usage' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tag__WEBPACK_IMPORTED_MODULE_6__.Tag, { label: 'View billing', onClick: () => _Global__WEBPACK_IMPORTED_MODULE_3__.Global.followLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.SettingsPopup.BillingTab) })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Storage', getValue: () => _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleStorageOrEgress(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.total, _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.limit), lineHeight: '18px', align: 'left', valueAlign: 'right' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Egress', getValue: () => _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleStorageOrEgress(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.egressTotal, _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.egressLimit), lineHeight: '18px', align: 'left', valueAlign: 'right' }),
                    _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.isSubscribed() ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Total cost', getValue: () => {
                            if (this.props.machineCost == null || this.props.egressCost == null || this.props.storageCost == null || this.props.serviceFeeCost == null)
                                return '--';
                            var sum = +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].floorAndToFixed(this.props.machineCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].floorAndToFixed(this.props.egressCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].floorAndToFixed(this.props.storageCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].floorAndToFixed(this.props.serviceFeeCost, 2);
                            if (sum == 0 && (this.props.machineCost > 0 || this.props.egressCost > 0 || this.props.storageCost > 0 || this.props.serviceFeeCost > 0))
                                return '< $0.01';
                            return `${_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].formatCost(sum)}`;
                        }, lineHeight: '18px', align: 'left', valueAlign: 'right' })) : _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.customerState == _core_CustomerState__WEBPACK_IMPORTED_MODULE_8__.CustomerState.FREE_TRIAL && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Credits', getValue: () => `${_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].formatCredit(this.props.balance)}`, lineHeight: '18px', align: 'left', valueAlign: 'right' })))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user != null) {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.getFilesChanged().connect(() => this.forceUpdate());
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.connect(() => this.forceUpdate());
            }
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user != null) {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.getFilesChanged().disconnect(() => this.forceUpdate());
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.disconnect(() => this.forceUpdate());
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/MonitorPage.js":
/*!***************************************!*\
  !*** ./lib/components/MonitorPage.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MonitorPage": () => (/* binding */ MonitorPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



// Defaults for this component
const DefaultState = {
    activeSessionCount: 0,
    activeJobCount: 0,
    finishedSessionCount: 0,
    finishedJobCount: 0,
};
class MonitorPage extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.state = DefaultState;
        this.generateActive = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if (n1.timestamp > n2.timestamp) {
                    return -1;
                }
                if (n1.timestamp < n2.timestamp) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { key: value.uuid, sx: { padding: '6px 0px 6px 6px' } }, value.getComponent())));
        };
        this.generateFinished = (apps) => {
            var sorted = apps.sort((n1, n2) => {
                if ((n1.getEndTime() || n1.timestamp) > (n2.getEndTime() || n2.timestamp)) {
                    return -1;
                }
                if ((n1.getEndTime() || n1.timestamp) < (n2.getEndTime() || n2.timestamp)) {
                    return 1;
                }
                return 0;
            });
            return sorted.map(value => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { key: value.uuid, sx: { padding: '6px 0px 6px 6px' } }, value.getComponent())));
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const appTracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.appTracker;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({ overflowY: 'auto' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { title: "Active" }),
                    this.state.activeSessionCount != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Sessions" }),
                        this.generateActive(appTracker.activeSessions))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Sessions", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))),
                    this.state.activeJobCount != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Jobs", grey: true }),
                        this.generateActive(appTracker.activeJobs))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Jobs", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)")))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { title: "Finished" }),
                    this.state.finishedSessionCount != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Sessions", grey: true }),
                        this.generateFinished(appTracker.finishedSessions))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Sessions", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))),
                    this.state.finishedJobCount != 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Jobs", grey: true }),
                        this.generateFinished(appTracker.finishedJobs))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.SubHeader, { title: "Jobs", grey: true }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                                margin: '6px 0px',
                                fontSize: '14px',
                                lineHeight: '18px',
                                opacity: 0.5
                            } }, "(none)"))))));
        };
        this.handleAppChange = () => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
            this.setState({
                activeSessionCount: ((_c = (_b = (_a = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user) === null || _a === void 0 ? void 0 : _a.appTracker) === null || _b === void 0 ? void 0 : _b.activeSessions) === null || _c === void 0 ? void 0 : _c.length) || 0,
                activeJobCount: ((_f = (_e = (_d = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user) === null || _d === void 0 ? void 0 : _d.appTracker) === null || _e === void 0 ? void 0 : _e.activeJobs) === null || _f === void 0 ? void 0 : _f.length) || 0,
                finishedSessionCount: ((_j = (_h = (_g = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user) === null || _g === void 0 ? void 0 : _g.appTracker) === null || _h === void 0 ? void 0 : _h.finishedSessions) === null || _j === void 0 ? void 0 : _j.length) || 0,
                finishedJobCount: ((_m = (_l = (_k = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user) === null || _k === void 0 ? void 0 : _k.appTracker) === null || _l === void 0 ? void 0 : _l.finishedJobs) === null || _m === void 0 ? void 0 : _m.length) || 0,
            });
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this.handleAppChange();
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.appTracker.appsChanged.connect(this.handleAppChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.appTracker.appsChanged.disconnect(this.handleAppChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/OauthLogin.js":
/*!**************************************!*\
  !*** ./lib/components/OauthLogin.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OauthLogin": () => (/* binding */ OauthLogin)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _models_User__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../models/User */ "./lib/models/User.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__);
///<reference path="../../node_modules/@types/node/index.d.ts"/>
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
// The login screen
class OauthLogin extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Avoid rapid login attempts
        this.lastLoginAttempt = new Date(0);
        this.getMessage = () => {
            if (this.state.loginFailedMessage != "") {
                return this.state.loginFailedMessage;
            }
            else {
                return this.state.progress;
            }
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const fontFamily = getComputedStyle(document.documentElement).getPropertyValue('--jp-code-font-family').trim();
            const message = this.getMessage();
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'jp-optumi-logo' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Container, { style: { textAlign: 'center', display: 'inline-flex', justifyContent: 'center' }, maxWidth: "xs" }, this.state.waiting && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '14px', thickness: 8, sx: { margin: 'auto 0px' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { color: this.state.loginFailed ? 'error.main' : 'text.secondary', paddingLeft: '6px', lineHeight: '14px' } }, message)))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Container, { style: { textAlign: 'center' }, maxWidth: "xs" }, !this.state.waiting && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { sx: { margin: '16px', minWidth: '0px', height: '52px' }, variant: "contained", color: "primary", disabled: this.state.waiting, onClick: () => this.check_login(true) }, "Sign in to Optumi"),
                    message == "no more stations" || message == "no more trial stations" ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { color: 'text.secondary', paddingLeft: '6px', lineHeight: '14px', textAlign: 'left' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { margin: '12px 0px' } }, message == "no more stations" ? ("Sorry! We've reached the maximum number of concurrent users. 😕") : ("Sorry! We've reached the maximum number of concurrent trial users. 😕")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { margin: '12px 0px' } }, 'Please try again later as slots will likely open up. Thank you for your patience as we grow our infrastructure to support more users.'))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { color: this.state.loginFailed ? 'error.main' : 'text.secondary', paddingLeft: '6px', lineHeight: '14px' } }, message))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Container, { style: { textAlign: 'center' }, maxWidth: "xs" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { color: this.state.loginFailed ? 'error.main' : 'text.secondary' } },
                        this.state.showLoginHint && this.state.progress == 'Logging in...' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null),
                            "You will be directed to a new browser tab in a moment. If a tab doesn't open, check that your browser is not blocking popups and click ",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { color: 'primary', sx: { padding: '0px', minWidth: '36px', top: '-1px' }, onClick: () => this.check_login(true) }, "here"))),
                        this.state.showAllocatingHint && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null),
                            "This may take a few minutes")))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                        position: 'absolute',
                        bottom: '10px',
                        width: '100%',
                        textAlign: 'center',
                        color: 'text.secondary',
                    } },
                    "Version ",
                    _Global__WEBPACK_IMPORTED_MODULE_5__.Global.version),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.packageString != "" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px 30px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Header, { title: this.state.downgrade ? "Whoops" : "New version available ✨", sx: { lineHeight: '24px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { padding: '18px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '6px 18px', lineHeight: '24px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null, this.state.downgrade ?
                                "Sorry, we've noticed an incompatibility between this JupyterLab extension version and our backend. To switch to a compatible extension run the command below and restart JupyterLab:"
                                :
                                    "We've made enhancements that require a new JupyterLab extension version. To upgrade your extension, run the command below and restart JupyterLab:"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { margin: '24px 0px', display: 'inline-flex', width: '100%', justifyContent: 'center' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.TEXTAREA, { id: "optumi-upgrade-string", sx: {
                                        fontFamily: 'var(--jp-code-font-family)',
                                        lineHeight: '24px',
                                        width: _Global__WEBPACK_IMPORTED_MODULE_5__.Global.getStringWidth('pip install ' + this.state.packageString, "16px " + fontFamily),
                                    }, rows: 1, readOnly: true }, 'pip install ' + this.state.packageString),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                        var copyTextarea = document.getElementById('optumi-upgrade-string');
                                        copyTextarea.focus();
                                        copyTextarea.select();
                                        try {
                                            document.execCommand('copy');
                                        }
                                        catch (err) {
                                            console.log(err);
                                        }
                                    }, sx: { padding: '0px', width: '30px', height: '30px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__.ContentCopy, { sx: { height: '20px' } })))))));
        };
        this.newTab = null;
        this.loginHintTimeout = null;
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.observer.observe(document.getElementById('optumi/Optumi'), { attributes: true, attributeFilter: ['class'] });
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
            this.observer.disconnect();
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            loginFailed: false,
            loginFailedMessage: "",
            waiting: false,
            packageString: "",
            downgrade: false,
            progress: undefined,
            showLoginHint: false,
            showAllocatingHint: false,
        };
        this.observer = new MutationObserver((mutations) => {
            mutations.forEach((mutationRecord) => {
                if (!mutationRecord.target.classList.contains('lm-mod-hidden')) {
                    this.check_login(true);
                }
            });
        });
    }
    // Try to log into the REST interface and update state according to response
    async login() {
        this.setState({ showLoginHint: false });
        var timeout = setTimeout(() => this.setState({ showAllocatingHint: true }), 30000);
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/login";
        const init = {
            method: 'GET',
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                clearTimeout(timeout);
                this.safeSetState({ loginFailed: true, loginFailedMessage: "Unable to restore context", waiting: false, showLoginHint: false, showAllocatingHint: false });
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.ResponseError(response);
            }
            return response.json();
        }).then((body) => {
            if (body) {
                clearTimeout(timeout);
                if (body.loginFailed) {
                    this.newTab = null;
                    if (body.message == 'Version exchange failed') {
                        var rawVersion = body.loginFailedMessage;
                        var split = rawVersion.split('-')[0].split('.');
                        const downgrade = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.version.split('.')[1] > split[1];
                        var packageString = '"jupyterlab-optumi>=' + split[0] + '.' + split[1] + '.0,' + '<' + split[0] + '.' + (+split[1] + 1) + '.0"';
                        this.safeSetState({ loginFailed: body.loginFailed || false, packageString: packageString, downgrade: downgrade, waiting: false, showLoginHint: false, showAllocatingHint: false });
                    }
                    else {
                        this.setState({ loginFailed: body.loginFailed || false, loginFailedMessage: body.loginFailedMessage || "", waiting: false, showLoginHint: false, showAllocatingHint: false });
                    }
                }
                else {
                    try {
                        var user = _models_User__WEBPACK_IMPORTED_MODULE_8__.User.handleLogin(body);
                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = user;
                    }
                    catch (err) {
                        console.error(err);
                        this.safeSetState({ loginFailed: true, loginFailedMessage: "Unable to restore context", waiting: false, showLoginHint: false, showAllocatingHint: false });
                    }
                }
            }
        });
    }
    async check_login(first = false) {
        // If the user has not logged in in 10 minutes after the new tab pops up, we time out
        if (this.state.progress == 'Logging in...' && new Date().getTime() - this.lastLoginAttempt.getTime() > 600000) {
            this.safeSetState({ loginFailed: true, loginFailedMessage: "Timed out", waiting: false, showLoginHint: false });
        }
        if (first) {
            if (!this.newTab || this.newTab.closed || typeof this.newTab.closed == 'undefined') {
                this.newTab = window.open(window.location.origin + '/optumi/oauth-login');
                this.setState({ showLoginHint: true });
            }
            else {
                this.newTab.focus();
            }
            this.lastLoginAttempt = new Date();
            this.safeSetState({ progress: 'Logging in...', waiting: true, loginFailed: false, loginFailedMessage: "" });
            this.loginHintTimeout = setTimeout(() => this.setState({ showLoginHint: true }), 6000);
        }
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-login-progress";
        const init = {
            method: 'GET',
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status == 204) {
                return;
            }
            if (response.status !== 200 && response.status !== 201) {
                throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.ResponseError(response);
            }
            return response.text();
        }).then((body) => {
            if (body) {
                if (body == 'Allocating...') {
                    if (this.newTab) {
                        clearTimeout(this.loginHintTimeout);
                        this.loginHintTimeout = null;
                        this.newTab.close();
                        this.newTab = null;
                        this.login();
                    }
                }
                this.setState({ progress: body });
            }
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.user == null)
                setTimeout(() => { this.check_login(); }, 500);
        });
    }
}


/***/ }),

/***/ "./lib/components/Pilot.js":
/*!*********************************!*\
  !*** ./lib/components/Pilot.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Pilot": () => (/* binding */ SnackbarPilot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _DeployPage__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./DeployPage */ "./lib/components/DeployPage.js");
/* harmony import */ var _MonitorPage__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./MonitorPage */ "./lib/components/MonitorPage.js");
/* harmony import */ var _MachinesPage__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./MachinesPage */ "./lib/components/MachinesPage.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _models_Snackbar__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../models/Snackbar */ "./lib/models/Snackbar.js");
/* harmony import */ var _UserDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./UserDialog */ "./lib/components/UserDialog.js");
/* harmony import */ var _models_machine_Machine__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models/machine/Machine */ "./lib/models/machine/Machine.js");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! notistack */ "webpack/sharing/consume/default/notistack/notistack");
/* harmony import */ var notistack__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(notistack__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core_SubscribeButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../core/SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _core_SubscribedPopup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/SubscribedPopup */ "./lib/core/SubscribedPopup.js");
/* harmony import */ var _core_CustomerState__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../core/CustomerState */ "./lib/core/CustomerState.js");
/* harmony import */ var _core_HoldoverTimePopup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/HoldoverTimePopup */ "./lib/core/HoldoverTimePopup.js");
/* harmony import */ var _core_SubscribePopup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/SubscribePopup */ "./lib/core/SubscribePopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/












// import { PackageState } from '../models/Package';





var Page;
(function (Page) {
    Page[Page["DEPLOY"] = 0] = "DEPLOY";
    Page[Page["MONITOR"] = 1] = "MONITOR";
    Page[Page["MACHINES"] = 2] = "MACHINES";
})(Page || (Page = {}));
class Pilot extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.machinesTimeout = null;
        this.costTimeout = null;
        this.currentCycleUsageTimeout = null;
        this.handleTabChange = (event, newValue) => {
            if (newValue == Page.MACHINES)
                this.updateMachines(false);
            this.safeSetState({ page: newValue });
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.lastPage = newValue;
        };
        this.getCurrentCycleUsage = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user == null)
                return;
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-balance";
            const now = new Date();
            var lastAnchor = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.billingCycleAnchor;
            if (lastAnchor) {
                lastAnchor.setFullYear(now.getFullYear());
                lastAnchor.setMonth(now.getMonth());
                if (lastAnchor > now)
                    lastAnchor.setMonth(lastAnchor.getMonth() - 1);
            }
            else {
                lastAnchor = new Date(0);
            }
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    startTime: lastAnchor.toISOString(),
                    endTime: now.toISOString(),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (this.polling) {
                    // If we are polling, send a new request in 2 seconds
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    this.currentCycleUsageTimeout = setTimeout(() => this.getCurrentCycleUsage(), 2000);
                }
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                if (body) {
                    if (JSON.stringify(body) !== JSON.stringify(this.previousCurrentCycleUsageUpdate)) {
                        this.safeSetState({ machineCost: body.machineCost, serviceFeeCost: body.serviceFeeCost, storageCost: body.storageCost, egressCost: body.egressCost });
                        this.previousCurrentCycleUsageUpdate = body;
                    }
                }
            });
        };
        this.updateMachines = (scheduleNew = true) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-machines";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                if (this.polling && scheduleNew) {
                    // If we are polling, send a new request in 2 seconds
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    this.machinesTimeout = setTimeout(() => this.updateMachines(), 2000);
                }
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                var machines = [];
                for (var i = 0; i < body.machines.length; i++) {
                    machines.push(_models_machine_Machine__WEBPACK_IMPORTED_MODULE_5__.Machine.parse(body.machines[i]));
                }
                if (JSON.stringify(body) !== JSON.stringify(this.previousMachines)) {
                    var rate = 0;
                    for (let machine of machines) {
                        if (machine.getStateMessage() != 'Releasing')
                            rate += +(machine.rate.toFixed(2));
                    }
                    this.safeSetState({ machines: machines, rate: rate });
                    this.previousMachines = body;
                }
            }, () => {
                if (this.polling && scheduleNew)
                    this.machinesTimeout = setTimeout(() => this.updateMachines(), 2000);
            });
        };
        // private getPackageBadge = () => {
        // 	if (Global.metadata) {
        // 		const pack = Global.metadata.getPackage(true);
        // 		if (pack == null) {
        // 			return 0;
        // 		} else if (pack.packageState == PackageState.SHIPPED) {
        // 			return '!';
        // 		} else {
        // 			return 0;
        // 		}
        // 	} else {
        // 		return 0;
        // 	}
        // }
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                    width: 'var(--jp-sidebar-min-width)',
                    maxWidth: 'var(--jp-sidebar-min-width)',
                    margin: '0px auto',
                    display: 'flex',
                    flexDirection: 'column',
                    height: '100%',
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribePopup__WEBPACK_IMPORTED_MODULE_6__["default"], null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribedPopup__WEBPACK_IMPORTED_MODULE_7__["default"], null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_HoldoverTimePopup__WEBPACK_IMPORTED_MODULE_8__["default"], null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { paddingBottom: "5px", textAlign: 'center', verticalAlign: 'middle' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', width: '100%' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: 'https://www.optumi.com', target: '_blank' },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-optumi-logo' })),
                        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user != null && !_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.isSubscribed() && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { position: 'relative', flexGrow: 1 } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { position: 'absolute', right: '0px', margin: '15px 6px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribeButton__WEBPACK_IMPORTED_MODULE_9__.SubscribeButton, { sx: { width: '75px' }, disableElevation: true, variant: 'skinny' })))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_UserDialog__WEBPACK_IMPORTED_MODULE_10__.UserDialog, { sx: { margin: 'auto 6px auto auto' }, balance: this.state.balance, machineCost: this.state.machineCost, serviceFeeCost: this.state.serviceFeeCost, storageCost: this.state.storageCost, egressCost: this.state.egressCost })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tabs, { value: this.state.page, onChange: this.handleTabChange, variant: "fullWidth", indicatorColor: "primary", textColor: "primary", sx: { margin: '0px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Badge
                            // badgeContent={this.getPackageBadge()}
                            , { 
                                // badgeContent={this.getPackageBadge()}
                                anchorOrigin: { vertical: 'top', horizontal: 'right', }, color: "primary" },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,446", sx: { width: '28px', height: '28px', margin: '0px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M348.000 58.232 C 324.618 61.984,306.000 66.674,306.000 68.813 C 306.000 71.851,369.545 135.122,371.067 133.599 C 372.905 131.761,382.000 74.336,382.000 64.567 L 382.000 56.000 370.500 56.234 C 364.175 56.362,354.050 57.262,348.000 58.232 M261.029 86.235 C 214.374 111.539,184.827 137.455,151.438 182.354 C 131.859 208.683,134.247 207.280,105.973 209.077 C 77.646 210.877,78.107 210.586,46.111 246.944 C 14.709 282.628,13.657 285.006,24.595 295.608 C 33.914 304.640,38.535 303.841,62.774 289.000 C 74.453 281.850,85.356 276.000,87.004 276.000 C 90.397 276.000,91.021 279.133,88.000 281.000 C 80.966 285.347,86.211 293.260,115.524 322.525 C 145.290 352.241,154.153 357.842,159.000 350.000 C 161.093 346.613,163.948 347.791,162.638 351.500 C 161.957 353.425,155.685 364.580,148.700 376.288 C 133.629 401.551,133.207 405.011,144.006 414.767 C 155.049 424.744,153.659 425.401,190.701 392.696 C 227.821 359.922,227.156 360.976,229.004 332.000 C 230.748 304.673,229.916 306.203,252.454 288.864 C 308.578 245.687,341.585 206.858,361.005 161.165 C 368.325 143.941,367.373 141.488,347.134 125.396 C 330.680 112.314,319.724 100.874,305.577 82.000 C 295.803 68.959,292.260 69.296,261.029 86.235 M281.518 145.989 C 295.397 154.451,299.651 169.944,291.460 182.204 C 279.075 200.744,254.612 198.973,245.060 178.845 C 234.650 156.906,260.788 133.350,281.518 145.989 M65.116 318.984 C 41.834 327.278,33.655 343.820,22.828 404.507 C 19.046 425.702,19.740 429.180,26.337 422.099 C 32.573 415.406,48.022 408.969,72.496 402.867 C 109.336 393.683,120.097 382.787,119.904 354.869 L 119.808 341.000 116.404 347.823 C 111.679 357.294,105.398 361.342,88.000 366.125 C 79.750 368.394,70.975 371.564,68.500 373.171 C 63.012 376.734,63.005 376.424,68.070 354.701 C 73.737 330.396,81.234 320.000,93.094 320.000 C 94.692 320.000,96.000 319.100,96.000 318.000 C 96.000 315.041,74.239 315.734,65.116 318.984 " }))), label: "Launch", sx: { minWidth: "72px", padding: '6px 12px 0px 12px' } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Badge, { badgeContent: this.state.displayNumApps, anchorOrigin: { vertical: 'top', horizontal: 'right', }, color: "primary" },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,400", sx: { width: '28px', height: '28px', margin: '0px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M184.000 75.671 C 157.886 84.352,136.646 102.091,124.338 125.500 L 117.765 138.000 105.383 138.035 C 90.924 138.075,71.538 141.909,56.000 147.801 C -14.626 174.580,-18.484 281.128,49.988 313.831 L 65.000 321.000 203.705 321.553 L 342.409 322.106 353.376 317.085 C 385.732 302.272,399.199 277.664,397.610 236.256 C 396.006 194.437,366.443 166.000,324.574 166.000 C 319.271 166.000,315.638 165.024,315.269 163.500 C 304.910 120.762,285.610 93.164,256.447 79.388 C 239.169 71.226,202.961 69.368,184.000 75.671 M244.970 147.777 C 301.927 179.760,259.786 271.237,199.913 245.586 L 192.826 242.549 169.913 267.273 C 142.622 296.721,133.842 300.366,127.894 284.720 C 125.394 278.145,125.295 278.289,151.476 250.369 L 173.952 226.400 169.629 216.700 C 148.789 169.946,200.388 122.743,244.970 147.777 M206.094 158.498 C 190.267 163.800,177.795 184.895,181.098 200.776 C 190.562 246.287,256.850 241.187,256.856 194.948 C 256.859 168.669,231.052 150.138,206.094 158.498 " }))), label: "Workloads", sx: { minWidth: "72px", padding: '6px 12px 0px 12px' } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, icon: (() => {
                                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.isSubscribed() && !_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.lastBillPaid) {
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Badge, { badgeContent: '!', anchorOrigin: { vertical: 'top', horizontal: 'right', }, color: "error" },
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,200", style: { width: '28px', height: '28px', margin: '0px' } },
                                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M0.000 40.000 L 0.000 80.000 200.000 80.000 L 400.000 80.000 400.000 40.000 L 400.000 0.000 200.000 0.000 L 0.000 0.000 0.000 40.000 M80.000 40.000 L 80.000 60.000 60.000 60.000 L 40.000 60.000 40.000 40.000 L 40.000 20.000 60.000 20.000 L 80.000 20.000 80.000 40.000 M0.000 160.000 L 0.000 200.000 200.000 200.000 L 400.000 200.000 400.000 160.000 L 400.000 120.000 200.000 120.000 L 0.000 120.000 0.000 160.000 M80.000 160.000 L 80.000 180.000 60.000 180.000 L 40.000 180.000 40.000 160.000 L 40.000 140.000 60.000 140.000 L 80.000 140.000 80.000 160.000 " }))));
                                }
                                else {
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Badge, { badgeContent: this.state.machines.filter(x => x.isVisible()).length, anchorOrigin: { vertical: 'top', horizontal: 'right', }, color: "primary" },
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.SvgIcon, { viewBox: "0, 0, 400,200", sx: { width: '28px', height: '28px', margin: '0px' } },
                                            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M0.000 40.000 L 0.000 80.000 200.000 80.000 L 400.000 80.000 400.000 40.000 L 400.000 0.000 200.000 0.000 L 0.000 0.000 0.000 40.000 M80.000 40.000 L 80.000 60.000 60.000 60.000 L 40.000 60.000 40.000 40.000 L 40.000 20.000 60.000 20.000 L 80.000 20.000 80.000 40.000 M0.000 160.000 L 0.000 200.000 200.000 200.000 L 400.000 200.000 400.000 160.000 L 400.000 120.000 200.000 120.000 L 0.000 120.000 0.000 160.000 M80.000 160.000 L 80.000 180.000 60.000 180.000 L 40.000 180.000 40.000 160.000 L 40.000 140.000 60.000 140.000 L 80.000 140.000 80.000 160.000 " }))));
                                }
                            })(), label: "Resources", sx: { minWidth: "72px", padding: '6px 12px 0px 12px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_11__.ShadowedDivider, null),
                this.state.page == Page.DEPLOY ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeployPage__WEBPACK_IMPORTED_MODULE_12__.DeployPage, { sx: { flexGrow: 1 }, balance: this.state.balance })) : this.state.page == Page.MONITOR ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MonitorPage__WEBPACK_IMPORTED_MODULE_13__.MonitorPage, { sx: { flexGrow: 1 } })) : this.state.page == Page.MACHINES ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MachinesPage__WEBPACK_IMPORTED_MODULE_14__.MachinesPage, { sx: { flexGrow: 1 }, rate: this.state.rate, balance: this.state.balance, machines: this.state.machines, machineCost: this.state.machineCost, serviceFeeCost: this.state.serviceFeeCost, storageCost: this.state.storageCost, egressCost: this.state.egressCost })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null))));
        };
        this.handleSnackbarEnqueue = (sender, snackbar) => this.props.enqueueSnackbar(snackbar.message, snackbar.options);
        // Call closeSnackbar with null to close all snackbars (useful for things like logging out)
        this.handleSnackbarClose = (sender, key) => key == null ? this.props.closeSnackbar() : this.props.closeSnackbar(key);
        this.handleAppsChange = () => this.setState({ displayNumApps: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.appTracker.getDisplayNum() });
        // private handlePackageChange = () => this.forceUpdate()
        this.handleChange = () => this.forceUpdate();
        this.handleForcePackageIntoView = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.lastForceCompleted = false;
            this.setState({ page: Page.DEPLOY });
        };
        this.handleJobLaunched = () => { }; /*this.safeSetState({ page: Page.Monitor })*/
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab, () => {
                this.safeSetState({ page: Page.DEPLOY });
                this.handleTabChange(undefined, Page.DEPLOY);
            });
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.MonitorTab, () => {
                this.safeSetState({ page: Page.MONITOR });
                this.handleTabChange(undefined, Page.MONITOR);
            });
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.MachinesTab, () => {
                this.safeSetState({ page: Page.MACHINES });
                this.handleTabChange(undefined, Page.MACHINES);
            });
            this.polling = true;
            this.updateMachines();
            this.receiveCostUpdate();
            this.getCurrentCycleUsage();
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.labShell.currentChanged.connect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.tracker.currentChanged.connect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.tracker.selectionChanged.connect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.appTracker.appsChanged.connect(this.handleAppsChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarEnqueue.connect(this.handleSnackbarEnqueue);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarClose.connect(this.handleSnackbarClose);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.jobLaunched.connect(this.handleJobLaunched);
            // Global.metadata.getPackageChanged().connect(this.handlePackageChange)
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.forcePackageIntoView.connect(this.handleForcePackageIntoView);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this.polling = false;
            if (this.machinesTimeout != null)
                clearTimeout(this.machinesTimeout);
            if (this.costTimeout != null)
                clearTimeout(this.costTimeout);
            if (this.currentCycleUsageTimeout != null)
                clearTimeout(this.currentCycleUsageTimeout);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.labShell.currentChanged.disconnect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.tracker.currentChanged.disconnect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.tracker.selectionChanged.disconnect(this.handleChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.appTracker.appsChanged.disconnect(this.handleAppsChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarEnqueue.disconnect(this.handleSnackbarEnqueue);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarClose.disconnect(this.handleSnackbarClose);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.jobLaunched.disconnect(this.handleJobLaunched);
            // Global.metadata.getPackageChanged().disconnect(this.handlePackageChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.forcePackageIntoView.disconnect(this.handleForcePackageIntoView);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.lastMachineRate = this.state.rate;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.lastCreditsBalance = this.state.balance;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.deleteLinksUnder(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        const lastPage = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.lastPage;
        this.state = {
            page: lastPage < 0 || lastPage > 2 ? 0 : lastPage,
            deployDisabled: false,
            balance: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.lastCreditsBalance,
            machines: [],
            rate: 0,
            machineCost: null,
            serviceFeeCost: null,
            storageCost: null,
            egressCost: null,
            displayNumApps: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.appTracker.getDisplayNum(),
            showTrialEndedPopup: false,
        };
    }
    async receiveCostUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-balance";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: new Date(0).toISOString(),
                endTime: new Date().toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                this.costTimeout = setTimeout(() => this.receiveCostUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                if (JSON.stringify(body) !== JSON.stringify(this.previousCostUpdate)) {
                    this.safeSetState({ balance: body.balance });
                    this.previousCostUpdate = body;
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.customerState == _core_CustomerState__WEBPACK_IMPORTED_MODULE_15__.CustomerState.FREE_TRIAL) {
                        const expiration = new Date(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.trialStart);
                        expiration.setDate(expiration.getDate() + 14);
                        const now = new Date();
                        // If the user's trial ended, we don't want to show them the credits snackbar
                        // freeTrialCreditLimit
                        if ((now.getTime() - _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.freeTrialCreditLimitDismissed.getTime() > _Global__WEBPACK_IMPORTED_MODULE_4__.Global.dismissalTimeout) && now.getTime() < expiration.getTime() && this.state.balance > 0) {
                            const action = (key) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribeButton__WEBPACK_IMPORTED_MODULE_9__.SubscribeButton, { variant: 'whiteText', color: 'secondary', onClick: () => {
                                        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.freeTrialCreditLimitDismissed = new Date();
                                    } }),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.WhiteTextButton, { onClick: () => {
                                        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.freeTrialCreditLimitDismissed = new Date();
                                        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarClose.emit(key);
                                    } }, "Dismiss")));
                            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.snackbarEnqueue.emit(new _models_Snackbar__WEBPACK_IMPORTED_MODULE_16__.Snackbar('You have no remaining credits', { variant: 'error', persist: true, action }));
                        }
                    }
                }
            }
        });
    }
}
const SnackbarPilot = (0,notistack__WEBPACK_IMPORTED_MODULE_3__.withSnackbar)(Pilot);



/***/ }),

/***/ "./lib/components/StatusWrapper.js":
/*!*****************************************!*\
  !*** ./lib/components/StatusWrapper.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StatusWrapper": () => (/* binding */ StatusWrapper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class StatusWrapper extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.isLightMode = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var color = this.props.statusColor;
            if (!color)
                color = 'var(--jp-layout-color2)';
            if (color.startsWith('var')) {
                color = getComputedStyle(document.documentElement).getPropertyValue(color.replace('var(', '').replace(')', '')).trim();
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Paper, { elevation: 0, sx: {
                        background: this.props.opened ? (this.isLightMode ? (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.darken)(color, 0.5) : (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.lighten)(color, 0.5)) : color,
                        transition: 'background 750ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { marginLeft: '6px', padding: '2px' } }, this.props.children))));
        };
        this.handleThemeChange = () => {
            this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
            this.forceUpdate();
        };
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
    }
}


/***/ }),

/***/ "./lib/components/StorageBuckets.js":
/*!******************************************!*\
  !*** ./lib/components/StorageBuckets.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageBuckets": () => (/* binding */ StorageBuckets)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core */ "./lib/core/Header.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class StorageBuckets extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%', justifyContent: 'center' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { sx: { width: 'fit-content', margin: '6px auto' }, title: "Storage" }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%', justifyContent: 'center' } }, this.props.buckets.map((bucket, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        width: '115px',
                        textAlign: 'center',
                        padding: '12px',
                        margin: index == 0 ? '6px 0px 6px 6px' : (index == this.props.buckets.length - 1 ? '6px 6px 6px 0px' : '6px 0px'),
                        border: '1px solid ' + _Colors__WEBPACK_IMPORTED_MODULE_3__.Colors.SECONDARY,
                        borderRadius: index == 0 ? '6px 0px 0px 6px' : (index == this.props.buckets.length - 1 ? '0px 6px 6px 0px' : '0px'),
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { color: _Colors__WEBPACK_IMPORTED_MODULE_3__.Colors.PRIMARY, fontSize: '20px', fontWeight: 'bold' } }, bucket.cost == 0 ? 'Free' : '$' + bucket.cost),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, null, 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__["default"].styleCapacityUnitValue()(bucket.limit))))))));
        };
        // public shouldComponentUpdate = (nextProps: IProps, nextState: IState): boolean => {
        //     try {
        //         if (JSON.stringify(this.props) != JSON.stringify(nextProps)) return true;
        //         if (JSON.stringify(this.state) != JSON.stringify(nextState)) return true;
        //         if (Global.shouldLogOnRender) console.log('SuppressedRender (' + new Date().getSeconds() + ')');
        //         return false;
        //     } catch (error) {
        //         return true;
        //     }
        // }
    }
}


/***/ }),

/***/ "./lib/components/Tag.js":
/*!*******************************!*\
  !*** ./lib/components/Tag.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Tag": () => (/* binding */ Tag)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/system */ "./node_modules/@mui/system/esm/colorManipulator.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const progressBorderSize = 1;
class Tag extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.getStyledCircularProgress = () => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    color: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.theme) ? (0,_mui_system__WEBPACK_IMPORTED_MODULE_4__.darken)(this.props.color || _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CHIP_GREY, 0.35) : (0,_mui_system__WEBPACK_IMPORTED_MODULE_4__.lighten)(this.props.color || _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CHIP_GREY, 0.35),
                },
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress);
        };
        this.getStyledChip = () => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    position: 'relative',
                    bottom: '0px',
                    margin: `${progressBorderSize}px`,
                    height: '18px',
                    backgroundColor: (0,_mui_system__WEBPACK_IMPORTED_MODULE_4__.alpha)(this.props.color || _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CHIP_GREY, 0.25),
                    fontSize: 'var(--jp-ui-font-size1)',
                    color: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.theme) ? (0,_mui_system__WEBPACK_IMPORTED_MODULE_4__.darken)(this.props.color || _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CHIP_GREY, 0.35) : (0,_mui_system__WEBPACK_IMPORTED_MODULE_4__.lighten)(this.props.color || _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CHIP_GREY, 0.35),
                    // fontWeight: 'bold',
                },
                label: {
                    overflow: 'visible',
                },
                icon: {
                    fontSize: '14px !important',
                },
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Chip);
        };
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const fontSize = getComputedStyle(document.documentElement).getPropertyValue('--jp-ui-font-size1').trim();
            const fontFamily = getComputedStyle(document.documentElement).getPropertyValue('--jp-ui-font-family').trim();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, ((this.props.label != "" && this.props.label != undefined) || (this.props.icon != undefined)) &&
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: Object.assign({
                        position: 'relative',
                        margin: '3px',
                    }, this.props.sx), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledChip, { onClick: this.props.onClick, key: this.props.label + this.props.color + this.props.icon, id: this.props.id, size: 'small', label: this.props.label, icon: this.props.showLoading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { height: '16px' } }, this.props.percentLoaded === undefined ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledCircularProgress, { size: '14px', thickness: 6 })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledCircularProgress, { size: '14px', thickness: 6, variant: 'determinate', value: this.props.percentLoaded * 100 })))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { height: '14px' } }, this.props.icon)), sx: {
                            width: (this.props.label != "" && this.props.label != undefined) ? ((_Global__WEBPACK_IMPORTED_MODULE_3__.Global.getStringWidth(this.props.label, fontSize + " " + fontFamily) + 14) + (this.props.showLoading || this.props.icon ? 14 : 0)) + 'px' : '18px',
                        } }))));
        };
        this.handleThemeChange = () => {
            this.StyledChip = this.getStyledChip();
            this.StyledCircularProgress = this.getStyledCircularProgress();
            this.forceUpdate();
        };
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledChip = this.getStyledChip();
        this.StyledCircularProgress = this.getStyledCircularProgress();
    }
}


/***/ }),

/***/ "./lib/components/UserDialog.js":
/*!**************************************!*\
  !*** ./lib/components/UserDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UserDialog": () => (/* binding */ UserDialog)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./settings/SettingsMenu */ "./lib/components/settings/SettingsMenu.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/










const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class UserDialog extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true, selectedPanel: 0 /* PREFERENCES */ });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false, validPhoneNumber: true });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var defaultProfilePicture = _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user.name.replace(/(?<=\B)\w+/g, '').replace(/[ ]/g, '').toUpperCase();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: Object.assign({}, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClickOpen, sx: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '6px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                            width: '24px',
                            height: '24px',
                            // margin: '6px auto',
                            borderRadius: '12px',
                            backgroundColor: _Colors__WEBPACK_IMPORTED_MODULE_6__.Colors.PRIMARY,
                            color: 'white',
                            fontSize: '14px',
                            fontWeight: 'bold',
                            lineHeight: '24px',
                            textAlign: 'center'
                        } }, defaultProfilePicture[defaultProfilePicture.length - 1])),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: () => {
                        if (!this.state.validPhoneNumber) {
                            this.safeSetState({ showCloseWithInvalidNumberPopup: true });
                        }
                        else {
                            this.handleClose();
                        }
                    }, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Settings")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: () => window.open('https://login.optumi.com/enduser/settings?iframe=true&iframeControlHideAll=true', '_blank'), disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: "outlined", color: "primary" }, "Edit profile"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: "outlined", color: "primary", onClick: this.logout }, "Logout")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_7__["default"], { open: this.state.showCloseWithInvalidNumberPopup, headerText: "Heads Up!", bodyText: `The phone number you entered is invalid. If you continue we'll revert back to your previous number.`, cancel: {
                                    text: `Edit number`,
                                    onCancel: (prevent) => {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: false });
                                    },
                                }, continue: {
                                    text: `Continue`,
                                    onContinue: (prevent) => {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: false });
                                        this.handleClose();
                                    },
                                    color: `primary`,
                                } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                    if (!this.state.validPhoneNumber) {
                                        this.safeSetState({ showCloseWithInvalidNumberPopup: true });
                                    }
                                    else {
                                        this.handleClose();
                                    }
                                }, sx: {
                                    margin: '6px',
                                    display: 'inline-block',
                                    width: '36px',
                                    height: '36px',
                                    padding: '3px',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                        width: '30px',
                                        height: '30px',
                                        padding: '3px',
                                    } })))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_8__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { display: 'flex', height: 'calc(100% - 60px - 2px)' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { width: '150px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: {
                                    overflowY: 'auto',
                                    height: '100%',
                                    padding: '0px',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                                        display: 'flex',
                                        flexDirection: 'column',
                                        padding: '6px',
                                        height: '100%',
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.safeSetState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', sx: { minHeight: '24px', flexGrow: 1 } },
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, label: 'Preferences', sx: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 0 /* PREFERENCES */ }),
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, label: 'Limits', sx: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 1 /* LIMITS */ }),
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, label: 'Integrations', sx: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 3 /* INTEGRATIONS */ }),
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, label: 'Storage', sx: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 2 /* STORAGE */ }),
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Tab, { disableRipple: true, label: 'Billing', sx: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            }, value: 4 /* BILLING */ })),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                                            margin: '12px',
                                            color: 'var(--jp-ui-font-color3)',
                                            textAlign: 'center',
                                            fontSize: '10px',
                                        } },
                                        "Version ",
                                        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.version)))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_8__.ShadowedDivider, { orientation: 'vertical' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: {
                                    flexGrow: 1,
                                    overflowY: 'auto',
                                    width: '100%',
                                    height: '100%',
                                    padding: '0px',
                                    marginBottom: '0px',
                                    // lineHeight: 'var(--jp-code-line-height)',
                                    fontSize: 'var(--jp-ui-font-size1)',
                                    fontFamily: 'var(--jp-ui-font-family)',
                                } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                                        // Height needs to be 100% otherwise it will cause problems with the phone number country selection
                                        display: 'flex', flexFlow: 'column', overflow: 'hidden', height: '100%'
                                    } }, this.state.selectedPanel == 0 /* PREFERENCES */ ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__.AccountPreferencesSubMenu, { sx: { flexGrow: 1, overflowY: 'auto', maxWidth: '450px' }, phoneValidOnBlur: (valid) => {
                                            this.setState({ validPhoneNumber: valid });
                                        } }))) : this.state.selectedPanel == 1 /* LIMITS */ ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__.AccountLimitsSubMenu, { sx: { flexGrow: 1, overflowY: 'auto', maxWidth: '450px' } })) : this.state.selectedPanel == 4 /* BILLING */ ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__.AccountBillingSubMenu, { sx: { flexGrow: 1, maxWidth: '450px' }, balance: this.props.balance, machineCost: this.props.machineCost, serviceFeeCost: this.props.serviceFeeCost, storageCost: this.props.storageCost, egressCost: this.props.egressCost })) : this.state.selectedPanel == 3 /* INTEGRATIONS */ ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__.AccountIntegrationsSubMenu, { sx: { flexGrow: 1, overflowY: 'auto' } })) : this.state.selectedPanel == 2 /* STORAGE */ && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_SettingsMenu__WEBPACK_IMPORTED_MODULE_9__.AccountStorageSubMenu, { sx: { flexGrow: 1, overflowY: 'auto' } })))))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup.PreferencesTab, async () => this.safeSetState({ open: true, selectedPanel: 0 /* PREFERENCES */ }));
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup.LimitsTab, async () => this.safeSetState({ open: true, selectedPanel: 1 /* LIMITS */ }));
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup.IntegrationsTab, async () => this.safeSetState({ open: true, selectedPanel: 3 /* INTEGRATIONS */ }));
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup.StorageTab, async () => this.safeSetState({ open: true, selectedPanel: 2 /* STORAGE */ }));
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup.BillingTab, async () => this.safeSetState({ open: true, selectedPanel: 4 /* BILLING */ }));
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.deleteLinksUnder(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.SettingsPopup);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* PREFERENCES */,
            validPhoneNumber: true,
            showCloseWithInvalidNumberPopup: false,
        };
    }
    // Log out of the REST interface
    logout() {
        _Global__WEBPACK_IMPORTED_MODULE_5__.Global.user = null;
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/logout";
        const init = {
            method: 'GET',
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeRequest(url, init, settings);
    }
}


/***/ }),

/***/ "./lib/components/deploy/AddDataConnectorsPopup.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/AddDataConnectorsPopup.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddDataConnectorsPopup": () => (/* binding */ AddDataConnectorsPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class AddDataConnectorsPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedDataConnectors = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleAdd = () => {
            this.props.onDataConnectorsAdded(this.getSelectedDataConnectors());
            // console.log(this.getSelectedFiles())
            this.handleClose();
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open || document.getElementsByClassName('MuiDialog-root').length > 1)
                return; // This means theres another popup open, so it expects the key input
            // The enter has to be a timeout because without it the file gets added but the popup doesn't close
            if (event.key === 'Enter')
                setTimeout(() => this.handleAdd(), 0);
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ display: 'inline-flex', width: '50%' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SkinnyButton, { onClick: this.handleClickOpen, disableElevation: true, color: "primary", variant: "contained", fullWidth: true, sx: { margin: '6px' } }, "+ Connector"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                width: '100%',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: 'auto 12px' } }, "Select data connectors")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: 'contained', color: 'primary', onClick: this.handleAdd }, "Add")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__["default"], { sx: { flexGrow: 1, height: '100%', maxHeight: 'calc(100% - 60px - 60px - 2px)' }, type: _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__.IntegrationType.DATA_CONNECTOR, onAdd: this.handleAdd, getSelected: (getSelectedDataConnectors) => this.getSelectedDataConnectors = getSelectedDataConnectors }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', margin: '6px 100px', height: '60px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', flexGrow: 1, margin: 'auto' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-s3-logo', sx: { width: '30px', height: '30px', margin: '0px 12px' }, style: { backgroundSize: 'contain' } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-drive-logo', sx: { width: '30px', height: '30px', margin: '0px 12px' }, style: { backgroundSize: 'contain' } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-cloud-logo', sx: { width: '30px', height: '30px', margin: '0px 12px' }, style: { backgroundSize: 'contain' } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-kaggle-logo', sx: { width: '30px', height: '30px', margin: '0px 12px' }, style: { backgroundSize: 'contain' } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { className: 'jp-wasabi-logo', sx: { width: '30px', height: '30px', margin: '0px 12px' }, style: { backgroundSize: 'contain' } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { height: '36px', margin: 'auto 12px' }, variant: 'contained', color: 'primary', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.followLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.SettingsPopup.IntegrationsTab);
                                this.safeSetState({ open: false });
                            }, endIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.OpenInNew, null) }, "Create connectors")))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.FilesAccordion.ConnectorPopup, () => this.safeSetState({ open: true }));
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.FilesAccordion.ConnectorPopup);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AddEnvironmentVariablesPopup.js":
/*!***************************************************************!*\
  !*** ./lib/components/deploy/AddEnvironmentVariablesPopup.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddEnvironmentVariablesPopup": () => (/* binding */ AddEnvironmentVariablesPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class AddEnvironmentVariablesPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedEnvironmentVariables = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleAdd = () => {
            this.props.onEnvironmentVariablesAdded(this.getSelectedEnvironmentVariables());
            this.handleClose();
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open || document.getElementsByClassName('MuiDialog-root').length > 1)
                return; // This means theres another popup open, so it expects the key input
            // The enter has to be a timeout because without it the file gets added but the popup doesn't close
            if (event.key === 'Enter')
                setTimeout(() => this.handleAdd(), 0);
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ display: 'inline-flex', flexGrow: 1 }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SkinnyButton, { onClick: this.handleClickOpen, disableElevation: true, color: "primary", variant: "contained", fullWidth: true, sx: { margin: '6px' } }, "+ Variable"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                width: '100%',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: 'auto 12px' } }, "Select environment variables")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: 'contained', color: 'primary', onClick: this.handleAdd }, "Add")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__["default"], { sx: { flexGrow: 1, height: '100%', maxHeight: 'calc(100% - 60px - 60px - 2px)' }, type: _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_6__.IntegrationType.ENVIRONMENT_VARIABLE, onAdd: this.handleAdd, getSelected: (getSelectedEnvironmentVariables) => this.getSelectedEnvironmentVariables = getSelectedEnvironmentVariables }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', margin: '6px 100px', height: '60px', justifyContent: 'center' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { height: '36px', margin: 'auto 12px' }, variant: 'contained', color: 'primary', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.followLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.SettingsPopup.IntegrationsTab);
                                this.safeSetState({ open: false });
                            }, endIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.OpenInNew, null) }, "Create environment variables")))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.FilesAccordion.ConnectorPopup, () => this.safeSetState({ open: true }));
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.FilesAccordion.ConnectorPopup);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AddFilesPopup.js":
/*!************************************************!*\
  !*** ./lib/components/deploy/AddFilesPopup.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddFilesPopup": () => (/* binding */ AddFilesPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./fileBrowser/FileBrowser */ "./lib/components/deploy/fileBrowser/FileBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_3__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class AddFilesPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedFiles = () => [];
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleAdd = () => {
            const files = this.getSelectedFiles();
            if (files.length > 0) {
                this.props.onFilesAdded(files);
                this.handleClose();
            }
        };
        this.handleKeyDown = (event) => {
            // The enter has to be a timeout because without it the file gets added but the popup doesn't close
            if (event.key === 'Enter')
                setTimeout(() => this.handleAdd(), 0);
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.request = async (path) => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'api/contents/' + path;
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: Object.assign({ display: 'inline-flex', width: '50%' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.SkinnyButton, { onClick: this.handleClickOpen, disableElevation: true, color: "primary", variant: "contained", fullWidth: true, sx: { margin: '6px' } }, "+ Upload"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Select files or directories")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: 'contained', color: 'primary', onClick: this.handleAdd }, "Add")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.IconButton, { size: 'large', onClick: this.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_7__["default"], { sx: { maxHeight: 'calc(100% - 60px - 2px)' }, request: this.request, onAdd: this.handleAdd, getSelectedFiles: (getSelectedFiles) => this.getSelectedFiles = getSelectedFiles }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.FilesAccordion.UploadPopup, () => this.safeSetState({ open: true }));
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            _Global__WEBPACK_IMPORTED_MODULE_5__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_5__.Global.Target.DeployTab.FilesAccordion.UploadPopup);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AmazonS3ConnectorPopup.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/AmazonS3ConnectorPopup.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AmazonS3ConnectorPopup": () => (/* binding */ AmazonS3ConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Dropdown.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/* harmony import */ var _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/AWSRegions */ "./lib/models/AWSRegions.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const defaultState = {
    region: _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__.AWSRegions.US_EAST_1.region,
    bucketName: '',
    objectKey: '',
    accessKeyID: '',
    secretAccessKey: '',
};
class AmazonS3ConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__.DataService.AMAZON_S3, description: 'Access an S3 bucket', header: 'Connect to an Amazon S3 bucket or object.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.region, saveValue: (value) => this.safeSetState({ region: value }), label: 'Region', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, values: _models_AWSRegions__WEBPACK_IMPORTED_MODULE_1__.AWSRegions.values.map(x => { return { value: x.region, description: x.description }; }), helperText: 'The service region as specified in S3 documentation.' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.objectKey, saveValue: (value) => this.safeSetState({ objectKey: value }), label: 'Object Key', helperText: 'If you leave this blank, we will transfer the entire bucket.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.accessKeyID, saveValue: (value) => this.safeSetState({ accessKeyID: value }), label: 'Access Key ID', helperText: 'The Access Key ID as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.secretAccessKey, saveValue: (value) => this.safeSetState({ secretAccessKey: value }), label: 'Secret Access Key', helperText: 'The Secret Access Key as specified in S3 documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/AnnotationInput.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/AnnotationInput.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotationInput": () => (/* binding */ AnnotationInput)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const StyledInput = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        lineHeight: '1',
        fontWeight: 'normal',
        width: '200px',
    },
    input: {
        padding: '2px 0px',
    },
    underline: {
        '&:hover:before': {
            borderBottomWidth: '1px !important',
        },
        '&:before': {
            borderBottomWidth: '0px',
        },
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Input);
class AnnotationInput extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const fontSize = getComputedStyle(document.documentElement).getPropertyValue('--jp-ui-font-size1').trim();
            const fontFamily = getComputedStyle(document.documentElement).getPropertyValue('--jp-ui-font-family').trim();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { position: 'relative', display: 'inline-flex' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledInput, { inputRef: this.textField, value: this.state.value, onChange: (event) => {
                        const value = event.target.value;
                        this.safeSetState({ value: value });
                    }, onKeyDown: (e) => {
                        if (e.key === 'Enter') {
                            this.textField.current.blur();
                        }
                    }, onBlur: () => this.props.saveValue(this.state.value), placeholder: this.props.placeholder }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Edit, { sx: { opacity: this.state.value == '' ? 0.5 : 0, height: '12px', width: '12px', margin: '4px', position: 'absolute', left: Math.min(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.getStringWidth(this.state.value == "" ? this.props.placeholder : this.state.value, fontSize + " " + fontFamily), 200) + 'px' } })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.state = {
            value: this.props.getValue(),
            editing: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/AzureBlobStorageConnector.js":
/*!************************************************************!*\
  !*** ./lib/components/deploy/AzureBlobStorageConnector.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AzureBlobStorageConnectorPopup": () => (/* binding */ AzureBlobStorageConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    containerName: '',
    blobName: '',
    connectionString: '',
};
class AzureBlobStorageConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.AZURE_BLOB_STORAGE, description: 'Access an Azure Blob Storage container', header: 'Connect to an Azure Blob Storage container or blob.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.containerName, saveValue: (value) => this.safeSetState({ containerName: value }), label: 'Container Name', helperText: 'The Container Name as specified in Azure documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.blobName, saveValue: (value) => this.safeSetState({ blobName: value }), label: 'Blob Name', helperText: 'If you leave this blank, we will transfer the entire container.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.connectionString, saveValue: (value) => this.safeSetState({ connectionString: value }), label: 'Connection String', helperText: 'The Connection String as specified in Azure documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/DataConnectorIdentity.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/DataConnectorIdentity.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataConnectorIdentity": () => (/* binding */ DataConnectorIdentity)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItem */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItem.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class DataConnectorIdentity extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({}, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationBrowser_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__["default"], { key: this.props.dataService, integrationMetadata: {
                        integrationType: _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__.IntegrationType.DATA_CONNECTOR,
                        name: this.props.description,
                        dataService: this.props.dataService,
                    }, selected: false, handleButtonClick: this.props.handleClick, buttonText: 'Create', buttonColor: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.PRIMARY, onClick: () => false, onDoubleClick: () => false }))
            // <DIV sx={{margin: '6px'}}>
            //     <DIV sx={{display: 'inline-flex', width: '100%', height: '40px'}}>
            //         <DIV className={this.props.iconClass} sx={{width: '30px', margin: '6px 6px 6px 12px'}}/>
            //         <DIV sx={{margin: 'auto 6px', lineHeight: '14px', width: this.props.description && '92px'}}>
            //             <DIV sx={{fontWeight: 'bold'}}>
            //                 {this.props.provider}
            //             </DIV>
            //             {this.props.service != '' && (
            //                 <DIV>
            //                     {this.props.service}
            //                 </DIV>
            //             )}
            //         </DIV>
            //         {this.props.description && <DIV sx={{flexGrow: 1, margin: 'auto 12px', maxWidth: '160px'}}>
            //             {this.props.description}
            //         </DIV>}
            //         {this.props.handleClick && <Button
            //             onClick={this.props.handleClick}
            //             sx={{
            //             //     padding: '6px',
            //             //     fontWeight: 'bold',
            //             //     height: '24px',
            //                 margin: 'auto 12px',
            //             }}
            //             variant='outlined'
            //             color='primary'
            //             disableElevation
            //         >
            //             Create   
            //         </Button>}
            //     </DIV>
            // </DIV>
            );
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/EnvironmentVariableIdentity.js":
/*!**************************************************************!*\
  !*** ./lib/components/deploy/EnvironmentVariableIdentity.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EnvironmentVariableIdentity": () => (/* binding */ EnvironmentVariableIdentity)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Colors */ "./lib/Colors.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItem */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItem.js");
/* harmony import */ var _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class EnvironmentVariableIdentity extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({}, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationBrowser_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__["default"], { key: 'environment variable', integrationMetadata: {
                        name: this.props.description,
                        integrationType: _IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__.IntegrationType.ENVIRONMENT_VARIABLE,
                    }, selected: false, handleButtonClick: this.props.handleClick, buttonText: 'Create', buttonColor: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.PRIMARY, onClick: () => false, onDoubleClick: () => false }))
            // <DIV sx={{margin: '6px'}}>
            //     <DIV sx={{display: 'inline-flex', width: '100%', height: '40px'}}>
            //         <DIV className={this.props.iconClass} sx={{width: '30px', margin: '6px 6px 6px 12px'}}/>
            //         <DIV sx={{margin: 'auto 6px', lineHeight: '14px', width: this.props.description && '92px'}}>
            //             <DIV sx={{fontWeight: 'bold'}}>
            //                 {this.props.provider}
            //             </DIV>
            //             {this.props.service != '' && (
            //                 <DIV>
            //                     {this.props.service}
            //                 </DIV>
            //             )}
            //         </DIV>
            //         {this.props.description && <DIV sx={{flexGrow: 1, margin: 'auto 12px', maxWidth: '160px'}}>
            //             {this.props.description}
            //         </DIV>}
            //         {this.props.handleClick && <Button
            //             onClick={this.props.handleClick}
            //             sx={{
            //             //     padding: '6px',
            //             //     fontWeight: 'bold',
            //             //     height: '24px',
            //                 margin: 'auto 12px',
            //             }}
            //             variant='outlined'
            //             color='primary'
            //             disableElevation
            //         >
            //             Create   
            //         </Button>}
            //     </DIV>
            // </DIV>
            );
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/EnvironmentVariables.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/EnvironmentVariables.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EnvironmentVariables": () => (/* binding */ EnvironmentVariables)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _AddEnvironmentVariablesPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AddEnvironmentVariablesPopup */ "./lib/components/deploy/AddEnvironmentVariablesPopup.js");
/* harmony import */ var _ResourceEnvironmentVariable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ResourceEnvironmentVariable */ "./lib/components/deploy/ResourceEnvironmentVariable.js");
/* harmony import */ var _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models/IntegrationConfig */ "./lib/models/IntegrationConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class EnvironmentVariables extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const integrations = optumi.config.integrations;
            for (var i = 0; i < integrations.length; i++) {
                if (integrations[i].name === name)
                    return true;
            }
            return false;
        };
        this.key = 0;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
            const environmentVariables = optumi.environmentVariables;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddEnvironmentVariablesPopup__WEBPACK_IMPORTED_MODULE_2__.AddEnvironmentVariablesPopup, { onEnvironmentVariablesAdded: async (metadatas) => {
                                for (let environmentVariableModel of metadatas) {
                                    // Don't try to add the same file/directory more than once
                                    if (this.nameHasError(environmentVariableModel.name))
                                        continue;
                                    const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                                    const optumi = tracker.getMetadata();
                                    var integrations = optumi.config.integrations;
                                    integrations.push(new _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_3__.EnvironmentVariableConfig({
                                        name: environmentVariableModel.name,
                                    }));
                                    console.log(optumi);
                                    tracker.setMetadata(optumi);
                                }
                            } })),
                    environmentVariables.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                            fontSize: '12px',
                            lineHeight: '14px',
                            padding: '3px 6px 3px 6px',
                        } }, "None")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, environmentVariables.map((value) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceEnvironmentVariable__WEBPACK_IMPORTED_MODULE_4__.ResourceEnvironmentVariable, { key: value.name + this.key++, environmentVariable: value, handleFileDelete: () => {
                            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                            const optumi = tracker.getMetadata();
                            const integrations = optumi.config.integrations;
                            for (var i = 0; i < integrations.length; i++) {
                                if (integrations[i].name === value.name) {
                                    integrations.splice(i, 1);
                                    break;
                                }
                            }
                            // optumi.upload.files = (optumi.upload.files as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                            tracker.setMetadata(optumi);
                            this.fileChecker.removeEnvironmentVariable(value.name);
                        }, noLongerExists: this.fileChecker.environmentVariableMissing(value.name) }))))))));
        };
        this.handleThemeChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.connect(this.handleMetadataChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        // private safeSetState = (map: any) => {
        // 	if (this._isMounted) {
        // 		let update = false
        // 		try {
        // 			for (const key of Object.keys(map)) {
        // 				if (JSON.stringify(map[key]) !== JSON.stringify((this.state as any)[key])) {
        // 					update = true
        // 					break
        // 				}
        // 			}
        // 		} catch (error) {
        // 			update = true
        // 		}
        // 		if (update) {
        // 			if (Global.shouldLogOnSafeSetState) console.log('SafeSetState (' + new Date().getSeconds() + ')');
        // 			this.setState(map)
        // 		} else {
        // 			if (Global.shouldLogOnSafeSetState) console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
        // 		}
        // 	}
        // }
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {};
        this.fileChecker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileChecker;
    }
}


/***/ }),

/***/ "./lib/components/deploy/FileList.js":
/*!*******************************************!*\
  !*** ./lib/components/deploy/FileList.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileList": () => (/* binding */ FileList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _FileTree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../FileTree */ "./lib/components/FileTree.js");
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _models_Module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models/Module */ "./lib/models/Module.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







class FileList extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getFileHidableIcon = (file) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.props.app.getAppStatus() != _models_Module__WEBPACK_IMPORTED_MODULE_3__.Status.COMPLETED || _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.pathExists(file.path + file.file) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => this.downloadFiles([file.metadata[0]]), sx: { width: '36px', height: '36px', padding: '4px 3px 2px 3px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.GetApp, { sx: { width: '30px', height: '30px', padding: '3px' } }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { lineHeight: '34px', opacity: '0.5', margin: 'auto 6px' } }, "File removed"))));
        };
        this.getDirectoryHidableIcon = (directory) => {
            // TODO:JJ Disable this if the entire directory has been disabled
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.props.app.getAppStatus() != _models_Module__WEBPACK_IMPORTED_MODULE_3__.Status.COMPLETED || _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.directoryExists(directory.path + directory.file) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => this.downloadFiles(_FileTree__WEBPACK_IMPORTED_MODULE_5__.FileTree.childrenToMetadata(directory, false), directory.path), sx: { width: '36px', height: '36px', padding: '4px 3px 2px 3px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.GetApp, { sx: { width: '30px', height: '30px', padding: '3px' } }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { lineHeight: '34px', opacity: '0.5', margin: 'auto 6px' } }, "Directory removed"))));
        };
        this.downloadFiles = (files, directory = null) => {
            const withHashes = [];
            const withoutHashes = [];
            for (let file of files) {
                if (file.hash) {
                    withHashes.push(file);
                }
                else {
                    withoutHashes.push(file);
                }
            }
            if (withHashes.length > 0)
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.downloadFiles(withHashes[0].path, withHashes, false, directory);
            if (withoutHashes.length > 0)
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.getNotebookOutputFiles(withoutHashes[0].path, withoutHashes, this.props.app.uuid, this.props.app.modules[0].uuid, false, directory);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '12px', width: "100%" } }, this.getFiles()));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.state = {
            overwrite: false
        };
    }
    getFiles() {
        const inputFiles = [];
        const outputFiles = [];
        for (let module of this.props.app.modules) {
            if (module.files) {
                for (let file of module.files) {
                    outputFiles.push(file);
                }
            }
        }
        for (let file of this.props.app.files) {
            inputFiles.push(file);
        }
        var sortedInput = inputFiles.sort(_utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_6__["default"].sortFiles);
        var sortedOutput = outputFiles.sort(_utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_6__["default"].sortFiles);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { fontWeight: 'bold' } }, "Input files"),
                sortedInput.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, "No input files")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FileTree__WEBPACK_IMPORTED_MODULE_5__.FileTree, { files: sortedInput, fileHidableIcon: this.getFileHidableIcon, directoryHidableIcon: this.getDirectoryHidableIcon }))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { fontWeight: 'bold', marginTop: '16px' } }, "Output files"),
                sortedOutput.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, "No output files")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FileTree__WEBPACK_IMPORTED_MODULE_5__.FileTree, { files: sortedOutput, fileHidableIcon: this.getFileHidableIcon, directoryHidableIcon: this.getDirectoryHidableIcon })))));
    }
}


/***/ }),

/***/ "./lib/components/deploy/Files.js":
/*!****************************************!*\
  !*** ./lib/components/deploy/Files.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataSources": () => (/* binding */ DataSources)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../models/FileUploadConfig */ "./lib/models/FileUploadConfig.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _AddFilesPopup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AddFilesPopup */ "./lib/components/deploy/AddFilesPopup.js");
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _AddDataConnectorsPopup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AddDataConnectorsPopup */ "./lib/components/deploy/AddDataConnectorsPopup.js");
/* harmony import */ var _ResourceFile__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ResourceFile */ "./lib/components/deploy/ResourceFile.js");
/* harmony import */ var _ResourceDataConnector__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ResourceDataConnector */ "./lib/components/deploy/ResourceDataConnector.js");
/* harmony import */ var _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../models/IntegrationConfig */ "./lib/models/IntegrationConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/











class DataSources extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.pathHasError = (path) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const upload = optumi.config.upload;
            const files = upload.files;
            for (var i = 0; i < files.length; i++) {
                if (files[i].path === path)
                    return true;
            }
            return false;
        };
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const integrations = optumi.config.integrations;
            for (var i = 0; i < integrations.length; i++) {
                if (integrations[i].name === name)
                    return true;
            }
            return false;
        };
        this.key = 0;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
            const files = optumi.upload.files;
            const dataConnectors = optumi.dataConnectors;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%', display: 'inline-flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_2__["default"], { open: this.state.filesTooBig.length > 0, headerText: "Warning", bodyText: (() => {
                            const problems = this.state.filesTooBig.map(x => x.path + ' (' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__["default"].styleCapacityUnitValue()(x.size) + ')').join('\n');
                            return `The following files exceed the maximum upload size (${_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.MAX_UPLOAD_SIZE)}):\n\n` + problems + `\n\nTo access larger data, use data connectors.`;
                        })(), continue: {
                            text: `OK`,
                            onContinue: (prevent) => {
                                this.safeSetState({ filesTooBig: [] });
                            },
                            color: `error`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddFilesPopup__WEBPACK_IMPORTED_MODULE_4__.AddFilesPopup, { onFilesAdded: async (metadatas) => {
                            const filesTooBig = [];
                            for (let fileModel of metadatas) {
                                fileModel.path = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.convertJupyterPathToOptumiPath(fileModel.path);
                                // Don't try to add the same file/directory more than once
                                if (this.pathHasError(fileModel.path))
                                    continue;
                                const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                                const optumi = tracker.getMetadata();
                                var files = optumi.config.upload.files;
                                if (fileModel.type != 'directory') {
                                    if (fileModel.size > _Global__WEBPACK_IMPORTED_MODULE_1__.Global.MAX_UPLOAD_SIZE) {
                                        filesTooBig.push(fileModel);
                                    }
                                    else {
                                        files.push(new _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_5__.FileUploadConfig({
                                            hash: fileModel.hash,
                                            path: fileModel.path,
                                            size: fileModel.size,
                                            created: fileModel.created,
                                            lastModified: fileModel.last_modified,
                                            type: fileModel.type,
                                            mimetype: fileModel.mimetype,
                                            enabled: true,
                                        }));
                                    }
                                }
                                else {
                                    const directoryContents = (await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_6__["default"].getRecursiveTree(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.convertOptumiPathToJupyterPath(fileModel.path)));
                                    const directoryPaths = [];
                                    for (let metadata of directoryContents) {
                                        if (metadata.size > _Global__WEBPACK_IMPORTED_MODULE_1__.Global.MAX_UPLOAD_SIZE) {
                                            filesTooBig.push(metadata);
                                        }
                                        else {
                                            directoryPaths.push(metadata.path);
                                        }
                                    }
                                    if (directoryPaths.length > 0) {
                                        files.push(new _models_FileUploadConfig__WEBPACK_IMPORTED_MODULE_5__.FileUploadConfig({
                                            hash: fileModel.hash,
                                            path: fileModel.path,
                                            size: fileModel.size,
                                            created: fileModel.created,
                                            lastModified: fileModel.last_modified,
                                            type: fileModel.type,
                                            mimetype: fileModel.mimetype,
                                            enabled: true,
                                        }));
                                    }
                                }
                                tracker.setMetadata(optumi);
                                _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker.uploadFiles(fileModel);
                            }
                            if (filesTooBig.length > 0) {
                                this.safeSetState({ filesTooBig: filesTooBig });
                            }
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddDataConnectorsPopup__WEBPACK_IMPORTED_MODULE_7__.AddDataConnectorsPopup, { onDataConnectorsAdded: async (metadatas) => {
                            for (let dataConnectorModel of metadatas) {
                                // Don't try to add the same file/directory more than once
                                if (this.nameHasError(dataConnectorModel.name))
                                    continue;
                                const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                                const optumi = tracker.getMetadata();
                                var integrations = optumi.config.integrations;
                                integrations.push(new _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__.DataConnectorConfig({
                                    name: dataConnectorModel.name,
                                    dataService: dataConnectorModel.dataService,
                                }));
                                tracker.setMetadata(optumi);
                            }
                        } })),
                files.length == 0 && dataConnectors.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                    } }, "None")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    files.map((value) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceFile__WEBPACK_IMPORTED_MODULE_9__.ResourceFile, { key: value.path + this.key++, file: value, handleFileDelete: () => {
                            // Cancel the upload
                            const progress = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker.get(value.path);
                            const compression = progress.filter(x => x.type == 'compression');
                            const upload = progress.filter(x => x.type == 'upload');
                            if (compression.length > 0)
                                compression[0].cancel();
                            if (upload.length > 0)
                                upload[0].cancel();
                            // Remove the file from metadata
                            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                            const optumi = tracker.getMetadata();
                            const files = optumi.config.upload.files;
                            for (var i = 0; i < files.length; i++) {
                                if (files[i].path === value.path) {
                                    files.splice(i, 1);
                                    break;
                                }
                            }
                            // optumi.upload.files = (optumi.upload.files as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                            tracker.setMetadata(optumi);
                            this.fileChecker.removeFile(value.path);
                        }, handleFileEnabledChange: (enabled) => {
                            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                            const optumi = tracker.getMetadata();
                            const upload = optumi.config.upload;
                            const files = upload.files;
                            for (var i = 0; i < files.length; i++) {
                                const file = files[i];
                                if (file.path === value.path) {
                                    file.enabled = enabled;
                                    break;
                                }
                            }
                            tracker.setMetadata(optumi);
                        }, missingLocally: this.fileChecker.fileMissingLocally(value.path), missingInCloud: this.fileChecker.fileMissingInCloud(value.path) }))),
                    dataConnectors.map((value) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResourceDataConnector__WEBPACK_IMPORTED_MODULE_10__.ResourceDataConnector, { key: value.name + this.key++, dataConnector: value, handleFileDelete: () => {
                            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
                            const optumi = tracker.getMetadata();
                            const integrations = optumi.config.integrations;
                            for (var i = 0; i < integrations.length; i++) {
                                if (integrations[i].name === value.name) {
                                    integrations.splice(i, 1);
                                    break;
                                }
                            }
                            // optumi.upload.files = (optumi.upload.files as UploadVarMetadata[]).filter(x => x.path !== (event.currentTarget as HTMLButtonElement).id.replace('-delete', ''));
                            tracker.setMetadata(optumi);
                            this.fileChecker.removeDataConnector(value.name);
                        }, noLongerExists: this.fileChecker.dataConnectorMissing(value.name) })))))));
        };
        this.handleThemeChange = () => this.forceUpdate();
        this.handleMetadataChange = () => {
            this.fileChecker.refreshIntegrations(false);
            this.fileChecker.refreshFiles(false);
            this.forceUpdate();
        };
        this.handleDataConnectorChange = () => {
            this.fileChecker.refreshIntegrations(false);
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.dataConnectorChange.connect(this.handleDataConnectorChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.connect(this.handleMetadataChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.dataConnectorChange.disconnect(this.handleDataConnectorChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            filePath: '',
            filesTooBig: [],
        };
        this.fileChecker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileChecker;
    }
}


/***/ }),

/***/ "./lib/components/deploy/FilesPanel.js":
/*!*********************************************!*\
  !*** ./lib/components/deploy/FilesPanel.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilesPanel": () => (/* binding */ FilesPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _NotificationsPopup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./NotificationsPopup */ "./lib/components/deploy/NotificationsPopup.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _Packages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Packages */ "./lib/components/deploy/Packages.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _Files__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Files */ "./lib/components/deploy/Files.js");
/* harmony import */ var _EnvironmentVariables__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EnvironmentVariables */ "./lib/components/deploy/EnvironmentVariables.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/











class FilesPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata().config;
            const files = optumi.upload.files;
            const dataConnectors = optumi.dataConnectors;
            const fileChecker = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileChecker;
            const [yellowTriangle, redTriangle] = fileChecker.getTriangle(files, dataConnectors);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordion, { variant: 'outlined', expanded: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded, sx: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionSummary, { sx: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.SubHeader, { title: 'Packages' }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__.InfoPopup, { title: 'Packages', popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `List Python packages that your notebook imports. Optumi will pip install these packages onto the machine your session or job will run on.

                                            Each package should go on a separate line:`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("img", { src: "https://drive.google.com/uc?export=view&id=1WePvBvaS_6xgvrljKSp8iaijlnD9MFxL", width: "350" }),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `
                                            To save time you can hit the “Auto-add” button. Optumi will scan your notebook for imported packages and list them for you. However, this is a beta feature and we encourage you to double check that the list is correct.
                                            `)) })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.SPAN, { sx: {
                                margin: 'auto 8px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } }, (() => {
                            const requirements = optumi.upload.requirements;
                            const numRequirements = requirements === '' ? 0 : requirements.split('\n').filter(line => line !== '').length;
                            if (numRequirements > 1)
                                return numRequirements + ' requirements';
                            if (numRequirements > 0)
                                return '1 requirement';
                            return '';
                        })()),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded;
                                if (this._isMounted)
                                    this.forceUpdate();
                            }, sx: { padding: '0px', marginRight: '-3px', width: '30px', transform: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded ? 'rotate(180deg)' : undefined } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Packages__WEBPACK_IMPORTED_MODULE_6__.Packages, null))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordion, { variant: 'outlined', expanded: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.environmentVariablesAccordionExpanded, sx: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionSummary, { sx: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.SubHeader, { title: 'Environment variables' }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__.InfoPopup, { title: 'Environment variables', popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } },
                                        "Environment variables are stored encrypted in the Optumi platform and are a convenient way of accessing credentials or configuration options. You can read more about environment variables in python ",
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: 'https://docs.python.org/3/library/os.html#os.environ', target: '_blank', style: { marginLeft: '3px', color: 'var(--jp-ui-font-color0)', textDecoration: 'underline' } }, "here"))) })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.SPAN, { sx: {
                                margin: 'auto 8px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.environmentVariablesAccordionExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } }, (() => {
                            const environmentVariables = optumi.environmentVariables;
                            if (environmentVariables.length > 1)
                                return environmentVariables.length + ' variables';
                            if (environmentVariables.length > 0)
                                return '1 variable';
                            return '';
                        })()),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.environmentVariablesAccordionExpanded = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.environmentVariablesAccordionExpanded;
                                if (this._isMounted)
                                    this.forceUpdate();
                            }, sx: { padding: '0px', marginRight: '-3px', width: '30px', transform: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.environmentVariablesAccordionExpanded ? 'rotate(180deg)' : undefined } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_EnvironmentVariables__WEBPACK_IMPORTED_MODULE_7__.EnvironmentVariables, null))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordion, { variant: 'outlined', expanded: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded, sx: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionSummary, { sx: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.SubHeader, { title: 'Data sources' }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__.InfoPopup, { title: 'Data sources', popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `Upload local files and access data from supported databases. Optumi will transfer files to the machine your session or job will run on.`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("img", { src: "https://drive.google.com/uc?export=view&id=1scH_eNAfnI5ivkEGfq30fjmpOdBWBmII", width: "350" })) })),
                        (yellowTriangle || redTriangle) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_8__["default"], { reminder: redTriangle ? 'Files are missing, both locally and in cloud storage. Your notebook will not be able to use them.' : 'Files are missing locally. Your notebook will be able to run with files in cloud storage but we will not be able to sync them with local copies.' },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.WarningRounded, { color: redTriangle ? 'error' : 'warning', fontSize: 'small', sx: { marginTop: '4px', marginLeft: '6px' } }))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.SPAN, { sx: {
                                margin: 'auto 8px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } },
                            files.length > 0 && (files.length + ' upload' + (files.length > 1 ? 's' : '')),
                            files.length > 0 && dataConnectors.length > 0 ? ', ' : '',
                            dataConnectors.length > 0 && (dataConnectors.length + ' connector' + (dataConnectors.length > 1 ? 's' : ''))),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded;
                                if (this._isMounted)
                                    this.forceUpdate();
                            }, sx: { padding: '0px', marginRight: '-3px', width: '30px', transform: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded ? 'rotate(180deg)' : undefined } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Files__WEBPACK_IMPORTED_MODULE_9__.DataSources, null))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionSummary, { sx: { cursor: 'default' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.SubHeader, { title: 'Notifications' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.SPAN, { sx: {
                            margin: 'auto 8px',
                            flexGrow: 1,
                            textAlign: 'end',
                            opacity: 0.5,
                            transitionDuration: '217ms',
                            whiteSpace: 'nowrap',
                            fontSize: '12px',
                            fontStyle: 'italic',
                        } }, (() => {
                        let numEnabled = 0;
                        const config = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata().config;
                        if (!config.interactive) {
                            const notifications = config.notifications;
                            if (notifications.jobStartedSMSEnabled)
                                numEnabled++;
                            if (notifications.jobFailedSMSEnabled || notifications.jobCompletedSMSEnabled)
                                numEnabled++;
                            // TODO:JJ This currently does not refresh automatically when Global.user.notificationsEnabled changes, and I wasn't sure how to quickly do this.
                            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled && numEnabled > 0) {
                                return numEnabled == 1 ? numEnabled + ' message' : numEnabled + ' messages';
                            }
                        }
                    })()),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_NotificationsPopup__WEBPACK_IMPORTED_MODULE_10__.NotificationsPopup, { onClose: () => this.forceUpdate(), disabled: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata().config.interactive }))));
        };
        this.handleLabShellChange = () => { this.forceUpdate(); };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.PackagesAccordion, () => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.packagesAccordionExpanded = true;
                if (this._isMounted)
                    this.forceUpdate();
            });
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.FilesAccordion, () => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.filesAccordionExpanded = true;
                if (this._isMounted)
                    this.forceUpdate();
            });
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileChecker.start();
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.labShell.currentChanged.connect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileChecker.stop();
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.labShell.currentChanged.disconnect(this.handleLabShellChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.PackagesAccordion);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.FilesAccordion);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {};
    }
}


/***/ }),

/***/ "./lib/components/deploy/GPUChipPopper.js":
/*!************************************************!*\
  !*** ./lib/components/deploy/GPUChipPopper.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GPUChipPopper": () => (/* binding */ GPUChipPopper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _ChipPopper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ChipPopper */ "./lib/components/ChipPopper.js");
/* harmony import */ var _ChipSlider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../ChipSlider */ "./lib/components/ChipSlider.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Switch.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class GPUChipPopper extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getMinMaxMemory = () => {
            const cardValue = this.getCardValue();
            const machines = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines;
            if (cardValue == 'U')
                return [machines.graphicsMemoryMin, machines.graphicsMemoryMax];
            return [machines.getGraphicsMemoryByCardMin(cardValue), machines.getGraphicsMemoryByCardMax(cardValue)];
        };
        this.getHeaderDescription = () => {
            const required = this.getRequiredValue();
            if (!required)
                return `Any`;
            const cardValue = this.getCardValue();
            var cardDesc = cardValue == 'U' ? '' : cardValue;
            const minMax = this.getMinMaxMemory();
            const min = minMax[0];
            const max = minMax[1];
            const styleUnit = _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleCapacityUnit();
            const styleValue = _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleShortCapacityValue();
            const value = [...this.getRAMValue()];
            var ramDesc = '';
            if (value[0] == -1)
                value[0] = min;
            if (value[1] == -1)
                value[1] = max;
            if (value[0] === min && value[1] === max) {
                // Do nothing
            }
            else if (value[0] !== min && value[1] !== max) {
                const maxUnit = styleUnit(value[1]);
                const minValue = styleValue(value[0], maxUnit);
                const maxValue = styleValue(value[1]);
                if (minValue == maxValue)
                    ramDesc = `${minValue} ${styleUnit(value[1])}`;
                else
                    ramDesc = `${minValue}-${maxValue} ${styleUnit(value[1])}`;
            }
            else if (value[0] !== min) {
                ramDesc = `Min ${styleValue(value[0])} ${styleUnit(value[0])}`;
            }
            else if (value[1] !== max) {
                ramDesc = `Max ${styleValue(value[1])} ${styleUnit(value[1])}`;
            }
            if (!(cardDesc || ramDesc))
                return 'Required';
            if (cardDesc && ramDesc)
                return cardDesc + ', ' + ramDesc;
            return cardDesc + ramDesc;
        };
        this.getChipDescription = () => {
            var desc = this.getHeaderDescription();
            if (desc.includes(','))
                return desc.replace(',', ':');
            return 'GPU: ' + desc;
        };
        this.handleCardChange = (event, child) => {
            const value = event.target.value;
            this.safeSetState({ selectedCard: value });
            this.saveCardValue(value);
        };
        this.getCardItems = () => {
            var cardItems = new Array();
            cardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.StyledMenuItem, { key: 'U', value: 'U' }, "Any"));
            const availableCards = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.graphicsCards;
            for (var i = 0; i < availableCards.length; i++) {
                var value = availableCards[i];
                cardItems.push(react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.StyledMenuItem, { key: value, value: value }, value));
            }
            return cardItems;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const required = this.getRequiredValue();
            const minMaxMemory = this.getMinMaxMemory();
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipPopper__WEBPACK_IMPORTED_MODULE_3__.ChipPopper, { sx: { width: 'calc(50% - 12px)', margin: '0px 6px 6px' }, title: 'GPU', color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.GPU, clearValue: () => {
                    this.saveRequiredValue(false);
                }, getChipDescription: this.getChipDescription, getHeaderDescription: this.getHeaderDescription, popperContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        display: 'flex',
                        flexDirection: 'column',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'inline-flex', width: '100%', marginTop: '12px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { sx: { margin: '6px 0px' } }, "Required"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Switch, { sx: { padding: '0px' }, getValue: this.getRequiredValue, saveValue: this.saveRequiredValue, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.GPU }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { flexGrow: 4 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { sx: { margin: '6px 0px' } }, "Type"),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.StyledSelect, { sx: { margin: 'auto 0px', height: '25px', padding: '3px 24px 3px 6px' }, disabled: !required, value: this.state.selectedCard, onChange: this.handleCardChange, SelectDisplayProps: { style: { width: '68px', paddingTop: 0.25, paddingRight: 2, paddingBottom: 0.25, paddingLeft: 0.5 } }, MenuProps: { MenuListProps: { style: { paddingTop: 0.5, paddingBottom: 0.5 } } }, displayEmpty: true, inputProps: { 'aria-label': 'Without label' } }, this.getCardItems())),
                    _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.snapToInventoryEnabled ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_6__.ChipSlider, { key: this.state.selectedCard + '-snap', disabled: !required, getValue: this.getRAMValue, saveValue: this.saveRAMValue, label: 'Memory', marks: (this.state.selectedCard == 'U' ? _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.graphicsMemory : _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.graphicsMemoryByCard.get(this.state.selectedCard)).map(x => { return { value: x }; }), step: null, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.GPU, styleUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleCapacityUnit(), styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleShortCapacityValue() })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_6__.ChipSlider, { key: this.state.selectedCard + '-no-snap', disabled: !required, getValue: this.getRAMValue, saveValue: this.saveRAMValue, label: 'Memory', min: minMaxMemory[0], max: minMaxMemory[1], step: 1024 * 1024 * 1024, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.GPU, styleUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleCapacityUnit(), styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_2__["default"].styleShortCapacityValue() }))) }));
        };
        this.handleMetadataChange = () => {
            var card = this.getCardValue();
            // TODO:JJ Get this list of valid names/numbers from the available graphics cards
            card = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.graphicsCards.includes(card) ? card : 'U';
            this.safeSetState({
                selectedCard: card,
                required: this.getRequiredValue(),
            });
        };
        this.handleUserChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.connect(this.handleUserChange);
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            // Make sure the metadata is simplified, make sure it is valid with out new approach
            const optumi = tracker.getMetadata();
            optumi.config.graphics.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
            if (optumi.config.graphics.cores == [-1, -1, -1])
                optumi.config.graphics.boardType = 'U';
            tracker.setMetadata(optumi);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        var card = this.getCardValue();
        // TODO:JJ Get this list of valid names/numbers from the available graphics cards
        card = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.graphicsCards.includes(card) ? card : 'U';
        this.state = {
            open: false,
            selectedCard: card,
        };
        this.saveCardValue(this.state.selectedCard);
    }
    getRequiredValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        // TODO:JJ This is kind of hacky
        return graphics.cores[0] != -1;
    }
    async saveRequiredValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        graphics.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        if (value) {
            // TODO:JJ This is kind of hacky
            graphics.cores = [1, -1, -1];
        }
        else {
            // TODO:JJ This is kind of hacky
            graphics.cores = [-1, -1, -1];
            graphics.boardType = 'U';
            graphics.memory = [-1, -1, -1];
        }
        tracker.setMetadata(optumi);
    }
    getCardValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        return graphics.boardType;
    }
    async saveCardValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const graphics = optumi.config.graphics;
        if (graphics.boardType == value)
            return;
        graphics.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        graphics.boardType = value;
        // const machines = Global.user.machines;
        // const min = machines.getGraphicsMemoryByCardMin(value);
        // const max = machines.getGraphicsMemoryByCardMax(value);
        // TODO:JJ Do this for more than just memory
        // if (graphics.memory[0] != -1 && graphics.memory[0] < min) graphics.memory[0] = -1;
        // if (graphics.memory[2] != -1 && graphics.memory[2] < min) graphics.memory[2] = -1;
        // if (graphics.memory[0] > max) graphics.memory[0] = -1;
        // if (graphics.memory[2] > max) graphics.memory[2] = -1;
        graphics.memory[0] = -1;
        graphics.memory[2] = -1;
        tracker.setMetadata(optumi);
    }
    getRAMValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const size = optumi.config.graphics.memory;
        return [size[0], size[2]];
    }
    saveRAMValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.graphics.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        optumi.config.graphics.memory = [value[0], -1, value[1]];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/GoogleCloudStorageConnectorPopup.js":
/*!*******************************************************************!*\
  !*** ./lib/components/deploy/GoogleCloudStorageConnectorPopup.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GoogleCloudStorageConnectorPopup": () => (/* binding */ GoogleCloudStorageConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    bucketName: '',
    serviceAccountKey: '',
};
class GoogleCloudStorageConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_CLOUD_STORAGE, description: 'Access a Cloud Storage bucket', header: 'Connect to a Google Cloud Storage bucket using a Service Account.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in Google Cloud Storage documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.serviceAccountKey, saveValue: (value) => this.safeSetState({ serviceAccountKey: value }), label: 'Service Account Key', helperText: 'The contents of the credentials file generated for your Google Service Account.', helperLink: { link: 'https://cloud.google.com/iam/docs/service-accounts', text: 'learn more' }, labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, multiline: true, minLines: 5 }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/GoogleDriveConnectorPopup.js":
/*!************************************************************!*\
  !*** ./lib/components/deploy/GoogleDriveConnectorPopup.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GoogleDriveConnectorPopup": () => (/* binding */ GoogleDriveConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    fileID: '',
    serviceAccountKey: '',
};
class GoogleDriveConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_DRIVE, description: 'Access a Drive file', header: 'Connect to a Google Drive file using a Service Account.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.fileID, saveValue: (value) => this.safeSetState({ fileID: value }), label: 'File ID', helperText: 'The unique ID found in the sharable link.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.serviceAccountKey, saveValue: (value) => this.safeSetState({ serviceAccountKey: value }), label: 'Service Account Key', helperText: 'The contents of the credentials file generated for your Google Service Account.', helperLink: { link: 'https://cloud.google.com/iam/docs/service-accounts', text: 'learn more' }, labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, multiline: true, minLines: 5 }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js":
/*!************************************************************************!*\
  !*** ./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntegrationType": () => (/* binding */ IntegrationType),
/* harmony export */   "default": () => (/* binding */ IntegrationBrowser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _IntegrationDirListing__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationDirListing */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListing.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




// import DataConnectorFilterBox from './DataConnectorFilterBox';
var IntegrationType;
(function (IntegrationType) {
    IntegrationType["DATA_CONNECTOR"] = "data connector";
    IntegrationType["ENVIRONMENT_VARIABLE"] = "environment variable";
    IntegrationType["NONE"] = "";
    IntegrationType["ALL"] = "all";
})(IntegrationType || (IntegrationType = {}));
class IntegrationBrowser extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelected = () => {
            return this.getSelected();
        };
        this.request = async () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/get-integrations';
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.handleOpen = (file) => {
            if (this.props.onAdd)
                this.props.onAdd();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-FileBrowser', sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationDirListing__WEBPACK_IMPORTED_MODULE_3__["default"], { filter: this.state.filter, integrations: this.state.integrations, onOpen: this.handleOpen, getSelected: this.props.getSelected && (getSelected => this.getSelected = getSelected), handleDelete: this.props.handleDelete, type: this.props.type })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.request().then(json => {
                this.safeSetState({ integrations: this.props.type == IntegrationType.DATA_CONNECTOR ? (json.integrations.filter((x) => x.integrationType == IntegrationType.DATA_CONNECTOR)) : this.props.type == IntegrationType.ENVIRONMENT_VARIABLE ? (json.integrations.filter((x) => x.integrationType == IntegrationType.ENVIRONMENT_VARIABLE)) : (json.integrations)
                });
                _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastIntegrations = json.integrations;
            });
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = this.oldOpen;
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelected)
            this.props.getSelected(this.getSelected);
        this.state = {
            integrations: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lastIntegrations,
            filter: '',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListing.js":
/*!***************************************************************************!*\
  !*** ./lib/components/deploy/IntegrationBrowser/IntegrationDirListing.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IntegrationDirListing)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _IntegrationDirListingContent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IntegrationDirListingContent */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingContent.js");
/* harmony import */ var _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class IntegrationDirListing extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sort = (a, b) => {
                const sortDirection = (a, b) => a.localeCompare(b) * (this.state.sorted === 'forward' ? 1 : -1);
                if (this.state.selected === 'name') {
                    if (a.name === b.name)
                        return a.integrationType.localeCompare(b.integrationType);
                    return sortDirection(a.name, b.name);
                }
                else if (this.state.selected === 'integrationType') {
                    if (a.integrationType === b.integrationType)
                        return a.name.localeCompare(b.name);
                    return sortDirection(a.integrationType, b.integrationType);
                }
            };
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing jp-FileBrowser-listing', sx: { overflow: 'hidden' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-header' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-headerItem jp-id-data-service' + (this.state.selected === 'integrationType' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'integrationType') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'dataService', sorted: 'forward' });
                            }
                        }, sx: { flex: '0 0 210px', textAlign: 'left', padding: '4px 12px 2px 17px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemText' }, this.props.type == _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__.IntegrationType.DATA_CONNECTOR ? 'Data service' : 'Integration type'),
                        this.state.selected === 'integrationType' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemIcon', sx: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) }))))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-headerItem jp-id-name' + (this.state.selected === 'name' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'name') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'name', sorted: 'forward' });
                            }
                        }, sx: { padding: '4px 12px 2px 17px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemText' }, "Name"),
                        this.state.selected === 'name' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemIcon', sx: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { marginBottom: '6px' } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationDirListingContent__WEBPACK_IMPORTED_MODULE_4__["default"], { filter: this.props.filter, integrations: this.props.integrations, handleDelete: this.props.handleDelete, onOpen: this.props.onOpen, sort: sort, getSelected: this.props.getSelected }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { marginBottom: '6px' } })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            selected: 'name',
            sorted: 'forward',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingContent.js":
/*!**********************************************************************************!*\
  !*** ./lib/components/deploy/IntegrationBrowser/IntegrationDirListingContent.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IntegrationDirListingContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../Colors */ "./lib/Colors.js");
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IntegrationDirListingItem */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItem.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class IntegrationDirListingContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            // The code in the RegExp converts 'tom' into '^[^t]*t[^o]*o[^m]*m.*$' which matches strings where those characters appear in that order while only checking each character once during the match for efficiency
            const filter = (integration) => integration.name.replace(new RegExp('^' + this.props.filter.replace(/(.)/gi, '[^$1]*$1') + '.*$', 'i'), '').length === 0;
            const sortedIntegrations = this.props.integrations.filter(filter).sort(this.props.sort);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.UL, { className: 'jp-DirListing-content', sx: { overflowY: 'auto' } }, sortedIntegrations.length == 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__["default"], { key: 'empty', integrationMetadata: {
                        name: '--',
                        integrationType: _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_3__.IntegrationType.NONE,
                    }, selected: false, onClick: () => false, onDoubleClick: () => false }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, sortedIntegrations.map(integration => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationDirListingItem__WEBPACK_IMPORTED_MODULE_2__["default"], { key: integration.path + integration.name, integrationMetadata: integration, selected: this.state.selected.includes(integration), handleButtonClick: this.props.handleDelete, buttonText: 'Delete', buttonColor: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.ERROR, onClick: (event) => {
                    if (this.props.getSelected === undefined)
                        return; // If someone doesn't want what is selected, don't select.
                    if (this.firstClicked === undefined) {
                        if (event.shiftKey) {
                            this.firstClicked = sortedIntegrations[0];
                            this.lastClicked = sortedIntegrations[0];
                        }
                        else {
                            this.firstClicked = integration;
                        }
                    }
                    if (event.ctrlKey) {
                        const newSelected = [...this.state.selected];
                        if (newSelected.includes(integration)) {
                            newSelected.splice(newSelected.indexOf(integration), 1);
                        }
                        else {
                            newSelected.push(integration);
                        }
                        this.safeSetState({ selected: newSelected });
                        this.lastClicked = integration;
                    }
                    else if (event.shiftKey) {
                        const newSelected = [...this.state.selected];
                        let index = sortedIntegrations.indexOf(integration);
                        const lastClickedIndex = sortedIntegrations.indexOf(this.lastClicked);
                        const direction = index < lastClickedIndex ? 1 : -1;
                        while (!newSelected.includes(sortedIntegrations[index]) && index !== lastClickedIndex) {
                            newSelected.push(sortedIntegrations[index]);
                            index += direction;
                        }
                        if (index === lastClickedIndex && !newSelected.includes(this.lastClicked))
                            newSelected.push(this.lastClicked);
                        this.safeSetState({ selected: newSelected });
                    }
                    else {
                        this.safeSetState({ selected: [integration] });
                        this.firstClicked = integration;
                        this.lastClicked = integration;
                    }
                }, onDoubleClick: (event) => {
                    if (!event.ctrlKey && !event.shiftKey)
                        this.props.onOpen(integration);
                } })))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelected)
            this.props.getSelected(() => this.state.selected);
        this.state = {
            selected: []
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItem.js":
/*!*******************************************************************************!*\
  !*** ./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItem.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IntegrationDirListingItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/Terminal */ "./node_modules/@mui/icons-material/Terminal.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    root: {
        display: 'inline-block',
        height: '20px',
        padding: '3px 6px',
        lineHeight: '12px',
        fontSize: '12px',
        minWidth: '0px',
        margin: 'auto',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button);
const dataConnectorTypes = [
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.AMAZON_S3, provider: 'Amazon', service: 'S3' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.AZURE_BLOB_STORAGE, provider: 'Azure', service: 'Blob Storage' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.WASABI, provider: 'Wasabi', service: '' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_DRIVE, provider: 'Google', service: 'Drive' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.GOOGLE_CLOUD_STORAGE, provider: 'Google', service: 'Cloud Storage' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.KAGGLE, provider: 'Kaggle', service: '' },
    { dataService: _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.EMPTY, provider: '', service: '--' },
];
class IntegrationDirListingItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const integrationMetadata = this.props.integrationMetadata;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, { className: 'jp-DirListing-item' + (this.props.selected ? ' jp-mod-selected' : ''), sx: { lineHeight: '25px', padding: '4px 17px' }, onClick: (event) => this.props.onClick(event), onDoubleClick: (event) => this.props.onDoubleClick(event) },
                this.props.integrationMetadata.integrationType == _IntegrationBrowser__WEBPACK_IMPORTED_MODULE_5__.IntegrationType.ENVIRONMENT_VARIABLE ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_6__["default"], { sx: Object.assign({
                            margin: '2.5px auto',
                            width: '20px',
                            height: '20px',
                        }) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { className: 'jp-DirListing-itemModified', sx: { marginLeft: '8px' }, style: { flex: '0 0 185px', textAlign: 'left' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { fontWeight: 'bold', marginRight: '0.25em' } }, "Environment variable"))))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__["default"], { sx: {
                            margin: '2.5px auto',
                            width: '20px',
                            height: '20px',
                        }, dataService: integrationMetadata.dataService }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { className: 'jp-DirListing-itemModified', sx: integrationMetadata.dataService == _IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.EMPTY ? {
                            marginLeft: '-24px',
                            marginRight: '24px',
                        } : {
                            marginLeft: '8px'
                        }, style: { flex: '0 0 185px', textAlign: 'left' } }, (() => {
                        for (const dataConnectorType of dataConnectorTypes) {
                            if (dataConnectorType.dataService === integrationMetadata.dataService) {
                                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { fontWeight: 'bold', marginRight: '0.25em' } }, dataConnectorType.provider),
                                    dataConnectorType.service));
                            }
                        }
                        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, null);
                    })()))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { className: 'jp-DirListing-itemText' }, integrationMetadata.name),
                this.props.handleButtonClick && this.props.buttonColor && this.props.buttonText && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledButton, { onClick: () => this.props.handleButtonClick(this.props.integrationMetadata), variant: 'outlined', color: 'primary', disableElevation: true, sx: {
                        color: this.props.buttonColor,
                        border: '1px solid ' + this.props.buttonColor,
                    } }, this.props.buttonText))));
        };
        this.state = {
            focused: false
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js":
/*!***********************************************************************************!*\
  !*** ./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DataService": () => (/* binding */ DataService),
/* harmony export */   "default": () => (/* binding */ DataConnectorDirListingItemIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



var DataService;
(function (DataService) {
    DataService["AMAZON_S3"] = "amazon s3";
    DataService["AZURE_BLOB_STORAGE"] = "azure blob storage";
    DataService["WASABI"] = "wasabi";
    DataService["GOOGLE_CLOUD_STORAGE"] = "google cloud storage";
    DataService["GOOGLE_DRIVE"] = "google drive";
    DataService["KAGGLE"] = "kaggle";
    DataService["EMPTY"] = "--";
})(DataService || (DataService = {}));
const dataConnectorTypes = [
    { dataService: DataService.AMAZON_S3, iconClass: 'jp-s3-logo' },
    { dataService: DataService.AZURE_BLOB_STORAGE, iconClass: 'jp-azure-logo' },
    { dataService: DataService.WASABI, iconClass: 'jp-wasabi-logo' },
    { dataService: DataService.GOOGLE_DRIVE, iconClass: 'jp-drive-logo' },
    { dataService: DataService.GOOGLE_CLOUD_STORAGE, iconClass: 'jp-cloud-logo' },
    { dataService: DataService.KAGGLE, iconClass: 'jp-kaggle-logo' },
    { dataService: DataService.EMPTY, iconClass: '' },
];
class DataConnectorDirListingItemIcon extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-itemIcon' }, (() => {
                for (const dataConnectorType of dataConnectorTypes) {
                    if (dataConnectorType.dataService === this.props.dataService) {
                        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { title: dataConnectorType.dataService, className: dataConnectorType.iconClass, style: { backgroundSize: 'contain' }, sx: Object.assign({
                                width: '16px',
                                height: '16px',
                                display: 'block'
                            }, this.props.sx) }));
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
            })()));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/KaggleConnectorPopup.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/KaggleConnectorPopup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KaggleConnectorPopup": () => (/* binding */ KaggleConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const defaultState = {
    datasetName: '',
    username: '',
    key: '',
};
class KaggleConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_3__.DataService.KAGGLE, description: 'Access a Kaggle dataset', header: 'Connect to a Kaggle dataset using an API Token.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.datasetName, saveValue: (value) => this.safeSetState({ datasetName: value }), label: 'Dataset Name', helperText: 'The unique data set name as specified in Kaggle documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.username, saveValue: (value) => this.safeSetState({ username: value }), label: 'Username', helperText: 'Your kaggle username.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.TextBox, { getValue: () => this.state.key, saveValue: (value) => this.safeSetState({ key: value }), label: 'Key', helperText: 'The key generated with an API token.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_2__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/NotificationsPopup.js":
/*!*****************************************************!*\
  !*** ./lib/components/deploy/NotificationsPopup.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationsPopup": () => (/* binding */ NotificationsPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _core_NotificationContent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/NotificationContent */ "./lib/core/NotificationContent.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
class NotificationsPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.handleKeyDown = (event) => {
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ margin: 'auto' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClickOpen, sx: { padding: '0px', marginRight: '-3px', width: '30px', height: '30px' }, disabled: this.props.disabled },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.AddAlert, { sx: { height: '21px' } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Configure Notifications")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            padding: '12px',
                            fontSize: 'var(--jp-ui-font-size1)',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_NotificationContent__WEBPACK_IMPORTED_MODULE_6__.NotificationContent, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadata().config, saveValue: (config) => {
                                const metadata = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadata();
                                metadata.config = config;
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.setMetadata(metadata);
                            }, handleClose: this.handleClose })))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.NotificationsPopup, () => {
                if (!this.props.disabled)
                    this.safeSetState({ open: true });
            });
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.Target.DeployTab.NotificationsPopup);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/OutlinedResourceRadio.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/OutlinedResourceRadio.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OutlinedResourceRadio": () => (/* binding */ OutlinedResourceRadio)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class OutlinedResourceRadio extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.handleMouseOver = (event) => {
            if (this.props.onMouseOver)
                this.props.onMouseOver(event);
        };
        this.handleMouseOut = (event) => {
            if (this.props.onMouseOut)
                this.props.onMouseOut(event);
        };
        this.getStyledButton = (color) => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    textAlign: 'center',
                    fontWeight: 'normal',
                    display: 'inline-flex',
                    padding: '0px 6px',
                    height: '28px',
                    border: '1px solid ' + color + '80',
                    borderRadius: '6px',
                    margin: '1px 6px 6px 6px',
                    width: 'calc(100% - 12px)',
                    transition: 'background-color 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms',
                    overflow: 'hidden',
                    position: 'relative',
                    color: 'var(--jp-ui-font-color1)'
                },
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledButton, { style: { border: this.props.selected ? '1px solid ' + this.props.color : '' }, sx: Object.assign({
                    backgroundColor: this.props.selected ? this.props.color + '40' : '',
                }, this.props.sx), onClick: () => this.props.handleClick(), onMouseOver: this.handleMouseOver, onMouseOut: this.handleMouseOut },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: {
                        flexGrow: 1,
                        lineHeight: '14px',
                        margin: 'auto auto auto 6px',
                        textAlign: 'center',
                        whiteSpace: 'pre-wrap',
                    } }, (this.props.beta ? ' ' : '' /* This extra space is explicitly for 'Session' launch mode so we dont forget to remove the space when we remove the beta label */) + this.props.label),
                this.props.selected ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.CheckCircle, { fontSize: 'small', sx: {
                        fill: this.props.color,
                        margin: 'auto',
                    } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.RadioButtonUnchecked, { fontSize: 'small', sx: {
                        fill: this.props.color + '80',
                        margin: 'auto',
                    } })),
                this.props.beta && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        position: 'absolute',
                        left: '-22px',
                        top: '3px',
                        transform: 'rotate(-45deg)',
                        background: this.props.selected ? this.props.color : this.props.color + '80',
                        color: '#ffffff',
                        fontSize: '9px',
                        lineHeight: '14px',
                        fontWeight: 'bold',
                        padding: '0px 20px',
                    } }, "BETA"))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledButton = this.getStyledButton(this.props.color);
    }
}


/***/ }),

/***/ "./lib/components/deploy/Packages.js":
/*!*******************************************!*\
  !*** ./lib/components/deploy/Packages.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Packages": () => (/* binding */ Packages)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _models_OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../models/OptumiMetadataTracker */ "./lib/models/OptumiMetadataTracker.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Packages extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getRequirementsValue = () => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.config.upload;
            return uploads.requirements;
        };
        this.saveRequirements = (value) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.config.upload;
            uploads.requirements = value.replace(' ', '');
            tracker.setMetadata(optumi);
            return '';
        };
        this.autoAddPackages = () => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            const uploads = optumi.config.upload;
            const requirements = uploads.requirements;
            const newRequirements = _models_OptumiMetadataTracker__WEBPACK_IMPORTED_MODULE_2__.OptumiMetadataTracker.autoAddPackages(requirements, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.tracker.currentWidget.content.model);
            if (newRequirements != requirements) {
                uploads.requirements = newRequirements;
                tracker.setMetadata(optumi);
            }
        };
        this.key = 0;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { width: '100%', display: 'inline-flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SkinnyButton, { sx: { margin: '6px' }, onClick: this.autoAddPackages, disableElevation: true, color: "primary", variant: "contained", fullWidth: true }, "Scan notebook and add")),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.TextBox, { key: optumi.upload.requirements, multiline: true, getValue: this.getRequirementsValue, saveValue: this.saveRequirements, placeholder: 'package==version', sx: { padding: '0px 0px 6px 0px' } }))));
        };
        this.handleThemeChange = () => this.forceUpdate();
        this.handleMetadataChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.connect(this.handleMetadataChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.labShell.currentChanged.disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        // private safeSetState = (map: any) => {
        // 	if (this._isMounted) {
        // 		let update = false
        // 		try {
        // 			for (const key of Object.keys(map)) {
        // 				if (JSON.stringify(map[key]) !== JSON.stringify((this.state as any)[key])) {
        // 					update = true
        // 					break
        // 				}
        // 			}
        // 		} catch (error) {
        // 			update = true
        // 		}
        // 		if (update) {
        // 			if (Global.shouldLogOnSafeSetState) console.log('SafeSetState (' + new Date().getSeconds() + ')');
        // 			this.setState(map)
        // 		} else {
        // 			if (Global.shouldLogOnSafeSetState) console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
        // 		}
        // 	}
        // }
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {};
        this.fileChecker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileChecker;
    }
}


/***/ }),

/***/ "./lib/components/deploy/PreviewLaunchButton.js":
/*!******************************************************!*\
  !*** ./lib/components/deploy/PreviewLaunchButton.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PreviewLaunchButton": () => (/* binding */ PreviewLaunchButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _models_application_App__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../models/application/App */ "./lib/models/application/App.js");
/* harmony import */ var _models_application_LightweightApp__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../models/application/LightweightApp */ "./lib/models/application/LightweightApp.js");
/* harmony import */ var _StatusWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../StatusWrapper */ "./lib/components/StatusWrapper.js");
/* harmony import */ var _models_ComputeConfig__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../models/ComputeConfig */ "./lib/models/ComputeConfig.js");
/* harmony import */ var _models_StorageConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../models/StorageConfig */ "./lib/models/StorageConfig.js");
/* harmony import */ var _models_GraphicsConfig__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../models/GraphicsConfig */ "./lib/models/GraphicsConfig.js");
/* harmony import */ var _models_MemoryConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../models/MemoryConfig */ "./lib/models/MemoryConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/









var retrievingPreview = false;
var updatePreviewAgain = false;
class PreviewLaunchButton extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        // We need to know if the component is mounted to change state
        this._isMounted = false;
        this.polling = false;
        this.timeout = null;
        this.poll = () => {
            // We will poll for a new preview every 10 seconds
            if (this.polling) {
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                this.timeout = setTimeout(() => this.poll(), 10000);
            }
            this.handlePreviewClick(false);
        };
        // To understand whats going on, look at the commented out functions below
        this.handlePreviewClick = (printRecommendations, bypassLimiter) => {
            // For basic mode, we do not need to retrieve a preview, since we know the exact machine
            if (!_Global__WEBPACK_IMPORTED_MODULE_1__.Global.expertModeSelected)
                return;
            const current = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.tracker.currentWidget;
            if (current != null) {
                const config = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
                // await current.context.ready;
                // current.context.save();
                // Make sure the notebook has the correct metadata.
                if (bypassLimiter || !retrievingPreview) {
                    try {
                        retrievingPreview = true;
                        const app = new _models_application_App__WEBPACK_IMPORTED_MODULE_2__.App(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.convertJupyterPathToOptumiPath(current.context.path), JSON.stringify(current.model.toJSON()), config);
                        app.previewNotebook(printRecommendations).then((machines) => {
                            this.safeSetState({
                                machine: machines,
                            });
                            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lastMachine = machines[0];
                            if (updatePreviewAgain) {
                                updatePreviewAgain = false;
                                this.handlePreviewClick(false, true);
                            }
                            else {
                                retrievingPreview = false;
                            }
                        }, () => {
                            retrievingPreview = false;
                        });
                    }
                    catch (err) {
                        console.error(err);
                        retrievingPreview = false;
                    }
                }
                else {
                    updatePreviewAgain = true;
                }
            }
        };
        // This is the logic of the function above incase we want to understand what it is doing easier
        // This function uses two flags, one flag keeps track of when we are actively getting an update, and one keeps track if we need to get another at the end.
        // We do this to not lose any requests that would be dropped between when we last started an update and the last request to update
        // private newHandlePreviewClick = (printRecommendations: boolean, bypassLimiter?: boolean) => {
        // 	if (bypassLimiter || !retrievingPreview) {
        // 		retrievingPreview = true;
        //		try {
        // 			// do the update
        //			...
        //			// after the update completed
        // 			if (updatePreviewAgain) {
        // 				updatePreviewAgain = false;
        // 				this.newHandlePreviewClick(false, true);
        // 			} else {
        // 				retrievingPreview = false;
        // 			}
        //		} catch (exception) {
        //			retrievingPreview = false;
        //		}
        // 	} else {
        // 		updatePreviewAgain = true;
        // 	}
        // }
        // This is the old handle code that was combined with the function above for the current handlePreviewClick
        // private oldHandlePreviewClick = (printRecommendations: boolean) => {
        // 	const current = Global.tracker.currentWidget;
        // 	if (current != null) {
        // 		const app = new App(current.context.path, current.model.toJSON(), "");
        // 		app.previewNotebook(printRecommendations).then((machine: Machine) => {
        // 			this.safeSetState({
        // 				machine: machine,
        // 			});
        // 		});
        // 	}
        // }
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            // var order = 1;
            const metadata = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata();
            const machine = (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.expertModeSelected ? this.state.machine[0] : _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.getMachine(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config.machineAssortment[0]));
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({ width: '100%' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(machine.getPreviewComponent(), { style: {} }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { margin: '6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StatusWrapper__WEBPACK_IMPORTED_MODULE_3__.StatusWrapper, { statusColor: 'var(--jp-layout-color2)' }, new _models_application_LightweightApp__WEBPACK_IMPORTED_MODULE_4__.LightweightApp(metadata.metadata.nbKey, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.tracker.currentWidget.context.path, metadata.config).getLaunchComponent(machine, this.props.balance))),
                " "));
        };
        // We need to force update in case the preview doesn't change but the metadata does
        this.handleMetadataChange = () => {
            try {
                const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata();
                var changed = false;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.expertModeSelected) {
                    // In expert mode, we do not want any specified VM sizes
                    if (optumi.config.machineAssortment.length > 0) {
                        optumi.config.machineAssortment = [];
                        changed = true;
                    }
                }
                else {
                    // In basic mode, we do not want any config except vm sizes
                    if (JSON.stringify(optumi.config.compute) != JSON.stringify(new _models_ComputeConfig__WEBPACK_IMPORTED_MODULE_5__.ComputeConfig())) {
                        optumi.config.compute = new _models_ComputeConfig__WEBPACK_IMPORTED_MODULE_5__.ComputeConfig();
                        changed = true;
                    }
                    if (JSON.stringify(optumi.config.graphics) != JSON.stringify(new _models_GraphicsConfig__WEBPACK_IMPORTED_MODULE_6__.GraphicsConfig())) {
                        optumi.config.graphics = new _models_GraphicsConfig__WEBPACK_IMPORTED_MODULE_6__.GraphicsConfig();
                        changed = true;
                    }
                    if (JSON.stringify(optumi.config.memory) != JSON.stringify(new _models_MemoryConfig__WEBPACK_IMPORTED_MODULE_7__.MemoryConfig())) {
                        optumi.config.memory = new _models_MemoryConfig__WEBPACK_IMPORTED_MODULE_7__.MemoryConfig();
                        changed = true;
                    }
                    if (JSON.stringify(optumi.config.storage) != JSON.stringify(new _models_StorageConfig__WEBPACK_IMPORTED_MODULE_8__.StorageConfig())) {
                        optumi.config.storage = new _models_StorageConfig__WEBPACK_IMPORTED_MODULE_8__.StorageConfig();
                        changed = true;
                    }
                    if (optumi.config.intent != 0.5) {
                        optumi.config.intent = 0.5;
                        changed = true;
                    }
                    // We need one VM size for basic mode
                    if (optumi.config.machineAssortment.length == 0) {
                        optumi.config.machineAssortment = ['Azure:Standard_NC4as_T4_v3'];
                        changed = true;
                    }
                }
                if (changed) {
                    _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.setMetadata(optumi);
                }
            }
            catch (err) {
                console.error(err);
            }
            this.forceUpdate();
            this.handlePreviewClick(false);
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.handleMetadataChange();
            this.polling = true;
            this.poll();
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.connect(() => this.forceUpdate());
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this.polling = false;
            if (this.timeout != null) {
                clearTimeout(this.timeout);
                retrievingPreview = false;
            }
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.disconnect(() => this.forceUpdate());
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            machine: [_Global__WEBPACK_IMPORTED_MODULE_1__.Global.lastMachine]
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/RequirementsBar.js":
/*!**************************************************!*\
  !*** ./lib/components/deploy/RequirementsBar.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Page": () => (/* binding */ Page)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
var Page;
(function (Page) {
    Page[Page["RESOURCES"] = 0] = "RESOURCES";
    Page[Page["FILES"] = 1] = "FILES";
})(Page || (Page = {}));


/***/ }),

/***/ "./lib/components/deploy/ResourceDataConnector.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/ResourceDataConnector.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourceDataConnector": () => (/* binding */ ResourceDataConnector)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class ResourceDataConnector extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.safeSetState({ hovering: true });
                }, onMouseOut: () => {
                    this.safeSetState({ hovering: false });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        position: 'absolute',
                        right: '-10px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.props.handleFileDelete, sx: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Close, { sx: { position: 'relative', width: '16px', height: '16px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex'
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__["default"], { dataService: this.props.dataConnector.dataService }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            textOverflow: 'ellipsis',
                            whiteSpace: 'nowrap',
                            direction: 'rtl',
                            color: this.props.noLongerExists ? _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.ERROR : ''
                        } }, this.props.dataConnector.name + (this.props.noLongerExists ? ' (no longer exists)' : '')))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/ResourceEnvironmentVariable.js":
/*!**************************************************************!*\
  !*** ./lib/components/deploy/ResourceEnvironmentVariable.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourceEnvironmentVariable": () => (/* binding */ ResourceEnvironmentVariable)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Colors */ "./lib/Colors.js");
/* harmony import */ var _mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material/Terminal */ "./node_modules/@mui/icons-material/Terminal.js");
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material/Close */ "./node_modules/@mui/icons-material/Close.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class ResourceEnvironmentVariable extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.safeSetState({ hovering: true });
                }, onMouseOut: () => {
                    this.safeSetState({ hovering: false });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                        position: 'absolute',
                        right: '-10px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: _Global__WEBPACK_IMPORTED_MODULE_2__.Global.easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.props.handleFileDelete, sx: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_3__["default"], { sx: { position: 'relative', width: '16px', height: '16px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex'
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material_Terminal__WEBPACK_IMPORTED_MODULE_4__["default"], { sx: Object.assign({
                            width: '16px',
                            height: '16px',
                            display: 'block',
                            margin: '0px 6px 0px 0px',
                        }) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            textOverflow: 'ellipsis',
                            whiteSpace: 'nowrap',
                            direction: 'rtl',
                            color: this.props.noLongerExists ? _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.ERROR : ''
                        } }, this.props.environmentVariable.name + (this.props.noLongerExists ? ' (no longer exists)' : '')))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/ResourceFile.js":
/*!***********************************************!*\
  !*** ./lib/components/deploy/ResourceFile.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourceFile": () => (/* binding */ ResourceFile)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _fileBrowser_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./fileBrowser/DirListingItemIcon */ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







class ResourceFile extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const progress = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.get(this.props.file.path);
            const compression = progress.filter(x => x.type == 'compression');
            const upload = progress.filter(x => x.type == 'upload');
            // Decide what color to make this
            // Green is if the file exists on the disk and can be synced
            // Yellow is if it doesn't exist on the disk but exists in the cloud so we can still run
            // Red is if it doesn't exist locally or in the cloud so we can't run
            // Always show is set based on color (green/gray false, red/orange true)
            var syncColor;
            var alwaysShowFileSync;
            if (this.state.fileSync) {
                if (!this.props.missingLocally) {
                    syncColor = 'success';
                    alwaysShowFileSync = false;
                }
                else {
                    if (!this.props.missingInCloud) {
                        syncColor = 'warning';
                        alwaysShowFileSync = true;
                    }
                    else {
                        syncColor = 'error';
                        alwaysShowFileSync = true;
                    }
                }
            }
            else {
                syncColor = 'text.disabled';
                alwaysShowFileSync = false;
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex', width: '100%', position: 'relative' }, onMouseOver: () => {
                    this.safeSetState({ hovering: true });
                }, onMouseOut: () => {
                    this.safeSetState({ hovering: false });
                } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        position: 'absolute',
                        left: '-10px',
                        paddingTop: '3px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Checkbox, { disableRipple: true, checked: this.state.fileSync, sx: { padding: '0px' }, icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.CheckBoxOutlineBlank, { sx: { width: '16px', height: '16px' } }), checkedIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.CheckBox, { sx: { width: '16px', height: '16px' } }), onClick: () => {
                            let newFileSync = !this.state.fileSync;
                            this.safeSetState({ fileSync: newFileSync });
                            this.props.handleFileEnabledChange(newFileSync);
                        } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        position: 'absolute',
                        right: '-10px',
                        display: 'inline-flex',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering ? '1' : '0',
                        transition: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.easeAnimation,
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.props.handleFileDelete, sx: {
                            width: '22px',
                            height: '22px',
                            padding: '0px',
                            position: 'relative',
                            display: 'inline-block',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Close, { sx: { position: 'relative', width: '16px', height: '16px' } }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        position: 'absolute',
                        right: '9px',
                        paddingTop: '3px',
                        display: 'inline-flex',
                        transition: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.easeAnimation,
                    } }, !this.props.missingLocally && (compression.length > 0 && compression[0].total >= 0) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__["default"], { reminder: compression.length > 0 ? compression[0].total == -1 ? '' : 'Compressed ' + compression[0].progress + '/' + compression[0].total + ' files' : '' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { height: '16px', width: '16px', background: 'var(--jp-layout-color1)' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { color: 'primary', size: '14px', thickness: 8, sx: { margin: 'auto' } })))) : (!this.props.missingLocally && (upload.length > 0 && upload[0].total >= 0) ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_4__["default"], { reminder: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__["default"].styleCapacityUnitValue()(upload[0].progress) + '/' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_5__["default"].styleCapacityUnitValue()(upload[0].total) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { height: '16px', width: '16px', background: 'var(--jp-layout-color1)' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { variant: 'determinate', size: '14px', thickness: 8, sx: { margin: 'auto' }, value: (upload[0].progress / upload[0].total) * 100 })))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Cached, { sx: {
                        position: 'relative',
                        width: '16px',
                        height: '16px',
                        transform: 'scaleX(-1)',
                        color: this.state.fileSync ? syncColor : 'var(--jp-ui-font-color2)',
                        background: 'var(--jp-layout-color1)',
                        opacity: this.state.hovering || alwaysShowFileSync ? this.state.fileSync ? '0.87' : '0.54' : '0',
                    } })))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        width: '100%',
                        fontSize: '12px',
                        lineHeight: '14px',
                        padding: '3px 6px 3px 6px',
                        display: 'inline-flex',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_fileBrowser_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_6__["default"], { fileType: this.props.file.type, mimetype: this.props.file.mimetype, extension: this.props.file.path.split('.').pop(), sx: { marginRight: '0px', opacity: this.state.fileSync ? '0.87' : '0.54' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            margin: 'auto 0px',
                            overflow: 'hidden',
                            color: this.state.fileSync ? 'var(--jp-ui-font-color1)' : 'var(--jp-ui-font-color2)', // this.props.noLongerExists ? Colors.ERROR : ''
                        }, title: (this.props.file.path.includes('/') ? (`Name: ${this.props.file.path.split('/').pop()}
Path: ${this.props.file.path.replace(/\/[^\/]*$/, '/')}`) : (`Name: ${this.props.file.path.split('/').pop()}`)) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                                direction: 'rtl',
                                overflow: 'hidden',
                                textOverflow: 'ellipsis',
                                whiteSpace: 'nowrap',
                            } }, _Global__WEBPACK_IMPORTED_MODULE_3__.Global.convertOptumiPathToJupyterPath(this.props.file.path))))));
        };
        this.handleFilesChanged = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.getFilesChanged().connect(this.handleFilesChanged);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.fileTracker.getFilesChanged().disconnect(this.handleFilesChanged);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovering: false,
            fileSync: this.props.file.enabled,
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/WasabiConnectorPopup.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/WasabiConnectorPopup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WasabiConnectorPopup": () => (/* binding */ WasabiConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Dropdown.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IntegrationBrowser/IntegrationDirListingItemIcon */ "./lib/components/deploy/IntegrationBrowser/IntegrationDirListingItemIcon.js");
/* harmony import */ var _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/BaseConnectorPopup */ "./lib/core/BaseConnectorPopup.js");
/* harmony import */ var _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/WasabiRegions */ "./lib/models/WasabiRegions.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const defaultState = {
    region: _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__.WasabiRegions.US_EAST_1.region,
    bucketName: '',
    objectKey: '',
    accessKeyID: '',
    secretAccessKey: '',
};
class WasabiConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState(defaultState);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup, { dataService: _IntegrationBrowser_IntegrationDirListingItemIcon__WEBPACK_IMPORTED_MODULE_4__.DataService.WASABI, description: 'Access a Wasabi bucket', header: 'Connect to a Wasabi bucket or object.', downloadPath: '', onClose: this.handleClose, getInfo: () => this.state, getContents: (waiting) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.region, saveValue: (value) => this.safeSetState({ region: value }), label: 'Region', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, values: _models_WasabiRegions__WEBPACK_IMPORTED_MODULE_1__.WasabiRegions.values.map(x => { return { value: x.region, description: x.description }; }), helperText: 'The service region as specified in Wasabi (or S3) documentation.' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.bucketName, saveValue: (value) => this.safeSetState({ bucketName: value }), label: 'Bucket Name', helperText: 'The Bucket Name as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.objectKey, saveValue: (value) => this.safeSetState({ objectKey: value }), label: 'Object Key', helperText: 'If you leave this blank, we will transfer the entire bucket.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.accessKeyID, saveValue: (value) => this.safeSetState({ accessKeyID: value }), label: 'Access Key ID', helperText: 'The Access Key ID as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.TextBox, { getValue: () => this.state.secretAccessKey, saveValue: (value) => this.safeSetState({ secretAccessKey: value }), label: 'Secret Access Key', helperText: 'The Secret Access Key as specified in Wasabi (or S3) documentation.', labelWidth: _core_BaseConnectorPopup__WEBPACK_IMPORTED_MODULE_3__.BaseConnectorPopup.LABEL_WIDTH, disabled: waiting, required: true }))) }));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = defaultState;
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js":
/*!*****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { className: 'jp-BreadCrumbs-item', title: this.props.file.path, onClick: () => this.props.onOpen(this.props.file) }, "..."),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbHome.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbHome.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbHome)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbHome extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { className: 'jp-BreadCrumbs-home jp-BreadCrumbs-item', title: this.props.serverRoot, onClick: () => this.props.onOpen(this.props.file) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: '16', viewBox: '0 0 24 24', style: {
                            height: '16px',
                            bottom: '1px',
                            position: 'relative',
                            margin: '0px 2px 0px 0px',
                            padding: '0px 2px',
                            verticalAlign: 'middle'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { className: 'jp-icon3 jp-icon-selectable', fill: '#616161', d: 'M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z' }))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbItem.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbItem.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class BreadCrumbItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { className: 'jp-BreadCrumbs-item', title: this.props.file.path, onClick: () => this.props.onOpen(this.props.file) }, this.props.file.name),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, null, "/")));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/BreadCrumbs.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/BreadCrumbs.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BreadCrumbs)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _BreadCrumbEllipses__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BreadCrumbEllipses */ "./lib/components/deploy/fileBrowser/BreadCrumbEllipses.js");
/* harmony import */ var _BreadCrumbHome__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BreadCrumbHome */ "./lib/components/deploy/fileBrowser/BreadCrumbHome.js");
/* harmony import */ var _BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BreadCrumbItem */ "./lib/components/deploy/fileBrowser/BreadCrumbItem.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class BreadCrumbs extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'jp-BreadCrumbs jp-FileBrowser-crumbs' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbHome__WEBPACK_IMPORTED_MODULE_2__["default"], { serverRoot: this.props.serverRoot, file: this.props.root, onOpen: this.props.onOpen }),
                this.props.path.length > 2 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbEllipses__WEBPACK_IMPORTED_MODULE_3__["default"], { file: this.props.path[this.props.path.length - 3], onOpen: this.props.onOpen }),
                this.props.path.length > 1 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__["default"], { file: this.props.path[this.props.path.length - 2], onOpen: this.props.onOpen }),
                this.props.path.length > 0 && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbItem__WEBPACK_IMPORTED_MODULE_4__["default"], { file: this.props.path[this.props.path.length - 1], onOpen: this.props.onOpen })));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListing.js":
/*!*********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListing.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListing)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DirListingContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DirListingContent */ "./lib/components/deploy/fileBrowser/DirListingContent.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class DirListing extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const sort = (a, b) => {
                if (a.type !== b.type && (a.type === 'directory' || b.type === 'directory'))
                    return a.type.localeCompare(b.type);
                const sortDirection = (a, b) => a.localeCompare(b) * (this.state.sorted === 'forward' ? 1 : -1);
                if (this.state.selected === 'name') {
                    return sortDirection(a.name, b.name);
                }
                else if (this.state.selected === 'modified') {
                    return sortDirection(b.last_modified, a.last_modified);
                }
            };
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing jp-FileBrowser-listing', sx: { overflow: 'hidden' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-header' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-headerItem jp-id-name' + (this.state.selected === 'name' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'name') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'name', sorted: 'forward' });
                            }
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemText' }, "Name"),
                        this.state.selected === 'name' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemIcon', sx: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) }))))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-DirListing-headerItem jp-id-modified' + (this.state.selected === 'modified' ? ' jp-mod-selected' : ''), onClick: () => {
                            if (this.state.selected === 'modified') {
                                this.safeSetState({ sorted: this.state.sorted === 'forward' ? 'backward' : 'forward' });
                            }
                            else {
                                this.safeSetState({ selected: 'modified', sorted: 'forward' });
                            }
                        }, style: { flex: '0 0 150px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemText' }, "Last Modified"),
                        this.state.selected === 'modified' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-headerItemIcon', sx: { float: 'right' } }, this.state.sorted === 'forward' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretUpIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.caretDownIcon.react, { container: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null) })))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingContent__WEBPACK_IMPORTED_MODULE_3__["default"], { filter: this.props.filter, files: this.props.files, onOpen: this.props.onOpen, sort: sort, getSelected: this.props.getSelected, onDownload: this.props.onDownload, onDelete: this.props.onDelete })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            selected: 'name',
            sorted: 'forward',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingContent.js":
/*!****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingContent.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilterableFile": () => (/* binding */ FilterableFile),
/* harmony export */   "default": () => (/* binding */ DirListingContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DirListingItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DirListingItem */ "./lib/components/deploy/fileBrowser/DirListingItem.js");
/* harmony import */ var _mui_material_Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/Button */ "./node_modules/@mui/material/Button/Button.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class FilterableFile {
    constructor(file) {
        this.file = file;
        this.indices = [];
    }
}
const PAGE_SIZE = 100;
class DirListingContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.filter = (filterableFile) => {
            // Jupyterlab does not filter on directories, but we do
            // if (filterableFile.file.type === 'directory') return true;
            // Run the fuzzy search for the item and query.
            const name = filterableFile.file.name.toLowerCase();
            const query = this.props.filter.toLowerCase();
            let score = fuzzySearch(name, query);
            // Ignore the item if it is not a match.
            if (!score) {
                filterableFile.indices = [];
                return false;
            }
            filterableFile.indices = score.indices;
            return true;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.UL, { className: 'jp-DirListing-content', sx: { overflowY: 'auto' } },
                this.state.visibleFiles.map(filteredFile => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingItem__WEBPACK_IMPORTED_MODULE_3__["default"], { key: filteredFile.file.path + filteredFile.file.name, file: filteredFile, filter: this.props.filter, selected: this.state.selected.includes(filteredFile.file), showReferences: false, showVersionHistory: true, onClick: (event) => {
                        // If we are not interested in selecting, do nothing on a single click
                        if (this.props.getSelected) {
                            if (this.firstClicked === undefined) {
                                if (event.shiftKey) {
                                    this.firstClicked = this.state.filteredSortedFiles[0].file;
                                    this.lastClicked = this.state.filteredSortedFiles[0].file;
                                }
                                else {
                                    this.firstClicked = filteredFile.file;
                                }
                            }
                            if (event.ctrlKey) {
                                const newSelected = [...this.state.selected];
                                if (newSelected.includes(filteredFile.file)) {
                                    newSelected.splice(newSelected.indexOf(filteredFile.file), 1);
                                }
                                else {
                                    newSelected.push(filteredFile.file);
                                }
                                this.safeSetState({ selected: newSelected });
                                this.lastClicked = filteredFile.file;
                            }
                            else if (event.shiftKey) {
                                const newSelected = [...this.state.selected];
                                let index = this.state.filteredSortedFiles.indexOf(filteredFile);
                                const lastClickedIndex = this.state.filteredSortedFiles.map(x => x.file).indexOf(this.lastClicked);
                                const direction = index < lastClickedIndex ? 1 : -1;
                                while (!newSelected.includes(this.state.filteredSortedFiles[index].file) && index !== lastClickedIndex) {
                                    newSelected.push(this.state.filteredSortedFiles[index].file);
                                    index += direction;
                                }
                                if (index === lastClickedIndex && !newSelected.includes(this.lastClicked))
                                    newSelected.push(this.lastClicked);
                                this.safeSetState({ selected: newSelected });
                            }
                            else {
                                this.safeSetState({ selected: [filteredFile.file] });
                                this.firstClicked = filteredFile.file;
                                this.lastClicked = filteredFile.file;
                            }
                        }
                    }, onDoubleClick: (event) => {
                        if (!event.ctrlKey && !event.shiftKey) {
                            this.safeSetState({ selected: [] });
                            this.props.onOpen(filteredFile.file);
                        }
                    }, onDownload: this.props.onDownload, onDelete: this.props.onDelete == undefined ? undefined :
                        (file) => {
                            // Remove the file from the internal state
                            for (let x of this.state.filteredSortedFiles) {
                                // We only want to remove the entry if there are no references left
                                if (x.file.path == file.path && x.file.content && file.content && x.file.content.length == file.content.length) {
                                    const filteredSortedFiles = this.state.filteredSortedFiles.filter(x => x.file.path != file.path);
                                    this.setState({ filteredSortedFiles: filteredSortedFiles, visibleFiles: filteredSortedFiles.slice(0, (this.state.currentPage + 1) * PAGE_SIZE) });
                                }
                            }
                            // Perform the passed in action
                            this.props.onDelete(file);
                        } }))),
                this.state.filteredSortedFiles.length > PAGE_SIZE && (((this.state.currentPage + 1) * PAGE_SIZE) < this.state.filteredSortedFiles.length) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_Button__WEBPACK_IMPORTED_MODULE_4__["default"], { sx: { width: '100%' }, onClick: () => {
                        const newPage = this.state.currentPage + 1;
                        this.setState({ currentPage: newPage, visibleFiles: this.state.filteredSortedFiles.slice(0, (newPage + 1) * PAGE_SIZE) });
                    } }, "Show more"))));
        };
        this.componentDidUpdate = (prevProps, prevState) => {
            if (JSON.stringify(prevProps) !== JSON.stringify(this.props)) {
                const filteredSortedFiles = this.props.files.map(x => new FilterableFile(x)).filter(this.filter).sort((a, b) => this.props.sort(a.file, b.file));
                this.safeSetState({ filteredSortedFiles: filteredSortedFiles, visibleFiles: filteredSortedFiles.slice(0, (this.state.currentPage + 1) * PAGE_SIZE) });
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelected)
            this.props.getSelected(() => this.state.selected);
        const filteredSortedFiles = this.props.files.map(x => new FilterableFile(x)).filter(this.filter).sort((a, b) => this.props.sort(a.file, b.file));
        this.state = {
            selected: [],
            filteredSortedFiles: filteredSortedFiles,
            visibleFiles: filteredSortedFiles.slice(0, PAGE_SIZE),
            currentPage: 0,
        };
    }
}
/**
 * Perform a fuzzy search on a single item.
 */
function fuzzySearch(source, query) {
    // Set up the match score and indices array.
    let score = Infinity;
    let indices = null;
    // The regex for search word boundaries
    const rgx = /\b\w/g;
    let continueSearch = true;
    // Search the source by word boundary.
    while (continueSearch) {
        // Find the next word boundary in the source.
        let rgxMatch = rgx.exec(source);
        // Break if there is no more source context.
        if (!rgxMatch) {
            break;
        }
        // Run the string match on the relevant substring.
        let match = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.StringExt.matchSumOfDeltas(source, query, rgxMatch.index);
        // Break if there is no match.
        if (!match) {
            break;
        }
        // Update the match if the score is better.
        if (match && match.score <= score) {
            score = match.score;
            indices = match.indices;
        }
    }
    // Bail if there was no match.
    if (!indices || score === Infinity) {
        return null;
    }
    // Handle a split match.
    return {
        score,
        indices
    };
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingItem.js":
/*!*************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingItem.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListingItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _DirListingItemIcon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DirListingItemIcon */ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _settings_VersionHistory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../settings/VersionHistory */ "./lib/components/settings/VersionHistory.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/IconButton/IconButton.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/









const fileTitle = (file) => ('Name: ' + file.name + '\n' +
    (file.size === null ? '' : 'Size: ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_4__["default"].styleCapacityUnitValue()(file.size) + (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.isDevVersion ? ' (' + file.size + ' bytes)' : '') + '\n') +
    (file.path === '' ? '' : 'Path: ' + file.path.replace(file.name, '').replace(/\/$/, '') + '\n') +
    'Modified: ' + moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).format('YYYY-MM-DD hh:mm:ss'));
class DirListingItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            var _a;
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const file = this.props.file.file;
            var html = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.StringExt.highlight(file.name, this.props.file.indices, (s) => '<mark style="padding: 0px;">' + s + '</mark>').join('');
            if (this.props.showReferences && file.type != 'directory' && ((_a = file.content) === null || _a === void 0 ? void 0 : _a.length) > 1)
                html += '<SPAN style="margin-left: 6px; opacity: 0.5;">is referenced by ' + file.content.length + ' workloads</SPAN>';
            const hidableIcon = (this.props.onDownload != undefined) || (this.props.onDelete != undefined);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: { position: 'relative' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.LI, { onMouseOver: () => this.setState({ hovered: true }), onMouseOut: () => this.setState({ hovered: false }), className: 'jp-DirListing-item' + (this.props.selected ? ' jp-mod-selected' : ''), onClick: (event) => this.props.onClick(event), onDoubleClick: (event) => this.props.onDoubleClick(event), title: fileTitle(file), style: { padding: hidableIcon ? '8px 12px' : '4px 12px', background: !this.props.selected && this.state.hovered ? 'var(--jp-layout-color2)' : '' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListingItemIcon__WEBPACK_IMPORTED_MODULE_6__["default"], { fileType: file.type, mimetype: file.mimetype, extension: file.path.split('.').pop() }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.SPAN, { className: 'jp-DirListing-itemText', dangerouslySetInnerHTML: { __html: html } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.SPAN, { sx: { opacity: this.state.hovered && hidableIcon ? 0 : 1, }, className: 'jp-DirListing-itemModified', title: moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).format('MMM D, YYYY h:mm A') }, moment__WEBPACK_IMPORTED_MODULE_1___default()(file.last_modified).fromNow())),
                hidableIcon && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: {
                        display: 'inline-flex',
                        position: 'absolute',
                        right: '0px',
                        top: '0px',
                        opacity: this.state.hovered ? 1 : 0,
                        transition: 'opacity 300ms ease-in-out'
                    }, onMouseOver: () => this.setState({ hovered: true }), onMouseOut: () => this.setState({ hovered: false }) },
                    this.props.showVersionHistory && file.type != 'directory' && file.content.length > 1 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_settings_VersionHistory__WEBPACK_IMPORTED_MODULE_7__.VersionHistory, { onClose: () => this.setState({ hovered: false }), metadata: file, onDownload: this.props.onDownload, onDelete: this.props.onDelete })),
                    this.props.onDownload && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_8__["default"], { size: 'large', onClick: () => this.props.onDownload(file), sx: { width: '36px', height: '36px', padding: '4px 3px 2px 3px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.GetApp, { sx: { width: '30px', height: '30px', padding: '3px' } }))),
                    this.props.onDelete && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_8__["default"], { size: 'large', onClick: () => this.props.onDelete(file), sx: { width: '36px', height: '36px', padding: '3px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Delete, { sx: { width: '30px', height: '30px', padding: '3px' } })))))));
        };
        this.state = {
            hovered: false
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/DirListingItemIcon.js":
/*!*****************************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/DirListingItemIcon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DirListingItemIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



const fileTypes = [
    { extension: '.aac', mime: 'audio/aac', icon: undefined },
    { extension: '.abw', mime: 'application/x-abiword', icon: undefined },
    { extension: '.arc', mime: 'application/x-freearc', icon: undefined },
    { extension: '.avi', mime: 'video/x-msvideo', icon: undefined },
    { extension: '.azw', mime: 'application/vnd.amazon.ebook', icon: undefined },
    { extension: '.bin', mime: 'application/octet-stream', icon: undefined },
    { extension: '.bmp', mime: 'image/bmp', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.bz', mime: 'application/x-bzip', icon: undefined },
    { extension: '.bz2', mime: 'application/x-bzip2', icon: undefined },
    { extension: '.csh', mime: 'application/x-csh', icon: undefined },
    { extension: '.css', mime: 'text/css', icon: undefined },
    { extension: '.csv', mime: 'text/csv', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.doc', mime: 'application/msword', icon: undefined },
    { extension: '.docx', mime: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', icon: undefined },
    { extension: '.eot', mime: 'application/vnd.ms-fontobject', icon: undefined },
    { extension: '.gz', mime: 'application/gzip', icon: undefined },
    { extension: '.gif', mime: 'image/gif', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.html', mime: 'text/html', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.html5Icon.react, { display: 'block' }), alternativeExtensions: ['.htm'] },
    { extension: '.ico', mime: 'image/vnd.microsoft.icon', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.ics', mime: 'text/calendar', icon: undefined },
    { extension: '.ipynb', mime: 'text/json', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.notebookIcon.react, { display: 'block' }) },
    { extension: '.jar', mime: 'application/java-archive', icon: undefined },
    { extension: '.jpeg', mime: 'image/jpeg', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.jpg'] },
    { extension: '.js', mime: 'text/javascript', icon: undefined },
    { extension: '.json', mime: 'application/json', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.jsonIcon.react, { display: 'block' }) },
    { extension: '.md', mime: 'text/markdown', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.markdownIcon.react, { display: 'block' }) },
    { extension: '.midi', mime: 'audio/midi', icon: undefined, alternativeExtensions: ['.mid'], alternativeMimes: ['audio/x-midi'] },
    { extension: '.mjs', mime: 'text/javascript', icon: undefined },
    { extension: '.mp3', mime: 'audio/mpeg', icon: undefined },
    { extension: '.mpeg', mime: 'video/mpeg', icon: undefined },
    { extension: '.odp', mime: 'application/vnd.oasis.opendocument.presentation', icon: undefined },
    { extension: '.ods', mime: 'application/vnd.oasis.opendocument.spreadsheet', icon: undefined },
    { extension: '.odt', mime: 'application/vnd.oasis.opendocument.text', icon: undefined },
    { extension: '.oga', mime: 'audio/ogg', icon: undefined },
    { extension: '.ogv', mime: 'video/ogg', icon: undefined },
    { extension: '.ogx', mime: 'application/ogg', icon: undefined },
    { extension: '.opus', mime: 'audio/opus', icon: undefined },
    { extension: '.otf', mime: 'font/otf', icon: undefined },
    { extension: '.png', mime: 'image/png', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.pdf', mime: 'application/pdf', icon: undefined },
    { extension: '.php', mime: 'application/x-httpd-php', icon: undefined },
    { extension: '.ppt', mime: 'application/vnd.ms-powerpoint', icon: undefined },
    { extension: '.pptx', mime: 'application/vnd.openxmlformats-officedocument.presentationml.presentation', icon: undefined },
    { extension: '.py', mime: 'text/x-python', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.pythonIcon.react, { display: 'block' }) },
    { extension: '.rar', mime: 'application/vnd.rar', icon: undefined },
    { extension: '.rtf', mime: 'application/rtf', icon: undefined },
    { extension: '.sh', mime: 'application/x-sh', icon: undefined },
    { extension: '.svg', mime: 'image/svg+xml', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }) },
    { extension: '.swf', mime: 'application/x-shockwave-flash', icon: undefined },
    { extension: '.tar', mime: 'application/x-tar', icon: undefined },
    { extension: '.tiff', mime: 'image/tiff', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.imageIcon.react, { display: 'block' }), alternativeExtensions: ['.tif'] },
    { extension: '.ts', mime: 'video/mp2t', icon: undefined },
    { extension: '.ttf', mime: 'font/ttf', icon: undefined },
    { extension: '.txt', mime: 'text/plain', icon: undefined },
    { extension: '.vsd', mime: 'application/vnd.visio', icon: undefined },
    { extension: '.wav', mime: 'audio/wav', icon: undefined },
    { extension: '.woff', mime: 'font/woff', icon: undefined },
    { extension: '.woff2', mime: 'font/woff2', icon: undefined },
    { extension: '.xhtml', mime: 'application/xhtml+xml', icon: undefined },
    { extension: '.xls', mime: 'application/vnd.ms-excel', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xlsx', mime: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.spreadsheetIcon.react, { display: 'block' }) },
    { extension: '.xml', mime: 'application/xml', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['text/xml'] },
    { extension: '.xul', mime: 'application/vnd.mozilla.xul+xml', icon: undefined },
    { extension: '.yaml', mime: 'application/x-yaml', icon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.yamlIcon.react, { display: 'block' }), alternativeExtensions: ['.yml'], alternativeMimes: ['text/yaml'] },
    { extension: '.zip', mime: 'application/zip', icon: undefined },
    { extension: '.3gp', mime: 'video/3gpp', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['audio/3gpp'] },
    { extension: '.3g2', mime: 'video/3gpp2', icon: undefined, alternativeExtensions: undefined, alternativeMimes: ['audio/3gpp2'] },
    { extension: '.7z', mime: 'application/x-7z-compressed', icon: undefined },
];
class DirListingItemIcon extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.SPAN, { className: 'jp-DirListing-itemIcon', sx: this.props.sx }, this.props.fileType === 'notebook' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.notebookIcon.react, { display: 'block' })) : this.props.fileType === 'directory' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.folderIcon.react, { display: 'block' })) : (() => {
                for (const fileType of fileTypes) {
                    if (fileType.mime === this.props.mimetype)
                        return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                    if (fileType.extension === '.' + this.props.extension)
                        return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                    if (fileType.alternativeMimes !== undefined) {
                        for (const alternativeMime of fileType.alternativeMimes) {
                            if (alternativeMime === this.props.mimetype)
                                return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                        }
                    }
                    if (fileType.alternativeExtensions !== undefined) {
                        for (const alternativeExtension of fileType.alternativeExtensions) {
                            if (alternativeExtension === '.' + this.props.extension)
                                return fileType.icon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
                        }
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.fileIcon.react, { display: 'block' });
            })()));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/FileBrowser.js":
/*!**********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/FileBrowser.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FileBrowser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _BreadCrumbs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BreadCrumbs */ "./lib/components/deploy/fileBrowser/BreadCrumbs.js");
/* harmony import */ var _DirListing__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DirListing */ "./lib/components/deploy/fileBrowser/DirListing.js");
/* harmony import */ var _FilterBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FilterBox */ "./lib/components/deploy/fileBrowser/FilterBox.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class FileBrowser extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getSelectedFiles = () => {
            // We don't want to return the internal contents in case they are changed
            return JSON.parse(JSON.stringify(this.getSelected()));
        };
        this.handleOpen = (file) => {
            if (file.type === 'directory') {
                this.props.request(file.path).then(json => {
                    const newPath = [...this.state.path];
                    const depth = file.path.replace(/[^/]/g, '').length;
                    while (newPath.length > depth)
                        newPath.pop();
                    if (file !== this.state.root)
                        newPath.push(file);
                    this.safeSetState({
                        path: newPath,
                        files: [...json.content],
                    });
                });
            }
            else {
                if (this.props.onAdd)
                    this.props.onAdd();
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'jp-FileBrowser', sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FilterBox__WEBPACK_IMPORTED_MODULE_3__["default"], { onChange: (filter) => this.safeSetState({ filter }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbs__WEBPACK_IMPORTED_MODULE_4__["default"], { serverRoot: this.state.serverRoot, root: this.state.root, path: this.state.path, onOpen: this.handleOpen }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DirListing__WEBPACK_IMPORTED_MODULE_5__["default"], { filter: this.state.filter, files: this.state.files, onOpen: this.handleOpen, getSelected: this.props.getSelectedFiles ? getSelected => this.getSelected = getSelected : undefined, onDownload: this.props.onDownload, onDelete: this.props.onDelete })));
        };
        this.handleUpdate = () => {
            this.props.request(this.state.path.length == 0 ? '' : this.state.path[this.state.path.length - 1].path).then(json => {
                this.safeSetState({ files: json.content });
            });
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.props.request('').then(json => {
                this.safeSetState({ root: json, files: json.content });
            });
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = () => false;
            if (this.props.updateSignal)
                this.props.updateSignal.connect(this.handleUpdate);
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.lab.contextMenu.open = this.oldOpen;
            this._isMounted = false;
            if (this.props.updateSignal)
                this.props.updateSignal.disconnect(this.handleUpdate);
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        if (this.props.getSelectedFiles)
            this.props.getSelectedFiles(this.getSelectedFiles);
        this.state = {
            serverRoot: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getOption('serverRoot'),
            root: undefined,
            path: [],
            files: [],
            filter: '',
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/fileBrowser/FilterBox.js":
/*!********************************************************!*\
  !*** ./lib/components/deploy/fileBrowser/FilterBox.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FilterBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class FilterBox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'jp-FileBrowser-filterBox' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'bp3-input-group jp-InputGroup' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", { type: 'text', placeholder: 'Filter files and directories by name', className: 'bp3-input', style: { paddingRight: '0px' }, onChange: (event) => this.props.onChange(event.currentTarget.value) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { className: 'bp3-input-action' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'jp-InputGroupAction' },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 18 18", width: "16", "data-icon": "ui-components:search" },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", { xmlns: "http://www.w3.org/2000/svg", className: "jp-icon3", fill: "#616161" },
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M12.1,10.9h-0.7l-0.2-0.2c0.8-0.9,1.3-2.2,1.3-3.5c0-3-2.4-5.4-5.4-5.4S1.8,4.2,1.8,7.1s2.4,5.4,5.4,5.4 c1.3,0,2.5-0.5,3.5-1.3l0.2,0.2v0.7l4.1,4.1l1.2-1.2L12.1,10.9z M7.1,10.9c-2.1,0-3.7-1.7-3.7-3.7s1.7-3.7,3.7-3.7s3.7,1.7,3.7,3.7 S9.2,10.9,7.1,10.9z" })))))))));
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/LaunchMode.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/resources/LaunchMode.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LaunchMode": () => (/* binding */ LaunchMode)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../core */ "./lib/core/Header.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../OutlinedResourceRadio */ "./lib/components/deploy/OutlinedResourceRadio.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





// import { EmbeddedYoutube } from '../../../core/EmbeddedYoutube';




class LaunchMode extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const value = this.getValue();
            const optumi = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadata().config;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordion, { variant: 'outlined', expanded: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded, sx: { background: 'var(--jp-layout-color1)' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionSummary, { sx: { cursor: 'default' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'flex' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_4__.SubHeader, { title: 'Launch mode' }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_5__.InfoPopup, { title: 'Launch mode', popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: '12px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `The selected launch mode determines how your notebook will be run in the cloud.`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line', fontWeight: 'bold', marginBottom: '0' } }, `Session`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `If selected, Optumi will start a JupyterLab server in the cloud that you will connect to with your browser. A new browser tab will open automatically when the session is ready for use. You will be able to work interactively the same way you do on your local laptop, however notebook execution will take place on the remote server.

                                            This is often useful when developing or debugging your notebook.`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line', fontWeight: 'bold', marginBottom: '0' } }, `Job`),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.P, { sx: { whiteSpace: 'pre-line' } }, `If selected, Optumi will take a snapshot of your current notebook and execute it in the cloud from start to finish. You will be able to see the notebook output as your job progresses, however you won't be able to re-run individual cells within the notebook.

                                            This is often useful when training or tuning hyperparameters. You can think of it as a fire-and-forget mode where you are free to close your browser without disrupting notebook execution.`)) })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.SPAN, { sx: {
                                margin: 'auto 8px',
                                flexGrow: 1,
                                textAlign: 'end',
                                opacity: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded ? 0 : 0.5,
                                transitionDuration: '217ms',
                                whiteSpace: 'nowrap',
                                fontSize: '12px',
                                fontStyle: 'italic',
                            } }, optumi.interactive ? 'session' : 'job'),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded;
                                if (this._isMounted)
                                    this.forceUpdate();
                            }, sx: { padding: '0px', marginRight: '-3px', width: '30px', transform: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded ? 'rotate(180deg)' : undefined } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.ExpandMore, null))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledAccordionDetails, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                                alignItems: 'center',
                                display: 'inline-flex',
                                width: '100%',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__["default"], { reminder: 'Run an interactive session' },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_7__.OutlinedResourceRadio, { label: 'Session', color: _Colors__WEBPACK_IMPORTED_MODULE_8__.Colors.SECONDARY, selected: value == "Session", handleClick: () => this.saveValue("Session") })),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_6__["default"], { reminder: 'Run a batch job' },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutlinedResourceRadio__WEBPACK_IMPORTED_MODULE_7__.OutlinedResourceRadio, { label: "Job", color: _Colors__WEBPACK_IMPORTED_MODULE_8__.Colors.SECONDARY, selected: value == "Job", handleClick: () => this.saveValue("Job") })))))));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.LaunchAccordion, () => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.launchModeAccordionExpanded = true;
                if (this._isMounted)
                    this.forceUpdate();
            });
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.LaunchAccordion.SessionMode, () => this.saveValue('Session'));
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.setLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.LaunchAccordion.JobMode, () => this.saveValue('Job'));
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.deleteLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.LaunchAccordion);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.deleteLinksUnder(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.DeployTab.LaunchAccordion);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata;
        const optumi = tracker.getMetadata();
        return optumi.config.interactive ? "Session" : "Job";
    }
    saveValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.interactive = value == "Session" ? true : false;
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/ResourcesPanel.js":
/*!***********************************************************!*\
  !*** ./lib/components/deploy/resources/ResourcesPanel.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourcesPanel": () => (/* binding */ ResourcesPanel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _Simplified__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Simplified */ "./lib/components/deploy/resources/Simplified.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class ResourcesPanel extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Simplified__WEBPACK_IMPORTED_MODULE_2__.Simplified, null)));
        };
        this.handleMetadataChange = () => { this.forceUpdate(); };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            // This will cause the display to change when we change to a new notebook with a different level specified
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/components/deploy/resources/Simplified.js":
/*!*******************************************************!*\
  !*** ./lib/components/deploy/resources/Simplified.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Simplified": () => (/* binding */ Simplified)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../Global */ "./lib/Global.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _ChipPopper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../ChipPopper */ "./lib/components/ChipPopper.js");
/* harmony import */ var _ChipSlider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../ChipSlider */ "./lib/components/ChipSlider.js");
/* harmony import */ var _GPUChipPopper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../GPUChipPopper */ "./lib/components/deploy/GPUChipPopper.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



// import ExtraInfo from '../../../utils/ExtraInfo';





class Simplified extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.getDescription = (getValue, min, max, styleValue, styleUnit) => {
            const value = [...getValue()];
            if (value[0] == -1)
                value[0] = min;
            if (value[1] == -1)
                value[1] = max;
            if (value[0] === min && value[1] === max) {
                return `Any`;
            }
            else if (value[0] !== min && value[1] !== max) {
                const maxUnit = styleUnit(value[1]);
                const minValue = styleValue(value[0], maxUnit);
                const maxValue = styleValue(value[1]);
                if (minValue == maxValue)
                    return `${minValue} ${styleUnit(value[1])}`;
                return `${minValue}-${maxValue} ${styleUnit(value[1])}`;
            }
            else if (value[0] !== min) {
                return `Min ${styleValue(value[0])} ${styleUnit(value[0])}`;
            }
            else if (value[1] !== max) {
                return `Max ${styleValue(value[1])} ${styleUnit(value[1])}`;
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        alignItems: 'center',
                        // display: 'inline-flex',
                        width: '100%',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GPUChipPopper__WEBPACK_IMPORTED_MODULE_2__.GPUChipPopper, null),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipPopper__WEBPACK_IMPORTED_MODULE_3__.ChipPopper, { sx: { width: 'calc(50% - 12px)', margin: '0px 6px 6px' }, title: 'CPU', color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.CPU, clearValue: () => this.saveCPUValue([-1, -1]), getHeaderDescription: () => this.getDescription(this.getCPUValue, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.computeCoresMin, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.computeCoresMax, (value) => value.toString(), (value) => value == 1 ? 'core' : 'cores'), popperContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.snapToInventoryEnabled ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'cpu-snap', getValue: this.getCPUValue, saveValue: this.saveCPUValue, label: 'Cores', marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.computeCores.map(x => { return { value: x }; }), step: null, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.CPU, styleUnit: (value) => '', styleValue: (value) => value.toString() })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'cpu-no-snap', getValue: this.getCPUValue, saveValue: this.saveCPUValue, label: 'Cores', min: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.computeCoresMin, max: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.computeCoresMax, step: 1, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.CPU, styleUnit: (value) => '', styleValue: (value) => value.toString() }))) })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipPopper__WEBPACK_IMPORTED_MODULE_3__.ChipPopper, { sx: { width: 'calc(50% - 12px)', margin: '0px 6px 6px' }, title: 'RAM', color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.RAM, clearValue: () => this.saveRAMValue([-1, -1]), getHeaderDescription: () => this.getDescription(this.getRAMValue, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.memorySizeMin, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.memorySizeMax, _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue(), _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit()), popperContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.snapToInventoryEnabled ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'ram-snap', getValue: this.getRAMValue, saveValue: this.saveRAMValue, label: 'Size', marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.memorySize.map(x => { return { value: x }; }), step: null, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.RAM, styleUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit(), styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue() })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'ram-no-snap', getValue: this.getRAMValue, saveValue: this.saveRAMValue, label: 'Size', min: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.memorySizeMin, max: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.memorySizeMax, step: 1024 * 1024 * 1024, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.RAM, styleUnit: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit(), styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue() }))) }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipPopper__WEBPACK_IMPORTED_MODULE_3__.ChipPopper, { sx: { width: 'calc(50% - 12px)', margin: '0px 6px 6px' }, title: 'DISK', color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.DISK, clearValue: () => this.saveDiskValue([-1, -1]), getHeaderDescription: () => this.getDescription(this.getDiskValue, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.storageSizeMin, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.storageSizeMax, _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue(), _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit()), popperContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.snapToInventoryEnabled ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'disk-snap', getValue: this.getDiskValue, saveValue: this.saveDiskValue, label: 'Size', marks: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.storageSize.map(x => { return { value: x }; }), step: null, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.DISK, styleUnit: (value) => {
                                    // We don't want to show MB for disk, since the only disk size number below GB is 0. In other words... show '0 GB' instead of '0 MB'
                                    const unit = _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit()(value);
                                    return unit == 'MB' ? 'GB' : unit;
                                }, styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue() })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChipSlider__WEBPACK_IMPORTED_MODULE_5__.ChipSlider, { key: 'disk-no-snap', getValue: this.getDiskValue, saveValue: this.saveDiskValue, label: 'Size', min: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.storageSizeMin, max: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.machines.storageSizeMax, step: 1024 * 1024 * 1024, color: _Colors__WEBPACK_IMPORTED_MODULE_4__.Colors.DISK, styleUnit: (value) => {
                                    // We don't want to show MB for disk, since the only disk size number below GB is 0. In other words... show '0 GB' instead of '0 MB'
                                    const unit = _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnit()(value);
                                    return unit == 'MB' ? 'GB' : unit;
                                }, styleValue: _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleShortCapacityValue() }))) })))));
        };
        this.handleMetadataChange = () => this.forceUpdate();
        this.handleUserChange = () => this.forceUpdate();
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user != null)
                _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.connect(this.handleUserChange);
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
            const optumi = tracker.getMetadata();
            // Set all resource levels to component
            optumi.config.compute.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.COMPONENT;
            optumi.config.memory.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.COMPONENT;
            optumi.config.storage.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.COMPONENT;
            tracker.setMetadata(optumi);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user != null)
                _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
    getCPUValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const cores = optumi.config.compute.cores;
        return [cores[0], cores[2]];
    }
    saveCPUValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.compute.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        optumi.config.compute.cores = [value[0], -1, value[1]];
        tracker.setMetadata(optumi);
    }
    getRAMValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const size = optumi.config.memory.size;
        return [size[0], size[2]];
    }
    saveRAMValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.memory.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        optumi.config.memory.size = [value[0], -1, value[1]];
        tracker.setMetadata(optumi);
    }
    getDiskValue() {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        const size = optumi.config.storage.size;
        return [size[0], size[2]];
    }
    saveDiskValue(value) {
        const tracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata;
        const optumi = tracker.getMetadata();
        optumi.config.storage.expertise = _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.Expertise.SIMPLIFIED;
        optumi.config.storage.size = [value[0], -1, value[1]];
        tracker.setMetadata(optumi);
    }
}


/***/ }),

/***/ "./lib/components/monitor/ScrollableDiv.js":
/*!*************************************************!*\
  !*** ./lib/components/monitor/ScrollableDiv.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ScrollableDiv": () => (/* binding */ ScrollableDiv)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/NotebookUtils */ "./lib/utils/NotebookUtils.js");
/* harmony import */ var _core_AnsiLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/AnsiLink */ "./lib/core/AnsiLink.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class ScrollableDiv extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.getFormattedContents = () => {
            var source = this.props.source;
            if (source.length == 0) {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.SPAN, { sx: { display: 'inline-block', color: 'var(--jp-ui-font-color1)' } }, "No output to display"));
            }
            else {
                const lines = [];
                for (let outputLine of source) {
                    lines.push(outputLine.line);
                }
                var ansiText = _utils_NotebookUtils__WEBPACK_IMPORTED_MODULE_2__["default"].fixOverwrittenChars(lines);
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_AnsiLink__WEBPACK_IMPORTED_MODULE_3__.AnsiLink, { sx: { display: 'inline-block', color: 'var(--jp-ui-font-color1)' }, key: lines[0], text: ansiText }));
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null));
            // return content;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '20px', overflow: 'auto', whiteSpace: 'pre' }, innerRef: this.element }, this.getFormattedContents()));
        };
        this.getSnapshotBeforeUpdate = (prevProps, prevState) => {
            if (this.props.autoScroll && this.element.current != null) {
                return {
                    "scrollTop": this.element.current.scrollTop,
                    "scrollHeight": this.element.current.scrollHeight,
                    "clientHeight": this.element.current.clientHeight
                };
            }
            return null;
        };
        this.componentDidUpdate = (prevProps, prevState, snapshot) => {
            if (this.props.autoScroll && snapshot != null) {
                // if (this.element.current != null) {
                var element = this.element.current;
                if (snapshot.scrollTop >= snapshot.scrollHeight - snapshot.clientHeight) {
                    element.scrollTo({
                        top: element.scrollHeight - element.clientHeight,
                        behavior: 'smooth'
                    });
                }
                // }
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            if (this.props.autoScroll) {
                var element = this.element.current;
                element.scrollTo({
                    top: element.scrollHeight - element.clientHeight,
                    behavior: 'auto'
                });
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.element = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
    }
}


/***/ }),

/***/ "./lib/components/settings/FreeTrial.js":
/*!**********************************************!*\
  !*** ./lib/components/settings/FreeTrial.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeTrial": () => (/* binding */ FreeTrial)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/Label.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _core_PlansPopup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/PlansPopup */ "./lib/core/PlansPopup.js");
/* harmony import */ var _core_SubscribeButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Tag */ "./lib/components/Tag.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "webpack/sharing/consume/default/moment/moment");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/









class FreeTrial extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const expiration = new Date(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.trialStart);
            expiration.setDate(expiration.getDate() + 14);
            var until;
            if (moment__WEBPACK_IMPORTED_MODULE_1___default()(new Date()).format('MM-DD') == moment__WEBPACK_IMPORTED_MODULE_1___default()(expiration).format('MM-DD')) {
                until = moment__WEBPACK_IMPORTED_MODULE_1___default()(expiration).format('hh:mm');
            }
            else {
                until = moment__WEBPACK_IMPORTED_MODULE_1___default()(expiration).format('MM/DD');
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { display: 'flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_3__.Header, { title: 'Current plan' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PlansPopup__WEBPACK_IMPORTED_MODULE_4__.PlansPopup, { open: this.state.plansOpen, handleClose: () => this.safeSetState({ plansOpen: false }), openButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tag__WEBPACK_IMPORTED_MODULE_5__.Tag, { label: 'View plans', onClick: () => this.safeSetState({ plansOpen: true }) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { display: 'flex', width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Label, { label: 'Free trial until ' + until, getValue: () => _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].formatCredit(this.props.balance) + ' credit', align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_8__.InfoPopup, { title: 'Free Trial', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { padding: '12px' } },
                                "A few things to remember about your free trial:",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.UL, null,
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "No credit card required"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "It is valid for 2 weeks"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "You get a $5 promotional credit for machines to run notebooks"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "At the end of the trial your promotional credit will expire and your data will be deleted (unless you subscribe!)"))) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Label, { label: 'Storage', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.storageBuckets[0].limit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_8__.InfoPopup, { title: 'Storage', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { padding: '12px' } }, "Storage refers to data you store persistently in the Optumi platform, such as uploaded files used as input for notebooks. It does not include temporary disk space on machines provisioned to run your notebooks.") }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Label, { label: 'Egress', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.user.egressBuckets[0].limit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_8__.InfoPopup, { title: 'Egress', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { padding: '12px' } },
                            "Egress refers to data (files, images, logs) transferred out of the Optumi platform. Examples include:",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.UL, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "Using your notebook to send files to Amazon RedShift or Google BigQuery"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.LI, null, "Downloading a file from the Optumi platform to your laptop"))) }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { display: 'flex', width: '100%', padding: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribeButton__WEBPACK_IMPORTED_MODULE_9__.SubscribeButton, { sx: { width: '50%', marginX: 'auto' } }))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            portalWaiting: false,
            showStoragePopup: false,
            plansOpen: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/settings/FreeTrialEnded.js":
/*!***************************************************!*\
  !*** ./lib/components/settings/FreeTrialEnded.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeTrialEnded": () => (/* binding */ FreeTrialEnded)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Label.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _core_PlansPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/PlansPopup */ "./lib/core/PlansPopup.js");
/* harmony import */ var _core_SubscribeButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tag */ "./lib/components/Tag.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class FreeTrialEnded extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { title: 'Current plan' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PlansPopup__WEBPACK_IMPORTED_MODULE_3__.PlansPopup, { open: this.state.plansOpen, handleClose: () => this.safeSetState({ plansOpen: false }), openButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tag__WEBPACK_IMPORTED_MODULE_4__.Tag, { label: 'View plans', onClick: () => this.safeSetState({ plansOpen: true }) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex', width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Free trial', getValue: () => { var _a; return _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.trialEnd ? 'Ended on ' + ((_a = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.trialEnd) === null || _a === void 0 ? void 0 : _a.toLocaleDateString()) : 'Ended'; }, align: 'left', valueAlign: 'right', lineHeight: '20px', infoRight: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Your free trial has ended', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "You can no longer launch workloads but you can still view workload details and download files (subject to remaining egress limits)."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "Your data will be retained for 14 days after the trial end date.")) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Storage', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker.limit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Storage', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "Storage refers to data you store persistently in the Optumi platform, such as uploaded files used as input for notebooks. It does not include temporary disk space on machines provisioned to run your notebooks.") }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Egress', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.egressLimit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Egress', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } },
                            "Egress refers to data (files, images, logs) transferred out of the Optumi platform. Examples include:",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.UL, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.LI, null, "Using your notebook to send files to Amazon RedShift or Google BigQuery"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.LI, null, "Downloading a file from the Optumi platform to your laptop"))) }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex', width: '100%', padding: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribeButton__WEBPACK_IMPORTED_MODULE_8__.SubscribeButton, { sx: { width: '50%', marginX: 'auto' } }))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            portalWaiting: false,
            showStoragePopup: false,
            plansOpen: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/settings/SettingsMenu.js":
/*!*************************************************!*\
  !*** ./lib/components/settings/SettingsMenu.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccountBillingSubMenu": () => (/* binding */ AccountBillingSubMenu),
/* harmony export */   "AccountIntegrationsSubMenu": () => (/* binding */ AccountIntegrationsSubMenu),
/* harmony export */   "AccountLimitsSubMenu": () => (/* binding */ AccountLimitsSubMenu),
/* harmony export */   "AccountPreferencesSubMenu": () => (/* binding */ AccountPreferencesSubMenu),
/* harmony export */   "AccountStorageSubMenu": () => (/* binding */ AccountStorageSubMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core */ "./lib/core/Switch.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core */ "./lib/core/TextBox.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../deploy/IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _deploy_AmazonS3ConnectorPopup__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../deploy/AmazonS3ConnectorPopup */ "./lib/components/deploy/AmazonS3ConnectorPopup.js");
/* harmony import */ var _deploy_GoogleCloudStorageConnectorPopup__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../deploy/GoogleCloudStorageConnectorPopup */ "./lib/components/deploy/GoogleCloudStorageConnectorPopup.js");
/* harmony import */ var _deploy_GoogleDriveConnectorPopup__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../deploy/GoogleDriveConnectorPopup */ "./lib/components/deploy/GoogleDriveConnectorPopup.js");
/* harmony import */ var _deploy_KaggleConnectorPopup__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../deploy/KaggleConnectorPopup */ "./lib/components/deploy/KaggleConnectorPopup.js");
/* harmony import */ var _deploy_WasabiConnectorPopup__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../deploy/WasabiConnectorPopup */ "./lib/components/deploy/WasabiConnectorPopup.js");
/* harmony import */ var _deploy_AzureBlobStorageConnector__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../deploy/AzureBlobStorageConnector */ "./lib/components/deploy/AzureBlobStorageConnector.js");
/* harmony import */ var _deploy_fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../deploy/fileBrowser/FileBrowser */ "./lib/components/deploy/fileBrowser/FileBrowser.js");
/* harmony import */ var _SubscriptionActive__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./SubscriptionActive */ "./lib/components/settings/SubscriptionActive.js");
/* harmony import */ var _FreeTrial__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./FreeTrial */ "./lib/components/settings/FreeTrial.js");
/* harmony import */ var _core_PhoneTextBox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/PhoneTextBox */ "./lib/core/PhoneTextBox.js");
/* harmony import */ var _SubscriptionEnded__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./SubscriptionEnded */ "./lib/components/settings/SubscriptionEnded.js");
/* harmony import */ var _core_CustomerState__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/CustomerState */ "./lib/core/CustomerState.js");
/* harmony import */ var _FreeTrialEnded__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./FreeTrialEnded */ "./lib/components/settings/FreeTrialEnded.js");
/* harmony import */ var _core_EnvironmentVariablePopup__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../core/EnvironmentVariablePopup */ "./lib/core/EnvironmentVariablePopup.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/













// import { PhoneTextBox } from '../../core/PhoneTextBox';










const emUpSub = 'Upgrade subscription to unlock';
const LABEL_WIDTH = '80px';
class AccountPreferencesSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ padding: '6px' }, this.props.sx) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PhoneTextBox__WEBPACK_IMPORTED_MODULE_5__.PhoneTextBox, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.phoneNumber ? _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.phoneNumber : '', saveValue: (phoneNumber) => {
                            if (phoneNumber == '')
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.notificationsEnabled = false;
                            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.phoneNumber = phoneNumber;
                            // We need to update so the switch below will be updated properly
                            this.setState({ switchKey: this.state.switchKey + 1 });
                        }, validOnBlur: this.props.phoneValidOnBlur, label: 'Phone', labelWidth: LABEL_WIDTH }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Switch, { key: this.state.switchKey, getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.notificationsEnabled, saveValue: (notificationsEnabled) => { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.notificationsEnabled = notificationsEnabled; }, label: 'Enable SMS notifications to ' + _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.phoneNumber, disabled: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.phoneNumber == '', labelBefore: true, flip: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Switch, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.compressFilesEnabled, saveValue: (compressFilesEnabled) => { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.compressFilesEnabled = compressFilesEnabled; }, label: 'Compress my files before uploading', labelBefore: true, flip: true }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_6__.Switch, { getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.snapToInventoryEnabled, saveValue: (snapToInventoryEnabled) => { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.snapToInventoryEnabled = snapToInventoryEnabled; }, label: 'Snap resource selection sliders to existing inventory', labelBefore: true, flip: true }),
                    _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.showDownloadAllButtonEnabled && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", color: "primary", startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.GetApp, null), sx: { width: '100%' }, onClick: async () => {
                            const data = [];
                            for (let app of _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.appTracker.finishedJobsOrSessions) {
                                const machine = app.machine;
                                data.push([
                                    this.stringToCSVCell(app.name),
                                    this.stringToCSVCell(app.annotationOrRunNum),
                                    app.timestamp,
                                    app.getTimeElapsed(),
                                    app.interactive || app.programType != _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_7__.ProgramType.PYTHON_NOTEBOOK ? 'N/A' : app.program.metadata.papermill.duration,
                                    app.getCost(),
                                    app.getAppMessage(),
                                    machine.name,
                                    machine.computeCores,
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__["default"].styleCapacityUnitValue()(machine.memorySize),
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__["default"].styleCapacityUnitValue()(machine.storageSize),
                                    machine.graphicsNumCards > 0 ? (machine.graphicsNumCards + ' ' + machine.graphicsCardType) : 'None',
                                    app.uuid,
                                ]);
                                var link = document.createElement("a");
                                var blob = new Blob([JSON.stringify(app.machine)], {
                                    type: "text/plain;charset=utf-8"
                                });
                                link.setAttribute("href", window.URL.createObjectURL(blob));
                                link.setAttribute("download", app.uuid + ".txt");
                                document.body.appendChild(link); // Required for FF
                                link.click();
                                await new Promise(resolve => setTimeout(resolve, 100));
                                var link = document.createElement("a");
                                var blob = new Blob([JSON.stringify(app.program)], {
                                    type: "text/plain;charset=utf-8"
                                });
                                link.setAttribute("href", window.URL.createObjectURL(blob));
                                link.setAttribute("download", app.uuid + app.name.split('.').pop());
                                document.body.appendChild(link); // Required for FF
                                link.click();
                                await new Promise(resolve => setTimeout(resolve, 100));
                            }
                            const headers = [
                                ["Name", "Annotation", "Start Time", "Duration (total)", "Duration (notebook)", "Cost", "Status", "Machine", "Cores", "RAM", "Disk", "GPUs", "UUID"]
                            ];
                            var link = document.createElement("a");
                            var blob = new Blob([headers.map(e => e.join(",")).join("\n") + '\n' + data.map(e => e.join(",")).join("\n") + '\n'], {
                                type: "data:text/csv;charset=utf-8,"
                            });
                            link.setAttribute("href", window.URL.createObjectURL(blob));
                            link.setAttribute("download", "run_history.csv");
                            document.body.appendChild(link); // Required for FF
                            link.click();
                        } }, "Download all runs")))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            // We need to increment this when the user changes his number so the switch will be enabled/disabled properly
            switchKey: 0
        };
    }
    stringToCSVCell(str) {
        var s = "\"";
        for (let nextChar of str) {
            s += nextChar;
            if (nextChar == '"')
                s += "\"";
        }
        s += "\"";
        return s;
    }
}
class AccountLimitsSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ padding: '6px' }, this.props.sx) },
                    _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userExpertise > 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_9__.TextBox, { getValue: this.getUserBudgetValue, saveValue: this.saveUserBudgetValue, styledUnitValue: (value) => '$' + value.toFixed(2), unstyleUnitValue: (value) => { return value.replace('$', '').replace('.', '').replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value.replace('$', '')); }, label: 'Budget', labelWidth: LABEL_WIDTH, onFocus: () => this.safeSetState({ budgetFocused: true }), onBlur: () => this.safeSetState({ budgetFocused: false }), helperText: this.state.budgetFocused ? `Must be between $1 and $${_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxBudget}` : 'Max monthly spend', minValue: 1, maxValue: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxBudget })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_9__.TextBox, { getValue: this.getMaxJobsValue, saveValue: this.saveMaxJobsValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Jobs/Sessions', labelWidth: LABEL_WIDTH, helperText: 'Max combined number of concurrent jobs and sessions', disabledMessage: emUpSub }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_9__.TextBox, { getValue: this.getMaxMachinesValue, saveValue: this.saveMaxMachinesValue, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Machines', labelWidth: LABEL_WIDTH, helperText: 'Max number of concurrent machines', disabledMessage: emUpSub }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_9__.TextBox, { getValue: this.getUserHoldoverTimeValue, saveValue: this.saveUserHoldoverTimeValue, styledUnitValue: (value) => { return isNaN(value) ? "" : value.toFixed(); }, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, label: 'Auto-release', labelWidth: LABEL_WIDTH, onFocus: () => this.safeSetState({ holdoverFocused: true }), onBlur: () => this.safeSetState({ holdoverFocused: false }), helperText: this.state.holdoverFocused ? `Must be between 0 and ${_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxHoldoverTime / 60} minutes` : 'Time in minutes before releasing idle machines', minValue: 0, maxValue: +(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxHoldoverTime / 60).toFixed() })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            holdoverFocused: false,
            budgetFocused: false,
            recsFocused: false,
        };
    }
    getUserBudgetValue() { return _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userBudget; }
    saveUserBudgetValue(userBudget) { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userBudget = userBudget; }
    getMaxJobsValue() { return _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxJobs; }
    saveMaxJobsValue(value) { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxJobs = value; }
    getMaxMachinesValue() { return _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxMachines; }
    saveMaxMachinesValue(value) { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxMachines = value; }
    getUserHoldoverTimeValue() { return Math.round(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userHoldoverTime / 60); }
    saveUserHoldoverTimeValue(userHoldoverTime) { _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userHoldoverTime = userHoldoverTime * 60; }
}
class AccountBillingSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.polling = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ padding: '6px' }, this.props.sx) }, _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.isSubscribed() ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SubscriptionActive__WEBPACK_IMPORTED_MODULE_10__.SubscriptionActive, { machineCost: this.props.machineCost, serviceFeeCost: this.props.serviceFeeCost, storageCost: this.props.storageCost, egressCost: this.props.egressCost })) : _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.customerState == _core_CustomerState__WEBPACK_IMPORTED_MODULE_11__.CustomerState.FREE_TRIAL ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FreeTrial__WEBPACK_IMPORTED_MODULE_12__.FreeTrial, { balance: this.props.balance })) : _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.customerState == _core_CustomerState__WEBPACK_IMPORTED_MODULE_11__.CustomerState.FREE_TRIAL_ENDED ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FreeTrialEnded__WEBPACK_IMPORTED_MODULE_13__.FreeTrialEnded, { balance: this.props.balance })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SubscriptionEnded__WEBPACK_IMPORTED_MODULE_14__.SubscriptionEnded, { balance: this.props.balance })))));
        };
        this.handleUserChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            this.polling = true;
            this.receiveUpdate();
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userInformationChanged.connect(this.handleUserChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
            this.polling = false;
            if (this.timeout != null)
                clearTimeout(this.timeout);
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            balance: 0,
        };
    }
    async receiveUpdate() {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/get-balance";
        const now = new Date();
        const epoch = new Date(0);
        const init = {
            method: 'POST',
            body: JSON.stringify({
                startTime: epoch.toISOString(),
                endTime: now.toISOString(),
            }),
        };
        _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (this.polling) {
                // If we are polling, send a new request in 2 seconds
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnPoll)
                    console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                this.timeout = setTimeout(() => this.receiveUpdate(), 2000);
            }
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
            return response.json();
        }).then((body) => {
            if (body) {
                this.safeSetState({ balance: body.balance });
            }
        });
    }
}
class AccountIntegrationsSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Use a key to force the data connector browser to refresh
        this.forceNewBrowser = () => {
            this.safeSetState({ browserKey: this.state.browserKey + 1 });
        };
        this.request = async () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/get-integrations';
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                if (response.status !== 200)
                    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.ResponseError(response);
                return response.json();
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({}, this.props.sx) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_15__.Header, { title: 'Existing integrations', sx: { lineHeight: '24px', margin: '6px 6px 6px 11px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_16__["default"], { key: this.state.browserKey, sx: {
                            maxHeight: 'calc(100% - 60px - 2px)',
                        }, type: _deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_16__.IntegrationType.ALL, handleDelete: (dataConnectorMetadata) => {
                            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeSettings();
                            const url = settings.baseUrl + "optumi/remove-integration";
                            const init = {
                                method: 'POST',
                                body: JSON.stringify({
                                    name: dataConnectorMetadata.name,
                                }),
                            };
                            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_3__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                            }).then(() => {
                                var newDataConnectors = [...this.state.dataConnectors];
                                newDataConnectors = newDataConnectors.filter(dataConnector => dataConnector.name !== dataConnectorMetadata.name);
                                this.safeSetState({ dataConnectors: newDataConnectors });
                                this.forceNewBrowser();
                            }).then(() => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.dataConnectorChange.emit());
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { sx: { marginTop: '33px' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', margin: '6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_15__.Header, { title: 'New integrations', sx: { lineHeight: '24px', margin: '6px 6px 6px 11px' } })),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { marginBottom: '6px' } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_AmazonS3ConnectorPopup__WEBPACK_IMPORTED_MODULE_17__.AmazonS3ConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_AzureBlobStorageConnector__WEBPACK_IMPORTED_MODULE_18__.AzureBlobStorageConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_GoogleCloudStorageConnectorPopup__WEBPACK_IMPORTED_MODULE_19__.GoogleCloudStorageConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_GoogleDriveConnectorPopup__WEBPACK_IMPORTED_MODULE_20__.GoogleDriveConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_KaggleConnectorPopup__WEBPACK_IMPORTED_MODULE_21__.KaggleConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_WasabiConnectorPopup__WEBPACK_IMPORTED_MODULE_22__.WasabiConnectorPopup, { onClose: this.forceNewBrowser }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_EnvironmentVariablePopup__WEBPACK_IMPORTED_MODULE_23__.EnvironmentVariablePopup, { onClose: this.forceNewBrowser }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            this.request().then(json => this.safeSetState({ integrations: json.integrations }));
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            dataConnectors: [],
            browserKey: 0,
        };
    }
}
class AccountStorageSubMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ display: 'flex', flexDirection: 'column', overflowY: 'visible' }, this.props.sx) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '20px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { lineHeight: '36px' } },
                            "Used storage: ",
                            _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__["default"].styleStorageOrEgress(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.total, _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.limit),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { sx: { width: '36px', height: '36px', padding: '3px' }, size: 'large', onClick: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.receiveUpdate(false) },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Refresh, { sx: { width: '30px', height: '30px', padding: '3px' } })))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_fileBrowser_FileBrowser__WEBPACK_IMPORTED_MODULE_24__["default"], { sx: { maxHeight: 'calc(100% - 77px)', flexGrow: 1 }, request: (path) => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.getContentsForFileBrowser(path), updateSignal: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.getFilesChanged(), onDownload: (file) => {
                            if (file.type == 'directory') {
                                const fixedPath = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.convertJupyterPathToOptumiPath(file.path);
                                this.downloadFiles(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.expandDirectory(fixedPath, false), fixedPath);
                            }
                            else {
                                this.downloadFiles([file]);
                            }
                        }, onDelete: (file) => {
                            if (file.type == 'directory') {
                                const fixedPath = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.convertJupyterPathToOptumiPath(file.path);
                                this.deleteFiles(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.expandDirectory(fixedPath), fixedPath);
                            }
                            else {
                                this.deleteFiles(file.content);
                            }
                        } })));
        };
        this.handleUserChange = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.getFilesChanged().connect(this.handleFilesChange);
        };
        this.handleFilesChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user != null) {
                this.handleUserChange();
            }
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.connect(this.handleUserChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user != null)
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.getFilesChanged().disconnect(this.handleFilesChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.disconnect(this.handleUserChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            files: [],
            appsToFiles: new Map(),
            filesToApps: new Map(),
        };
    }
    async deleteFiles(files, directory = "") {
        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.deleteFiles(files, directory);
    }
    async downloadFiles(files, directory = "") {
        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.downloadFiles(files[0].path, files, false, directory);
    }
}


/***/ }),

/***/ "./lib/components/settings/SubscriptionActive.js":
/*!*******************************************************!*\
  !*** ./lib/components/settings/SubscriptionActive.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SubscriptionActive": () => (/* binding */ SubscriptionActive)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core */ "./lib/core/Label.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../core */ "./lib/core/Switch.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _EgressBuckets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../EgressBuckets */ "./lib/components/EgressBuckets.js");
/* harmony import */ var _StorageBuckets__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../StorageBuckets */ "./lib/components/StorageBuckets.js");
/* harmony import */ var _core_WarningPopup__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/WarningPopup */ "./lib/core/WarningPopup.js");
/* harmony import */ var _core_PlansPopup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/PlansPopup */ "./lib/core/PlansPopup.js");
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Tag */ "./lib/components/Tag.js");
/* harmony import */ var _core_CustomerState__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/CustomerState */ "./lib/core/CustomerState.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/














class SubscriptionActive extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.ordinalSuffixOf = (i) => {
            var j = i % 10, k = i % 100;
            if (j == 1 && k != 11) {
                return i + "st";
            }
            if (j == 2 && k != 12) {
                return i + "nd";
            }
            if (j == 3 && k != 13) {
                return i + "rd";
            }
            return i + "th";
        };
        this.handleCancelSubscription = async () => {
            this.safeSetState({ cancelWaiting: true });
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/cancel-subscription";
            const init = {
                method: 'GET',
            };
            await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.text();
            }).then((body) => {
                // When the customer clicks on the button, redirect them to the portal
                this.safeSetState({ cancelWaiting: false, showCancelSubscriptionPopup: false });
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.customerState = _core_CustomerState__WEBPACK_IMPORTED_MODULE_5__.CustomerState.SUBSCRIPTION_CANCELED;
            });
        };
        this.handlePortalClick = async () => {
            this.safeSetState({ portalWaiting: true });
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/create-portal";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    redirect: settings.baseUrl,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                // When the customer clicks on the button, redirect them to the portal
                window.location.href = body.url;
                this.safeSetState({ portalWaiting: false });
            });
        };
        this.getDuration = (record) => {
            var endTime = new Date(record.endTime);
            var startTime = new Date(record.startTime);
            var diff = endTime.getTime() - startTime.getTime();
            return _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].msToTime(diff, true);
        };
        this.saveDetailedBilling = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user == null)
                return;
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-detailed-billing";
            const now = new Date();
            const threeMonthsAgo = new Date();
            threeMonthsAgo.setMonth(threeMonthsAgo.getMonth() - 3);
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    startTime: threeMonthsAgo.toISOString(),
                    endTime: now.toISOString(),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                if (body) {
                    const data = [];
                    for (let record of body.records) {
                        switch (record.type) {
                            case 'Machine':
                                const machine = body.machines[record.provider + ':' + record.product];
                                data.push([
                                    "Machine",
                                    new Date(record.startTime).toLocaleString().replace(/,/g, ''),
                                    new Date(record.endTime).toLocaleString().replace(/,/g, ''),
                                    this.getDuration(record),
                                    '$' + (record.rate * 3600).toFixed(2),
                                    record.cost < 0 ? '$' + (-record.cost).toFixed(5) : '',
                                    record.cost > 0 ? '$' + record.cost.toFixed(5) : '',
                                    machine.graphicsNumCards > 0 ? (machine.graphicsNumCards + 'x' + machine.graphicsCardType) : 'No GPU',
                                    machine.computeCores[1] + ' cores',
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(machine.memorySize),
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(machine.storageSize)
                                ]);
                                break;
                            case 'Payment':
                                data.push([
                                    "Payment",
                                    new Date(record.time).toLocaleString().replace(/,/g, ''),
                                    '',
                                    '',
                                    '',
                                    record.cost < 0 ? '$' + (-record.cost).toFixed(5) : '',
                                    record.cost > 0 ? '$' + record.cost.toFixed(5) : '',
                                    '',
                                    '',
                                    '',
                                    ''
                                ]);
                                break;
                            case 'Egress':
                                data.push([
                                    "Egress",
                                    new Date(record.time).toLocaleString().replace(/,/g, ''),
                                    '',
                                    '',
                                    '',
                                    record.cost < 0 ? '$' + (-record.cost).toFixed(5) : '',
                                    record.cost > 0 ? '$' + record.cost.toFixed(5) : '',
                                    '',
                                    '',
                                    '',
                                    ''
                                ]);
                                break;
                            case 'Storage':
                                data.push([
                                    "Storage",
                                    new Date(record.time).toLocaleString().replace(/,/g, ''),
                                    '',
                                    '',
                                    '',
                                    record.cost < 0 ? '$' + (-record.cost).toFixed(5) : '',
                                    record.cost > 0 ? '$' + record.cost.toFixed(5) : '',
                                    '',
                                    '',
                                    '',
                                    ''
                                ]);
                                break;
                            case 'Service Fee':
                                data.push([
                                    "Service Fee",
                                    new Date(record.startTime).toLocaleString().replace(/,/g, ''),
                                    new Date(record.endTime).toLocaleString().replace(/,/g, ''),
                                    this.getDuration(record),
                                    '$' + (record.rate * 3600).toFixed(2),
                                    record.cost < 0 ? '$' + (-record.cost).toFixed(5) : '',
                                    record.cost > 0 ? '$' + record.cost.toFixed(5) : '',
                                    '',
                                    '',
                                    '',
                                    ''
                                ]);
                                break;
                            default:
                                console.error("Unknown billing record type " + record.type);
                        }
                    }
                    var sorted = data.sort((n1, n2) => {
                        if (new Date(n1[1]) > new Date(n2[1])) {
                            return 1;
                        }
                        if (new Date(n1[1]) < new Date(n2[1])) {
                            return -1;
                        }
                        return 0;
                    });
                    const headers = [
                        ["Type", "Start Time", "End Time", "Duration", "Rate ($/hr)", "Credit ($)", "Debit ($)", "GPU", "CPU", "RAM", "Disk"]
                    ];
                    var link = document.createElement("a");
                    var blob = new Blob([headers.map(e => e.join(",")).join("\n") + '\n' + sorted.map(e => e.join(",")).join("\n") + '\n'], {
                        type: "data:text/csv;charset=utf-8,"
                    });
                    link.setAttribute("href", window.URL.createObjectURL(blob));
                    link.setAttribute("download", "billing_records.csv");
                    document.body.appendChild(link); // Required for FF
                    link.click();
                }
            });
        };
        this.getCostDiv = (costType = '') => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', width: '100%', padding: '3px 0px' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        height: '12px',
                        margin: '0px 12px',
                        lineHeight: '12px',
                        textAlign: 'left',
                        whiteSpace: 'pre',
                    } }, costType == 'Service Fee' ? ('Optumi service') : costType == 'Machine' ? ('Machines') : costType == 'Storage' ? ('Storage') : costType == 'Egress' ? ('Egress') : ('Total cost')),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        width: '100%',
                        height: '12px',
                        margin: '0px 6px',
                        lineHeight: '12px',
                        textAlign: 'right',
                        display: 'flex',
                        justifyContent: 'end',
                    } }, costType == 'Service Fee' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, this.props.serviceFeeCost == null ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.LinearProgress, { sx: { width: '25px' } })) : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].formatCost(this.props.serviceFeeCost))) : costType == 'Machine' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, this.props.machineCost == null ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.LinearProgress, { sx: { width: '25px' } })) : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].formatCost(this.props.machineCost))) : costType == 'Storage' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, this.props.storageCost == null ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.LinearProgress, { sx: { width: '25px' } })) : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].formatCost(this.props.storageCost))) : costType == 'Egress' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, this.props.egressCost == null ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.LinearProgress, { sx: { width: '25px' } })) : _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].formatCost(this.props.egressCost))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, (this.props.egressCost == null || this.props.machineCost == null || this.props.storageCost == null || this.props.serviceFeeCost == null) ?
                    (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.LinearProgress, { sx: { width: '25px' } }))
                    :
                        (() => {
                            var sum = +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].floorAndToFixed(this.props.machineCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].floorAndToFixed(this.props.egressCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].floorAndToFixed(this.props.storageCost, 2) + +_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].floorAndToFixed(this.props.serviceFeeCost, 2);
                            if (sum == 0 && (this.props.machineCost > 0 || this.props.egressCost > 0 || this.props.storageCost > 0 || this.props.serviceFeeCost > 0))
                                return '< $0.01';
                            return `${_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].formatCost(sum)}`;
                        })())))));
        };
        // The contents of the component
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const credit = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.credit;
            const now = new Date();
            var nextAnchor = _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.billingCycleAnchor;
            if (nextAnchor) {
                nextAnchor.setFullYear(now.getFullYear());
                nextAnchor.setMonth(now.getMonth());
                if (nextAnchor < now)
                    nextAnchor.setMonth(nextAnchor.getMonth() + 1);
            }
            else {
                nextAnchor = new Date(0);
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.Header, { title: 'Current plan' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PlansPopup__WEBPACK_IMPORTED_MODULE_8__.PlansPopup, { open: this.state.plansOpen, handleClose: () => this.safeSetState({ plansOpen: false }), openButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tag__WEBPACK_IMPORTED_MODULE_9__.Tag, { label: 'View plans', onClick: () => this.safeSetState({ plansOpen: true }) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_10__.Label, { label: 'Starter', getValue: () => '$0.10/hour', align: 'left', valueAlign: 'right', lineHeight: '20px' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_10__.Label, { label: 'Storage', getValue: () => (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.limit == _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[0].limit ? 'Free up to ' : 'Up to ') + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.limit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_11__.InfoPopup, { title: 'Storage', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '12px' } }, "Storage refers to data you store persistently in the Optumi platform, such as uploaded files used as input for notebooks. It does not include temporary disk space on machines provisioned to run your notebooks.") }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_10__.Label, { label: 'Egress', getValue: () => (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.egressLimit == _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.egressBuckets[0].limit ? 'Free up to ' : 'Up to ') + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.egressLimit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_11__.InfoPopup, { title: 'Egress', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '12px' } },
                            "Egress refers to data (files, images, logs) transferred out of the Optumi platform. Examples include:",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.UL, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, null, "Using your notebook to send files to Amazon RedShift or Google BigQuery"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, null, "Downloading a file from the Optumi platform to your laptop"))) }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex', width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_12__.Switch, { label: 'Dynamic upgrades', getValue: () => _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.autoAddOnsEnabled, saveValue: value => {
                            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.autoAddOnsEnabled = value;
                            if (!value && _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.fileTracker.total > _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[0].limit) {
                                this.safeSetState({ showStoragePopup: true });
                            }
                        }, labelBefore: true, sx: { width: '100%', paddingY: 0.25, marginRight: '12px' }, info: (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_11__.InfoPopup, { title: 'Dynamic upgrades', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: 1 } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                                    "If enabled, storage and egress tiers will be automatically upgraded as you consume more of each resource. For example, if in a given billing period you use ",
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()((_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[1].limit + _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[2].limit) / 2),
                                    " of storage, you will be charged $",
                                    _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[2].cost,
                                    "."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, "If disabled, you will not be able to consume more than the storage and egress limits included in your current tier."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, "At the beginning of every billing cycle you will start off in the lowest possible tier based on your usage."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("br", null),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_StorageBuckets__WEBPACK_IMPORTED_MODULE_13__.StorageBuckets, { buckets: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets }),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_EgressBuckets__WEBPACK_IMPORTED_MODULE_14__.EgressBuckets, { buckets: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.egressBuckets })) })) }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_15__["default"], { open: this.state.showStoragePopup, headerText: "Dynamic storage", bodyText: `If you would like to shift into a lower storage tier for next billing cycle, you will have to delete more data. For example, to shift into the free storage tier your usage must be under ${_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[0].limit)}.`, continue: {
                            text: `OK`,
                            onContinue: (prevent) => {
                                this.safeSetState({ showStoragePopup: false });
                            },
                            color: `primary`,
                        } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.Header, { title: `To be billed on ${nextAnchor.toLocaleString('default', { month: 'long' })} ${this.ordinalSuffixOf(nextAnchor.getDate())}` }),
                this.getCostDiv('Service Fee'),
                this.getCostDiv('Machine'),
                this.getCostDiv('Storage'),
                this.getCostDiv('Egress'),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'fullWidth', sx: { margin: '12px' } }),
                this.getCostDiv(),
                credit > 0 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { marginX: 1, marginY: 0.75 } },
                    "A credit up to $",
                    (credit).toFixed(2),
                    " will be applied to your first bill")),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex', padding: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disabled: this.state.portalWaiting, variant: "contained", color: "primary", sx: { width: '50%', margin: 0.5 }, onClick: this.handlePortalClick }, this.state.portalWaiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' })) : 'Payment settings'),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { fullWidth: true, variant: "outlined", color: "primary", startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.GetApp, null), sx: { width: '50%', margin: 0.5 }, onClick: this.saveDetailedBilling }, "Billing records")),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_7__.Header, { title: 'Cancel subscription' }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex', padding: 0.75 } }, "You can cancel your subscription at any time"),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'flex', padding: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_WarningPopup__WEBPACK_IMPORTED_MODULE_15__["default"], { open: this.state.showCancelSubscriptionPopup, headerText: "Are you sure?", bodyContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            "You are about to cancel your subscription to the Optumi Starter tier. Here are a few things to remember:",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.UL, { sx: { lineHeight: '2' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, null, "Data will be removed in 2 weeks (so there's time for you to retrieve it)"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, null, "You will still be able to log in, view workload details and download files"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.LI, null, "You can re-subscribe to retain data and launch more workloads"))), cancel: {
                            text: `Keep subscription`,
                            onCancel: (prevent) => {
                                this.safeSetState({ showCancelSubscriptionPopup: false });
                            },
                        }, continue: {
                            text: `Cancel subscription`,
                            onContinueAsync: async (prevent) => {
                                await this.handleCancelSubscription();
                            },
                            color: `error`,
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: "outlined", color: "error", sx: { width: 'calc(50% - 12px)', margin: 0.5 }, onClick: () => this.safeSetState({ showCancelSubscriptionPopup: true }) }, "Cancel"))));
        };
        this.handleUserChange = () => {
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userInformationChanged.connect(this.handleUserChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.onUserChange.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            portalWaiting: false,
            showStoragePopup: false,
            plansOpen: false,
            showCancelSubscriptionPopup: false,
            cancelWaiting: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/settings/SubscriptionEnded.js":
/*!******************************************************!*\
  !*** ./lib/components/settings/SubscriptionEnded.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SubscriptionEnded": () => (/* binding */ SubscriptionEnded)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core */ "./lib/core/Header.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/Label.js");
/* harmony import */ var _core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/InfoPoppup */ "./lib/core/InfoPoppup.js");
/* harmony import */ var _core_PlansPopup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/PlansPopup */ "./lib/core/PlansPopup.js");
/* harmony import */ var _core_SubscribeButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../core/SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _Tag__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tag */ "./lib/components/Tag.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class SubscriptionEnded extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // The contents of the component
        this.render = () => {
            var _a;
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_2__.Header, { title: 'Current plan' }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_PlansPopup__WEBPACK_IMPORTED_MODULE_3__.PlansPopup, { open: this.state.plansOpen, handleClose: () => this.safeSetState({ plansOpen: false }), openButton: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tag__WEBPACK_IMPORTED_MODULE_4__.Tag, { label: 'View plans', onClick: () => this.safeSetState({ plansOpen: true }) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex', width: '100%' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.subscriptionEnd ? 'Starter subscription canceled on ' + ((_a = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.subscriptionEnd) === null || _a === void 0 ? void 0 : _a.toLocaleDateString()) : 'Starter subscription canceled', getValue: () => '', align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Your subscription has been cancelled', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "You can no longer launch workloads but you can still view workload details and download files (subject to remaining egress limits)."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "Your data will be retained for 14 days after the cancellation date.")) }) })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Storage', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker.limit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Storage', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } }, "Storage refers to data you store persistently in the Optumi platform, such as uploaded files used as input for notebooks. It does not include temporary disk space on machines provisioned to run your notebooks.") }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.Label, { label: 'Egress', getValue: () => 'Up to ' + _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_7__["default"].styleCapacityUnitValue()(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.egressLimit), align: 'left', valueAlign: 'right', lineHeight: '20px', info: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_InfoPoppup__WEBPACK_IMPORTED_MODULE_6__.InfoPopup, { title: 'Egress', sx: { marginY: 'auto', marginLeft: 0.5, marginRight: -0.5, marginBottom: '2px' }, popup: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '12px' } },
                            "Egress refers to data (files, images, logs) transferred out of the Optumi platform. Examples include:",
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.UL, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.LI, null, "Using your notebook to send files to Amazon RedShift or Google BigQuery"),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.LI, null, "Downloading a file from the Optumi platform to your laptop"))) }) }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'flex', width: '100%', padding: 0.5 } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core_SubscribeButton__WEBPACK_IMPORTED_MODULE_8__.SubscribeButton, { sx: { width: '50%', marginX: 'auto' } }))));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            portalWaiting: false,
            showStoragePopup: false,
            plansOpen: false,
        };
    }
}


/***/ }),

/***/ "./lib/components/settings/VersionHistory.js":
/*!***************************************************!*\
  !*** ./lib/components/settings/VersionHistory.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VersionHistory": () => (/* binding */ VersionHistory)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _deploy_fileBrowser_DirListingItem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../deploy/fileBrowser/DirListingItem */ "./lib/components/deploy/fileBrowser/DirListingItem.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_1__.withStyles)({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
        width: 'calc(min(80%, 600px + 2px))',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Dialog);
class VersionHistory extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.organizeFiles = () => {
            const newChildren = [];
            // Combine multiple children that are the same file
            for (let child of this.props.metadata.content) {
                var match = false;
                for (let newChild of newChildren) {
                    if (newChild.hash == child.hash) {
                        newChild.content.push(child);
                        match = true;
                        break;
                    }
                }
                if (!match) {
                    const newChild = JSON.parse(JSON.stringify(child));
                    newChild.content = [JSON.parse(JSON.stringify(newChild))];
                    newChildren.push(newChild);
                }
            }
            return newChildren;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: () => {
                        if (this.props.onClose)
                            this.props.onClose();
                        this.safeSetState({ open: false });
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                width: '100%',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: 'auto 12px' } }, "Version history")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.IconButton, { size: 'large', onClick: () => this.safeSetState({ open: false }), sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_core__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogContent, { sx: { padding: '8px', lineHeight: '24px', fontSize: 'var(--jp-ui-font-size0)' } }, this.state.organizedFiles.map(metadata => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_deploy_fileBrowser_DirListingItem__WEBPACK_IMPORTED_MODULE_6__["default"], { file: { file: metadata, indices: [] }, filter: null, selected: false, showReferences: true, showVersionHistory: false, onClick: () => void 0, onDoubleClick: () => void 0, onDownload: this.props.onDownload, onDelete: this.props.onDelete == undefined ? undefined :
                                (file) => {
                                    // Remove the file from the internal state
                                    const sortedFiles = this.state.organizedFiles.filter(x => x.path != file.path || x.hash != file.hash);
                                    this.setState({ organizedFiles: sortedFiles, open: sortedFiles.length > 0 });
                                    // Perform the passed in action
                                    this.props.onDelete(file);
                                } })))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { onClick: () => this.safeSetState({ open: true }) }, "Version history")));
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            open: false,
            organizedFiles: this.organizeFiles(),
        };
    }
}


/***/ }),

/***/ "./lib/core/AnsiLink.js":
/*!******************************!*\
  !*** ./lib/core/AnsiLink.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnsiLink": () => (/* binding */ AnsiLink)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_escape__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash.escape */ "./node_modules/lodash.escape/index.js");
/* harmony import */ var lodash_escape__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_escape__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class AnsiLink extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.PRE, { sx: Object.assign({}, this.props.sx), dangerouslySetInnerHTML: { __html: autolink(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.defaultSanitizer.sanitize(ansiSpan(this.props.text))) } }));
        };
    }
}
/// The functions below were taken from https://github.com/jupyterlab/jupyterlab/blob/b05c2748c021a8da681315fd0a6bcaee01e96d6b/packages/rendermime/src/renderers.ts
function autolink(content) {
    // Taken from Visual Studio Code:
    // https://github.com/microsoft/vscode/blob/9f709d170b06e991502153f281ec3c012add2e42/src/vs/workbench/contrib/debug/browser/linkDetector.ts#L17-L18
    const controlCodes = '\\u0000-\\u0020\\u007f-\\u009f';
    const webLinkRegex = new RegExp('(?:[a-zA-Z][a-zA-Z0-9+.-]{2,}:\\/\\/|data:|www\\.)[^\\s' +
        controlCodes +
        '"]{2,}[^\\s' +
        controlCodes +
        '"\'(){}\\[\\],:;.!?]', 'ug');
    return content.replace(webLinkRegex, url => {
        // Special case when the URL ends with ">" or "<"
        const lastChars = url.slice(-3);
        const endsWithGtLt = ['&gt', '&lt'].indexOf(lastChars) !== -1;
        const toAppend = endsWithGtLt ? lastChars : '';
        const len = endsWithGtLt ? url.length - 3 : url.length;
        return (`<a href="${url.slice(0, len)}" rel="noopener" target="_blank">` +
            `${url.slice(0, len)}</a>${toAppend}`);
    });
}
const ANSI_COLORS = [
    'ansi-black',
    'ansi-red',
    'ansi-green',
    'ansi-yellow',
    'ansi-blue',
    'ansi-magenta',
    'ansi-cyan',
    'ansi-white',
    'ansi-black-intense',
    'ansi-red-intense',
    'ansi-green-intense',
    'ansi-yellow-intense',
    'ansi-blue-intense',
    'ansi-magenta-intense',
    'ansi-cyan-intense',
    'ansi-white-intense'
];
/**
 * Create HTML tags for a string with given foreground, background etc. and
 * add them to the `out` array.
 */
function pushColoredChunk(chunk, fg, bg, bold, underline, inverse, out) {
    if (chunk) {
        const classes = [];
        const styles = [];
        if (bold && typeof fg === 'number' && 0 <= fg && fg < 8) {
            fg += 8; // Bold text uses "intense" colors
        }
        if (inverse) {
            [fg, bg] = [bg, fg];
        }
        if (typeof fg === 'number') {
            classes.push(ANSI_COLORS[fg] + '-fg');
        }
        else if (fg.length) {
            styles.push(`color: rgb(${fg})`);
        }
        else if (inverse) {
            classes.push('ansi-default-inverse-fg');
        }
        if (typeof bg === 'number') {
            classes.push(ANSI_COLORS[bg] + '-bg');
        }
        else if (bg.length) {
            styles.push(`background-color: rgb(${bg})`);
        }
        else if (inverse) {
            classes.push('ansi-default-inverse-bg');
        }
        if (bold) {
            classes.push('ansi-bold');
        }
        if (underline) {
            classes.push('ansi-underline');
        }
        if (classes.length || styles.length) {
            out.push('<SPAN');
            if (classes.length) {
                out.push(` class="${classes.join(' ')}"`);
            }
            if (styles.length) {
                out.push(` style="${styles.join('; ')}"`);
            }
            out.push('>');
            out.push(chunk);
            out.push('</SPAN>');
        }
        else {
            out.push(chunk);
        }
    }
}
/**
 * Convert ANSI extended colors to R/G/B triple.
 */
function getExtendedColors(numbers) {
    let r;
    let g;
    let b;
    const n = numbers.shift();
    if (n === 2 && numbers.length >= 3) {
        // 24-bit RGB
        r = numbers.shift();
        g = numbers.shift();
        b = numbers.shift();
        if ([r, g, b].some(c => c < 0 || 255 < c)) {
            throw new RangeError('Invalid range for RGB colors');
        }
    }
    else if (n === 5 && numbers.length >= 1) {
        // 256 colors
        const idx = numbers.shift();
        if (idx < 0) {
            throw new RangeError('Color index must be >= 0');
        }
        else if (idx < 16) {
            // 16 default terminal colors
            return idx;
        }
        else if (idx < 232) {
            // 6x6x6 color cube, see https://stackoverflow.com/a/27165165/500098
            r = Math.floor((idx - 16) / 36);
            r = r > 0 ? 55 + r * 40 : 0;
            g = Math.floor(((idx - 16) % 36) / 6);
            g = g > 0 ? 55 + g * 40 : 0;
            b = (idx - 16) % 6;
            b = b > 0 ? 55 + b * 40 : 0;
        }
        else if (idx < 256) {
            // grayscale, see https://stackoverflow.com/a/27165165/500098
            r = g = b = (idx - 232) * 10 + 8;
        }
        else {
            throw new RangeError('Color index must be < 256');
        }
    }
    else {
        throw new RangeError('Invalid extended color specification');
    }
    return [r, g, b];
}
/**
   * Transform ANSI color escape codes into HTML <SPAN> tags with CSS
   * classes such as "ansi-green-intense-fg".
   * The actual colors used are set in the CSS file.
   * This also removes non-color escape sequences.
   * This is supposed to have the same behavior as nbconvert.filters.ansi2html()
   */
function ansiSpan(str) {
    const ansiRe = /\x1b\[(.*?)([@-~])/g; // eslint-disable-line no-control-regex
    let fg = [];
    let bg = [];
    let bold = false;
    let underline = false;
    let inverse = false;
    let match;
    const out = [];
    const numbers = [];
    let start = 0;
    str = lodash_escape__WEBPACK_IMPORTED_MODULE_2___default()(str);
    str += '\x1b[m'; // Ensure markup for trailing text
    // tslint:disable-next-line
    while ((match = ansiRe.exec(str))) {
        if (match[2] === 'm') {
            const items = match[1].split(';');
            for (let i = 0; i < items.length; i++) {
                const item = items[i];
                if (item === '') {
                    numbers.push(0);
                }
                else if (item.search(/^\d+$/) !== -1) {
                    numbers.push(parseInt(item, 10));
                }
                else {
                    // Ignored: Invalid color specification
                    numbers.length = 0;
                    break;
                }
            }
        }
        else {
            // Ignored: Not a color code
        }
        const chunk = str.substring(start, match.index);
        pushColoredChunk(chunk, fg, bg, bold, underline, inverse, out);
        start = ansiRe.lastIndex;
        while (numbers.length) {
            const n = numbers.shift();
            switch (n) {
                case 0:
                    fg = bg = [];
                    bold = false;
                    underline = false;
                    inverse = false;
                    break;
                case 1:
                case 5:
                    bold = true;
                    break;
                case 4:
                    underline = true;
                    break;
                case 7:
                    inverse = true;
                    break;
                case 21:
                case 22:
                    bold = false;
                    break;
                case 24:
                    underline = false;
                    break;
                case 27:
                    inverse = false;
                    break;
                case 30:
                case 31:
                case 32:
                case 33:
                case 34:
                case 35:
                case 36:
                case 37:
                    fg = n - 30;
                    break;
                case 38:
                    try {
                        fg = getExtendedColors(numbers);
                    }
                    catch (e) {
                        numbers.length = 0;
                    }
                    break;
                case 39:
                    fg = [];
                    break;
                case 40:
                case 41:
                case 42:
                case 43:
                case 44:
                case 45:
                case 46:
                case 47:
                    bg = n - 40;
                    break;
                case 48:
                    try {
                        bg = getExtendedColors(numbers);
                    }
                    catch (e) {
                        numbers.length = 0;
                    }
                    break;
                case 49:
                    bg = [];
                    break;
                case 90:
                case 91:
                case 92:
                case 93:
                case 94:
                case 95:
                case 96:
                case 97:
                    fg = n - 90 + 8;
                    break;
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                case 105:
                case 106:
                case 107:
                    bg = n - 100 + 8;
                    break;
                default:
                // Unknown codes are ignored
            }
        }
    }
    return out.join('');
}


/***/ }),

/***/ "./lib/core/BaseConnectorPopup.js":
/*!****************************************!*\
  !*** ./lib/core/BaseConnectorPopup.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseConnectorPopup": () => (/* binding */ BaseConnectorPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _TextBox__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./TextBox */ "./lib/core/TextBox.js");
/* harmony import */ var _components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/deploy/DataConnectorIdentity */ "./lib/components/deploy/DataConnectorIdentity.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _components_deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/deploy/IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../models/IntegrationConfig */ "./lib/models/IntegrationConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/














const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
const StyledButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    startIcon: {
        marginRight: '0px',
    },
    iconSizeMedium: {
        '& > *:first-child': {
            fontSize: '12px',
        },
    }
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button);
const defaultState = {
    waiting: false,
    open: false,
    addSpinning: false,
    createSpinning: false,
    name: '',
    errorMessage: '',
};
class BaseConnectorPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            if (!this.state.waiting) {
                if (this.props.onClose)
                    this.props.onClose();
                this.safeSetState(defaultState);
            }
        };
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_6__.Global.metadata;
            const optumi = tracker.getMetadata();
            const integrations = optumi.config.integrations;
            for (var i = 0; i < integrations.length; i++) {
                if (integrations[i].name === name)
                    return true;
            }
            return false;
        };
        this.handleCreate = (add) => {
            this.safeSetState({ errorMessage: '', waiting: true, addSpinning: false, createSpinning: false });
            if (add) {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ addSpinning: true });
                }, 1000);
            }
            else {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ createSpinning: true });
                }, 1000);
            }
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/add-integration';
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    name: this.state.name,
                    info: JSON.stringify(Object.assign({ integrationType: _components_deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_7__.IntegrationType.DATA_CONNECTOR, dataService: this.props.dataService, downloadPath: this.props.downloadPath }, this.props.getInfo())),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_6__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                try {
                    var parsed = JSON.parse(body.message);
                    // TODO:JJ This is a hacky way to figure out if the returned value is a json data connector (meaning this was successful)
                    if (!(parsed.integrationType && parsed.type && parsed.name && parsed.dataService))
                        throw Error();
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false });
                    if (add && !this.nameHasError(this.state.name)) {
                        const tracker = _Global__WEBPACK_IMPORTED_MODULE_6__.Global.metadata;
                        const optumi = tracker.getMetadata();
                        var integrations = optumi.config.integrations;
                        integrations.push(new _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__.DataConnectorConfig({
                            name: this.state.name,
                            dataService: this.props.dataService,
                        }));
                        tracker.setMetadata(optumi);
                    }
                    // Success
                    this.handleClose();
                }
                catch (err) {
                    // This means there was a failure
                    // Show what went wrong
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false, errorMessage: body.message });
                }
            }, (error) => {
                console.error(error);
                error.response.text().then((text) => {
                    // Show what went wrong
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false, errorMessage: text });
                });
            });
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open)
                return;
            if (event.key === 'Enter')
                this.handleCreate();
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnRender)
                console.log('CreateConnectorPopup (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: Object.assign({}, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_9__.DataConnectorIdentity, { dataService: this.props.dataService, description: this.props.description, handleClick: this.handleClickOpen }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                display: 'inline-flex',
                                flexGrow: 1,
                                marginLeft: '-6px', // this is to counteract the padding in CreateDataConnector so we can reuse it without messing with it
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_deploy_DataConnectorIdentity__WEBPACK_IMPORTED_MODULE_9__.DataConnectorIdentity, { dataService: this.props.dataService, sx: { zoom: 1.4 } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledButton, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'outlined', onClick: this.handleClose, disabled: this.state.waiting, startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.ArrowBackIos, null) }, "Back")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(false), disabled: this.state.waiting }, this.state.waiting && this.state.createSpinning ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' }) : 'Create'),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_10__["default"], { reminder: 'Create and add to your notebook' },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(true), disabled: (!(_Global__WEBPACK_IMPORTED_MODULE_6__.Global.labShell.currentWidget instanceof _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__.NotebookPanel) && _Global__WEBPACK_IMPORTED_MODULE_6__.Global.tracker.currentWidget != null) || this.state.waiting }, this.state.waiting && this.state.addSpinning ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' }) : 'Create and add')))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_11__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '0px', display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { padding: '12px', display: 'flex', flexDirection: 'column' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { margin: '12px 18px 18px 18px' } }, this.props.header + " Files from this connector will be accessible in your notebook's working directory."),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_12__.TextBox, { getValue: () => this.state.name, saveValue: (value) => this.safeSetState({ name: value }), label: 'Connector Name', helperText: 'The unique identifier for this connector.', labelWidth: BaseConnectorPopup.LABEL_WIDTH, disabled: this.state.waiting, required: true }),
                            this.props.getContents(this.state.waiting),
                            this.state.errorMessage && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                    color: _Colors__WEBPACK_IMPORTED_MODULE_13__.Colors.ERROR,
                                    margin: '36px 12px',
                                    wordBreak: 'break-all',
                                    fontSize: '12px',
                                } }, this.state.errorMessage)),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { flexGrow: 1 } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                    margin: '12px 18px',
                                    fontStyle: 'italic',
                                    fontSize: '14px',
                                    textAlign: 'end',
                                    // TODO:Beck how do I do this with the theme
                                    color: 'gray'
                                } }, "*required fields"))))));
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.state = defaultState;
    }
}
BaseConnectorPopup.LABEL_WIDTH = '144px';


/***/ }),

/***/ "./lib/core/CustomerState.js":
/*!***********************************!*\
  !*** ./lib/core/CustomerState.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CustomerState": () => (/* binding */ CustomerState)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
// NOTE: This needs to be kept in sync with the enum in the controller
var CustomerState;
(function (CustomerState) {
    CustomerState["INIT"] = "init";
    CustomerState["FREE_TRIAL"] = "free trial";
    CustomerState["FREE_TRIAL_ENDED"] = "free trial ended";
    CustomerState["STARTER"] = "starter";
    CustomerState["SUBSCRIPTION_CANCELED"] = "subscription canceled";
})(CustomerState || (CustomerState = {}));


/***/ }),

/***/ "./lib/core/Dropdown.js":
/*!******************************!*\
  !*** ./lib/core/Dropdown.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Dropdown": () => (/* binding */ Dropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




const StyledMenuItem = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    root: {
        fontSize: 'var(--jp-ui-font-size1)',
        padding: '3px 3px 3px 6px',
        textAlign: 'start',
    }
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.MenuItem);
class Dropdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleValueChange = (event) => {
            const value = event.target.value;
            this.safeSetState({ value: value });
            this.props.saveValue(value);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: Object.assign({
                    display: 'inline-flex',
                    width: '100%',
                    padding: '6px 0px',
                    // textAlign: 'center',
                    // justifyContent: 'center'
                }, this.props.sx) },
                this.props.label && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                        minWidth: this.props.labelWidth || '68px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                    } }, this.props.label),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.FormControl, { variant: 'outlined', sx: { width: '100%', margin: '2px 6px', height: this.props.helperText ? '32px' : '20px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.StyledSelect, { value: this.state.value, onChange: this.handleValueChange, SelectDisplayProps: { style: { padding: '1px 20px 1px 6px' } }, MenuProps: { MenuListProps: { style: { paddingTop: '6px', paddingBottom: '6px' } } }, sx: { width: '100%' }, disabled: this.props.disabled }, this.props.values.map(value => react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledMenuItem, { key: value.value, value: value.value, disabled: value.disabled }, value.value + (value.description ? (': ' + value.description) : '')))),
                    this.props.helperText &&
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.FormHelperText, { sx: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap' } }, this.props.helperText))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            value: this.props.getValue(),
        };
    }
}


/***/ }),

/***/ "./lib/core/EnvironmentVariablePopup.js":
/*!**********************************************!*\
  !*** ./lib/core/EnvironmentVariablePopup.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EnvironmentVariablePopup": () => (/* binding */ EnvironmentVariablePopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _TextBox__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./TextBox */ "./lib/core/TextBox.js");
/* harmony import */ var _components_deploy_EnvironmentVariableIdentity__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/deploy/EnvironmentVariableIdentity */ "./lib/components/deploy/EnvironmentVariableIdentity.js");
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _components_deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/deploy/IntegrationBrowser/IntegrationBrowser */ "./lib/components/deploy/IntegrationBrowser/IntegrationBrowser.js");
/* harmony import */ var _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../models/IntegrationConfig */ "./lib/models/IntegrationConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/














const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
const StyledButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    startIcon: {
        marginRight: '0px',
    },
    iconSizeMedium: {
        '& > *:first-child': {
            fontSize: '12px',
        },
    }
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button);
class EnvironmentVariable {
    constructor() {
        this.key = '';
        this.value = '';
    }
}
const defaultState = {
    waiting: false,
    open: false,
    addSpinning: false,
    createSpinning: false,
    name: '',
    errorMessage: '',
    variables: [],
};
class EnvironmentVariablePopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            this.safeSetState({ open: true, variables: [new EnvironmentVariable()] });
        };
        this.handleClose = () => {
            if (!this.state.waiting) {
                if (this.props.onClose)
                    this.props.onClose();
                this.safeSetState(defaultState);
            }
        };
        this.nameHasError = (name) => {
            const tracker = _Global__WEBPACK_IMPORTED_MODULE_6__.Global.metadata;
            const optumi = tracker.getMetadata();
            const integrations = optumi.config.integrations;
            for (var i = 0; i < integrations.length; i++) {
                if (integrations[i].name === name)
                    return true;
            }
            return false;
        };
        this.handleCreate = (add) => {
            this.safeSetState({ errorMessage: '', waiting: true, addSpinning: false, createSpinning: false });
            if (add) {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ addSpinning: true });
                }, 1000);
            }
            else {
                setTimeout(() => {
                    if (this.state.waiting)
                        this.safeSetState({ createSpinning: true });
                }, 1000);
            }
            const map = {};
            for (let variable of this.state.variables) {
                if (variable.key != '' && variable.value != '') {
                    map[variable.key] = variable.value;
                }
            }
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeSettings();
            const url = settings.baseUrl + 'optumi/add-integration';
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    name: this.state.name,
                    info: JSON.stringify({ integrationType: _components_deploy_IntegrationBrowser_IntegrationBrowser__WEBPACK_IMPORTED_MODULE_7__.IntegrationType.ENVIRONMENT_VARIABLE, name: this.state.name, variables: map }),
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_4__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_6__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                try {
                    var parsed = JSON.parse(body.message);
                    // TODO:JJ This is a hacky way to figure out if the returned value is a json data connector (meaning this was successful)
                    if (!(parsed.integrationType && parsed.type && parsed.name && parsed.keys))
                        throw Error();
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false });
                    if (add && !this.nameHasError(this.state.name)) {
                        const tracker = _Global__WEBPACK_IMPORTED_MODULE_6__.Global.metadata;
                        const optumi = tracker.getMetadata();
                        var integrations = optumi.config.integrations;
                        integrations.push(new _models_IntegrationConfig__WEBPACK_IMPORTED_MODULE_8__.EnvironmentVariableConfig({
                            name: this.state.name,
                        }));
                        tracker.setMetadata(optumi);
                    }
                    // Success
                    this.handleClose();
                }
                catch (err) {
                    // This means there was a failure
                    // Show what went wrong
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false, errorMessage: body.message });
                }
            }, (error) => {
                console.error(error);
                error.response.text().then((text) => {
                    // Show what went wrong
                    this.safeSetState({ waiting: false, addSpinning: false, createSpinning: false, errorMessage: text });
                });
            });
        };
        this.handleKeyDown = (event) => {
            if (!this.state.open)
                return;
            if (event.key === 'Enter')
                this.handleCreate();
            if (event.key === 'Escape')
                this.handleClose();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnRender)
                console.log('CreateEnvironmentVariablePopup (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: Object.assign({}, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_deploy_EnvironmentVariableIdentity__WEBPACK_IMPORTED_MODULE_9__.EnvironmentVariableIdentity, { description: 'Add an environment variable', handleClick: this.handleClickOpen }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                display: 'inline-flex',
                                flexGrow: 1,
                                marginLeft: '-6px', // this is to counteract the padding in CreateEnvironmentVariablePopup so we can reuse it without messing with it
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_deploy_EnvironmentVariableIdentity__WEBPACK_IMPORTED_MODULE_9__.EnvironmentVariableIdentity, { sx: { zoom: 1.4 } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledButton, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'outlined', onClick: this.handleClose, disabled: this.state.waiting, startIcon: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.ArrowBackIos, null) }, "Back")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, null,
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(false), disabled: this.state.waiting }, this.state.waiting && this.state.createSpinning ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' }) : 'Create'),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_10__["default"], { reminder: 'Create and add to your notebook' },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { disableElevation: true, sx: { margin: '6px', height: '36px' }, variant: 'contained', color: 'primary', onClick: () => this.handleCreate(true), disabled: (!(_Global__WEBPACK_IMPORTED_MODULE_6__.Global.labShell.currentWidget instanceof _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_5__.NotebookPanel) && _Global__WEBPACK_IMPORTED_MODULE_6__.Global.tracker.currentWidget != null) || this.state.waiting }, this.state.waiting && this.state.addSpinning ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' }) : 'Create and add')))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_11__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '0px', display: 'flex' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { padding: '12px', display: 'flex', flexDirection: 'column' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { margin: '12px 18px 18px 18px' } },
                                "Environment variables are stored encrypted in the Optumi platform and are a convenient way of accessing credentials or configuration options. You can read more about environment variables in python ",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: 'https://docs.python.org/3/library/os.html#os.environ', target: '_blank', style: { marginLeft: '3px', color: 'var(--jp-ui-font-color0)', textDecoration: 'underline' } }, "here")),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_12__.TextBox, { getValue: () => this.state.name, saveValue: (value) => this.safeSetState({ name: value }), label: 'Name', helperText: 'The unique identifier for this environment variable.', labelWidth: EnvironmentVariablePopup.LABEL_WIDTH, disabled: this.state.waiting, required: true }),
                            this.state.variables.map(variable => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_12__.TextBox, { getValue: () => variable.key, saveValue: (value) => {
                                        variable.key = value;
                                        if (this.state.variables[this.state.variables.length - 1].key != '') {
                                            this.safeSetState({ variables: [...this.state.variables, new EnvironmentVariable()] });
                                        }
                                    }, label: 'Variable key', helperText: 'The environment variable key.', labelWidth: EnvironmentVariablePopup.LABEL_WIDTH, disabled: this.state.waiting, required: true }),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_12__.TextBox, { getValue: () => variable.value, saveValue: (value) => {
                                        variable.value = value;
                                        if (this.state.variables[this.state.variables.length - 1].value != '') {
                                            this.safeSetState({ variables: [...this.state.variables, new EnvironmentVariable()] });
                                        }
                                    }, label: 'Value', helperText: 'The environment variable value.', labelWidth: EnvironmentVariablePopup.LABEL_WIDTH, disabled: this.state.waiting, required: true })))),
                            this.state.errorMessage && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                    color: _Colors__WEBPACK_IMPORTED_MODULE_13__.Colors.ERROR,
                                    margin: '36px 12px',
                                    wordBreak: 'break-all',
                                    fontSize: '12px',
                                } }, this.state.errorMessage)),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: { flexGrow: 1 } }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_6__.DIV, { sx: {
                                    margin: '12px 18px',
                                    fontStyle: 'italic',
                                    fontSize: '14px',
                                    textAlign: 'end',
                                    // TODO:Beck how do I do this with the theme
                                    color: 'gray'
                                } }, "*required fields"))))));
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_6__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            document.addEventListener('keydown', this.handleKeyDown, false);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.handleKeyDown, false);
            this._isMounted = false;
        };
        this.state = defaultState;
    }
}
EnvironmentVariablePopup.LABEL_WIDTH = '144px';


/***/ }),

/***/ "./lib/core/Header.js":
/*!****************************!*\
  !*** ./lib/core/Header.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Header": () => (/* binding */ Header),
/* harmony export */   "SubHeader": () => (/* binding */ SubHeader),
/* harmony export */   "SubSubHeader": () => (/* binding */ SubSubHeader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class Header extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({
                    textAlign: this.props.align || 'left',
                    fontSize: '16px',
                    fontWeight: 'bold',
                    lineHeight: '18px',
                    margin: '6px'
                }, this.props.sx) }, this.props.title));
        };
    }
}
class SubHeader extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({
                    textAlign: this.props.align || 'left',
                    fontSize: '14px',
                    fontWeight: 'bold',
                    lineHeight: '18px',
                    margin: '6px',
                    opacity: this.props.grey ? 0.5 : 1,
                }, this.props.sx) }, this.props.title));
        };
    }
}
class SubSubHeader extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({
                    textAlign: this.props.align || 'left',
                    fontSize: '13px',
                    lineHeight: '18px',
                    margin: '6px',
                    color: 'var(--jp-ui-font-color2)',
                }, this.props.sx) }, this.props.title));
        };
    }
}


/***/ }),

/***/ "./lib/core/HoldoverTimePopup.js":
/*!***************************************!*\
  !*** ./lib/core/HoldoverTimePopup.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HoldoverTimePopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _TextBox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TextBox */ "./lib/core/TextBox.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class HoldoverTimePopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.PermanentPopup, { open: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.getDisplayNum() > 0 && new Date(0).getTime() == _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.holdoverTimePopupDismissed.getTime() },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                        display: 'inline-flex',
                        height: '60px',
                        padding: '6px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            display: 'inline-flex',
                            minWidth: '150px',
                            fontSize: '16px',
                            fontWeight: 'bold',
                            paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Heads up!")),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1 } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.holdoverTimePopupDismissed = new Date();
                                this.forceUpdate();
                            }, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } })))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__.ShadowedDivider, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '18px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '6px 18px', whiteSpace: 'pre-wrap' } },
                        "You can configure how long machines are held onto after workloads finish. This can also be changed at any time in Settings",
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: {
                                padding: 0.5,
                                zIndex: 1,
                            }, onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.followLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.SettingsPopup.LimitsTab);
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { sx: { height: '18px', width: '18px' } })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'inline-flex', width: '100%', justifyContent: 'center', marginTop: '24px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextBox__WEBPACK_IMPORTED_MODULE_5__.TextBox, { sx: { width: '75px' }, getValue: this.getUserHoldoverTimeValue, saveValue: this.saveUserHoldoverTimeValue, styledUnitValue: (value) => { return isNaN(value) ? "" : value.toFixed(); }, unstyleUnitValue: (value) => { return value.replace(/\d/g, '').length > 0 ? Number.NaN : Number.parseFloat(value); }, onFocus: () => this.safeSetState({ holdoverFocused: true }), onBlur: () => this.safeSetState({ holdoverFocused: false }), minValue: 0, maxValue: +(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.maxHoldoverTime / 60).toFixed() }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: 'auto 0px' } }, "minutes before releasing idle machines"))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogActions, { sx: { padding: '12px 6px 6px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: 'contained', color: 'primary', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.holdoverTimePopupDismissed = new Date();
                            }, sx: { marginLeft: '18x' } }, "Got it")))));
        };
        this.handleUserChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.connect(this.handleUserChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            holdoverFocused: false,
        };
    }
    getUserHoldoverTimeValue() { return Math.round(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userHoldoverTime / 60); }
    saveUserHoldoverTimeValue(userHoldoverTime) { _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userHoldoverTime = userHoldoverTime * 60; }
}


/***/ }),

/***/ "./lib/core/InfoPoppup.js":
/*!********************************!*\
  !*** ./lib/core/InfoPoppup.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InfoPopup": () => (/* binding */ InfoPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! . */ "./lib/core/ShadowedDivider.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 2px))',
        // width: '100%',
        // height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class InfoPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleClickOpen = () => {
            this.safeSetState({ open: true });
        };
        this.handleClose = () => {
            this.safeSetState({ open: false });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClickOpen, sx: Object.assign({ padding: 0, marginY: 'auto', marginRight: -0.25, marginLeft: 0 }, this.props.sx), onMouseOver: () => this.safeSetState({ hovered: true }), onMouseOut: () => this.safeSetState({ hovered: false }) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.InfoOutlined, { sx: { width: '14px', height: '14px', color: this.state.hovered || this.state.open ? 'primary.light' : 'text.disabled' } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: 1, // this is 0.5 counteracting the DialogTitle padding and 0.5 aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { marginY: 'auto', marginX: 0.5, paddingLeft: 1 } }, this.props.title)),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: 0.25,
                                margin: 0.5,
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: 0.25,
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            padding: 1,
                            fontSize: 'var(--jp-ui-font-size1)',
                        } }, this.props.popup)));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            hovered: false,
            open: false,
        };
    }
}


/***/ }),

/***/ "./lib/core/IntentSlider.js":
/*!**********************************!*\
  !*** ./lib/core/IntentSlider.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntentSlider": () => (/* binding */ IntentSlider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





let retrievingPreview = false;
let updatePreviewAgain = false;
let latestValue;
const icons = [
    react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { viewBox: '0 0 24 24', style: { width: '1.5rem', height: '1.5rem', fill: 'var(--jp-layout-color2)' } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: 'M6.05 8.05c-2.73 2.73-2.73 7.15-.02 9.88 1.47-3.4 4.09-6.24 7.36-7.93-2.77 2.34-4.71 5.61-5.39 9.32 2.6 1.23 5.8.78 7.95-1.37C19.43 14.47 20 4 20 4S9.53 4.57 6.05 8.05z' })),
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Equalizer, { sx: { fill: 'var(--jp-layout-color2)' } }),
    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.FlashOn, { sx: { fill: 'var(--jp-layout-color2)' } })
];
class IntentSlider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledSlider = () => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    height: '16px',
                    width: 'calc(100% - 42px)',
                    padding: '13px 0px',
                    margin: '0px 21px'
                },
                thumb: {
                    position: 'relative',
                    transform: 'none',
                    height: '42px',
                    width: '42px',
                    margin: '-13px -21px',
                    transition: 'none',
                    backgroundColor: this.props.color,
                    zIndex: 2,
                    // '&$focusVisible,&:hover': {
                    //     boxShadow: 'none',
                    // },
                    '&$active': {
                        boxShadow: 'none',
                    },
                    '&::before': {
                        boxShadow: 'none',
                    },
                    '&:hover': {
                        boxShadow: 'none',
                    },
                },
                thumbColorPrimary: {
                    // '&$focusVisible,&:hover': {
                    //     boxShadow: 'none',
                    // },
                    '&$active': {
                        boxShadow: 'none',
                    },
                },
                active: {
                    boxShadow: 'none',
                },
                track: {
                    height: '16px',
                    color: this.props.color,
                    opacity: 0,
                    boxSizing: 'border-box',
                    borderRadius: '8px',
                },
                rail: {
                    height: '16px',
                    width: '100%',
                    opacity: 0,
                    boxSizing: 'border-box',
                    borderRadius: '8px',
                },
                mark: {
                    opacity: 0,
                },
                markActive: {
                    opacity: 0,
                },
                markLabel: {},
                markLabelActive: {},
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Slider);
        };
        this.handleChange = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                this.safeSetState({ value: newValue / 100 });
                this.slowDownSaveValue(newValue / 100);
            }
        };
        this.handleChangeCommitted = async (event, newValue) => {
            if (newValue instanceof Array) {
                // This is invalid
            }
            else {
                this.safeSetState({ value: newValue / 100 });
                this.props.saveValue(newValue / 100);
            }
        };
        this.delay = (ms) => { return new Promise(resolve => setTimeout(resolve, ms)); };
        this.slowDownSaveValue = (newValue, bypassLimiter) => {
            if (newValue != null)
                latestValue = newValue;
            if (bypassLimiter || !retrievingPreview) {
                retrievingPreview = true;
                this.delay(100).then(() => {
                    this.props.saveValue(latestValue);
                    if (updatePreviewAgain) {
                        updatePreviewAgain = false;
                        this.slowDownSaveValue(null, true);
                    }
                    else {
                        retrievingPreview = false;
                    }
                }, () => {
                    retrievingPreview = false;
                });
            }
            else {
                updatePreviewAgain = true;
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const icon = this.state.value < 0.33 ? 0 : this.state.value < 0.66 ? 1 : 2;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: this.props.sx },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { position: 'relative', margin: '3px 6px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSlider
                    // sx={{position: 'relative'}}
                    , { 
                        // sx={{position: 'relative'}}
                        onChange: this.handleChange, onChangeCommitted: this.handleChangeCommitted, min: 0, max: 100, value: this.state.value * 100, components: {
                            Thumb: (props) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.SliderThumb, Object.assign({ sx: Object.assign({ top: 'unset', left: this.state.value + '%' }, props.sx) }, props),
                                props.children,
                                icons[icon]))
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            position: 'absolute',
                            top: 'calc(50% - 8px)',
                            left: '0px',
                            width: '100%',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '16px',
                            borderRadius: '8px',
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            position: 'absolute',
                            zIndex: 1,
                            top: 'calc(50% - 8px)',
                            left: '12px',
                            color: 'var(--jp-ui-font-color1)',
                            fontSize: '11px',
                            opacity: this.state.value < 0.22 ? 0 : 1,
                            transition: 'opacity 250ms ease 0s',
                            fontStyle: 'italic',
                            height: '0px', overflow: 'visible', pointerEvents: 'none' // Pass click events to the slider behind
                        } }, 'cheaper'),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            position: 'absolute',
                            zIndex: 1,
                            top: 'calc(50% - 8px)',
                            right: '12px',
                            color: 'var(--jp-ui-font-color1)',
                            fontSize: '11px',
                            opacity: this.state.value > 0.82 ? 0 : 1,
                            transition: 'opacity 250ms ease 0s',
                            fontStyle: 'italic',
                            height: '0px', overflow: 'visible', pointerEvents: 'none' // Pass click events to the slider behind    
                        } }, 'faster'))));
        };
        this.handleMetadataChange = () => this.safeSetState({ value: this.props.getValue(), weGotADot: '' });
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.StyledSlider = this.getStyledSlider();
        this.state = {
            value: this.props.getValue(),
        };
    }
}


/***/ }),

/***/ "./lib/core/Label.js":
/*!***************************!*\
  !*** ./lib/core/Label.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Label": () => (/* binding */ Label)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


class Label extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: Object.assign({ display: 'inline-flex', width: '100%', padding: '3px 0px', position: 'relative' }, this.props.sx) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: this.props.lineHeight || '24px',
                        margin: '0px 12px',
                        lineHeight: this.props.lineHeight || '24px',
                        textAlign: this.props.align || 'center',
                        whiteSpace: 'pre',
                    } },
                    this.props.label,
                    this.props.info),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: {
                        width: '100%',
                        height: this.props.lineHeight || '24px',
                        margin: '0px 6px',
                        lineHeight: this.props.lineHeight || '24px',
                        textAlign: this.props.valueAlign || 'left',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { padding: '0px 6px', fontSize: '12px' } }, this.props.styledUnitValue(this.props.getValue()))),
                this.props.infoRight && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { position: 'absolute', right: '-6px' } }, this.props.infoRight))));
        };
        // public shouldComponentUpdate = (nextProps: IProps<any>, nextState: IState<any>): boolean => {
        //     try {
        //         if (JSON.stringify(this.props) != JSON.stringify(nextProps)) return true;
        //         if (JSON.stringify(this.state) != JSON.stringify(nextState)) return true;
        //         if (Global.shouldLogOnRender) console.log('SuppressedRender (' + new Date().getSeconds() + ')');
        //         return false;
        //     } catch (error) {
        //         return true;
        //     }
        // }
    }
}
Label.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};


/***/ }),

/***/ "./lib/core/Markdown.js":
/*!******************************!*\
  !*** ./lib/core/Markdown.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Markdown": () => (/* binding */ Markdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/rendermime */ "webpack/sharing/consume/default/@jupyterlab/rendermime");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/codemirror */ "webpack/sharing/consume/default/@jupyterlab/codemirror");
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var marked__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! marked */ "webpack/sharing/consume/default/marked/marked");
/* harmony import */ var marked__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(marked__WEBPACK_IMPORTED_MODULE_4__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class Markdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            // Separate math from normal markdown text.
            const parts = _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.removeMath(this.props.text);
            // Convert the markdown to HTML.
            let html = renderMarked(parts['text']);
            // Replace math.
            html = _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.replaceMath(html, parts['math']);
            if (_Global__WEBPACK_IMPORTED_MODULE_5__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_5__.DIV, { sx: Object.assign({}, this.props.sx), dangerouslySetInnerHTML: { __html: _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.defaultSanitizer.sanitize(html) } }));
        };
    }
}
/// The functions below were taken from https://github.com/jupyterlab/jupyterlab/blob/b05c2748c021a8da681315fd0a6bcaee01e96d6b/packages/rendermime/src/renderers.ts
let markedInitialized = false;
/**
 * Support GitHub flavored Markdown, leave sanitizing to external library.
 */
function initializeMarked() {
    if (markedInitialized) {
        return;
    }
    markedInitialized = true;
    marked__WEBPACK_IMPORTED_MODULE_4___default().setOptions({
        gfm: true,
        sanitize: false,
        // breaks: true; We can't use GFM breaks as it causes problems with tables
        langPrefix: `cm-s-${_jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2__.CodeMirrorEditor.defaultConfig.theme} language-`,
        highlight: (code, lang, callback) => {
            const cb = (err, code) => {
                if (callback) {
                    callback(err, code);
                }
                return code;
            };
            if (!lang) {
                // no language, no highlight
                return cb(null, code);
            }
            _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2__.Mode.ensure(lang)
                .then(spec => {
                const el = document.createElement('div');
                if (!spec) {
                    console.error(`No CodeMirror mode: ${lang}`);
                    return cb(null, code);
                }
                try {
                    _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_2__.Mode.run(code, spec.mime, el);
                    return cb(null, el.innerHTML);
                }
                catch (err) {
                    console.error(`Failed to highlight ${lang} code`, err);
                    return cb(err, code);
                }
            })
                .catch(err => {
                console.error(`No CodeMirror mode: ${lang}`);
                console.error(`Require CodeMirror mode error: ${err}`);
                return cb(null, code);
            });
            return code;
        }
    });
}
/**
   * Render markdown for the specified content.
   *
   * @param content - The string of markdown to render.
   *
   * @return A promise which resolves with the rendered content.
   */
function renderMarked(content) {
    initializeMarked();
    return marked__WEBPACK_IMPORTED_MODULE_4___default()(content);
}


/***/ }),

/***/ "./lib/core/NotificationContent.js":
/*!*****************************************!*\
  !*** ./lib/core/NotificationContent.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationContent": () => (/* binding */ NotificationContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! . */ "./lib/core/Switch.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! . */ "./lib/core/Dropdown.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const LABEL_WIDTH = '80px';
const VALUES = [{ value: 'succeeds or fails', description: '' }, { value: 'fails', description: '' }];
class NotificationContent extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // private handleNotebookOptimizedSMSChange = (value: boolean) => {
        //     const config = this.props.getValue().copy()
        //     config.notifications.packageReadySMSEnabled = value;
        //     this.props.saveValue(config);
        // }
        this.handleJobStartedSMSChange = (value) => {
            const config = this.props.getValue().copy();
            config.notifications.jobStartedSMSEnabled = value;
            this.props.saveValue(config);
        };
        this.handleChange = (value, enabled) => {
            const config = this.props.getValue().copy();
            config.notifications.jobCompletedSMSEnabled = value == VALUES[0].value && enabled;
            config.notifications.jobFailedSMSEnabled = enabled;
            this.props.saveValue(config);
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const disabled = !_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.notificationsEnabled || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber == null || _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.phoneNumber == "";
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_4__.Switch, { getValue: () => (disabled && !this.props.disabled) ? false : this.props.getValue().notifications.jobStartedSMSEnabled, saveValue: this.handleJobStartedSMSChange, label: 'Send a text when my job starts', labelWidth: LABEL_WIDTH, disabled: disabled || this.props.disabled || this.props.disabled }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'inline-flex' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_4__.Switch, { getValue: () => (disabled && !this.props.disabled) ? false : this.props.getValue().notifications.jobFailedSMSEnabled, saveValue: (enabled) => this.handleChange(this.state.value, enabled), label: 'Send a text when my job ', labelWidth: LABEL_WIDTH, disabled: disabled || this.props.disabled }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_5__.Dropdown, { getValue: () => this.state.value, saveValue: (value) => {
                            this.safeSetState({ value: value });
                            this.handleChange(value, this.props.getValue().notifications.jobFailedSMSEnabled);
                        }, values: VALUES, disabled: disabled || this.props.disabled, 
                        // Wipe out the width being set internally in Dropdown
                        sx: { width: 'unset', marginLeft: '-6px' } })),
                (disabled && !this.props.disabled) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'inline-flex', width: 'calc(100% - 72px)', margin: '12px 36px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: 'auto 0px', fontStyle: 'italic' } }, "Notifications can be enabled in settings"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.followLink(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.Target.SettingsPopup.PreferencesTab);
                            if (this.props.handleClose)
                                this.props.handleClose();
                        }, sx: {
                            display: 'inline-block',
                            width: '36px',
                            height: '36px',
                            padding: '3px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { sx: { height: '20px', width: '20px' } })))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        const value = this.props.getValue();
        this.state = {
            value: !value.notifications.jobFailedSMSEnabled || (value.notifications.jobFailedSMSEnabled && value.notifications.jobCompletedSMSEnabled) ? VALUES[0].value : VALUES[1].value,
        };
    }
}


/***/ }),

/***/ "./lib/core/PhoneTextBox.js":
/*!**********************************!*\
  !*** ./lib/core/PhoneTextBox.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PhoneTextBox": () => (/* binding */ PhoneTextBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-phone-input-2 */ "webpack/sharing/consume/default/react-phone-input-2/react-phone-input-2");
/* harmony import */ var react_phone_input_2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_phone_input_2__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_phone_input_2_lib_style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-phone-input-2/lib/style.css */ "./node_modules/react-phone-input-2/lib/style.css");
/* harmony import */ var google_libphonenumber__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! google-libphonenumber */ "webpack/sharing/consume/default/google-libphonenumber/google-libphonenumber");
/* harmony import */ var google_libphonenumber__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(google_libphonenumber__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/


// import ExtraInfo from '../utils/ExtraInfo';



class PhoneTextBox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // This turns the textbox red if it is not a valid value determined by the unstyle function
        this.handleChange = async (value, data, event, formattedValue) => {
            this.safeSetState({ value: value, invalidTextMessage: '' });
        };
        // Saves value if it is a valid value
        this.saveChanges = () => {
            var value = this.state.value;
            var invalid = false;
            if (value == "" || value == "1") {
                this.props.saveValue("");
            }
            else {
                try {
                    const phoneUtil = google_libphonenumber__WEBPACK_IMPORTED_MODULE_3___default().PhoneNumberUtil.getInstance();
                    if (phoneUtil.isValidNumber(phoneUtil.parse('+' + value, 'US'))) {
                        this.safeSetState({ editing: false, value: value });
                        this.props.saveValue('+' + value);
                    }
                    else {
                        invalid = true;
                    }
                }
                catch (err) {
                    invalid = true;
                }
            }
            if (invalid) {
                this.safeSetState({ invalidTextMessage: 'Invalid phone number' });
            }
            if (this.props.validOnBlur) {
                this.props.validOnBlur(!invalid);
            }
        };
        this.handleFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            if (this.state.value == '')
                this.setState({ value: '1' });
            this.saveChanges();
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ display: 'inline-flex', width: '100%', padding: '6px 0px' }, this.props.sx) },
                this.props.label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        display: 'flex',
                        position: 'relative',
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        // textAlign: 'center',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { display: 'inline', width: '100%', color: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? 'var(--jp-ui-font-color3)' : 'var(--jp-ui-font-color1)' } }, this.props.label))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement((react_phone_input_2__WEBPACK_IMPORTED_MODULE_1___default()), { disabled: this.props.disabled, value: '+' + this.state.value, country: 'us', onChange: this.handleChange, preferredCountries: ['us'], containerStyle: { margin: 'auto 0px auto 6px' }, inputStyle: { height: '20.25px', width: '100%', background: 'var(--jp-layout-color1)', color: 'var(--jp-ui-font-color0)' }, buttonStyle: { height: '20.25px', background: 'var(--jp-layout-color1)', color: 'var(--jp-ui-font-color0)' }, dropdownStyle: { background: 'var(--jp-layout-color1)', color: 'var(--jp-ui-font-color0)' }, searchStyle: { background: 'var(--jp-layout-color1)', color: 'var(--jp-ui-font-color0)' }, onFocus: this.handleFocus, onBlur: this.handleBlur, isValid: this.state.invalidTextMessage == '' })));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        const value = this.props.getValue().replace('+', '');
        this.state = {
            value: value == '' ? '1' : value,
            invalidTextMessage: '',
            editing: false,
            hovered: false,
            hidePassword: true,
        };
    }
}


/***/ }),

/***/ "./lib/core/PlansPopup.js":
/*!********************************!*\
  !*** ./lib/core/PlansPopup.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PlansPopup": () => (/* binding */ PlansPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! . */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _components_EgressBuckets__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../components/EgressBuckets */ "./lib/components/EgressBuckets.js");
/* harmony import */ var _components_StorageBuckets__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/StorageBuckets */ "./lib/components/StorageBuckets.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _SubscribeButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/











const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
    paper: {
        width: 'calc(min(80%, 600px + 150px + 2px))',
        // width: '100%',
        // height: '80%',
        overflowY: 'visible',
        maxWidth: 'inherit',
    },
})(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class PlansPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                this.props.openButton,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.props.open, onClose: this.props.handleClose, scroll: 'paper' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            display: 'inline-flex',
                            height: '60px',
                            padding: '6px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                display: 'inline-flex',
                                minWidth: '225px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: 'auto 6px', paddingLeft: '12px' } }, "Plans")),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: 1 } }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: this.props.handleClose, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(___WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            padding: '12px',
                            fontSize: 'var(--jp-ui-font-size1)',
                            overflow: 'auto',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { padding: '12px' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto', fontSize: '24px', fontWeight: 'bold' } }, "Pricing"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto' } },
                                "Our Starter tier charges $",
                                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.serviceFee.toFixed(2),
                                "/hour when one or more machines (used for sessions and jobs) are running. Machines are charged separately and you only pay for what you use. We pass through machine costs as billed by our cloud providers, including any promotional pricing."),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: '100%', display: 'inline-flex', justifyContent: 'center' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                        textAlign: 'center',
                                        padding: '12px',
                                        margin: '12px',
                                        border: '1px solid ' + _Colors__WEBPACK_IMPORTED_MODULE_6__.Colors.SECONDARY,
                                        borderRadius: '6px',
                                        width: 'fit-content'
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto', fontSize: '24px', fontWeight: 'bold' } }, "Starter"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { color: _Colors__WEBPACK_IMPORTED_MODULE_6__.Colors.PRIMARY, fontSize: '20px', fontWeight: 'bold' } },
                                        "$",
                                        _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.serviceFee.toFixed(2),
                                        "/hour"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.maxJobs + ' parallel jobs/sessions'),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, null, 'SMS notifications'),
                                    _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.isSubscribed() ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { sx: { margin: '12px', width: '150px' }, variant: 'contained', color: 'primary', disabled: true }, "Subscribed")) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SubscribeButton__WEBPACK_IMPORTED_MODULE_7__.SubscribeButton, { sx: { width: '150px', margin: '12px' } }))),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                                        textAlign: 'center',
                                        padding: '12px',
                                        margin: '12px',
                                        border: '1px solid ' + _Colors__WEBPACK_IMPORTED_MODULE_6__.Colors.SECONDARY,
                                        borderRadius: '6px',
                                        width: 'fit-content',
                                        display: 'flex',
                                        flexDirection: 'column',
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto', fontSize: '24px', fontWeight: 'bold' } }, "Pro"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { color: _Colors__WEBPACK_IMPORTED_MODULE_6__.Colors.PRIMARY, fontSize: '20px', fontWeight: 'bold' } }, "Coming soon"),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { flexGrow: '1' } }),
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { sx: { margin: '12px', width: '150px' }, variant: 'contained', color: 'primary', onClick: () => window.open('https://02y48lsf4ft.typeform.com/to/EbE8axZj', '_blank') }, "Contact us"))),
                            this.props.buttons && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { display: 'inline-flex', width: '100%', justifyContent: 'center' } }, this.props.buttons)),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto', fontSize: '24px', fontWeight: 'bold' } }, "Dynamic upgrades"),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '6px auto 18px auto' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: '6px' } },
                                    "If enabled, storage and egress tiers will be automatically upgraded as you consume more of each resource. For example, if in a given billing period you use ",
                                    _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_8__["default"].styleCapacityUnitValue()((_Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[1].limit + _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[2].limit) / 2),
                                    " of storage, you will be charged $",
                                    _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets[2].cost,
                                    "."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: '6px' } }, "If disabled, you will not be able to consume more than the storage and egress limits included in your current tier."),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { margin: '6px' } }, "At the beginning of every billing cycle you will start off in the lowest possible tier based on your usage.")),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_StorageBuckets__WEBPACK_IMPORTED_MODULE_9__.StorageBuckets, { buckets: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.storageBuckets }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_EgressBuckets__WEBPACK_IMPORTED_MODULE_10__.EgressBuckets, { buckets: _Global__WEBPACK_IMPORTED_MODULE_4__.Global.user.egressBuckets }),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: 'fit-content', margin: '18px auto 6px auto', fontSize: '10px' } },
                                "Unit prefixes (such as '2 GB') should be interpreted as binary units ('2 GiB') as further explained",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: 'https://en.wikipedia.org/wiki/Gigabyte', target: '_blank', style: { marginLeft: '3px', color: 'var(--jp-ui-font-color0)', textDecoration: 'underline' } }, "here"))))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/Popper.js":
/*!****************************!*\
  !*** ./lib/core/Popper.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Popper": () => (/* binding */ Popper)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class Popper extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.stopPropagation = false;
        this.handleClick = (event) => {
            if (this.props.button.props.onClick)
                this.props.button.props.onClick();
            if (this.stopPropagation) {
                this.stopPropagation = false;
                return;
            }
            if (this.props.onOpen)
                this.props.onOpen();
            this.safeSetState({ open: true, anchorEl: event.currentTarget });
        };
        this.handleClose = () => {
            if (this.props.onClose)
                this.props.onClose();
            this.safeSetState({ open: false, anchorEl: null });
        };
        this.handleStopPropagation = () => {
            this.stopPropagation = true;
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(this.props.button, { onClick: this.handleClick }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Popover, { sx: { top: (theme) => theme.spacing(0.5) }, open: this.state.open, anchorEl: this.state.anchorEl, onClose: this.handleClose, anchorOrigin: {
                        vertical: 'bottom',
                        horizontal: 'left',
                    }, transformOrigin: {
                        vertical: 'top',
                        horizontal: 'left',
                    }, PaperProps: {
                        style: {
                            border: this.props.color ? 'solid 1px ' + this.props.color : undefined
                        }
                    } }, react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(this.props.popup, { sx: Object.assign({ minWidth: 'var(--jp-sidebar-min-width)' }, this.props.popup.props.sx) }))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        if (props.close)
            props.close(this.handleClose);
        if (props.stopPropagation)
            props.stopPropagation(this.handleStopPropagation);
        this.state = {
            open: false,
            anchorEl: null,
        };
    }
}


/***/ }),

/***/ "./lib/core/ResourceGraph.js":
/*!***********************************!*\
  !*** ./lib/core/ResourceGraph.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ResourceGraph": () => (/* binding */ ResourceGraph)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/* harmony import */ var react_plotly_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-plotly.js */ "webpack/sharing/consume/default/react-plotly.js/react-plotly.js");
/* harmony import */ var react_plotly_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_plotly_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/* harmony import */ var _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class ResourceGraph extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.updateCellTimes = (state) => {
            if (!this.props.app.interactive && this.props.app.programType == _models_OptumiConfig__WEBPACK_IMPORTED_MODULE_2__.ProgramType.PYTHON_NOTEBOOK) {
                state.cell_starts.splice(0, state.cell_starts.length);
                state.cell_ends.splice(0, state.cell_ends.length);
                for (let cell of this.props.app.program['cells']) {
                    if (cell.cell_type === 'code') {
                        const metadata = cell['metadata'];
                        if (metadata) {
                            const papermill = metadata['papermill'];
                            if (papermill) {
                                if (papermill['start_time']) {
                                    state.cell_starts.push(new Date(papermill['start_time'] + 'Z'));
                                }
                                if (papermill['end_time']) {
                                    state.cell_ends.push(new Date(papermill['end_time'] + 'Z'));
                                }
                            }
                        }
                    }
                }
            }
            this.updateLayout(state);
            this.updateCellTraces(state);
        };
        this.updateResources = (state, update, skipUpdateCellTimes) => {
            const sampleString = update.line;
            if (sampleString.length === 0)
                return;
            let sample = sampleString.split('|');
            const time = new Date(update.modifier);
            for (let i = 0; i < 21; i++) {
                state.data[i].x.push(time);
                state.data[i].y.push(+sample[20 - i]);
            }
            if (state.xAxisAuto) {
                state.xAxisMin = state.data[0].x[0];
                state.xAxisMax = state.data[0].x[state.data[0].x.length - 1];
            }
            if (skipUpdateCellTimes !== true)
                this.updateCellTimes(state);
        };
        this.updateCellTraces = (state) => {
            const x = [];
            const y1 = [];
            const y2 = [];
            const text1 = [];
            const text2 = [];
            const xAxisMin = new Date(state.xAxisMin);
            const xAxisMax = new Date(state.xAxisMax);
            const totalDuration = xAxisMax.getTime() - xAxisMin.getTime();
            for (let i = 0; i < state.cell_starts.length; i++) {
                if (state.cell_ends.length > i) {
                    var cell_start = new Date(state.cell_starts[i]);
                    var cell_end = new Date(state.cell_ends[i]);
                    const duration = cell_end.getTime() - cell_start.getTime();
                    x.push(new Date(cell_start.getTime() + (duration / 2)));
                    y1.push(95);
                    y2.push(90);
                    if (cell_start.getTime() < xAxisMax.getTime() && cell_end.getTime() > xAxisMin.getTime()) {
                        if (duration / totalDuration > 0.05) {
                            text1.push('Cell ' + (i + 1));
                            text2.push(_utils_FormatUtils__WEBPACK_IMPORTED_MODULE_3__["default"].msToTime(duration));
                        }
                        else {
                            text1.push('');
                            text2.push('');
                        }
                    }
                    else {
                        text1.push('');
                        text2.push('');
                    }
                }
            }
            ;
            state.data.splice(-2, 2);
            state.data = state.data.concat([{ x: x, y: y1, text: text1, mode: 'text', textposition: 'middle center', name: 'CELLS', legendgroup: 'CELLS', hoverinfo: 'none' }, { x: x, y: y2, text: text2, mode: 'text', textposition: 'middle center', legendgroup: 'CELLS', showlegend: false, hoverinfo: 'none' }]);
        };
        this.updateLayout = (state) => {
            const shapes = state.showCells ?
                state.cell_ends.map((x, i) => ({
                    type: 'rect',
                    x0: state.cell_starts[i],
                    y0: 0,
                    x1: x,
                    y1: 100,
                    line: {
                        color: 'rgba(0, 0, 0, 0.5)',
                        width: 1,
                    },
                })) : [];
            state.layout = {
                shapes: shapes,
                xaxis: {
                    title: 'Time',
                    range: [state.xAxisMin, state.xAxisMax]
                },
                yaxis: {
                    title: 'Resource Utilization (%)',
                    range: [0, 100],
                    fixedrange: true,
                },
                legend: {
                    traceorder: 'reversed',
                },
            };
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement((react_plotly_js__WEBPACK_IMPORTED_MODULE_1___default()), { divId: this.props.app.uuid + '-graph', style: { width: '100%', height: '100%' }, key: this.props.app.uuid + '-graph', data: this.state.data, layout: this.state.layout, config: this.state.config, onInitialized: (figure, graphDiv) => this.setState({ data: figure.data, layout: figure.layout }), onUpdate: (figure, graphDiv) => this.setState({ data: figure.data, layout: figure.layout }), onRestyle: (event) => {
                    for (let i = 0; i < event[1].length; i++) {
                        if (event[1][i] == 21) {
                            const newState = this.cloneState(this.state);
                            newState.showCells = event[0].visible[i] === true;
                            this.updateLayout(newState);
                            newState.revision++;
                            this.safeSetState(newState);
                            break;
                        }
                    }
                }, onRelayout: (event) => {
                    if (event['xaxis.autorange']) {
                        const newState = this.cloneState(this.state);
                        newState.xAxisAuto = true;
                        newState.xAxisMin = newState.data[0].x[0];
                        newState.xAxisMax = newState.data[0].x[newState.data[0].x.length - 1];
                        this.updateLayout(newState);
                        this.updateCellTraces(newState);
                        newState.revision++;
                        this.safeSetState(newState);
                    }
                    else if (event['xaxis.range[0]'] || event['xaxis.range[1]']) {
                        const newState = this.cloneState(this.state);
                        newState.xAxisAuto = false;
                        newState.xAxisMin = new Date(event['xaxis.range[0]']);
                        newState.xAxisMax = new Date(event['xaxis.range[1]']);
                        this.updateLayout(newState);
                        this.updateCellTraces(newState);
                        newState.revision++;
                        this.safeSetState(newState);
                    }
                } }));
        };
        // public shouldComponentUpdate = (nextProps: IProps, nextState: IState): boolean => {
        //     try {
        //         if (JSON.stringify(this.props) != JSON.stringify(nextProps)) return true;
        //         if (JSON.stringify(this.state) != JSON.stringify(nextState)) return true;
        //         if (Global.shouldLogOnRender) console.log('SuppressedRender (' + new Date().getSeconds() + ')');
        //         return false;
        //     } catch (error) {
        //         return true;
        //     }
        // }
        this.safeSetState = (map) => {
            if (this._isMounted) {
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                    console.log('SafeSetState (' + new Date().getSeconds() + ')');
                this.setState(map);
            }
        };
        this.handleResourceChange = (update) => {
            const newState = this.cloneState(this.state);
            this.updateResources(newState, update);
            newState.revision++;
            this.safeSetState(newState);
        };
        // We need this to clone the state including dates
        this.cloneState = (state) => {
            const newState = JSON.parse(JSON.stringify(state));
            for (let data of newState.data) {
                data.x = data.x.map((x) => new Date(x));
            }
            newState.cell_starts = newState.cell_starts.map((x) => new Date(x));
            newState.cell_ends = newState.cell_ends.map((x) => new Date(x));
            newState.xAxisMin = new Date(newState.xAxisMin);
            newState.xAxisMax = new Date(newState.xAxisMax);
            return newState;
        };
        this.componentDidMount = () => {
            this._isMounted = true;
            let newState = {
                data: [
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'NET max', hoverinfo: 'none', legendgroup: 'NET', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.NETWORK }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.NETWORK + '60', name: 'NET', legendgroup: 'NET' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.NETWORK + '60', name: 'NET min', hoverinfo: 'none', legendgroup: 'NET', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'DISK max', hoverinfo: 'none', legendgroup: 'DISK', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.DISK }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.DISK + '60', name: 'DISK', legendgroup: 'DISK' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.DISK + '60', name: 'DISK min', hoverinfo: 'none', legendgroup: 'DISK', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'SWAP max', hoverinfo: 'none', legendgroup: 'SWAP', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.SWAP }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.SWAP + '60', name: 'SWAP', legendgroup: 'SWAP' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.SWAP + '60', name: 'SWAP min', hoverinfo: 'none', legendgroup: 'SWAP', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'RAM max', hoverinfo: 'none', legendgroup: 'RAM', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.RAM }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.RAM + '60', name: 'RAM', legendgroup: 'RAM' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.RAM + '60', name: 'RAM min', hoverinfo: 'none', legendgroup: 'RAM', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'CPU max', hoverinfo: 'none', legendgroup: 'CPU', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CPU }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CPU + '60', name: 'CPU', legendgroup: 'CPU' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.CPU + '60', name: 'CPU min', hoverinfo: 'none', legendgroup: 'CPU', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'VRAM max', hoverinfo: 'none', legendgroup: 'VRAM', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.VRAM }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.VRAM + '60', name: 'VRAM', legendgroup: 'VRAM' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.VRAM + '60', name: 'VRAM min', hoverinfo: 'none', legendgroup: 'VRAM', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, name: 'GPU max', hoverinfo: 'none', legendgroup: 'GPU', showlegend: false },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', color: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.GPU }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.GPU + '60', name: 'GPU', legendgroup: 'GPU' },
                    { x: [], y: [], mode: 'lines', type: 'scatter', line: { shape: 'spline', width: 0 }, fill: 'tonexty', fillcolor: _Colors__WEBPACK_IMPORTED_MODULE_5__.Colors.GPU + '60', name: 'GPU min', hoverinfo: 'none', legendgroup: 'GPU', showlegend: false },
                    { /* This empty entry is needed */},
                    { /* This empty entry is needed */},
                ],
                layout: {},
                config: {
                    toImageButtonOptions: {
                        filename: this.props.app.uuid,
                        format: 'png',
                        height: 1000,
                        width: 3000,
                    },
                    responsive: true,
                    displaylogo: false,
                    modeBarButtonsToRemove: [
                        'lasso2d',
                        'select2d',
                        'resetScale2d',
                        'toggleSpikelines',
                        'hoverClosestCartesian',
                        'hoverCompareCartesian',
                    ]
                },
                cell_starts: [],
                cell_ends: [],
                showCells: true,
                xAxisAuto: true,
            };
            // const numSamples = this.props.app.modules[0].monitoring.length;
            // const jump = Math.ceil(numSamples / 500);
            // for (let i = 0; i < (numSamples-jump); i+=jump) {
            //     const sample = this.props.app.modules[0].monitoring[i]
            //     this.updateResources(newState, sample, true)
            // }
            for (let sample of this.props.app.modules[0].monitoring) {
                this.updateResources(newState, sample, true);
            }
            this.updateCellTimes(newState);
            newState.xAxisMin = newState.data[0].x[0];
            newState.xAxisMax = newState.data[0].x[newState.data[0].x.length - 1];
            this.safeSetState(newState);
            this.props.app.modules[0].addUpdateCallback(this.handleResourceChange);
        };
        this.componentWillUnmount = () => {
            this.props.app.modules[0].removeUpdateCallback(this.handleResourceChange);
            this._isMounted = false;
        };
        this.state = {
            revision: 0,
            cell_starts: [],
            cell_ends: [],
            showCells: true,
            data: [],
            layout: {},
            config: {},
            xAxisAuto: true,
            xAxisMin: null,
            xAxisMax: null,
        };
    }
}


/***/ }),

/***/ "./lib/core/ShadowedDivider.js":
/*!*************************************!*\
  !*** ./lib/core/ShadowedDivider.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ShadowedDivider": () => (/* binding */ ShadowedDivider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class ShadowedDivider extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const darkColor = this.isLightMode ? '#bbbbbb' : 'rgba(255, 255, 255, 0.18)';
            const lightColor = this.isLightMode ? (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.lighten)(darkColor, 2 / 3) : 'rgba(255, 255, 255, 0.12)';
            return this.props.orientation === undefined || this.props.orientation === 'horizontal' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'fullWidth', sx: { backgroundColor: darkColor } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { variant: 'fullWidth', sx: { backgroundColor: lightColor } }))) : this.props.orientation === 'vertical' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: { display: 'flex', height: '100%' } },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { orientation: 'vertical', variant: 'fullWidth', sx: { backgroundColor: darkColor } }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Divider, { orientation: 'vertical', variant: 'fullWidth', sx: { backgroundColor: lightColor } })));
        };
        this.handleThemeChange = () => { this.isLightMode = _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager == undefined || _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.isLight(_Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.theme); this.forceUpdate(); };
        this.componentDidMount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_2__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
        };
    }
}


/***/ }),

/***/ "./lib/core/SubscribeButton.js":
/*!*************************************!*\
  !*** ./lib/core/SubscribeButton.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SubscribeButton": () => (/* binding */ SubscribeButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @stripe/stripe-js */ "webpack/sharing/consume/default/@stripe/stripe-js/@stripe/stripe-js");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_3__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





const stripePromise = (0,_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_3__.loadStripe)(_Global__WEBPACK_IMPORTED_MODULE_4__.Global.stripe_key);
class SubscribeButton extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.handleCheckoutClick = async () => {
            if (this.props.onClick)
                this.props.onClick();
            // Get Stripe.js instance    
            // Call your backend to create the Checkout Session
            this.safeSetState({ checkoutWaiting: true });
            const stripe = await stripePromise;
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/create-checkout";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    items: [],
                    redirect: settings.baseUrl,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_4__.Global.handleResponse(response);
                return response.json();
            }).then((body) => {
                // When the customer clicks on the button, redirect them to Checkout.
                return stripe.redirectToCheckout({
                    sessionId: body.id,
                });
            }).then((result) => {
                this.safeSetState({ checkoutWaiting: false });
                if (result.error) {
                    // If `redirectToCheckout` fails due to a browser or network
                    // error, display the localized error message to your customer
                    // using `result.error.message`.
                }
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            if (this.props.variant == 'whiteOutlined') {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disabled: this.state.checkoutWaiting, variant: 'outlined', sx: Object.assign(this.props.sx || {}, { color: 'white', borderColor: 'white' }), onClick: this.handleCheckoutClick, disableElevation: this.props.disableElevation || false }, this.state.checkoutWaiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '1.75em' })) : (this.props.text || 'Subscribe')));
            }
            else if (this.props.variant == 'whiteText') {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.WhiteTextButton, { disabled: this.state.checkoutWaiting, sx: this.props.sx, onClick: this.handleCheckoutClick, disableElevation: this.props.disableElevation || false }, this.state.checkoutWaiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '1.75em', sx: { color: 'white' } })) : (this.props.text || 'Subscribe')));
            }
            else if (this.props.variant == 'skinny') {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SkinnyButton, { disabled: this.state.checkoutWaiting, color: "primary", variant: "contained", sx: this.props.sx, onClick: this.handleCheckoutClick, disableElevation: this.props.disableElevation || false }, this.state.checkoutWaiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '14px', thickness: 8 })) : (this.props.text || 'Subscribe')));
            }
            else {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disabled: this.state.checkoutWaiting, color: this.props.color || "primary", variant: this.props.variant || "contained", sx: this.props.sx, onClick: this.handleCheckoutClick, disableElevation: this.props.disableElevation || false }, this.state.checkoutWaiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: '1.75em' })) : (this.props.text || 'Subscribe')));
            }
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.state = {
            checkoutWaiting: false
        };
    }
}


/***/ }),

/***/ "./lib/core/SubscribePopup.js":
/*!************************************!*\
  !*** ./lib/core/SubscribePopup.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SubscribePopup)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _SubscribeButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SubscribeButton */ "./lib/core/SubscribeButton.js");
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Header */ "./lib/core/Header.js");
/* harmony import */ var _CustomerState__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CustomerState */ "./lib/core/CustomerState.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/








class SubscribePopup extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        // Log out of the REST interface (Copied from SettingsPage aside from setState call)
        this.logout = () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/logout";
            const init = {
                method: 'GET',
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user = null;
            });
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.PermanentPopup, { open: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.customerState == _CustomerState__WEBPACK_IMPORTED_MODULE_4__.CustomerState.INIT },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { sx: {
                        display: 'inline-flex',
                        height: '60px',
                        padding: '6px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            display: 'inline-flex',
                            minWidth: '150px',
                            fontSize: '16px',
                            fontWeight: 'bold',
                            paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                        } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Welcome to Optumi! \uD83D\uDC4B")),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1 } }),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, null,
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, { disableElevation: true, sx: { height: '36px', margin: '6px' }, variant: "outlined", color: "primary", onClick: () => {
                                const user = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user;
                                if (user.appTracker.activeSessions.length != 0) {
                                    this.safeSetState({ showLogoutWithSessionPopup: true });
                                }
                                else {
                                    this.logout();
                                }
                            } }, "Logout"))),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '18px' } },
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogContent, { sx: { padding: '6px 18px', whiteSpace: 'pre-wrap' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { display: 'inline', width: '100%' } },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Header__WEBPACK_IMPORTED_MODULE_6__.Header, { title: 'A few things to remember:', sx: { fontSize: '18px' } }),
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.UL, { sx: { lineHeight: '2' } },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null, "You get $5 of free compute credit for running data science notebooks"),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null, "Compute credits are valid for 30 days"),
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null, "You will need to enter credit card information but will *NOT* be charged until your credits are gone")))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__.DialogActions, { sx: { padding: '12px 6px 6px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_SubscribeButton__WEBPACK_IMPORTED_MODULE_7__.SubscribeButton, { text: 'Get my compute credits' })))));
        };
        this.handleUserChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.connect(this.handleUserChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            plansOpen: false,
            freeTrialWaiting: false
        };
    }
}


/***/ }),

/***/ "./lib/core/SubscribedPopup.js":
/*!*************************************!*\
  !*** ./lib/core/SubscribedPopup.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SubscribedPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/





class SubscribedPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const expiration = new Date(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.trialStart);
            expiration.setDate(expiration.getDate() + 14);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.PermanentPopup, { open: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.isSubscribed() && new Date(0).getTime() == _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.starterPopupDismissed.getTime() },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                        display: 'inline-flex',
                        height: '60px',
                        padding: '6px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: {
                            display: 'inline-flex',
                            minWidth: '150px',
                            fontSize: '16px',
                            fontWeight: 'bold',
                            paddingRight: '12px', // this is 6px counteracting the DialogTitle padding and 6px aligning the padding to the right of the tabs
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { margin: 'auto', paddingLeft: '12px' } }, "Let's run some notebooks \uD83D\uDE80")),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { flexGrow: 1 } }),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, null,
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.starterPopupDismissed = new Date();
                                this.forceUpdate();
                            }, sx: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                                margin: '6px',
                            } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.Close, { sx: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } })))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_4__.ShadowedDivider, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '18px' } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '6px 18px', whiteSpace: 'pre-wrap' } },
                        "Here are a few resources to help you get started:",
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.UL, { sx: { lineHeight: '2' } },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null,
                                "Explore the knowledge base",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: {
                                        padding: 0.5,
                                        zIndex: 1,
                                    }, onClick: () => {
                                        window.open('https://optumi.notion.site/Optumi-Knowledge-Base-f51e2040569b46449601851c91caea29', '_blank');
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { sx: { height: '18px', width: '18px' } }))),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null,
                                "Walk through an example notebook",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: {
                                        padding: 0.5,
                                    }, onClick: () => {
                                        window.open('https://optumi.notion.site/Launch-a-workload-with-an-example-notebook-0e473db440334c7d86b0dc398cb41761', '_blank');
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { sx: { height: '18px', width: '18px' } }))),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.LI, null,
                                "Learn about the two ways to run notebooks",
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', sx: {
                                        padding: 0.5,
                                    }, onClick: () => {
                                        window.open('https://optumi.notion.site/Decide-when-to-launch-a-workload-as-a-session-vs-job-3266e474b89f4c9592b0d4f88fb28fec', '_blank');
                                    } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__.OpenInNew, { sx: { height: '18px', width: '18px' } })))),
                        "For support you can always reach out to cs@optumi.com."),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogActions, { sx: { padding: '12px 6px 6px 6px' } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: 'contained', color: 'primary', onClick: () => {
                                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.starterPopupDismissed = new Date();
                                this.safeSetState({ waiting: true });
                            }, sx: { marginLeft: '18x' } }, this.state.waiting ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' })) : 'Get started')))));
        };
        this.handleUserChange = () => this.forceUpdate();
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.connect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.connect(this.handleUserChange);
        };
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.userInformationChanged.disconnect(this.handleUserChange);
            _Global__WEBPACK_IMPORTED_MODULE_3__.Global.onUserChange.disconnect(this.handleUserChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            plansOpen: false,
            waiting: false
        };
    }
}


/***/ }),

/***/ "./lib/core/Switch.js":
/*!****************************!*\
  !*** ./lib/core/Switch.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Switch": () => (/* binding */ Switch)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/* harmony import */ var _Colors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Colors */ "./lib/Colors.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const getStyledSwitch = (color = _Colors__WEBPACK_IMPORTED_MODULE_3__.Colors.PRIMARY) => {
    return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
        root: {
            width: '42px',
            height: '24px',
            padding: '0px',
        },
        thumb: {
            width: '20px',
            height: '20px',
            padding: '0px',
            margin: '2px',
        },
        switchBase: {
            padding: '0px',
            '&$checked': {
                color: color,
            },
            '&$checked + $track': {
                backgroundColor: color,
            },
        },
        checked: {
            color: color,
        },
        track: {
            height: '12px',
            width: '34px',
            borderRadius: '6px',
            padding: '0px',
            margin: '6px',
        },
    })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Switch);
};
class Switch extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({
                    display: 'inline-flex',
                    width: this.props.label ? '100%' : undefined,
                    padding: '6px 0px',
                }, this.props.sx), ref: this.props.ref, onMouseOver: this.props.onMouseOver, onMouseOut: this.props.onMouseOut },
                this.props.label && this.props.labelBefore && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        width: this.props.labelWidth || '100%',
                        textAlign: 'left',
                        margin: 'auto 12px',
                    } },
                    this.props.label,
                    this.props.info)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__["default"], { reminder: this.props.tooltip || '' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                            minWidth: (this.props.labelBefore !== true && this.props.labelWidth) || 'unset',
                            lineHeight: '24px',
                            textAlign: 'center',
                            direction: this.props.flip ? 'rtl' : 'ltr'
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledSwitch, { inputProps: { style: { height: '24px' } }, checked: this.state.value, onChange: (event) => {
                                this.safeSetState({ value: event.currentTarget.checked });
                                this.props.saveValue(event.currentTarget.checked);
                            }, disabled: this.props.disabled }))),
                this.props.label && (this.props.labelBefore !== true) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: { width: '100%', textAlign: 'left', margin: 'auto 6px' } },
                    this.props.label,
                    this.props.info))));
        };
        this.handleMetadataChange = () => { this.safeSetState({ value: this.props.getValue() }); };
        this.handleThemeChange = () => {
            this.StyledSwitch = getStyledSwitch(this.props.color);
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            this._isMounted = true;
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            _Global__WEBPACK_IMPORTED_MODULE_4__.Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledSwitch = getStyledSwitch(props.color);
        this.state = { value: this.props.getValue() };
    }
}


/***/ }),

/***/ "./lib/core/TextBox.js":
/*!*****************************!*\
  !*** ./lib/core/TextBox.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextBox": () => (/* binding */ TextBox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "webpack/sharing/consume/default/@mui/icons-material/@mui/icons-material");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/ExtraInfo */ "./lib/utils/ExtraInfo.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






class TextBox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.getStyledOutlinedInput = () => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    padding: '0px',
                },
                input: {
                    lineHeight: '14px',
                    fontSize: '12px',
                    padding: '3px 6px 3px 6px',
                    height: '1.1876em',
                },
                adornedEnd: {
                    paddingRight: '0px',
                },
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.OutlinedInput);
        };
        this.getStyledInputLabel = () => {
            return (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)({
                root: {
                    fontSize: '12px',
                    backgroundColor: 'var(--jp-layout-color1)',
                    padding: '1px 2px',
                },
                outlined: {
                    transform: 'translate(6px, 6px) scale(1)',
                    '&$shrink': {
                        transform: 'translate(9px, -6px) scale(0.8)',
                    }
                },
                formControl: {
                    transform: 'translate(6px, 6px) scale(1)',
                },
                shrink: {
                    transform: 'translate(9px, -6px) scale(0.8)',
                },
            })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.InputLabel);
        };
        // This turns the textbox red if it is not a valid value determined by the unstyle function
        this.handleChange = async (event) => {
            const value = event.currentTarget.value;
            this.safeSetState({ textValue: value });
            if (this.props.unstyleUnitValue == undefined) {
                if (typeof value === 'number') {
                    if (this.props.minValue !== undefined && value < this.props.minValue) {
                        this.safeSetState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && value > this.props.maxValue) {
                        this.safeSetState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.safeSetState({ value: value, invalidTextMessage: '' });
                    }
                }
                else {
                    if (!this.props.editPressRequired)
                        this.safeSetState({ value: value, invalidTextMessage: '' });
                }
            }
            else {
                var unstyledValue = this.props.unstyleUnitValue(value);
                if (!isNaN(unstyledValue)) {
                    if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                        this.safeSetState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                        this.safeSetState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.safeSetState({ value: unstyledValue, invalidTextMessage: '' });
                    }
                }
                else {
                    this.safeSetState({ invalidTextMessage: 'Invalid format' });
                }
            }
        };
        this.startEdit = () => {
            this.safeSetState({ editing: true });
            this.textField.current.disabled = false;
            this.textField.current.focus();
        };
        this.discardChanges = () => {
            this.safeSetState({
                editing: false,
                textValue: this.props.styledUnitValue(this.state.value),
                invalidTextMessage: '',
            });
        };
        // If save clicked, or if unfocused if save not required. Saves value if it is a valid value determined by the unstyle function or lack thereof
        this.saveChanges = () => {
            var invalidTextMessage = '';
            var unstyledValue = this.state.textValue;
            if (this.props.unstyleUnitValue != undefined) {
                unstyledValue = this.props.unstyleUnitValue(this.state.textValue);
                if (isNaN(unstyledValue)) {
                    invalidTextMessage = 'Invalid format';
                }
                else if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                    invalidTextMessage = 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue);
                }
                else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                    invalidTextMessage = 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue);
                }
            }
            this.safeSetState({ invalidTextMessage: invalidTextMessage });
            if (invalidTextMessage == '') {
                this.safeSetState({ editing: false, value: unstyledValue, textValue: this.props.styledUnitValue(unstyledValue) });
                var saveReturn = this.props.saveValue(unstyledValue);
                this.safeSetState({ invalidTextMessage: saveReturn == undefined ? '' : saveReturn });
            }
        };
        this.startHover = () => {
            this.safeSetState({ hovered: true });
        };
        this.stopHover = () => {
            this.safeSetState({ hovered: false });
        };
        this.renderPopupButton = (render) => {
            return this.props.editPopup !== undefined ? react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(this.props.editPopup, {
                style: {
                    display: render ? 'flex' : 'none',
                },
                onOpen: () => {
                    this.safeSetState({ editing: true });
                },
                onClose: () => {
                    this.safeSetState({ hovered: false, editing: false });
                }
            }) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
        };
        this.renderEditButton = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.startEdit, sx: {
                    display: render ? 'flex' : 'none',
                    width: '100%',
                    minWidth: '0px',
                    paddingTop: '6px',
                }, variant: "outlined", color: 'secondary' }, "Edit"));
        };
        this.renderConfirmCancelButtons = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.discardChanges, variant: "outlined", color: "primary", sx: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopRightRadius: '0px',
                        borderBottomRightRadius: '0px',
                        borderRight: '0px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Close, { sx: { width: '20px', height: '20px' } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { onClick: this.saveChanges, variant: "outlined", color: "primary", sx: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopLeftRadius: '0px',
                        borderBottomLeftRadius: '0px',
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Done, { sx: { width: '20px', height: '20px' } }))));
        };
        this.renderLabelOverButton = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledInputLabel, { shrink: true, sx: { display: render ? 'flex' : 'none', position: 'absolute' } }, this.props.label));
        };
        this.renderLabel = (render) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.SPAN, { sx: { display: render ? 'inline' : 'none', width: '100%', color: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? 'var(--jp-ui-font-color3)' : 'var(--jp-ui-font-color1)' } }, this.props.label + (this.props.required ? '*' : '')));
        };
        this.handleFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            if (!(this.props.editPressRequired || this.props.editPopup !== undefined)) {
                this.saveChanges();
            }
        };
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var showPopupButton = false, showEditButton = false, showConfirmCancelButtons = false, showLabel = false;
            // There should never be an if without an else. That could lead to nothing being rendered to the left of the textbox
            if (this.props.editPopup === undefined && !this.props.editPressRequired) {
                showLabel = true;
            }
            else if (!this.state.hovered && !this.state.editing) {
                showLabel = true;
            }
            else {
                if (this.props.editPopup !== undefined) {
                    showPopupButton = true;
                }
                else {
                    if (this.state.editing) {
                        showConfirmCancelButtons = true;
                    }
                    else {
                        showEditButton = true;
                    }
                }
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: Object.assign({ display: 'inline-flex', width: '100%', padding: '6px 0px' }, this.props.sx), onMouseOver: this.startHover, onMouseOut: this.stopHover },
                this.props.label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_4__.DIV, { sx: {
                        display: 'flex',
                        position: 'relative',
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        // textAlign: 'center',
                    } },
                    this.renderLabel(showLabel),
                    this.renderPopupButton(showPopupButton),
                    this.renderEditButton(showEditButton),
                    this.renderConfirmCancelButtons(showConfirmCancelButtons),
                    this.renderLabelOverButton(!showLabel))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_utils_ExtraInfo__WEBPACK_IMPORTED_MODULE_5__["default"], { reminder: this.state.invalidTextMessage },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.FormControl, { error: this.state.invalidTextMessage != '', variant: 'outlined', sx: { width: '100%', margin: '2px 6px', height: this.props.multiline ? '' : (this.props.helperText ? '32px' : '20px') } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.StyledOutlinedInput, { size: 'small', notched: false, label: '', inputRef: this.textField, value: this.state.textValue, placeholder: this.props.placeholder, disabled: this.props.disabled ||
                                (!(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ||
                                    (this.props.editPressRequired && !this.state.editing) ||
                                    this.props.editPopup !== undefined), onChange: this.handleChange, onKeyDown: (event) => { if ((!this.props.multiline && event.key == 'Enter') || event.key == 'Escape')
                                this.textField.current.blur(); }, onFocus: this.handleFocus, onBlur: this.handleBlur, type: this.props.password && this.state.hidePassword ? 'password' : 'text', multiline: this.props.multiline, required: this.props.required, rows: (() => {
                                const lines = this.state.textValue.split('\n').length;
                                if (this.props.minLines && lines < this.props.minLines)
                                    return this.props.minLines;
                                return lines;
                            })(), endAdornment: (this.props.disabled || !(this.props.disabledMessage == undefined || this.props.disabledMessage == '')) ? (
                            // <ExtraInfo reminder={this.props.disabledMessage}>
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.InputAdornment, { position: "end", sx: { height: '20px', margin: '0px 3px 0px 0px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', disabled: true, sx: { padding: '3px 3px 3px 0px' } },
                                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Lock, { sx: { width: '14px', height: '14px' } })))
                            // </ExtraInfo>
                            ) : this.props.password && (
                            // <ExtraInfo reminder={this.state.hidePassword ? 'Show Password' : 'Hide Password'}>
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.InputAdornment, { position: "end", sx: { height: '20px', margin: '0px 3px 0px 0px' } },
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.IconButton, { size: 'large', onClick: () => this.safeSetState({ hidePassword: !this.state.hidePassword }), sx: { padding: '3px 3px 3px 0px' } }, this.state.hidePassword ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.VisibilityOff, { sx: { width: '14px', height: '14px' } })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__.Visibility, { sx: { width: '14px', height: '14px' } }))))
                            // </ExtraInfo>
                            ) }),
                        this.props.helperText &&
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.FormHelperText, { sx: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap', display: 'inline-flex' } },
                                this.props.helperText,
                                this.props.helperLink && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", { href: this.props.helperLink.link, target: "_blank", style: { flexGrow: 1, textAlign: 'end', fontStyle: 'italic' } }, this.props.helperLink.text)))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_4__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.StyledInputLabel = this.getStyledInputLabel();
        this.textField = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        const value = this.props.getValue();
        this.state = {
            value: value,
            textValue: this.props.styledUnitValue(value),
            editing: false,
            hovered: false,
            invalidTextMessage: '',
            hidePassword: true,
        };
    }
}
TextBox.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};


/***/ }),

/***/ "./lib/core/WarningPopup.js":
/*!**********************************!*\
  !*** ./lib/core/WarningPopup.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WarningPopup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "webpack/sharing/consume/default/@mui/material/@mui/material");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/styles */ "webpack/sharing/consume/default/@mui/styles/@mui/styles");
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Header */ "./lib/core/Header.js");
/* harmony import */ var _ShadowedDivider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ShadowedDivider */ "./lib/core/ShadowedDivider.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/






const StyledDialog = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)((theme) => ({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
    },
}))(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Dialog);
class WarningPopup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(StyledDialog, { open: this.props.open },
                this.props.headerText &&
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogTitle, { sx: {
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px 30px',
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Header__WEBPACK_IMPORTED_MODULE_4__.Header, { title: this.props.headerText, sx: { lineHeight: '24px' } })),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ShadowedDivider__WEBPACK_IMPORTED_MODULE_5__.ShadowedDivider, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { padding: '18px' } },
                    this.props.bodyText &&
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '6px 18px', whiteSpace: 'pre-wrap' } }, this.props.bodyText),
                    this.props.bodyContent &&
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogContent, { sx: { padding: '6px 18px', whiteSpace: 'pre-wrap' } }, this.props.bodyContent),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.DialogActions, { sx: { padding: '12px 6px 6px 6px' } },
                        this.props.preventText &&
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Checkbox, { checked: this.state.prevent, onClick: () => this.safeSetState({ prevent: !this.state.prevent }) }),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.ListItemText, { disableTypography: true, primary: this.props.preventText, sx: { marginLeft: '0px', fontSize: '14px' } })),
                        this.props.cancel &&
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, { variant: 'contained', color: 'secondary', sx: { opacity: this.state.continueWaiting ? '0' : '1', transition: 'all 225ms', pointerEvents: this.state.continueWaiting ? 'none' : 'auto' }, disabled: this.state.cancelWaiting, onClick: async () => {
                                    setTimeout(() => this.safeSetState({ prevent: false, cancelWaiting: true }), 250);
                                    if (this.props.cancel.onCancelAsync) {
                                        await this.props.cancel.onCancelAsync(this.state.prevent);
                                    }
                                    else {
                                        this.props.cancel.onCancel(this.state.prevent);
                                    }
                                    setTimeout(() => this.safeSetState({ cancelWaiting: false }), 250);
                                } },
                                this.state.cancelWaiting && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' })),
                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { paddingLeft: this.state.cancelWaiting ? '12px' : '' } }, this.props.cancel.text)),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(this.ContinueButton, { variant: 'contained', sx: { marginLeft: '18px', opacity: this.state.cancelWaiting ? '0' : '1', transition: 'all 225ms', pointerEvents: this.state.continueWaiting ? 'none' : 'auto' }, disabled: this.state.continueWaiting, onClick: async () => {
                                setTimeout(() => this.safeSetState({ continueWaiting: true }), 250);
                                if (this.props.continue.onContinueAsync) {
                                    await this.props.continue.onContinueAsync(this.state.prevent);
                                }
                                else {
                                    this.props.continue.onContinue(this.state.prevent);
                                }
                                setTimeout(() => this.safeSetState({ continueWaiting: false }), 250);
                            } },
                            this.state.continueWaiting && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__.CircularProgress, { size: '1.75em' })),
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_3__.DIV, { sx: { paddingLeft: this.state.continueWaiting ? '12px' : '' } }, this.props.continue.text))))));
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.safeSetState = (map) => {
            if (this._isMounted) {
                let update = false;
                try {
                    for (const key of Object.keys(map)) {
                        if (JSON.stringify(map[key]) !== JSON.stringify(this.state[key])) {
                            update = true;
                            break;
                        }
                    }
                }
                catch (error) {
                    update = true;
                }
                if (update) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SafeSetState (' + new Date().getSeconds() + ')');
                    this.setState(map);
                }
                else {
                    if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnSafeSetState)
                        console.log('SuppressedSetState (' + new Date().getSeconds() + ')');
                }
            }
        };
        this.state = {
            prevent: false,
            cancelWaiting: false,
            continueWaiting: false,
        };
        this.ContinueButton = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_2__.withStyles)((theme) => {
            const paletteColor = (() => {
                switch (this.props.continue.color) {
                    case 'primary': return theme.palette.primary;
                    case 'secondary': return theme.palette.secondary;
                    case 'success': return theme.palette.success;
                    case 'error': return theme.palette.error;
                    case 'warning': return theme.palette.warning;
                    case 'info': return theme.palette.info;
                }
            })();
            return ({
                root: {
                    color: paletteColor.contrastText,
                    backgroundColor: paletteColor.main,
                    '&:hover': {
                        backgroundColor: paletteColor.dark,
                        // Reset on touch devices, it doesn't add specificity
                        '@media (hover: none)': {
                            backgroundColor: paletteColor.main,
                        },
                    },
                },
            });
        })(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button);
    }
}


/***/ }),

/***/ "./lib/core/notebook/CodeCell.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/CodeCell.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CodeCell)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _InputArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputArea */ "./lib/core/notebook/InputArea.js");
/* harmony import */ var _OutputArea__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./OutputArea */ "./lib/core/notebook/OutputArea.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class CodeCell extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-Cell jp-CodeCell jp-Notebook-cell', onContextMenu: (e) => e.preventDefault() },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputArea__WEBPACK_IMPORTED_MODULE_2__["default"], { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor }),
                this.props.cell.outputs && this.props.cell.outputs.length > 0 && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_OutputArea__WEBPACK_IMPORTED_MODULE_3__["default"], { cell: this.props.cell, metadata: this.props.metadata }))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Editor.js":
/*!*************************************!*\
  !*** ./lib/core/notebook/Editor.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Editor)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-codemirror2 */ "webpack/sharing/consume/default/react-codemirror2/react-codemirror2");
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



// This code did not work to enable supporting all languages, though they don't recommend enabling all of them
// import glob from 'glob'
// import path from 'path'
// glob.sync('codemirror/mode/**/*').forEach((file: string) => require(path.resolve(file)))
__webpack_require__(/*! codemirror/mode/julia/julia */ "./node_modules/codemirror/mode/julia/julia.js");
__webpack_require__(/*! codemirror/mode/python/python */ "./node_modules/codemirror/mode/python/python.js");
__webpack_require__(/*! codemirror/mode/r/r */ "./node_modules/codemirror/mode/r/r.js");
class Editor extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return this.props.renderInColor ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__.UnControlled, { value: this.props.cell.source, options: {
                        readOnly: 'nocursor',
                        screenReaderLabel: 'jp-mod-readOnly',
                        theme: 'jupyter',
                        mode: this.props.metadata.language_info.name,
                    } }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                    whiteSpace: 'pre-wrap',
                    fontFamily: 'var(--jp-code-font-family)',
                }, className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' }, this.props.cell.source));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/InputArea.js":
/*!****************************************!*\
  !*** ./lib/core/notebook/InputArea.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputArea)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _Editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Editor */ "./lib/core/notebook/Editor.js");
/* harmony import */ var _Markdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Markdown */ "./lib/core/notebook/Markdown.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class InputArea extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            var exec_count = ' ';
            var scrollID = '';
            // If the notebook is running, add a star toa ll cells
            if (this.props.metadata.papermill && this.props.metadata.papermill.start_time && !this.props.metadata.papermill.end_time)
                exec_count = '*';
            // If the cell is finished, show the execution count
            if (this.props.cell.execution_count != null)
                exec_count = this.props.cell.execution_count;
            // Papermill puts an execution_count in a cell even if it is still running, so patch that here, also set the scroll id
            if (this.props.cell.metadata.papermill && this.props.cell.metadata.papermill.start_time && !this.props.cell.metadata.papermill.end_time) {
                exec_count = '*';
                scrollID = 'scrollHere';
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { id: scrollID, className: 'p-Widget lm-Widget jp-Cell-inputWrapper' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-InputArea jp-Cell-inputArea' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-InputPrompt jp-InputArea-prompt' }, this.props.cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, this.props.cell.execution_count !== undefined && `[${exec_count}]:`)) : this.props.cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null))),
                    this.props.cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Editor__WEBPACK_IMPORTED_MODULE_2__["default"], { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor })) : this.props.cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Markdown__WEBPACK_IMPORTED_MODULE_3__["default"], { cell: this.props.cell, metadata: this.props.metadata })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Markdown.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/Markdown.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Markdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _Markdown__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Markdown */ "./lib/core/Markdown.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class Markdown extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'jp-RenderedMarkdown jp-MarkdownOutput jp-RenderedHTMLCommon' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Markdown__WEBPACK_IMPORTED_MODULE_2__.Markdown, { text: this.props.cell.source })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/MarkdownCell.js":
/*!*******************************************!*\
  !*** ./lib/core/notebook/MarkdownCell.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MarkdownCell)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _InputArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputArea */ "./lib/core/notebook/InputArea.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class MarkdownCell extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-Cell jp-MarkdownCell jp-Notebook-cell' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputArea__WEBPACK_IMPORTED_MODULE_2__["default"], { cell: this.props.cell, metadata: this.props.metadata, renderInColor: this.props.renderInColor })));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/Notebook.js":
/*!***************************************!*\
  !*** ./lib/core/notebook/Notebook.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Notebook)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _CodeCell__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CodeCell */ "./lib/core/notebook/CodeCell.js");
/* harmony import */ var _MarkdownCell__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MarkdownCell */ "./lib/core/notebook/MarkdownCell.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/




class Notebook extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            const notebook = this.props.notebook;
            // const words = notebook.cells.map(cell => (cell.source as string).split(/\b/).length).reduce((a, b) => a + b, 0)
            const words = notebook.cells.map(cell => cell.source.length).reduce((a, b) => a + b, 0) / 5;
            const renderInColor = words < 2500;
            let i = 0;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-Notebook jp-NotebookPanel-notebook jp-mod-scrollPastEnd jp-mod-commandMode' }, notebook.cells.map(cell => cell.cell_type === 'code' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_CodeCell__WEBPACK_IMPORTED_MODULE_2__["default"], { key: i++, cell: cell, metadata: notebook.metadata, renderInColor: renderInColor })) : cell.cell_type === 'markdown' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_MarkdownCell__WEBPACK_IMPORTED_MODULE_3__["default"], { key: i++, cell: cell, metadata: notebook.metadata, renderInColor: renderInColor })) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null)))));
        };
        this.papermillErrorCell = null;
        this.componentDidMount = () => {
            // Remove the papermill error cell from any elements if they exist
            this.papermillErrorCell = document.getElementById('papermill-error-cell');
            if (this.papermillErrorCell) {
                this.papermillErrorCell.id = '';
                // Avoid removing the id from the notebook in the popup
                if (!document.getElementById('papermill-error-cell')) {
                    this.papermillErrorCell.id = 'papermill-error-cell';
                    this.papermillErrorCell = null;
                }
            }
            // Scroll to the current executing cell if there is one running
            location.href = "#";
            location.href = "#scrollHere";
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open;
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            _Global__WEBPACK_IMPORTED_MODULE_1__.Global.lab.contextMenu.open = this.oldOpen;
            // Restore the old error cell
            if (this.papermillErrorCell) {
                this.papermillErrorCell.id = 'papermill-error-cell';
                this.papermillErrorCell = null;
            }
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/core/notebook/OutputArea.js":
/*!*****************************************!*\
  !*** ./lib/core/notebook/OutputArea.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OutputArea)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var _AnsiLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../AnsiLink */ "./lib/core/AnsiLink.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class OutputArea extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-Cell-outputWrapper' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-OutputArea jp-Cell-outputArea' },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-OutputArea-child' },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { className: 'p-Widget lm-Widget jp-OutputPrompt jp-OutputArea-prompt' }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { sx: { display: 'block', width: '100%' } }, this.props.cell.outputs.map((output) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { key: hashString(JSON.stringify(output)) }, (() => {
                            var output_type = output.output_type;
                            switch (output_type) {
                                case "stream":
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { "data-mime-type": output.name === 'stderr' ? 'application/vnd.jupyter.stderr' : 'application/vnd.jupyter.stdout', className: 'p-Widget lm-Widget jp-RenderedText jp-OutputArea-output' },
                                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AnsiLink__WEBPACK_IMPORTED_MODULE_2__.AnsiLink, { text: output.text })));
                                case "error":
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { "data-mime-type": 'application/vnd.jupyter.stderr', className: 'p-Widget lm-Widget jp-RenderedText jp-OutputArea-output' }, output.traceback.map((line) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AnsiLink__WEBPACK_IMPORTED_MODULE_2__.AnsiLink, { key: hashString(line), text: line })))));
                                case "execute_result":
                                // Let this fall through to display data because
                                // "Results of an execution are published as an execute_result. These are identical to display_data messages, with the addition of an execution_count key." - Jupyter messaging docs
                                case "display_data":
                                    for (var firstPass = 0; firstPass < 2; firstPass++) {
                                        for (var type in output.data) {
                                            // We want to show the rich output, so only look at text/plain if that is the only data_type
                                            if (firstPass == 0 && type == 'text/plain')
                                                continue;
                                            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, null, type === 'text/html' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { "data-mime-type": type, className: 'p-Widget lm-Widget jp-RenderedHTMLCommon jp-RenderedHTML jp-OutputArea-output' },
                                                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { dangerouslySetInnerHTML: { __html: output.data[type] } }))) : type.startsWith('image/') ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { "data-mime-type": type, className: 'p-Widget lm-Widget jp-RenderedImage jp-OutputArea-output' },
                                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("img", { src: "data:" + type + ";base64," + output.data[type], className: "jp-needs-light-background" }))) : type === 'text/plain' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_1__.DIV, { "data-mime-type": output.data[type], className: 'p-Widget lm-Widget jp-RenderedText jp-OutputArea-output' },
                                                react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", null, output.data[type]))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null))));
                                        }
                                    }
                                // Note: this can fall through
                                case "update_display_data":
                                    // I don't know what to do with this type, but i'm hoping we don't need to handle it
                                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null));
                            }
                        })()))))))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}
function hashString(toHash) {
    var hash = 0, i, chr;
    if (toHash.length === 0)
        return hash;
    for (i = 0; i < toHash.length; i++) {
        chr = toHash.charCodeAt(i);
        hash = ((hash << 5) - hash) + chr;
        hash |= 0; // Convert to 32bit integer
    }
    return hash;
}
;


/***/ }),

/***/ "./lib/core/notebook/Script.js":
/*!*************************************!*\
  !*** ./lib/core/notebook/Script.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Script)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Global */ "./lib/Global.js");
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-codemirror2 */ "webpack/sharing/consume/default/react-codemirror2/react-codemirror2");
/* harmony import */ var react_codemirror2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__);
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



// This code did not work to enable supporting all languages, though they don't recommend enabling all of them
// import glob from 'glob'
// import path from 'path'
// glob.sync('codemirror/mode/**/*').forEach((file: string) => require(path.resolve(file)))
__webpack_require__(/*! codemirror/mode/julia/julia */ "./node_modules/codemirror/mode/julia/julia.js");
__webpack_require__(/*! codemirror/mode/python/python */ "./node_modules/codemirror/mode/python/python.js");
__webpack_require__(/*! codemirror/mode/r/r */ "./node_modules/codemirror/mode/r/r.js");
class Script extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                console.log('ComponentRender (' + new Date().getSeconds() + ')');
            return this.props.renderInColor ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_codemirror2__WEBPACK_IMPORTED_MODULE_1__.UnControlled, { value: this.props.source, options: {
                        readOnly: 'nocursor',
                        screenReaderLabel: 'jp-mod-readOnly',
                        theme: 'jupyter',
                        mode: this.props.mode,
                    } }))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Global__WEBPACK_IMPORTED_MODULE_2__.DIV, { sx: {
                    whiteSpace: 'pre-wrap',
                    fontFamily: 'var(--jp-code-font-family)',
                }, className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' }, this.props.source));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (_Global__WEBPACK_IMPORTED_MODULE_2__.Global.shouldLogOnRender)
                    console.log('SuppressedRender (' + new Date().getSeconds() + ')');
                return false;
            }
            catch (error) {
                return true;
            }
        };
    }
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./widget */ "./lib/widget.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
    _widget__WEBPACK_IMPORTED_MODULE_0__["default"],
]);


/***/ }),

/***/ "./lib/models/AWSRegions.js":
/*!**********************************!*\
  !*** ./lib/models/AWSRegions.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AWSRegions": () => (/* binding */ AWSRegions)
/* harmony export */ });
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
class AWSRegion {
    constructor(region, description) {
        this.region = region;
        this.description = description;
    }
}
class AWSRegions {
    static get GovCloud() { return AWSRegions.regions.GovCloud; }
    static get US_GOV_EAST_1() { return AWSRegions.regions.US_GOV_EAST_1; }
    static get US_EAST_1() { return AWSRegions.regions.US_EAST_1; }
    static get US_EAST_2() { return AWSRegions.regions.US_EAST_2; }
    static get US_WEST_1() { return AWSRegions.regions.US_WEST_1; }
    static get US_WEST_2() { return AWSRegions.regions.US_WEST_2; }
    static get EU_WEST_1() { return AWSRegions.regions.EU_WEST_1; }
    static get EU_WEST_2() { return AWSRegions.regions.EU_WEST_2; }
    static get EU_WEST_3() { return AWSRegions.regions.EU_WEST_3; }
    static get EU_CENTRAL_1() { return AWSRegions.regions.EU_CENTRAL_1; }
    static get EU_NORTH_1() { return AWSRegions.regions.EU_NORTH_1; }
    static get EU_SOUTH_1() { return AWSRegions.regions.EU_SOUTH_1; }
    static get AP_EAST_1() { return AWSRegions.regions.AP_EAST_1; }
    static get AP_SOUTH_1() { return AWSRegions.regions.AP_SOUTH_1; }
    static get AP_SOUTHEAST_1() { return AWSRegions.regions.AP_SOUTHEAST_1; }
    static get AP_SOUTHEAST_2() { return AWSRegions.regions.AP_SOUTHEAST_2; }
    static get AP_NORTHEAST_1() { return AWSRegions.regions.AP_NORTHEAST_1; }
    static get AP_NORTHEAST_2() { return AWSRegions.regions.AP_NORTHEAST_2; }
    static get AP_NORTHEAST_3() { return AWSRegions.regions.AP_NORTHEAST_3; }
    static get SA_EAST_1() { return AWSRegions.regions.SA_EAST_1; }
    static get CN_NORTH_1() { return AWSRegions.regions.CN_NORTH_1; }
    static get CN_NORTHWEST_1() { return AWSRegions.regions.CN_NORTHWEST_1; }
    static get CA_CENTRAL_1() { return AWSRegions.regions.CA_CENTRAL_1; }
    static get ME_SOUTH_1() { return AWSRegions.regions.ME_SOUTH_1; }
    static get AF_SOUTH_1() { return AWSRegions.regions.AF_SOUTH_1; }
    static get US_ISO_EAST_1() { return AWSRegions.regions.US_ISO_EAST_1; }
    static get US_ISOB_EAST_1() { return AWSRegions.regions.US_ISOB_EAST_1; }
    static get US_ISO_WEST_1() { return AWSRegions.regions.US_ISO_WEST_1; }
    static get values() {
        return [
            AWSRegions.GovCloud,
            AWSRegions.US_GOV_EAST_1,
            AWSRegions.US_EAST_1,
            AWSRegions.US_EAST_2,
            AWSRegions.US_WEST_1,
            AWSRegions.US_WEST_2,
            AWSRegions.EU_WEST_1,
            AWSRegions.EU_WEST_2,
            AWSRegions.EU_WEST_3,
            AWSRegions.EU_CENTRAL_1,
            AWSRegions.EU_NORTH_1,
            AWSRegions.EU_SOUTH_1,
            AWSRegions.AP_EAST_1,
            AWSRegions.AP_SOUTH_1,
            AWSRegions.AP_SOUTHEAST_1,
            AWSRegions.AP_SOUTHEAST_2,
            AWSRegions.AP_NORTHEAST_1,
            AWSRegions.AP_NORTHEAST_2,
            AWSRegions.AP_NORTHEAST_3,
            AWSRegions.SA_EAST_1,
            AWSRegions.CN_NORTH_1,
            AWSRegions.CN_NORTHWEST_1,
            AWSRegions.CA_CENTRAL_1,
            AWSRegions.ME_SOUTH_1,
            AWSRegions.AF_SOUTH_1,
            AWSRegions.US_ISOB_EAST_1,
            AWSRegions.US_ISO_WEST_1
        ];
    }
}
AWSRegions.regions = {
    GovCloud: new AWSRegion("us-gov-west-1", "AWS GovCloud (US)"),
    US_GOV_EAST_1: new AWSRegion("us-gov-east-1", "AWS GovCloud (US-East)"),
    US_EAST_1: new AWSRegion("us-east-1", "US East (N. Virginia)"),
    US_EAST_2: new AWSRegion("us-east-2", "US East (Ohio)"),
    US_WEST_1: new AWSRegion("us-west-1", "US West (N. California)"),
    US_WEST_2: new AWSRegion("us-west-2", "US West (Oregon)"),
    EU_WEST_1: new AWSRegion("eu-west-1", "EU (Ireland)"),
    EU_WEST_2: new AWSRegion("eu-west-2", "EU (London)"),
    EU_WEST_3: new AWSRegion("eu-west-3", "EU (Paris)"),
    EU_CENTRAL_1: new AWSRegion("eu-central-1", "EU (Frankfurt)"),
    EU_NORTH_1: new AWSRegion("eu-north-1", "EU (Stockholm)"),
    EU_SOUTH_1: new AWSRegion("eu-south-1", "EU (Milan)"),
    AP_EAST_1: new AWSRegion("ap-east-1", "Asia Pacific (Hong Kong)"),
    AP_SOUTH_1: new AWSRegion("ap-south-1", "Asia Pacific (Mumbai)"),
    AP_SOUTHEAST_1: new AWSRegion("ap-southeast-1", "Asia Pacific (Singapore)"),
    AP_SOUTHEAST_2: new AWSRegion("ap-southeast-2", "Asia Pacific (Sydney)"),
    AP_NORTHEAST_1: new AWSRegion("ap-northeast-1", "Asia Pacific (Tokyo)"),
    AP_NORTHEAST_2: new AWSRegion("ap-northeast-2", "Asia Pacific (Seoul)"),
    AP_NORTHEAST_3: new AWSRegion("ap-northeast-3", "Asia Pacific (Osaka)"),
    SA_EAST_1: new AWSRegion("sa-east-1", "South America (Sao Paulo)"),
    CN_NORTH_1: new AWSRegion("cn-north-1", "China (Beijing)"),
    CN_NORTHWEST_1: new AWSRegion("cn-northwest-1", "China (Ningxia)"),
    CA_CENTRAL_1: new AWSRegion("ca-central-1", "Canada (Central)"),
    ME_SOUTH_1: new AWSRegion("me-south-1", "Middle East (Bahrain)"),
    AF_SOUTH_1: new AWSRegion("af-south-1", "Africa (Cape Town)"),
    US_ISO_EAST_1: new AWSRegion("us-iso-east-1", "US ISO East"),
    US_ISOB_EAST_1: new AWSRegion("us-isob-east-1", "US ISOB East (Ohio)"),
    US_ISO_WEST_1: new AWSRegion("us-iso-west-1", "US ISO West"),
};


/***/ }),

/***/ "./lib/models/ComputeConfig.js":
/*!*************************************!*\
  !*** ./lib/models/ComputeConfig.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComputeConfig": () => (/* binding */ ComputeConfig)
/* harmony export */ });
/* harmony import */ var _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./OptumiConfig */ "./lib/models/OptumiConfig.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

class ComputeConfig {
    // Dev Ops properties
    // TODO:JJ
    constructor(map = {}, user = null) {
        this.expertise = map.expertise || _OptumiConfig__WEBPACK_IMPORTED_MODULE_0__.Expertise.COMPONENT;
        this.required = map.required || false;
        this.rating = map.rating || [-1, -1, -1];
        this.score = map.score || [-1, -1, -1];
        this.cores = map.cores || [-1, -1, -1];
        this.frequency = map.frequency || [-1, -1, -1];
    }
}


/***/ }),

/***/ "./lib/models/FileChecker.js":
/*!***********************************!*\
  !*** ./lib/models/FileChecker.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileChecker": () => (/* binding */ FileChecker)
/* harmony export */ });
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/



class FileChecker {
    constructor() {
        // Here is where we will keep a list of the file paths that were entered successfully but no longer exist on the disk
        this.localProblemFiles = [];
        this.cloudProblemFiles = [];
        this.problemDataConnectors = [];
        this.problemEnvironmentVariables = [];
        this.refreshing = false;
        this.filesTimeout = null;
        this.dataConnectorsTimeout = null;
        this.refreshFiles = async (poll = true) => {
            if (this.refreshing) {
                try {
                    var newLocalProblemFiles = [];
                    var newCloudProblemFiles = [];
                    const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
                    const files = optumi.upload.files;
                    const fileTracker = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker;
                    for (var file of files) {
                        if (!this.refreshing)
                            break;
                        // Check local
                        const barr = await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_2__["default"].checkIfPathExists(_Global__WEBPACK_IMPORTED_MODULE_1__.Global.convertOptumiPathToJupyterPath(file.path));
                        if (!barr[0]) {
                            newLocalProblemFiles.push(file.path);
                        }
                        else {
                            // This upload call will 'sync' the file if necessary
                            // We don't want to re-upload disabled files
                            if (file.enabled)
                                _Global__WEBPACK_IMPORTED_MODULE_1__.Global.user.fileTracker.uploadFiles({ path: file.path, type: file.type });
                        }
                        // Check cloud
                        const exists = file.type === 'directory' ? fileTracker.directoryExists(file.path) : fileTracker.pathExists(file.path);
                        if (!exists) {
                            newCloudProblemFiles.push(file.path);
                        }
                    }
                    this.localProblemFiles = newLocalProblemFiles;
                    this.cloudProblemFiles = newCloudProblemFiles;
                }
                catch (err) {
                    console.error(err);
                }
                if (poll) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    this.filesTimeout = setTimeout(this.refreshFiles, 60000);
                }
            }
        };
        this.refreshIntegrations = async (poll = true) => {
            if (this.refreshing) {
                try {
                    const optumi = _Global__WEBPACK_IMPORTED_MODULE_1__.Global.metadata.getMetadata().config;
                    const dataConnectors = optumi.dataConnectors;
                    const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
                    const url = settings.baseUrl + "optumi/get-integrations";
                    const dataConnectorsFromController = await (_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {}, settings).then(response => {
                        if (response.status !== 200)
                            throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.ResponseError(response);
                        return response.json();
                    }).then((json) => json.integrations));
                    for (var dataConnector of dataConnectors) {
                        if (!this.refreshing)
                            break;
                        if (!this.problemDataConnectors.includes(dataConnector.name)) {
                            const exists = dataConnectorsFromController.map(x => x.name).includes(dataConnector.name);
                            if (!exists) {
                                this.problemDataConnectors = this.problemDataConnectors.concat([dataConnector.name]);
                            }
                        }
                    }
                }
                catch (err) {
                    console.error(err);
                }
                if (poll) {
                    if (_Global__WEBPACK_IMPORTED_MODULE_1__.Global.shouldLogOnPoll)
                        console.log('FunctionPoll (' + new Date().getSeconds() + ')');
                    this.dataConnectorsTimeout = setTimeout(this.refreshIntegrations, 60000);
                }
            }
        };
    }
    start() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.refreshFiles(true);
            this.refreshIntegrations(true);
        }
    }
    stop() {
        this.refreshing = false;
        if (this.filesTimeout != null)
            clearTimeout(this.filesTimeout);
        if (this.dataConnectorsTimeout != null)
            clearTimeout(this.dataConnectorsTimeout);
    }
    getTriangle(files, dataConnectors) {
        var yellowTriangle = false;
        var redTriangle = false;
        for (let file of files) {
            if (file.enabled) {
                if (this.localProblemFiles.includes(file.path)) {
                    yellowTriangle = true;
                    if (this.cloudProblemFiles.includes(file.path)) {
                        redTriangle = true;
                    }
                }
            }
        }
        for (let dataConnector of dataConnectors) {
            if (dataConnector.enabled) {
                if (this.problemDataConnectors.includes(dataConnector.name)) {
                    redTriangle = true;
                }
            }
        }
        return [yellowTriangle, redTriangle];
    }
    fileMissingLocally(path) {
        return this.localProblemFiles.includes(path);
    }
    fileMissingInCloud(path) {
        return this.cloudProblemFiles.includes(path);
    }
    dataConnectorMissing(name) {
        return this.problemDataConnectors.includes(name);
    }
    environmentVariableMissing(name) {
        return this.problemEnvironmentVariables.includes(name);
    }
    removeFile(path) {
        if (this.localProblemFiles.includes(path))
            this.localProblemFiles = this.localProblemFiles.filter(x => x != path);
        if (this.cloudProblemFiles.includes(path))
            this.cloudProblemFiles = this.cloudProblemFiles.filter(x => x != path);
    }
    removeDataConnector(name) {
        if (this.problemDataConnectors.includes(name))
            this.problemDataConnectors = this.problemDataConnectors.filter(x => x != name);
    }
    removeEnvironmentVariable(name) {
        if (this.problemEnvironmentVariables.includes(name))
            this.problemEnvironmentVariables = this.problemEnvironmentVariables.filter(x => x != name);
    }
}


/***/ }),

/***/ "./lib/models/FileTracker.js":
/*!***********************************!*\
  !*** ./lib/models/FileTracker.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FileTracker": () => (/* binding */ FileTracker)
/* harmony export */ });
/* harmony import */ var _Global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Global */ "./lib/Global.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/FileServerUtils */ "./lib/utils/FileServerUtils.js");
/* harmony import */ var _Snackbar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Snackbar */ "./lib/models/Snackbar.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_FormatUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/FormatUtils */ "./lib/utils/FormatUtils.js");
/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/







var UploadStatus;
(function (UploadStatus) {
    UploadStatus[UploadStatus["COMPLETED"] = -1] = "COMPLETED";
    UploadStatus[UploadStatus["STORAGE_LIMIT"] = -2] = "STORAGE_LIMIT";
    UploadStatus[UploadStatus["UPLOAD_SIZE"] = -3] = "UPLOAD_SIZE";
})(UploadStatus || (UploadStatus = {}));
class FileProgress {
    constructor(path, key, type) {
        // We expect the progress number to be set to -1 when it is done
        // This is to avoid timing holes where the extension thinks files are uploaded but the controller is still in the process of uploading them to blob storage
        this.isDone = () => {
            return this.progress < 0 || this.sameProgressCounter > 20;
        };
        // Cancel this progress
        this.cancel = async () => {
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/cancel-progress";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    key: this.path + this.key,
                }),
            };
            _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.path = path;
        this.key = key;
        this.type = type;
        this._progress = 0;
        this.total = -1;
    }
    get progress() {
        return this._progress;
    }
    // We will keep track of non-changing progress so we can eventually treat it as done
    // This is too add resiliency to the extension in case the sever does something wrong
    set progress(progress) {
        if (this._progress == progress) {
            // If this is done uploading, we don't want to forget it early
            if (this._progress < this.total)
                this.sameProgressCounter++;
        }
        else {
            this.sameProgressCounter = 0;
            this._progress = progress;
        }
    }
}
class FileTracker {
    constructor() {
        this.polling = false;
        this.total = 0;
        this.limit = 0;
        // TODO:JJ This is kind of hacky
        this.lastNumRunningJobs = 0;
        this.handleJobCompleted = () => {
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user) {
                const newNumRunningJobs = _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.appTracker.getDisplayNum();
                if (newNumRunningJobs < this.lastNumRunningJobs) {
                    this.receiveUpdate(false);
                }
                this.lastNumRunningJobs = newNumRunningJobs;
            }
        };
        this.get = (name) => {
            return [...this.fileProgress.filter(x => x.path == name)];
        };
        this.forget = (progress) => {
            this.fileProgress = this.fileProgress.filter(x => x != progress);
        };
        this.uploadFiles = async (metadata) => {
            // If there is an unsigned agreement, do not poll
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user != null && _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.unsignedAgreement) {
                return;
            }
            // If we are already uploading this file, ignore the request
            if (this.compressions.filter(x => x.path == metadata.path).length > 0 || this.uploads.filter(x => x.path == metadata.path).length > 0)
                return;
            const paths = [];
            if (metadata.type == 'directory') {
                for (let file of (await _utils_FileServerUtils__WEBPACK_IMPORTED_MODULE_4__["default"].getRecursiveTree(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.convertOptumiPathToJupyterPath(metadata.path)))) {
                    if (file.size <= _Global__WEBPACK_IMPORTED_MODULE_3__.Global.MAX_UPLOAD_SIZE) {
                        paths.push(_Global__WEBPACK_IMPORTED_MODULE_3__.Global.convertJupyterPathToOptumiPath(file.path));
                    }
                }
            }
            else {
                paths.push(metadata.path);
            }
            // Make this unique by adding a timestamp
            const key = new Date().toISOString();
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/upload-files";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    key: metadata.path + key,
                    paths: paths,
                    compress: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.compressFilesEnabled,
                    storageTotal: this.total,
                    storageLimit: this.limit,
                    autoAddOnsEnabled: _Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.autoAddOnsEnabled,
                }),
            };
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.user.compressFilesEnabled)
                this.fileProgress.push(new FileProgress(metadata.path, key, 'compression'));
            this.fileProgress.push(new FileProgress(metadata.path, key, 'upload'));
            this._filesChanged.emit();
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.generateDownloadSnackbars = (files) => {
            var shortestPath = files[0].path;
            for (let file of files) {
                var newShortest = '';
                for (let i = 0; i < Math.min(shortestPath.length, file.path.length); i++) {
                    if (file.path[i] != shortestPath[i])
                        break;
                    newShortest += shortestPath[i];
                }
                shortestPath = newShortest;
            }
            if (_Global__WEBPACK_IMPORTED_MODULE_3__.Global.shouldLogOnEmit)
                console.log('SignalEmit (' + new Date().getSeconds() + ')');
            if (files.length == 1) {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.snackbarEnqueue.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_5__.Snackbar("Downloading " + shortestPath, { variant: 'success', key: new Date().toISOString() }));
            }
            else {
                while (!shortestPath.endsWith('/')) {
                    shortestPath = shortestPath.substring(0, shortestPath.length - 1);
                }
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.snackbarEnqueue.emit(new _Snackbar__WEBPACK_IMPORTED_MODULE_5__.Snackbar("Downloading " + files.length + ' files to ' + shortestPath, { variant: 'success', key: new Date().toISOString() }));
            }
        };
        this.getNotebookOutputFiles = async (name, files, workloadUUID, moduleUUID, overwrite, directory = null) => {
            this.generateDownloadSnackbars(files);
            const paths = [];
            const sizes = [];
            for (var file of files) {
                paths.push(file.path);
                sizes.push(file.size);
            }
            // Make this unique by adding a timestamp
            const key = new Date().toISOString();
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/get-notebook-output-files";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    workloadUUID: workloadUUID,
                    moduleUUID: moduleUUID,
                    key: name + key,
                    paths: paths,
                    sizes: sizes,
                    overwrite: overwrite,
                    directory: directory,
                }),
            };
            this.fileProgress.push(new FileProgress(name, key, 'download'));
            this._filesChanged.emit();
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.downloadFiles = async (name, files, overwrite, directory = null) => {
            this.generateDownloadSnackbars(files);
            const paths = [];
            const sizes = [];
            const hashes = [];
            for (var file of files) {
                if (this.fileExists(file)) {
                    paths.push(file.path);
                    sizes.push(file.size);
                    hashes.push(file.hash || "");
                }
            }
            // Make this unique by adding a timestamp
            const key = new Date().toISOString();
            const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
            const url = settings.baseUrl + "optumi/download-files";
            const init = {
                method: 'POST',
                body: JSON.stringify({
                    key: name + key,
                    paths: paths,
                    sizes: sizes,
                    hashes: hashes,
                    overwrite: overwrite,
                    directory: directory,
                }),
            };
            this.fileProgress.push(new FileProgress(name, key, 'download'));
            this._filesChanged.emit();
            return _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, init, settings).then((response) => {
                _Global__WEBPACK_IMPORTED_MODULE_3__.Global.handleResponse(response);
            });
        };
        this.compressionPollDelay = 500;
  