# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['taskbadger',
 'taskbadger.internal',
 'taskbadger.internal.api',
 'taskbadger.internal.api.action_endpoints',
 'taskbadger.internal.api.task_endpoints',
 'taskbadger.internal.models']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=21.3.0',
 'httpx>=0.15.4,<0.24.0',
 'python-dateutil>=2.8.0,<3.0.0',
 'tomlkit>=0.11.6,<0.12.0',
 'typer[all]>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['taskbadger = taskbadger.cli:app']}

setup_kwargs = {
    'name': 'taskbadger',
    'version': '0.1',
    'description': 'The official Python SDK for Task Badger',
    'long_description': '# Task Badger Python Client\nThis is the official Python SDK for [Task Badger](https://taskbadger.net/)\n\n---\n\n## Getting Started\n\n### Install\n\n```bash\npip install --upgrade taskbadger\n```\n\n### Configuration\n\n```python\nimport taskbadger\n\ntaskbadger.init(\n    organization_slug="my-org",\n    project_slug="my-project",\n    token="***"\n)\n```\n\n### Usage\n\n```python\nfrom taskbadger import Task, Action, EmailIntegration\n\n# create a new task with custom data and an action definition\ntask = Task.create(\n    "task name",\n    data={\n        "custom": "data"\n    },\n    actions=[\n        Action(\n            "*/10%,success,error",\n            integration=EmailIntegration(to="me@example.com")\n        )\n    ]\n)\n\n# update the task status to \'processing\'\ntask.start()\ntry:\n   for i in range(100):\n      do_something(i)\n      if i % 10 == 0:\n         # update the progress of the task\n         task.update_progress(i)\nexcept Exception as e:\n    # record task errors\n    task.error(data={\n        "error": str(e)\n    })\n    raise\n\n# record task success\ntask.success()\n```\n',
    'author': 'None',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
