# ImprovedReplace

Python library to add some replace method improvements focused on common replacements to optimize code.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes. See deployment for notes on how to deploy the project on a live system.

### Prerequisites

Make sure you have Python and that the expected version is available from your command line. You can check this by running:

```PowerShell
python --version
```

You should get some output like Python 3.6.3. If you do not have Python, please install the latest 3.x version from [python.org](https://python.org)

Additionally, you’ll need to make sure you have pip available. You can check this by running:

```PowerShell
pip --version
```

If you installed Python from source, with an installer from [python.org](https://python.org) you should already have pip. If you’re on Linux and installed using your OS package manager, you may have to install pip separately, see Installing [pip/setuptools/wheel with Linux Package Managers](https://packaging.python.org/guides/installing-using-linux-tools/).

If pip isn’t already installed, then first try to bootstrap it from the standard library:

```PowerShell
python -m ensurepip --default-pip
```

While pip alone is sufficient to install from pre-built binary archives, up to date copies of the setuptools and wheel projects are useful to ensure you can also install from source archives:

```PowerShell
python -m pip install --upgrade pip setuptools wheel
```

### Installing

To install the latest version of ImprovedReplace:

```PowerShell
pip install -U improved-replace
```

And then you can import this library in Python:

```Python
from improved_replace import to_array

string = "Hello World"
string = to_array(string)

print(string)
# Output: ['Hello', 'World']
```

Or you can check the project in [PyPI](https://pypi.org/project/improved-replace/).

## Running the tests

To run automated module tests you first need to install py.test:

```PowerShell
pip install -U py.test
```

Then you must to download the source code of the module in his [github repository](https://github.com/LuckJMG/ImprovedReplace), go to the tests folder with PowerShell and run pytest:

```PowerShell
pytest
```

Pytest will detect all automatic tests to run and check them.

### Some test examples

These are some examples of the automated test

```Python
def test_to_array():
    """Test to_array function."""

    # Normal string
    assert to_array("Hello World") == ["Hello", "World"]

    # Many spaces
    assert to_array(" H e l l o ") == ["H", "e", "l", "l", "o"]

    # Only spaces
    assert to_array("           ") == []

    # Any spaces
    assert to_array("HelloWorld!") == ["HelloWorld!"]

    # Not a string
    assert to_array(None) == None
```

This test is testing all the general cases of the function `to_array` and since
the function is based on separating by space, the tests are based on that.

## Built With

- [Python](https://www.python.org) - Programming language used
- [VS Code](https://code.visualstudio.com/) - Code editor used

## Contributing

Please read [CONTRIBUTING.md](CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/LuckJMG/ImprovedReplace/tags).

## Authors

- **Lucas Mosquera** - _Creator and Maintainer_ - [LuckJMG](https://github.com/LuckJMG)

See also the list of [contributors](https://github.com/LuckJMG/ImprovedReplace/contributors) who participated in this project.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details

## Acknowledgments

This is my first package of python and my first real open source project. The idea occurred to me when I had to
replace a few commas many times with points or vice versa when i was practicing in the URI Online Judge.

Thank you all for getting here, remember this is my first project and i'll learn more thank to this
