"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 */
class Schema {
    /**
     * Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits
     * @param scale the number of digits in fractional part, the default is 0
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     */
    static array(itemType) {
        jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(itemType);
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     */
    static map(keyType, valueType) {
        jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(keyType);
        jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(valueType);
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
_a = JSII_RTTI_SYMBOL_1;
Schema[_a] = { fqn: "@aws-cdk/aws-glue.Schema", version: "1.145.0" };
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * Date type.
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * Timestamp type (date and time).
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * Arbitrary-length string type.
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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