# coding: utf-8
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

# Copyright 2016 Google Inc. All Rights Reserved.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


"""Units of measure for OpenHTF.

THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

Used to retrieve UNECE unit codes by object, name, or suffix:

    from openhtf.util import units

    # The following three expressions are equivalent:
    units.METRE_PER_SECOND
    units.Unit('m/s')
    units.Unit('metre per second')

OpenHTF uses UNECE unit codes internally because they are relatively complete
and modern, and because they are recognized internationally. For full details
regarding where we get the codes from and which units are available, see the
docstring at the top of openhtf/util/units/bin/units_from_xls.py.

THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.
"""
# pylint: disable=too-many-lines

import collections


class UnitDescriptor(
    collections.namedtuple('UnitDescriptor', [
        'name',
        'code',
        'suffix',
    ])):
  pass


ALL_UNITS = []

# pylint: disable=line-too-long

# NO_DIMENSION means that there are units set, but they cannot be expressed
# by a known dimension (such as a ratio)
NO_DIMENSION = UnitDescriptor('No dimension', 'NDL', None)
ALL_UNITS.append(NO_DIMENSION)
NONE = UnitDescriptor('None', None, None)
LIFT = UnitDescriptor('lift', '05', '''''')
ALL_UNITS.append(LIFT)
SMALL_SPRAY = UnitDescriptor('small spray', '06', '''''')
ALL_UNITS.append(SMALL_SPRAY)
HEAT_LOT = UnitDescriptor('heat lot', '08', '''''')
ALL_UNITS.append(HEAT_LOT)
GROUP = UnitDescriptor('group', '10', '''''')
ALL_UNITS.append(GROUP)
OUTFIT = UnitDescriptor('outfit', '11', '''''')
ALL_UNITS.append(OUTFIT)
RATION = UnitDescriptor('ration', '13', '''''')
ALL_UNITS.append(RATION)
SHOT = UnitDescriptor('shot', '14', '''''')
ALL_UNITS.append(SHOT)
STICK_MILITARY = UnitDescriptor('stick, military', '15', '''''')
ALL_UNITS.append(STICK_MILITARY)
HUNDRED_FIFTEEN_KG_DRUM = UnitDescriptor('hundred fifteen kg drum', '16', '''''')
ALL_UNITS.append(HUNDRED_FIFTEEN_KG_DRUM)
HUNDRED_LB_DRUM = UnitDescriptor('hundred lb drum', '17', '''''')
ALL_UNITS.append(HUNDRED_LB_DRUM)
FIFTYFIVE_GALLON_US_DRUM = UnitDescriptor('fiftyfive gallon (US) drum', '18', '''''')
ALL_UNITS.append(FIFTYFIVE_GALLON_US_DRUM)
TANK_TRUCK = UnitDescriptor('tank truck', '19', '''''')
ALL_UNITS.append(TANK_TRUCK)
TWENTY_FOOT_CONTAINER = UnitDescriptor('twenty foot container', '20', '''''')
ALL_UNITS.append(TWENTY_FOOT_CONTAINER)
FORTY_FOOT_CONTAINER = UnitDescriptor('forty foot container', '21', '''''')
ALL_UNITS.append(FORTY_FOOT_CONTAINER)
DECILITRE_PER_GRAM = UnitDescriptor('decilitre per gram', '22', '''dl/g''')
ALL_UNITS.append(DECILITRE_PER_GRAM)
GRAM_PER_CUBIC_CENTIMETRE = UnitDescriptor('gram per cubic centimetre', '23', '''g/cm³''')
ALL_UNITS.append(GRAM_PER_CUBIC_CENTIMETRE)
THEORETICAL_POUND = UnitDescriptor('theoretical pound', '24', '''''')
ALL_UNITS.append(THEORETICAL_POUND)
GRAM_PER_SQUARE_CENTIMETRE = UnitDescriptor('gram per square centimetre', '25', '''g/cm²''')
ALL_UNITS.append(GRAM_PER_SQUARE_CENTIMETRE)
ACTUAL_TON = UnitDescriptor('actual ton', '26', '''''')
ALL_UNITS.append(ACTUAL_TON)
THEORETICAL_TON = UnitDescriptor('theoretical ton', '27', '''''')
ALL_UNITS.append(THEORETICAL_TON)
KILOGRAM_PER_SQUARE_METRE = UnitDescriptor('kilogram per square metre', '28', '''kg/m²''')
ALL_UNITS.append(KILOGRAM_PER_SQUARE_METRE)
POUND_PER_THOUSAND_SQUARE_FOOT = UnitDescriptor('pound per thousand square foot', '29', '''lb/kft²''')
ALL_UNITS.append(POUND_PER_THOUSAND_SQUARE_FOOT)
HORSE_POWER_DAY_PER_AIR_DRY_METRIC_TON = UnitDescriptor('horse power day per air dry metric ton', '30', '''''')
ALL_UNITS.append(HORSE_POWER_DAY_PER_AIR_DRY_METRIC_TON)
CATCH_WEIGHT = UnitDescriptor('catch weight', '31', '''''')
ALL_UNITS.append(CATCH_WEIGHT)
KILOGRAM_PER_AIR_DRY_METRIC_TON = UnitDescriptor('kilogram per air dry metric ton', '32', '''''')
ALL_UNITS.append(KILOGRAM_PER_AIR_DRY_METRIC_TON)
KILOPASCAL_SQUARE_METRE_PER_GRAM = UnitDescriptor('kilopascal square metre per gram', '33', '''kPa·m²/g''')
ALL_UNITS.append(KILOPASCAL_SQUARE_METRE_PER_GRAM)
KILOPASCAL_PER_MILLIMETRE = UnitDescriptor('kilopascal per millimetre', '34', '''kPa/mm''')
ALL_UNITS.append(KILOPASCAL_PER_MILLIMETRE)
MILLILITRE_PER_SQUARE_CENTIMETRE_SECOND = UnitDescriptor('millilitre per square centimetre second', '35', '''ml/(cm²·s)''')
ALL_UNITS.append(MILLILITRE_PER_SQUARE_CENTIMETRE_SECOND)
CUBIC_FOOT_PER_MINUTE_PER_SQUARE_FOOT = UnitDescriptor('cubic foot per minute per square foot', '36', '''ft³/(min/ft²)''')
ALL_UNITS.append(CUBIC_FOOT_PER_MINUTE_PER_SQUARE_FOOT)
OUNCE_PER_SQUARE_FOOT = UnitDescriptor('ounce per square foot', '37', '''oz/ft²''')
ALL_UNITS.append(OUNCE_PER_SQUARE_FOOT)
OUNCE_PER_SQUARE_FOOT_PER_0_01INCH = UnitDescriptor('ounce per square foot per 0,01inch', '38', '''oz/(ft²/cin)''')
ALL_UNITS.append(OUNCE_PER_SQUARE_FOOT_PER_0_01INCH)
MILLILITRE_PER_SECOND = UnitDescriptor('millilitre per second', '40', '''ml/s''')
ALL_UNITS.append(MILLILITRE_PER_SECOND)
MILLILITRE_PER_MINUTE = UnitDescriptor('millilitre per minute', '41', '''ml/min''')
ALL_UNITS.append(MILLILITRE_PER_MINUTE)
SUPER_BULK_BAG = UnitDescriptor('super bulk bag', '43', '''''')
ALL_UNITS.append(SUPER_BULK_BAG)
FIVEHUNDRED_KG_BULK_BAG = UnitDescriptor('fivehundred kg bulk bag', '44', '''''')
ALL_UNITS.append(FIVEHUNDRED_KG_BULK_BAG)
THREEHUNDRED_KG_BULK_BAG = UnitDescriptor('threehundred kg bulk bag', '45', '''''')
ALL_UNITS.append(THREEHUNDRED_KG_BULK_BAG)
FIFTY_LB_BULK_BAG = UnitDescriptor('fifty lb bulk bag', '46', '''''')
ALL_UNITS.append(FIFTY_LB_BULK_BAG)
FIFTY_LB_BAG = UnitDescriptor('fifty lb bag', '47', '''''')
ALL_UNITS.append(FIFTY_LB_BAG)
BULK_CAR_LOAD = UnitDescriptor('bulk car load', '48', '''''')
ALL_UNITS.append(BULK_CAR_LOAD)
THEORETICAL_KILOGRAM = UnitDescriptor('theoretical kilogram', '53', '''''')
ALL_UNITS.append(THEORETICAL_KILOGRAM)
THEORETICAL_TONNE = UnitDescriptor('theoretical tonne', '54', '''''')
ALL_UNITS.append(THEORETICAL_TONNE)
SITAS = UnitDescriptor('sitas', '56', '''''')
ALL_UNITS.append(SITAS)
MESH = UnitDescriptor('mesh', '57', '''''')
ALL_UNITS.append(MESH)
NET_KILOGRAM = UnitDescriptor('net kilogram', '58', '''''')
ALL_UNITS.append(NET_KILOGRAM)
PART_PER_MILLION = UnitDescriptor('part per million', '59', '''ppm''')
ALL_UNITS.append(PART_PER_MILLION)
PERCENT_WEIGHT = UnitDescriptor('percent weight', '60', '''''')
ALL_UNITS.append(PERCENT_WEIGHT)
PART_PER_BILLION_US = UnitDescriptor('part per billion (US)', '61', '''ppb''')
ALL_UNITS.append(PART_PER_BILLION_US)
PERCENT_PER_1000_HOUR = UnitDescriptor('percent per 1000 hour', '62', '''''')
ALL_UNITS.append(PERCENT_PER_1000_HOUR)
FAILURE_RATE_IN_TIME = UnitDescriptor('failure rate in time', '63', '''''')
ALL_UNITS.append(FAILURE_RATE_IN_TIME)
POUND_PER_SQUARE_INCH_GAUGE = UnitDescriptor('pound per square inch, gauge', '64', '''''')
ALL_UNITS.append(POUND_PER_SQUARE_INCH_GAUGE)
OERSTED = UnitDescriptor('oersted', '66', '''Oe''')
ALL_UNITS.append(OERSTED)
TEST_SPECIFIC_SCALE = UnitDescriptor('test specific scale', '69', '''''')
ALL_UNITS.append(TEST_SPECIFIC_SCALE)
VOLT_AMPERE_PER_POUND = UnitDescriptor('volt ampere per pound', '71', '''''')
ALL_UNITS.append(VOLT_AMPERE_PER_POUND)
WATT_PER_POUND = UnitDescriptor('watt per pound', '72', '''''')
ALL_UNITS.append(WATT_PER_POUND)
AMPERE_TUM_PER_CENTIMETRE = UnitDescriptor('ampere tum per centimetre', '73', '''''')
ALL_UNITS.append(AMPERE_TUM_PER_CENTIMETRE)
MILLIPASCAL = UnitDescriptor('millipascal', '74', '''mPa''')
ALL_UNITS.append(MILLIPASCAL)
GAUSS = UnitDescriptor('gauss', '76', '''Gs''')
ALL_UNITS.append(GAUSS)
MILLI_INCH = UnitDescriptor('milli-inch', '77', '''mil''')
ALL_UNITS.append(MILLI_INCH)
KILOGAUSS = UnitDescriptor('kilogauss', '78', '''kGs''')
ALL_UNITS.append(KILOGAUSS)
POUND_PER_SQUARE_INCH_ABSOLUTE = UnitDescriptor('pound per square inch absolute', '80', '''lb/in²''')
ALL_UNITS.append(POUND_PER_SQUARE_INCH_ABSOLUTE)
HENRY = UnitDescriptor('henry', '81', '''H''')
ALL_UNITS.append(HENRY)
KILOPOUND_FORCE_PER_SQUARE_INCH = UnitDescriptor('kilopound-force per square inch', '84', '''klbf/in²''')
ALL_UNITS.append(KILOPOUND_FORCE_PER_SQUARE_INCH)
FOOT_POUND_FORCE = UnitDescriptor('foot pound-force', '85', '''ft·lbf''')
ALL_UNITS.append(FOOT_POUND_FORCE)
POUND_PER_CUBIC_FOOT = UnitDescriptor('pound per cubic foot', '87', '''lb/ft³''')
ALL_UNITS.append(POUND_PER_CUBIC_FOOT)
POISE = UnitDescriptor('poise', '89', '''P''')
ALL_UNITS.append(POISE)
SAYBOLD_UNIVERSAL_SECOND = UnitDescriptor('Saybold universal second', '90', '''''')
ALL_UNITS.append(SAYBOLD_UNIVERSAL_SECOND)
STOKES = UnitDescriptor('stokes', '91', '''St''')
ALL_UNITS.append(STOKES)
CALORIE_PER_CUBIC_CENTIMETRE = UnitDescriptor('calorie per cubic centimetre', '92', '''''')
ALL_UNITS.append(CALORIE_PER_CUBIC_CENTIMETRE)
CALORIE_PER_GRAM = UnitDescriptor('calorie per gram', '93', '''cal/g''')
ALL_UNITS.append(CALORIE_PER_GRAM)
CURL_UNIT = UnitDescriptor('curl unit', '94', '''''')
ALL_UNITS.append(CURL_UNIT)
TWENTY_THOUSAND_GALLON_US_TANKCAR = UnitDescriptor('twenty thousand gallon (US) tankcar', '95', '''''')
ALL_UNITS.append(TWENTY_THOUSAND_GALLON_US_TANKCAR)
TEN_THOUSAND_GALLON_US_TANKCAR = UnitDescriptor('ten thousand gallon (US) tankcar', '96', '''''')
ALL_UNITS.append(TEN_THOUSAND_GALLON_US_TANKCAR)
TEN_KG_DRUM = UnitDescriptor('ten kg drum', '97', '''''')
ALL_UNITS.append(TEN_KG_DRUM)
FIFTEEN_KG_DRUM = UnitDescriptor('fifteen kg drum', '98', '''''')
ALL_UNITS.append(FIFTEEN_KG_DRUM)
CAR_MILE = UnitDescriptor('car mile', '1A', '''''')
ALL_UNITS.append(CAR_MILE)
CAR_COUNT = UnitDescriptor('car count', '1B', '''''')
ALL_UNITS.append(CAR_COUNT)
LOCOMOTIVE_COUNT = UnitDescriptor('locomotive count', '1C', '''''')
ALL_UNITS.append(LOCOMOTIVE_COUNT)
CABOOSE_COUNT = UnitDescriptor('caboose count', '1D', '''''')
ALL_UNITS.append(CABOOSE_COUNT)
EMPTY_CAR = UnitDescriptor('empty car', '1E', '''''')
ALL_UNITS.append(EMPTY_CAR)
TRAIN_MILE = UnitDescriptor('train mile', '1F', '''''')
ALL_UNITS.append(TRAIN_MILE)
FUEL_USAGE_GALLON_US = UnitDescriptor('fuel usage gallon (US)', '1G', '''''')
ALL_UNITS.append(FUEL_USAGE_GALLON_US)
CABOOSE_MILE = UnitDescriptor('caboose mile', '1H', '''''')
ALL_UNITS.append(CABOOSE_MILE)
FIXED_RATE = UnitDescriptor('fixed rate', '1I', '''''')
ALL_UNITS.append(FIXED_RATE)
TON_MILE = UnitDescriptor('ton mile', '1J', '''''')
ALL_UNITS.append(TON_MILE)
LOCOMOTIVE_MILE = UnitDescriptor('locomotive mile', '1K', '''''')
ALL_UNITS.append(LOCOMOTIVE_MILE)
TOTAL_CAR_COUNT = UnitDescriptor('total car count', '1L', '''''')
ALL_UNITS.append(TOTAL_CAR_COUNT)
TOTAL_CAR_MILE = UnitDescriptor('total car mile', '1M', '''''')
ALL_UNITS.append(TOTAL_CAR_MILE)
QUARTER_MILE = UnitDescriptor('quarter mile', '1X', '''''')
ALL_UNITS.append(QUARTER_MILE)
RADIAN_PER_SECOND = UnitDescriptor('radian per second', '2A', '''rad/s''')
ALL_UNITS.append(RADIAN_PER_SECOND)
RADIAN_PER_SECOND_SQUARED = UnitDescriptor('radian per second squared', '2B', '''rad/s²''')
ALL_UNITS.append(RADIAN_PER_SECOND_SQUARED)
ROENTGEN = UnitDescriptor('roentgen', '2C', '''R''')
ALL_UNITS.append(ROENTGEN)
VOLT_AC = UnitDescriptor('volt AC', '2G', '''V''')
ALL_UNITS.append(VOLT_AC)
VOLT_DC = UnitDescriptor('volt DC', '2H', '''V''')
ALL_UNITS.append(VOLT_DC)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR = UnitDescriptor('British thermal unit (international table) per hour', '2I', '''BtuIT/h''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR)
CUBIC_CENTIMETRE_PER_SECOND = UnitDescriptor('cubic centimetre per second', '2J', '''cm³/s''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_SECOND)
CUBIC_FOOT_PER_HOUR = UnitDescriptor('cubic foot per hour', '2K', '''ft³/h''')
ALL_UNITS.append(CUBIC_FOOT_PER_HOUR)
CUBIC_FOOT_PER_MINUTE = UnitDescriptor('cubic foot per minute', '2L', '''ft³/min''')
ALL_UNITS.append(CUBIC_FOOT_PER_MINUTE)
CENTIMETRE_PER_SECOND = UnitDescriptor('centimetre per second', '2M', '''cm/s''')
ALL_UNITS.append(CENTIMETRE_PER_SECOND)
DECIBEL = UnitDescriptor('decibel', '2N', '''dB''')
ALL_UNITS.append(DECIBEL)
KILOBYTE = UnitDescriptor('kilobyte', '2P', '''kbyte''')
ALL_UNITS.append(KILOBYTE)
KILOBECQUEREL = UnitDescriptor('kilobecquerel', '2Q', '''kBq''')
ALL_UNITS.append(KILOBECQUEREL)
KILOCURIE = UnitDescriptor('kilocurie', '2R', '''kCi''')
ALL_UNITS.append(KILOCURIE)
MEGAGRAM = UnitDescriptor('megagram', '2U', '''Mg''')
ALL_UNITS.append(MEGAGRAM)
MEGAGRAM_PER_HOUR = UnitDescriptor('megagram per hour', '2V', '''Mg/h''')
ALL_UNITS.append(MEGAGRAM_PER_HOUR)
BIN = UnitDescriptor('bin', '2W', '''''')
ALL_UNITS.append(BIN)
METRE_PER_MINUTE = UnitDescriptor('metre per minute', '2X', '''m/min''')
ALL_UNITS.append(METRE_PER_MINUTE)
MILLIROENTGEN = UnitDescriptor('milliroentgen', '2Y', '''mR''')
ALL_UNITS.append(MILLIROENTGEN)
MILLIVOLT = UnitDescriptor('millivolt', '2Z', '''mV''')
ALL_UNITS.append(MILLIVOLT)
MEGAJOULE = UnitDescriptor('megajoule', '3B', '''MJ''')
ALL_UNITS.append(MEGAJOULE)
MANMONTH = UnitDescriptor('manmonth', '3C', '''''')
ALL_UNITS.append(MANMONTH)
POUND_PER_POUND_OF_PRODUCT = UnitDescriptor('pound per pound of product', '3E', '''''')
ALL_UNITS.append(POUND_PER_POUND_OF_PRODUCT)
POUND_PER_PIECE_OF_PRODUCT = UnitDescriptor('pound per piece of product', '3G', '''''')
ALL_UNITS.append(POUND_PER_PIECE_OF_PRODUCT)
KILOGRAM_PER_KILOGRAM_OF_PRODUCT = UnitDescriptor('kilogram per kilogram of product', '3H', '''''')
ALL_UNITS.append(KILOGRAM_PER_KILOGRAM_OF_PRODUCT)
KILOGRAM_PER_PIECE_OF_PRODUCT = UnitDescriptor('kilogram per piece of product', '3I', '''''')
ALL_UNITS.append(KILOGRAM_PER_PIECE_OF_PRODUCT)
BOBBIN = UnitDescriptor('bobbin', '4A', '''''')
ALL_UNITS.append(BOBBIN)
CAP = UnitDescriptor('cap', '4B', '''''')
ALL_UNITS.append(CAP)
CENTISTOKES = UnitDescriptor('centistokes', '4C', '''cSt''')
ALL_UNITS.append(CENTISTOKES)
TWENTY_PACK = UnitDescriptor('twenty pack', '4E', '''''')
ALL_UNITS.append(TWENTY_PACK)
MICROLITRE = UnitDescriptor('microlitre', '4G', '''µl''')
ALL_UNITS.append(MICROLITRE)
MICROMETRE_MICRON = UnitDescriptor('micrometre (micron)', '4H', '''µm''')
ALL_UNITS.append(MICROMETRE_MICRON)
MILLIAMPERE = UnitDescriptor('milliampere', '4K', '''mA''')
ALL_UNITS.append(MILLIAMPERE)
MEGABYTE = UnitDescriptor('megabyte', '4L', '''Mbyte''')
ALL_UNITS.append(MEGABYTE)
MILLIGRAM_PER_HOUR = UnitDescriptor('milligram per hour', '4M', '''mg/h''')
ALL_UNITS.append(MILLIGRAM_PER_HOUR)
MEGABECQUEREL = UnitDescriptor('megabecquerel', '4N', '''MBq''')
ALL_UNITS.append(MEGABECQUEREL)
MICROFARAD = UnitDescriptor('microfarad', '4O', '''µF''')
ALL_UNITS.append(MICROFARAD)
NEWTON_PER_METRE = UnitDescriptor('newton per metre', '4P', '''N/m''')
ALL_UNITS.append(NEWTON_PER_METRE)
OUNCE_INCH = UnitDescriptor('ounce inch', '4Q', '''oz·in''')
ALL_UNITS.append(OUNCE_INCH)
OUNCE_FOOT = UnitDescriptor('ounce foot', '4R', '''oz·ft''')
ALL_UNITS.append(OUNCE_FOOT)
PICOFARAD = UnitDescriptor('picofarad', '4T', '''pF''')
ALL_UNITS.append(PICOFARAD)
POUND_PER_HOUR = UnitDescriptor('pound per hour', '4U', '''lb/h''')
ALL_UNITS.append(POUND_PER_HOUR)
TON_US_PER_HOUR = UnitDescriptor('ton (US) per hour', '4W', '''ton (US) /h''')
ALL_UNITS.append(TON_US_PER_HOUR)
KILOLITRE_PER_HOUR = UnitDescriptor('kilolitre per hour', '4X', '''kl/h''')
ALL_UNITS.append(KILOLITRE_PER_HOUR)
BARREL_US_PER_MINUTE = UnitDescriptor('barrel (US) per minute', '5A', '''barrel (US)/min''')
ALL_UNITS.append(BARREL_US_PER_MINUTE)
BATCH = UnitDescriptor('batch', '5B', '''''')
ALL_UNITS.append(BATCH)
GALLONUS_PER_THOUSAND = UnitDescriptor('gallon(US) per thousand', '5C', '''''')
ALL_UNITS.append(GALLONUS_PER_THOUSAND)
MMSCF_PER_DAY = UnitDescriptor('MMSCF/day', '5E', '''''')
ALL_UNITS.append(MMSCF_PER_DAY)
POUND_PER_THOUSAND = UnitDescriptor('pound per thousand', '5F', '''''')
ALL_UNITS.append(POUND_PER_THOUSAND)
PUMP = UnitDescriptor('pump', '5G', '''''')
ALL_UNITS.append(PUMP)
STAGE = UnitDescriptor('stage', '5H', '''''')
ALL_UNITS.append(STAGE)
STANDARD_CUBIC_FOOT = UnitDescriptor('standard cubic foot', '5I', '''std''')
ALL_UNITS.append(STANDARD_CUBIC_FOOT)
HYDRAULIC_HORSE_POWER = UnitDescriptor('hydraulic horse power', '5J', '''''')
ALL_UNITS.append(HYDRAULIC_HORSE_POWER)
COUNT_PER_MINUTE = UnitDescriptor('count per minute', '5K', '''''')
ALL_UNITS.append(COUNT_PER_MINUTE)
SEISMIC_LEVEL = UnitDescriptor('seismic level', '5P', '''''')
ALL_UNITS.append(SEISMIC_LEVEL)
SEISMIC_LINE = UnitDescriptor('seismic line', '5Q', '''''')
ALL_UNITS.append(SEISMIC_LINE)
FIFTEEN_DEG_C_CALORIE = UnitDescriptor('15 °C calorie', 'A1', '''cal₁₅''')
ALL_UNITS.append(FIFTEEN_DEG_C_CALORIE)
AMPERE_SQUARE_METRE_PER_JOULE_SECOND = UnitDescriptor('ampere square metre per joule second', 'A10', '''A·m²/(J·s)''')
ALL_UNITS.append(AMPERE_SQUARE_METRE_PER_JOULE_SECOND)
ANGSTROM = UnitDescriptor('angstrom', 'A11', '''Å''')
ALL_UNITS.append(ANGSTROM)
ASTRONOMICAL_UNIT = UnitDescriptor('astronomical unit', 'A12', '''ua''')
ALL_UNITS.append(ASTRONOMICAL_UNIT)
ATTOJOULE = UnitDescriptor('attojoule', 'A13', '''aJ''')
ALL_UNITS.append(ATTOJOULE)
BARN = UnitDescriptor('barn', 'A14', '''b''')
ALL_UNITS.append(BARN)
BARN_PER_ELECTRONVOLT = UnitDescriptor('barn per electronvolt', 'A15', '''b/eV''')
ALL_UNITS.append(BARN_PER_ELECTRONVOLT)
BARN_PER_STERADIAN_ELECTRONVOLT = UnitDescriptor('barn per steradian electronvolt', 'A16', '''b/(sr·eV)''')
ALL_UNITS.append(BARN_PER_STERADIAN_ELECTRONVOLT)
BARN_PER_STERADIAN = UnitDescriptor('barn per steradian', 'A17', '''b/sr''')
ALL_UNITS.append(BARN_PER_STERADIAN)
BECQUEREL_PER_KILOGRAM = UnitDescriptor('becquerel per kilogram', 'A18', '''Bq/kg''')
ALL_UNITS.append(BECQUEREL_PER_KILOGRAM)
BECQUEREL_PER_CUBIC_METRE = UnitDescriptor('becquerel per cubic metre', 'A19', '''Bq/m³''')
ALL_UNITS.append(BECQUEREL_PER_CUBIC_METRE)
AMPERE_PER_CENTIMETRE = UnitDescriptor('ampere per centimetre', 'A2', '''A/cm''')
ALL_UNITS.append(AMPERE_PER_CENTIMETRE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_RANKINE = UnitDescriptor('British thermal unit (international table) per second square foot degree Rankine', 'A20', '''BtuIT/(s·ft²·°R)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_RANKINE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_RANKINE = UnitDescriptor('British thermal unit (international table) per pound degree Rankine', 'A21', '''BtuIT/(lb·°R)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_RANKINE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_FOOT_DEGREE_RANKINE = UnitDescriptor('British thermal unit (international table) per second foot degree Rankine', 'A22', '''BtuIT/(s·ft·°R)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_FOOT_DEGREE_RANKINE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_RANKINE = UnitDescriptor('British thermal unit (international table) per hour square foot degree Rankine', 'A23', '''BtuIT/(h·ft²·°R)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_RANKINE)
CANDELA_PER_SQUARE_METRE = UnitDescriptor('candela per square metre', 'A24', '''cd/m²''')
ALL_UNITS.append(CANDELA_PER_SQUARE_METRE)
CHEVAL_VAPEUR = UnitDescriptor('cheval vapeur', 'A25', '''CV''')
ALL_UNITS.append(CHEVAL_VAPEUR)
COULOMB_METRE = UnitDescriptor('coulomb metre', 'A26', '''C·m''')
ALL_UNITS.append(COULOMB_METRE)
COULOMB_METRE_SQUARED_PER_VOLT = UnitDescriptor('coulomb metre squared per volt', 'A27', '''C·m²/V''')
ALL_UNITS.append(COULOMB_METRE_SQUARED_PER_VOLT)
COULOMB_PER_CUBIC_CENTIMETRE = UnitDescriptor('coulomb per cubic centimetre', 'A28', '''C/cm³''')
ALL_UNITS.append(COULOMB_PER_CUBIC_CENTIMETRE)
COULOMB_PER_CUBIC_METRE = UnitDescriptor('coulomb per cubic metre', 'A29', '''C/m³''')
ALL_UNITS.append(COULOMB_PER_CUBIC_METRE)
AMPERE_PER_MILLIMETRE = UnitDescriptor('ampere per millimetre', 'A3', '''A/mm''')
ALL_UNITS.append(AMPERE_PER_MILLIMETRE)
COULOMB_PER_CUBIC_MILLIMETRE = UnitDescriptor('coulomb per cubic millimetre', 'A30', '''C/mm³''')
ALL_UNITS.append(COULOMB_PER_CUBIC_MILLIMETRE)
COULOMB_PER_KILOGRAM_SECOND = UnitDescriptor('coulomb per kilogram second', 'A31', '''C/(kg·s)''')
ALL_UNITS.append(COULOMB_PER_KILOGRAM_SECOND)
COULOMB_PER_MOLE = UnitDescriptor('coulomb per mole', 'A32', '''C/mol''')
ALL_UNITS.append(COULOMB_PER_MOLE)
COULOMB_PER_SQUARE_CENTIMETRE = UnitDescriptor('coulomb per square centimetre', 'A33', '''C/cm²''')
ALL_UNITS.append(COULOMB_PER_SQUARE_CENTIMETRE)
COULOMB_PER_SQUARE_METRE = UnitDescriptor('coulomb per square metre', 'A34', '''C/m²''')
ALL_UNITS.append(COULOMB_PER_SQUARE_METRE)
COULOMB_PER_SQUARE_MILLIMETRE = UnitDescriptor('coulomb per square millimetre', 'A35', '''C/mm²''')
ALL_UNITS.append(COULOMB_PER_SQUARE_MILLIMETRE)
CUBIC_CENTIMETRE_PER_MOLE = UnitDescriptor('cubic centimetre per mole', 'A36', '''cm³/mol''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_MOLE)
CUBIC_DECIMETRE_PER_MOLE = UnitDescriptor('cubic decimetre per mole', 'A37', '''dm³/mol''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_MOLE)
CUBIC_METRE_PER_COULOMB = UnitDescriptor('cubic metre per coulomb', 'A38', '''m³/C''')
ALL_UNITS.append(CUBIC_METRE_PER_COULOMB)
CUBIC_METRE_PER_KILOGRAM = UnitDescriptor('cubic metre per kilogram', 'A39', '''m³/kg''')
ALL_UNITS.append(CUBIC_METRE_PER_KILOGRAM)
AMPERE_PER_SQUARE_CENTIMETRE = UnitDescriptor('ampere per square centimetre', 'A4', '''A/cm²''')
ALL_UNITS.append(AMPERE_PER_SQUARE_CENTIMETRE)
CUBIC_METRE_PER_MOLE = UnitDescriptor('cubic metre per mole', 'A40', '''m³/mol''')
ALL_UNITS.append(CUBIC_METRE_PER_MOLE)
AMPERE_PER_SQUARE_METRE = UnitDescriptor('ampere per square metre', 'A41', '''A/m²''')
ALL_UNITS.append(AMPERE_PER_SQUARE_METRE)
CURIE_PER_KILOGRAM = UnitDescriptor('curie per kilogram', 'A42', '''Ci/kg''')
ALL_UNITS.append(CURIE_PER_KILOGRAM)
DEADWEIGHT_TONNAGE = UnitDescriptor('deadweight tonnage', 'A43', '''dwt''')
ALL_UNITS.append(DEADWEIGHT_TONNAGE)
DECALITRE = UnitDescriptor('decalitre', 'A44', '''dal''')
ALL_UNITS.append(DECALITRE)
DECAMETRE = UnitDescriptor('decametre', 'A45', '''dam''')
ALL_UNITS.append(DECAMETRE)
DECITEX = UnitDescriptor('decitex', 'A47', '''dtex (g/10km)''')
ALL_UNITS.append(DECITEX)
DEGREE_RANKINE = UnitDescriptor('degree Rankine', 'A48', '''°R''')
ALL_UNITS.append(DEGREE_RANKINE)
DENIER = UnitDescriptor('denier', 'A49', '''den (g/9 km)''')
ALL_UNITS.append(DENIER)
AMPERE_SQUARE_METRE = UnitDescriptor('ampere square metre', 'A5', '''A·m²''')
ALL_UNITS.append(AMPERE_SQUARE_METRE)
DYNE_SECOND_PER_CUBIC_CENTIMETRE = UnitDescriptor('dyne second per cubic centimetre', 'A50', '''dyn·s/cm³''')
ALL_UNITS.append(DYNE_SECOND_PER_CUBIC_CENTIMETRE)
DYNE_SECOND_PER_CENTIMETRE = UnitDescriptor('dyne second per centimetre', 'A51', '''dyn·s/cm''')
ALL_UNITS.append(DYNE_SECOND_PER_CENTIMETRE)
DYNE_SECOND_PER_CENTIMETRE_TO_THE_FIFTH_POWER = UnitDescriptor('dyne second per centimetre to the fifth power', 'A52', '''dyn·s/cm⁵''')
ALL_UNITS.append(DYNE_SECOND_PER_CENTIMETRE_TO_THE_FIFTH_POWER)
ELECTRONVOLT = UnitDescriptor('electronvolt', 'A53', '''eV''')
ALL_UNITS.append(ELECTRONVOLT)
ELECTRONVOLT_PER_METRE = UnitDescriptor('electronvolt per metre', 'A54', '''eV/m''')
ALL_UNITS.append(ELECTRONVOLT_PER_METRE)
ELECTRONVOLT_SQUARE_METRE = UnitDescriptor('electronvolt square metre', 'A55', '''eV·m²''')
ALL_UNITS.append(ELECTRONVOLT_SQUARE_METRE)
ELECTRONVOLT_SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('electronvolt square metre per kilogram', 'A56', '''eV·m²/kg''')
ALL_UNITS.append(ELECTRONVOLT_SQUARE_METRE_PER_KILOGRAM)
ERG = UnitDescriptor('erg', 'A57', '''erg''')
ALL_UNITS.append(ERG)
ERG_PER_CENTIMETRE = UnitDescriptor('erg per centimetre', 'A58', '''erg/cm''')
ALL_UNITS.append(ERG_PER_CENTIMETRE)
EIGHT_PART_CLOUD_COVER = UnitDescriptor('8-part cloud cover', 'A59', '''''')
ALL_UNITS.append(EIGHT_PART_CLOUD_COVER)
AMPERE_PER_SQUARE_METRE_KELVIN_SQUARED = UnitDescriptor('ampere per square metre kelvin squared', 'A6', '''A/(m²·K²)''')
ALL_UNITS.append(AMPERE_PER_SQUARE_METRE_KELVIN_SQUARED)
ERG_PER_CUBIC_CENTIMETRE = UnitDescriptor('erg per cubic centimetre', 'A60', '''erg/cm³''')
ALL_UNITS.append(ERG_PER_CUBIC_CENTIMETRE)
ERG_PER_GRAM = UnitDescriptor('erg per gram', 'A61', '''erg/g''')
ALL_UNITS.append(ERG_PER_GRAM)
ERG_PER_GRAM_SECOND = UnitDescriptor('erg per gram second', 'A62', '''erg/g·s''')
ALL_UNITS.append(ERG_PER_GRAM_SECOND)
ERG_PER_SECOND = UnitDescriptor('erg per second', 'A63', '''erg/s''')
ALL_UNITS.append(ERG_PER_SECOND)
ERG_PER_SECOND_SQUARE_CENTIMETRE = UnitDescriptor('erg per second square centimetre', 'A64', '''erg/(s·cm²)''')
ALL_UNITS.append(ERG_PER_SECOND_SQUARE_CENTIMETRE)
ERG_PER_SQUARE_CENTIMETRE_SECOND = UnitDescriptor('erg per square centimetre second', 'A65', '''erg/(cm²·s)''')
ALL_UNITS.append(ERG_PER_SQUARE_CENTIMETRE_SECOND)
ERG_SQUARE_CENTIMETRE = UnitDescriptor('erg square centimetre', 'A66', '''erg·cm²''')
ALL_UNITS.append(ERG_SQUARE_CENTIMETRE)
ERG_SQUARE_CENTIMETRE_PER_GRAM = UnitDescriptor('erg square centimetre per gram', 'A67', '''erg·cm²/g''')
ALL_UNITS.append(ERG_SQUARE_CENTIMETRE_PER_GRAM)
EXAJOULE = UnitDescriptor('exajoule', 'A68', '''EJ''')
ALL_UNITS.append(EXAJOULE)
FARAD_PER_METRE = UnitDescriptor('farad per metre', 'A69', '''F/m''')
ALL_UNITS.append(FARAD_PER_METRE)
AMPERE_PER_SQUARE_MILLIMETRE = UnitDescriptor('ampere per square millimetre', 'A7', '''A/mm²''')
ALL_UNITS.append(AMPERE_PER_SQUARE_MILLIMETRE)
FEMTOJOULE = UnitDescriptor('femtojoule', 'A70', '''fJ''')
ALL_UNITS.append(FEMTOJOULE)
FEMTOMETRE = UnitDescriptor('femtometre', 'A71', '''fm''')
ALL_UNITS.append(FEMTOMETRE)
FOOT_PER_SECOND_SQUARED = UnitDescriptor('foot per second squared', 'A73', '''ft/s²''')
ALL_UNITS.append(FOOT_PER_SECOND_SQUARED)
FOOT_POUND_FORCE_PER_SECOND = UnitDescriptor('foot pound-force per second', 'A74', '''ft·lbf/s''')
ALL_UNITS.append(FOOT_POUND_FORCE_PER_SECOND)
FREIGHT_TON = UnitDescriptor('freight ton', 'A75', '''''')
ALL_UNITS.append(FREIGHT_TON)
GAL = UnitDescriptor('gal', 'A76', '''Gal''')
ALL_UNITS.append(GAL)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_DISPLACEMENT = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of displacement', 'A77', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_DISPLACEMENT)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_CURRENT = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of electric current', 'A78', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_CURRENT)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_CHARGE = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of electric charge', 'A79', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_CHARGE)
AMPERE_SECOND = UnitDescriptor('ampere second', 'A8', '''A·s''')
ALL_UNITS.append(AMPERE_SECOND)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_FIELD_STRENGTH = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of electric field strength', 'A80', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_FIELD_STRENGTH)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_POLARIZATION = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of electric polarization', 'A81', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_POLARIZATION)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_POTENTIAL = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of electric potential', 'A82', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_ELECTRIC_POTENTIAL)
GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_MAGNETIZATION = UnitDescriptor('Gaussian CGS (Centimetre-Gram-Second system) unit of magnetization', 'A83', '''''')
ALL_UNITS.append(GAUSSIAN_CGS_CENTIMETRE_GRAM_SECOND_SYSTEM_UNIT_OF_MAGNETIZATION)
GIGACOULOMB_PER_CUBIC_METRE = UnitDescriptor('gigacoulomb per cubic metre', 'A84', '''GC/m³''')
ALL_UNITS.append(GIGACOULOMB_PER_CUBIC_METRE)
GIGAELECTRONVOLT = UnitDescriptor('gigaelectronvolt', 'A85', '''GeV''')
ALL_UNITS.append(GIGAELECTRONVOLT)
GIGAHERTZ = UnitDescriptor('gigahertz', 'A86', '''GHz''')
ALL_UNITS.append(GIGAHERTZ)
GIGAOHM = UnitDescriptor('gigaohm', 'A87', '''GΩ''')
ALL_UNITS.append(GIGAOHM)
GIGAOHM_METRE = UnitDescriptor('gigaohm metre', 'A88', '''GΩ·m''')
ALL_UNITS.append(GIGAOHM_METRE)
GIGAPASCAL = UnitDescriptor('gigapascal', 'A89', '''GPa''')
ALL_UNITS.append(GIGAPASCAL)
RATE = UnitDescriptor('rate', 'A9', '''''')
ALL_UNITS.append(RATE)
GIGAWATT = UnitDescriptor('gigawatt', 'A90', '''GW''')
ALL_UNITS.append(GIGAWATT)
GON = UnitDescriptor('gon', 'A91', '''gon''')
ALL_UNITS.append(GON)
GRAM_PER_CUBIC_METRE = UnitDescriptor('gram per cubic metre', 'A93', '''g/m³''')
ALL_UNITS.append(GRAM_PER_CUBIC_METRE)
GRAM_PER_MOLE = UnitDescriptor('gram per mole', 'A94', '''g/mol''')
ALL_UNITS.append(GRAM_PER_MOLE)
GRAY = UnitDescriptor('gray', 'A95', '''Gy''')
ALL_UNITS.append(GRAY)
GRAY_PER_SECOND = UnitDescriptor('gray per second', 'A96', '''Gy/s''')
ALL_UNITS.append(GRAY_PER_SECOND)
HECTOPASCAL = UnitDescriptor('hectopascal', 'A97', '''hPa''')
ALL_UNITS.append(HECTOPASCAL)
HENRY_PER_METRE = UnitDescriptor('henry per metre', 'A98', '''H/m''')
ALL_UNITS.append(HENRY_PER_METRE)
BIT = UnitDescriptor('bit', 'A99', '''bit''')
ALL_UNITS.append(BIT)
BALL = UnitDescriptor('ball', 'AA', '''''')
ALL_UNITS.append(BALL)
BULK_PACK = UnitDescriptor('bulk pack', 'AB', '''pk''')
ALL_UNITS.append(BULK_PACK)
ACRE = UnitDescriptor('acre', 'ACR', '''acre''')
ALL_UNITS.append(ACRE)
ACTIVITY = UnitDescriptor('activity', 'ACT', '''''')
ALL_UNITS.append(ACTIVITY)
BYTE = UnitDescriptor('byte', 'AD', '''byte''')
ALL_UNITS.append(BYTE)
AMPERE_PER_METRE = UnitDescriptor('ampere per metre', 'AE', '''A/m''')
ALL_UNITS.append(AMPERE_PER_METRE)
ADDITIONAL_MINUTE = UnitDescriptor('additional minute', 'AH', '''''')
ALL_UNITS.append(ADDITIONAL_MINUTE)
AVERAGE_MINUTE_PER_CALL = UnitDescriptor('average minute per call', 'AI', '''''')
ALL_UNITS.append(AVERAGE_MINUTE_PER_CALL)
COP = UnitDescriptor('cop', 'AJ', '''''')
ALL_UNITS.append(COP)
FATHOM = UnitDescriptor('fathom', 'AK', '''fth''')
ALL_UNITS.append(FATHOM)
ACCESS_LINE = UnitDescriptor('access line', 'AL', '''''')
ALL_UNITS.append(ACCESS_LINE)
AMPOULE = UnitDescriptor('ampoule', 'AM', '''''')
ALL_UNITS.append(AMPOULE)
AMPERE_HOUR = UnitDescriptor('ampere hour', 'AMH', '''A·h''')
ALL_UNITS.append(AMPERE_HOUR)
AMPERE = UnitDescriptor('ampere', 'AMP', '''A''')
ALL_UNITS.append(AMPERE)
YEAR = UnitDescriptor('year', 'ANN', '''y''')
ALL_UNITS.append(YEAR)
ALUMINIUM_POUND_ONLY = UnitDescriptor('aluminium pound only', 'AP', '''''')
ALL_UNITS.append(ALUMINIUM_POUND_ONLY)
TROY_OUNCE_OR_APOTHECARY_OUNCE = UnitDescriptor('troy ounce or apothecary ounce', 'APZ', '''tr oz''')
ALL_UNITS.append(TROY_OUNCE_OR_APOTHECARY_OUNCE)
ANTI_HEMOPHILIC_FACTOR_AHF_UNIT = UnitDescriptor('anti-hemophilic factor (AHF) unit', 'AQ', '''''')
ALL_UNITS.append(ANTI_HEMOPHILIC_FACTOR_AHF_UNIT)
SUPPOSITORY = UnitDescriptor('suppository', 'AR', '''''')
ALL_UNITS.append(SUPPOSITORY)
ARE = UnitDescriptor('are', 'ARE', '''a''')
ALL_UNITS.append(ARE)
ASSORTMENT = UnitDescriptor('assortment', 'AS', '''''')
ALL_UNITS.append(ASSORTMENT)
ALCOHOLIC_STRENGTH_BY_MASS = UnitDescriptor('alcoholic strength by mass', 'ASM', '''''')
ALL_UNITS.append(ALCOHOLIC_STRENGTH_BY_MASS)
ALCOHOLIC_STRENGTH_BY_VOLUME = UnitDescriptor('alcoholic strength by volume', 'ASU', '''''')
ALL_UNITS.append(ALCOHOLIC_STRENGTH_BY_VOLUME)
STANDARD_ATMOSPHERE = UnitDescriptor('standard atmosphere', 'ATM', '''atm''')
ALL_UNITS.append(STANDARD_ATMOSPHERE)
TECHNICAL_ATMOSPHERE = UnitDescriptor('technical atmosphere', 'ATT', '''at''')
ALL_UNITS.append(TECHNICAL_ATMOSPHERE)
CAPSULE = UnitDescriptor('capsule', 'AV', '''''')
ALL_UNITS.append(CAPSULE)
POWDER_FILLED_VIAL = UnitDescriptor('powder filled vial', 'AW', '''''')
ALL_UNITS.append(POWDER_FILLED_VIAL)
AMERICAN_WIRE_GAUGE = UnitDescriptor('american wire gauge', 'AWG', '''AWG''')
ALL_UNITS.append(AMERICAN_WIRE_GAUGE)
ASSEMBLY = UnitDescriptor('assembly', 'AY', '''''')
ALL_UNITS.append(ASSEMBLY)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND = UnitDescriptor('British thermal unit (international table) per pound', 'AZ', '''BtuIT/lb''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND)
BTU_PER_CUBIC_FOOT = UnitDescriptor('Btu per cubic foot', 'B0', '''BTU/ft³''')
ALL_UNITS.append(BTU_PER_CUBIC_FOOT)
BARREL_US_PER_DAY = UnitDescriptor('barrel (US) per day', 'B1', '''barrel (US)/d''')
ALL_UNITS.append(BARREL_US_PER_DAY)
BIT_PER_SECOND = UnitDescriptor('bit per second', 'B10', '''bit/s''')
ALL_UNITS.append(BIT_PER_SECOND)
JOULE_PER_KILOGRAM_KELVIN = UnitDescriptor('joule per kilogram kelvin', 'B11', '''J/(kg·K)''')
ALL_UNITS.append(JOULE_PER_KILOGRAM_KELVIN)
JOULE_PER_METRE = UnitDescriptor('joule per metre', 'B12', '''J/m''')
ALL_UNITS.append(JOULE_PER_METRE)
JOULE_PER_SQUARE_METRE = UnitDescriptor('joule per square metre', 'B13', '''J/m²''')
ALL_UNITS.append(JOULE_PER_SQUARE_METRE)
JOULE_PER_METRE_TO_THE_FOURTH_POWER = UnitDescriptor('joule per metre to the fourth power', 'B14', '''J/m⁴''')
ALL_UNITS.append(JOULE_PER_METRE_TO_THE_FOURTH_POWER)
JOULE_PER_MOLE = UnitDescriptor('joule per mole', 'B15', '''J/mol''')
ALL_UNITS.append(JOULE_PER_MOLE)
JOULE_PER_MOLE_KELVIN = UnitDescriptor('joule per mole kelvin', 'B16', '''J/(mol·K)''')
ALL_UNITS.append(JOULE_PER_MOLE_KELVIN)
CREDIT = UnitDescriptor('credit', 'B17', '''''')
ALL_UNITS.append(CREDIT)
JOULE_SECOND = UnitDescriptor('joule second', 'B18', '''J·s''')
ALL_UNITS.append(JOULE_SECOND)
DIGIT = UnitDescriptor('digit', 'B19', '''''')
ALL_UNITS.append(DIGIT)
BUNK = UnitDescriptor('bunk', 'B2', '''''')
ALL_UNITS.append(BUNK)
JOULE_SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('joule square metre per kilogram', 'B20', '''J·m²/kg''')
ALL_UNITS.append(JOULE_SQUARE_METRE_PER_KILOGRAM)
KELVIN_PER_WATT = UnitDescriptor('kelvin per watt', 'B21', '''K/W''')
ALL_UNITS.append(KELVIN_PER_WATT)
KILOAMPERE = UnitDescriptor('kiloampere', 'B22', '''kA''')
ALL_UNITS.append(KILOAMPERE)
KILOAMPERE_PER_SQUARE_METRE = UnitDescriptor('kiloampere per square metre', 'B23', '''kA/m²''')
ALL_UNITS.append(KILOAMPERE_PER_SQUARE_METRE)
KILOAMPERE_PER_METRE = UnitDescriptor('kiloampere per metre', 'B24', '''kA/m''')
ALL_UNITS.append(KILOAMPERE_PER_METRE)
KILOBECQUEREL_PER_KILOGRAM = UnitDescriptor('kilobecquerel per kilogram', 'B25', '''kBq/kg''')
ALL_UNITS.append(KILOBECQUEREL_PER_KILOGRAM)
KILOCOULOMB = UnitDescriptor('kilocoulomb', 'B26', '''kC''')
ALL_UNITS.append(KILOCOULOMB)
KILOCOULOMB_PER_CUBIC_METRE = UnitDescriptor('kilocoulomb per cubic metre', 'B27', '''kC/m³''')
ALL_UNITS.append(KILOCOULOMB_PER_CUBIC_METRE)
KILOCOULOMB_PER_SQUARE_METRE = UnitDescriptor('kilocoulomb per square metre', 'B28', '''kC/m²''')
ALL_UNITS.append(KILOCOULOMB_PER_SQUARE_METRE)
KILOELECTRONVOLT = UnitDescriptor('kiloelectronvolt', 'B29', '''keV''')
ALL_UNITS.append(KILOELECTRONVOLT)
BATTING_POUND = UnitDescriptor('batting pound', 'B3', '''''')
ALL_UNITS.append(BATTING_POUND)
GIBIBIT = UnitDescriptor('gibibit', 'B30', '''Gibit''')
ALL_UNITS.append(GIBIBIT)
KILOGRAM_METRE_PER_SECOND = UnitDescriptor('kilogram metre per second', 'B31', '''kg·m/s''')
ALL_UNITS.append(KILOGRAM_METRE_PER_SECOND)
KILOGRAM_METRE_SQUARED = UnitDescriptor('kilogram metre squared', 'B32', '''kg·m²''')
ALL_UNITS.append(KILOGRAM_METRE_SQUARED)
KILOGRAM_METRE_SQUARED_PER_SECOND = UnitDescriptor('kilogram metre squared per second', 'B33', '''kg·m²/s''')
ALL_UNITS.append(KILOGRAM_METRE_SQUARED_PER_SECOND)
KILOGRAM_PER_CUBIC_DECIMETRE = UnitDescriptor('kilogram per cubic decimetre', 'B34', '''kg/dm³''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_DECIMETRE)
KILOGRAM_PER_LITRE = UnitDescriptor('kilogram per litre', 'B35', '''kg/l''')
ALL_UNITS.append(KILOGRAM_PER_LITRE)
KILOGRAM_PER_LITRE = UnitDescriptor('kilogram per litre', 'B35', '''kg/L''')
ALL_UNITS.append(KILOGRAM_PER_LITRE)
CALORIE_THERMOCHEMICAL_PER_GRAM = UnitDescriptor('calorie (thermochemical) per gram', 'B36', '''calth/g''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_GRAM)
KILOGRAM_FORCE = UnitDescriptor('kilogram-force', 'B37', '''kgf''')
ALL_UNITS.append(KILOGRAM_FORCE)
KILOGRAM_FORCE_METRE = UnitDescriptor('kilogram-force metre', 'B38', '''kgf·m''')
ALL_UNITS.append(KILOGRAM_FORCE_METRE)
KILOGRAM_FORCE_METRE_PER_SECOND = UnitDescriptor('kilogram-force metre per second', 'B39', '''kgf·m/s''')
ALL_UNITS.append(KILOGRAM_FORCE_METRE_PER_SECOND)
BARREL_IMPERIAL = UnitDescriptor('barrel, imperial', 'B4', '''''')
ALL_UNITS.append(BARREL_IMPERIAL)
KILOGRAM_FORCE_PER_SQUARE_METRE = UnitDescriptor('kilogram-force per square metre', 'B40', '''kgf/m²''')
ALL_UNITS.append(KILOGRAM_FORCE_PER_SQUARE_METRE)
KILOJOULE_PER_KELVIN = UnitDescriptor('kilojoule per kelvin', 'B41', '''kJ/K''')
ALL_UNITS.append(KILOJOULE_PER_KELVIN)
KILOJOULE_PER_KILOGRAM = UnitDescriptor('kilojoule per kilogram', 'B42', '''kJ/kg''')
ALL_UNITS.append(KILOJOULE_PER_KILOGRAM)
KILOJOULE_PER_KILOGRAM_KELVIN = UnitDescriptor('kilojoule per kilogram kelvin', 'B43', '''kJ/(kg·K)''')
ALL_UNITS.append(KILOJOULE_PER_KILOGRAM_KELVIN)
KILOJOULE_PER_MOLE = UnitDescriptor('kilojoule per mole', 'B44', '''kJ/mol''')
ALL_UNITS.append(KILOJOULE_PER_MOLE)
KILOMOLE = UnitDescriptor('kilomole', 'B45', '''kmol''')
ALL_UNITS.append(KILOMOLE)
KILOMOLE_PER_CUBIC_METRE = UnitDescriptor('kilomole per cubic metre', 'B46', '''kmol/m³''')
ALL_UNITS.append(KILOMOLE_PER_CUBIC_METRE)
KILONEWTON = UnitDescriptor('kilonewton', 'B47', '''kN''')
ALL_UNITS.append(KILONEWTON)
KILONEWTON_METRE = UnitDescriptor('kilonewton metre', 'B48', '''kN·m''')
ALL_UNITS.append(KILONEWTON_METRE)
KILOOHM = UnitDescriptor('kiloohm', 'B49', '''kΩ''')
ALL_UNITS.append(KILOOHM)
BILLET = UnitDescriptor('billet', 'B5', '''''')
ALL_UNITS.append(BILLET)
KILOOHM_METRE = UnitDescriptor('kiloohm metre', 'B50', '''kΩ·m''')
ALL_UNITS.append(KILOOHM_METRE)
KILOPOND = UnitDescriptor('kilopond', 'B51', '''kp''')
ALL_UNITS.append(KILOPOND)
KILOSECOND = UnitDescriptor('kilosecond', 'B52', '''ks''')
ALL_UNITS.append(KILOSECOND)
KILOSIEMENS = UnitDescriptor('kilosiemens', 'B53', '''kS''')
ALL_UNITS.append(KILOSIEMENS)
KILOSIEMENS_PER_METRE = UnitDescriptor('kilosiemens per metre', 'B54', '''kS/m''')
ALL_UNITS.append(KILOSIEMENS_PER_METRE)
KILOVOLT_PER_METRE = UnitDescriptor('kilovolt per metre', 'B55', '''kV/m''')
ALL_UNITS.append(KILOVOLT_PER_METRE)
KILOWEBER_PER_METRE = UnitDescriptor('kiloweber per metre', 'B56', '''kWb/m''')
ALL_UNITS.append(KILOWEBER_PER_METRE)
LIGHT_YEAR = UnitDescriptor('light year', 'B57', '''ly''')
ALL_UNITS.append(LIGHT_YEAR)
LITRE_PER_MOLE = UnitDescriptor('litre per mole', 'B58', '''l/mol''')
ALL_UNITS.append(LITRE_PER_MOLE)
LUMEN_HOUR = UnitDescriptor('lumen hour', 'B59', '''lm·h''')
ALL_UNITS.append(LUMEN_HOUR)
BUN = UnitDescriptor('bun', 'B6', '''''')
ALL_UNITS.append(BUN)
LUMEN_PER_SQUARE_METRE = UnitDescriptor('lumen per square metre', 'B60', '''lm/m²''')
ALL_UNITS.append(LUMEN_PER_SQUARE_METRE)
LUMEN_PER_WATT = UnitDescriptor('lumen per watt', 'B61', '''lm/W''')
ALL_UNITS.append(LUMEN_PER_WATT)
LUMEN_SECOND = UnitDescriptor('lumen second', 'B62', '''lm·s''')
ALL_UNITS.append(LUMEN_SECOND)
LUX_HOUR = UnitDescriptor('lux hour', 'B63', '''lx·h''')
ALL_UNITS.append(LUX_HOUR)
LUX_SECOND = UnitDescriptor('lux second', 'B64', '''lx·s''')
ALL_UNITS.append(LUX_SECOND)
MAXWELL = UnitDescriptor('maxwell', 'B65', '''Mx''')
ALL_UNITS.append(MAXWELL)
MEGAAMPERE_PER_SQUARE_METRE = UnitDescriptor('megaampere per square metre', 'B66', '''MA/m²''')
ALL_UNITS.append(MEGAAMPERE_PER_SQUARE_METRE)
MEGABECQUEREL_PER_KILOGRAM = UnitDescriptor('megabecquerel per kilogram', 'B67', '''MBq/kg''')
ALL_UNITS.append(MEGABECQUEREL_PER_KILOGRAM)
GIGABIT = UnitDescriptor('gigabit', 'B68', '''Gbit''')
ALL_UNITS.append(GIGABIT)
MEGACOULOMB_PER_CUBIC_METRE = UnitDescriptor('megacoulomb per cubic metre', 'B69', '''MC/m³''')
ALL_UNITS.append(MEGACOULOMB_PER_CUBIC_METRE)
CYCLE = UnitDescriptor('cycle', 'B7', '''''')
ALL_UNITS.append(CYCLE)
MEGACOULOMB_PER_SQUARE_METRE = UnitDescriptor('megacoulomb per square metre', 'B70', '''MC/m²''')
ALL_UNITS.append(MEGACOULOMB_PER_SQUARE_METRE)
MEGAELECTRONVOLT = UnitDescriptor('megaelectronvolt', 'B71', '''MeV''')
ALL_UNITS.append(MEGAELECTRONVOLT)
MEGAGRAM_PER_CUBIC_METRE = UnitDescriptor('megagram per cubic metre', 'B72', '''Mg/m³''')
ALL_UNITS.append(MEGAGRAM_PER_CUBIC_METRE)
MEGANEWTON = UnitDescriptor('meganewton', 'B73', '''MN''')
ALL_UNITS.append(MEGANEWTON)
MEGANEWTON_METRE = UnitDescriptor('meganewton metre', 'B74', '''MN·m''')
ALL_UNITS.append(MEGANEWTON_METRE)
MEGAOHM = UnitDescriptor('megaohm', 'B75', '''MΩ''')
ALL_UNITS.append(MEGAOHM)
MEGAOHM_METRE = UnitDescriptor('megaohm metre', 'B76', '''MΩ·m''')
ALL_UNITS.append(MEGAOHM_METRE)
MEGASIEMENS_PER_METRE = UnitDescriptor('megasiemens per metre', 'B77', '''MS/m''')
ALL_UNITS.append(MEGASIEMENS_PER_METRE)
MEGAVOLT = UnitDescriptor('megavolt', 'B78', '''MV''')
ALL_UNITS.append(MEGAVOLT)
MEGAVOLT_PER_METRE = UnitDescriptor('megavolt per metre', 'B79', '''MV/m''')
ALL_UNITS.append(MEGAVOLT_PER_METRE)
JOULE_PER_CUBIC_METRE = UnitDescriptor('joule per cubic metre', 'B8', '''J/m³''')
ALL_UNITS.append(JOULE_PER_CUBIC_METRE)
GIGABIT_PER_SECOND = UnitDescriptor('gigabit per second', 'B80', '''Gbit/s''')
ALL_UNITS.append(GIGABIT_PER_SECOND)
RECIPROCAL_METRE_SQUARED_RECIPROCAL_SECOND = UnitDescriptor('reciprocal metre squared reciprocal second', 'B81', '''m⁻²/s''')
ALL_UNITS.append(RECIPROCAL_METRE_SQUARED_RECIPROCAL_SECOND)
INCH_PER_LINEAR_FOOT = UnitDescriptor('inch per linear foot', 'B82', '''''')
ALL_UNITS.append(INCH_PER_LINEAR_FOOT)
METRE_TO_THE_FOURTH_POWER = UnitDescriptor('metre to the fourth power', 'B83', '''m⁴''')
ALL_UNITS.append(METRE_TO_THE_FOURTH_POWER)
MICROAMPERE = UnitDescriptor('microampere', 'B84', '''µA''')
ALL_UNITS.append(MICROAMPERE)
MICROBAR = UnitDescriptor('microbar', 'B85', '''µbar''')
ALL_UNITS.append(MICROBAR)
MICROCOULOMB = UnitDescriptor('microcoulomb', 'B86', '''µC''')
ALL_UNITS.append(MICROCOULOMB)
MICROCOULOMB_PER_CUBIC_METRE = UnitDescriptor('microcoulomb per cubic metre', 'B87', '''µC/m³''')
ALL_UNITS.append(MICROCOULOMB_PER_CUBIC_METRE)
MICROCOULOMB_PER_SQUARE_METRE = UnitDescriptor('microcoulomb per square metre', 'B88', '''µC/m²''')
ALL_UNITS.append(MICROCOULOMB_PER_SQUARE_METRE)
MICROFARAD_PER_METRE = UnitDescriptor('microfarad per metre', 'B89', '''µF/m''')
ALL_UNITS.append(MICROFARAD_PER_METRE)
BATT = UnitDescriptor('batt', 'B9', '''''')
ALL_UNITS.append(BATT)
MICROHENRY = UnitDescriptor('microhenry', 'B90', '''µH''')
ALL_UNITS.append(MICROHENRY)
MICROHENRY_PER_METRE = UnitDescriptor('microhenry per metre', 'B91', '''µH/m''')
ALL_UNITS.append(MICROHENRY_PER_METRE)
MICRONEWTON = UnitDescriptor('micronewton', 'B92', '''µN''')
ALL_UNITS.append(MICRONEWTON)
MICRONEWTON_METRE = UnitDescriptor('micronewton metre', 'B93', '''µN·m''')
ALL_UNITS.append(MICRONEWTON_METRE)
MICROOHM = UnitDescriptor('microohm', 'B94', '''µΩ''')
ALL_UNITS.append(MICROOHM)
MICROOHM_METRE = UnitDescriptor('microohm metre', 'B95', '''µΩ·m''')
ALL_UNITS.append(MICROOHM_METRE)
MICROPASCAL = UnitDescriptor('micropascal', 'B96', '''µPa''')
ALL_UNITS.append(MICROPASCAL)
MICRORADIAN = UnitDescriptor('microradian', 'B97', '''µrad''')
ALL_UNITS.append(MICRORADIAN)
MICROSECOND = UnitDescriptor('microsecond', 'B98', '''µs''')
ALL_UNITS.append(MICROSECOND)
MICROSIEMENS = UnitDescriptor('microsiemens', 'B99', '''µS''')
ALL_UNITS.append(MICROSIEMENS)
BAR_UNIT_OF_PRESSURE = UnitDescriptor('bar [unit of pressure]', 'BAR', '''bar''')
ALL_UNITS.append(BAR_UNIT_OF_PRESSURE)
BASE_BOX = UnitDescriptor('base box', 'BB', '''''')
ALL_UNITS.append(BASE_BOX)
BOARD = UnitDescriptor('board', 'BD', '''''')
ALL_UNITS.append(BOARD)
BUNDLE = UnitDescriptor('bundle', 'BE', '''''')
ALL_UNITS.append(BUNDLE)
BOARD_FOOT = UnitDescriptor('board foot', 'BFT', '''fbm''')
ALL_UNITS.append(BOARD_FOOT)
BAG = UnitDescriptor('bag', 'BG', '''''')
ALL_UNITS.append(BAG)
BRUSH = UnitDescriptor('brush', 'BH', '''''')
ALL_UNITS.append(BRUSH)
BRAKE_HORSE_POWER = UnitDescriptor('brake horse power', 'BHP', '''BHP''')
ALL_UNITS.append(BRAKE_HORSE_POWER)
BILLION_EUR = UnitDescriptor('billion (EUR)', 'BIL', '''''')
ALL_UNITS.append(BILLION_EUR)
BUCKET = UnitDescriptor('bucket', 'BJ', '''''')
ALL_UNITS.append(BUCKET)
BASKET = UnitDescriptor('basket', 'BK', '''''')
ALL_UNITS.append(BASKET)
BALE = UnitDescriptor('bale', 'BL', '''''')
ALL_UNITS.append(BALE)
DRY_BARREL_US = UnitDescriptor('dry barrel (US)', 'BLD', '''bbl (US)''')
ALL_UNITS.append(DRY_BARREL_US)
BARREL_US = UnitDescriptor('barrel (US)', 'BLL', '''barrel (US)''')
ALL_UNITS.append(BARREL_US)
BOTTLE = UnitDescriptor('bottle', 'BO', '''''')
ALL_UNITS.append(BOTTLE)
HUNDRED_BOARD_FOOT = UnitDescriptor('hundred board foot', 'BP', '''''')
ALL_UNITS.append(HUNDRED_BOARD_FOOT)
BEATS_PER_MINUTE = UnitDescriptor('beats per minute', 'BPM', '''BPM''')
ALL_UNITS.append(BEATS_PER_MINUTE)
BECQUEREL = UnitDescriptor('becquerel', 'BQL', '''Bq''')
ALL_UNITS.append(BECQUEREL)
BAR_UNIT_OF_PACKAGING = UnitDescriptor('bar [unit of packaging]', 'BR', '''''')
ALL_UNITS.append(BAR_UNIT_OF_PACKAGING)
BOLT = UnitDescriptor('bolt', 'BT', '''''')
ALL_UNITS.append(BOLT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = UnitDescriptor('British thermal unit (international table)', 'BTU', '''BtuIT''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE)
BUSHEL_US = UnitDescriptor('bushel (US)', 'BUA', '''bu (US)''')
ALL_UNITS.append(BUSHEL_US)
BUSHEL_UK = UnitDescriptor('bushel (UK)', 'BUI', '''bushel (UK)''')
ALL_UNITS.append(BUSHEL_UK)
BASE_WEIGHT = UnitDescriptor('base weight', 'BW', '''''')
ALL_UNITS.append(BASE_WEIGHT)
BOX = UnitDescriptor('box', 'BX', '''''')
ALL_UNITS.append(BOX)
MILLION_BTUS = UnitDescriptor('million BTUs', 'BZ', '''''')
ALL_UNITS.append(MILLION_BTUS)
CALL = UnitDescriptor('call', 'C0', '''''')
ALL_UNITS.append(CALL)
COMPOSITE_PRODUCT_POUND_TOTAL_WEIGHT = UnitDescriptor('composite product pound (total weight)', 'C1', '''''')
ALL_UNITS.append(COMPOSITE_PRODUCT_POUND_TOTAL_WEIGHT)
MILLIFARAD = UnitDescriptor('millifarad', 'C10', '''mF''')
ALL_UNITS.append(MILLIFARAD)
MILLIGAL = UnitDescriptor('milligal', 'C11', '''mGal''')
ALL_UNITS.append(MILLIGAL)
MILLIGRAM_PER_METRE = UnitDescriptor('milligram per metre', 'C12', '''mg/m''')
ALL_UNITS.append(MILLIGRAM_PER_METRE)
MILLIGRAY = UnitDescriptor('milligray', 'C13', '''mGy''')
ALL_UNITS.append(MILLIGRAY)
MILLIHENRY = UnitDescriptor('millihenry', 'C14', '''mH''')
ALL_UNITS.append(MILLIHENRY)
MILLIJOULE = UnitDescriptor('millijoule', 'C15', '''mJ''')
ALL_UNITS.append(MILLIJOULE)
MILLIMETRE_PER_SECOND = UnitDescriptor('millimetre per second', 'C16', '''mm/s''')
ALL_UNITS.append(MILLIMETRE_PER_SECOND)
MILLIMETRE_SQUARED_PER_SECOND = UnitDescriptor('millimetre squared per second', 'C17', '''mm²/s''')
ALL_UNITS.append(MILLIMETRE_SQUARED_PER_SECOND)
MILLIMOLE = UnitDescriptor('millimole', 'C18', '''mmol''')
ALL_UNITS.append(MILLIMOLE)
MOLE_PER_KILOGRAM = UnitDescriptor('mole per kilogram', 'C19', '''mol/kg''')
ALL_UNITS.append(MOLE_PER_KILOGRAM)
CARSET = UnitDescriptor('carset', 'C2', '''''')
ALL_UNITS.append(CARSET)
MILLINEWTON = UnitDescriptor('millinewton', 'C20', '''mN''')
ALL_UNITS.append(MILLINEWTON)
KIBIBIT = UnitDescriptor('kibibit', 'C21', '''Kibit''')
ALL_UNITS.append(KIBIBIT)
MILLINEWTON_PER_METRE = UnitDescriptor('millinewton per metre', 'C22', '''mN/m''')
ALL_UNITS.append(MILLINEWTON_PER_METRE)
MILLIOHM_METRE = UnitDescriptor('milliohm metre', 'C23', '''mΩ·m''')
ALL_UNITS.append(MILLIOHM_METRE)
MILLIPASCAL_SECOND = UnitDescriptor('millipascal second', 'C24', '''mPa·s''')
ALL_UNITS.append(MILLIPASCAL_SECOND)
MILLIRADIAN = UnitDescriptor('milliradian', 'C25', '''mrad''')
ALL_UNITS.append(MILLIRADIAN)
MILLISECOND = UnitDescriptor('millisecond', 'C26', '''ms''')
ALL_UNITS.append(MILLISECOND)
MILLISIEMENS = UnitDescriptor('millisiemens', 'C27', '''mS''')
ALL_UNITS.append(MILLISIEMENS)
MILLISIEVERT = UnitDescriptor('millisievert', 'C28', '''mSv''')
ALL_UNITS.append(MILLISIEVERT)
MILLITESLA = UnitDescriptor('millitesla', 'C29', '''mT''')
ALL_UNITS.append(MILLITESLA)
MICROVOLT_PER_METRE = UnitDescriptor('microvolt per metre', 'C3', '''µV/m''')
ALL_UNITS.append(MICROVOLT_PER_METRE)
MILLIVOLT_PER_METRE = UnitDescriptor('millivolt per metre', 'C30', '''mV/m''')
ALL_UNITS.append(MILLIVOLT_PER_METRE)
MILLIWATT = UnitDescriptor('milliwatt', 'C31', '''mW''')
ALL_UNITS.append(MILLIWATT)
MILLIWATT_PER_SQUARE_METRE = UnitDescriptor('milliwatt per square metre', 'C32', '''mW/m²''')
ALL_UNITS.append(MILLIWATT_PER_SQUARE_METRE)
MILLIWEBER = UnitDescriptor('milliweber', 'C33', '''mWb''')
ALL_UNITS.append(MILLIWEBER)
MOLE = UnitDescriptor('mole', 'C34', '''mol''')
ALL_UNITS.append(MOLE)
MOLE_PER_CUBIC_DECIMETRE = UnitDescriptor('mole per cubic decimetre', 'C35', '''mol/dm³''')
ALL_UNITS.append(MOLE_PER_CUBIC_DECIMETRE)
MOLE_PER_CUBIC_METRE = UnitDescriptor('mole per cubic metre', 'C36', '''mol/m³''')
ALL_UNITS.append(MOLE_PER_CUBIC_METRE)
KILOBIT = UnitDescriptor('kilobit', 'C37', '''kbit''')
ALL_UNITS.append(KILOBIT)
MOLE_PER_LITRE = UnitDescriptor('mole per litre', 'C38', '''mol/l''')
ALL_UNITS.append(MOLE_PER_LITRE)
NANOAMPERE = UnitDescriptor('nanoampere', 'C39', '''nA''')
ALL_UNITS.append(NANOAMPERE)
CARLOAD = UnitDescriptor('carload', 'C4', '''''')
ALL_UNITS.append(CARLOAD)
NANOCOULOMB = UnitDescriptor('nanocoulomb', 'C40', '''nC''')
ALL_UNITS.append(NANOCOULOMB)
NANOFARAD = UnitDescriptor('nanofarad', 'C41', '''nF''')
ALL_UNITS.append(NANOFARAD)
NANOFARAD_PER_METRE = UnitDescriptor('nanofarad per metre', 'C42', '''nF/m''')
ALL_UNITS.append(NANOFARAD_PER_METRE)
NANOHENRY = UnitDescriptor('nanohenry', 'C43', '''nH''')
ALL_UNITS.append(NANOHENRY)
NANOHENRY_PER_METRE = UnitDescriptor('nanohenry per metre', 'C44', '''nH/m''')
ALL_UNITS.append(NANOHENRY_PER_METRE)
NANOMETRE = UnitDescriptor('nanometre', 'C45', '''nm''')
ALL_UNITS.append(NANOMETRE)
NANOOHM_METRE = UnitDescriptor('nanoohm metre', 'C46', '''nΩ·m''')
ALL_UNITS.append(NANOOHM_METRE)
NANOSECOND = UnitDescriptor('nanosecond', 'C47', '''ns''')
ALL_UNITS.append(NANOSECOND)
NANOTESLA = UnitDescriptor('nanotesla', 'C48', '''nT''')
ALL_UNITS.append(NANOTESLA)
NANOWATT = UnitDescriptor('nanowatt', 'C49', '''nW''')
ALL_UNITS.append(NANOWATT)
COST = UnitDescriptor('cost', 'C5', '''''')
ALL_UNITS.append(COST)
NEPER = UnitDescriptor('neper', 'C50', '''Np''')
ALL_UNITS.append(NEPER)
NEPER_PER_SECOND = UnitDescriptor('neper per second', 'C51', '''Np/s''')
ALL_UNITS.append(NEPER_PER_SECOND)
PICOMETRE = UnitDescriptor('picometre', 'C52', '''pm''')
ALL_UNITS.append(PICOMETRE)
NEWTON_METRE_SECOND = UnitDescriptor('newton metre second', 'C53', '''N·m·s''')
ALL_UNITS.append(NEWTON_METRE_SECOND)
NEWTON_METRE_SQUARED_PER_KILOGRAM_SQUARED = UnitDescriptor('newton metre squared per kilogram squared', 'C54', '''N·m²/kg²''')
ALL_UNITS.append(NEWTON_METRE_SQUARED_PER_KILOGRAM_SQUARED)
NEWTON_PER_SQUARE_METRE = UnitDescriptor('newton per square metre', 'C55', '''N/m²''')
ALL_UNITS.append(NEWTON_PER_SQUARE_METRE)
NEWTON_PER_SQUARE_MILLIMETRE = UnitDescriptor('newton per square millimetre', 'C56', '''N/mm²''')
ALL_UNITS.append(NEWTON_PER_SQUARE_MILLIMETRE)
NEWTON_SECOND = UnitDescriptor('newton second', 'C57', '''N·s''')
ALL_UNITS.append(NEWTON_SECOND)
NEWTON_SECOND_PER_METRE = UnitDescriptor('newton second per metre', 'C58', '''N·s/m''')
ALL_UNITS.append(NEWTON_SECOND_PER_METRE)
OCTAVE = UnitDescriptor('octave', 'C59', '''''')
ALL_UNITS.append(OCTAVE)
CELL = UnitDescriptor('cell', 'C6', '''''')
ALL_UNITS.append(CELL)
OHM_CENTIMETRE = UnitDescriptor('ohm centimetre', 'C60', '''Ω·cm''')
ALL_UNITS.append(OHM_CENTIMETRE)
OHM_METRE = UnitDescriptor('ohm metre', 'C61', '''Ω·m''')
ALL_UNITS.append(OHM_METRE)
ONE = UnitDescriptor('one', 'C62', '''1''')
ALL_UNITS.append(ONE)
PARSEC = UnitDescriptor('parsec', 'C63', '''pc''')
ALL_UNITS.append(PARSEC)
PASCAL_PER_KELVIN = UnitDescriptor('pascal per kelvin', 'C64', '''Pa/K''')
ALL_UNITS.append(PASCAL_PER_KELVIN)
PASCAL_SECOND = UnitDescriptor('pascal second', 'C65', '''Pa·s''')
ALL_UNITS.append(PASCAL_SECOND)
PASCAL_SECOND_PER_CUBIC_METRE = UnitDescriptor('pascal second per cubic metre', 'C66', '''Pa·s/m³''')
ALL_UNITS.append(PASCAL_SECOND_PER_CUBIC_METRE)
PASCAL_SECOND_PER_METRE = UnitDescriptor('pascal second per metre', 'C67', '''Pa· s/m''')
ALL_UNITS.append(PASCAL_SECOND_PER_METRE)
PETAJOULE = UnitDescriptor('petajoule', 'C68', '''PJ''')
ALL_UNITS.append(PETAJOULE)
PHON = UnitDescriptor('phon', 'C69', '''''')
ALL_UNITS.append(PHON)
CENTIPOISE = UnitDescriptor('centipoise', 'C7', '''cP''')
ALL_UNITS.append(CENTIPOISE)
PICOAMPERE = UnitDescriptor('picoampere', 'C70', '''pA''')
ALL_UNITS.append(PICOAMPERE)
PICOCOULOMB = UnitDescriptor('picocoulomb', 'C71', '''pC''')
ALL_UNITS.append(PICOCOULOMB)
PICOFARAD_PER_METRE = UnitDescriptor('picofarad per metre', 'C72', '''pF/m''')
ALL_UNITS.append(PICOFARAD_PER_METRE)
PICOHENRY = UnitDescriptor('picohenry', 'C73', '''pH''')
ALL_UNITS.append(PICOHENRY)
KILOBIT_PER_SECOND = UnitDescriptor('kilobit per second', 'C74', '''kbit/s''')
ALL_UNITS.append(KILOBIT_PER_SECOND)
PICOWATT = UnitDescriptor('picowatt', 'C75', '''pW''')
ALL_UNITS.append(PICOWATT)
PICOWATT_PER_SQUARE_METRE = UnitDescriptor('picowatt per square metre', 'C76', '''pW/m²''')
ALL_UNITS.append(PICOWATT_PER_SQUARE_METRE)
POUND_GAGE = UnitDescriptor('pound gage', 'C77', '''''')
ALL_UNITS.append(POUND_GAGE)
POUND_FORCE = UnitDescriptor('pound-force', 'C78', '''lbf''')
ALL_UNITS.append(POUND_FORCE)
KILOVOLT_AMPERE_HOUR = UnitDescriptor('kilovolt ampere hour', 'C79', '''kVAh''')
ALL_UNITS.append(KILOVOLT_AMPERE_HOUR)
MILLICOULOMB_PER_KILOGRAM = UnitDescriptor('millicoulomb per kilogram', 'C8', '''mC/kg''')
ALL_UNITS.append(MILLICOULOMB_PER_KILOGRAM)
RAD = UnitDescriptor('rad', 'C80', '''rad''')
ALL_UNITS.append(RAD)
RADIAN = UnitDescriptor('radian', 'C81', '''rad''')
ALL_UNITS.append(RADIAN)
RADIAN_SQUARE_METRE_PER_MOLE = UnitDescriptor('radian square metre per mole', 'C82', '''rad·m²/mol''')
ALL_UNITS.append(RADIAN_SQUARE_METRE_PER_MOLE)
RADIAN_SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('radian square metre per kilogram', 'C83', '''rad·m²/kg''')
ALL_UNITS.append(RADIAN_SQUARE_METRE_PER_KILOGRAM)
RADIAN_PER_METRE = UnitDescriptor('radian per metre', 'C84', '''rad/m''')
ALL_UNITS.append(RADIAN_PER_METRE)
RECIPROCAL_ANGSTROM = UnitDescriptor('reciprocal angstrom', 'C85', '''Å⁻¹''')
ALL_UNITS.append(RECIPROCAL_ANGSTROM)
RECIPROCAL_CUBIC_METRE = UnitDescriptor('reciprocal cubic metre', 'C86', '''m⁻³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_METRE)
RECIPROCAL_CUBIC_METRE_PER_SECOND = UnitDescriptor('reciprocal cubic metre per second', 'C87', '''m⁻³/s''')
ALL_UNITS.append(RECIPROCAL_CUBIC_METRE_PER_SECOND)
RECIPROCAL_ELECTRON_VOLT_PER_CUBIC_METRE = UnitDescriptor('reciprocal electron volt per cubic metre', 'C88', '''eV⁻¹/m³''')
ALL_UNITS.append(RECIPROCAL_ELECTRON_VOLT_PER_CUBIC_METRE)
RECIPROCAL_HENRY = UnitDescriptor('reciprocal henry', 'C89', '''H⁻¹''')
ALL_UNITS.append(RECIPROCAL_HENRY)
COIL_GROUP = UnitDescriptor('coil group', 'C9', '''''')
ALL_UNITS.append(COIL_GROUP)
RECIPROCAL_JOULE_PER_CUBIC_METRE = UnitDescriptor('reciprocal joule per cubic metre', 'C90', '''J⁻¹/m³''')
ALL_UNITS.append(RECIPROCAL_JOULE_PER_CUBIC_METRE)
RECIPROCAL_KELVIN_OR_KELVIN_TO_THE_POWER_MINUS_ONE = UnitDescriptor('reciprocal kelvin or kelvin to the power minus one', 'C91', '''K⁻¹''')
ALL_UNITS.append(RECIPROCAL_KELVIN_OR_KELVIN_TO_THE_POWER_MINUS_ONE)
RECIPROCAL_METRE = UnitDescriptor('reciprocal metre', 'C92', '''m⁻¹''')
ALL_UNITS.append(RECIPROCAL_METRE)
RECIPROCAL_SQUARE_METRE = UnitDescriptor('reciprocal square metre', 'C93', '''m⁻²''')
ALL_UNITS.append(RECIPROCAL_SQUARE_METRE)
RECIPROCAL_MINUTE = UnitDescriptor('reciprocal minute', 'C94', '''min⁻¹''')
ALL_UNITS.append(RECIPROCAL_MINUTE)
RECIPROCAL_MOLE = UnitDescriptor('reciprocal mole', 'C95', '''mol⁻¹''')
ALL_UNITS.append(RECIPROCAL_MOLE)
RECIPROCAL_PASCAL_OR_PASCAL_TO_THE_POWER_MINUS_ONE = UnitDescriptor('reciprocal pascal or pascal to the power minus one', 'C96', '''Pa⁻¹''')
ALL_UNITS.append(RECIPROCAL_PASCAL_OR_PASCAL_TO_THE_POWER_MINUS_ONE)
RECIPROCAL_SECOND = UnitDescriptor('reciprocal second', 'C97', '''s⁻¹''')
ALL_UNITS.append(RECIPROCAL_SECOND)
RECIPROCAL_SECOND_PER_CUBIC_METRE = UnitDescriptor('reciprocal second per cubic metre', 'C98', '''s⁻¹/m³''')
ALL_UNITS.append(RECIPROCAL_SECOND_PER_CUBIC_METRE)
RECIPROCAL_SECOND_PER_METRE_SQUARED = UnitDescriptor('reciprocal second per metre squared', 'C99', '''s⁻¹/m²''')
ALL_UNITS.append(RECIPROCAL_SECOND_PER_METRE_SQUARED)
CAN = UnitDescriptor('can', 'CA', '''''')
ALL_UNITS.append(CAN)
CARRYING_CAPACITY_IN_METRIC_TON = UnitDescriptor('carrying capacity in metric ton', 'CCT', '''''')
ALL_UNITS.append(CARRYING_CAPACITY_IN_METRIC_TON)
CANDELA = UnitDescriptor('candela', 'CDL', '''cd''')
ALL_UNITS.append(CANDELA)
DEGREE_CELSIUS = UnitDescriptor('degree Celsius', 'CEL', '''°C''')
ALL_UNITS.append(DEGREE_CELSIUS)
HUNDRED = UnitDescriptor('hundred', 'CEN', '''''')
ALL_UNITS.append(HUNDRED)
CARD = UnitDescriptor('card', 'CG', '''''')
ALL_UNITS.append(CARD)
CENTIGRAM = UnitDescriptor('centigram', 'CGM', '''cg''')
ALL_UNITS.append(CENTIGRAM)
CONTAINER = UnitDescriptor('container', 'CH', '''''')
ALL_UNITS.append(CONTAINER)
CONE = UnitDescriptor('cone', 'CJ', '''''')
ALL_UNITS.append(CONE)
CONNECTOR = UnitDescriptor('connector', 'CK', '''''')
ALL_UNITS.append(CONNECTOR)
COULOMB_PER_KILOGRAM = UnitDescriptor('coulomb per kilogram', 'CKG', '''C/kg''')
ALL_UNITS.append(COULOMB_PER_KILOGRAM)
COIL = UnitDescriptor('coil', 'CL', '''''')
ALL_UNITS.append(COIL)
HUNDRED_LEAVE = UnitDescriptor('hundred leave', 'CLF', '''''')
ALL_UNITS.append(HUNDRED_LEAVE)
CENTILITRE = UnitDescriptor('centilitre', 'CLT', '''cl''')
ALL_UNITS.append(CENTILITRE)
SQUARE_CENTIMETRE = UnitDescriptor('square centimetre', 'CMK', '''cm²''')
ALL_UNITS.append(SQUARE_CENTIMETRE)
CUBIC_CENTIMETRE = UnitDescriptor('cubic centimetre', 'CMQ', '''cm³''')
ALL_UNITS.append(CUBIC_CENTIMETRE)
CENTIMETRE = UnitDescriptor('centimetre', 'CMT', '''cm''')
ALL_UNITS.append(CENTIMETRE)
HUNDRED_PACK = UnitDescriptor('hundred pack', 'CNP', '''''')
ALL_UNITS.append(HUNDRED_PACK)
CENTAL_UK = UnitDescriptor('cental (UK)', 'CNT', '''''')
ALL_UNITS.append(CENTAL_UK)
CARBOY = UnitDescriptor('carboy', 'CO', '''''')
ALL_UNITS.append(CARBOY)
COULOMB = UnitDescriptor('coulomb', 'COU', '''C''')
ALL_UNITS.append(COULOMB)
CARTRIDGE = UnitDescriptor('cartridge', 'CQ', '''''')
ALL_UNITS.append(CARTRIDGE)
CRATE = UnitDescriptor('crate', 'CR', '''''')
ALL_UNITS.append(CRATE)
CASE = UnitDescriptor('case', 'CS', '''''')
ALL_UNITS.append(CASE)
CARTON = UnitDescriptor('carton', 'CT', '''''')
ALL_UNITS.append(CARTON)
CONTENT_GRAM = UnitDescriptor('content gram', 'CTG', '''''')
ALL_UNITS.append(CONTENT_GRAM)
METRIC_CARAT = UnitDescriptor('metric carat', 'CTM', '''''')
ALL_UNITS.append(METRIC_CARAT)
CONTENT_TON_METRIC = UnitDescriptor('content ton (metric)', 'CTN', '''''')
ALL_UNITS.append(CONTENT_TON_METRIC)
CUP = UnitDescriptor('cup', 'CU', '''''')
ALL_UNITS.append(CUP)
CURIE = UnitDescriptor('curie', 'CUR', '''Ci''')
ALL_UNITS.append(CURIE)
COVER = UnitDescriptor('cover', 'CV', '''''')
ALL_UNITS.append(COVER)
HUNDRED_POUND_CWT_PER_HUNDRED_WEIGHT_US = UnitDescriptor('hundred pound (cwt) / hundred weight (US)', 'CWA', '''cwt (US)''')
ALL_UNITS.append(HUNDRED_POUND_CWT_PER_HUNDRED_WEIGHT_US)
HUNDRED_WEIGHT_UK = UnitDescriptor('hundred weight (UK)', 'CWI', '''cwt (UK)''')
ALL_UNITS.append(HUNDRED_WEIGHT_UK)
CYLINDER = UnitDescriptor('cylinder', 'CY', '''''')
ALL_UNITS.append(CYLINDER)
COMBO = UnitDescriptor('combo', 'CZ', '''''')
ALL_UNITS.append(COMBO)
KILOWATT_HOUR_PER_HOUR = UnitDescriptor('kilowatt hour per hour', 'D03', '''kW·h/h''')
ALL_UNITS.append(KILOWATT_HOUR_PER_HOUR)
LOT_UNIT_OF_WEIGHT = UnitDescriptor('lot [unit of weight]', 'D04', '''''')
ALL_UNITS.append(LOT_UNIT_OF_WEIGHT)
RECIPROCAL_SECOND_PER_STERADIAN = UnitDescriptor('reciprocal second per steradian', 'D1', '''s⁻¹/sr''')
ALL_UNITS.append(RECIPROCAL_SECOND_PER_STERADIAN)
SIEMENS_PER_METRE = UnitDescriptor('siemens per metre', 'D10', '''S/m''')
ALL_UNITS.append(SIEMENS_PER_METRE)
MEBIBIT = UnitDescriptor('mebibit', 'D11', '''Mibit''')
ALL_UNITS.append(MEBIBIT)
SIEMENS_SQUARE_METRE_PER_MOLE = UnitDescriptor('siemens square metre per mole', 'D12', '''S·m²/mol''')
ALL_UNITS.append(SIEMENS_SQUARE_METRE_PER_MOLE)
SIEVERT = UnitDescriptor('sievert', 'D13', '''Sv''')
ALL_UNITS.append(SIEVERT)
THOUSAND_LINEAR_YARD = UnitDescriptor('thousand linear yard', 'D14', '''''')
ALL_UNITS.append(THOUSAND_LINEAR_YARD)
SONE = UnitDescriptor('sone', 'D15', '''''')
ALL_UNITS.append(SONE)
SQUARE_CENTIMETRE_PER_ERG = UnitDescriptor('square centimetre per erg', 'D16', '''cm²/erg''')
ALL_UNITS.append(SQUARE_CENTIMETRE_PER_ERG)
SQUARE_CENTIMETRE_PER_STERADIAN_ERG = UnitDescriptor('square centimetre per steradian erg', 'D17', '''cm²/(sr·erg)''')
ALL_UNITS.append(SQUARE_CENTIMETRE_PER_STERADIAN_ERG)
METRE_KELVIN = UnitDescriptor('metre kelvin', 'D18', '''m·K''')
ALL_UNITS.append(METRE_KELVIN)
SQUARE_METRE_KELVIN_PER_WATT = UnitDescriptor('square metre kelvin per watt', 'D19', '''m²·K/W''')
ALL_UNITS.append(SQUARE_METRE_KELVIN_PER_WATT)
RECIPROCAL_SECOND_PER_STERADIAN_METRE_SQUARED = UnitDescriptor('reciprocal second per steradian metre squared', 'D2', '''s⁻¹/(sr·m²)''')
ALL_UNITS.append(RECIPROCAL_SECOND_PER_STERADIAN_METRE_SQUARED)
SQUARE_METRE_PER_JOULE = UnitDescriptor('square metre per joule', 'D20', '''m²/J''')
ALL_UNITS.append(SQUARE_METRE_PER_JOULE)
SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('square metre per kilogram', 'D21', '''m²/kg''')
ALL_UNITS.append(SQUARE_METRE_PER_KILOGRAM)
SQUARE_METRE_PER_MOLE = UnitDescriptor('square metre per mole', 'D22', '''m²/mol''')
ALL_UNITS.append(SQUARE_METRE_PER_MOLE)
PEN_GRAM_PROTEIN = UnitDescriptor('pen gram (protein)', 'D23', '''''')
ALL_UNITS.append(PEN_GRAM_PROTEIN)
SQUARE_METRE_PER_STERADIAN = UnitDescriptor('square metre per steradian', 'D24', '''m²/sr''')
ALL_UNITS.append(SQUARE_METRE_PER_STERADIAN)
SQUARE_METRE_PER_STERADIAN_JOULE = UnitDescriptor('square metre per steradian joule', 'D25', '''m²/(sr·J)''')
ALL_UNITS.append(SQUARE_METRE_PER_STERADIAN_JOULE)
SQUARE_METRE_PER_VOLT_SECOND = UnitDescriptor('square metre per volt second', 'D26', '''m²/(V·s)''')
ALL_UNITS.append(SQUARE_METRE_PER_VOLT_SECOND)
STERADIAN = UnitDescriptor('steradian', 'D27', '''sr''')
ALL_UNITS.append(STERADIAN)
SYPHON = UnitDescriptor('syphon', 'D28', '''''')
ALL_UNITS.append(SYPHON)
TERAHERTZ = UnitDescriptor('terahertz', 'D29', '''THz''')
ALL_UNITS.append(TERAHERTZ)
TERAJOULE = UnitDescriptor('terajoule', 'D30', '''TJ''')
ALL_UNITS.append(TERAJOULE)
TERAWATT = UnitDescriptor('terawatt', 'D31', '''TW''')
ALL_UNITS.append(TERAWATT)
TERAWATT_HOUR = UnitDescriptor('terawatt hour', 'D32', '''TW·h''')
ALL_UNITS.append(TERAWATT_HOUR)
TESLA = UnitDescriptor('tesla', 'D33', '''T''')
ALL_UNITS.append(TESLA)
TEX = UnitDescriptor('tex', 'D34', '''tex (g/km)''')
ALL_UNITS.append(TEX)
CALORIE_THERMOCHEMICAL = UnitDescriptor('calorie (thermochemical)', 'D35', '''calth''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL)
MEGABIT = UnitDescriptor('megabit', 'D36', '''Mbit''')
ALL_UNITS.append(MEGABIT)
CALORIE_THERMOCHEMICAL_PER_GRAM_KELVIN = UnitDescriptor('calorie (thermochemical) per gram kelvin', 'D37', '''calth/(g·K)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_GRAM_KELVIN)
CALORIE_THERMOCHEMICAL_PER_SECOND_CENTIMETRE_KELVIN = UnitDescriptor('calorie (thermochemical) per second centimetre kelvin', 'D38', '''calth/(s·cm·K)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SECOND_CENTIMETRE_KELVIN)
CALORIE_THERMOCHEMICAL_PER_SECOND_SQUARE_CENTIMETRE_KELVIN = UnitDescriptor('calorie (thermochemical) per second square centimetre kelvin', 'D39', '''calth/(s·cm²·K)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SECOND_SQUARE_CENTIMETRE_KELVIN)
THOUSAND_LITRE = UnitDescriptor('thousand litre', 'D40', '''''')
ALL_UNITS.append(THOUSAND_LITRE)
TONNE_PER_CUBIC_METRE = UnitDescriptor('tonne per cubic metre', 'D41', '''t/m³''')
ALL_UNITS.append(TONNE_PER_CUBIC_METRE)
TROPICAL_YEAR = UnitDescriptor('tropical year', 'D42', '''y (tropical)''')
ALL_UNITS.append(TROPICAL_YEAR)
UNIFIED_ATOMIC_MASS_UNIT = UnitDescriptor('unified atomic mass unit', 'D43', '''u''')
ALL_UNITS.append(UNIFIED_ATOMIC_MASS_UNIT)
VAR = UnitDescriptor('var', 'D44', '''var''')
ALL_UNITS.append(VAR)
VOLT_SQUARED_PER_KELVIN_SQUARED = UnitDescriptor('volt squared per kelvin squared', 'D45', '''V²/K²''')
ALL_UNITS.append(VOLT_SQUARED_PER_KELVIN_SQUARED)
VOLT_AMPERE = UnitDescriptor('volt - ampere', 'D46', '''V·A''')
ALL_UNITS.append(VOLT_AMPERE)
VOLT_PER_CENTIMETRE = UnitDescriptor('volt per centimetre', 'D47', '''V/cm''')
ALL_UNITS.append(VOLT_PER_CENTIMETRE)
VOLT_PER_KELVIN = UnitDescriptor('volt per kelvin', 'D48', '''V/K''')
ALL_UNITS.append(VOLT_PER_KELVIN)
MILLIVOLT_PER_KELVIN = UnitDescriptor('millivolt per kelvin', 'D49', '''mV/K''')
ALL_UNITS.append(MILLIVOLT_PER_KELVIN)
KILOGRAM_PER_SQUARE_CENTIMETRE = UnitDescriptor('kilogram per square centimetre', 'D5', '''kg/cm²''')
ALL_UNITS.append(KILOGRAM_PER_SQUARE_CENTIMETRE)
VOLT_PER_METRE = UnitDescriptor('volt per metre', 'D50', '''V/m''')
ALL_UNITS.append(VOLT_PER_METRE)
VOLT_PER_MILLIMETRE = UnitDescriptor('volt per millimetre', 'D51', '''V/mm''')
ALL_UNITS.append(VOLT_PER_MILLIMETRE)
WATT_PER_KELVIN = UnitDescriptor('watt per kelvin', 'D52', '''W/K''')
ALL_UNITS.append(WATT_PER_KELVIN)
WATT_PER_METRE_KELVIN = UnitDescriptor('watt per metre kelvin', 'D53', '''W/(m·K)''')
ALL_UNITS.append(WATT_PER_METRE_KELVIN)
WATT_PER_SQUARE_METRE = UnitDescriptor('watt per square metre', 'D54', '''W/m²''')
ALL_UNITS.append(WATT_PER_SQUARE_METRE)
WATT_PER_SQUARE_METRE_KELVIN = UnitDescriptor('watt per square metre kelvin', 'D55', '''W/(m²·K)''')
ALL_UNITS.append(WATT_PER_SQUARE_METRE_KELVIN)
WATT_PER_SQUARE_METRE_KELVIN_TO_THE_FOURTH_POWER = UnitDescriptor('watt per square metre kelvin to the fourth power', 'D56', '''W/(m²·K⁴)''')
ALL_UNITS.append(WATT_PER_SQUARE_METRE_KELVIN_TO_THE_FOURTH_POWER)
WATT_PER_STERADIAN = UnitDescriptor('watt per steradian', 'D57', '''W/sr''')
ALL_UNITS.append(WATT_PER_STERADIAN)
WATT_PER_STERADIAN_SQUARE_METRE = UnitDescriptor('watt per steradian square metre', 'D58', '''W/(sr·m²)''')
ALL_UNITS.append(WATT_PER_STERADIAN_SQUARE_METRE)
WEBER_PER_METRE = UnitDescriptor('weber per metre', 'D59', '''Wb/m''')
ALL_UNITS.append(WEBER_PER_METRE)
ROENTGEN_PER_SECOND = UnitDescriptor('roentgen per second', 'D6', '''R/s''')
ALL_UNITS.append(ROENTGEN_PER_SECOND)
WEBER_PER_MILLIMETRE = UnitDescriptor('weber per millimetre', 'D60', '''Wb/mm''')
ALL_UNITS.append(WEBER_PER_MILLIMETRE)
MINUTE_UNIT_OF_ANGLE = UnitDescriptor('minute [unit of angle]', 'D61', '''\'''')
ALL_UNITS.append(MINUTE_UNIT_OF_ANGLE)
SECOND_UNIT_OF_ANGLE = UnitDescriptor('second [unit of angle]', 'D62', '''"''')
ALL_UNITS.append(SECOND_UNIT_OF_ANGLE)
BOOK = UnitDescriptor('book', 'D63', '''''')
ALL_UNITS.append(BOOK)
BLOCK = UnitDescriptor('block', 'D64', '''''')
ALL_UNITS.append(BLOCK)
ROUND = UnitDescriptor('round', 'D65', '''''')
ALL_UNITS.append(ROUND)
CASSETTE = UnitDescriptor('cassette', 'D66', '''''')
ALL_UNITS.append(CASSETTE)
DOLLAR_PER_HOUR = UnitDescriptor('dollar per hour', 'D67', '''''')
ALL_UNITS.append(DOLLAR_PER_HOUR)
NUMBER_OF_WORDS = UnitDescriptor('number of words', 'D68', '''''')
ALL_UNITS.append(NUMBER_OF_WORDS)
INCH_TO_THE_FOURTH_POWER = UnitDescriptor('inch to the fourth power', 'D69', '''in⁴''')
ALL_UNITS.append(INCH_TO_THE_FOURTH_POWER)
SANDWICH = UnitDescriptor('sandwich', 'D7', '''''')
ALL_UNITS.append(SANDWICH)
CALORIE_INTERNATIONAL_TABLE = UnitDescriptor('calorie (international table)', 'D70', '''calIT''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE)
CALORIE_INTERNATIONAL_TABLE_PER_SECOND_CENTIMETRE_KELVIN = UnitDescriptor('calorie (international table) per second centimetre kelvin', 'D71', '''calIT/(s·cm·K)''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE_PER_SECOND_CENTIMETRE_KELVIN)
CALORIE_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_CENTIMETRE_KELVIN = UnitDescriptor('calorie (international table) per second square centimetre kelvin', 'D72', '''calIT/(s·cm²·K)''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_CENTIMETRE_KELVIN)
JOULE_SQUARE_METRE = UnitDescriptor('joule square metre', 'D73', '''J·m²''')
ALL_UNITS.append(JOULE_SQUARE_METRE)
KILOGRAM_PER_MOLE = UnitDescriptor('kilogram per mole', 'D74', '''kg/mol''')
ALL_UNITS.append(KILOGRAM_PER_MOLE)
CALORIE_INTERNATIONAL_TABLE_PER_GRAM = UnitDescriptor('calorie (international table) per gram', 'D75', '''calIT/g''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE_PER_GRAM)
CALORIE_INTERNATIONAL_TABLE_PER_GRAM_KELVIN = UnitDescriptor('calorie (international table) per gram kelvin', 'D76', '''calIT/(g·K)''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE_PER_GRAM_KELVIN)
MEGACOULOMB = UnitDescriptor('megacoulomb', 'D77', '''MC''')
ALL_UNITS.append(MEGACOULOMB)
MEGAJOULE_PER_SECOND = UnitDescriptor('megajoule per second', 'D78', '''MJ/s''')
ALL_UNITS.append(MEGAJOULE_PER_SECOND)
BEAM = UnitDescriptor('beam', 'D79', '''''')
ALL_UNITS.append(BEAM)
DRAIZE_SCORE = UnitDescriptor('draize score', 'D8', '''''')
ALL_UNITS.append(DRAIZE_SCORE)
MICROWATT = UnitDescriptor('microwatt', 'D80', '''µW''')
ALL_UNITS.append(MICROWATT)
MICROTESLA = UnitDescriptor('microtesla', 'D81', '''µT''')
ALL_UNITS.append(MICROTESLA)
MICROVOLT = UnitDescriptor('microvolt', 'D82', '''µV''')
ALL_UNITS.append(MICROVOLT)
MILLINEWTON_METRE = UnitDescriptor('millinewton metre', 'D83', '''mN·m''')
ALL_UNITS.append(MILLINEWTON_METRE)
MICROWATT_PER_SQUARE_METRE = UnitDescriptor('microwatt per square metre', 'D85', '''µW/m²''')
ALL_UNITS.append(MICROWATT_PER_SQUARE_METRE)
MILLICOULOMB = UnitDescriptor('millicoulomb', 'D86', '''mC''')
ALL_UNITS.append(MILLICOULOMB)
MILLIMOLE_PER_KILOGRAM = UnitDescriptor('millimole per kilogram', 'D87', '''mmol/kg''')
ALL_UNITS.append(MILLIMOLE_PER_KILOGRAM)
MILLICOULOMB_PER_CUBIC_METRE = UnitDescriptor('millicoulomb per cubic metre', 'D88', '''mC/m³''')
ALL_UNITS.append(MILLICOULOMB_PER_CUBIC_METRE)
MILLICOULOMB_PER_SQUARE_METRE = UnitDescriptor('millicoulomb per square metre', 'D89', '''mC/m²''')
ALL_UNITS.append(MILLICOULOMB_PER_SQUARE_METRE)
DYNE_PER_SQUARE_CENTIMETRE = UnitDescriptor('dyne per square centimetre', 'D9', '''dyn/cm²''')
ALL_UNITS.append(DYNE_PER_SQUARE_CENTIMETRE)
CUBIC_METRE_NET = UnitDescriptor('cubic metre (net)', 'D90', '''''')
ALL_UNITS.append(CUBIC_METRE_NET)
REM = UnitDescriptor('rem', 'D91', '''rem''')
ALL_UNITS.append(REM)
BAND = UnitDescriptor('band', 'D92', '''''')
ALL_UNITS.append(BAND)
SECOND_PER_CUBIC_METRE = UnitDescriptor('second per cubic metre', 'D93', '''s/m³''')
ALL_UNITS.append(SECOND_PER_CUBIC_METRE)
SECOND_PER_CUBIC_METRE_RADIAN = UnitDescriptor('second per cubic metre radian', 'D94', '''s/(rad·m³)''')
ALL_UNITS.append(SECOND_PER_CUBIC_METRE_RADIAN)
JOULE_PER_GRAM = UnitDescriptor('joule per gram', 'D95', '''J/g''')
ALL_UNITS.append(JOULE_PER_GRAM)
POUND_GROSS = UnitDescriptor('pound gross', 'D96', '''''')
ALL_UNITS.append(POUND_GROSS)
PALLET_PER_UNIT_LOAD = UnitDescriptor('pallet/unit load', 'D97', '''''')
ALL_UNITS.append(PALLET_PER_UNIT_LOAD)
MASS_POUND = UnitDescriptor('mass pound', 'D98', '''''')
ALL_UNITS.append(MASS_POUND)
SLEEVE = UnitDescriptor('sleeve', 'D99', '''''')
ALL_UNITS.append(SLEEVE)
DECARE = UnitDescriptor('decare', 'DAA', '''daa''')
ALL_UNITS.append(DECARE)
TEN_DAY = UnitDescriptor('ten day', 'DAD', '''''')
ALL_UNITS.append(TEN_DAY)
DAY = UnitDescriptor('day', 'DAY', '''d''')
ALL_UNITS.append(DAY)
DRY_POUND = UnitDescriptor('dry pound', 'DB', '''''')
ALL_UNITS.append(DRY_POUND)
DISK_DISC = UnitDescriptor('disk (disc)', 'DC', '''''')
ALL_UNITS.append(DISK_DISC)
DEGREE_UNIT_OF_ANGLE = UnitDescriptor('degree [unit of angle]', 'DD', '''°''')
ALL_UNITS.append(DEGREE_UNIT_OF_ANGLE)
DEAL = UnitDescriptor('deal', 'DE', '''''')
ALL_UNITS.append(DEAL)
DECADE = UnitDescriptor('decade', 'DEC', '''''')
ALL_UNITS.append(DECADE)
DECIGRAM = UnitDescriptor('decigram', 'DG', '''dg''')
ALL_UNITS.append(DECIGRAM)
DISPENSER = UnitDescriptor('dispenser', 'DI', '''''')
ALL_UNITS.append(DISPENSER)
DECAGRAM = UnitDescriptor('decagram', 'DJ', '''dag''')
ALL_UNITS.append(DECAGRAM)
DECILITRE = UnitDescriptor('decilitre', 'DLT', '''dl''')
ALL_UNITS.append(DECILITRE)
CUBIC_DECAMETRE = UnitDescriptor('cubic decametre', 'DMA', '''dam³''')
ALL_UNITS.append(CUBIC_DECAMETRE)
SQUARE_DECIMETRE = UnitDescriptor('square decimetre', 'DMK', '''dm²''')
ALL_UNITS.append(SQUARE_DECIMETRE)
STANDARD_KILOLITRE = UnitDescriptor('standard kilolitre', 'DMO', '''''')
ALL_UNITS.append(STANDARD_KILOLITRE)
CUBIC_DECIMETRE = UnitDescriptor('cubic decimetre', 'DMQ', '''dm³''')
ALL_UNITS.append(CUBIC_DECIMETRE)
DECIMETRE = UnitDescriptor('decimetre', 'DMT', '''dm''')
ALL_UNITS.append(DECIMETRE)
DECINEWTON_METRE = UnitDescriptor('decinewton metre', 'DN', '''dN·m''')
ALL_UNITS.append(DECINEWTON_METRE)
DOZEN_PIECE = UnitDescriptor('dozen piece', 'DPC', '''''')
ALL_UNITS.append(DOZEN_PIECE)
DOZEN_PAIR = UnitDescriptor('dozen pair', 'DPR', '''''')
ALL_UNITS.append(DOZEN_PAIR)
DISPLACEMENT_TONNAGE = UnitDescriptor('displacement tonnage', 'DPT', '''''')
ALL_UNITS.append(DISPLACEMENT_TONNAGE)
DATA_RECORD = UnitDescriptor('data record', 'DQ', '''''')
ALL_UNITS.append(DATA_RECORD)
DRUM = UnitDescriptor('drum', 'DR', '''''')
ALL_UNITS.append(DRUM)
DRAM_US = UnitDescriptor('dram (US)', 'DRA', '''''')
ALL_UNITS.append(DRAM_US)
DRAM_UK = UnitDescriptor('dram (UK)', 'DRI', '''''')
ALL_UNITS.append(DRAM_UK)
DOZEN_ROLL = UnitDescriptor('dozen roll', 'DRL', '''''')
ALL_UNITS.append(DOZEN_ROLL)
DRACHM_UK = UnitDescriptor('drachm (UK)', 'DRM', '''''')
ALL_UNITS.append(DRACHM_UK)
DISPLAY = UnitDescriptor('display', 'DS', '''''')
ALL_UNITS.append(DISPLAY)
DRY_TON = UnitDescriptor('dry ton', 'DT', '''''')
ALL_UNITS.append(DRY_TON)
DECITONNE = UnitDescriptor('decitonne', 'DTN', '''dt''')
ALL_UNITS.append(DECITONNE)
DECITONNE = UnitDescriptor('decitonne', 'DTN', '''dtn''')
ALL_UNITS.append(DECITONNE)
DYNE = UnitDescriptor('dyne', 'DU', '''dyn''')
ALL_UNITS.append(DYNE)
PENNYWEIGHT = UnitDescriptor('pennyweight', 'DWT', '''''')
ALL_UNITS.append(PENNYWEIGHT)
DYNE_PER_CENTIMETRE = UnitDescriptor('dyne per centimetre', 'DX', '''dyn/cm''')
ALL_UNITS.append(DYNE_PER_CENTIMETRE)
DIRECTORY_BOOK = UnitDescriptor('directory book', 'DY', '''''')
ALL_UNITS.append(DIRECTORY_BOOK)
DOZEN = UnitDescriptor('dozen', 'DZN', '''DOZ''')
ALL_UNITS.append(DOZEN)
DOZEN_PACK = UnitDescriptor('dozen pack', 'DZP', '''''')
ALL_UNITS.append(DOZEN_PACK)
NEWTON_PER_SQUARE_CENTIMETRE = UnitDescriptor('newton per square centimetre', 'E01', '''N/cm²''')
ALL_UNITS.append(NEWTON_PER_SQUARE_CENTIMETRE)
MEGAWATT_HOUR_PER_HOUR = UnitDescriptor('megawatt hour per hour', 'E07', '''MW·h/h''')
ALL_UNITS.append(MEGAWATT_HOUR_PER_HOUR)
MEGAWATT_PER_HERTZ = UnitDescriptor('megawatt per hertz', 'E08', '''MW/Hz''')
ALL_UNITS.append(MEGAWATT_PER_HERTZ)
MILLIAMPERE_HOUR = UnitDescriptor('milliampere hour', 'E09', '''mA·h''')
ALL_UNITS.append(MILLIAMPERE_HOUR)
DEGREE_DAY = UnitDescriptor('degree day', 'E10', '''deg da''')
ALL_UNITS.append(DEGREE_DAY)
GIGACALORIE = UnitDescriptor('gigacalorie', 'E11', '''''')
ALL_UNITS.append(GIGACALORIE)
MILLE = UnitDescriptor('mille', 'E12', '''''')
ALL_UNITS.append(MILLE)
KILOCALORIE_INTERNATIONAL_TABLE = UnitDescriptor('kilocalorie (international table)', 'E14', '''kcalIT''')
ALL_UNITS.append(KILOCALORIE_INTERNATIONAL_TABLE)
KILOCALORIE_THERMOCHEMICAL_PER_HOUR = UnitDescriptor('kilocalorie (thermochemical) per hour', 'E15', '''kcalth/h''')
ALL_UNITS.append(KILOCALORIE_THERMOCHEMICAL_PER_HOUR)
MILLION_BTUIT_PER_HOUR = UnitDescriptor('million Btu(IT) per hour', 'E16', '''BtuIT/h''')
ALL_UNITS.append(MILLION_BTUIT_PER_HOUR)
CUBIC_FOOT_PER_SECOND = UnitDescriptor('cubic foot per second', 'E17', '''ft³/s''')
ALL_UNITS.append(CUBIC_FOOT_PER_SECOND)
TONNE_PER_HOUR = UnitDescriptor('tonne per hour', 'E18', '''t/h''')
ALL_UNITS.append(TONNE_PER_HOUR)
PING = UnitDescriptor('ping', 'E19', '''''')
ALL_UNITS.append(PING)
BELT = UnitDescriptor('belt', 'E2', '''''')
ALL_UNITS.append(BELT)
MEGABIT_PER_SECOND = UnitDescriptor('megabit per second', 'E20', '''Mbit/s''')
ALL_UNITS.append(MEGABIT_PER_SECOND)
SHARES = UnitDescriptor('shares', 'E21', '''''')
ALL_UNITS.append(SHARES)
TEU = UnitDescriptor('TEU', 'E22', '''''')
ALL_UNITS.append(TEU)
TYRE = UnitDescriptor('tyre', 'E23', '''''')
ALL_UNITS.append(TYRE)
ACTIVE_UNIT = UnitDescriptor('active unit', 'E25', '''''')
ALL_UNITS.append(ACTIVE_UNIT)
DOSE = UnitDescriptor('dose', 'E27', '''''')
ALL_UNITS.append(DOSE)
AIR_DRY_TON = UnitDescriptor('air dry ton', 'E28', '''''')
ALL_UNITS.append(AIR_DRY_TON)
TRAILER = UnitDescriptor('trailer', 'E3', '''''')
ALL_UNITS.append(TRAILER)
STRAND = UnitDescriptor('strand', 'E30', '''''')
ALL_UNITS.append(STRAND)
SQUARE_METRE_PER_LITRE = UnitDescriptor('square metre per litre', 'E31', '''m²/l''')
ALL_UNITS.append(SQUARE_METRE_PER_LITRE)
LITRE_PER_HOUR = UnitDescriptor('litre per hour', 'E32', '''l/h''')
ALL_UNITS.append(LITRE_PER_HOUR)
FOOT_PER_THOUSAND = UnitDescriptor('foot per thousand', 'E33', '''''')
ALL_UNITS.append(FOOT_PER_THOUSAND)
GIGABYTE = UnitDescriptor('gigabyte', 'E34', '''Gbyte''')
ALL_UNITS.append(GIGABYTE)
TERABYTE = UnitDescriptor('terabyte', 'E35', '''Tbyte''')
ALL_UNITS.append(TERABYTE)
PETABYTE = UnitDescriptor('petabyte', 'E36', '''Pbyte''')
ALL_UNITS.append(PETABYTE)
PIXEL = UnitDescriptor('pixel', 'E37', '''''')
ALL_UNITS.append(PIXEL)
MEGAPIXEL = UnitDescriptor('megapixel', 'E38', '''''')
ALL_UNITS.append(MEGAPIXEL)
DOTS_PER_INCH = UnitDescriptor('dots per inch', 'E39', '''dpi''')
ALL_UNITS.append(DOTS_PER_INCH)
GROSS_KILOGRAM = UnitDescriptor('gross kilogram', 'E4', '''''')
ALL_UNITS.append(GROSS_KILOGRAM)
PART_PER_HUNDRED_THOUSAND = UnitDescriptor('part per hundred thousand', 'E40', '''ppht''')
ALL_UNITS.append(PART_PER_HUNDRED_THOUSAND)
KILOGRAM_FORCE_PER_SQUARE_MILLIMETRE = UnitDescriptor('kilogram-force per square millimetre', 'E41', '''kgf/mm²''')
ALL_UNITS.append(KILOGRAM_FORCE_PER_SQUARE_MILLIMETRE)
KILOGRAM_FORCE_PER_SQUARE_CENTIMETRE = UnitDescriptor('kilogram-force per square centimetre', 'E42', '''kgf/cm²''')
ALL_UNITS.append(KILOGRAM_FORCE_PER_SQUARE_CENTIMETRE)
JOULE_PER_SQUARE_CENTIMETRE = UnitDescriptor('joule per square centimetre', 'E43', '''J/cm²''')
ALL_UNITS.append(JOULE_PER_SQUARE_CENTIMETRE)
KILOGRAM_FORCE_METRE_PER_SQUARE_CENTIMETRE = UnitDescriptor('kilogram-force metre per square centimetre', 'E44', '''kgf·m/cm²''')
ALL_UNITS.append(KILOGRAM_FORCE_METRE_PER_SQUARE_CENTIMETRE)
MILLIOHM = UnitDescriptor('milliohm', 'E45', '''mΩ''')
ALL_UNITS.append(MILLIOHM)
KILOWATT_HOUR_PER_CUBIC_METRE = UnitDescriptor('kilowatt hour per cubic metre', 'E46', '''kW·h/m³''')
ALL_UNITS.append(KILOWATT_HOUR_PER_CUBIC_METRE)
KILOWATT_HOUR_PER_KELVIN = UnitDescriptor('kilowatt hour per kelvin', 'E47', '''kW·h/K''')
ALL_UNITS.append(KILOWATT_HOUR_PER_KELVIN)
SERVICE_UNIT = UnitDescriptor('service unit', 'E48', '''''')
ALL_UNITS.append(SERVICE_UNIT)
WORKING_DAY = UnitDescriptor('working day', 'E49', '''''')
ALL_UNITS.append(WORKING_DAY)
METRIC_LONG_TON = UnitDescriptor('metric long ton', 'E5', '''''')
ALL_UNITS.append(METRIC_LONG_TON)
ACCOUNTING_UNIT = UnitDescriptor('accounting unit', 'E50', '''''')
ALL_UNITS.append(ACCOUNTING_UNIT)
JOB = UnitDescriptor('job', 'E51', '''''')
ALL_UNITS.append(JOB)
RUN_FOOT = UnitDescriptor('run foot', 'E52', '''''')
ALL_UNITS.append(RUN_FOOT)
TEST = UnitDescriptor('test', 'E53', '''''')
ALL_UNITS.append(TEST)
TRIP = UnitDescriptor('trip', 'E54', '''''')
ALL_UNITS.append(TRIP)
USE = UnitDescriptor('use', 'E55', '''''')
ALL_UNITS.append(USE)
WELL = UnitDescriptor('well', 'E56', '''''')
ALL_UNITS.append(WELL)
ZONE = UnitDescriptor('zone', 'E57', '''''')
ALL_UNITS.append(ZONE)
EXABIT_PER_SECOND = UnitDescriptor('exabit per second', 'E58', '''Ebit/s''')
ALL_UNITS.append(EXABIT_PER_SECOND)
EXBIBYTE = UnitDescriptor('exbibyte', 'E59', '''Eibyte''')
ALL_UNITS.append(EXBIBYTE)
PEBIBYTE = UnitDescriptor('pebibyte', 'E60', '''Pibyte''')
ALL_UNITS.append(PEBIBYTE)
TEBIBYTE = UnitDescriptor('tebibyte', 'E61', '''Tibyte''')
ALL_UNITS.append(TEBIBYTE)
GIBIBYTE = UnitDescriptor('gibibyte', 'E62', '''Gibyte''')
ALL_UNITS.append(GIBIBYTE)
MEBIBYTE = UnitDescriptor('mebibyte', 'E63', '''Mibyte''')
ALL_UNITS.append(MEBIBYTE)
KIBIBYTE = UnitDescriptor('kibibyte', 'E64', '''Kibyte''')
ALL_UNITS.append(KIBIBYTE)
EXBIBIT_PER_METRE = UnitDescriptor('exbibit per metre', 'E65', '''Eibit/m''')
ALL_UNITS.append(EXBIBIT_PER_METRE)
EXBIBIT_PER_SQUARE_METRE = UnitDescriptor('exbibit per square metre', 'E66', '''Eibit/m²''')
ALL_UNITS.append(EXBIBIT_PER_SQUARE_METRE)
EXBIBIT_PER_CUBIC_METRE = UnitDescriptor('exbibit per cubic metre', 'E67', '''Eibit/m³''')
ALL_UNITS.append(EXBIBIT_PER_CUBIC_METRE)
GIGABYTE_PER_SECOND = UnitDescriptor('gigabyte per second', 'E68', '''Gbyte/s''')
ALL_UNITS.append(GIGABYTE_PER_SECOND)
GIBIBIT_PER_METRE = UnitDescriptor('gibibit per metre', 'E69', '''Gibit/m''')
ALL_UNITS.append(GIBIBIT_PER_METRE)
GIBIBIT_PER_SQUARE_METRE = UnitDescriptor('gibibit per square metre', 'E70', '''Gibit/m²''')
ALL_UNITS.append(GIBIBIT_PER_SQUARE_METRE)
GIBIBIT_PER_CUBIC_METRE = UnitDescriptor('gibibit per cubic metre', 'E71', '''Gibit/m³''')
ALL_UNITS.append(GIBIBIT_PER_CUBIC_METRE)
KIBIBIT_PER_METRE = UnitDescriptor('kibibit per metre', 'E72', '''Kibit/m''')
ALL_UNITS.append(KIBIBIT_PER_METRE)
KIBIBIT_PER_SQUARE_METRE = UnitDescriptor('kibibit per square metre', 'E73', '''Kibit/m²''')
ALL_UNITS.append(KIBIBIT_PER_SQUARE_METRE)
KIBIBIT_PER_CUBIC_METRE = UnitDescriptor('kibibit per cubic metre', 'E74', '''Kibit/m³''')
ALL_UNITS.append(KIBIBIT_PER_CUBIC_METRE)
MEBIBIT_PER_METRE = UnitDescriptor('mebibit per metre', 'E75', '''Mibit/m''')
ALL_UNITS.append(MEBIBIT_PER_METRE)
MEBIBIT_PER_SQUARE_METRE = UnitDescriptor('mebibit per square metre', 'E76', '''Mibit/m²''')
ALL_UNITS.append(MEBIBIT_PER_SQUARE_METRE)
MEBIBIT_PER_CUBIC_METRE = UnitDescriptor('mebibit per cubic metre', 'E77', '''Mibit/m³''')
ALL_UNITS.append(MEBIBIT_PER_CUBIC_METRE)
PETABIT = UnitDescriptor('petabit', 'E78', '''Pbit''')
ALL_UNITS.append(PETABIT)
PETABIT_PER_SECOND = UnitDescriptor('petabit per second', 'E79', '''Pbit/s''')
ALL_UNITS.append(PETABIT_PER_SECOND)
PEBIBIT_PER_METRE = UnitDescriptor('pebibit per metre', 'E80', '''Pibit/m''')
ALL_UNITS.append(PEBIBIT_PER_METRE)
PEBIBIT_PER_SQUARE_METRE = UnitDescriptor('pebibit per square metre', 'E81', '''Pibit/m²''')
ALL_UNITS.append(PEBIBIT_PER_SQUARE_METRE)
PEBIBIT_PER_CUBIC_METRE = UnitDescriptor('pebibit per cubic metre', 'E82', '''Pibit/m³''')
ALL_UNITS.append(PEBIBIT_PER_CUBIC_METRE)
TERABIT = UnitDescriptor('terabit', 'E83', '''Tbit''')
ALL_UNITS.append(TERABIT)
TERABIT_PER_SECOND = UnitDescriptor('terabit per second', 'E84', '''Tbit/s''')
ALL_UNITS.append(TERABIT_PER_SECOND)
TEBIBIT_PER_METRE = UnitDescriptor('tebibit per metre', 'E85', '''Tibit/m''')
ALL_UNITS.append(TEBIBIT_PER_METRE)
TEBIBIT_PER_CUBIC_METRE = UnitDescriptor('tebibit per cubic metre', 'E86', '''Tibit/m³''')
ALL_UNITS.append(TEBIBIT_PER_CUBIC_METRE)
TEBIBIT_PER_SQUARE_METRE = UnitDescriptor('tebibit per square metre', 'E87', '''Tibit/m²''')
ALL_UNITS.append(TEBIBIT_PER_SQUARE_METRE)
BIT_PER_METRE = UnitDescriptor('bit per metre', 'E88', '''bit/m''')
ALL_UNITS.append(BIT_PER_METRE)
BIT_PER_SQUARE_METRE = UnitDescriptor('bit per square metre', 'E89', '''bit/m²''')
ALL_UNITS.append(BIT_PER_SQUARE_METRE)
RECIPROCAL_CENTIMETRE = UnitDescriptor('reciprocal centimetre', 'E90', '''cm⁻¹''')
ALL_UNITS.append(RECIPROCAL_CENTIMETRE)
RECIPROCAL_DAY = UnitDescriptor('reciprocal day', 'E91', '''d⁻¹''')
ALL_UNITS.append(RECIPROCAL_DAY)
CUBIC_DECIMETRE_PER_HOUR = UnitDescriptor('cubic decimetre per hour', 'E92', '''dm³/h''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_HOUR)
KILOGRAM_PER_HOUR = UnitDescriptor('kilogram per hour', 'E93', '''kg/h''')
ALL_UNITS.append(KILOGRAM_PER_HOUR)
KILOMOLE_PER_SECOND = UnitDescriptor('kilomole per second', 'E94', '''kmol/s''')
ALL_UNITS.append(KILOMOLE_PER_SECOND)
MOLE_PER_SECOND = UnitDescriptor('mole per second', 'E95', '''mol/s''')
ALL_UNITS.append(MOLE_PER_SECOND)
DEGREE_PER_SECOND = UnitDescriptor('degree per second', 'E96', '''°/s''')
ALL_UNITS.append(DEGREE_PER_SECOND)
MILLIMETRE_PER_DEGREE_CELCIUS_METRE = UnitDescriptor('millimetre per degree Celcius metre', 'E97', '''mm/(°C·m)''')
ALL_UNITS.append(MILLIMETRE_PER_DEGREE_CELCIUS_METRE)
DEGREE_CELSIUS_PER_KELVIN = UnitDescriptor('degree Celsius per kelvin', 'E98', '''°C/K''')
ALL_UNITS.append(DEGREE_CELSIUS_PER_KELVIN)
HECTOPASCAL_PER_BAR = UnitDescriptor('hectopascal per bar', 'E99', '''hPa/bar''')
ALL_UNITS.append(HECTOPASCAL_PER_BAR)
EACH = UnitDescriptor('each', 'EA', '''''')
ALL_UNITS.append(EACH)
ELECTRONIC_MAIL_BOX = UnitDescriptor('electronic mail box', 'EB', '''''')
ALL_UNITS.append(ELECTRONIC_MAIL_BOX)
EACH_PER_MONTH = UnitDescriptor('each per month', 'EC', '''''')
ALL_UNITS.append(EACH_PER_MONTH)
ELEVEN_PACK = UnitDescriptor('eleven pack', 'EP', '''''')
ALL_UNITS.append(ELEVEN_PACK)
EQUIVALENT_GALLON = UnitDescriptor('equivalent gallon', 'EQ', '''''')
ALL_UNITS.append(EQUIVALENT_GALLON)
ENVELOPE = UnitDescriptor('envelope', 'EV', '''''')
ALL_UNITS.append(ENVELOPE)
BIT_PER_CUBIC_METRE = UnitDescriptor('bit per cubic metre', 'F01', '''bit/m³''')
ALL_UNITS.append(BIT_PER_CUBIC_METRE)
KELVIN_PER_KELVIN = UnitDescriptor('kelvin per kelvin', 'F02', '''K/K''')
ALL_UNITS.append(KELVIN_PER_KELVIN)
KILOPASCAL_PER_BAR = UnitDescriptor('kilopascal per bar', 'F03', '''kPa/bar''')
ALL_UNITS.append(KILOPASCAL_PER_BAR)
MILLIBAR_PER_BAR = UnitDescriptor('millibar per bar', 'F04', '''mbar/bar''')
ALL_UNITS.append(MILLIBAR_PER_BAR)
MEGAPASCAL_PER_BAR = UnitDescriptor('megapascal per bar', 'F05', '''MPa/bar''')
ALL_UNITS.append(MEGAPASCAL_PER_BAR)
POISE_PER_BAR = UnitDescriptor('poise per bar', 'F06', '''P/bar''')
ALL_UNITS.append(POISE_PER_BAR)
PASCAL_PER_BAR = UnitDescriptor('pascal per bar', 'F07', '''Pa/bar''')
ALL_UNITS.append(PASCAL_PER_BAR)
MILLIAMPERE_PER_INCH = UnitDescriptor('milliampere per inch', 'F08', '''mA/in''')
ALL_UNITS.append(MILLIAMPERE_PER_INCH)
THOUSAND_CUBIC_FOOT_PER_DAY = UnitDescriptor('thousand cubic foot per day', 'F1', '''''')
ALL_UNITS.append(THOUSAND_CUBIC_FOOT_PER_DAY)
KELVIN_PER_HOUR = UnitDescriptor('kelvin per hour', 'F10', '''K/h''')
ALL_UNITS.append(KELVIN_PER_HOUR)
KELVIN_PER_MINUTE = UnitDescriptor('kelvin per minute', 'F11', '''K/min''')
ALL_UNITS.append(KELVIN_PER_MINUTE)
KELVIN_PER_SECOND = UnitDescriptor('kelvin per second', 'F12', '''K/s''')
ALL_UNITS.append(KELVIN_PER_SECOND)
SLUG = UnitDescriptor('slug', 'F13', '''slug''')
ALL_UNITS.append(SLUG)
GRAM_PER_KELVIN = UnitDescriptor('gram per kelvin', 'F14', '''g/K''')
ALL_UNITS.append(GRAM_PER_KELVIN)
KILOGRAM_PER_KELVIN = UnitDescriptor('kilogram per kelvin', 'F15', '''kg/K''')
ALL_UNITS.append(KILOGRAM_PER_KELVIN)
MILLIGRAM_PER_KELVIN = UnitDescriptor('milligram per kelvin', 'F16', '''mg/K''')
ALL_UNITS.append(MILLIGRAM_PER_KELVIN)
POUND_FORCE_PER_FOOT = UnitDescriptor('pound-force per foot', 'F17', '''lbf/ft''')
ALL_UNITS.append(POUND_FORCE_PER_FOOT)
KILOGRAM_SQUARE_CENTIMETRE = UnitDescriptor('kilogram square centimetre', 'F18', '''kg·cm²''')
ALL_UNITS.append(KILOGRAM_SQUARE_CENTIMETRE)
KILOGRAM_SQUARE_MILLIMETRE = UnitDescriptor('kilogram square millimetre', 'F19', '''kg·mm²''')
ALL_UNITS.append(KILOGRAM_SQUARE_MILLIMETRE)
POUND_INCH_SQUARED = UnitDescriptor('pound inch squared', 'F20', '''lb·in²''')
ALL_UNITS.append(POUND_INCH_SQUARED)
POUND_FORCE_INCH = UnitDescriptor('pound-force inch', 'F21', '''lbf·in''')
ALL_UNITS.append(POUND_FORCE_INCH)
POUND_FORCE_FOOT_PER_AMPERE = UnitDescriptor('pound-force foot per ampere', 'F22', '''lbf·ft/A''')
ALL_UNITS.append(POUND_FORCE_FOOT_PER_AMPERE)
GRAM_PER_CUBIC_DECIMETRE = UnitDescriptor('gram per cubic decimetre', 'F23', '''g/dm³''')
ALL_UNITS.append(GRAM_PER_CUBIC_DECIMETRE)
KILOGRAM_PER_KILOMOL = UnitDescriptor('kilogram per kilomol', 'F24', '''kg/kmol''')
ALL_UNITS.append(KILOGRAM_PER_KILOMOL)
GRAM_PER_HERTZ = UnitDescriptor('gram per hertz', 'F25', '''g/Hz''')
ALL_UNITS.append(GRAM_PER_HERTZ)
GRAM_PER_DAY = UnitDescriptor('gram per day', 'F26', '''g/d''')
ALL_UNITS.append(GRAM_PER_DAY)
GRAM_PER_HOUR = UnitDescriptor('gram per hour', 'F27', '''g/h''')
ALL_UNITS.append(GRAM_PER_HOUR)
GRAM_PER_MINUTE = UnitDescriptor('gram per minute', 'F28', '''g/min''')
ALL_UNITS.append(GRAM_PER_MINUTE)
GRAM_PER_SECOND = UnitDescriptor('gram per second', 'F29', '''g/s''')
ALL_UNITS.append(GRAM_PER_SECOND)
KILOGRAM_PER_DAY = UnitDescriptor('kilogram per day', 'F30', '''kg/d''')
ALL_UNITS.append(KILOGRAM_PER_DAY)
KILOGRAM_PER_MINUTE = UnitDescriptor('kilogram per minute', 'F31', '''kg/min''')
ALL_UNITS.append(KILOGRAM_PER_MINUTE)
MILLIGRAM_PER_DAY = UnitDescriptor('milligram per day', 'F32', '''mg/d''')
ALL_UNITS.append(MILLIGRAM_PER_DAY)
MILLIGRAM_PER_MINUTE = UnitDescriptor('milligram per minute', 'F33', '''mg/min''')
ALL_UNITS.append(MILLIGRAM_PER_MINUTE)
MILLIGRAM_PER_SECOND = UnitDescriptor('milligram per second', 'F34', '''mg/s''')
ALL_UNITS.append(MILLIGRAM_PER_SECOND)
GRAM_PER_DAY_KELVIN = UnitDescriptor('gram per day kelvin', 'F35', '''g/(d·K)''')
ALL_UNITS.append(GRAM_PER_DAY_KELVIN)
GRAM_PER_HOUR_KELVIN = UnitDescriptor('gram per hour kelvin', 'F36', '''g/(h·K)''')
ALL_UNITS.append(GRAM_PER_HOUR_KELVIN)
GRAM_PER_MINUTE_KELVIN = UnitDescriptor('gram per minute kelvin', 'F37', '''g/(min·K)''')
ALL_UNITS.append(GRAM_PER_MINUTE_KELVIN)
GRAM_PER_SECOND_KELVIN = UnitDescriptor('gram per second kelvin', 'F38', '''g/(s·K)''')
ALL_UNITS.append(GRAM_PER_SECOND_KELVIN)
KILOGRAM_PER_DAY_KELVIN = UnitDescriptor('kilogram per day kelvin', 'F39', '''kg/(d·K)''')
ALL_UNITS.append(KILOGRAM_PER_DAY_KELVIN)
KILOGRAM_PER_HOUR_KELVIN = UnitDescriptor('kilogram per hour kelvin', 'F40', '''kg/(h·K)''')
ALL_UNITS.append(KILOGRAM_PER_HOUR_KELVIN)
KILOGRAM_PER_MINUTE_KELVIN = UnitDescriptor('kilogram per minute kelvin', 'F41', '''kg/(min·K)''')
ALL_UNITS.append(KILOGRAM_PER_MINUTE_KELVIN)
KILOGRAM_PER_SECOND_KELVIN = UnitDescriptor('kilogram per second kelvin', 'F42', '''kg/(s·K)''')
ALL_UNITS.append(KILOGRAM_PER_SECOND_KELVIN)
MILLIGRAM_PER_DAY_KELVIN = UnitDescriptor('milligram per day kelvin', 'F43', '''mg/(d·K)''')
ALL_UNITS.append(MILLIGRAM_PER_DAY_KELVIN)
MILLIGRAM_PER_HOUR_KELVIN = UnitDescriptor('milligram per hour kelvin', 'F44', '''mg/(h·K)''')
ALL_UNITS.append(MILLIGRAM_PER_HOUR_KELVIN)
MILLIGRAM_PER_MINUTE_KELVIN = UnitDescriptor('milligram per minute kelvin', 'F45', '''mg/(min·K)''')
ALL_UNITS.append(MILLIGRAM_PER_MINUTE_KELVIN)
MILLIGRAM_PER_SECOND_KELVIN = UnitDescriptor('milligram per second kelvin', 'F46', '''mg/(s·K)''')
ALL_UNITS.append(MILLIGRAM_PER_SECOND_KELVIN)
NEWTON_PER_MILLIMETRE = UnitDescriptor('newton per millimetre', 'F47', '''N/mm''')
ALL_UNITS.append(NEWTON_PER_MILLIMETRE)
POUND_FORCE_PER_INCH = UnitDescriptor('pound-force per inch', 'F48', '''lbf/in''')
ALL_UNITS.append(POUND_FORCE_PER_INCH)
ROD_UNIT_OF_DISTANCE = UnitDescriptor('rod [unit of distance]', 'F49', '''rd (US)''')
ALL_UNITS.append(ROD_UNIT_OF_DISTANCE)
MICROMETRE_PER_KELVIN = UnitDescriptor('micrometre per kelvin', 'F50', '''µm/K''')
ALL_UNITS.append(MICROMETRE_PER_KELVIN)
CENTIMETRE_PER_KELVIN = UnitDescriptor('centimetre per kelvin', 'F51', '''cm/K''')
ALL_UNITS.append(CENTIMETRE_PER_KELVIN)
METRE_PER_KELVIN = UnitDescriptor('metre per kelvin', 'F52', '''m/K''')
ALL_UNITS.append(METRE_PER_KELVIN)
MILLIMETRE_PER_KELVIN = UnitDescriptor('millimetre per kelvin', 'F53', '''mm/K''')
ALL_UNITS.append(MILLIMETRE_PER_KELVIN)
MILLIOHM_PER_METRE = UnitDescriptor('milliohm per metre', 'F54', '''mΩ/m''')
ALL_UNITS.append(MILLIOHM_PER_METRE)
OHM_PER_MILE_STATUTE_MILE = UnitDescriptor('ohm per mile (statute mile)', 'F55', '''Ω/mi''')
ALL_UNITS.append(OHM_PER_MILE_STATUTE_MILE)
OHM_PER_KILOMETRE = UnitDescriptor('ohm per kilometre', 'F56', '''Ω/km''')
ALL_UNITS.append(OHM_PER_KILOMETRE)
MILLIAMPERE_PER_POUND_FORCE_PER_SQUARE_INCH = UnitDescriptor('milliampere per pound-force per square inch', 'F57', '''mA/(lbf/in²)''')
ALL_UNITS.append(MILLIAMPERE_PER_POUND_FORCE_PER_SQUARE_INCH)
RECIPROCAL_BAR = UnitDescriptor('reciprocal bar', 'F58', '''1/bar''')
ALL_UNITS.append(RECIPROCAL_BAR)
MILLIAMPERE_PER_BAR = UnitDescriptor('milliampere per bar', 'F59', '''mA/bar''')
ALL_UNITS.append(MILLIAMPERE_PER_BAR)
DEGREE_CELSIUS_PER_BAR = UnitDescriptor('degree Celsius per bar', 'F60', '''°C/bar''')
ALL_UNITS.append(DEGREE_CELSIUS_PER_BAR)
KELVIN_PER_BAR = UnitDescriptor('kelvin per bar', 'F61', '''K/bar''')
ALL_UNITS.append(KELVIN_PER_BAR)
GRAM_PER_DAY_BAR = UnitDescriptor('gram per day bar', 'F62', '''g/(d·bar)''')
ALL_UNITS.append(GRAM_PER_DAY_BAR)
GRAM_PER_HOUR_BAR = UnitDescriptor('gram per hour bar', 'F63', '''g/(h·bar)''')
ALL_UNITS.append(GRAM_PER_HOUR_BAR)
GRAM_PER_MINUTE_BAR = UnitDescriptor('gram per minute bar', 'F64', '''g/(min·bar)''')
ALL_UNITS.append(GRAM_PER_MINUTE_BAR)
GRAM_PER_SECOND_BAR = UnitDescriptor('gram per second bar', 'F65', '''g/(s·bar)''')
ALL_UNITS.append(GRAM_PER_SECOND_BAR)
KILOGRAM_PER_DAY_BAR = UnitDescriptor('kilogram per day bar', 'F66', '''kg/(d·bar)''')
ALL_UNITS.append(KILOGRAM_PER_DAY_BAR)
KILOGRAM_PER_HOUR_BAR = UnitDescriptor('kilogram per hour bar', 'F67', '''kg/(h·bar)''')
ALL_UNITS.append(KILOGRAM_PER_HOUR_BAR)
KILOGRAM_PER_MINUTE_BAR = UnitDescriptor('kilogram per minute bar', 'F68', '''kg/(min·bar)''')
ALL_UNITS.append(KILOGRAM_PER_MINUTE_BAR)
KILOGRAM_PER_SECOND_BAR = UnitDescriptor('kilogram per second bar', 'F69', '''kg/(s·bar)''')
ALL_UNITS.append(KILOGRAM_PER_SECOND_BAR)
MILLIGRAM_PER_DAY_BAR = UnitDescriptor('milligram per day bar', 'F70', '''mg/(d·bar)''')
ALL_UNITS.append(MILLIGRAM_PER_DAY_BAR)
MILLIGRAM_PER_HOUR_BAR = UnitDescriptor('milligram per hour bar', 'F71', '''mg/(h·bar)''')
ALL_UNITS.append(MILLIGRAM_PER_HOUR_BAR)
MILLIGRAM_PER_MINUTE_BAR = UnitDescriptor('milligram per minute bar', 'F72', '''mg/(min·bar)''')
ALL_UNITS.append(MILLIGRAM_PER_MINUTE_BAR)
MILLIGRAM_PER_SECOND_BAR = UnitDescriptor('milligram per second bar', 'F73', '''mg/(s·bar)''')
ALL_UNITS.append(MILLIGRAM_PER_SECOND_BAR)
GRAM_PER_BAR = UnitDescriptor('gram per bar', 'F74', '''g/bar''')
ALL_UNITS.append(GRAM_PER_BAR)
MILLIGRAM_PER_BAR = UnitDescriptor('milligram per bar', 'F75', '''mg/bar''')
ALL_UNITS.append(MILLIGRAM_PER_BAR)
MILLIAMPERE_PER_MILLIMETRE = UnitDescriptor('milliampere per millimetre', 'F76', '''mA/mm''')
ALL_UNITS.append(MILLIAMPERE_PER_MILLIMETRE)
PASCAL_SECOND_PER_KELVIN = UnitDescriptor('pascal second per kelvin', 'F77', '''Pa.s/K''')
ALL_UNITS.append(PASCAL_SECOND_PER_KELVIN)
INCH_OF_WATER = UnitDescriptor('inch of water', 'F78', '''inH₂O''')
ALL_UNITS.append(INCH_OF_WATER)
INCH_OF_MERCURY = UnitDescriptor('inch of mercury', 'F79', '''inHg''')
ALL_UNITS.append(INCH_OF_MERCURY)
WATER_HORSE_POWER = UnitDescriptor('water horse power', 'F80', '''''')
ALL_UNITS.append(WATER_HORSE_POWER)
BAR_PER_KELVIN = UnitDescriptor('bar per kelvin', 'F81', '''bar/K''')
ALL_UNITS.append(BAR_PER_KELVIN)
HECTOPASCAL_PER_KELVIN = UnitDescriptor('hectopascal per kelvin', 'F82', '''hPa/K''')
ALL_UNITS.append(HECTOPASCAL_PER_KELVIN)
KILOPASCAL_PER_KELVIN = UnitDescriptor('kilopascal per kelvin', 'F83', '''kPa/K''')
ALL_UNITS.append(KILOPASCAL_PER_KELVIN)
MILLIBAR_PER_KELVIN = UnitDescriptor('millibar per kelvin', 'F84', '''mbar/K''')
ALL_UNITS.append(MILLIBAR_PER_KELVIN)
MEGAPASCAL_PER_KELVIN = UnitDescriptor('megapascal per kelvin', 'F85', '''MPa/K''')
ALL_UNITS.append(MEGAPASCAL_PER_KELVIN)
POISE_PER_KELVIN = UnitDescriptor('poise per kelvin', 'F86', '''P/K''')
ALL_UNITS.append(POISE_PER_KELVIN)
VOLT_PER_LITRE_MINUTE = UnitDescriptor('volt per litre minute', 'F87', '''V/(l·min)''')
ALL_UNITS.append(VOLT_PER_LITRE_MINUTE)
NEWTON_CENTIMETRE = UnitDescriptor('newton centimetre', 'F88', '''N·cm''')
ALL_UNITS.append(NEWTON_CENTIMETRE)
NEWTON_METRE_PER_DEGREE = UnitDescriptor('newton metre per degree', 'F89', '''Nm/°''')
ALL_UNITS.append(NEWTON_METRE_PER_DEGREE)
FIBRE_PER_CUBIC_CENTIMETRE_OF_AIR = UnitDescriptor('fibre per cubic centimetre of air', 'F9', '''''')
ALL_UNITS.append(FIBRE_PER_CUBIC_CENTIMETRE_OF_AIR)
NEWTON_METRE_PER_AMPERE = UnitDescriptor('newton metre per ampere', 'F90', '''N·m/A''')
ALL_UNITS.append(NEWTON_METRE_PER_AMPERE)
BAR_LITRE_PER_SECOND = UnitDescriptor('bar litre per second', 'F91', '''bar·l/s''')
ALL_UNITS.append(BAR_LITRE_PER_SECOND)
BAR_CUBIC_METRE_PER_SECOND = UnitDescriptor('bar cubic metre per second', 'F92', '''bar·m³/s''')
ALL_UNITS.append(BAR_CUBIC_METRE_PER_SECOND)
HECTOPASCAL_LITRE_PER_SECOND = UnitDescriptor('hectopascal litre per second', 'F93', '''hPa·l/s''')
ALL_UNITS.append(HECTOPASCAL_LITRE_PER_SECOND)
HECTOPASCAL_CUBIC_METRE_PER_SECOND = UnitDescriptor('hectopascal cubic metre per second', 'F94', '''hPa·m³/s''')
ALL_UNITS.append(HECTOPASCAL_CUBIC_METRE_PER_SECOND)
MILLIBAR_LITRE_PER_SECOND = UnitDescriptor('millibar litre per second', 'F95', '''mbar·l/s''')
ALL_UNITS.append(MILLIBAR_LITRE_PER_SECOND)
MILLIBAR_CUBIC_METRE_PER_SECOND = UnitDescriptor('millibar cubic metre per second', 'F96', '''mbar·m³/s''')
ALL_UNITS.append(MILLIBAR_CUBIC_METRE_PER_SECOND)
MEGAPASCAL_LITRE_PER_SECOND = UnitDescriptor('megapascal litre per second', 'F97', '''MPa·l/s''')
ALL_UNITS.append(MEGAPASCAL_LITRE_PER_SECOND)
MEGAPASCAL_CUBIC_METRE_PER_SECOND = UnitDescriptor('megapascal cubic metre per second', 'F98', '''MPa·m³/s''')
ALL_UNITS.append(MEGAPASCAL_CUBIC_METRE_PER_SECOND)
PASCAL_LITRE_PER_SECOND = UnitDescriptor('pascal litre per second', 'F99', '''Pa·l/s''')
ALL_UNITS.append(PASCAL_LITRE_PER_SECOND)
DEGREE_FAHRENHEIT = UnitDescriptor('degree Fahrenheit', 'FAH', '''°F''')
ALL_UNITS.append(DEGREE_FAHRENHEIT)
FARAD = UnitDescriptor('farad', 'FAR', '''F''')
ALL_UNITS.append(FARAD)
FIELD = UnitDescriptor('field', 'FB', '''''')
ALL_UNITS.append(FIELD)
FIBRE_METRE = UnitDescriptor('fibre metre', 'FBM', '''''')
ALL_UNITS.append(FIBRE_METRE)
THOUSAND_CUBIC_FOOT = UnitDescriptor('thousand cubic foot', 'FC', '''kft³''')
ALL_UNITS.append(THOUSAND_CUBIC_FOOT)
MILLION_PARTICLE_PER_CUBIC_FOOT = UnitDescriptor('million particle per cubic foot', 'FD', '''''')
ALL_UNITS.append(MILLION_PARTICLE_PER_CUBIC_FOOT)
TRACK_FOOT = UnitDescriptor('track foot', 'FE', '''''')
ALL_UNITS.append(TRACK_FOOT)
HUNDRED_CUBIC_METRE = UnitDescriptor('hundred cubic metre', 'FF', '''''')
ALL_UNITS.append(HUNDRED_CUBIC_METRE)
TRANSDERMAL_PATCH = UnitDescriptor('transdermal patch', 'FG', '''''')
ALL_UNITS.append(TRANSDERMAL_PATCH)
MICROMOLE = UnitDescriptor('micromole', 'FH', '''µmol''')
ALL_UNITS.append(MICROMOLE)
FAILURES_IN_TIME = UnitDescriptor('failures in time', 'FIT', '''FIT''')
ALL_UNITS.append(FAILURES_IN_TIME)
FLAKE_TON = UnitDescriptor('flake ton', 'FL', '''''')
ALL_UNITS.append(FLAKE_TON)
MILLION_CUBIC_FOOT = UnitDescriptor('million cubic foot', 'FM', '''Mft³''')
ALL_UNITS.append(MILLION_CUBIC_FOOT)
FOOT = UnitDescriptor('foot', 'FOT', '''ft''')
ALL_UNITS.append(FOOT)
POUND_PER_SQUARE_FOOT = UnitDescriptor('pound per square foot', 'FP', '''lb/ft²''')
ALL_UNITS.append(POUND_PER_SQUARE_FOOT)
FOOT_PER_MINUTE = UnitDescriptor('foot per minute', 'FR', '''ft/min''')
ALL_UNITS.append(FOOT_PER_MINUTE)
FOOT_PER_SECOND = UnitDescriptor('foot per second', 'FS', '''ft/s''')
ALL_UNITS.append(FOOT_PER_SECOND)
SQUARE_FOOT = UnitDescriptor('square foot', 'FTK', '''ft²''')
ALL_UNITS.append(SQUARE_FOOT)
CUBIC_FOOT = UnitDescriptor('cubic foot', 'FTQ', '''ft³''')
ALL_UNITS.append(CUBIC_FOOT)
PASCAL_CUBIC_METRE_PER_SECOND = UnitDescriptor('pascal cubic metre per second', 'G01', '''Pa·m³/s''')
ALL_UNITS.append(PASCAL_CUBIC_METRE_PER_SECOND)
CENTIMETRE_PER_BAR = UnitDescriptor('centimetre per bar', 'G04', '''cm/bar''')
ALL_UNITS.append(CENTIMETRE_PER_BAR)
METRE_PER_BAR = UnitDescriptor('metre per bar', 'G05', '''m/bar''')
ALL_UNITS.append(METRE_PER_BAR)
MILLIMETRE_PER_BAR = UnitDescriptor('millimetre per bar', 'G06', '''mm/bar''')
ALL_UNITS.append(MILLIMETRE_PER_BAR)
SQUARE_INCH_PER_SECOND = UnitDescriptor('square inch per second', 'G08', '''in²/s''')
ALL_UNITS.append(SQUARE_INCH_PER_SECOND)
SQUARE_METRE_PER_SECOND_KELVIN = UnitDescriptor('square metre per second kelvin', 'G09', '''m²/(s·K)''')
ALL_UNITS.append(SQUARE_METRE_PER_SECOND_KELVIN)
STOKES_PER_KELVIN = UnitDescriptor('stokes per kelvin', 'G10', '''St/K''')
ALL_UNITS.append(STOKES_PER_KELVIN)
GRAM_PER_CUBIC_CENTIMETRE_BAR = UnitDescriptor('gram per cubic centimetre bar', 'G11', '''g/(cm³·bar)''')
ALL_UNITS.append(GRAM_PER_CUBIC_CENTIMETRE_BAR)
GRAM_PER_CUBIC_DECIMETRE_BAR = UnitDescriptor('gram per cubic decimetre bar', 'G12', '''g/(dm³·bar)''')
ALL_UNITS.append(GRAM_PER_CUBIC_DECIMETRE_BAR)
GRAM_PER_LITRE_BAR = UnitDescriptor('gram per litre bar', 'G13', '''g/(l·bar)''')
ALL_UNITS.append(GRAM_PER_LITRE_BAR)
GRAM_PER_CUBIC_METRE_BAR = UnitDescriptor('gram per cubic metre bar', 'G14', '''g/(m³·bar)''')
ALL_UNITS.append(GRAM_PER_CUBIC_METRE_BAR)
GRAM_PER_MILLILITRE_BAR = UnitDescriptor('gram per millilitre bar', 'G15', '''g/(ml·bar)''')
ALL_UNITS.append(GRAM_PER_MILLILITRE_BAR)
KILOGRAM_PER_CUBIC_CENTIMETRE_BAR = UnitDescriptor('kilogram per cubic centimetre bar', 'G16', '''kg/(cm³·bar)''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_CENTIMETRE_BAR)
KILOGRAM_PER_LITRE_BAR = UnitDescriptor('kilogram per litre bar', 'G17', '''kg/(l·bar)''')
ALL_UNITS.append(KILOGRAM_PER_LITRE_BAR)
KILOGRAM_PER_CUBIC_METRE_BAR = UnitDescriptor('kilogram per cubic metre bar', 'G18', '''kg/(m³·bar)''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_METRE_BAR)
NEWTON_METRE_PER_KILOGRAM = UnitDescriptor('newton metre per kilogram', 'G19', '''N·m/kg''')
ALL_UNITS.append(NEWTON_METRE_PER_KILOGRAM)
US_GALLON_PER_MINUTE = UnitDescriptor('US gallon per minute', 'G2', '''gal (US) /min''')
ALL_UNITS.append(US_GALLON_PER_MINUTE)
POUND_FORCE_FOOT_PER_POUND = UnitDescriptor('pound-force foot per pound', 'G20', '''lbf·ft/lb''')
ALL_UNITS.append(POUND_FORCE_FOOT_PER_POUND)
CUP_UNIT_OF_VOLUME = UnitDescriptor('cup [unit of volume]', 'G21', '''cup (US)''')
ALL_UNITS.append(CUP_UNIT_OF_VOLUME)
PECK = UnitDescriptor('peck', 'G23', '''pk (US)''')
ALL_UNITS.append(PECK)
TABLESPOON_US = UnitDescriptor('tablespoon (US)', 'G24', '''tablespoon (US)''')
ALL_UNITS.append(TABLESPOON_US)
TEASPOON_US = UnitDescriptor('teaspoon (US)', 'G25', '''teaspoon (US)''')
ALL_UNITS.append(TEASPOON_US)
STERE = UnitDescriptor('stere', 'G26', '''st''')
ALL_UNITS.append(STERE)
CUBIC_CENTIMETRE_PER_KELVIN = UnitDescriptor('cubic centimetre per kelvin', 'G27', '''cm³/K''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_KELVIN)
LITRE_PER_KELVIN = UnitDescriptor('litre per kelvin', 'G28', '''l/K''')
ALL_UNITS.append(LITRE_PER_KELVIN)
CUBIC_METRE_PER_KELVIN = UnitDescriptor('cubic metre per kelvin', 'G29', '''m³/K''')
ALL_UNITS.append(CUBIC_METRE_PER_KELVIN)
IMPERIAL_GALLON_PER_MINUTE = UnitDescriptor('Imperial gallon per minute', 'G3', '''gal (UK) /min''')
ALL_UNITS.append(IMPERIAL_GALLON_PER_MINUTE)
MILLILITRE_PER_KELVIN = UnitDescriptor('millilitre per kelvin', 'G30', '''ml/K''')
ALL_UNITS.append(MILLILITRE_PER_KELVIN)
KILOGRAM_PER_CUBIC_CENTIMETRE = UnitDescriptor('kilogram per cubic centimetre', 'G31', '''kg/cm³''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_CENTIMETRE)
OUNCE_AVOIRDUPOIS_PER_CUBIC_YARD = UnitDescriptor('ounce (avoirdupois) per cubic yard', 'G32', '''oz/yd³''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_CUBIC_YARD)
GRAM_PER_CUBIC_CENTIMETRE_KELVIN = UnitDescriptor('gram per cubic centimetre kelvin', 'G33', '''g/(cm³·K)''')
ALL_UNITS.append(GRAM_PER_CUBIC_CENTIMETRE_KELVIN)
GRAM_PER_CUBIC_DECIMETRE_KELVIN = UnitDescriptor('gram per cubic decimetre kelvin', 'G34', '''g/(dm³·K)''')
ALL_UNITS.append(GRAM_PER_CUBIC_DECIMETRE_KELVIN)
GRAM_PER_LITRE_KELVIN = UnitDescriptor('gram per litre kelvin', 'G35', '''g/(l·K)''')
ALL_UNITS.append(GRAM_PER_LITRE_KELVIN)
GRAM_PER_CUBIC_METRE_KELVIN = UnitDescriptor('gram per cubic metre kelvin', 'G36', '''g/(m³·K)''')
ALL_UNITS.append(GRAM_PER_CUBIC_METRE_KELVIN)
GRAM_PER_MILLILITRE_KELVIN = UnitDescriptor('gram per millilitre kelvin', 'G37', '''g/(ml·K)''')
ALL_UNITS.append(GRAM_PER_MILLILITRE_KELVIN)
KILOGRAM_PER_CUBIC_CENTIMETRE_KELVIN = UnitDescriptor('kilogram per cubic centimetre kelvin', 'G38', '''kg/(cm³·K)''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_CENTIMETRE_KELVIN)
KILOGRAM_PER_LITRE_KELVIN = UnitDescriptor('kilogram per litre kelvin', 'G39', '''kg/(l·K)''')
ALL_UNITS.append(KILOGRAM_PER_LITRE_KELVIN)
KILOGRAM_PER_CUBIC_METRE_KELVIN = UnitDescriptor('kilogram per cubic metre kelvin', 'G40', '''kg/(m³·K)''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_METRE_KELVIN)
SQUARE_METRE_PER_SECOND_BAR = UnitDescriptor('square metre per second bar', 'G41', '''m²/(s·bar)''')
ALL_UNITS.append(SQUARE_METRE_PER_SECOND_BAR)
MICROSIEMENS_PER_CENTIMETRE = UnitDescriptor('microsiemens per centimetre', 'G42', '''µS/cm''')
ALL_UNITS.append(MICROSIEMENS_PER_CENTIMETRE)
MICROSIEMENS_PER_METRE = UnitDescriptor('microsiemens per metre', 'G43', '''µS/m''')
ALL_UNITS.append(MICROSIEMENS_PER_METRE)
NANOSIEMENS_PER_CENTIMETRE = UnitDescriptor('nanosiemens per centimetre', 'G44', '''nS/cm''')
ALL_UNITS.append(NANOSIEMENS_PER_CENTIMETRE)
NANOSIEMENS_PER_METRE = UnitDescriptor('nanosiemens per metre', 'G45', '''nS/m''')
ALL_UNITS.append(NANOSIEMENS_PER_METRE)
STOKES_PER_BAR = UnitDescriptor('stokes per bar', 'G46', '''St/bar''')
ALL_UNITS.append(STOKES_PER_BAR)
CUBIC_CENTIMETRE_PER_DAY = UnitDescriptor('cubic centimetre per day', 'G47', '''cm³/d''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_DAY)
CUBIC_CENTIMETRE_PER_HOUR = UnitDescriptor('cubic centimetre per hour', 'G48', '''cm³/h''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_HOUR)
CUBIC_CENTIMETRE_PER_MINUTE = UnitDescriptor('cubic centimetre per minute', 'G49', '''cm³/min''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_MINUTE)
GALLON_US_PER_HOUR = UnitDescriptor('gallon (US) per hour', 'G50', '''gal/h''')
ALL_UNITS.append(GALLON_US_PER_HOUR)
LITRE_PER_SECOND = UnitDescriptor('litre per second', 'G51', '''l/s''')
ALL_UNITS.append(LITRE_PER_SECOND)
CUBIC_METRE_PER_DAY = UnitDescriptor('cubic metre per day', 'G52', '''m³/d''')
ALL_UNITS.append(CUBIC_METRE_PER_DAY)
CUBIC_METRE_PER_MINUTE = UnitDescriptor('cubic metre per minute', 'G53', '''m³/min''')
ALL_UNITS.append(CUBIC_METRE_PER_MINUTE)
MILLILITRE_PER_DAY = UnitDescriptor('millilitre per day', 'G54', '''ml/d''')
ALL_UNITS.append(MILLILITRE_PER_DAY)
MILLILITRE_PER_HOUR = UnitDescriptor('millilitre per hour', 'G55', '''ml/h''')
ALL_UNITS.append(MILLILITRE_PER_HOUR)
CUBIC_INCH_PER_HOUR = UnitDescriptor('cubic inch per hour', 'G56', '''in³/h''')
ALL_UNITS.append(CUBIC_INCH_PER_HOUR)
CUBIC_INCH_PER_MINUTE = UnitDescriptor('cubic inch per minute', 'G57', '''in³/min''')
ALL_UNITS.append(CUBIC_INCH_PER_MINUTE)
CUBIC_INCH_PER_SECOND = UnitDescriptor('cubic inch per second', 'G58', '''in³/s''')
ALL_UNITS.append(CUBIC_INCH_PER_SECOND)
MILLIAMPERE_PER_LITRE_MINUTE = UnitDescriptor('milliampere per litre minute', 'G59', '''mA/(l·min)''')
ALL_UNITS.append(MILLIAMPERE_PER_LITRE_MINUTE)
VOLT_PER_BAR = UnitDescriptor('volt per bar', 'G60', '''V/bar''')
ALL_UNITS.append(VOLT_PER_BAR)
CUBIC_CENTIMETRE_PER_DAY_KELVIN = UnitDescriptor('cubic centimetre per day kelvin', 'G61', '''cm³/(d·K)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_DAY_KELVIN)
CUBIC_CENTIMETRE_PER_HOUR_KELVIN = UnitDescriptor('cubic centimetre per hour kelvin', 'G62', '''cm³/(h·K)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_HOUR_KELVIN)
CUBIC_CENTIMETRE_PER_MINUTE_KELVIN = UnitDescriptor('cubic centimetre per minute kelvin', 'G63', '''cm³/(min·K)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_MINUTE_KELVIN)
CUBIC_CENTIMETRE_PER_SECOND_KELVIN = UnitDescriptor('cubic centimetre per second kelvin', 'G64', '''cm³/(s·K)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_SECOND_KELVIN)
LITRE_PER_DAY_KELVIN = UnitDescriptor('litre per day kelvin', 'G65', '''l/(d·K)''')
ALL_UNITS.append(LITRE_PER_DAY_KELVIN)
LITRE_PER_HOUR_KELVIN = UnitDescriptor('litre per hour kelvin', 'G66', '''l/(h·K)''')
ALL_UNITS.append(LITRE_PER_HOUR_KELVIN)
LITRE_PER_MINUTE_KELVIN = UnitDescriptor('litre per minute kelvin', 'G67', '''l/(min·K)''')
ALL_UNITS.append(LITRE_PER_MINUTE_KELVIN)
LITRE_PER_SECOND_KELVIN = UnitDescriptor('litre per second kelvin', 'G68', '''l/(s·K)''')
ALL_UNITS.append(LITRE_PER_SECOND_KELVIN)
CUBIC_METRE_PER_DAY_KELVIN = UnitDescriptor('cubic metre per day kelvin', 'G69', '''m³/(d·K)''')
ALL_UNITS.append(CUBIC_METRE_PER_DAY_KELVIN)
MICROFICHE_SHEET = UnitDescriptor('microfiche sheet', 'G7', '''''')
ALL_UNITS.append(MICROFICHE_SHEET)
CUBIC_METRE_PER_HOUR_KELVIN = UnitDescriptor('cubic metre per hour kelvin', 'G70', '''m³/(h·K)''')
ALL_UNITS.append(CUBIC_METRE_PER_HOUR_KELVIN)
CUBIC_METRE_PER_MINUTE_KELVIN = UnitDescriptor('cubic metre per minute kelvin', 'G71', '''m³/(min·K)''')
ALL_UNITS.append(CUBIC_METRE_PER_MINUTE_KELVIN)
CUBIC_METRE_PER_SECOND_KELVIN = UnitDescriptor('cubic metre per second kelvin', 'G72', '''m³/(s·K)''')
ALL_UNITS.append(CUBIC_METRE_PER_SECOND_KELVIN)
MILLILITRE_PER_DAY_KELVIN = UnitDescriptor('millilitre per day kelvin', 'G73', '''ml/(d·K)''')
ALL_UNITS.append(MILLILITRE_PER_DAY_KELVIN)
MILLILITRE_PER_HOUR_KELVIN = UnitDescriptor('millilitre per hour kelvin', 'G74', '''ml/(h·K)''')
ALL_UNITS.append(MILLILITRE_PER_HOUR_KELVIN)
MILLILITRE_PER_MINUTE_KELVIN = UnitDescriptor('millilitre per minute kelvin', 'G75', '''ml/(min·K)''')
ALL_UNITS.append(MILLILITRE_PER_MINUTE_KELVIN)
MILLILITRE_PER_SECOND_KELVIN = UnitDescriptor('millilitre per second kelvin', 'G76', '''ml/(s·K)''')
ALL_UNITS.append(MILLILITRE_PER_SECOND_KELVIN)
MILLIMETRE_TO_THE_FOURTH_POWER = UnitDescriptor('millimetre to the fourth power', 'G77', '''mm⁴''')
ALL_UNITS.append(MILLIMETRE_TO_THE_FOURTH_POWER)
CUBIC_CENTIMETRE_PER_DAY_BAR = UnitDescriptor('cubic centimetre per day bar', 'G78', '''cm³/(d·bar)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_DAY_BAR)
CUBIC_CENTIMETRE_PER_HOUR_BAR = UnitDescriptor('cubic centimetre per hour bar', 'G79', '''cm³/(h·bar)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_HOUR_BAR)
CUBIC_CENTIMETRE_PER_MINUTE_BAR = UnitDescriptor('cubic centimetre per minute bar', 'G80', '''cm³/(min·bar)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_MINUTE_BAR)
CUBIC_CENTIMETRE_PER_SECOND_BAR = UnitDescriptor('cubic centimetre per second bar', 'G81', '''cm³/(s·bar)''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_SECOND_BAR)
LITRE_PER_DAY_BAR = UnitDescriptor('litre per day bar', 'G82', '''l/(d·bar)''')
ALL_UNITS.append(LITRE_PER_DAY_BAR)
LITRE_PER_HOUR_BAR = UnitDescriptor('litre per hour bar', 'G83', '''l/(h·bar)''')
ALL_UNITS.append(LITRE_PER_HOUR_BAR)
LITRE_PER_MINUTE_BAR = UnitDescriptor('litre per minute bar', 'G84', '''l/(min·bar)''')
ALL_UNITS.append(LITRE_PER_MINUTE_BAR)
LITRE_PER_SECOND_BAR = UnitDescriptor('litre per second bar', 'G85', '''l/(s·bar)''')
ALL_UNITS.append(LITRE_PER_SECOND_BAR)
CUBIC_METRE_PER_DAY_BAR = UnitDescriptor('cubic metre per day bar', 'G86', '''m³/(d·bar)''')
ALL_UNITS.append(CUBIC_METRE_PER_DAY_BAR)
CUBIC_METRE_PER_HOUR_BAR = UnitDescriptor('cubic metre per hour bar', 'G87', '''m³/(h·bar)''')
ALL_UNITS.append(CUBIC_METRE_PER_HOUR_BAR)
CUBIC_METRE_PER_MINUTE_BAR = UnitDescriptor('cubic metre per minute bar', 'G88', '''m³/(min·bar)''')
ALL_UNITS.append(CUBIC_METRE_PER_MINUTE_BAR)
CUBIC_METRE_PER_SECOND_BAR = UnitDescriptor('cubic metre per second bar', 'G89', '''m³/(s·bar)''')
ALL_UNITS.append(CUBIC_METRE_PER_SECOND_BAR)
MILLILITRE_PER_DAY_BAR = UnitDescriptor('millilitre per day bar', 'G90', '''ml/(d·bar)''')
ALL_UNITS.append(MILLILITRE_PER_DAY_BAR)
MILLILITRE_PER_HOUR_BAR = UnitDescriptor('millilitre per hour bar', 'G91', '''ml/(h·bar)''')
ALL_UNITS.append(MILLILITRE_PER_HOUR_BAR)
MILLILITRE_PER_MINUTE_BAR = UnitDescriptor('millilitre per minute bar', 'G92', '''ml/(min·bar)''')
ALL_UNITS.append(MILLILITRE_PER_MINUTE_BAR)
MILLILITRE_PER_SECOND_BAR = UnitDescriptor('millilitre per second bar', 'G93', '''ml/(s·bar)''')
ALL_UNITS.append(MILLILITRE_PER_SECOND_BAR)
CUBIC_CENTIMETRE_PER_BAR = UnitDescriptor('cubic centimetre per bar', 'G94', '''cm³/bar''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_BAR)
LITRE_PER_BAR = UnitDescriptor('litre per bar', 'G95', '''l/bar''')
ALL_UNITS.append(LITRE_PER_BAR)
CUBIC_METRE_PER_BAR = UnitDescriptor('cubic metre per bar', 'G96', '''m³/bar''')
ALL_UNITS.append(CUBIC_METRE_PER_BAR)
MILLILITRE_PER_BAR = UnitDescriptor('millilitre per bar', 'G97', '''ml/bar''')
ALL_UNITS.append(MILLILITRE_PER_BAR)
MICROHENRY_PER_KILOOHM = UnitDescriptor('microhenry per kiloohm', 'G98', '''µH/kΩ''')
ALL_UNITS.append(MICROHENRY_PER_KILOOHM)
MICROHENRY_PER_OHM = UnitDescriptor('microhenry per ohm', 'G99', '''µH/Ω''')
ALL_UNITS.append(MICROHENRY_PER_OHM)
GALLON_US_PER_DAY = UnitDescriptor('gallon (US) per day', 'GB', '''gal (US)/d''')
ALL_UNITS.append(GALLON_US_PER_DAY)
GIGABECQUEREL = UnitDescriptor('gigabecquerel', 'GBQ', '''GBq''')
ALL_UNITS.append(GIGABECQUEREL)
GRAM_PER_100_GRAM = UnitDescriptor('gram per 100 gram', 'GC', '''''')
ALL_UNITS.append(GRAM_PER_100_GRAM)
GROSS_BARREL = UnitDescriptor('gross barrel', 'GD', '''''')
ALL_UNITS.append(GROSS_BARREL)
GRAM_DRY_WEIGHT = UnitDescriptor('gram, dry weight', 'GDW', '''''')
ALL_UNITS.append(GRAM_DRY_WEIGHT)
POUND_PER_GALLON_US = UnitDescriptor('pound per gallon (US)', 'GE', '''lb/gal (US)''')
ALL_UNITS.append(POUND_PER_GALLON_US)
GRAM_PER_METRE_GRAM_PER_100_CENTIMETRES = UnitDescriptor('gram per metre (gram per 100 centimetres)', 'GF', '''g/m''')
ALL_UNITS.append(GRAM_PER_METRE_GRAM_PER_100_CENTIMETRES)
GRAM_OF_FISSILE_ISOTOPE = UnitDescriptor('gram of fissile isotope', 'GFI', '''gi F/S''')
ALL_UNITS.append(GRAM_OF_FISSILE_ISOTOPE)
GREAT_GROSS = UnitDescriptor('great gross', 'GGR', '''''')
ALL_UNITS.append(GREAT_GROSS)
HALF_GALLON_US = UnitDescriptor('half gallon (US)', 'GH', '''''')
ALL_UNITS.append(HALF_GALLON_US)
GILL_US = UnitDescriptor('gill (US)', 'GIA', '''gi (US)''')
ALL_UNITS.append(GILL_US)
GRAM_INCLUDING_CONTAINER = UnitDescriptor('gram, including container', 'GIC', '''''')
ALL_UNITS.append(GRAM_INCLUDING_CONTAINER)
GILL_UK = UnitDescriptor('gill (UK)', 'GII', '''gi (UK)''')
ALL_UNITS.append(GILL_UK)
GRAM_INCLUDING_INNER_PACKAGING = UnitDescriptor('gram, including inner packaging', 'GIP', '''''')
ALL_UNITS.append(GRAM_INCLUDING_INNER_PACKAGING)
GRAM_PER_MILLILITRE = UnitDescriptor('gram per millilitre', 'GJ', '''g/ml''')
ALL_UNITS.append(GRAM_PER_MILLILITRE)
GRAM_PER_KILOGRAM = UnitDescriptor('gram per kilogram', 'GK', '''''')
ALL_UNITS.append(GRAM_PER_KILOGRAM)
GRAM_PER_LITRE = UnitDescriptor('gram per litre', 'GL', '''g/l''')
ALL_UNITS.append(GRAM_PER_LITRE)
DRY_GALLON_US = UnitDescriptor('dry gallon (US)', 'GLD', '''dry gal (US)''')
ALL_UNITS.append(DRY_GALLON_US)
GALLON_UK = UnitDescriptor('gallon (UK)', 'GLI', '''gal (UK)''')
ALL_UNITS.append(GALLON_UK)
GALLON_US = UnitDescriptor('gallon (US)', 'GLL', '''gal (US)''')
ALL_UNITS.append(GALLON_US)
GRAM_PER_SQUARE_METRE = UnitDescriptor('gram per square metre', 'GM', '''g/m²''')
ALL_UNITS.append(GRAM_PER_SQUARE_METRE)
GROSS_GALLON = UnitDescriptor('gross gallon', 'GN', '''''')
ALL_UNITS.append(GROSS_GALLON)
MILLIGRAM_PER_SQUARE_METRE = UnitDescriptor('milligram per square metre', 'GO', '''mg/m²''')
ALL_UNITS.append(MILLIGRAM_PER_SQUARE_METRE)
MILLIGRAM_PER_CUBIC_METRE = UnitDescriptor('milligram per cubic metre', 'GP', '''mg/m³''')
ALL_UNITS.append(MILLIGRAM_PER_CUBIC_METRE)
MICROGRAM_PER_CUBIC_METRE = UnitDescriptor('microgram per cubic metre', 'GQ', '''µg/m³''')
ALL_UNITS.append(MICROGRAM_PER_CUBIC_METRE)
GRAM = UnitDescriptor('gram', 'GRM', '''g''')
ALL_UNITS.append(GRAM)
GRAIN = UnitDescriptor('grain', 'GRN', '''gr''')
ALL_UNITS.append(GRAIN)
GROSS = UnitDescriptor('gross', 'GRO', '''gr''')
ALL_UNITS.append(GROSS)
GROSS_REGISTER_TON = UnitDescriptor('gross register ton', 'GRT', '''''')
ALL_UNITS.append(GROSS_REGISTER_TON)
GROSS_TON = UnitDescriptor('gross ton', 'GT', '''''')
ALL_UNITS.append(GROSS_TON)
GIGAJOULE = UnitDescriptor('gigajoule', 'GV', '''GJ''')
ALL_UNITS.append(GIGAJOULE)
GALLON_PER_THOUSAND_CUBIC_FOOT = UnitDescriptor('gallon per thousand cubic foot', 'GW', '''''')
ALL_UNITS.append(GALLON_PER_THOUSAND_CUBIC_FOOT)
GIGAWATT_HOUR = UnitDescriptor('gigawatt hour', 'GWH', '''GW·h''')
ALL_UNITS.append(GIGAWATT_HOUR)
GROSS_YARD = UnitDescriptor('gross yard', 'GY', '''''')
ALL_UNITS.append(GROSS_YARD)
GAGE_SYSTEM = UnitDescriptor('gage system', 'GZ', '''''')
ALL_UNITS.append(GAGE_SYSTEM)
HENRY_PER_KILOOHM = UnitDescriptor('henry per kiloohm', 'H03', '''H/kΩ''')
ALL_UNITS.append(HENRY_PER_KILOOHM)
HENRY_PER_OHM = UnitDescriptor('henry per ohm', 'H04', '''H/Ω''')
ALL_UNITS.append(HENRY_PER_OHM)
MILLIHENRY_PER_KILOOHM = UnitDescriptor('millihenry per kiloohm', 'H05', '''mH/kΩ''')
ALL_UNITS.append(MILLIHENRY_PER_KILOOHM)
MILLIHENRY_PER_OHM = UnitDescriptor('millihenry per ohm', 'H06', '''mH/Ω''')
ALL_UNITS.append(MILLIHENRY_PER_OHM)
PASCAL_SECOND_PER_BAR = UnitDescriptor('pascal second per bar', 'H07', '''Pa·s/bar''')
ALL_UNITS.append(PASCAL_SECOND_PER_BAR)
MICROBECQUEREL = UnitDescriptor('microbecquerel', 'H08', '''µBq''')
ALL_UNITS.append(MICROBECQUEREL)
RECIPROCAL_YEAR = UnitDescriptor('reciprocal year', 'H09', '''1/y''')
ALL_UNITS.append(RECIPROCAL_YEAR)
HALF_PAGE_ELECTRONIC = UnitDescriptor('half page – electronic', 'H1', '''''')
ALL_UNITS.append(HALF_PAGE_ELECTRONIC)
RECIPROCAL_HOUR = UnitDescriptor('reciprocal hour', 'H10', '''1/h''')
ALL_UNITS.append(RECIPROCAL_HOUR)
RECIPROCAL_MONTH = UnitDescriptor('reciprocal month', 'H11', '''1/mo''')
ALL_UNITS.append(RECIPROCAL_MONTH)
DEGREE_CELSIUS_PER_HOUR = UnitDescriptor('degree Celsius per hour', 'H12', '''°C/h''')
ALL_UNITS.append(DEGREE_CELSIUS_PER_HOUR)
DEGREE_CELSIUS_PER_MINUTE = UnitDescriptor('degree Celsius per minute', 'H13', '''°C/min''')
ALL_UNITS.append(DEGREE_CELSIUS_PER_MINUTE)
DEGREE_CELSIUS_PER_SECOND = UnitDescriptor('degree Celsius per second', 'H14', '''°C/s''')
ALL_UNITS.append(DEGREE_CELSIUS_PER_SECOND)
SQUARE_CENTIMETRE_PER_GRAM = UnitDescriptor('square centimetre per gram', 'H15', '''cm²/g''')
ALL_UNITS.append(SQUARE_CENTIMETRE_PER_GRAM)
SQUARE_DECAMETRE = UnitDescriptor('square decametre', 'H16', '''dam²''')
ALL_UNITS.append(SQUARE_DECAMETRE)
SQUARE_HECTOMETRE = UnitDescriptor('square hectometre', 'H18', '''hm²''')
ALL_UNITS.append(SQUARE_HECTOMETRE)
CUBIC_HECTOMETRE = UnitDescriptor('cubic hectometre', 'H19', '''hm³''')
ALL_UNITS.append(CUBIC_HECTOMETRE)
HALF_LITRE = UnitDescriptor('half litre', 'H2', '''''')
ALL_UNITS.append(HALF_LITRE)
CUBIC_KILOMETRE = UnitDescriptor('cubic kilometre', 'H20', '''km³''')
ALL_UNITS.append(CUBIC_KILOMETRE)
BLANK = UnitDescriptor('blank', 'H21', '''''')
ALL_UNITS.append(BLANK)
VOLT_SQUARE_INCH_PER_POUND_FORCE = UnitDescriptor('volt square inch per pound-force', 'H22', '''V/(lbf/in²)''')
ALL_UNITS.append(VOLT_SQUARE_INCH_PER_POUND_FORCE)
VOLT_PER_INCH = UnitDescriptor('volt per inch', 'H23', '''V/in''')
ALL_UNITS.append(VOLT_PER_INCH)
VOLT_PER_MICROSECOND = UnitDescriptor('volt per microsecond', 'H24', '''V/µs''')
ALL_UNITS.append(VOLT_PER_MICROSECOND)
PERCENT_PER_KELVIN = UnitDescriptor('percent per kelvin', 'H25', '''%/K''')
ALL_UNITS.append(PERCENT_PER_KELVIN)
OHM_PER_METRE = UnitDescriptor('ohm per metre', 'H26', '''Ω/m''')
ALL_UNITS.append(OHM_PER_METRE)
DEGREE_PER_METRE = UnitDescriptor('degree per metre', 'H27', '''°/m''')
ALL_UNITS.append(DEGREE_PER_METRE)
MICROFARAD_PER_KILOMETRE = UnitDescriptor('microfarad per kilometre', 'H28', '''µF/km''')
ALL_UNITS.append(MICROFARAD_PER_KILOMETRE)
MICROGRAM_PER_LITRE = UnitDescriptor('microgram per litre', 'H29', '''µg/l''')
ALL_UNITS.append(MICROGRAM_PER_LITRE)
SQUARE_MICROMETRE_SQUARE_MICRON = UnitDescriptor('square micrometre (square micron)', 'H30', '''µm²''')
ALL_UNITS.append(SQUARE_MICROMETRE_SQUARE_MICRON)
AMPERE_PER_KILOGRAM = UnitDescriptor('ampere per kilogram', 'H31', '''A/kg''')
ALL_UNITS.append(AMPERE_PER_KILOGRAM)
AMPERE_SQUARED_SECOND = UnitDescriptor('ampere squared second', 'H32', '''A²·s''')
ALL_UNITS.append(AMPERE_SQUARED_SECOND)
FARAD_PER_KILOMETRE = UnitDescriptor('farad per kilometre', 'H33', '''F/km''')
ALL_UNITS.append(FARAD_PER_KILOMETRE)
HERTZ_METRE = UnitDescriptor('hertz metre', 'H34', '''Hz·m''')
ALL_UNITS.append(HERTZ_METRE)
KELVIN_METRE_PER_WATT = UnitDescriptor('kelvin metre per watt', 'H35', '''K·m/W''')
ALL_UNITS.append(KELVIN_METRE_PER_WATT)
MEGAOHM_PER_KILOMETRE = UnitDescriptor('megaohm per kilometre', 'H36', '''MΩ/km''')
ALL_UNITS.append(MEGAOHM_PER_KILOMETRE)
MEGAOHM_PER_METRE = UnitDescriptor('megaohm per metre', 'H37', '''MΩ/m''')
ALL_UNITS.append(MEGAOHM_PER_METRE)
MEGAAMPERE = UnitDescriptor('megaampere', 'H38', '''MA''')
ALL_UNITS.append(MEGAAMPERE)
MEGAHERTZ_KILOMETRE = UnitDescriptor('megahertz kilometre', 'H39', '''MHz·km''')
ALL_UNITS.append(MEGAHERTZ_KILOMETRE)
NEWTON_PER_AMPERE = UnitDescriptor('newton per ampere', 'H40', '''N/A''')
ALL_UNITS.append(NEWTON_PER_AMPERE)
NEWTON_METRE_WATT_TO_THE_POWER_MINUS_0_5 = UnitDescriptor('newton metre watt to the power minus 0,5', 'H41', '''N·m·W⁻⁰‧⁵''')
ALL_UNITS.append(NEWTON_METRE_WATT_TO_THE_POWER_MINUS_0_5)
PASCAL_PER_METRE = UnitDescriptor('pascal per metre', 'H42', '''Pa/m''')
ALL_UNITS.append(PASCAL_PER_METRE)
SIEMENS_PER_CENTIMETRE = UnitDescriptor('siemens per centimetre', 'H43', '''S/cm''')
ALL_UNITS.append(SIEMENS_PER_CENTIMETRE)
TERAOHM = UnitDescriptor('teraohm', 'H44', '''TΩ''')
ALL_UNITS.append(TERAOHM)
VOLT_SECOND_PER_METRE = UnitDescriptor('volt second per metre', 'H45', '''V·s/m''')
ALL_UNITS.append(VOLT_SECOND_PER_METRE)
VOLT_PER_SECOND = UnitDescriptor('volt per second', 'H46', '''V/s''')
ALL_UNITS.append(VOLT_PER_SECOND)
WATT_PER_CUBIC_METRE = UnitDescriptor('watt per cubic metre', 'H47', '''W/m³''')
ALL_UNITS.append(WATT_PER_CUBIC_METRE)
ATTOFARAD = UnitDescriptor('attofarad', 'H48', '''aF''')
ALL_UNITS.append(ATTOFARAD)
CENTIMETRE_PER_HOUR = UnitDescriptor('centimetre per hour', 'H49', '''cm/h''')
ALL_UNITS.append(CENTIMETRE_PER_HOUR)
RECIPROCAL_CUBIC_CENTIMETRE = UnitDescriptor('reciprocal cubic centimetre', 'H50', '''cm⁻³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_CENTIMETRE)
DECIBEL_PER_KILOMETRE = UnitDescriptor('decibel per kilometre', 'H51', '''dB/km''')
ALL_UNITS.append(DECIBEL_PER_KILOMETRE)
DECIBEL_PER_METRE = UnitDescriptor('decibel per metre', 'H52', '''dB/m''')
ALL_UNITS.append(DECIBEL_PER_METRE)
KILOGRAM_PER_BAR = UnitDescriptor('kilogram per bar', 'H53', '''kg/bar''')
ALL_UNITS.append(KILOGRAM_PER_BAR)
KILOGRAM_PER_CUBIC_DECIMETRE_KELVIN = UnitDescriptor('kilogram per cubic decimetre kelvin', 'H54', '''(kg/dm³)/K''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_DECIMETRE_KELVIN)
KILOGRAM_PER_CUBIC_DECIMETRE_BAR = UnitDescriptor('kilogram per cubic decimetre bar', 'H55', '''(kg/dm³)/bar''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_DECIMETRE_BAR)
KILOGRAM_PER_SQUARE_METRE_SECOND = UnitDescriptor('kilogram per square metre second', 'H56', '''kg/(m²·s)''')
ALL_UNITS.append(KILOGRAM_PER_SQUARE_METRE_SECOND)
INCH_PER_TWO_PI_RADIANT = UnitDescriptor('inch per two pi radiant', 'H57', '''in/revolution''')
ALL_UNITS.append(INCH_PER_TWO_PI_RADIANT)
METRE_PER_VOLT_SECOND = UnitDescriptor('metre per volt second', 'H58', '''m/(V·s)''')
ALL_UNITS.append(METRE_PER_VOLT_SECOND)
SQUARE_METRE_PER_NEWTON = UnitDescriptor('square metre per newton', 'H59', '''m²/N''')
ALL_UNITS.append(SQUARE_METRE_PER_NEWTON)
CUBIC_METRE_PER_CUBIC_METRE = UnitDescriptor('cubic metre per cubic metre', 'H60', '''m³/m³''')
ALL_UNITS.append(CUBIC_METRE_PER_CUBIC_METRE)
MILLISIEMENS_PER_CENTIMETRE = UnitDescriptor('millisiemens per centimetre', 'H61', '''mS/cm''')
ALL_UNITS.append(MILLISIEMENS_PER_CENTIMETRE)
MILLIVOLT_PER_MINUTE = UnitDescriptor('millivolt per minute', 'H62', '''mV/min''')
ALL_UNITS.append(MILLIVOLT_PER_MINUTE)
MILLIGRAM_PER_SQUARE_CENTIMETRE = UnitDescriptor('milligram per square centimetre', 'H63', '''mg/cm²''')
ALL_UNITS.append(MILLIGRAM_PER_SQUARE_CENTIMETRE)
MILLIGRAM_PER_GRAM = UnitDescriptor('milligram per gram', 'H64', '''mg/g''')
ALL_UNITS.append(MILLIGRAM_PER_GRAM)
MILLILITRE_PER_CUBIC_METRE = UnitDescriptor('millilitre per cubic metre', 'H65', '''ml/m³''')
ALL_UNITS.append(MILLILITRE_PER_CUBIC_METRE)
MILLIMETRE_PER_YEAR = UnitDescriptor('millimetre per year', 'H66', '''mm/y''')
ALL_UNITS.append(MILLIMETRE_PER_YEAR)
MILLIMETRE_PER_HOUR = UnitDescriptor('millimetre per hour', 'H67', '''mm/h''')
ALL_UNITS.append(MILLIMETRE_PER_HOUR)
MILLIMOLE_PER_GRAM = UnitDescriptor('millimole per gram', 'H68', '''mmol/g''')
ALL_UNITS.append(MILLIMOLE_PER_GRAM)
PICOPASCAL_PER_KILOMETRE = UnitDescriptor('picopascal per kilometre', 'H69', '''pPa/km''')
ALL_UNITS.append(PICOPASCAL_PER_KILOMETRE)
PICOSECOND = UnitDescriptor('picosecond', 'H70', '''ps''')
ALL_UNITS.append(PICOSECOND)
PERCENT_PER_MONTH = UnitDescriptor('percent per month', 'H71', '''%/mo''')
ALL_UNITS.append(PERCENT_PER_MONTH)
PERCENT_PER_HECTOBAR = UnitDescriptor('percent per hectobar', 'H72', '''%/hbar''')
ALL_UNITS.append(PERCENT_PER_HECTOBAR)
PERCENT_PER_DECAKELVIN = UnitDescriptor('percent per decakelvin', 'H73', '''%/daK''')
ALL_UNITS.append(PERCENT_PER_DECAKELVIN)
WATT_PER_METRE = UnitDescriptor('watt per metre', 'H74', '''W/m''')
ALL_UNITS.append(WATT_PER_METRE)
DECAPASCAL = UnitDescriptor('decapascal', 'H75', '''daPa''')
ALL_UNITS.append(DECAPASCAL)
GRAM_PER_MILLIMETRE = UnitDescriptor('gram per millimetre', 'H76', '''g/mm''')
ALL_UNITS.append(GRAM_PER_MILLIMETRE)
MODULE_WIDTH = UnitDescriptor('module width', 'H77', '''MW''')
ALL_UNITS.append(MODULE_WIDTH)
CONVENTIONAL_CENTIMETRE_OF_WATER = UnitDescriptor('conventional centimetre of water', 'H78', '''cm H₂O''')
ALL_UNITS.append(CONVENTIONAL_CENTIMETRE_OF_WATER)
FRENCH_GAUGE = UnitDescriptor('French gauge', 'H79', '''Fg''')
ALL_UNITS.append(FRENCH_GAUGE)
RACK_UNIT = UnitDescriptor('rack unit', 'H80', '''U''')
ALL_UNITS.append(RACK_UNIT)
RACK_UNIT = UnitDescriptor('rack unit', 'H80', '''RU''')
ALL_UNITS.append(RACK_UNIT)
MILLIMETRE_PER_MINUTE = UnitDescriptor('millimetre per minute', 'H81', '''mm/min''')
ALL_UNITS.append(MILLIMETRE_PER_MINUTE)
BIG_POINT = UnitDescriptor('big point', 'H82', '''bp''')
ALL_UNITS.append(BIG_POINT)
LITRE_PER_KILOGRAM = UnitDescriptor('litre per kilogram', 'H83', '''l/kg''')
ALL_UNITS.append(LITRE_PER_KILOGRAM)
GRAM_MILLIMETRE = UnitDescriptor('gram millimetre', 'H84', '''g·mm''')
ALL_UNITS.append(GRAM_MILLIMETRE)
RECIPROCAL_WEEK = UnitDescriptor('reciprocal week', 'H85', '''1/wk''')
ALL_UNITS.append(RECIPROCAL_WEEK)
PIECE = UnitDescriptor('piece', 'H87', '''''')
ALL_UNITS.append(PIECE)
MEGAOHM_KILOMETRE = UnitDescriptor('megaohm kilometre', 'H88', '''MΩ·km''')
ALL_UNITS.append(MEGAOHM_KILOMETRE)
PERCENT_PER_OHM = UnitDescriptor('percent per ohm', 'H89', '''%/Ω''')
ALL_UNITS.append(PERCENT_PER_OHM)
PERCENT_PER_DEGREE = UnitDescriptor('percent per degree', 'H90', '''%/°''')
ALL_UNITS.append(PERCENT_PER_DEGREE)
PERCENT_PER_TEN_THOUSAND = UnitDescriptor('percent per ten thousand', 'H91', '''%/10000''')
ALL_UNITS.append(PERCENT_PER_TEN_THOUSAND)
PERCENT_PER_ONE_HUNDRED_THOUSAND = UnitDescriptor('percent per one hundred thousand', 'H92', '''%/100000''')
ALL_UNITS.append(PERCENT_PER_ONE_HUNDRED_THOUSAND)
PERCENT_PER_HUNDRED = UnitDescriptor('percent per hundred', 'H93', '''%/100''')
ALL_UNITS.append(PERCENT_PER_HUNDRED)
PERCENT_PER_THOUSAND = UnitDescriptor('percent per thousand', 'H94', '''%/1000''')
ALL_UNITS.append(PERCENT_PER_THOUSAND)
PERCENT_PER_VOLT = UnitDescriptor('percent per volt', 'H95', '''%/V''')
ALL_UNITS.append(PERCENT_PER_VOLT)
PERCENT_PER_BAR = UnitDescriptor('percent per bar', 'H96', '''%/bar''')
ALL_UNITS.append(PERCENT_PER_BAR)
PERCENT_PER_INCH = UnitDescriptor('percent per inch', 'H98', '''%/in''')
ALL_UNITS.append(PERCENT_PER_INCH)
PERCENT_PER_METRE = UnitDescriptor('percent per metre', 'H99', '''%/m''')
ALL_UNITS.append(PERCENT_PER_METRE)
HANK = UnitDescriptor('hank', 'HA', '''''')
ALL_UNITS.append(HANK)
HECTARE = UnitDescriptor('hectare', 'HAR', '''ha''')
ALL_UNITS.append(HECTARE)
HECTOBAR = UnitDescriptor('hectobar', 'HBA', '''hbar''')
ALL_UNITS.append(HECTOBAR)
HUNDRED_BOXES = UnitDescriptor('hundred boxes', 'HBX', '''''')
ALL_UNITS.append(HUNDRED_BOXES)
HUNDRED_COUNT = UnitDescriptor('hundred count', 'HC', '''''')
ALL_UNITS.append(HUNDRED_COUNT)
HALF_DOZEN = UnitDescriptor('half dozen', 'HD', '''''')
ALL_UNITS.append(HALF_DOZEN)
HUNDRED_KILOGRAM_DRY_WEIGHT = UnitDescriptor('hundred kilogram, dry weight', 'HDW', '''''')
ALL_UNITS.append(HUNDRED_KILOGRAM_DRY_WEIGHT)
HUNDREDTH_OF_A_CARAT = UnitDescriptor('hundredth of a carat', 'HE', '''''')
ALL_UNITS.append(HUNDREDTH_OF_A_CARAT)
HEAD = UnitDescriptor('head', 'HEA', '''''')
ALL_UNITS.append(HEAD)
HUNDRED_FOOT = UnitDescriptor('hundred foot', 'HF', '''''')
ALL_UNITS.append(HUNDRED_FOOT)
HECTOGRAM = UnitDescriptor('hectogram', 'HGM', '''hg''')
ALL_UNITS.append(HECTOGRAM)
HUNDRED_CUBIC_FOOT = UnitDescriptor('hundred cubic foot', 'HH', '''''')
ALL_UNITS.append(HUNDRED_CUBIC_FOOT)
HUNDRED_SHEET = UnitDescriptor('hundred sheet', 'HI', '''''')
ALL_UNITS.append(HUNDRED_SHEET)
HUNDRED_INTERNATIONAL_UNIT = UnitDescriptor('hundred international unit', 'HIU', '''''')
ALL_UNITS.append(HUNDRED_INTERNATIONAL_UNIT)
METRIC_HORSE_POWER = UnitDescriptor('metric horse power', 'HJ', '''metric hp''')
ALL_UNITS.append(METRIC_HORSE_POWER)
HUNDRED_KILOGRAM = UnitDescriptor('hundred kilogram', 'HK', '''''')
ALL_UNITS.append(HUNDRED_KILOGRAM)
HUNDRED_KILOGRAM_NET_MASS = UnitDescriptor('hundred kilogram, net mass', 'HKM', '''''')
ALL_UNITS.append(HUNDRED_KILOGRAM_NET_MASS)
HUNDRED_FOOT_LINEAR = UnitDescriptor('hundred foot (linear)', 'HL', '''''')
ALL_UNITS.append(HUNDRED_FOOT_LINEAR)
HECTOLITRE = UnitDescriptor('hectolitre', 'HLT', '''hl''')
ALL_UNITS.append(HECTOLITRE)
MILE_PER_HOUR_STATUTE_MILE = UnitDescriptor('mile per hour (statute mile)', 'HM', '''mile/h''')
ALL_UNITS.append(MILE_PER_HOUR_STATUTE_MILE)
MILLION_CUBIC_METRE = UnitDescriptor('million cubic metre', 'HMQ', '''Mm³''')
ALL_UNITS.append(MILLION_CUBIC_METRE)
HECTOMETRE = UnitDescriptor('hectometre', 'HMT', '''hm''')
ALL_UNITS.append(HECTOMETRE)
CONVENTIONAL_MILLIMETRE_OF_MERCURY = UnitDescriptor('conventional millimetre of mercury', 'HN', '''mm Hg''')
ALL_UNITS.append(CONVENTIONAL_MILLIMETRE_OF_MERCURY)
HUNDRED_TROY_OUNCE = UnitDescriptor('hundred troy ounce', 'HO', '''''')
ALL_UNITS.append(HUNDRED_TROY_OUNCE)
CONVENTIONAL_MILLIMETRE_OF_WATER = UnitDescriptor('conventional millimetre of water', 'HP', '''mm H₂O''')
ALL_UNITS.append(CONVENTIONAL_MILLIMETRE_OF_WATER)
HECTOLITRE_OF_PURE_ALCOHOL = UnitDescriptor('hectolitre of pure alcohol', 'HPA', '''''')
ALL_UNITS.append(HECTOLITRE_OF_PURE_ALCOHOL)
HUNDRED_SQUARE_FOOT = UnitDescriptor('hundred square foot', 'HS', '''''')
ALL_UNITS.append(HUNDRED_SQUARE_FOOT)
HALF_HOUR = UnitDescriptor('half hour', 'HT', '''''')
ALL_UNITS.append(HALF_HOUR)
HERTZ = UnitDescriptor('hertz', 'HTZ', '''Hz''')
ALL_UNITS.append(HERTZ)
HOUR = UnitDescriptor('hour', 'HUR', '''h''')
ALL_UNITS.append(HOUR)
HUNDRED_YARD = UnitDescriptor('hundred yard', 'HY', '''''')
ALL_UNITS.append(HUNDRED_YARD)
INCH_POUND_POUND_INCH = UnitDescriptor('inch pound (pound inch)', 'IA', '''in·lb''')
ALL_UNITS.append(INCH_POUND_POUND_INCH)
COUNT_PER_INCH = UnitDescriptor('count per inch', 'IC', '''''')
ALL_UNITS.append(COUNT_PER_INCH)
PERSON = UnitDescriptor('person', 'IE', '''''')
ALL_UNITS.append(PERSON)
INCHES_OF_WATER = UnitDescriptor('inches of water', 'IF', '''''')
ALL_UNITS.append(INCHES_OF_WATER)
COLUMN_INCH = UnitDescriptor('column inch', 'II', '''''')
ALL_UNITS.append(COLUMN_INCH)
INCH_PER_MINUTE = UnitDescriptor('inch per minute', 'IL', '''''')
ALL_UNITS.append(INCH_PER_MINUTE)
IMPRESSION = UnitDescriptor('impression', 'IM', '''''')
ALL_UNITS.append(IMPRESSION)
INCH = UnitDescriptor('inch', 'INH', '''in''')
ALL_UNITS.append(INCH)
SQUARE_INCH = UnitDescriptor('square inch', 'INK', '''in²''')
ALL_UNITS.append(SQUARE_INCH)
CUBIC_INCH = UnitDescriptor('cubic inch', 'INQ', '''in³''')
ALL_UNITS.append(CUBIC_INCH)
INSURANCE_POLICY = UnitDescriptor('insurance policy', 'IP', '''''')
ALL_UNITS.append(INSURANCE_POLICY)
INTERNATIONAL_SUGAR_DEGREE = UnitDescriptor('international sugar degree', 'ISD', '''''')
ALL_UNITS.append(INTERNATIONAL_SUGAR_DEGREE)
COUNT_PER_CENTIMETRE = UnitDescriptor('count per centimetre', 'IT', '''''')
ALL_UNITS.append(COUNT_PER_CENTIMETRE)
INCH_PER_SECOND = UnitDescriptor('inch per second', 'IU', '''in/s''')
ALL_UNITS.append(INCH_PER_SECOND)
INTERNATIONAL_UNIT_PER_GRAM = UnitDescriptor('international unit per gram', 'IUG', '''''')
ALL_UNITS.append(INTERNATIONAL_UNIT_PER_GRAM)
INCH_PER_SECOND_SQUARED = UnitDescriptor('inch per second squared', 'IV', '''in/s²''')
ALL_UNITS.append(INCH_PER_SECOND_SQUARED)
PERCENT_PER_MILLIMETRE = UnitDescriptor('percent per millimetre', 'J10', '''%/mm''')
ALL_UNITS.append(PERCENT_PER_MILLIMETRE)
PER_MILLE_PER_PSI = UnitDescriptor('per mille per psi', 'J12', '''‰/psi''')
ALL_UNITS.append(PER_MILLE_PER_PSI)
DEGREE_API = UnitDescriptor('degree API', 'J13', '''°API''')
ALL_UNITS.append(DEGREE_API)
DEGREE_BAUME_ORIGIN_SCALE = UnitDescriptor('degree Baume (origin scale)', 'J14', '''°Bé''')
ALL_UNITS.append(DEGREE_BAUME_ORIGIN_SCALE)
DEGREE_BAUME_US_HEAVY = UnitDescriptor('degree Baume (US heavy)', 'J15', '''°Bé (US heavy)''')
ALL_UNITS.append(DEGREE_BAUME_US_HEAVY)
DEGREE_BAUME_US_LIGHT = UnitDescriptor('degree Baume (US light)', 'J16', '''°Bé (US light)''')
ALL_UNITS.append(DEGREE_BAUME_US_LIGHT)
DEGREE_BALLING = UnitDescriptor('degree Balling', 'J17', '''°Balling''')
ALL_UNITS.append(DEGREE_BALLING)
DEGREE_BRIX = UnitDescriptor('degree Brix', 'J18', '''°Bx''')
ALL_UNITS.append(DEGREE_BRIX)
DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = UnitDescriptor('degree Fahrenheit hour square foot per British thermal unit (thermochemical)', 'J19', '''°F·h·ft²/Btuth''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL)
JOULE_PER_KILOGRAM = UnitDescriptor('joule per kilogram', 'J2', '''J/kg''')
ALL_UNITS.append(JOULE_PER_KILOGRAM)
DEGREE_FAHRENHEIT_PER_KELVIN = UnitDescriptor('degree Fahrenheit per kelvin', 'J20', '''°F/K''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_PER_KELVIN)
DEGREE_FAHRENHEIT_PER_BAR = UnitDescriptor('degree Fahrenheit per bar', 'J21', '''°F/bar''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_PER_BAR)
DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = UnitDescriptor('degree Fahrenheit hour square foot per British thermal unit (international table)', 'J22', '''°F·h·ft²/BtuIT''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE)
DEGREE_FAHRENHEIT_PER_HOUR = UnitDescriptor('degree Fahrenheit per hour', 'J23', '''°F/h''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_PER_HOUR)
DEGREE_FAHRENHEIT_PER_MINUTE = UnitDescriptor('degree Fahrenheit per minute', 'J24', '''°F/min''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_PER_MINUTE)
DEGREE_FAHRENHEIT_PER_SECOND = UnitDescriptor('degree Fahrenheit per second', 'J25', '''°F/s''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_PER_SECOND)
RECIPROCAL_DEGREE_FAHRENHEIT = UnitDescriptor('reciprocal degree Fahrenheit', 'J26', '''1/°F''')
ALL_UNITS.append(RECIPROCAL_DEGREE_FAHRENHEIT)
DEGREE_OECHSLE = UnitDescriptor('degree Oechsle', 'J27', '''°Oechsle''')
ALL_UNITS.append(DEGREE_OECHSLE)
DEGREE_RANKINE_PER_HOUR = UnitDescriptor('degree Rankine per hour', 'J28', '''°R/h''')
ALL_UNITS.append(DEGREE_RANKINE_PER_HOUR)
DEGREE_RANKINE_PER_MINUTE = UnitDescriptor('degree Rankine per minute', 'J29', '''°R/min''')
ALL_UNITS.append(DEGREE_RANKINE_PER_MINUTE)
DEGREE_RANKINE_PER_SECOND = UnitDescriptor('degree Rankine per second', 'J30', '''°R/s''')
ALL_UNITS.append(DEGREE_RANKINE_PER_SECOND)
DEGREE_TWADDELL = UnitDescriptor('degree Twaddell', 'J31', '''°Tw''')
ALL_UNITS.append(DEGREE_TWADDELL)
MICROPOISE = UnitDescriptor('micropoise', 'J32', '''µP''')
ALL_UNITS.append(MICROPOISE)
MICROGRAM_PER_KILOGRAM = UnitDescriptor('microgram per kilogram', 'J33', '''µg/kg''')
ALL_UNITS.append(MICROGRAM_PER_KILOGRAM)
MICROGRAM_PER_CUBIC_METRE_KELVIN = UnitDescriptor('microgram per cubic metre kelvin', 'J34', '''(µg/m³)/K''')
ALL_UNITS.append(MICROGRAM_PER_CUBIC_METRE_KELVIN)
MICROGRAM_PER_CUBIC_METRE_BAR = UnitDescriptor('microgram per cubic metre bar', 'J35', '''(µg/m³)/bar''')
ALL_UNITS.append(MICROGRAM_PER_CUBIC_METRE_BAR)
MICROLITRE_PER_LITRE = UnitDescriptor('microlitre per litre', 'J36', '''µl/l''')
ALL_UNITS.append(MICROLITRE_PER_LITRE)
BAUD = UnitDescriptor('baud', 'J38', '''Bd''')
ALL_UNITS.append(BAUD)
BRITISH_THERMAL_UNIT_MEAN = UnitDescriptor('British thermal unit (mean)', 'J39', '''Btu''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_MEAN)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_FOOT_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) foot per hour square foot degree Fahrenheit', 'J40', '''BtuIT·ft/(h·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_FOOT_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) inch per hour square foot degree Fahrenheit', 'J41', '''BtuIT·in/(h·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) inch per second square foot degree Fahrenheit', 'J42', '''BtuIT·in/(s·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) per pound degree Fahrenheit', 'J43', '''BtuIT/(lb·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_MINUTE = UnitDescriptor('British thermal unit (international table) per minute', 'J44', '''BtuIT/min''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_MINUTE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND = UnitDescriptor('British thermal unit (international table) per second', 'J45', '''BtuIT/s''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_FOOT_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) foot per hour square foot degree Fahrenheit', 'J46', '''Btuth·ft/(h·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_FOOT_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR = UnitDescriptor('British thermal unit (thermochemical) per hour', 'J47', '''Btuth/h''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) inch per hour square foot degree Fahrenheit', 'J48', '''Btuth·in/(h·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) inch per second square foot degree Fahrenheit', 'J49', '''Btuth·in/(s·ft²·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) per pound degree Fahrenheit', 'J50', '''Btuth/(lb·°F)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_MINUTE = UnitDescriptor('British thermal unit (thermochemical) per minute', 'J51', '''Btuth/min''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_MINUTE)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND = UnitDescriptor('British thermal unit (thermochemical) per second', 'J52', '''Btuth/s''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND)
COULOMB_SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('coulomb square metre per kilogram', 'J53', '''C·m²/kg''')
ALL_UNITS.append(COULOMB_SQUARE_METRE_PER_KILOGRAM)
MEGABAUD = UnitDescriptor('megabaud', 'J54', '''MBd''')
ALL_UNITS.append(MEGABAUD)
WATT_SECOND = UnitDescriptor('watt second', 'J55', '''W·s''')
ALL_UNITS.append(WATT_SECOND)
BAR_PER_BAR = UnitDescriptor('bar per bar', 'J56', '''bar/bar''')
ALL_UNITS.append(BAR_PER_BAR)
BARREL_UK_PETROLEUM = UnitDescriptor('barrel (UK petroleum)', 'J57', '''bbl (UK liq.)''')
ALL_UNITS.append(BARREL_UK_PETROLEUM)
BARREL_UK_PETROLEUM_PER_MINUTE = UnitDescriptor('barrel (UK petroleum) per minute', 'J58', '''bbl (UK liq.)/min''')
ALL_UNITS.append(BARREL_UK_PETROLEUM_PER_MINUTE)
BARREL_UK_PETROLEUM_PER_DAY = UnitDescriptor('barrel (UK petroleum) per day', 'J59', '''bbl (UK liq.)/d''')
ALL_UNITS.append(BARREL_UK_PETROLEUM_PER_DAY)
BARREL_UK_PETROLEUM_PER_HOUR = UnitDescriptor('barrel (UK petroleum) per hour', 'J60', '''bbl (UK liq.)/h''')
ALL_UNITS.append(BARREL_UK_PETROLEUM_PER_HOUR)
BARREL_UK_PETROLEUM_PER_SECOND = UnitDescriptor('barrel (UK petroleum) per second', 'J61', '''bbl (UK liq.)/s''')
ALL_UNITS.append(BARREL_UK_PETROLEUM_PER_SECOND)
BARREL_US_PETROLEUM_PER_HOUR = UnitDescriptor('barrel (US petroleum) per hour', 'J62', '''bbl (US)/h''')
ALL_UNITS.append(BARREL_US_PETROLEUM_PER_HOUR)
BARREL_US_PETROLEUM_PER_SECOND = UnitDescriptor('barrel (US petroleum) per second', 'J63', '''bbl (US)/s''')
ALL_UNITS.append(BARREL_US_PETROLEUM_PER_SECOND)
BUSHEL_UK_PER_DAY = UnitDescriptor('bushel (UK) per day', 'J64', '''bu (UK)/d''')
ALL_UNITS.append(BUSHEL_UK_PER_DAY)
BUSHEL_UK_PER_HOUR = UnitDescriptor('bushel (UK) per hour', 'J65', '''bu (UK)/h''')
ALL_UNITS.append(BUSHEL_UK_PER_HOUR)
BUSHEL_UK_PER_MINUTE = UnitDescriptor('bushel (UK) per minute', 'J66', '''bu (UK)/min''')
ALL_UNITS.append(BUSHEL_UK_PER_MINUTE)
BUSHEL_UK_PER_SECOND = UnitDescriptor('bushel (UK) per second', 'J67', '''bu (UK)/s''')
ALL_UNITS.append(BUSHEL_UK_PER_SECOND)
BUSHEL_US_DRY_PER_DAY = UnitDescriptor('bushel (US dry) per day', 'J68', '''bu (US dry)/d''')
ALL_UNITS.append(BUSHEL_US_DRY_PER_DAY)
BUSHEL_US_DRY_PER_HOUR = UnitDescriptor('bushel (US dry) per hour', 'J69', '''bu (US dry)/h''')
ALL_UNITS.append(BUSHEL_US_DRY_PER_HOUR)
BUSHEL_US_DRY_PER_MINUTE = UnitDescriptor('bushel (US dry) per minute', 'J70', '''bu (US dry)/min''')
ALL_UNITS.append(BUSHEL_US_DRY_PER_MINUTE)
BUSHEL_US_DRY_PER_SECOND = UnitDescriptor('bushel (US dry) per second', 'J71', '''bu (US dry)/s''')
ALL_UNITS.append(BUSHEL_US_DRY_PER_SECOND)
CENTINEWTON_METRE = UnitDescriptor('centinewton metre', 'J72', '''cN·m''')
ALL_UNITS.append(CENTINEWTON_METRE)
CENTIPOISE_PER_KELVIN = UnitDescriptor('centipoise per kelvin', 'J73', '''cP/K''')
ALL_UNITS.append(CENTIPOISE_PER_KELVIN)
CENTIPOISE_PER_BAR = UnitDescriptor('centipoise per bar', 'J74', '''cP/bar''')
ALL_UNITS.append(CENTIPOISE_PER_BAR)
CALORIE_MEAN = UnitDescriptor('calorie (mean)', 'J75', '''cal''')
ALL_UNITS.append(CALORIE_MEAN)
CALORIE_INTERNATIONAL_TABLE_PER_GRAM_DEGREE_CELSIUS = UnitDescriptor('calorie (international table) per gram degree Celsius', 'J76', '''calIT/(g·°C)''')
ALL_UNITS.append(CALORIE_INTERNATIONAL_TABLE_PER_GRAM_DEGREE_CELSIUS)
CALORIE_THERMOCHEMICAL_PER_CENTIMETRE_SECOND_DEGREE_CELSIUS = UnitDescriptor('calorie (thermochemical) per centimetre second degree Celsius', 'J78', '''calth/(cm·s·°C)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_CENTIMETRE_SECOND_DEGREE_CELSIUS)
CALORIE_THERMOCHEMICAL_PER_GRAM_DEGREE_CELSIUS = UnitDescriptor('calorie (thermochemical) per gram degree Celsius', 'J79', '''calth/(g·°C)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_GRAM_DEGREE_CELSIUS)
CALORIE_THERMOCHEMICAL_PER_MINUTE = UnitDescriptor('calorie (thermochemical) per minute', 'J81', '''calth/min''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_MINUTE)
CALORIE_THERMOCHEMICAL_PER_SECOND = UnitDescriptor('calorie (thermochemical) per second', 'J82', '''calth/s''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SECOND)
CLO = UnitDescriptor('clo', 'J83', '''clo''')
ALL_UNITS.append(CLO)
CENTIMETRE_PER_SECOND_KELVIN = UnitDescriptor('centimetre per second kelvin', 'J84', '''(cm/s)/K''')
ALL_UNITS.append(CENTIMETRE_PER_SECOND_KELVIN)
CENTIMETRE_PER_SECOND_BAR = UnitDescriptor('centimetre per second bar', 'J85', '''(cm/s)/bar''')
ALL_UNITS.append(CENTIMETRE_PER_SECOND_BAR)
CUBIC_CENTIMETRE_PER_CUBIC_METRE = UnitDescriptor('cubic centimetre per cubic metre', 'J87', '''cm³/m³''')
ALL_UNITS.append(CUBIC_CENTIMETRE_PER_CUBIC_METRE)
CENTIMETRE_OF_MERCURY = UnitDescriptor('centimetre of mercury', 'J89', '''cm Hg''')
ALL_UNITS.append(CENTIMETRE_OF_MERCURY)
CUBIC_DECIMETRE_PER_DAY = UnitDescriptor('cubic decimetre per day', 'J90', '''dm³/d''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_DAY)
CUBIC_DECIMETRE_PER_CUBIC_METRE = UnitDescriptor('cubic decimetre per cubic metre', 'J91', '''dm³/m³''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_CUBIC_METRE)
CUBIC_DECIMETRE_PER_MINUTE = UnitDescriptor('cubic decimetre per minute', 'J92', '''dm³/min''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_MINUTE)
CUBIC_DECIMETRE_PER_SECOND = UnitDescriptor('cubic decimetre per second', 'J93', '''dm³/s''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_SECOND)
DYNE_CENTIMETRE = UnitDescriptor('dyne centimetre', 'J94', '''dyn·cm''')
ALL_UNITS.append(DYNE_CENTIMETRE)
OUNCE_UK_FLUID_PER_DAY = UnitDescriptor('ounce (UK fluid) per day', 'J95', '''fl oz (UK)/d''')
ALL_UNITS.append(OUNCE_UK_FLUID_PER_DAY)
OUNCE_UK_FLUID_PER_HOUR = UnitDescriptor('ounce (UK fluid) per hour', 'J96', '''fl oz (UK)/h''')
ALL_UNITS.append(OUNCE_UK_FLUID_PER_HOUR)
OUNCE_UK_FLUID_PER_MINUTE = UnitDescriptor('ounce (UK fluid) per minute', 'J97', '''fl oz (UK)/min''')
ALL_UNITS.append(OUNCE_UK_FLUID_PER_MINUTE)
OUNCE_UK_FLUID_PER_SECOND = UnitDescriptor('ounce (UK fluid) per second', 'J98', '''fl oz (UK)/s''')
ALL_UNITS.append(OUNCE_UK_FLUID_PER_SECOND)
OUNCE_US_FLUID_PER_DAY = UnitDescriptor('ounce (US fluid) per day', 'J99', '''fl oz (US)/d''')
ALL_UNITS.append(OUNCE_US_FLUID_PER_DAY)
JUMBO = UnitDescriptor('jumbo', 'JB', '''''')
ALL_UNITS.append(JUMBO)
JOULE_PER_KELVIN = UnitDescriptor('joule per kelvin', 'JE', '''J/K''')
ALL_UNITS.append(JOULE_PER_KELVIN)
JUG = UnitDescriptor('jug', 'JG', '''''')
ALL_UNITS.append(JUG)
MEGAJOULE_PER_KILOGRAM = UnitDescriptor('megajoule per kilogram', 'JK', '''MJ/kg''')
ALL_UNITS.append(MEGAJOULE_PER_KILOGRAM)
MEGAJOULE_PER_CUBIC_METRE = UnitDescriptor('megajoule per cubic metre', 'JM', '''MJ/m³''')
ALL_UNITS.append(MEGAJOULE_PER_CUBIC_METRE)
PIPELINE_JOINT = UnitDescriptor('pipeline joint', 'JNT', '''''')
ALL_UNITS.append(PIPELINE_JOINT)
JOINT = UnitDescriptor('joint', 'JO', '''''')
ALL_UNITS.append(JOINT)
JOULE = UnitDescriptor('joule', 'JOU', '''J''')
ALL_UNITS.append(JOULE)
HUNDRED_METRE = UnitDescriptor('hundred metre', 'JPS', '''''')
ALL_UNITS.append(HUNDRED_METRE)
JAR = UnitDescriptor('jar', 'JR', '''''')
ALL_UNITS.append(JAR)
NUMBER_OF_JEWELS = UnitDescriptor('number of jewels', 'JWL', '''''')
ALL_UNITS.append(NUMBER_OF_JEWELS)
KILOWATT_DEMAND = UnitDescriptor('kilowatt demand', 'K1', '''''')
ALL_UNITS.append(KILOWATT_DEMAND)
OUNCE_US_FLUID_PER_HOUR = UnitDescriptor('ounce (US fluid) per hour', 'K10', '''fl oz (US)/h''')
ALL_UNITS.append(OUNCE_US_FLUID_PER_HOUR)
OUNCE_US_FLUID_PER_MINUTE = UnitDescriptor('ounce (US fluid) per minute', 'K11', '''fl oz (US)/min''')
ALL_UNITS.append(OUNCE_US_FLUID_PER_MINUTE)
OUNCE_US_FLUID_PER_SECOND = UnitDescriptor('ounce (US fluid) per second', 'K12', '''fl oz (US)/s''')
ALL_UNITS.append(OUNCE_US_FLUID_PER_SECOND)
FOOT_PER_DEGREE_FAHRENHEIT = UnitDescriptor('foot per degree Fahrenheit', 'K13', '''ft/°F''')
ALL_UNITS.append(FOOT_PER_DEGREE_FAHRENHEIT)
FOOT_PER_HOUR = UnitDescriptor('foot per hour', 'K14', '''ft/h''')
ALL_UNITS.append(FOOT_PER_HOUR)
FOOT_POUND_FORCE_PER_HOUR = UnitDescriptor('foot pound-force per hour', 'K15', '''ft·lbf/h''')
ALL_UNITS.append(FOOT_POUND_FORCE_PER_HOUR)
FOOT_POUND_FORCE_PER_MINUTE = UnitDescriptor('foot pound-force per minute', 'K16', '''ft·lbf/min''')
ALL_UNITS.append(FOOT_POUND_FORCE_PER_MINUTE)
FOOT_PER_PSI = UnitDescriptor('foot per psi', 'K17', '''ft/psi''')
ALL_UNITS.append(FOOT_PER_PSI)
FOOT_PER_SECOND_DEGREE_FAHRENHEIT = UnitDescriptor('foot per second degree Fahrenheit', 'K18', '''(ft/s)/°F''')
ALL_UNITS.append(FOOT_PER_SECOND_DEGREE_FAHRENHEIT)
FOOT_PER_SECOND_PSI = UnitDescriptor('foot per second psi', 'K19', '''(ft/s)/psi''')
ALL_UNITS.append(FOOT_PER_SECOND_PSI)
KILOVOLT_AMPERE_REACTIVE_DEMAND = UnitDescriptor('kilovolt ampere reactive demand', 'K2', '''''')
ALL_UNITS.append(KILOVOLT_AMPERE_REACTIVE_DEMAND)
RECIPROCAL_CUBIC_FOOT = UnitDescriptor('reciprocal cubic foot', 'K20', '''1/ft³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_FOOT)
CUBIC_FOOT_PER_DEGREE_FAHRENHEIT = UnitDescriptor('cubic foot per degree Fahrenheit', 'K21', '''ft³/°F''')
ALL_UNITS.append(CUBIC_FOOT_PER_DEGREE_FAHRENHEIT)
CUBIC_FOOT_PER_DAY = UnitDescriptor('cubic foot per day', 'K22', '''ft³/d''')
ALL_UNITS.append(CUBIC_FOOT_PER_DAY)
CUBIC_FOOT_PER_PSI = UnitDescriptor('cubic foot per psi', 'K23', '''ft³/psi''')
ALL_UNITS.append(CUBIC_FOOT_PER_PSI)
FOOT_OF_WATER = UnitDescriptor('foot of water', 'K24', '''ft H₂O''')
ALL_UNITS.append(FOOT_OF_WATER)
FOOT_OF_MERCURY = UnitDescriptor('foot of mercury', 'K25', '''ft Hg''')
ALL_UNITS.append(FOOT_OF_MERCURY)
GALLON_UK_PER_DAY = UnitDescriptor('gallon (UK) per day', 'K26', '''gal (UK)/d''')
ALL_UNITS.append(GALLON_UK_PER_DAY)
GALLON_UK_PER_HOUR = UnitDescriptor('gallon (UK) per hour', 'K27', '''gal (UK)/h''')
ALL_UNITS.append(GALLON_UK_PER_HOUR)
GALLON_UK_PER_SECOND = UnitDescriptor('gallon (UK) per second', 'K28', '''gal (UK)/s''')
ALL_UNITS.append(GALLON_UK_PER_SECOND)
KILOVOLT_AMPERE_REACTIVE_HOUR = UnitDescriptor('kilovolt ampere reactive hour', 'K3', '''kvar·h''')
ALL_UNITS.append(KILOVOLT_AMPERE_REACTIVE_HOUR)
GALLON_US_LIQUID_PER_SECOND = UnitDescriptor('gallon (US liquid) per second', 'K30', '''gal (US liq.)/s''')
ALL_UNITS.append(GALLON_US_LIQUID_PER_SECOND)
GRAM_FORCE_PER_SQUARE_CENTIMETRE = UnitDescriptor('gram-force per square centimetre', 'K31', '''gf/cm²''')
ALL_UNITS.append(GRAM_FORCE_PER_SQUARE_CENTIMETRE)
GILL_UK_PER_DAY = UnitDescriptor('gill (UK) per day', 'K32', '''gi (UK)/d''')
ALL_UNITS.append(GILL_UK_PER_DAY)
GILL_UK_PER_HOUR = UnitDescriptor('gill (UK) per hour', 'K33', '''gi (UK)/h''')
ALL_UNITS.append(GILL_UK_PER_HOUR)
GILL_UK_PER_MINUTE = UnitDescriptor('gill (UK) per minute', 'K34', '''gi (UK)/min''')
ALL_UNITS.append(GILL_UK_PER_MINUTE)
GILL_UK_PER_SECOND = UnitDescriptor('gill (UK) per second', 'K35', '''gi (UK)/s''')
ALL_UNITS.append(GILL_UK_PER_SECOND)
GILL_US_PER_DAY = UnitDescriptor('gill (US) per day', 'K36', '''gi (US)/d''')
ALL_UNITS.append(GILL_US_PER_DAY)
GILL_US_PER_HOUR = UnitDescriptor('gill (US) per hour', 'K37', '''gi (US)/h''')
ALL_UNITS.append(GILL_US_PER_HOUR)
GILL_US_PER_MINUTE = UnitDescriptor('gill (US) per minute', 'K38', '''gi (US)/min''')
ALL_UNITS.append(GILL_US_PER_MINUTE)
GILL_US_PER_SECOND = UnitDescriptor('gill (US) per second', 'K39', '''gi (US)/s''')
ALL_UNITS.append(GILL_US_PER_SECOND)
STANDARD_ACCELERATION_OF_FREE_FALL = UnitDescriptor('standard acceleration of free fall', 'K40', '''gn''')
ALL_UNITS.append(STANDARD_ACCELERATION_OF_FREE_FALL)
GRAIN_PER_GALLON_US = UnitDescriptor('grain per gallon (US)', 'K41', '''gr/gal (US)''')
ALL_UNITS.append(GRAIN_PER_GALLON_US)
HORSEPOWER_BOILER = UnitDescriptor('horsepower (boiler)', 'K42', '''boiler hp''')
ALL_UNITS.append(HORSEPOWER_BOILER)
HORSEPOWER_ELECTRIC = UnitDescriptor('horsepower (electric)', 'K43', '''electric hp''')
ALL_UNITS.append(HORSEPOWER_ELECTRIC)
INCH_PER_DEGREE_FAHRENHEIT = UnitDescriptor('inch per degree Fahrenheit', 'K45', '''in/°F''')
ALL_UNITS.append(INCH_PER_DEGREE_FAHRENHEIT)
INCH_PER_PSI = UnitDescriptor('inch per psi', 'K46', '''in/psi''')
ALL_UNITS.append(INCH_PER_PSI)
INCH_PER_SECOND_DEGREE_FAHRENHEIT = UnitDescriptor('inch per second degree Fahrenheit', 'K47', '''(in/s)/°F''')
ALL_UNITS.append(INCH_PER_SECOND_DEGREE_FAHRENHEIT)
INCH_PER_SECOND_PSI = UnitDescriptor('inch per second psi', 'K48', '''(in/s)/psi''')
ALL_UNITS.append(INCH_PER_SECOND_PSI)
RECIPROCAL_CUBIC_INCH = UnitDescriptor('reciprocal cubic inch', 'K49', '''1/in³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_INCH)
KILOVOLT_AMPERE_REACTIVE = UnitDescriptor('kilovolt ampere (reactive)', 'K5', '''kvar''')
ALL_UNITS.append(KILOVOLT_AMPERE_REACTIVE)
KILOBAUD = UnitDescriptor('kilobaud', 'K50', '''kBd''')
ALL_UNITS.append(KILOBAUD)
KILOCALORIE_MEAN = UnitDescriptor('kilocalorie (mean)', 'K51', '''kcal''')
ALL_UNITS.append(KILOCALORIE_MEAN)
KILOCALORIE_INTERNATIONAL_TABLE_PER_HOUR_METRE_DEGREE_CELSIUS = UnitDescriptor('kilocalorie (international table) per hour metre degree Celsius', 'K52', '''kcal/(m·h·°C)''')
ALL_UNITS.append(KILOCALORIE_INTERNATIONAL_TABLE_PER_HOUR_METRE_DEGREE_CELSIUS)
KILOCALORIE_THERMOCHEMICAL = UnitDescriptor('kilocalorie (thermochemical)', 'K53', '''kcalth''')
ALL_UNITS.append(KILOCALORIE_THERMOCHEMICAL)
KILOCALORIE_THERMOCHEMICAL_PER_MINUTE = UnitDescriptor('kilocalorie (thermochemical) per minute', 'K54', '''kcalth/min''')
ALL_UNITS.append(KILOCALORIE_THERMOCHEMICAL_PER_MINUTE)
KILOCALORIE_THERMOCHEMICAL_PER_SECOND = UnitDescriptor('kilocalorie (thermochemical) per second', 'K55', '''kcalth/s''')
ALL_UNITS.append(KILOCALORIE_THERMOCHEMICAL_PER_SECOND)
KILOMOLE_PER_HOUR = UnitDescriptor('kilomole per hour', 'K58', '''kmol/h''')
ALL_UNITS.append(KILOMOLE_PER_HOUR)
KILOMOLE_PER_CUBIC_METRE_KELVIN = UnitDescriptor('kilomole per cubic metre kelvin', 'K59', '''(kmol/m³)/K''')
ALL_UNITS.append(KILOMOLE_PER_CUBIC_METRE_KELVIN)
KILOLITRE = UnitDescriptor('kilolitre', 'K6', '''kl''')
ALL_UNITS.append(KILOLITRE)
KILOMOLE_PER_CUBIC_METRE_BAR = UnitDescriptor('kilomole per cubic metre bar', 'K60', '''(kmol/m³)/bar''')
ALL_UNITS.append(KILOMOLE_PER_CUBIC_METRE_BAR)
KILOMOLE_PER_MINUTE = UnitDescriptor('kilomole per minute', 'K61', '''kmol/min''')
ALL_UNITS.append(KILOMOLE_PER_MINUTE)
LITRE_PER_LITRE = UnitDescriptor('litre per litre', 'K62', '''l/l''')
ALL_UNITS.append(LITRE_PER_LITRE)
RECIPROCAL_LITRE = UnitDescriptor('reciprocal litre', 'K63', '''1/l''')
ALL_UNITS.append(RECIPROCAL_LITRE)
POUND_AVOIRDUPOIS_PER_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per degree Fahrenheit', 'K64', '''lb/°F''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_SQUARE_FOOT = UnitDescriptor('pound (avoirdupois) square foot', 'K65', '''lb·ft²''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_SQUARE_FOOT)
POUND_AVOIRDUPOIS_PER_DAY = UnitDescriptor('pound (avoirdupois) per day', 'K66', '''lb/d''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_DAY)
POUND_PER_FOOT_HOUR = UnitDescriptor('pound per foot hour', 'K67', '''lb/(ft·h)''')
ALL_UNITS.append(POUND_PER_FOOT_HOUR)
POUND_PER_FOOT_SECOND = UnitDescriptor('pound per foot second', 'K68', '''lb/(ft·s)''')
ALL_UNITS.append(POUND_PER_FOOT_SECOND)
POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per cubic foot degree Fahrenheit', 'K69', '''(lb/ft³)/°F''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_PSI = UnitDescriptor('pound (avoirdupois) per cubic foot psi', 'K70', '''(lb/ft³)/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_PSI)
POUND_AVOIRDUPOIS_PER_GALLON_UK = UnitDescriptor('pound (avoirdupois) per gallon (UK)', 'K71', '''lb/gal (UK)''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_GALLON_UK)
POUND_AVOIRDUPOIS_PER_HOUR_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per hour degree Fahrenheit', 'K73', '''(lb/h)/°F''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_HOUR_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_PER_HOUR_PSI = UnitDescriptor('pound (avoirdupois) per hour psi', 'K74', '''(lb/h)/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_HOUR_PSI)
POUND_AVOIRDUPOIS_PER_CUBIC_INCH_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per cubic inch degree Fahrenheit', 'K75', '''(lb/in³)/°F''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_CUBIC_INCH_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_PER_CUBIC_INCH_PSI = UnitDescriptor('pound (avoirdupois) per cubic inch psi', 'K76', '''(lb/in³)/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_CUBIC_INCH_PSI)
POUND_AVOIRDUPOIS_PER_PSI = UnitDescriptor('pound (avoirdupois) per psi', 'K77', '''lb/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_PSI)
POUND_AVOIRDUPOIS_PER_MINUTE = UnitDescriptor('pound (avoirdupois) per minute', 'K78', '''lb/min''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_MINUTE)
POUND_AVOIRDUPOIS_PER_MINUTE_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per minute degree Fahrenheit', 'K79', '''lb/(min·°F)''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_MINUTE_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_PER_MINUTE_PSI = UnitDescriptor('pound (avoirdupois) per minute psi', 'K80', '''(lb/min)/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_MINUTE_PSI)
POUND_AVOIRDUPOIS_PER_SECOND = UnitDescriptor('pound (avoirdupois) per second', 'K81', '''lb/s''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_SECOND)
POUND_AVOIRDUPOIS_PER_SECOND_DEGREE_FAHRENHEIT = UnitDescriptor('pound (avoirdupois) per second degree Fahrenheit', 'K82', '''(lb/s)/°F''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_SECOND_DEGREE_FAHRENHEIT)
POUND_AVOIRDUPOIS_PER_SECOND_PSI = UnitDescriptor('pound (avoirdupois) per second psi', 'K83', '''(lb/s)/psi''')
ALL_UNITS.append(POUND_AVOIRDUPOIS_PER_SECOND_PSI)
POUND_PER_CUBIC_YARD = UnitDescriptor('pound per cubic yard', 'K84', '''lb/yd³''')
ALL_UNITS.append(POUND_PER_CUBIC_YARD)
POUND_FORCE_PER_SQUARE_FOOT = UnitDescriptor('pound-force per square foot', 'K85', '''lbf/ft²''')
ALL_UNITS.append(POUND_FORCE_PER_SQUARE_FOOT)
POUND_FORCE_PER_SQUARE_INCH_DEGREE_FAHRENHEIT = UnitDescriptor('pound-force per square inch degree Fahrenheit', 'K86', '''psi/°F''')
ALL_UNITS.append(POUND_FORCE_PER_SQUARE_INCH_DEGREE_FAHRENHEIT)
PSI_CUBIC_INCH_PER_SECOND = UnitDescriptor('psi cubic inch per second', 'K87', '''psi·in³/s''')
ALL_UNITS.append(PSI_CUBIC_INCH_PER_SECOND)
PSI_LITRE_PER_SECOND = UnitDescriptor('psi litre per second', 'K88', '''psi·l/s''')
ALL_UNITS.append(PSI_LITRE_PER_SECOND)
PSI_CUBIC_METRE_PER_SECOND = UnitDescriptor('psi cubic metre per second', 'K89', '''psi·m³/s''')
ALL_UNITS.append(PSI_CUBIC_METRE_PER_SECOND)
PSI_CUBIC_YARD_PER_SECOND = UnitDescriptor('psi cubic yard per second', 'K90', '''psi·yd³/s''')
ALL_UNITS.append(PSI_CUBIC_YARD_PER_SECOND)
POUND_FORCE_SECOND_PER_SQUARE_FOOT = UnitDescriptor('pound-force second per square foot', 'K91', '''lbf·s/ft²''')
ALL_UNITS.append(POUND_FORCE_SECOND_PER_SQUARE_FOOT)
POUND_FORCE_SECOND_PER_SQUARE_INCH = UnitDescriptor('pound-force second per square inch', 'K92', '''lbf·s/in²''')
ALL_UNITS.append(POUND_FORCE_SECOND_PER_SQUARE_INCH)
RECIPROCAL_PSI = UnitDescriptor('reciprocal psi', 'K93', '''1/psi''')
ALL_UNITS.append(RECIPROCAL_PSI)
QUART_UK_LIQUID_PER_DAY = UnitDescriptor('quart (UK liquid) per day', 'K94', '''qt (UK liq.)/d''')
ALL_UNITS.append(QUART_UK_LIQUID_PER_DAY)
QUART_UK_LIQUID_PER_HOUR = UnitDescriptor('quart (UK liquid) per hour', 'K95', '''qt (UK liq.)/h''')
ALL_UNITS.append(QUART_UK_LIQUID_PER_HOUR)
QUART_UK_LIQUID_PER_MINUTE = UnitDescriptor('quart (UK liquid) per minute', 'K96', '''qt (UK liq.)/min''')
ALL_UNITS.append(QUART_UK_LIQUID_PER_MINUTE)
QUART_UK_LIQUID_PER_SECOND = UnitDescriptor('quart (UK liquid) per second', 'K97', '''qt (UK liq.)/s''')
ALL_UNITS.append(QUART_UK_LIQUID_PER_SECOND)
QUART_US_LIQUID_PER_DAY = UnitDescriptor('quart (US liquid) per day', 'K98', '''qt (US liq.)/d''')
ALL_UNITS.append(QUART_US_LIQUID_PER_DAY)
QUART_US_LIQUID_PER_HOUR = UnitDescriptor('quart (US liquid) per hour', 'K99', '''qt (US liq.)/h''')
ALL_UNITS.append(QUART_US_LIQUID_PER_HOUR)
CAKE = UnitDescriptor('cake', 'KA', '''''')
ALL_UNITS.append(CAKE)
KATAL = UnitDescriptor('katal', 'KAT', '''kat''')
ALL_UNITS.append(KATAL)
KILOCHARACTER = UnitDescriptor('kilocharacter', 'KB', '''''')
ALL_UNITS.append(KILOCHARACTER)
KILOBAR = UnitDescriptor('kilobar', 'KBA', '''kbar''')
ALL_UNITS.append(KILOBAR)
KILOGRAM_OF_CHOLINE_CHLORIDE = UnitDescriptor('kilogram of choline chloride', 'KCC', '''kg C₅ H₁₄ClNO''')
ALL_UNITS.append(KILOGRAM_OF_CHOLINE_CHLORIDE)
KILOGRAM_DECIMAL = UnitDescriptor('kilogram decimal', 'KD', '''''')
ALL_UNITS.append(KILOGRAM_DECIMAL)
KILOGRAM_DRAINED_NET_WEIGHT = UnitDescriptor('kilogram drained net weight', 'KDW', '''kg/net eda''')
ALL_UNITS.append(KILOGRAM_DRAINED_NET_WEIGHT)
KELVIN = UnitDescriptor('kelvin', 'KEL', '''K''')
ALL_UNITS.append(KELVIN)
KILOPACKET = UnitDescriptor('kilopacket', 'KF', '''''')
ALL_UNITS.append(KILOPACKET)
KEG = UnitDescriptor('keg', 'KG', '''''')
ALL_UNITS.append(KEG)
KILOGRAM = UnitDescriptor('kilogram', 'KGM', '''kg''')
ALL_UNITS.append(KILOGRAM)
KILOGRAM_PER_SECOND = UnitDescriptor('kilogram per second', 'KGS', '''kg/s''')
ALL_UNITS.append(KILOGRAM_PER_SECOND)
KILOGRAM_OF_HYDROGEN_PEROXIDE = UnitDescriptor('kilogram of hydrogen peroxide', 'KHY', '''kg H₂O₂''')
ALL_UNITS.append(KILOGRAM_OF_HYDROGEN_PEROXIDE)
KILOHERTZ = UnitDescriptor('kilohertz', 'KHZ', '''kHz''')
ALL_UNITS.append(KILOHERTZ)
KILOGRAM_PER_MILLIMETRE_WIDTH = UnitDescriptor('kilogram per millimetre width', 'KI', '''''')
ALL_UNITS.append(KILOGRAM_PER_MILLIMETRE_WIDTH)
KILOGRAM_INCLUDING_CONTAINER = UnitDescriptor('kilogram, including container', 'KIC', '''''')
ALL_UNITS.append(KILOGRAM_INCLUDING_CONTAINER)
KILOGRAM_INCLUDING_INNER_PACKAGING = UnitDescriptor('kilogram, including inner packaging', 'KIP', '''''')
ALL_UNITS.append(KILOGRAM_INCLUDING_INNER_PACKAGING)
KILOSEGMENT = UnitDescriptor('kilosegment', 'KJ', '''''')
ALL_UNITS.append(KILOSEGMENT)
KILOJOULE = UnitDescriptor('kilojoule', 'KJO', '''kJ''')
ALL_UNITS.append(KILOJOULE)
KILOGRAM_PER_METRE = UnitDescriptor('kilogram per metre', 'KL', '''kg/m''')
ALL_UNITS.append(KILOGRAM_PER_METRE)
LACTIC_DRY_MATERIAL_PERCENTAGE = UnitDescriptor('lactic dry material percentage', 'KLK', '''''')
ALL_UNITS.append(LACTIC_DRY_MATERIAL_PERCENTAGE)
KILOLUX = UnitDescriptor('kilolux', 'KLX', '''klx''')
ALL_UNITS.append(KILOLUX)
KILOGRAM_OF_METHYLAMINE = UnitDescriptor('kilogram of methylamine', 'KMA', '''kg met.am.''')
ALL_UNITS.append(KILOGRAM_OF_METHYLAMINE)
KILOMETRE_PER_HOUR = UnitDescriptor('kilometre per hour', 'KMH', '''km/h''')
ALL_UNITS.append(KILOMETRE_PER_HOUR)
SQUARE_KILOMETRE = UnitDescriptor('square kilometre', 'KMK', '''km²''')
ALL_UNITS.append(SQUARE_KILOMETRE)
KILOGRAM_PER_CUBIC_METRE = UnitDescriptor('kilogram per cubic metre', 'KMQ', '''kg/m³''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_METRE)
KILOMETRE = UnitDescriptor('kilometre', 'KMT', '''km''')
ALL_UNITS.append(KILOMETRE)
KILOGRAM_OF_NITROGEN = UnitDescriptor('kilogram of nitrogen', 'KNI', '''kg N''')
ALL_UNITS.append(KILOGRAM_OF_NITROGEN)
KILONEWTON_PER_SQUARE_METRE = UnitDescriptor('kilonewton per square metre', 'KNM', '''kN/m2''')
ALL_UNITS.append(KILONEWTON_PER_SQUARE_METRE)
KILOGRAM_NAMED_SUBSTANCE = UnitDescriptor('kilogram named substance', 'KNS', '''''')
ALL_UNITS.append(KILOGRAM_NAMED_SUBSTANCE)
KNOT = UnitDescriptor('knot', 'KNT', '''kn''')
ALL_UNITS.append(KNOT)
MILLIEQUIVALENCE_CAUSTIC_POTASH_PER_GRAM_OF_PRODUCT = UnitDescriptor('milliequivalence caustic potash per gram of product', 'KO', '''''')
ALL_UNITS.append(MILLIEQUIVALENCE_CAUSTIC_POTASH_PER_GRAM_OF_PRODUCT)
KILOPASCAL = UnitDescriptor('kilopascal', 'KPA', '''kPa''')
ALL_UNITS.append(KILOPASCAL)
KILOGRAM_OF_POTASSIUM_HYDROXIDE_CAUSTIC_POTASH = UnitDescriptor('kilogram of potassium hydroxide (caustic potash)', 'KPH', '''kg KOH''')
ALL_UNITS.append(KILOGRAM_OF_POTASSIUM_HYDROXIDE_CAUSTIC_POTASH)
KILOGRAM_OF_POTASSIUM_OXIDE = UnitDescriptor('kilogram of potassium oxide', 'KPO', '''kg K₂O''')
ALL_UNITS.append(KILOGRAM_OF_POTASSIUM_OXIDE)
KILOGRAM_OF_PHOSPHORUS_PENTOXIDE_PHOSPHORIC_ANHYDRIDE = UnitDescriptor('kilogram of phosphorus pentoxide (phosphoric anhydride)', 'KPP', '''''')
ALL_UNITS.append(KILOGRAM_OF_PHOSPHORUS_PENTOXIDE_PHOSPHORIC_ANHYDRIDE)
KILOROENTGEN = UnitDescriptor('kiloroentgen', 'KR', '''kR''')
ALL_UNITS.append(KILOROENTGEN)
THOUSAND_POUND_PER_SQUARE_INCH = UnitDescriptor('thousand pound per square inch', 'KS', '''''')
ALL_UNITS.append(THOUSAND_POUND_PER_SQUARE_INCH)
KILOGRAM_OF_SUBSTANCE_90_PERCENT_DRY = UnitDescriptor('kilogram of substance 90 % dry', 'KSD', '''kg 90 % sdt''')
ALL_UNITS.append(KILOGRAM_OF_SUBSTANCE_90_PERCENT_DRY)
KILOGRAM_OF_SODIUM_HYDROXIDE_CAUSTIC_SODA = UnitDescriptor('kilogram of sodium hydroxide (caustic soda)', 'KSH', '''kg NaOH''')
ALL_UNITS.append(KILOGRAM_OF_SODIUM_HYDROXIDE_CAUSTIC_SODA)
KIT = UnitDescriptor('kit', 'KT', '''''')
ALL_UNITS.append(KIT)
KILOTONNE = UnitDescriptor('kilotonne', 'KTN', '''kt''')
ALL_UNITS.append(KILOTONNE)
KILOGRAM_OF_URANIUM = UnitDescriptor('kilogram of uranium', 'KUR', '''kg U''')
ALL_UNITS.append(KILOGRAM_OF_URANIUM)
KILOVOLT_AMPERE = UnitDescriptor('kilovolt - ampere', 'KVA', '''kV·A''')
ALL_UNITS.append(KILOVOLT_AMPERE)
KILOVAR = UnitDescriptor('kilovar', 'KVR', '''kvar''')
ALL_UNITS.append(KILOVAR)
KILOVOLT = UnitDescriptor('kilovolt', 'KVT', '''kV''')
ALL_UNITS.append(KILOVOLT)
KILOGRAM_PER_MILLIMETRE = UnitDescriptor('kilogram per millimetre', 'KW', '''kg/mm''')
ALL_UNITS.append(KILOGRAM_PER_MILLIMETRE)
KILOWATT_HOUR = UnitDescriptor('kilowatt hour', 'KWH', '''kW·h''')
ALL_UNITS.append(KILOWATT_HOUR)
KILOWATT_YEAR = UnitDescriptor('kilowatt year', 'KWY', '''kW/year''')
ALL_UNITS.append(KILOWATT_YEAR)
KILOWATT_HOUR_PER_NORMALIZED_CUBIC_METRE = UnitDescriptor('Kilowatt hour per normalized cubic metre', 'KWN', '''''')
ALL_UNITS.append(KILOWATT_HOUR_PER_NORMALIZED_CUBIC_METRE)
KILOGRAM_OF_TUNGSTEN_TRIOXIDE = UnitDescriptor('kilogram of tungsten trioxide', 'KWO', '''kg WO₃''')
ALL_UNITS.append(KILOGRAM_OF_TUNGSTEN_TRIOXIDE)
KILOWATT_HOUR_PER_STANDARD_CUBIC_METRE = UnitDescriptor('Kilowatt hour per standard cubic metre', 'KWS', '''''')
ALL_UNITS.append(KILOWATT_HOUR_PER_STANDARD_CUBIC_METRE)
KILOWATT = UnitDescriptor('kilowatt', 'KWT', '''kW''')
ALL_UNITS.append(KILOWATT)
MILLILITRE_PER_KILOGRAM = UnitDescriptor('millilitre per kilogram', 'KX', '''ml/kg''')
ALL_UNITS.append(MILLILITRE_PER_KILOGRAM)
QUART_US_LIQUID_PER_MINUTE = UnitDescriptor('quart (US liquid) per minute', 'L10', '''qt (US liq.)/min''')
ALL_UNITS.append(QUART_US_LIQUID_PER_MINUTE)
QUART_US_LIQUID_PER_SECOND = UnitDescriptor('quart (US liquid) per second', 'L11', '''qt (US liq.)/s''')
ALL_UNITS.append(QUART_US_LIQUID_PER_SECOND)
METRE_PER_SECOND_KELVIN = UnitDescriptor('metre per second kelvin', 'L12', '''(m/s)/K''')
ALL_UNITS.append(METRE_PER_SECOND_KELVIN)
METRE_PER_SECOND_BAR = UnitDescriptor('metre per second bar', 'L13', '''(m/s)/bar''')
ALL_UNITS.append(METRE_PER_SECOND_BAR)
SQUARE_METRE_HOUR_DEGREE_CELSIUS_PER_KILOCALORIE_INTERNATIONAL_TABLE = UnitDescriptor('square metre hour degree Celsius per kilocalorie (international table)', 'L14', '''m²·h·°C/kcal''')
ALL_UNITS.append(SQUARE_METRE_HOUR_DEGREE_CELSIUS_PER_KILOCALORIE_INTERNATIONAL_TABLE)
MILLIPASCAL_SECOND_PER_KELVIN = UnitDescriptor('millipascal second per kelvin', 'L15', '''mPa·s/K''')
ALL_UNITS.append(MILLIPASCAL_SECOND_PER_KELVIN)
MILLIPASCAL_SECOND_PER_BAR = UnitDescriptor('millipascal second per bar', 'L16', '''mPa·s/bar''')
ALL_UNITS.append(MILLIPASCAL_SECOND_PER_BAR)
MILLIGRAM_PER_CUBIC_METRE_KELVIN = UnitDescriptor('milligram per cubic metre kelvin', 'L17', '''(mg/m³)/K''')
ALL_UNITS.append(MILLIGRAM_PER_CUBIC_METRE_KELVIN)
MILLIGRAM_PER_CUBIC_METRE_BAR = UnitDescriptor('milligram per cubic metre bar', 'L18', '''(mg/m³)/bar''')
ALL_UNITS.append(MILLIGRAM_PER_CUBIC_METRE_BAR)
MILLILITRE_PER_LITRE = UnitDescriptor('millilitre per litre', 'L19', '''ml/l''')
ALL_UNITS.append(MILLILITRE_PER_LITRE)
LITRE_PER_MINUTE = UnitDescriptor('litre per minute', 'L2', '''l/min''')
ALL_UNITS.append(LITRE_PER_MINUTE)
RECIPROCAL_CUBIC_MILLIMETRE = UnitDescriptor('reciprocal cubic millimetre', 'L20', '''1/mm³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_MILLIMETRE)
CUBIC_MILLIMETRE_PER_CUBIC_METRE = UnitDescriptor('cubic millimetre per cubic metre', 'L21', '''mm³/m³''')
ALL_UNITS.append(CUBIC_MILLIMETRE_PER_CUBIC_METRE)
MOLE_PER_HOUR = UnitDescriptor('mole per hour', 'L23', '''mol/h''')
ALL_UNITS.append(MOLE_PER_HOUR)
MOLE_PER_KILOGRAM_KELVIN = UnitDescriptor('mole per kilogram kelvin', 'L24', '''(mol/kg)/K''')
ALL_UNITS.append(MOLE_PER_KILOGRAM_KELVIN)
MOLE_PER_KILOGRAM_BAR = UnitDescriptor('mole per kilogram bar', 'L25', '''(mol/kg)/bar''')
ALL_UNITS.append(MOLE_PER_KILOGRAM_BAR)
MOLE_PER_LITRE_KELVIN = UnitDescriptor('mole per litre kelvin', 'L26', '''(mol/l)/K''')
ALL_UNITS.append(MOLE_PER_LITRE_KELVIN)
MOLE_PER_LITRE_BAR = UnitDescriptor('mole per litre bar', 'L27', '''(mol/l)/bar''')
ALL_UNITS.append(MOLE_PER_LITRE_BAR)
MOLE_PER_CUBIC_METRE_KELVIN = UnitDescriptor('mole per cubic metre kelvin', 'L28', '''(mol/m³)/K''')
ALL_UNITS.append(MOLE_PER_CUBIC_METRE_KELVIN)
MOLE_PER_CUBIC_METRE_BAR = UnitDescriptor('mole per cubic metre bar', 'L29', '''(mol/m³)/bar''')
ALL_UNITS.append(MOLE_PER_CUBIC_METRE_BAR)
MOLE_PER_MINUTE = UnitDescriptor('mole per minute', 'L30', '''mol/min''')
ALL_UNITS.append(MOLE_PER_MINUTE)
MILLIROENTGEN_AEQUIVALENT_MEN = UnitDescriptor('milliroentgen aequivalent men', 'L31', '''mrem''')
ALL_UNITS.append(MILLIROENTGEN_AEQUIVALENT_MEN)
NANOGRAM_PER_KILOGRAM = UnitDescriptor('nanogram per kilogram', 'L32', '''ng/kg''')
ALL_UNITS.append(NANOGRAM_PER_KILOGRAM)
OUNCE_AVOIRDUPOIS_PER_DAY = UnitDescriptor('ounce (avoirdupois) per day', 'L33', '''oz/d''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_DAY)
OUNCE_AVOIRDUPOIS_PER_HOUR = UnitDescriptor('ounce (avoirdupois) per hour', 'L34', '''oz/h''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_HOUR)
OUNCE_AVOIRDUPOIS_PER_MINUTE = UnitDescriptor('ounce (avoirdupois) per minute', 'L35', '''oz/min''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_MINUTE)
OUNCE_AVOIRDUPOIS_PER_SECOND = UnitDescriptor('ounce (avoirdupois) per second', 'L36', '''oz/s''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_SECOND)
OUNCE_AVOIRDUPOIS_PER_GALLON_UK = UnitDescriptor('ounce (avoirdupois) per gallon (UK)', 'L37', '''oz/gal (UK)''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_GALLON_UK)
OUNCE_AVOIRDUPOIS_PER_GALLON_US = UnitDescriptor('ounce (avoirdupois) per gallon (US)', 'L38', '''oz/gal (US)''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_GALLON_US)
OUNCE_AVOIRDUPOIS_PER_CUBIC_INCH = UnitDescriptor('ounce (avoirdupois) per cubic inch', 'L39', '''oz/in³''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_CUBIC_INCH)
OUNCE_AVOIRDUPOIS_FORCE = UnitDescriptor('ounce (avoirdupois)-force', 'L40', '''ozf''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_FORCE)
OUNCE_AVOIRDUPOIS_FORCE_INCH = UnitDescriptor('ounce (avoirdupois)-force inch', 'L41', '''ozf·in''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_FORCE_INCH)
PICOSIEMENS_PER_METRE = UnitDescriptor('picosiemens per metre', 'L42', '''pS/m''')
ALL_UNITS.append(PICOSIEMENS_PER_METRE)
PECK_UK = UnitDescriptor('peck (UK)', 'L43', '''pk (UK)''')
ALL_UNITS.append(PECK_UK)
PECK_UK_PER_DAY = UnitDescriptor('peck (UK) per day', 'L44', '''pk (UK)/d''')
ALL_UNITS.append(PECK_UK_PER_DAY)
PECK_UK_PER_HOUR = UnitDescriptor('peck (UK) per hour', 'L45', '''pk (UK)/h''')
ALL_UNITS.append(PECK_UK_PER_HOUR)
PECK_UK_PER_MINUTE = UnitDescriptor('peck (UK) per minute', 'L46', '''pk (UK)/min''')
ALL_UNITS.append(PECK_UK_PER_MINUTE)
PECK_UK_PER_SECOND = UnitDescriptor('peck (UK) per second', 'L47', '''pk (UK)/s''')
ALL_UNITS.append(PECK_UK_PER_SECOND)
PECK_US_DRY_PER_DAY = UnitDescriptor('peck (US dry) per day', 'L48', '''pk (US dry)/d''')
ALL_UNITS.append(PECK_US_DRY_PER_DAY)
PECK_US_DRY_PER_HOUR = UnitDescriptor('peck (US dry) per hour', 'L49', '''pk (US dry)/h''')
ALL_UNITS.append(PECK_US_DRY_PER_HOUR)
PECK_US_DRY_PER_MINUTE = UnitDescriptor('peck (US dry) per minute', 'L50', '''pk (US dry)/min''')
ALL_UNITS.append(PECK_US_DRY_PER_MINUTE)
PECK_US_DRY_PER_SECOND = UnitDescriptor('peck (US dry) per second', 'L51', '''pk (US dry)/s''')
ALL_UNITS.append(PECK_US_DRY_PER_SECOND)
PSI_PER_PSI = UnitDescriptor('psi per psi', 'L52', '''psi/psi''')
ALL_UNITS.append(PSI_PER_PSI)
PINT_UK_PER_DAY = UnitDescriptor('pint (UK) per day', 'L53', '''pt (UK)/d''')
ALL_UNITS.append(PINT_UK_PER_DAY)
PINT_UK_PER_HOUR = UnitDescriptor('pint (UK) per hour', 'L54', '''pt (UK)/h''')
ALL_UNITS.append(PINT_UK_PER_HOUR)
PINT_UK_PER_MINUTE = UnitDescriptor('pint (UK) per minute', 'L55', '''pt (UK)/min''')
ALL_UNITS.append(PINT_UK_PER_MINUTE)
PINT_UK_PER_SECOND = UnitDescriptor('pint (UK) per second', 'L56', '''pt (UK)/s''')
ALL_UNITS.append(PINT_UK_PER_SECOND)
PINT_US_LIQUID_PER_DAY = UnitDescriptor('pint (US liquid) per day', 'L57', '''pt (US liq.)/d''')
ALL_UNITS.append(PINT_US_LIQUID_PER_DAY)
PINT_US_LIQUID_PER_HOUR = UnitDescriptor('pint (US liquid) per hour', 'L58', '''pt (US liq.)/h''')
ALL_UNITS.append(PINT_US_LIQUID_PER_HOUR)
PINT_US_LIQUID_PER_MINUTE = UnitDescriptor('pint (US liquid) per minute', 'L59', '''pt (US liq.)/min''')
ALL_UNITS.append(PINT_US_LIQUID_PER_MINUTE)
PINT_US_LIQUID_PER_SECOND = UnitDescriptor('pint (US liquid) per second', 'L60', '''pt (US liq.)/s''')
ALL_UNITS.append(PINT_US_LIQUID_PER_SECOND)
PINT_US_DRY = UnitDescriptor('pint (US dry)', 'L61', '''pt (US dry)''')
ALL_UNITS.append(PINT_US_DRY)
QUART_US_DRY = UnitDescriptor('quart (US dry)', 'L62', '''qt (US dry)''')
ALL_UNITS.append(QUART_US_DRY)
SLUG_PER_DAY = UnitDescriptor('slug per day', 'L63', '''slug/d''')
ALL_UNITS.append(SLUG_PER_DAY)
SLUG_PER_FOOT_SECOND = UnitDescriptor('slug per foot second', 'L64', '''slug/(ft·s)''')
ALL_UNITS.append(SLUG_PER_FOOT_SECOND)
SLUG_PER_CUBIC_FOOT = UnitDescriptor('slug per cubic foot', 'L65', '''slug/ft³''')
ALL_UNITS.append(SLUG_PER_CUBIC_FOOT)
SLUG_PER_HOUR = UnitDescriptor('slug per hour', 'L66', '''slug/h''')
ALL_UNITS.append(SLUG_PER_HOUR)
SLUG_PER_MINUTE = UnitDescriptor('slug per minute', 'L67', '''slug/min''')
ALL_UNITS.append(SLUG_PER_MINUTE)
SLUG_PER_SECOND = UnitDescriptor('slug per second', 'L68', '''slug/s''')
ALL_UNITS.append(SLUG_PER_SECOND)
TONNE_PER_KELVIN = UnitDescriptor('tonne per kelvin', 'L69', '''t/K''')
ALL_UNITS.append(TONNE_PER_KELVIN)
TONNE_PER_BAR = UnitDescriptor('tonne per bar', 'L70', '''t/bar''')
ALL_UNITS.append(TONNE_PER_BAR)
TONNE_PER_DAY = UnitDescriptor('tonne per day', 'L71', '''t/d''')
ALL_UNITS.append(TONNE_PER_DAY)
TONNE_PER_DAY_KELVIN = UnitDescriptor('tonne per day kelvin', 'L72', '''(t/d)/K''')
ALL_UNITS.append(TONNE_PER_DAY_KELVIN)
TONNE_PER_DAY_BAR = UnitDescriptor('tonne per day bar', 'L73', '''(t/d)/bar''')
ALL_UNITS.append(TONNE_PER_DAY_BAR)
TONNE_PER_HOUR_KELVIN = UnitDescriptor('tonne per hour kelvin', 'L74', '''(t/h)/K''')
ALL_UNITS.append(TONNE_PER_HOUR_KELVIN)
TONNE_PER_HOUR_BAR = UnitDescriptor('tonne per hour bar', 'L75', '''(t/h)/bar''')
ALL_UNITS.append(TONNE_PER_HOUR_BAR)
TONNE_PER_CUBIC_METRE_KELVIN = UnitDescriptor('tonne per cubic metre kelvin', 'L76', '''(t/m³)/K''')
ALL_UNITS.append(TONNE_PER_CUBIC_METRE_KELVIN)
TONNE_PER_CUBIC_METRE_BAR = UnitDescriptor('tonne per cubic metre bar', 'L77', '''(t/m³)/bar''')
ALL_UNITS.append(TONNE_PER_CUBIC_METRE_BAR)
TONNE_PER_MINUTE = UnitDescriptor('tonne per minute', 'L78', '''t/min''')
ALL_UNITS.append(TONNE_PER_MINUTE)
TONNE_PER_MINUTE_KELVIN = UnitDescriptor('tonne per minute kelvin', 'L79', '''(t/min)/K''')
ALL_UNITS.append(TONNE_PER_MINUTE_KELVIN)
TONNE_PER_MINUTE_BAR = UnitDescriptor('tonne per minute bar', 'L80', '''(t/min)/bar''')
ALL_UNITS.append(TONNE_PER_MINUTE_BAR)
TONNE_PER_SECOND = UnitDescriptor('tonne per second', 'L81', '''t/s''')
ALL_UNITS.append(TONNE_PER_SECOND)
TONNE_PER_SECOND_KELVIN = UnitDescriptor('tonne per second kelvin', 'L82', '''(t/s)/K''')
ALL_UNITS.append(TONNE_PER_SECOND_KELVIN)
TONNE_PER_SECOND_BAR = UnitDescriptor('tonne per second bar', 'L83', '''(t/s)/bar''')
ALL_UNITS.append(TONNE_PER_SECOND_BAR)
TON_UK_SHIPPING = UnitDescriptor('ton (UK shipping)', 'L84', '''British shipping ton''')
ALL_UNITS.append(TON_UK_SHIPPING)
TON_LONG_PER_DAY = UnitDescriptor('ton long per day', 'L85', '''ton (UK)/d''')
ALL_UNITS.append(TON_LONG_PER_DAY)
TON_US_SHIPPING = UnitDescriptor('ton (US shipping)', 'L86', '''(US) shipping ton''')
ALL_UNITS.append(TON_US_SHIPPING)
TON_SHORT_PER_DEGREE_FAHRENHEIT = UnitDescriptor('ton short per degree Fahrenheit', 'L87', '''ton (US)/°F''')
ALL_UNITS.append(TON_SHORT_PER_DEGREE_FAHRENHEIT)
TON_SHORT_PER_DAY = UnitDescriptor('ton short per day', 'L88', '''ton (US)/d''')
ALL_UNITS.append(TON_SHORT_PER_DAY)
TON_SHORT_PER_HOUR_DEGREE_FAHRENHEIT = UnitDescriptor('ton short per hour degree Fahrenheit', 'L89', '''ton (US)/(h·°F)''')
ALL_UNITS.append(TON_SHORT_PER_HOUR_DEGREE_FAHRENHEIT)
TON_SHORT_PER_HOUR_PSI = UnitDescriptor('ton short per hour psi', 'L90', '''(ton (US)/h)/psi''')
ALL_UNITS.append(TON_SHORT_PER_HOUR_PSI)
TON_SHORT_PER_PSI = UnitDescriptor('ton short per psi', 'L91', '''ton (US)/psi''')
ALL_UNITS.append(TON_SHORT_PER_PSI)
TON_UK_LONG_PER_CUBIC_YARD = UnitDescriptor('ton (UK long) per cubic yard', 'L92', '''ton.l/yd³ (UK)''')
ALL_UNITS.append(TON_UK_LONG_PER_CUBIC_YARD)
TON_US_SHORT_PER_CUBIC_YARD = UnitDescriptor('ton (US short) per cubic yard', 'L93', '''ton.s/yd³ (US)''')
ALL_UNITS.append(TON_US_SHORT_PER_CUBIC_YARD)
TON_FORCE_US_SHORT = UnitDescriptor('ton-force (US short)', 'L94', '''ton.sh-force''')
ALL_UNITS.append(TON_FORCE_US_SHORT)
COMMON_YEAR = UnitDescriptor('common year', 'L95', '''y (365 days)''')
ALL_UNITS.append(COMMON_YEAR)
SIDEREAL_YEAR = UnitDescriptor('sidereal year', 'L96', '''y (sidereal)''')
ALL_UNITS.append(SIDEREAL_YEAR)
YARD_PER_DEGREE_FAHRENHEIT = UnitDescriptor('yard per degree Fahrenheit', 'L98', '''yd/°F''')
ALL_UNITS.append(YARD_PER_DEGREE_FAHRENHEIT)
YARD_PER_PSI = UnitDescriptor('yard per psi', 'L99', '''yd/psi''')
ALL_UNITS.append(YARD_PER_PSI)
POUND_PER_CUBIC_INCH = UnitDescriptor('pound per cubic inch', 'LA', '''lb/in³''')
ALL_UNITS.append(POUND_PER_CUBIC_INCH)
LACTOSE_EXCESS_PERCENTAGE = UnitDescriptor('lactose excess percentage', 'LAC', '''''')
ALL_UNITS.append(LACTOSE_EXCESS_PERCENTAGE)
POUND = UnitDescriptor('pound', 'LBR', '''lb''')
ALL_UNITS.append(POUND)
TROY_POUND_US = UnitDescriptor('troy pound (US)', 'LBT', '''''')
ALL_UNITS.append(TROY_POUND_US)
LINEAR_CENTIMETRE = UnitDescriptor('linear centimetre', 'LC', '''''')
ALL_UNITS.append(LINEAR_CENTIMETRE)
LITRE_PER_DAY = UnitDescriptor('litre per day', 'LD', '''l/d''')
ALL_UNITS.append(LITRE_PER_DAY)
LITE = UnitDescriptor('lite', 'LE', '''''')
ALL_UNITS.append(LITE)
LEAF = UnitDescriptor('leaf', 'LEF', '''''')
ALL_UNITS.append(LEAF)
LINEAR_FOOT = UnitDescriptor('linear foot', 'LF', '''''')
ALL_UNITS.append(LINEAR_FOOT)
LABOUR_HOUR = UnitDescriptor('labour hour', 'LH', '''''')
ALL_UNITS.append(LABOUR_HOUR)
LINEAR_INCH = UnitDescriptor('linear inch', 'LI', '''''')
ALL_UNITS.append(LINEAR_INCH)
LARGE_SPRAY = UnitDescriptor('large spray', 'LJ', '''''')
ALL_UNITS.append(LARGE_SPRAY)
LINK = UnitDescriptor('link', 'LK', '''''')
ALL_UNITS.append(LINK)
LINEAR_METRE = UnitDescriptor('linear metre', 'LM', '''''')
ALL_UNITS.append(LINEAR_METRE)
LENGTH = UnitDescriptor('length', 'LN', '''''')
ALL_UNITS.append(LENGTH)
LOT_UNIT_OF_PROCUREMENT = UnitDescriptor('lot [unit of procurement]', 'LO', '''''')
ALL_UNITS.append(LOT_UNIT_OF_PROCUREMENT)
LIQUID_POUND = UnitDescriptor('liquid pound', 'LP', '''''')
ALL_UNITS.append(LIQUID_POUND)
LITRE_OF_PURE_ALCOHOL = UnitDescriptor('litre of pure alcohol', 'LPA', '''''')
ALL_UNITS.append(LITRE_OF_PURE_ALCOHOL)
LAYER = UnitDescriptor('layer', 'LR', '''''')
ALL_UNITS.append(LAYER)
LUMP_SUM = UnitDescriptor('lump sum', 'LS', '''''')
ALL_UNITS.append(LUMP_SUM)
TON_UK_OR_LONG_TON_US = UnitDescriptor('ton (UK) or long ton (US)', 'LTN', '''ton (UK)''')
ALL_UNITS.append(TON_UK_OR_LONG_TON_US)
LITRE = UnitDescriptor('litre', 'LTR', '''l''')
ALL_UNITS.append(LITRE)
METRIC_TON_LUBRICATING_OIL = UnitDescriptor('metric ton, lubricating oil', 'LUB', '''''')
ALL_UNITS.append(METRIC_TON_LUBRICATING_OIL)
LUMEN = UnitDescriptor('lumen', 'LUM', '''lm''')
ALL_UNITS.append(LUMEN)
LUX = UnitDescriptor('lux', 'LUX', '''lx''')
ALL_UNITS.append(LUX)
LINEAR_YARD_PER_POUND = UnitDescriptor('linear yard per pound', 'LX', '''''')
ALL_UNITS.append(LINEAR_YARD_PER_POUND)
LINEAR_YARD = UnitDescriptor('linear yard', 'LY', '''''')
ALL_UNITS.append(LINEAR_YARD)
MAGNETIC_TAPE = UnitDescriptor('magnetic tape', 'M0', '''''')
ALL_UNITS.append(MAGNETIC_TAPE)
MILLIGRAM_PER_LITRE = UnitDescriptor('milligram per litre', 'M1', '''mg/l''')
ALL_UNITS.append(MILLIGRAM_PER_LITRE)
RECIPROCAL_CUBIC_YARD = UnitDescriptor('reciprocal cubic yard', 'M10', '''1/yd³''')
ALL_UNITS.append(RECIPROCAL_CUBIC_YARD)
CUBIC_YARD_PER_DEGREE_FAHRENHEIT = UnitDescriptor('cubic yard per degree Fahrenheit', 'M11', '''yd³/°F''')
ALL_UNITS.append(CUBIC_YARD_PER_DEGREE_FAHRENHEIT)
CUBIC_YARD_PER_DAY = UnitDescriptor('cubic yard per day', 'M12', '''yd³/d''')
ALL_UNITS.append(CUBIC_YARD_PER_DAY)
CUBIC_YARD_PER_HOUR = UnitDescriptor('cubic yard per hour', 'M13', '''yd³/h''')
ALL_UNITS.append(CUBIC_YARD_PER_HOUR)
CUBIC_YARD_PER_PSI = UnitDescriptor('cubic yard per psi', 'M14', '''yd³/psi''')
ALL_UNITS.append(CUBIC_YARD_PER_PSI)
CUBIC_YARD_PER_MINUTE = UnitDescriptor('cubic yard per minute', 'M15', '''yd³/min''')
ALL_UNITS.append(CUBIC_YARD_PER_MINUTE)
CUBIC_YARD_PER_SECOND = UnitDescriptor('cubic yard per second', 'M16', '''yd³/s''')
ALL_UNITS.append(CUBIC_YARD_PER_SECOND)
KILOHERTZ_METRE = UnitDescriptor('kilohertz metre', 'M17', '''kHz·m''')
ALL_UNITS.append(KILOHERTZ_METRE)
GIGAHERTZ_METRE = UnitDescriptor('gigahertz metre', 'M18', '''GHz·m''')
ALL_UNITS.append(GIGAHERTZ_METRE)
BEAUFORT = UnitDescriptor('Beaufort', 'M19', '''Bft''')
ALL_UNITS.append(BEAUFORT)
RECIPROCAL_MEGAKELVIN_OR_MEGAKELVIN_TO_THE_POWER_MINUS_ONE = UnitDescriptor('reciprocal megakelvin or megakelvin to the power minus one', 'M20', '''1/MK''')
ALL_UNITS.append(RECIPROCAL_MEGAKELVIN_OR_MEGAKELVIN_TO_THE_POWER_MINUS_ONE)
RECIPROCAL_KILOVOLT_AMPERE_RECIPROCAL_HOUR = UnitDescriptor('reciprocal kilovolt - ampere reciprocal hour', 'M21', '''1/kVAh''')
ALL_UNITS.append(RECIPROCAL_KILOVOLT_AMPERE_RECIPROCAL_HOUR)
MILLILITRE_PER_SQUARE_CENTIMETRE_MINUTE = UnitDescriptor('millilitre per square centimetre minute', 'M22', '''(ml/min)/cm²''')
ALL_UNITS.append(MILLILITRE_PER_SQUARE_CENTIMETRE_MINUTE)
NEWTON_PER_CENTIMETRE = UnitDescriptor('newton per centimetre', 'M23', '''N/cm''')
ALL_UNITS.append(NEWTON_PER_CENTIMETRE)
OHM_KILOMETRE = UnitDescriptor('ohm kilometre', 'M24', '''Ω·km''')
ALL_UNITS.append(OHM_KILOMETRE)
PERCENT_PER_DEGREE_CELSIUS = UnitDescriptor('percent per degree Celsius', 'M25', '''%/°C''')
ALL_UNITS.append(PERCENT_PER_DEGREE_CELSIUS)
GIGAOHM_PER_METRE = UnitDescriptor('gigaohm per metre', 'M26', '''GΩ/m''')
ALL_UNITS.append(GIGAOHM_PER_METRE)
MEGAHERTZ_METRE = UnitDescriptor('megahertz metre', 'M27', '''MHz·m''')
ALL_UNITS.append(MEGAHERTZ_METRE)
KILOGRAM_PER_KILOGRAM = UnitDescriptor('kilogram per kilogram', 'M29', '''kg/kg''')
ALL_UNITS.append(KILOGRAM_PER_KILOGRAM)
RECIPROCAL_VOLT_AMPERE_RECIPROCAL_SECOND = UnitDescriptor('reciprocal volt - ampere reciprocal second', 'M30', '''1/(V·A·s)''')
ALL_UNITS.append(RECIPROCAL_VOLT_AMPERE_RECIPROCAL_SECOND)
KILOGRAM_PER_KILOMETRE = UnitDescriptor('kilogram per kilometre', 'M31', '''kg/km''')
ALL_UNITS.append(KILOGRAM_PER_KILOMETRE)
PASCAL_SECOND_PER_LITRE = UnitDescriptor('pascal second per litre', 'M32', '''Pa·s/l''')
ALL_UNITS.append(PASCAL_SECOND_PER_LITRE)
MILLIMOLE_PER_LITRE = UnitDescriptor('millimole per litre', 'M33', '''mmol/l''')
ALL_UNITS.append(MILLIMOLE_PER_LITRE)
NEWTON_METRE_PER_SQUARE_METRE = UnitDescriptor('newton metre per square metre', 'M34', '''N·m/m²''')
ALL_UNITS.append(NEWTON_METRE_PER_SQUARE_METRE)
MILLIVOLT_AMPERE = UnitDescriptor('millivolt - ampere', 'M35', '''mV·A''')
ALL_UNITS.append(MILLIVOLT_AMPERE)
THIRTY_DAY_MONTH = UnitDescriptor('30-day month', 'M36', '''mo (30 days)''')
ALL_UNITS.append(THIRTY_DAY_MONTH)
ACTUAL_PER_360 = UnitDescriptor('actual/360', 'M37', '''y (360 days)''')
ALL_UNITS.append(ACTUAL_PER_360)
KILOMETRE_PER_SECOND_SQUARED = UnitDescriptor('kilometre per second squared', 'M38', '''km/s²''')
ALL_UNITS.append(KILOMETRE_PER_SECOND_SQUARED)
CENTIMETRE_PER_SECOND_SQUARED = UnitDescriptor('centimetre per second squared', 'M39', '''cm/s²''')
ALL_UNITS.append(CENTIMETRE_PER_SECOND_SQUARED)
MONETARY_VALUE = UnitDescriptor('monetary value', 'M4', '''''')
ALL_UNITS.append(MONETARY_VALUE)
YARD_PER_SECOND_SQUARED = UnitDescriptor('yard per second squared', 'M40', '''yd/s²''')
ALL_UNITS.append(YARD_PER_SECOND_SQUARED)
MILLIMETRE_PER_SECOND_SQUARED = UnitDescriptor('millimetre per second squared', 'M41', '''mm/s²''')
ALL_UNITS.append(MILLIMETRE_PER_SECOND_SQUARED)
MILE_STATUTE_MILE_PER_SECOND_SQUARED = UnitDescriptor('mile (statute mile) per second squared', 'M42', '''mi/s²''')
ALL_UNITS.append(MILE_STATUTE_MILE_PER_SECOND_SQUARED)
MIL = UnitDescriptor('mil', 'M43', '''mil''')
ALL_UNITS.append(MIL)
REVOLUTION = UnitDescriptor('revolution', 'M44', '''rev''')
ALL_UNITS.append(REVOLUTION)
DEGREE_UNIT_OF_ANGLE_PER_SECOND_SQUARED = UnitDescriptor('degree [unit of angle] per second squared', 'M45', '''°/s²''')
ALL_UNITS.append(DEGREE_UNIT_OF_ANGLE_PER_SECOND_SQUARED)
REVOLUTION_PER_MINUTE = UnitDescriptor('revolution per minute', 'M46', '''r/min''')
ALL_UNITS.append(REVOLUTION_PER_MINUTE)
CIRCULAR_MIL = UnitDescriptor('circular mil', 'M47', '''cmil''')
ALL_UNITS.append(CIRCULAR_MIL)
SQUARE_MILE_BASED_ON_U_S_SURVEY_FOOT = UnitDescriptor('square mile (based on U.S. survey foot)', 'M48', '''mi² (US survey)''')
ALL_UNITS.append(SQUARE_MILE_BASED_ON_U_S_SURVEY_FOOT)
CHAIN_BASED_ON_U_S_SURVEY_FOOT = UnitDescriptor('chain (based on U.S. survey foot)', 'M49', '''ch (US survey) ''')
ALL_UNITS.append(CHAIN_BASED_ON_U_S_SURVEY_FOOT)
MICROCURIE = UnitDescriptor('microcurie', 'M5', '''µCi''')
ALL_UNITS.append(MICROCURIE)
FURLONG = UnitDescriptor('furlong', 'M50', '''fur''')
ALL_UNITS.append(FURLONG)
FOOT_U_S_SURVEY = UnitDescriptor('foot (U.S. survey)', 'M51', '''ft (US survey) ''')
ALL_UNITS.append(FOOT_U_S_SURVEY)
MILE_BASED_ON_U_S_SURVEY_FOOT = UnitDescriptor('mile (based on U.S. survey foot)', 'M52', '''mi (US survey) ''')
ALL_UNITS.append(MILE_BASED_ON_U_S_SURVEY_FOOT)
METRE_PER_PASCAL = UnitDescriptor('metre per pascal', 'M53', '''m/Pa''')
ALL_UNITS.append(METRE_PER_PASCAL)
METRE_PER_RADIANT = UnitDescriptor('metre per radiant', 'M55', '''m/rad''')
ALL_UNITS.append(METRE_PER_RADIANT)
SHAKE = UnitDescriptor('shake', 'M56', '''shake''')
ALL_UNITS.append(SHAKE)
MILE_PER_MINUTE = UnitDescriptor('mile per minute', 'M57', '''mi/min''')
ALL_UNITS.append(MILE_PER_MINUTE)
MILE_PER_SECOND = UnitDescriptor('mile per second', 'M58', '''mi/s''')
ALL_UNITS.append(MILE_PER_SECOND)
METRE_PER_SECOND_PASCAL = UnitDescriptor('metre per second pascal', 'M59', '''(m/s)/Pa''')
ALL_UNITS.append(METRE_PER_SECOND_PASCAL)
METRE_PER_HOUR = UnitDescriptor('metre per hour', 'M60', '''m/h''')
ALL_UNITS.append(METRE_PER_HOUR)
INCH_PER_YEAR = UnitDescriptor('inch per year', 'M61', '''in/y''')
ALL_UNITS.append(INCH_PER_YEAR)
KILOMETRE_PER_SECOND = UnitDescriptor('kilometre per second', 'M62', '''km/s''')
ALL_UNITS.append(KILOMETRE_PER_SECOND)
YARD_PER_SECOND = UnitDescriptor('yard per second', 'M64', '''yd/s''')
ALL_UNITS.append(YARD_PER_SECOND)
YARD_PER_MINUTE = UnitDescriptor('yard per minute', 'M65', '''yd/min''')
ALL_UNITS.append(YARD_PER_MINUTE)
YARD_PER_HOUR = UnitDescriptor('yard per hour', 'M66', '''yd/h''')
ALL_UNITS.append(YARD_PER_HOUR)
ACRE_FOOT_BASED_ON_U_S_SURVEY_FOOT = UnitDescriptor('acre-foot (based on U.S. survey foot)', 'M67', '''acre-ft (US survey)''')
ALL_UNITS.append(ACRE_FOOT_BASED_ON_U_S_SURVEY_FOOT)
CORD_12EIGHT_FT3 = UnitDescriptor('cord (128 ft3)', 'M68', '''cord''')
ALL_UNITS.append(CORD_12EIGHT_FT3)
CUBIC_MILE_UK_STATUTE = UnitDescriptor('cubic mile (UK statute)', 'M69', '''mi³''')
ALL_UNITS.append(CUBIC_MILE_UK_STATUTE)
MICRO_INCH = UnitDescriptor('micro-inch', 'M7', '''µin''')
ALL_UNITS.append(MICRO_INCH)
TON_REGISTER = UnitDescriptor('ton, register', 'M70', '''RT''')
ALL_UNITS.append(TON_REGISTER)
CUBIC_METRE_PER_PASCAL = UnitDescriptor('cubic metre per pascal', 'M71', '''m³/Pa''')
ALL_UNITS.append(CUBIC_METRE_PER_PASCAL)
BEL = UnitDescriptor('bel', 'M72', '''B''')
ALL_UNITS.append(BEL)
KILOGRAM_PER_CUBIC_METRE_PASCAL = UnitDescriptor('kilogram per cubic metre pascal', 'M73', '''(kg/m³)/Pa''')
ALL_UNITS.append(KILOGRAM_PER_CUBIC_METRE_PASCAL)
KILOGRAM_PER_PASCAL = UnitDescriptor('kilogram per pascal', 'M74', '''kg/Pa''')
ALL_UNITS.append(KILOGRAM_PER_PASCAL)
KILOPOUND_FORCE = UnitDescriptor('kilopound-force', 'M75', '''kip''')
ALL_UNITS.append(KILOPOUND_FORCE)
POUNDAL = UnitDescriptor('poundal', 'M76', '''pdl''')
ALL_UNITS.append(POUNDAL)
KILOGRAM_METRE_PER_SECOND_SQUARED = UnitDescriptor('kilogram metre per second squared', 'M77', '''kg·m/s²''')
ALL_UNITS.append(KILOGRAM_METRE_PER_SECOND_SQUARED)
POND = UnitDescriptor('pond', 'M78', '''p''')
ALL_UNITS.append(POND)
SQUARE_FOOT_PER_HOUR = UnitDescriptor('square foot per hour', 'M79', '''ft²/h''')
ALL_UNITS.append(SQUARE_FOOT_PER_HOUR)
STOKES_PER_PASCAL = UnitDescriptor('stokes per pascal', 'M80', '''St/Pa''')
ALL_UNITS.append(STOKES_PER_PASCAL)
SQUARE_CENTIMETRE_PER_SECOND = UnitDescriptor('square centimetre per second', 'M81', '''cm²/s''')
ALL_UNITS.append(SQUARE_CENTIMETRE_PER_SECOND)
SQUARE_METRE_PER_SECOND_PASCAL = UnitDescriptor('square metre per second pascal', 'M82', '''(m²/s)/Pa''')
ALL_UNITS.append(SQUARE_METRE_PER_SECOND_PASCAL)
POUND_PER_YARD = UnitDescriptor('pound per yard', 'M84', '''lb/yd''')
ALL_UNITS.append(POUND_PER_YARD)
TON_ASSAY = UnitDescriptor('ton, assay', 'M85', '''''')
ALL_UNITS.append(TON_ASSAY)
PFUND = UnitDescriptor('pfund', 'M86', '''pfd''')
ALL_UNITS.append(PFUND)
KILOGRAM_PER_SECOND_PASCAL = UnitDescriptor('kilogram per second pascal', 'M87', '''(kg/s)/Pa''')
ALL_UNITS.append(KILOGRAM_PER_SECOND_PASCAL)
TONNE_PER_MONTH = UnitDescriptor('tonne per month', 'M88', '''t/mo''')
ALL_UNITS.append(TONNE_PER_MONTH)
TONNE_PER_YEAR = UnitDescriptor('tonne per year', 'M89', '''t/y''')
ALL_UNITS.append(TONNE_PER_YEAR)
MILLION_BTU_PER_1000_CUBIC_FOOT = UnitDescriptor('million Btu per 1000 cubic foot', 'M9', '''MBTU/kft³''')
ALL_UNITS.append(MILLION_BTU_PER_1000_CUBIC_FOOT)
KILOPOUND_PER_HOUR = UnitDescriptor('kilopound per hour', 'M90', '''klb/h''')
ALL_UNITS.append(KILOPOUND_PER_HOUR)
POUND_PER_POUND = UnitDescriptor('pound per pound', 'M91', '''lb/lb''')
ALL_UNITS.append(POUND_PER_POUND)
POUND_FORCE_FOOT = UnitDescriptor('pound-force foot', 'M92', '''lbf·ft''')
ALL_UNITS.append(POUND_FORCE_FOOT)
NEWTON_METRE_PER_RADIAN = UnitDescriptor('newton metre per radian', 'M93', '''N·m/rad''')
ALL_UNITS.append(NEWTON_METRE_PER_RADIAN)
KILOGRAM_METRE = UnitDescriptor('kilogram metre', 'M94', '''kg·m''')
ALL_UNITS.append(KILOGRAM_METRE)
POUNDAL_FOOT = UnitDescriptor('poundal foot', 'M95', '''pdl·ft''')
ALL_UNITS.append(POUNDAL_FOOT)
POUNDAL_INCH = UnitDescriptor('poundal inch', 'M96', '''pdl·in''')
ALL_UNITS.append(POUNDAL_INCH)
DYNE_METRE = UnitDescriptor('dyne metre', 'M97', '''dyn·m''')
ALL_UNITS.append(DYNE_METRE)
KILOGRAM_CENTIMETRE_PER_SECOND = UnitDescriptor('kilogram centimetre per second', 'M98', '''kg·(cm/s)''')
ALL_UNITS.append(KILOGRAM_CENTIMETRE_PER_SECOND)
GRAM_CENTIMETRE_PER_SECOND = UnitDescriptor('gram centimetre per second', 'M99', '''g·(cm/s)''')
ALL_UNITS.append(GRAM_CENTIMETRE_PER_SECOND)
MACHINE_PER_UNIT = UnitDescriptor('machine per unit', 'MA', '''''')
ALL_UNITS.append(MACHINE_PER_UNIT)
MEGAVOLT_AMPERE_REACTIVE_HOUR = UnitDescriptor('megavolt ampere reactive hour', 'MAH', '''Mvar·h''')
ALL_UNITS.append(MEGAVOLT_AMPERE_REACTIVE_HOUR)
MEGALITRE = UnitDescriptor('megalitre', 'MAL', '''Ml''')
ALL_UNITS.append(MEGALITRE)
MEGAMETRE = UnitDescriptor('megametre', 'MAM', '''Mm''')
ALL_UNITS.append(MEGAMETRE)
MEGAVAR = UnitDescriptor('megavar', 'MAR', '''Mvar''')
ALL_UNITS.append(MEGAVAR)
MEGAWATT = UnitDescriptor('megawatt', 'MAW', '''MW''')
ALL_UNITS.append(MEGAWATT)
THOUSAND_STANDARD_BRICK_EQUIVALENT = UnitDescriptor('thousand standard brick equivalent', 'MBE', '''''')
ALL_UNITS.append(THOUSAND_STANDARD_BRICK_EQUIVALENT)
THOUSAND_BOARD_FOOT = UnitDescriptor('thousand board foot', 'MBF', '''''')
ALL_UNITS.append(THOUSAND_BOARD_FOOT)
MILLIBAR = UnitDescriptor('millibar', 'MBR', '''mbar''')
ALL_UNITS.append(MILLIBAR)
MICROGRAM = UnitDescriptor('microgram', 'MC', '''µg''')
ALL_UNITS.append(MICROGRAM)
MILLICURIE = UnitDescriptor('millicurie', 'MCU', '''mCi''')
ALL_UNITS.append(MILLICURIE)
AIR_DRY_METRIC_TON = UnitDescriptor('air dry metric ton', 'MD', '''''')
ALL_UNITS.append(AIR_DRY_METRIC_TON)
MILLIGRAM_PER_SQUARE_FOOT_PER_SIDE = UnitDescriptor('milligram per square foot per side', 'MF', '''''')
ALL_UNITS.append(MILLIGRAM_PER_SQUARE_FOOT_PER_SIDE)
MILLIGRAM = UnitDescriptor('milligram', 'MGM', '''mg''')
ALL_UNITS.append(MILLIGRAM)
MEGAHERTZ = UnitDescriptor('megahertz', 'MHZ', '''MHz''')
ALL_UNITS.append(MEGAHERTZ)
SQUARE_MILE_STATUTE_MILE = UnitDescriptor('square mile (statute mile)', 'MIK', '''mi²''')
ALL_UNITS.append(SQUARE_MILE_STATUTE_MILE)
THOUSAND = UnitDescriptor('thousand', 'MIL', '''''')
ALL_UNITS.append(THOUSAND)
MINUTE_UNIT_OF_TIME = UnitDescriptor('minute [unit of time]', 'MIN', '''min''')
ALL_UNITS.append(MINUTE_UNIT_OF_TIME)
MILLION = UnitDescriptor('million', 'MIO', '''''')
ALL_UNITS.append(MILLION)
MILLION_INTERNATIONAL_UNIT = UnitDescriptor('million international unit', 'MIU', '''''')
ALL_UNITS.append(MILLION_INTERNATIONAL_UNIT)
MILLIGRAM_PER_SQUARE_INCH = UnitDescriptor('milligram per square inch', 'MK', '''mg/in²''')
ALL_UNITS.append(MILLIGRAM_PER_SQUARE_INCH)
MILLIARD = UnitDescriptor('milliard', 'MLD', '''''')
ALL_UNITS.append(MILLIARD)
MILLILITRE = UnitDescriptor('millilitre', 'MLT', '''ml''')
ALL_UNITS.append(MILLILITRE)
SQUARE_MILLIMETRE = UnitDescriptor('square millimetre', 'MMK', '''mm²''')
ALL_UNITS.append(SQUARE_MILLIMETRE)
CUBIC_MILLIMETRE = UnitDescriptor('cubic millimetre', 'MMQ', '''mm³''')
ALL_UNITS.append(CUBIC_MILLIMETRE)
MILLIMETRE = UnitDescriptor('millimetre', 'MMT', '''mm''')
ALL_UNITS.append(MILLIMETRE)
KILOGRAM_DRY_WEIGHT = UnitDescriptor('kilogram, dry weight', 'MND', '''''')
ALL_UNITS.append(KILOGRAM_DRY_WEIGHT)
MONTH = UnitDescriptor('month', 'MON', '''mo''')
ALL_UNITS.append(MONTH)
MEGAPASCAL = UnitDescriptor('megapascal', 'MPA', '''MPa''')
ALL_UNITS.append(MEGAPASCAL)
THOUSAND_METRE = UnitDescriptor('thousand metre', 'MQ', '''''')
ALL_UNITS.append(THOUSAND_METRE)
CUBIC_METRE_PER_HOUR = UnitDescriptor('cubic metre per hour', 'MQH', '''m³/h''')
ALL_UNITS.append(CUBIC_METRE_PER_HOUR)
CUBIC_METRE_PER_SECOND = UnitDescriptor('cubic metre per second', 'MQS', '''m³/s''')
ALL_UNITS.append(CUBIC_METRE_PER_SECOND)
METRE_PER_SECOND_SQUARED = UnitDescriptor('metre per second squared', 'MSK', '''m/s²''')
ALL_UNITS.append(METRE_PER_SECOND_SQUARED)
MAT = UnitDescriptor('mat', 'MT', '''''')
ALL_UNITS.append(MAT)
SQUARE_METRE = UnitDescriptor('square metre', 'MTK', '''m²''')
ALL_UNITS.append(SQUARE_METRE)
CUBIC_METRE = UnitDescriptor('cubic metre', 'MTQ', '''m³''')
ALL_UNITS.append(CUBIC_METRE)
METRE = UnitDescriptor('metre', 'MTR', '''m''')
ALL_UNITS.append(METRE)
METRE_PER_SECOND = UnitDescriptor('metre per second', 'MTS', '''m/s''')
ALL_UNITS.append(METRE_PER_SECOND)
NUMBER_OF_MULTS = UnitDescriptor('number of mults', 'MV', '''''')
ALL_UNITS.append(NUMBER_OF_MULTS)
MEGAVOLT_AMPERE = UnitDescriptor('megavolt - ampere', 'MVA', '''MV·A''')
ALL_UNITS.append(MEGAVOLT_AMPERE)
MEGAWATT_HOUR_1000_KW_H = UnitDescriptor('megawatt hour (1000 kW.h)', 'MWH', '''MW·h''')
ALL_UNITS.append(MEGAWATT_HOUR_1000_KW_H)
PEN_CALORIE = UnitDescriptor('pen calorie', 'N1', '''''')
ALL_UNITS.append(PEN_CALORIE)
POUND_FOOT_PER_SECOND = UnitDescriptor('pound foot per second', 'N10', '''lb·(ft/s)''')
ALL_UNITS.append(POUND_FOOT_PER_SECOND)
POUND_INCH_PER_SECOND = UnitDescriptor('pound inch per second', 'N11', '''lb·(in/s)''')
ALL_UNITS.append(POUND_INCH_PER_SECOND)
PFERDESTAERKE = UnitDescriptor('Pferdestaerke', 'N12', '''PS''')
ALL_UNITS.append(PFERDESTAERKE)
CENTIMETRE_OF_MERCURY_0_DEG_C = UnitDescriptor('centimetre of mercury (0 ºC)', 'N13', '''cmHg (0 ºC)''')
ALL_UNITS.append(CENTIMETRE_OF_MERCURY_0_DEG_C)
CENTIMETRE_OF_WATER_4_DEG_C = UnitDescriptor('centimetre of water (4 ºC)', 'N14', '''cmH₂O (4 °C)''')
ALL_UNITS.append(CENTIMETRE_OF_WATER_4_DEG_C)
FOOT_OF_WATER_39_2_DEG_F = UnitDescriptor('foot of water (39.2 ºF)', 'N15', '''ftH₂O (39,2 ºF)''')
ALL_UNITS.append(FOOT_OF_WATER_39_2_DEG_F)
INCH_OF_MERCURY_32_DEG_F = UnitDescriptor('inch of mercury (32 ºF)', 'N16', '''inHG (32 ºF)''')
ALL_UNITS.append(INCH_OF_MERCURY_32_DEG_F)
INCH_OF_MERCURY_60_DEG_F = UnitDescriptor('inch of mercury (60 ºF)', 'N17', '''inHg (60 ºF)''')
ALL_UNITS.append(INCH_OF_MERCURY_60_DEG_F)
INCH_OF_WATER_39_2_DEG_F = UnitDescriptor('inch of water (39.2 ºF)', 'N18', '''inH₂O (39,2 ºF)''')
ALL_UNITS.append(INCH_OF_WATER_39_2_DEG_F)
INCH_OF_WATER_60_DEG_F = UnitDescriptor('inch of water (60 ºF)', 'N19', '''inH₂O (60 ºF)''')
ALL_UNITS.append(INCH_OF_WATER_60_DEG_F)
NUMBER_OF_LINES = UnitDescriptor('number of lines', 'N2', '''''')
ALL_UNITS.append(NUMBER_OF_LINES)
KIP_PER_SQUARE_INCH = UnitDescriptor('kip per square inch', 'N20', '''ksi''')
ALL_UNITS.append(KIP_PER_SQUARE_INCH)
POUNDAL_PER_SQUARE_FOOT = UnitDescriptor('poundal per square foot', 'N21', '''pdl/ft²''')
ALL_UNITS.append(POUNDAL_PER_SQUARE_FOOT)
OUNCE_AVOIRDUPOIS_PER_SQUARE_INCH = UnitDescriptor('ounce (avoirdupois) per square inch', 'N22', '''oz/in²''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS_PER_SQUARE_INCH)
CONVENTIONAL_METRE_OF_WATER = UnitDescriptor('conventional metre of water', 'N23', '''mH₂O''')
ALL_UNITS.append(CONVENTIONAL_METRE_OF_WATER)
GRAM_PER_SQUARE_MILLIMETRE = UnitDescriptor('gram per square millimetre', 'N24', '''g/mm²''')
ALL_UNITS.append(GRAM_PER_SQUARE_MILLIMETRE)
POUND_PER_SQUARE_YARD = UnitDescriptor('pound per square yard', 'N25', '''lb/yd²''')
ALL_UNITS.append(POUND_PER_SQUARE_YARD)
POUNDAL_PER_SQUARE_INCH = UnitDescriptor('poundal per square inch', 'N26', '''pdl/in²''')
ALL_UNITS.append(POUNDAL_PER_SQUARE_INCH)
FOOT_TO_THE_FOURTH_POWER = UnitDescriptor('foot to the fourth power', 'N27', '''ft⁴''')
ALL_UNITS.append(FOOT_TO_THE_FOURTH_POWER)
CUBIC_DECIMETRE_PER_KILOGRAM = UnitDescriptor('cubic decimetre per kilogram', 'N28', '''dm³/kg''')
ALL_UNITS.append(CUBIC_DECIMETRE_PER_KILOGRAM)
CUBIC_FOOT_PER_POUND = UnitDescriptor('cubic foot per pound', 'N29', '''ft³/lb''')
ALL_UNITS.append(CUBIC_FOOT_PER_POUND)
PRINT_POINT = UnitDescriptor('print point', 'N3', '''''')
ALL_UNITS.append(PRINT_POINT)
CUBIC_INCH_PER_POUND = UnitDescriptor('cubic inch per pound', 'N30', '''in³/lb''')
ALL_UNITS.append(CUBIC_INCH_PER_POUND)
KILONEWTON_PER_METRE = UnitDescriptor('kilonewton per metre', 'N31', '''kN/m''')
ALL_UNITS.append(KILONEWTON_PER_METRE)
POUNDAL_PER_INCH = UnitDescriptor('poundal per inch', 'N32', '''pdl/in''')
ALL_UNITS.append(POUNDAL_PER_INCH)
POUND_FORCE_PER_YARD = UnitDescriptor('pound-force per yard', 'N33', '''lbf/yd''')
ALL_UNITS.append(POUND_FORCE_PER_YARD)
POUNDAL_SECOND_PER_SQUARE_FOOT = UnitDescriptor('poundal second per square foot', 'N34', '''(pdl/ft²)·s''')
ALL_UNITS.append(POUNDAL_SECOND_PER_SQUARE_FOOT)
POISE_PER_PASCAL = UnitDescriptor('poise per pascal', 'N35', '''P/Pa''')
ALL_UNITS.append(POISE_PER_PASCAL)
NEWTON_SECOND_PER_SQUARE_METRE = UnitDescriptor('newton second per square metre', 'N36', '''(N/m²)·s''')
ALL_UNITS.append(NEWTON_SECOND_PER_SQUARE_METRE)
KILOGRAM_PER_METRE_SECOND = UnitDescriptor('kilogram per metre second', 'N37', '''kg/(m·s)''')
ALL_UNITS.append(KILOGRAM_PER_METRE_SECOND)
KILOGRAM_PER_METRE_MINUTE = UnitDescriptor('kilogram per metre minute', 'N38', '''kg/(m·min)''')
ALL_UNITS.append(KILOGRAM_PER_METRE_MINUTE)
KILOGRAM_PER_METRE_DAY = UnitDescriptor('kilogram per metre day', 'N39', '''kg/(m·d)''')
ALL_UNITS.append(KILOGRAM_PER_METRE_DAY)
KILOGRAM_PER_METRE_HOUR = UnitDescriptor('kilogram per metre hour', 'N40', '''kg/(m·h)''')
ALL_UNITS.append(KILOGRAM_PER_METRE_HOUR)
GRAM_PER_CENTIMETRE_SECOND = UnitDescriptor('gram per centimetre second', 'N41', '''g/(cm·s)''')
ALL_UNITS.append(GRAM_PER_CENTIMETRE_SECOND)
POUNDAL_SECOND_PER_SQUARE_INCH = UnitDescriptor('poundal second per square inch', 'N42', '''(pdl/in²)·s''')
ALL_UNITS.append(POUNDAL_SECOND_PER_SQUARE_INCH)
POUND_PER_FOOT_MINUTE = UnitDescriptor('pound per foot minute', 'N43', '''lb/(ft·min)''')
ALL_UNITS.append(POUND_PER_FOOT_MINUTE)
POUND_PER_FOOT_DAY = UnitDescriptor('pound per foot day', 'N44', '''lb/(ft·d)''')
ALL_UNITS.append(POUND_PER_FOOT_DAY)
CUBIC_METRE_PER_SECOND_PASCAL = UnitDescriptor('cubic metre per second pascal', 'N45', '''(m³/s)/Pa''')
ALL_UNITS.append(CUBIC_METRE_PER_SECOND_PASCAL)
FOOT_POUNDAL = UnitDescriptor('foot poundal', 'N46', '''ft·pdl''')
ALL_UNITS.append(FOOT_POUNDAL)
INCH_POUNDAL = UnitDescriptor('inch poundal', 'N47', '''in·pdl''')
ALL_UNITS.append(INCH_POUNDAL)
WATT_PER_SQUARE_CENTIMETRE = UnitDescriptor('watt per square centimetre', 'N48', '''W/cm²''')
ALL_UNITS.append(WATT_PER_SQUARE_CENTIMETRE)
WATT_PER_SQUARE_INCH = UnitDescriptor('watt per square inch', 'N49', '''W/in²''')
ALL_UNITS.append(WATT_PER_SQUARE_INCH)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_HOUR = UnitDescriptor('British thermal unit (international table) per square foot hour', 'N50', '''BtuIT/(ft²·h)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_HOUR)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_HOUR = UnitDescriptor('British thermal unit (thermochemical) per square foot hour', 'N51', '''Btuth/(ft²·h)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_HOUR)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_MINUTE = UnitDescriptor('British thermal unit (thermochemical) per square foot minute', 'N52', '''Btuth/(ft²·min) ''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_MINUTE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_SECOND = UnitDescriptor('British thermal unit (international table) per square foot second', 'N53', '''BtuIT/(ft²·s)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_SECOND)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_SECOND = UnitDescriptor('British thermal unit (thermochemical) per square foot second', 'N54', '''Btuth/(ft²·s)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_SECOND)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_INCH_SECOND = UnitDescriptor('British thermal unit (international table) per square inch second', 'N55', '''BtuIT/(in²·s)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_INCH_SECOND)
CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_MINUTE = UnitDescriptor('calorie (thermochemical) per square centimetre minute', 'N56', '''calth/(cm²·min)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_MINUTE)
CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_SECOND = UnitDescriptor('calorie (thermochemical) per square centimetre second', 'N57', '''calth/(cm²·s)''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_SECOND)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_CUBIC_FOOT = UnitDescriptor('British thermal unit (international table) per cubic foot', 'N58', '''BtuIT/ft³''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_CUBIC_FOOT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_CUBIC_FOOT = UnitDescriptor('British thermal unit (thermochemical) per cubic foot', 'N59', '''Btuth/ft³''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_CUBIC_FOOT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) per degree Fahrenheit', 'N60', '''BtuIT/ºF''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) per degree Fahrenheit', 'N61', '''Btuth/ºF''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_RANKINE = UnitDescriptor('British thermal unit (international table) per degree Rankine', 'N62', '''BtuIT/ºR''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_RANKINE)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_RANKINE = UnitDescriptor('British thermal unit (thermochemical) per degree Rankine', 'N63', '''Btuth/ºR''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_RANKINE)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_RANKINE = UnitDescriptor('British thermal unit (thermochemical) per pound degree Rankine', 'N64', '''(Btuth/°R)/lb''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_RANKINE)
KILOCALORIE_INTERNATIONAL_TABLE_PER_GRAM_KELVIN = UnitDescriptor('kilocalorie (international table) per gram kelvin', 'N65', '''(kcalIT/K)/g''')
ALL_UNITS.append(KILOCALORIE_INTERNATIONAL_TABLE_PER_GRAM_KELVIN)
BRITISH_THERMAL_UNIT_39_DEG_F = UnitDescriptor('British thermal unit (39 ºF)', 'N66', '''Btu (39 ºF) ''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_39_DEG_F)
BRITISH_THERMAL_UNIT_59_DEG_F = UnitDescriptor('British thermal unit (59 ºF)', 'N67', '''Btu (59 ºF)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_59_DEG_F)
BRITISH_THERMAL_UNIT_60_DEG_F = UnitDescriptor('British thermal unit (60 ºF)', 'N68', '''Btu (60 ºF) ''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_60_DEG_F)
CALORIE_20_DEG_C = UnitDescriptor('calorie (20 ºC)', 'N69', '''cal₂₀''')
ALL_UNITS.append(CALORIE_20_DEG_C)
QUAD_10FIFTEEN_BTUIT = UnitDescriptor('quad (1015 BtuIT)', 'N70', '''quad''')
ALL_UNITS.append(QUAD_10FIFTEEN_BTUIT)
THERM_EC = UnitDescriptor('therm (EC)', 'N71', '''thm (EC)''')
ALL_UNITS.append(THERM_EC)
THERM_U_S_ = UnitDescriptor('therm (U.S.)', 'N72', '''thm (US)''')
ALL_UNITS.append(THERM_U_S_)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND = UnitDescriptor('British thermal unit (thermochemical) per pound', 'N73', '''Btuth/lb''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) per hour square foot degree Fahrenheit', 'N74', '''BtuIT/(h·ft²·ºF)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) per hour square foot degree Fahrenheit', 'N75', '''Btuth/(h·ft²·ºF)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (international table) per second square foot degree Fahrenheit', 'N76', '''BtuIT/(s·ft²·ºF)''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = UnitDescriptor('British thermal unit (thermochemical) per second square foot degree Fahrenheit', 'N77', '''Btuth/(s·ft²·ºF) ''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT)
KILOWATT_PER_SQUARE_METRE_KELVIN = UnitDescriptor('kilowatt per square metre kelvin', 'N78', '''kW/(m²·K)''')
ALL_UNITS.append(KILOWATT_PER_SQUARE_METRE_KELVIN)
KELVIN_PER_PASCAL = UnitDescriptor('kelvin per pascal', 'N79', '''K/Pa''')
ALL_UNITS.append(KELVIN_PER_PASCAL)
WATT_PER_METRE_DEGREE_CELSIUS = UnitDescriptor('watt per metre degree Celsius', 'N80', '''W/(m·°C)''')
ALL_UNITS.append(WATT_PER_METRE_DEGREE_CELSIUS)
KILOWATT_PER_METRE_KELVIN = UnitDescriptor('kilowatt per metre kelvin', 'N81', '''kW/(m·K)''')
ALL_UNITS.append(KILOWATT_PER_METRE_KELVIN)
KILOWATT_PER_METRE_DEGREE_CELSIUS = UnitDescriptor('kilowatt per metre degree Celsius', 'N82', '''kW/(m·°C)''')
ALL_UNITS.append(KILOWATT_PER_METRE_DEGREE_CELSIUS)
METRE_PER_DEGREE_CELCIUS_METRE = UnitDescriptor('metre per degree Celcius metre', 'N83', '''m/(°C·m)''')
ALL_UNITS.append(METRE_PER_DEGREE_CELCIUS_METRE)
DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = UnitDescriptor('degree Fahrenheit hour per British thermal unit (international table)', 'N84', '''ºF/(BtuIT/h)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE)
DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = UnitDescriptor('degree Fahrenheit hour per British thermal unit (thermochemical)', 'N85', '''ºF/(Btuth/h)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL)
DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = UnitDescriptor('degree Fahrenheit second per British thermal unit (international table)', 'N86', '''ºF/(BtuIT/s)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE)
DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = UnitDescriptor('degree Fahrenheit second per British thermal unit (thermochemical)', 'N87', '''ºF/(Btuth/s)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL)
DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH = UnitDescriptor('degree Fahrenheit hour square foot per British thermal unit (international table) inch', 'N88', '''ºF·h·ft²/(BtuIT·in)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH)
DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH = UnitDescriptor('degree Fahrenheit hour square foot per British thermal unit (thermochemical) inch', 'N89', '''ºF·h·ft²/(Btuth·in)''')
ALL_UNITS.append(DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH)
KILOFARAD = UnitDescriptor('kilofarad', 'N90', '''kF''')
ALL_UNITS.append(KILOFARAD)
RECIPROCAL_JOULE = UnitDescriptor('reciprocal joule', 'N91', '''1/J''')
ALL_UNITS.append(RECIPROCAL_JOULE)
PICOSIEMENS = UnitDescriptor('picosiemens', 'N92', '''pS''')
ALL_UNITS.append(PICOSIEMENS)
AMPERE_PER_PASCAL = UnitDescriptor('ampere per pascal', 'N93', '''A/Pa''')
ALL_UNITS.append(AMPERE_PER_PASCAL)
FRANKLIN = UnitDescriptor('franklin', 'N94', '''Fr''')
ALL_UNITS.append(FRANKLIN)
AMPERE_MINUTE = UnitDescriptor('ampere minute', 'N95', '''A·min''')
ALL_UNITS.append(AMPERE_MINUTE)
BIOT = UnitDescriptor('biot', 'N96', '''Bi''')
ALL_UNITS.append(BIOT)
GILBERT = UnitDescriptor('gilbert', 'N97', '''Gi''')
ALL_UNITS.append(GILBERT)
VOLT_PER_PASCAL = UnitDescriptor('volt per pascal', 'N98', '''V/Pa''')
ALL_UNITS.append(VOLT_PER_PASCAL)
PICOVOLT = UnitDescriptor('picovolt', 'N99', '''pV''')
ALL_UNITS.append(PICOVOLT)
MILLIGRAM_PER_KILOGRAM = UnitDescriptor('milligram per kilogram', 'NA', '''mg/kg''')
ALL_UNITS.append(MILLIGRAM_PER_KILOGRAM)
NUMBER_OF_ARTICLES = UnitDescriptor('number of articles', 'NAR', '''''')
ALL_UNITS.append(NUMBER_OF_ARTICLES)
BARGE = UnitDescriptor('barge', 'NB', '''''')
ALL_UNITS.append(BARGE)
NUMBER_OF_BOBBINS = UnitDescriptor('number of bobbins', 'NBB', '''''')
ALL_UNITS.append(NUMBER_OF_BOBBINS)
CAR = UnitDescriptor('car', 'NC', '''''')
ALL_UNITS.append(CAR)
NUMBER_OF_CELLS = UnitDescriptor('number of cells', 'NCL', '''''')
ALL_UNITS.append(NUMBER_OF_CELLS)
NET_BARREL = UnitDescriptor('net barrel', 'ND', '''''')
ALL_UNITS.append(NET_BARREL)
NET_LITRE = UnitDescriptor('net litre', 'NE', '''''')
ALL_UNITS.append(NET_LITRE)
NEWTON = UnitDescriptor('newton', 'NEW', '''N''')
ALL_UNITS.append(NEWTON)
MESSAGE = UnitDescriptor('message', 'NF', '''''')
ALL_UNITS.append(MESSAGE)
NET_GALLON_US = UnitDescriptor('net gallon (us)', 'NG', '''''')
ALL_UNITS.append(NET_GALLON_US)
MESSAGE_HOUR = UnitDescriptor('message hour', 'NH', '''''')
ALL_UNITS.append(MESSAGE_HOUR)
NET_IMPERIAL_GALLON = UnitDescriptor('net imperial gallon', 'NI', '''''')
ALL_UNITS.append(NET_IMPERIAL_GALLON)
NIL = UnitDescriptor('nil', 'NIL', '''()''')
ALL_UNITS.append(NIL)
NUMBER_OF_INTERNATIONAL_UNITS = UnitDescriptor('number of international units', 'NIU', '''''')
ALL_UNITS.append(NUMBER_OF_INTERNATIONAL_UNITS)
NUMBER_OF_SCREENS = UnitDescriptor('number of screens', 'NJ', '''''')
ALL_UNITS.append(NUMBER_OF_SCREENS)
LOAD = UnitDescriptor('load', 'NL', '''''')
ALL_UNITS.append(LOAD)
NORMALISED_CUBIC_METRE = UnitDescriptor('Normalised cubic metre', 'NM3', '''''')
ALL_UNITS.append(NORMALISED_CUBIC_METRE)
NAUTICAL_MILE = UnitDescriptor('nautical mile', 'NMI', '''n mile''')
ALL_UNITS.append(NAUTICAL_MILE)
NUMBER_OF_PACKS = UnitDescriptor('number of packs', 'NMP', '''''')
ALL_UNITS.append(NUMBER_OF_PACKS)
TRAIN = UnitDescriptor('train', 'NN', '''''')
ALL_UNITS.append(TRAIN)
NUMBER_OF_PARCELS = UnitDescriptor('number of parcels', 'NPL', '''''')
ALL_UNITS.append(NUMBER_OF_PARCELS)
NUMBER_OF_PAIRS = UnitDescriptor('number of pairs', 'NPR', '''''')
ALL_UNITS.append(NUMBER_OF_PAIRS)
NUMBER_OF_PARTS = UnitDescriptor('number of parts', 'NPT', '''''')
ALL_UNITS.append(NUMBER_OF_PARTS)
MHO = UnitDescriptor('mho', 'NQ', '''''')
ALL_UNITS.append(MHO)
MICROMHO = UnitDescriptor('micromho', 'NR', '''''')
ALL_UNITS.append(MICROMHO)
NUMBER_OF_ROLLS = UnitDescriptor('number of rolls', 'NRL', '''''')
ALL_UNITS.append(NUMBER_OF_ROLLS)
NET_TON = UnitDescriptor('net ton', 'NT', '''''')
ALL_UNITS.append(NET_TON)
NET_REGISTER_TON = UnitDescriptor('net register ton', 'NTT', '''''')
ALL_UNITS.append(NET_REGISTER_TON)
NEWTON_METRE = UnitDescriptor('newton metre', 'NU', '''N·m''')
ALL_UNITS.append(NEWTON_METRE)
VEHICLE = UnitDescriptor('vehicle', 'NV', '''''')
ALL_UNITS.append(VEHICLE)
PART_PER_THOUSAND = UnitDescriptor('part per thousand', 'NX', '''‰''')
ALL_UNITS.append(PART_PER_THOUSAND)
POUND_PER_AIR_DRY_METRIC_TON = UnitDescriptor('pound per air dry metric ton', 'NY', '''''')
ALL_UNITS.append(POUND_PER_AIR_DRY_METRIC_TON)
PANEL = UnitDescriptor('panel', 'OA', '''''')
ALL_UNITS.append(PANEL)
OZONE_DEPLETION_EQUIVALENT = UnitDescriptor('ozone depletion equivalent', 'ODE', '''''')
ALL_UNITS.append(OZONE_DEPLETION_EQUIVALENT)
ODS_GRAMS = UnitDescriptor('ODS Grams', 'ODG', '''''')
ALL_UNITS.append(ODS_GRAMS)
ODS_KILOGRAMS = UnitDescriptor('ODS Kilograms', 'ODK', '''''')
ALL_UNITS.append(ODS_KILOGRAMS)
ODS_MILLIGRAMS = UnitDescriptor('ODS Milligrams', 'ODM', '''''')
ALL_UNITS.append(ODS_MILLIGRAMS)
OHM = UnitDescriptor('ohm', 'OHM', '''Ω''')
ALL_UNITS.append(OHM)
OUNCE_PER_SQUARE_YARD = UnitDescriptor('ounce per square yard', 'ON', '''oz/yd²''')
ALL_UNITS.append(OUNCE_PER_SQUARE_YARD)
OUNCE_AVOIRDUPOIS = UnitDescriptor('ounce (avoirdupois)', 'ONZ', '''oz''')
ALL_UNITS.append(OUNCE_AVOIRDUPOIS)
TWO_PACK = UnitDescriptor('two pack', 'OP', '''''')
ALL_UNITS.append(TWO_PACK)
OSCILLATIONS_PER_MINUTE = UnitDescriptor('oscillations per minute', 'OPM', '''o/min''')
ALL_UNITS.append(OSCILLATIONS_PER_MINUTE)
OVERTIME_HOUR = UnitDescriptor('overtime hour', 'OT', '''''')
ALL_UNITS.append(OVERTIME_HOUR)
OUNCE_AV = UnitDescriptor('ounce av', 'OZ', '''''')
ALL_UNITS.append(OUNCE_AV)
FLUID_OUNCE_US = UnitDescriptor('fluid ounce (US)', 'OZA', '''fl oz (US)''')
ALL_UNITS.append(FLUID_OUNCE_US)
FLUID_OUNCE_UK = UnitDescriptor('fluid ounce (UK)', 'OZI', '''fl oz (UK)''')
ALL_UNITS.append(FLUID_OUNCE_UK)
PAGE_ELECTRONIC = UnitDescriptor('page - electronic', 'P0', '''''')
ALL_UNITS.append(PAGE_ELECTRONIC)
PERCENT = UnitDescriptor('percent', 'P1', '''%''')
ALL_UNITS.append(PERCENT)
PERCENT = UnitDescriptor('percent', 'P1', '''pct''')
ALL_UNITS.append(PERCENT)
COULOMB_PER_METRE = UnitDescriptor('coulomb per metre', 'P10', '''C/m''')
ALL_UNITS.append(COULOMB_PER_METRE)
KILOWEBER = UnitDescriptor('kiloweber', 'P11', '''kWb''')
ALL_UNITS.append(KILOWEBER)
GAMMA = UnitDescriptor('gamma', 'P12', '''γ''')
ALL_UNITS.append(GAMMA)
KILOTESLA = UnitDescriptor('kilotesla', 'P13', '''kT''')
ALL_UNITS.append(KILOTESLA)
JOULE_PER_SECOND = UnitDescriptor('joule per second', 'P14', '''J/s''')
ALL_UNITS.append(JOULE_PER_SECOND)
JOULE_PER_MINUTE = UnitDescriptor('joule per minute', 'P15', '''J/min''')
ALL_UNITS.append(JOULE_PER_MINUTE)
JOULE_PER_HOUR = UnitDescriptor('joule per hour', 'P16', '''J/h''')
ALL_UNITS.append(JOULE_PER_HOUR)
JOULE_PER_DAY = UnitDescriptor('joule per day', 'P17', '''J/d''')
ALL_UNITS.append(JOULE_PER_DAY)
KILOJOULE_PER_SECOND = UnitDescriptor('kilojoule per second', 'P18', '''kJ/s''')
ALL_UNITS.append(KILOJOULE_PER_SECOND)
KILOJOULE_PER_MINUTE = UnitDescriptor('kilojoule per minute', 'P19', '''kJ/min''')
ALL_UNITS.append(KILOJOULE_PER_MINUTE)
POUND_PER_FOOT = UnitDescriptor('pound per foot', 'P2', '''lb/ft''')
ALL_UNITS.append(POUND_PER_FOOT)
KILOJOULE_PER_HOUR = UnitDescriptor('kilojoule per hour', 'P20', '''kJ/h''')
ALL_UNITS.append(KILOJOULE_PER_HOUR)
KILOJOULE_PER_DAY = UnitDescriptor('kilojoule per day', 'P21', '''kJ/d''')
ALL_UNITS.append(KILOJOULE_PER_DAY)
NANOOHM = UnitDescriptor('nanoohm', 'P22', '''nΩ''')
ALL_UNITS.append(NANOOHM)
OHM_CIRCULAR_MIL_PER_FOOT = UnitDescriptor('ohm circular-mil per foot', 'P23', '''Ω·cmil/ft ''')
ALL_UNITS.append(OHM_CIRCULAR_MIL_PER_FOOT)
KILOHENRY = UnitDescriptor('kilohenry', 'P24', '''kH''')
ALL_UNITS.append(KILOHENRY)
LUMEN_PER_SQUARE_FOOT = UnitDescriptor('lumen per square foot', 'P25', '''lm/ft²''')
ALL_UNITS.append(LUMEN_PER_SQUARE_FOOT)
PHOT = UnitDescriptor('phot', 'P26', '''ph''')
ALL_UNITS.append(PHOT)
FOOTCANDLE = UnitDescriptor('footcandle', 'P27', '''ftc''')
ALL_UNITS.append(FOOTCANDLE)
CANDELA_PER_SQUARE_INCH = UnitDescriptor('candela per square inch', 'P28', '''cd/in²''')
ALL_UNITS.append(CANDELA_PER_SQUARE_INCH)
FOOTLAMBERT = UnitDescriptor('footlambert', 'P29', '''ftL''')
ALL_UNITS.append(FOOTLAMBERT)
THREE_PACK = UnitDescriptor('three pack', 'P3', '''''')
ALL_UNITS.append(THREE_PACK)
LAMBERT = UnitDescriptor('lambert', 'P30', '''Lb''')
ALL_UNITS.append(LAMBERT)
STILB = UnitDescriptor('stilb', 'P31', '''sb''')
ALL_UNITS.append(STILB)
CANDELA_PER_SQUARE_FOOT = UnitDescriptor('candela per square foot', 'P32', '''cd/ft²''')
ALL_UNITS.append(CANDELA_PER_SQUARE_FOOT)
KILOCANDELA = UnitDescriptor('kilocandela', 'P33', '''kcd''')
ALL_UNITS.append(KILOCANDELA)
MILLICANDELA = UnitDescriptor('millicandela', 'P34', '''mcd''')
ALL_UNITS.append(MILLICANDELA)
HEFNER_KERZE = UnitDescriptor('Hefner-Kerze', 'P35', '''HK''')
ALL_UNITS.append(HEFNER_KERZE)
INTERNATIONAL_CANDLE = UnitDescriptor('international candle', 'P36', '''IK''')
ALL_UNITS.append(INTERNATIONAL_CANDLE)
BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT = UnitDescriptor('British thermal unit (international table) per square foot', 'P37', '''BtuIT/ft²''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT)
BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT = UnitDescriptor('British thermal unit (thermochemical) per square foot', 'P38', '''Btuth/ft²''')
ALL_UNITS.append(BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT)
CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE = UnitDescriptor('calorie (thermochemical) per square centimetre', 'P39', '''calth/cm²''')
ALL_UNITS.append(CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE)
FOUR_PACK = UnitDescriptor('four pack', 'P4', '''''')
ALL_UNITS.append(FOUR_PACK)
LANGLEY = UnitDescriptor('langley', 'P40', '''Ly''')
ALL_UNITS.append(LANGLEY)
DECADE_LOGARITHMIC = UnitDescriptor('decade (logarithmic)', 'P41', '''dec''')
ALL_UNITS.append(DECADE_LOGARITHMIC)
PASCAL_SQUARED_SECOND = UnitDescriptor('pascal squared second', 'P42', '''Pa²·s''')
ALL_UNITS.append(PASCAL_SQUARED_SECOND)
BEL_PER_METRE = UnitDescriptor('bel per metre', 'P43', '''B/m''')
ALL_UNITS.append(BEL_PER_METRE)
POUND_MOLE = UnitDescriptor('pound mole', 'P44', '''lbmol''')
ALL_UNITS.append(POUND_MOLE)
POUND_MOLE_PER_SECOND = UnitDescriptor('pound mole per second', 'P45', '''lbmol/s''')
ALL_UNITS.append(POUND_MOLE_PER_SECOND)
POUND_MOLE_PER_MINUTE = UnitDescriptor('pound mole per minute', 'P46', '''lbmol/h''')
ALL_UNITS.append(POUND_MOLE_PER_MINUTE)
KILOMOLE_PER_KILOGRAM = UnitDescriptor('kilomole per kilogram', 'P47', '''kmol/kg''')
ALL_UNITS.append(KILOMOLE_PER_KILOGRAM)
POUND_MOLE_PER_POUND = UnitDescriptor('pound mole per pound', 'P48', '''lbmol/lb''')
ALL_UNITS.append(POUND_MOLE_PER_POUND)
NEWTON_SQUARE_METRE_PER_AMPERE = UnitDescriptor('newton square metre per ampere', 'P49', '''N·m²/A''')
ALL_UNITS.append(NEWTON_SQUARE_METRE_PER_AMPERE)
FIVE_PACK = UnitDescriptor('five pack', 'P5', '''''')
ALL_UNITS.append(FIVE_PACK)
WEBER_METRE = UnitDescriptor('weber metre', 'P50', '''Wb·m''')
ALL_UNITS.append(WEBER_METRE)
MOL_PER_KILOGRAM_PASCAL = UnitDescriptor('mol per kilogram pascal', 'P51', '''(mol/kg)/Pa''')
ALL_UNITS.append(MOL_PER_KILOGRAM_PASCAL)
MOL_PER_CUBIC_METRE_PASCAL = UnitDescriptor('mol per cubic metre pascal', 'P52', '''(mol/m³)/Pa''')
ALL_UNITS.append(MOL_PER_CUBIC_METRE_PASCAL)
UNIT_POLE = UnitDescriptor('unit pole', 'P53', '''unit pole ''')
ALL_UNITS.append(UNIT_POLE)
MILLIGRAY_PER_SECOND = UnitDescriptor('milligray per second', 'P54', '''mGy/s''')
ALL_UNITS.append(MILLIGRAY_PER_SECOND)
MICROGRAY_PER_SECOND = UnitDescriptor('microgray per second', 'P55', '''µGy/s''')
ALL_UNITS.append(MICROGRAY_PER_SECOND)
NANOGRAY_PER_SECOND = UnitDescriptor('nanogray per second', 'P56', '''nGy/s''')
ALL_UNITS.append(NANOGRAY_PER_SECOND)
GRAY_PER_MINUTE = UnitDescriptor('gray per minute', 'P57', '''Gy/min''')
ALL_UNITS.append(GRAY_PER_MINUTE)
MILLIGRAY_PER_MINUTE = UnitDescriptor('milligray per minute', 'P58', '''mGy/min''')
ALL_UNITS.append(MILLIGRAY_PER_MINUTE)
MICROGRAY_PER_MINUTE = UnitDescriptor('microgray per minute', 'P59', '''µGy/min''')
ALL_UNITS.append(MICROGRAY_PER_MINUTE)
SIX_PACK = UnitDescriptor('six pack', 'P6', '''''')
ALL_UNITS.append(SIX_PACK)
NANOGRAY_PER_MINUTE = UnitDescriptor('nanogray per minute', 'P60', '''nGy/min''')
ALL_UNITS.append(NANOGRAY_PER_MINUTE)
GRAY_PER_HOUR = UnitDescriptor('gray per hour', 'P61', '''Gy/h''')
ALL_UNITS.append(GRAY_PER_HOUR)
MILLIGRAY_PER_HOUR = UnitDescriptor('milligray per hour', 'P62', '''mGy/h''')
ALL_UNITS.append(MILLIGRAY_PER_HOUR)
MICROGRAY_PER_HOUR = UnitDescriptor('microgray per hour', 'P63', '''µGy/h''')
ALL_UNITS.append(MICROGRAY_PER_HOUR)
NANOGRAY_PER_HOUR = UnitDescriptor('nanogray per hour', 'P64', '''nGy/h''')
ALL_UNITS.append(NANOGRAY_PER_HOUR)
SIEVERT_PER_SECOND = UnitDescriptor('sievert per second', 'P65', '''Sv/s''')
ALL_UNITS.append(SIEVERT_PER_SECOND)
MILLISIEVERT_PER_SECOND = UnitDescriptor('millisievert per second', 'P66', '''mSv/s''')
ALL_UNITS.append(MILLISIEVERT_PER_SECOND)
MICROSIEVERT_PER_SECOND = UnitDescriptor('microsievert per second', 'P67', '''µSv/s''')
ALL_UNITS.append(MICROSIEVERT_PER_SECOND)
NANOSIEVERT_PER_SECOND = UnitDescriptor('nanosievert per second', 'P68', '''nSv/s''')
ALL_UNITS.append(NANOSIEVERT_PER_SECOND)
REM_PER_SECOND = UnitDescriptor('rem per second', 'P69', '''rem/s''')
ALL_UNITS.append(REM_PER_SECOND)
SEVEN_PACK = UnitDescriptor('seven pack', 'P7', '''''')
ALL_UNITS.append(SEVEN_PACK)
SIEVERT_PER_HOUR = UnitDescriptor('sievert per hour', 'P70', '''Sv/h''')
ALL_UNITS.append(SIEVERT_PER_HOUR)
MILLISIEVERT_PER_HOUR = UnitDescriptor('millisievert per hour', 'P71', '''mSv/h''')
ALL_UNITS.append(MILLISIEVERT_PER_HOUR)
MICROSIEVERT_PER_HOUR = UnitDescriptor('microsievert per hour', 'P72', '''µSv/h''')
ALL_UNITS.append(MICROSIEVERT_PER_HOUR)
NANOSIEVERT_PER_HOUR = UnitDescriptor('nanosievert per hour', 'P73', '''nSv/h''')
ALL_UNITS.append(NANOSIEVERT_PER_HOUR)
SIEVERT_PER_MINUTE = UnitDescriptor('sievert per minute', 'P74', '''Sv/min''')
ALL_UNITS.append(SIEVERT_PER_MINUTE)
MILLISIEVERT_PER_MINUTE = UnitDescriptor('millisievert per minute', 'P75', '''mSv/min''')
ALL_UNITS.append(MILLISIEVERT_PER_MINUTE)
MICROSIEVERT_PER_MINUTE = UnitDescriptor('microsievert per minute', 'P76', '''µSv/min''')
ALL_UNITS.append(MICROSIEVERT_PER_MINUTE)
NANOSIEVERT_PER_MINUTE = UnitDescriptor('nanosievert per minute', 'P77', '''nSv/min''')
ALL_UNITS.append(NANOSIEVERT_PER_MINUTE)
RECIPROCAL_SQUARE_INCH = UnitDescriptor('reciprocal square inch', 'P78', '''1/in²''')
ALL_UNITS.append(RECIPROCAL_SQUARE_INCH)
PASCAL_SQUARE_METRE_PER_KILOGRAM = UnitDescriptor('pascal square metre per kilogram', 'P79', '''Pa/(kg/m²)''')
ALL_UNITS.append(PASCAL_SQUARE_METRE_PER_KILOGRAM)
EIGHT_PACK = UnitDescriptor('eight pack', 'P8', '''''')
ALL_UNITS.append(EIGHT_PACK)
MILLIPASCAL_PER_METRE = UnitDescriptor('millipascal per metre', 'P80', '''mPa/m''')
ALL_UNITS.append(MILLIPASCAL_PER_METRE)
KILOPASCAL_PER_METRE = UnitDescriptor('kilopascal per metre', 'P81', '''kPa/m''')
ALL_UNITS.append(KILOPASCAL_PER_METRE)
HECTOPASCAL_PER_METRE = UnitDescriptor('hectopascal per metre', 'P82', '''hPa/m''')
ALL_UNITS.append(HECTOPASCAL_PER_METRE)
STANDARD_ATMOSPHERE_PER_METRE = UnitDescriptor('standard atmosphere per metre', 'P83', '''Atm/m''')
ALL_UNITS.append(STANDARD_ATMOSPHERE_PER_METRE)
TECHNICAL_ATMOSPHERE_PER_METRE = UnitDescriptor('technical atmosphere per metre', 'P84', '''at/m''')
ALL_UNITS.append(TECHNICAL_ATMOSPHERE_PER_METRE)
TORR_PER_METRE = UnitDescriptor('torr per metre', 'P85', '''Torr/m''')
ALL_UNITS.append(TORR_PER_METRE)
PSI_PER_INCH = UnitDescriptor('psi per inch', 'P86', '''psi/in''')
ALL_UNITS.append(PSI_PER_INCH)
CUBIC_METRE_PER_SECOND_SQUARE_METRE = UnitDescriptor('cubic metre per second square metre', 'P87', '''(m³/s)/m²''')
ALL_UNITS.append(CUBIC_METRE_PER_SECOND_SQUARE_METRE)
RHE = UnitDescriptor('rhe', 'P88', '''rhe''')
ALL_UNITS.append(RHE)
POUND_FORCE_FOOT_PER_INCH = UnitDescriptor('pound-force foot per inch', 'P89', '''lbf·ft/in''')
ALL_UNITS.append(POUND_FORCE_FOOT_PER_INCH)
NINE_PACK = UnitDescriptor('nine pack', 'P9', '''''')
ALL_UNITS.append(NINE_PACK)
POUND_FORCE_INCH_PER_INCH = UnitDescriptor('pound-force inch per inch', 'P90', '''lbf·in/in''')
ALL_UNITS.append(POUND_FORCE_INCH_PER_INCH)
PERM_0_DEG_C = UnitDescriptor('perm (0 ºC)', 'P91', '''perm (0 ºC) ''')
ALL_UNITS.append(PERM_0_DEG_C)
PERM_23_DEG_C = UnitDescriptor('perm (23 ºC)', 'P92', '''perm (23 ºC) ''')
ALL_UNITS.append(PERM_23_DEG_C)
BYTE_PER_SECOND = UnitDescriptor('byte per second', 'P93', '''byte/s''')
ALL_UNITS.append(BYTE_PER_SECOND)
KILOBYTE_PER_SECOND = UnitDescriptor('kilobyte per second', 'P94', '''kbyte/s''')
ALL_UNITS.append(KILOBYTE_PER_SECOND)
MEGABYTE_PER_SECOND = UnitDescriptor('megabyte per second', 'P95', '''Mbyte/s''')
ALL_UNITS.append(MEGABYTE_PER_SECOND)
RECIPROCAL_VOLT = UnitDescriptor('reciprocal volt', 'P96', '''1/V''')
ALL_UNITS.append(RECIPROCAL_VOLT)
RECIPROCAL_RADIAN = UnitDescriptor('reciprocal radian', 'P97', '''1/rad''')
ALL_UNITS.append(RECIPROCAL_RADIAN)
PASCAL_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS = UnitDescriptor('pascal to the power sum of stoichiometric numbers', 'P98', '''PaΣνB''')
ALL_UNITS.append(PASCAL_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS)
MOLE_PER_CUBIV_METRE_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS = UnitDescriptor('mole per cubiv metre to the power sum of stoichiometric numbers', 'P99', '''(mol/m³)∑νB''')
ALL_UNITS.append(MOLE_PER_CUBIV_METRE_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS)
PACKET = UnitDescriptor('packet', 'PA', '''''')
ALL_UNITS.append(PACKET)
PASCAL = UnitDescriptor('pascal', 'PAL', '''Pa''')
ALL_UNITS.append(PASCAL)
PAIR_INCH = UnitDescriptor('pair inch', 'PB', '''''')
ALL_UNITS.append(PAIR_INCH)
PAD = UnitDescriptor('pad', 'PD', '''''')
ALL_UNITS.append(PAD)
POUND_EQUIVALENT = UnitDescriptor('pound equivalent', 'PE', '''''')
ALL_UNITS.append(POUND_EQUIVALENT)
PALLET_LIFT = UnitDescriptor('pallet (lift)', 'PF', '''''')
ALL_UNITS.append(PALLET_LIFT)
PROOF_LITRE = UnitDescriptor('proof litre', 'PFL', '''''')
ALL_UNITS.append(PROOF_LITRE)
PLATE = UnitDescriptor('plate', 'PG', '''''')
ALL_UNITS.append(PLATE)
PROOF_GALLON = UnitDescriptor('proof gallon', 'PGL', '''''')
ALL_UNITS.append(PROOF_GALLON)
PITCH = UnitDescriptor('pitch', 'PI', '''''')
ALL_UNITS.append(PITCH)
PACK = UnitDescriptor('pack', 'PK', '''''')
ALL_UNITS.append(PACK)
PAIL = UnitDescriptor('pail', 'PL', '''''')
ALL_UNITS.append(PAIL)
DEGREE_PLATO = UnitDescriptor('degree Plato', 'PLA', '''°P''')
ALL_UNITS.append(DEGREE_PLATO)
POUND_PERCENTAGE = UnitDescriptor('pound percentage', 'PM', '''''')
ALL_UNITS.append(POUND_PERCENTAGE)
POUND_NET = UnitDescriptor('pound net', 'PN', '''''')
ALL_UNITS.append(POUND_NET)
POUND_PER_INCH_OF_LENGTH = UnitDescriptor('pound per inch of length', 'PO', '''lb/in''')
ALL_UNITS.append(POUND_PER_INCH_OF_LENGTH)
PAGE_PER_INCH = UnitDescriptor('page per inch', 'PQ', '''ppi''')
ALL_UNITS.append(PAGE_PER_INCH)
PAIR = UnitDescriptor('pair', 'PR', '''''')
ALL_UNITS.append(PAIR)
POUND_FORCE_PER_SQUARE_INCH = UnitDescriptor('pound-force per square inch', 'PS', '''lbf/in²''')
ALL_UNITS.append(POUND_FORCE_PER_SQUARE_INCH)
PINT_US = UnitDescriptor('pint (US)', 'PT', '''pt (US)''')
ALL_UNITS.append(PINT_US)
DRY_PINT_US = UnitDescriptor('dry pint (US)', 'PTD', '''dry pt (US)''')
ALL_UNITS.append(DRY_PINT_US)
PINT_UK = UnitDescriptor('pint (UK)', 'PTI', '''pt (UK)''')
ALL_UNITS.append(PINT_UK)
LIQUID_PINT_US = UnitDescriptor('liquid pint (US)', 'PTL', '''liq pt (US)''')
ALL_UNITS.append(LIQUID_PINT_US)
PORTION = UnitDescriptor('portion', 'PTN', '''PTN''')
ALL_UNITS.append(PORTION)
TRAY_PER_TRAY_PACK = UnitDescriptor('tray / tray pack', 'PU', '''''')
ALL_UNITS.append(TRAY_PER_TRAY_PACK)
HALF_PINT_US = UnitDescriptor('half pint (US)', 'PV', '''''')
ALL_UNITS.append(HALF_PINT_US)
POUND_PER_INCH_OF_WIDTH = UnitDescriptor('pound per inch of width', 'PW', '''''')
ALL_UNITS.append(POUND_PER_INCH_OF_WIDTH)
PECK_DRY_US = UnitDescriptor('peck dry (US)', 'PY', '''''')
ALL_UNITS.append(PECK_DRY_US)
PECK_DRY_UK = UnitDescriptor('peck dry (UK)', 'PZ', '''''')
ALL_UNITS.append(PECK_DRY_UK)
JOULE_PER_TESLA = UnitDescriptor('joule per tesla', 'Q10', '''J/T''')
ALL_UNITS.append(JOULE_PER_TESLA)
ERLANG = UnitDescriptor('erlang', 'Q11', '''E''')
ALL_UNITS.append(ERLANG)
OCTET = UnitDescriptor('octet', 'Q12', '''o''')
ALL_UNITS.append(OCTET)
OCTET_PER_SECOND = UnitDescriptor('octet per second', 'Q13', '''o/s''')
ALL_UNITS.append(OCTET_PER_SECOND)
SHANNON = UnitDescriptor('shannon', 'Q14', '''Sh''')
ALL_UNITS.append(SHANNON)
HARTLEY = UnitDescriptor('hartley', 'Q15', '''Hart''')
ALL_UNITS.append(HARTLEY)
NATURAL_UNIT_OF_INFORMATION = UnitDescriptor('natural unit of information', 'Q16', '''nat''')
ALL_UNITS.append(NATURAL_UNIT_OF_INFORMATION)
SHANNON_PER_SECOND = UnitDescriptor('shannon per second', 'Q17', '''Sh/s''')
ALL_UNITS.append(SHANNON_PER_SECOND)
HARTLEY_PER_SECOND = UnitDescriptor('hartley per second', 'Q18', '''Hart/s''')
ALL_UNITS.append(HARTLEY_PER_SECOND)
NATURAL_UNIT_OF_INFORMATION_PER_SECOND = UnitDescriptor('natural unit of information per second', 'Q19', '''nat/s''')
ALL_UNITS.append(NATURAL_UNIT_OF_INFORMATION_PER_SECOND)
SECOND_PER_KILOGRAMM = UnitDescriptor('second per kilogramm', 'Q20', '''s/kg''')
ALL_UNITS.append(SECOND_PER_KILOGRAMM)
WATT_SQUARE_METRE = UnitDescriptor('watt square metre', 'Q21', '''W·m²''')
ALL_UNITS.append(WATT_SQUARE_METRE)
SECOND_PER_RADIAN_CUBIC_METRE = UnitDescriptor('second per radian cubic metre', 'Q22', '''1/(Hz·rad·m³)''')
ALL_UNITS.append(SECOND_PER_RADIAN_CUBIC_METRE)
WEBER_TO_THE_POWER_MINUS_ONE = UnitDescriptor('weber to the power minus one', 'Q23', '''1/Wb''')
ALL_UNITS.append(WEBER_TO_THE_POWER_MINUS_ONE)
RECIPROCAL_INCH = UnitDescriptor('reciprocal inch', 'Q24', '''1/in''')
ALL_UNITS.append(RECIPROCAL_INCH)
DIOPTRE = UnitDescriptor('dioptre', 'Q25', '''dpt''')
ALL_UNITS.append(DIOPTRE)
ONE_PER_ONE = UnitDescriptor('one per one', 'Q26', '''1/1''')
ALL_UNITS.append(ONE_PER_ONE)
NEWTON_METRE_PER_METRE = UnitDescriptor('newton metre per metre', 'Q27', '''N·m/m²''')
ALL_UNITS.append(NEWTON_METRE_PER_METRE)
KILOGRAM_PER_SQUARE_METRE_PASCAL_SECOND = UnitDescriptor('kilogram per square metre pascal second', 'Q28', '''kg/(m²·Pa·s)''')
ALL_UNITS.append(KILOGRAM_PER_SQUARE_METRE_PASCAL_SECOND)
MICROGRAM_PER_HECTOGRAM = UnitDescriptor('microgram per hectogram', 'Q29', '''µg/hg''')
ALL_UNITS.append(MICROGRAM_PER_HECTOGRAM)
PH_POTENTIAL_OF_HYDROGEN = UnitDescriptor('pH (potential of Hydrogen)', 'Q30', '''pH''')
ALL_UNITS.append(PH_POTENTIAL_OF_HYDROGEN)
KILOJOULE_PER_GRAM = UnitDescriptor('kilojoule per gram', 'Q31', '''kJ/g''')
ALL_UNITS.append(KILOJOULE_PER_GRAM)
FEMTOLITRE = UnitDescriptor('femtolitre', 'Q32', '''fl''')
ALL_UNITS.append(FEMTOLITRE)
PICOLITRE = UnitDescriptor('picolitre', 'Q33', '''pl''')
ALL_UNITS.append(PICOLITRE)
NANOLITRE = UnitDescriptor('nanolitre', 'Q34', '''nl''')
ALL_UNITS.append(NANOLITRE)
MEGAWATTS_PER_MINUTE = UnitDescriptor('megawatts per minute', 'Q35', '''MW/min''')
ALL_UNITS.append(MEGAWATTS_PER_MINUTE)
SQUARE_METRE_PER_CUBIC_METRE = UnitDescriptor('square metre per cubic metre', 'Q36', '''m2/m3''')
ALL_UNITS.append(SQUARE_METRE_PER_CUBIC_METRE)
STANDARD_CUBIC_METRE_PER_DAY = UnitDescriptor('Standard cubic metre per day', 'Q37', '''''')
ALL_UNITS.append(STANDARD_CUBIC_METRE_PER_DAY)
STANDARD_CUBIC_METRE_PER_HOUR = UnitDescriptor('Standard cubic metre per hour', 'Q38', '''''')
ALL_UNITS.append(STANDARD_CUBIC_METRE_PER_HOUR)
NORMALIZED_CUBIC_METRE_PER_DAY = UnitDescriptor('Normalized cubic metre per day', 'Q39', '''''')
ALL_UNITS.append(NORMALIZED_CUBIC_METRE_PER_DAY)
NORMALIZED_CUBIC_METRE_PER_HOUR = UnitDescriptor('Normalized cubic metre per hour', 'Q40', '''''')
ALL_UNITS.append(NORMALIZED_CUBIC_METRE_PER_HOUR)
JOULE_PER_NORMALISED_CUBIC_METRE = UnitDescriptor('Joule per normalised cubic metre', 'Q41', '''''')
ALL_UNITS.append(JOULE_PER_NORMALISED_CUBIC_METRE)
JOULE_PER_STANDARD_CUBIC_METRE = UnitDescriptor('Joule per standard cubic metre', 'Q42', '''''')
ALL_UNITS.append(JOULE_PER_STANDARD_CUBIC_METRE)
MEAL = UnitDescriptor('meal', 'Q3', '''''')
ALL_UNITS.append(MEAL)
PAGE_FACSIMILE = UnitDescriptor('page - facsimile', 'QA', '''''')
ALL_UNITS.append(PAGE_FACSIMILE)
QUARTER_OF_A_YEAR = UnitDescriptor('quarter (of a year)', 'QAN', '''''')
ALL_UNITS.append(QUARTER_OF_A_YEAR)
PAGE_HARDCOPY = UnitDescriptor('page - hardcopy', 'QB', '''''')
ALL_UNITS.append(PAGE_HARDCOPY)
QUARTER_DOZEN = UnitDescriptor('quarter dozen', 'QD', '''''')
ALL_UNITS.append(QUARTER_DOZEN)
QUARTER_HOUR = UnitDescriptor('quarter hour', 'QH', '''''')
ALL_UNITS.append(QUARTER_HOUR)
QUARTER_KILOGRAM = UnitDescriptor('quarter kilogram', 'QK', '''''')
ALL_UNITS.append(QUARTER_KILOGRAM)
QUIRE = UnitDescriptor('quire', 'QR', '''qr''')
ALL_UNITS.append(QUIRE)
QUART_US = UnitDescriptor('quart (US)', 'QT', '''qt (US)''')
ALL_UNITS.append(QUART_US)
DRY_QUART_US = UnitDescriptor('dry quart (US)', 'QTD', '''dry qt (US)''')
ALL_UNITS.append(DRY_QUART_US)
QUART_UK = UnitDescriptor('quart (UK)', 'QTI', '''qt (UK)''')
ALL_UNITS.append(QUART_UK)
LIQUID_QUART_US = UnitDescriptor('liquid quart (US)', 'QTL', '''liq qt (US)''')
ALL_UNITS.append(LIQUID_QUART_US)
QUARTER_UK = UnitDescriptor('quarter (UK)', 'QTR', '''Qr (UK)''')
ALL_UNITS.append(QUARTER_UK)
PICA = UnitDescriptor('pica', 'R1', '''''')
ALL_UNITS.append(PICA)
CALORIE = UnitDescriptor('calorie', 'R4', '''cal''')
ALL_UNITS.append(CALORIE)
THOUSAND_CUBIC_METRE = UnitDescriptor('thousand cubic metre', 'R9', '''''')
ALL_UNITS.append(THOUSAND_CUBIC_METRE)
RACK = UnitDescriptor('rack', 'RA', '''''')
ALL_UNITS.append(RACK)
ROD = UnitDescriptor('rod', 'RD', '''''')
ALL_UNITS.append(ROD)
RING = UnitDescriptor('ring', 'RG', '''''')
ALL_UNITS.append(RING)
RUNNING_OR_OPERATING_HOUR = UnitDescriptor('running or operating hour', 'RH', '''''')
ALL_UNITS.append(RUNNING_OR_OPERATING_HOUR)
ROLL_METRIC_MEASURE = UnitDescriptor('roll metric measure', 'RK', '''''')
ALL_UNITS.append(ROLL_METRIC_MEASURE)
REEL = UnitDescriptor('reel', 'RL', '''''')
ALL_UNITS.append(REEL)
REAM = UnitDescriptor('ream', 'RM', '''''')
ALL_UNITS.append(REAM)
REAM_METRIC_MEASURE = UnitDescriptor('ream metric measure', 'RN', '''''')
ALL_UNITS.append(REAM_METRIC_MEASURE)
ROLL = UnitDescriptor('roll', 'RO', '''''')
ALL_UNITS.append(ROLL)
ROOM = UnitDescriptor('room', 'ROM', '''''')
ALL_UNITS.append(ROOM)
POUND_PER_REAM = UnitDescriptor('pound per ream', 'RP', '''''')
ALL_UNITS.append(POUND_PER_REAM)
REVOLUTIONS_PER_MINUTE = UnitDescriptor('revolutions per minute', 'RPM', '''r/min''')
ALL_UNITS.append(REVOLUTIONS_PER_MINUTE)
REVOLUTIONS_PER_SECOND = UnitDescriptor('revolutions per second', 'RPS', '''r/s''')
ALL_UNITS.append(REVOLUTIONS_PER_SECOND)
RESET = UnitDescriptor('reset', 'RS', '''''')
ALL_UNITS.append(RESET)
REVENUE_TON_MILE = UnitDescriptor('revenue ton mile', 'RT', '''''')
ALL_UNITS.append(REVENUE_TON_MILE)
RUN = UnitDescriptor('run', 'RU', '''''')
ALL_UNITS.append(RUN)
SQUARE_FOOT_PER_SECOND = UnitDescriptor('square foot per second', 'S3', '''ft²/s''')
ALL_UNITS.append(SQUARE_FOOT_PER_SECOND)
SQUARE_METRE_PER_SECOND = UnitDescriptor('square metre per second', 'S4', '''m²/s''')
ALL_UNITS.append(SQUARE_METRE_PER_SECOND)
SIXTY_FOURTHS_OF_AN_INCH = UnitDescriptor('sixty fourths of an inch', 'S5', '''''')
ALL_UNITS.append(SIXTY_FOURTHS_OF_AN_INCH)
SESSION = UnitDescriptor('session', 'S6', '''''')
ALL_UNITS.append(SESSION)
STORAGE_UNIT = UnitDescriptor('storage unit', 'S7', '''''')
ALL_UNITS.append(STORAGE_UNIT)
STANDARD_ADVERTISING_UNIT = UnitDescriptor('standard advertising unit', 'S8', '''''')
ALL_UNITS.append(STANDARD_ADVERTISING_UNIT)
SACK = UnitDescriptor('sack', 'SA', '''''')
ALL_UNITS.append(SACK)
HALF_YEAR_6_MONTHS = UnitDescriptor('half year (6 months)', 'SAN', '''''')
ALL_UNITS.append(HALF_YEAR_6_MONTHS)
SCORE = UnitDescriptor('score', 'SCO', '''''')
ALL_UNITS.append(SCORE)
SCRUPLE = UnitDescriptor('scruple', 'SCR', '''''')
ALL_UNITS.append(SCRUPLE)
SOLID_POUND = UnitDescriptor('solid pound', 'SD', '''''')
ALL_UNITS.append(SOLID_POUND)
SECTION = UnitDescriptor('section', 'SE', '''''')
ALL_UNITS.append(SECTION)
SECOND_UNIT_OF_TIME = UnitDescriptor('second [unit of time]', 'SEC', '''s''')
ALL_UNITS.append(SECOND_UNIT_OF_TIME)
SET = UnitDescriptor('set', 'SET', '''''')
ALL_UNITS.append(SET)
SEGMENT = UnitDescriptor('segment', 'SG', '''''')
ALL_UNITS.append(SEGMENT)
SHIPPING_TON = UnitDescriptor('shipping ton', 'SHT', '''''')
ALL_UNITS.append(SHIPPING_TON)
SIEMENS = UnitDescriptor('siemens', 'SIE', '''S''')
ALL_UNITS.append(SIEMENS)
SPLIT_TANK_TRUCK = UnitDescriptor('split tank truck', 'SK', '''''')
ALL_UNITS.append(SPLIT_TANK_TRUCK)
SLIPSHEET = UnitDescriptor('slipsheet', 'SL', '''''')
ALL_UNITS.append(SLIPSHEET)
STANDARD_CUBIC_METRE = UnitDescriptor('Standard cubic metre', 'SM3', '''''')
ALL_UNITS.append(STANDARD_CUBIC_METRE)
MILE_STATUTE_MILE = UnitDescriptor('mile (statute mile)', 'SMI', '''mile''')
ALL_UNITS.append(MILE_STATUTE_MILE)
SQUARE_ROD = UnitDescriptor('square rod', 'SN', '''rd²''')
ALL_UNITS.append(SQUARE_ROD)
SPOOL = UnitDescriptor('spool', 'SO', '''''')
ALL_UNITS.append(SPOOL)
SHELF_PACKAGE = UnitDescriptor('shelf package', 'SP', '''''')
ALL_UNITS.append(SHELF_PACKAGE)
SQUARE = UnitDescriptor('square', 'SQ', '''''')
ALL_UNITS.append(SQUARE)
SQUARE_ROOFING = UnitDescriptor('square, roofing', 'SQR', '''''')
ALL_UNITS.append(SQUARE_ROOFING)
STRIP = UnitDescriptor('strip', 'SR', '''''')
ALL_UNITS.append(STRIP)
SHEET_METRIC_MEASURE = UnitDescriptor('sheet metric measure', 'SS', '''''')
ALL_UNITS.append(SHEET_METRIC_MEASURE)
SHORT_STANDARD_7200_MATCHES = UnitDescriptor('short standard (7200 matches)', 'SST', '''''')
ALL_UNITS.append(SHORT_STANDARD_7200_MATCHES)
SHEET = UnitDescriptor('sheet', 'ST', '''''')
ALL_UNITS.append(SHEET)
STICK = UnitDescriptor('stick', 'STC', '''''')
ALL_UNITS.append(STICK)
STONE_UK = UnitDescriptor('stone (UK)', 'STI', '''st''')
ALL_UNITS.append(STONE_UK)
STICK_CIGARETTE = UnitDescriptor('stick, cigarette', 'STK', '''''')
ALL_UNITS.append(STICK_CIGARETTE)
STANDARD_LITRE = UnitDescriptor('standard litre', 'STL', '''''')
ALL_UNITS.append(STANDARD_LITRE)
TON_US_OR_SHORT_TON_UK_PER_US = UnitDescriptor('ton (US) or short ton (UK/US)', 'STN', '''ton (US)''')
ALL_UNITS.append(TON_US_OR_SHORT_TON_UK_PER_US)
STRAW = UnitDescriptor('straw', 'STW', '''''')
ALL_UNITS.append(STRAW)
SKID = UnitDescriptor('skid', 'SV', '''''')
ALL_UNITS.append(SKID)
SKEIN = UnitDescriptor('skein', 'SW', '''''')
ALL_UNITS.append(SKEIN)
SHIPMENT = UnitDescriptor('shipment', 'SX', '''''')
ALL_UNITS.append(SHIPMENT)
SYRINGE = UnitDescriptor('syringe', 'SYR', '''''')
ALL_UNITS.append(SYRINGE)
TELECOMMUNICATION_LINE_IN_SERVICE = UnitDescriptor('telecommunication line in service', 'T0', '''''')
ALL_UNITS.append(TELECOMMUNICATION_LINE_IN_SERVICE)
THOUSAND_POUND_GROSS = UnitDescriptor('thousand pound gross', 'T1', '''''')
ALL_UNITS.append(THOUSAND_POUND_GROSS)
THOUSAND_PIECE = UnitDescriptor('thousand piece', 'T3', '''''')
ALL_UNITS.append(THOUSAND_PIECE)
THOUSAND_BAG = UnitDescriptor('thousand bag', 'T4', '''''')
ALL_UNITS.append(THOUSAND_BAG)
THOUSAND_CASING = UnitDescriptor('thousand casing', 'T5', '''''')
ALL_UNITS.append(THOUSAND_CASING)
THOUSAND_GALLON_US = UnitDescriptor('thousand gallon (US)', 'T6', '''''')
ALL_UNITS.append(THOUSAND_GALLON_US)
THOUSAND_IMPRESSION = UnitDescriptor('thousand impression', 'T7', '''''')
ALL_UNITS.append(THOUSAND_IMPRESSION)
THOUSAND_LINEAR_INCH = UnitDescriptor('thousand linear inch', 'T8', '''''')
ALL_UNITS.append(THOUSAND_LINEAR_INCH)
TENTH_CUBIC_FOOT = UnitDescriptor('tenth cubic foot', 'TA', '''''')
ALL_UNITS.append(TENTH_CUBIC_FOOT)
KILOAMPERE_HOUR_THOUSAND_AMPERE_HOUR = UnitDescriptor('kiloampere hour (thousand ampere hour)', 'TAH', '''kA·h''')
ALL_UNITS.append(KILOAMPERE_HOUR_THOUSAND_AMPERE_HOUR)
TOTAL_ACID_NUMBER = UnitDescriptor('total acid number', 'TAN', '''TAN''')
ALL_UNITS.append(TOTAL_ACID_NUMBER)
TRUCKLOAD = UnitDescriptor('truckload', 'TC', '''''')
ALL_UNITS.append(TRUCKLOAD)
THERM = UnitDescriptor('therm', 'TD', '''''')
ALL_UNITS.append(THERM)
TOTE = UnitDescriptor('tote', 'TE', '''''')
ALL_UNITS.append(TOTE)
TEN_SQUARE_YARD = UnitDescriptor('ten square yard', 'TF', '''''')
ALL_UNITS.append(TEN_SQUARE_YARD)
THOUSAND_SQUARE_INCH = UnitDescriptor('thousand square inch', 'TI', '''''')
ALL_UNITS.append(THOUSAND_SQUARE_INCH)
METRIC_TON_INCLUDING_CONTAINER = UnitDescriptor('metric ton, including container', 'TIC', '''''')
ALL_UNITS.append(METRIC_TON_INCLUDING_CONTAINER)
METRIC_TON_INCLUDING_INNER_PACKAGING = UnitDescriptor('metric ton, including inner packaging', 'TIP', '''''')
ALL_UNITS.append(METRIC_TON_INCLUDING_INNER_PACKAGING)
THOUSAND_SQUARE_CENTIMETRE = UnitDescriptor('thousand square centimetre', 'TJ', '''''')
ALL_UNITS.append(THOUSAND_SQUARE_CENTIMETRE)
TANK_RECTANGULAR = UnitDescriptor('tank, rectangular', 'TK', '''''')
ALL_UNITS.append(TANK_RECTANGULAR)
TONNE_KILOMETRE = UnitDescriptor('tonne kilometre', 'TKM', '''t·km''')
ALL_UNITS.append(TONNE_KILOMETRE)
THOUSAND_FOOT_LINEAR = UnitDescriptor('thousand foot (linear)', 'TL', '''''')
ALL_UNITS.append(THOUSAND_FOOT_LINEAR)
KILOGRAM_OF_IMPORTED_MEAT_LESS_OFFAL = UnitDescriptor('kilogram of imported meat, less offal', 'TMS', '''''')
ALL_UNITS.append(KILOGRAM_OF_IMPORTED_MEAT_LESS_OFFAL)
TIN = UnitDescriptor('tin', 'TN', '''''')
ALL_UNITS.append(TIN)
TONNE_METRIC_TON = UnitDescriptor('tonne (metric ton)', 'TNE', '''t''')
ALL_UNITS.append(TONNE_METRIC_TON)
TEN_PACK = UnitDescriptor('ten pack', 'TP', '''''')
ALL_UNITS.append(TEN_PACK)
TEETH_PER_INCH = UnitDescriptor('teeth per inch', 'TPI', '''TPI''')
ALL_UNITS.append(TEETH_PER_INCH)
TEN_PAIR = UnitDescriptor('ten pair', 'TPR', '''''')
ALL_UNITS.append(TEN_PAIR)
THOUSAND_FOOT = UnitDescriptor('thousand foot', 'TQ', '''''')
ALL_UNITS.append(THOUSAND_FOOT)
THOUSAND_CUBIC_METRE_PER_DAY = UnitDescriptor('thousand cubic metre per day', 'TQD', '''km³/d''')
ALL_UNITS.append(THOUSAND_CUBIC_METRE_PER_DAY)
TEN_SQUARE_FOOT = UnitDescriptor('ten square foot', 'TR', '''''')
ALL_UNITS.append(TEN_SQUARE_FOOT)
TRILLION_EUR = UnitDescriptor('trillion (EUR)', 'TRL', '''''')
ALL_UNITS.append(TRILLION_EUR)
THOUSAND_SQUARE_FOOT = UnitDescriptor('thousand square foot', 'TS', '''''')
ALL_UNITS.append(THOUSAND_SQUARE_FOOT)
TONNE_OF_SUBSTANCE_90_PERCENT_DRY = UnitDescriptor('tonne of substance 90 % dry', 'TSD', '''''')
ALL_UNITS.append(TONNE_OF_SUBSTANCE_90_PERCENT_DRY)
TON_OF_STEAM_PER_HOUR = UnitDescriptor('ton of steam per hour', 'TSH', '''''')
ALL_UNITS.append(TON_OF_STEAM_PER_HOUR)
TEN_SET = UnitDescriptor('ten set', 'TST', '''''')
ALL_UNITS.append(TEN_SET)
THOUSAND_LINEAR_METRE = UnitDescriptor('thousand linear metre', 'TT', '''''')
ALL_UNITS.append(THOUSAND_LINEAR_METRE)
TEN_THOUSAND_STICKS = UnitDescriptor('ten thousand sticks', 'TTS', '''''')
ALL_UNITS.append(TEN_THOUSAND_STICKS)
TUBE = UnitDescriptor('tube', 'TU', '''''')
ALL_UNITS.append(TUBE)
THOUSAND_KILOGRAM = UnitDescriptor('thousand kilogram', 'TV', '''''')
ALL_UNITS.append(THOUSAND_KILOGRAM)
THOUSAND_SHEET = UnitDescriptor('thousand sheet', 'TW', '''''')
ALL_UNITS.append(THOUSAND_SHEET)
TANK_CYLINDRICAL = UnitDescriptor('tank, cylindrical', 'TY', '''''')
ALL_UNITS.append(TANK_CYLINDRICAL)
TREATMENT = UnitDescriptor('treatment', 'U1', '''''')
ALL_UNITS.append(TREATMENT)
TABLET = UnitDescriptor('tablet', 'U2', '''''')
ALL_UNITS.append(TABLET)
TORR = UnitDescriptor('torr', 'UA', '''Torr''')
ALL_UNITS.append(TORR)
TELECOMMUNICATION_LINE_IN_SERVICE_AVERAGE = UnitDescriptor('telecommunication line in service average', 'UB', '''''')
ALL_UNITS.append(TELECOMMUNICATION_LINE_IN_SERVICE_AVERAGE)
TELECOMMUNICATION_PORT = UnitDescriptor('telecommunication port', 'UC', '''''')
ALL_UNITS.append(TELECOMMUNICATION_PORT)
TENTH_MINUTE = UnitDescriptor('tenth minute', 'UD', '''''')
ALL_UNITS.append(TENTH_MINUTE)
TENTH_HOUR = UnitDescriptor('tenth hour', 'UE', '''''')
ALL_UNITS.append(TENTH_HOUR)
USAGE_PER_TELECOMMUNICATION_LINE_AVERAGE = UnitDescriptor('usage per telecommunication line average', 'UF', '''''')
ALL_UNITS.append(USAGE_PER_TELECOMMUNICATION_LINE_AVERAGE)
TEN_THOUSAND_YARD = UnitDescriptor('ten thousand yard', 'UH', '''''')
ALL_UNITS.append(TEN_THOUSAND_YARD)
MILLION_UNIT = UnitDescriptor('million unit', 'UM', '''''')
ALL_UNITS.append(MILLION_UNIT)
VOLT_AMPERE_PER_KILOGRAM = UnitDescriptor('volt - ampere per kilogram', 'VA', '''V·A / kg''')
ALL_UNITS.append(VOLT_AMPERE_PER_KILOGRAM)
VIAL = UnitDescriptor('vial', 'VI', '''''')
ALL_UNITS.append(VIAL)
VOLT = UnitDescriptor('volt', 'VLT', '''V''')
ALL_UNITS.append(VOLT)
PERCENT_VOLUME = UnitDescriptor('percent volume', 'VP', '''''')
ALL_UNITS.append(PERCENT_VOLUME)
BULK = UnitDescriptor('bulk', 'VQ', '''''')
ALL_UNITS.append(BULK)
VISIT = UnitDescriptor('visit', 'VS', '''''')
ALL_UNITS.append(VISIT)
WET_KILO = UnitDescriptor('wet kilo', 'W2', '''''')
ALL_UNITS.append(WET_KILO)
TWO_WEEK = UnitDescriptor('two week', 'W4', '''''')
ALL_UNITS.append(TWO_WEEK)
WATT_PER_KILOGRAM = UnitDescriptor('watt per kilogram', 'WA', '''W/kg''')
ALL_UNITS.append(WATT_PER_KILOGRAM)
WET_POUND = UnitDescriptor('wet pound', 'WB', '''''')
ALL_UNITS.append(WET_POUND)
CORD = UnitDescriptor('cord', 'WCD', '''''')
ALL_UNITS.append(CORD)
WET_TON = UnitDescriptor('wet ton', 'WE', '''''')
ALL_UNITS.append(WET_TON)
WEBER = UnitDescriptor('weber', 'WEB', '''Wb''')
ALL_UNITS.append(WEBER)
WEEK = UnitDescriptor('week', 'WEE', '''wk''')
ALL_UNITS.append(WEEK)
WINE_GALLON = UnitDescriptor('wine gallon', 'WG', '''''')
ALL_UNITS.append(WINE_GALLON)
WHEEL = UnitDescriptor('wheel', 'WH', '''''')
ALL_UNITS.append(WHEEL)
WATT_HOUR = UnitDescriptor('watt hour', 'WHR', '''W·h''')
ALL_UNITS.append(WATT_HOUR)
WEIGHT_PER_SQUARE_INCH = UnitDescriptor('weight per square inch', 'WI', '''''')
ALL_UNITS.append(WEIGHT_PER_SQUARE_INCH)
WORKING_MONTH = UnitDescriptor('working month', 'WM', '''''')
ALL_UNITS.append(WORKING_MONTH)
WRAP = UnitDescriptor('wrap', 'WR', '''''')
ALL_UNITS.append(WRAP)
STANDARD = UnitDescriptor('standard', 'WSD', '''std''')
ALL_UNITS.append(STANDARD)
WATT = UnitDescriptor('watt', 'WTT', '''W''')
ALL_UNITS.append(WATT)
MILLILITRE_OF_WATER = UnitDescriptor('millilitre of water', 'WW', '''''')
ALL_UNITS.append(MILLILITRE_OF_WATER)
GUNTER_S_CHAIN = UnitDescriptor('Gunter\'s chain', 'X1', '''ch (UK)''')
ALL_UNITS.append(GUNTER_S_CHAIN)
SQUARE_YARD = UnitDescriptor('square yard', 'YDK', '''yd²''')
ALL_UNITS.append(SQUARE_YARD)
CUBIC_YARD = UnitDescriptor('cubic yard', 'YDQ', '''yd³''')
ALL_UNITS.append(CUBIC_YARD)
HUNDRED_LINEAR_YARD = UnitDescriptor('hundred linear yard', 'YL', '''''')
ALL_UNITS.append(HUNDRED_LINEAR_YARD)
YARD = UnitDescriptor('yard', 'YRD', '''yd''')
ALL_UNITS.append(YARD)
TEN_YARD = UnitDescriptor('ten yard', 'YT', '''''')
ALL_UNITS.append(TEN_YARD)
LIFT_VAN = UnitDescriptor('lift van', 'Z1', '''''')
ALL_UNITS.append(LIFT_VAN)
HANGING_CONTAINER = UnitDescriptor('hanging container', 'Z11', '''''')
ALL_UNITS.append(HANGING_CONTAINER)
CHEST = UnitDescriptor('chest', 'Z2', '''''')
ALL_UNITS.append(CHEST)
CASK = UnitDescriptor('cask', 'Z3', '''''')
ALL_UNITS.append(CASK)
HOGSHEAD = UnitDescriptor('hogshead', 'Z4', '''''')
ALL_UNITS.append(HOGSHEAD)
LUG = UnitDescriptor('lug', 'Z5', '''''')
ALL_UNITS.append(LUG)
CONFERENCE_POINT = UnitDescriptor('conference point', 'Z6', '''''')
ALL_UNITS.append(CONFERENCE_POINT)
NEWSPAGE_AGATE_LINE = UnitDescriptor('newspage agate line', 'Z8', '''''')
ALL_UNITS.append(NEWSPAGE_AGATE_LINE)
PAGE = UnitDescriptor('page', 'ZP', '''''')
ALL_UNITS.append(PAGE)
MUTUALLY_DEFINED = UnitDescriptor('mutually defined', 'ZZ', '''''')
ALL_UNITS.append(MUTUALLY_DEFINED)
METRE_WEEK = UnitDescriptor('Metre Week', 'MRW', '''m·wk''')
ALL_UNITS.append(METRE_WEEK)
SQUARE_METRE_WEEK = UnitDescriptor('Square Metre Week', 'MKW', '''m²· wk''')
ALL_UNITS.append(SQUARE_METRE_WEEK)
CUBIC_METRE_WEEK = UnitDescriptor('Cubic Metre Week', 'MQW', '''m³·wk''')
ALL_UNITS.append(CUBIC_METRE_WEEK)
PIECE_WEEK = UnitDescriptor('Piece Week', 'HWE', '''piece·k''')
ALL_UNITS.append(PIECE_WEEK)
METRE_DAY = UnitDescriptor('Metre Day', 'MRD', '''m·day''')
ALL_UNITS.append(METRE_DAY)
SQUARE_METRE_DAY = UnitDescriptor('Square Metre Day', 'MKD', '''m²·d''')
ALL_UNITS.append(SQUARE_METRE_DAY)
CUBIC_METRE_DAY = UnitDescriptor('Cubic Metre Day', 'MQD', '''m³·d''')
ALL_UNITS.append(CUBIC_METRE_DAY)
PIECE_DAY = UnitDescriptor('Piece Day', 'HAD', '''piece·d''')
ALL_UNITS.append(PIECE_DAY)
METRE_MONTH = UnitDescriptor('Metre Month', 'MRM', '''m·mo''')
ALL_UNITS.append(METRE_MONTH)
SQUARE_METRE_MONTH = UnitDescriptor('Square Metre Month', 'MKM', '''m²·mo''')
ALL_UNITS.append(SQUARE_METRE_MONTH)
CUBIC_METRE_MONTH = UnitDescriptor('Cubic Metre Month', 'MQM', '''m³·mo''')
ALL_UNITS.append(CUBIC_METRE_MONTH)
PIECE_MONTH = UnitDescriptor('Piece Month', 'HMO', '''piece·mo''')
ALL_UNITS.append(PIECE_MONTH)
DECIBEL_WATT = UnitDescriptor('Decibel watt', 'DBW', '''dBW''')
ALL_UNITS.append(DECIBEL_WATT)
DECIBEL_MILLIWATTS = UnitDescriptor('Decibel-milliwatts', 'DBM', '''dBm''')
ALL_UNITS.append(DECIBEL_MILLIWATTS)
FORMAZIN_NEPHELOMETRIC_UNIT = UnitDescriptor('Formazin nephelometric unit', 'FNU', '''FNU''')
ALL_UNITS.append(FORMAZIN_NEPHELOMETRIC_UNIT)
NEPHELOMETRIC_TURBIDITY_UNIT = UnitDescriptor('Nephelometric turbidity unit', 'NTU', '''NTU''')
ALL_UNITS.append(NEPHELOMETRIC_TURBIDITY_UNIT)

# Convenience aliases.
MINUTE = MINUTE_UNIT_OF_TIME
SECOND = SECOND_UNIT_OF_TIME

# pylint: enable=line-too-long


class UnitLookup(object):
  """Facilitates user-friendly access to units."""

  def __init__(self, lookup):
    self._lookup = lookup

  def __call__(self, name_or_suffix):
    """Provides instantiation-like access for units module."""
    return self._lookup[name_or_suffix]


UNITS_BY_NAME = {u.name: u for u in ALL_UNITS}
UNITS_BY_SUFFIX = {u.suffix: u for u in ALL_UNITS}

del ALL_UNITS

UNITS_BY_ALL = {}
UNITS_BY_ALL.update(UNITS_BY_NAME)
UNITS_BY_ALL.update(UNITS_BY_SUFFIX)
UNITS_BY_ALL[None] = NONE

Unit = UnitLookup(UNITS_BY_ALL)  # pylint: disable=invalid-name
