# 浅层机器学习平台用户指南	

​	针对中文文本的预处理方法，包括文本清洗、分词、分句、同义词匹配等功能

### 环境

numpy<br>
jieba<br>
textrank4zh<br>
pandas<br>
tqdm<br>



### 安装方法

```
git clone git@git.huimeimt.com:carl.bai/shallow_machine_learning_platform.git
cd shallow_machine_learning_platform/
python3 setup.py install
```



### 功能及使用说明

#### 文本预处理

- 全角转半角

  - ```python
    def strQ2B(self, ustring)
    ```

  - 由于所获取的中文文本有部分是全角，对于数据清理不太方便，因此可以将文本全部转换为半角

  - 该方法写在PreProcessing 类里面，被clean_up 文本清理方法所调用

    

- 分句

  - ```python
    def cut_sent(self, para)
    ```

  - 为每个文本根据断句符、中英文省略号、换行符等做分句处理

    

- 文本清理

  - ```python
    def cleanup(self, filepath: str)
    def cleanup_txt(self, text: str)
    ```

  - 包括全角转半角，清洗()外的内容，分句，去除空格等

  - 将括号外的所有字词都去除空格和异常符号，以方便处理分词

  - 处理完成后根据分句方法进行分词

    

- 分词

  - ```python
    def seg(self, contents: list, dictpath='default')
    ```

  - 为每个分句做分词处理

  - 文本采用的是jieba分词工具，默认为自带的词典，如果需要新的词典需要输入路径，根据每个分句来进行分词

    

- 文本预处理使用方法

  ```python
  from smlp.PreProcessing import PreProcessing
  
  pp = PreProcessing()	# 声明PreProcessing类实例
  #content = pp.cleanup('test.txt')	可以直接清理文本文件
  content = pp.cleanup_txt(text: str)  # 直接清理string文本， 返回分句列表
  segs = pp.seg(content, dictpath=sm)	# 对已清理的分句进行分词，返回已分好词的分句的二维数组
  # 注意：此处添加了自定义词典路径

  ```



#### 单位统一

- 将所有单位转换为克并将百分数转换为小数

  - ```python
    def unit_cov_g(self, segments: list) # 需要上面分好词的分句数组进行转换
    ```

  - 使用方法

    ```python
    from smlp.unicov import unicov
    
    uc = unicov()	# 声明unicov类实例
    for s in segs:	#对每个分句里的分词列表进行处理
        uc.unit_cov_g(s)	
    
    ```

- 将所有单位转换为kg并将百分数转换为小数

  - ```python
    def unit_cov_kg(self, segments: list) # 需要上面分好词的分句数组进行转换
    ```

  - 使用方法同上

- 将所有单位转换为mg并将百分数转换为小数

  - ```python
    def unit_cov_mg(self, segments: list) # 需要上面分好词的分句数组进行转换
    ```

  - 使用方法同上



#### 同义词词典

- 类初始化

  ```python
  class Thesaurus():
      def __init__(self, contents: list): 	# 需要上面分好词的分句数组进行转换
          self.contents = contents	# 文本属性赋值
          self.synonym = {}		# 初始化同义词词典
          return
  ```

  

- 找出同义词

  - ```python
    def synonymy(self, min_len=2, max_len=12)
    ```

  - 定义同义词的最小长度和最大长度，以此来避免非法词语的写入

  - 返回类属性 synonym, 可通过类实例来调用



- 同义词词典清洗

  - ```python
    def cleanup(self)
    ```

  - 若词典中key对应的list里有不符合规范的value词，将会移除该元素

  - 若清洗后词典中key对应为空，则删除该key

  - 清洗的词典为类属性synonym，不返回数值



- 推荐词排序

  - ```python
        # 大写率
        @staticmethod
        def upper_rate(word):
    		……
    
        # 推荐词排序
        def sug_words(self, array):
            return sorted(set(array), key=lambda x: self.upper_rate(x), reverse=True)
    ```

  - 根据对应key的list中大写率越大的词放在前面，表示简写（当然后续还可以按照其他的方法排序）



- 同义词词典使用方法

  ```python
  from smlp.Thesaurus import Thesaurus
  
  ts = Thesaurus(segs)
  ts.synonymy()
  ts.cleanup()
  ```



- 效果展示：

  ```
  {
  ...
   '美国癌症学会': ['ACCP',
              'AATS',
              'ACS',
              'AL A',
              'ACCP American Cancer Society',
              'AATS A m er i c an Lu ng Association',
              'AL A American College of Chest Physicians',
              'American Association for Thoracic Surgery'],
   '美国胸外科学会': ['AATS', 'American Association for Thoracic Surgery'],
   '聚乙二醇': ['PEG'],
   '聚合酶链反应': ['FISH',
              'RT-PCR',
              'FISH real time polymerase chain reaction',
              'fluorescence in situ hybridization'],
   '聚苯胺': ['PANI'],
   ...
   }
  ```



- 待处理的问题：

  - (已解决)由于分词的原因，有一些单词会把 ',' 包含进去，导致无法将单词分割开来，例如:

    ```
     '生存期': ['overall survival, OS'],
    ```

    本来应该是两个同义词却包含在了一起

  - 还是由于分词的原因，导致一些本来不是该词的同义词变成了该词的同义词，同时选取的专业词汇错误，例如：

    ```
     '材料': ['MOFS',
            'Zeolitic Imidazolate Framework - 8, ZIF-8',
            'Metal - Organic Frameworks'],
    ```

    

  - 同时对于同义词的分析还是不够完善，目前只能识别（）内的同义词，而且一些（）内的词不属于同义词，例如：

    ```
    '结果': ['SEER', 'and End Results', 'Surveillance', 'Epidemiology'],
    ```

