/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.Bits;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntSet;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;

public class BitIntSet
implements IntSet {
    int[] bits;

    public BitIntSet(int n) {
        this.bits = Bits.makeBitSet(n);
    }

    @Override
    public void add(int n) {
        this.ensureCapacity(n);
        Bits.set(this.bits, n, true);
    }

    private void ensureCapacity(int n) {
        if (n >= Bits.getMax(this.bits)) {
            int[] nArray = Bits.makeBitSet(Math.max(n + 1, 2 * Bits.getMax(this.bits)));
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    @Override
    public void remove(int n) {
        if (n < Bits.getMax(this.bits)) {
            Bits.set(this.bits, n, false);
        }
    }

    @Override
    public boolean has(int n) {
        return n < Bits.getMax(this.bits) && Bits.get(this.bits, n);
    }

    @Override
    public void merge(IntSet intSet) {
        if (intSet instanceof BitIntSet) {
            BitIntSet bitIntSet = (BitIntSet)intSet;
            this.ensureCapacity(Bits.getMax(bitIntSet.bits) + 1);
            Bits.or(this.bits, bitIntSet.bits);
        } else if (intSet instanceof ListIntSet) {
            ListIntSet listIntSet = (ListIntSet)intSet;
            int n = listIntSet.ints.size();
            if (n > 0) {
                this.ensureCapacity(listIntSet.ints.get(n - 1));
            }
            for (int i = 0; i < listIntSet.ints.size(); ++i) {
                Bits.set(this.bits, listIntSet.ints.get(i), true);
            }
        } else {
            IntIterator intIterator = intSet.iterator();
            while (intIterator.hasNext()) {
                this.add(intIterator.next());
            }
        }
    }

    @Override
    public int elements() {
        return Bits.bitCount(this.bits);
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int idx;
            {
                this.idx = Bits.findFirst(BitIntSet.this.bits, 0);
            }

            @Override
            public boolean hasNext() {
                return this.idx >= 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int n = this.idx;
                this.idx = Bits.findFirst(BitIntSet.this.bits, this.idx + 1);
                return n;
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        int n = Bits.findFirst(this.bits, 0);
        while (n >= 0) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(n);
            n = Bits.findFirst(this.bits, n + 1);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

