/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntSet;
import java.util.ArrayList;

public abstract class RegisterAllocator {
    protected final SsaMethod ssaMeth;
    protected final InterferenceGraph interference;

    public RegisterAllocator(SsaMethod ssaMethod, InterferenceGraph interferenceGraph) {
        this.ssaMeth = ssaMethod;
        this.interference = interferenceGraph;
    }

    public abstract boolean wantsParamsMovedHigh();

    public abstract RegisterMapper allocateRegisters();

    protected final int getCategoryForSsaReg(int n) {
        SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(n);
        if (ssaInsn == null) {
            return 1;
        }
        return ssaInsn.getResult().getCategory();
    }

    protected final RegisterSpec getDefinitionSpecForSsaReg(int n) {
        SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(n);
        return ssaInsn == null ? null : ssaInsn.getResult();
    }

    protected boolean isDefinitionMoveParam(int n) {
        SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(n);
        if (ssaInsn instanceof NormalSsaInsn) {
            NormalSsaInsn normalSsaInsn = (NormalSsaInsn)ssaInsn;
            return normalSsaInsn.getOpcode().getOpcode() == 3;
        }
        return false;
    }

    protected final RegisterSpec insertMoveBefore(SsaInsn ssaInsn, RegisterSpec registerSpec) {
        SsaBasicBlock ssaBasicBlock = ssaInsn.getBlock();
        ArrayList<SsaInsn> arrayList = ssaBasicBlock.getInsns();
        int n = arrayList.indexOf(ssaInsn);
        if (n < 0) {
            throw new IllegalArgumentException("specified insn is not in this block");
        }
        if (n != arrayList.size() - 1) {
            throw new IllegalArgumentException("Adding move here not supported:" + ssaInsn.toHuman());
        }
        RegisterSpec registerSpec2 = RegisterSpec.make(this.ssaMeth.makeNewSsaReg(), registerSpec.getTypeBearer());
        SsaInsn ssaInsn2 = SsaInsn.makeFromRop(new PlainInsn(Rops.opMove(registerSpec2.getType()), SourcePosition.NO_INFO, registerSpec2, RegisterSpecList.make(registerSpec)), ssaBasicBlock);
        arrayList.add(n, ssaInsn2);
        int n2 = registerSpec2.getReg();
        IntSet intSet = ssaBasicBlock.getLiveOutRegs();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            this.interference.add(n2, intIterator.next());
        }
        RegisterSpecList registerSpecList = ssaInsn.getSources();
        int n3 = registerSpecList.size();
        for (int i = 0; i < n3; ++i) {
            this.interference.add(n2, registerSpecList.get(i).getReg());
        }
        this.ssaMeth.onInsnsChanged();
        return registerSpec2;
    }
}

