/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class SsaMethod {
    private ArrayList<SsaBasicBlock> blocks;
    private int entryBlockIndex;
    private int exitBlockIndex;
    private int registerCount;
    private int spareRegisterBase;
    private int borrowedSpareRegisters;
    private int maxLabel;
    private final int paramWidth;
    private final boolean isStatic;
    private SsaInsn[] definitionList;
    private ArrayList<SsaInsn>[] useList;
    private List<SsaInsn>[] unmodifiableUseList;
    private boolean backMode;

    public static SsaMethod newFromRopMethod(RopMethod ropMethod, int n, boolean bl) {
        SsaMethod ssaMethod = new SsaMethod(ropMethod, n, bl);
        ssaMethod.convertRopToSsaBlocks(ropMethod);
        return ssaMethod;
    }

    private SsaMethod(RopMethod ropMethod, int n, boolean bl) {
        this.paramWidth = n;
        this.isStatic = bl;
        this.backMode = false;
        this.maxLabel = ropMethod.getBlocks().getMaxLabel();
        this.spareRegisterBase = this.registerCount = ropMethod.getBlocks().getRegCount();
    }

    static BitSet bitSetFromLabelList(BasicBlockList basicBlockList, IntList intList) {
        BitSet bitSet = new BitSet(basicBlockList.size());
        int n = intList.size();
        for (int i = 0; i < n; ++i) {
            bitSet.set(basicBlockList.indexOfLabel(intList.get(i)));
        }
        return bitSet;
    }

    public static IntList indexListFromLabelList(BasicBlockList basicBlockList, IntList intList) {
        IntList intList2 = new IntList(intList.size());
        int n = intList.size();
        for (int i = 0; i < n; ++i) {
            intList2.add(basicBlockList.indexOfLabel(intList.get(i)));
        }
        return intList2;
    }

    private void convertRopToSsaBlocks(RopMethod ropMethod) {
        SsaBasicBlock ssaBasicBlock;
        int n;
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int n2 = basicBlockList.size();
        this.blocks = new ArrayList(n2 + 2);
        for (n = 0; n < n2; ++n) {
            ssaBasicBlock = SsaBasicBlock.newFromRop(ropMethod, n, this);
            this.blocks.add(ssaBasicBlock);
        }
        n = ropMethod.getBlocks().indexOfLabel(ropMethod.getFirstLabel());
        ssaBasicBlock = this.blocks.get(n).insertNewPredecessor();
        this.entryBlockIndex = ssaBasicBlock.getIndex();
        this.exitBlockIndex = -1;
    }

    void makeExitBlock() {
        if (this.exitBlockIndex >= 0) {
            throw new RuntimeException("must be called at most once");
        }
        this.exitBlockIndex = this.blocks.size();
        SsaBasicBlock ssaBasicBlock = new SsaBasicBlock(this.exitBlockIndex, this.maxLabel++, this);
        this.blocks.add(ssaBasicBlock);
        for (SsaBasicBlock ssaBasicBlock2 : this.blocks) {
            ssaBasicBlock2.exitBlockFixup(ssaBasicBlock);
        }
        if (ssaBasicBlock.getPredecessors().cardinality() == 0) {
            this.blocks.remove(this.exitBlockIndex);
            this.exitBlockIndex = -1;
            --this.maxLabel;
        }
    }

    private static SsaInsn getGoto(SsaBasicBlock ssaBasicBlock) {
        return new NormalSsaInsn(new PlainInsn(Rops.GOTO, SourcePosition.NO_INFO, null, RegisterSpecList.EMPTY), ssaBasicBlock);
    }

    public SsaBasicBlock makeNewGotoBlock() {
        int n = this.blocks.size();
        SsaBasicBlock ssaBasicBlock = new SsaBasicBlock(n, this.maxLabel++, this);
        ssaBasicBlock.getInsns().add(SsaMethod.getGoto(ssaBasicBlock));
        this.blocks.add(ssaBasicBlock);
        return ssaBasicBlock;
    }

    public int getEntryBlockIndex() {
        return this.entryBlockIndex;
    }

    public SsaBasicBlock getEntryBlock() {
        return this.blocks.get(this.entryBlockIndex);
    }

    public int getExitBlockIndex() {
        return this.exitBlockIndex;
    }

    public SsaBasicBlock getExitBlock() {
        return this.exitBlockIndex < 0 ? null : this.blocks.get(this.exitBlockIndex);
    }

    public int blockIndexToRopLabel(int n) {
        if (n < 0) {
            return -1;
        }
        return this.blocks.get(n).getRopLabel();
    }

    public int getRegCount() {
        return this.registerCount;
    }

    public int getParamWidth() {
        return this.paramWidth;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int borrowSpareRegister(int n) {
        int n2 = this.spareRegisterBase + this.borrowedSpareRegisters;
        this.borrowedSpareRegisters += n;
        this.registerCount = Math.max(this.registerCount, n2 + n);
        return n2;
    }

    public void returnSpareRegisters() {
        this.borrowedSpareRegisters = 0;
    }

    public ArrayList<SsaBasicBlock> getBlocks() {
        return this.blocks;
    }

    public int getCountReachableBlocks() {
        int n = 0;
        for (SsaBasicBlock ssaBasicBlock : this.blocks) {
            if (!ssaBasicBlock.isReachable()) continue;
            ++n;
        }
        return n;
    }

    public void computeReachability() {
        for (SsaBasicBlock ssaBasicBlock : this.blocks) {
            ssaBasicBlock.setReachable(0);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getEntryBlock());
        while (!arrayList.isEmpty()) {
            SsaBasicBlock ssaBasicBlock;
            ssaBasicBlock = (SsaBasicBlock)arrayList.remove(0);
            if (ssaBasicBlock.isReachable()) continue;
            ssaBasicBlock.setReachable(1);
            BitSet bitSet = ssaBasicBlock.getSuccessors();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                arrayList.add(this.blocks.get(n));
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    public void mapRegisters(RegisterMapper registerMapper) {
        for (SsaBasicBlock ssaBasicBlock : this.getBlocks()) {
            for (SsaInsn ssaInsn : ssaBasicBlock.getInsns()) {
                ssaInsn.mapRegisters(registerMapper);
            }
        }
        this.spareRegisterBase = this.registerCount = registerMapper.getNewRegisterCount();
    }

    public SsaInsn getDefinitionForRegister(int n) {
        if (this.backMode) {
            throw new RuntimeException("No def list in back mode");
        }
        if (this.definitionList != null) {
            return this.definitionList[n];
        }
        this.definitionList = new SsaInsn[this.getRegCount()];
        this.forEachInsn(new SsaInsn.Visitor(){

            @Override
            public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
                ((SsaMethod)SsaMethod.this).definitionList[normalSsaInsn.getResult().getReg()] = normalSsaInsn;
            }

            @Override
            public void visitPhiInsn(PhiInsn phiInsn) {
                ((SsaMethod)SsaMethod.this).definitionList[phiInsn.getResult().getReg()] = phiInsn;
            }

            @Override
            public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
                RegisterSpec registerSpec = normalSsaInsn.getResult();
                if (registerSpec != null) {
                    ((SsaMethod)SsaMethod.this).definitionList[normalSsaInsn.getResult().getReg()] = normalSsaInsn;
                }
            }
        });
        return this.definitionList[n];
    }

    private void buildUseList() {
        int n;
        if (this.backMode) {
            throw new RuntimeException("No use list in back mode");
        }
        this.useList = new ArrayList[this.registerCount];
        for (n = 0; n < this.registerCount; ++n) {
            this.useList[n] = new ArrayList();
        }
        this.forEachInsn(new SsaInsn.Visitor(){

            @Override
            public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
                this.addToUses(normalSsaInsn);
            }

            @Override
            public void visitPhiInsn(PhiInsn phiInsn) {
                this.addToUses(phiInsn);
            }

            @Override
            public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
                this.addToUses(normalSsaInsn);
            }

            private void addToUses(SsaInsn ssaInsn) {
                RegisterSpecList registerSpecList = ssaInsn.getSources();
                int n = registerSpecList.size();
                for (int i = 0; i < n; ++i) {
                    SsaMethod.this.useList[registerSpecList.get(i).getReg()].add(ssaInsn);
                }
            }
        });
        this.unmodifiableUseList = new List[this.registerCount];
        for (n = 0; n < this.registerCount; ++n) {
            this.unmodifiableUseList[n] = Collections.unmodifiableList(this.useList[n]);
        }
    }

    void onSourceChanged(SsaInsn ssaInsn, RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        int n;
        if (this.useList == null) {
            return;
        }
        if (registerSpec != null) {
            n = registerSpec.getReg();
            this.useList[n].remove(ssaInsn);
        }
        if (this.useList.length <= (n = registerSpec2.getReg())) {
            this.useList = null;
            return;
        }
        this.useList[n].add(ssaInsn);
    }

    void onSourcesChanged(SsaInsn ssaInsn, RegisterSpecList registerSpecList) {
        if (this.useList == null) {
            return;
        }
        if (registerSpecList != null) {
            this.removeFromUseList(ssaInsn, registerSpecList);
        }
        RegisterSpecList registerSpecList2 = ssaInsn.getSources();
        int n = registerSpecList2.size();
        for (int i = 0; i < n; ++i) {
            int n2 = registerSpecList2.get(i).getReg();
            this.useList[n2].add(ssaInsn);
        }
    }

    private void removeFromUseList(SsaInsn ssaInsn, RegisterSpecList registerSpecList) {
        if (registerSpecList == null) {
            return;
        }
        int n = registerSpecList.size();
        for (int i = 0; i < n; ++i) {
            if (this.useList[registerSpecList.get(i).getReg()].remove(ssaInsn)) continue;
            throw new RuntimeException("use not found");
        }
    }

    void onInsnAdded(SsaInsn ssaInsn) {
        this.onSourcesChanged(ssaInsn, null);
        this.updateOneDefinition(ssaInsn, null);
    }

    void onInsnRemoved(SsaInsn ssaInsn) {
        if (this.useList != null) {
            this.removeFromUseList(ssaInsn, ssaInsn.getSources());
        }
        RegisterSpec registerSpec = ssaInsn.getResult();
        if (this.definitionList != null && registerSpec != null) {
            this.definitionList[registerSpec.getReg()] = null;
        }
    }

    public void onInsnsChanged() {
        this.definitionList = null;
        this.useList = null;
        this.unmodifiableUseList = null;
    }

    void updateOneDefinition(SsaInsn ssaInsn, RegisterSpec registerSpec) {
        RegisterSpec registerSpec2;
        if (this.definitionList == null) {
            return;
        }
        if (registerSpec != null) {
            int n = registerSpec.getReg();
            this.definitionList[n] = null;
        }
        if ((registerSpec2 = ssaInsn.getResult()) != null) {
            int n = registerSpec2.getReg();
            if (this.definitionList[n] != null) {
                throw new RuntimeException("Duplicate add of insn");
            }
            this.definitionList[registerSpec2.getReg()] = ssaInsn;
        }
    }

    public List<SsaInsn> getUseListForRegister(int n) {
        if (this.unmodifiableUseList == null) {
            this.buildUseList();
        }
        return this.unmodifiableUseList[n];
    }

    public ArrayList<SsaInsn>[] getUseListCopy() {
        if (this.useList == null) {
            this.buildUseList();
        }
        ArrayList[] arrayListArray = new ArrayList[this.registerCount];
        for (int i = 0; i < this.registerCount; ++i) {
            arrayListArray[i] = new ArrayList<SsaInsn>(this.useList[i]);
        }
        return arrayListArray;
    }

    public boolean isRegALocal(RegisterSpec registerSpec) {
        SsaInsn ssaInsn = this.getDefinitionForRegister(registerSpec.getReg());
        if (ssaInsn == null) {
            return false;
        }
        if (ssaInsn.getLocalAssignment() != null) {
            return true;
        }
        for (SsaInsn ssaInsn2 : this.getUseListForRegister(registerSpec.getReg())) {
            Insn insn = ssaInsn2.getOriginalRopInsn();
            if (insn == null || insn.getOpcode().getOpcode() != 54) continue;
            return true;
        }
        return false;
    }

    void setNewRegCount(int n) {
        this.spareRegisterBase = this.registerCount = n;
        this.onInsnsChanged();
    }

    public int makeNewSsaReg() {
        int n = this.registerCount++;
        this.spareRegisterBase = this.registerCount;
        this.onInsnsChanged();
        return n;
    }

    public void forEachInsn(SsaInsn.Visitor visitor) {
        for (SsaBasicBlock ssaBasicBlock : this.blocks) {
            ssaBasicBlock.forEachInsn(visitor);
        }
    }

    public void forEachPhiInsn(PhiInsn.Visitor visitor) {
        for (SsaBasicBlock ssaBasicBlock : this.blocks) {
            ssaBasicBlock.forEachPhiInsn(visitor);
        }
    }

    public void forEachBlockDepthFirst(boolean bl, SsaBasicBlock.Visitor visitor) {
        SsaBasicBlock ssaBasicBlock;
        BitSet bitSet = new BitSet(this.blocks.size());
        Stack<SsaBasicBlock> stack = new Stack<SsaBasicBlock>();
        SsaBasicBlock ssaBasicBlock2 = ssaBasicBlock = bl ? this.getExitBlock() : this.getEntryBlock();
        if (ssaBasicBlock == null) {
            return;
        }
        stack.add(null);
        stack.add(ssaBasicBlock);
        while (stack.size() > 0) {
            SsaBasicBlock ssaBasicBlock3 = (SsaBasicBlock)stack.pop();
            SsaBasicBlock ssaBasicBlock4 = (SsaBasicBlock)stack.pop();
            if (bitSet.get(ssaBasicBlock3.getIndex())) continue;
            BitSet bitSet2 = bl ? ssaBasicBlock3.getPredecessors() : ssaBasicBlock3.getSuccessors();
            int n = bitSet2.nextSetBit(0);
            while (n >= 0) {
                stack.add(ssaBasicBlock3);
                stack.add(this.blocks.get(n));
                n = bitSet2.nextSetBit(n + 1);
            }
            bitSet.set(ssaBasicBlock3.getIndex());
            visitor.visitBlock(ssaBasicBlock3, ssaBasicBlock4);
        }
    }

    public void forEachBlockDepthFirstDom(SsaBasicBlock.Visitor visitor) {
        BitSet bitSet = new BitSet(this.getBlocks().size());
        Stack<SsaBasicBlock> stack = new Stack<SsaBasicBlock>();
        stack.add(this.getEntryBlock());
        while (stack.size() > 0) {
            SsaBasicBlock ssaBasicBlock = (SsaBasicBlock)stack.pop();
            ArrayList<SsaBasicBlock> arrayList = ssaBasicBlock.getDomChildren();
            if (bitSet.get(ssaBasicBlock.getIndex())) continue;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SsaBasicBlock ssaBasicBlock2 = arrayList.get(i);
                stack.add(ssaBasicBlock2);
            }
            bitSet.set(ssaBasicBlock.getIndex());
            visitor.visitBlock(ssaBasicBlock, null);
        }
    }

    public void deleteInsns(Set<SsaInsn> set) {
        for (SsaBasicBlock ssaBasicBlock : this.getBlocks()) {
            SsaInsn ssaInsn;
            int n;
            ArrayList<SsaInsn> arrayList = ssaBasicBlock.getInsns();
            for (n = arrayList.size() - 1; n >= 0; --n) {
                ssaInsn = arrayList.get(n);
                if (!set.contains(ssaInsn)) continue;
                this.onInsnRemoved(ssaInsn);
                arrayList.remove(n);
            }
            n = arrayList.size();
            SsaInsn ssaInsn2 = ssaInsn = n == 0 ? null : arrayList.get(n - 1);
            if (ssaBasicBlock == this.getExitBlock() || n != 0 && ssaInsn.getOriginalRopInsn() != null && ssaInsn.getOriginalRopInsn().getOpcode().getBranchingness() != 1) continue;
            PlainInsn plainInsn = new PlainInsn(Rops.GOTO, SourcePosition.NO_INFO, null, RegisterSpecList.EMPTY);
            arrayList.add(SsaInsn.makeFromRop(plainInsn, ssaBasicBlock));
            BitSet bitSet = ssaBasicBlock.getSuccessors();
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (n2 != ssaBasicBlock.getPrimarySuccessorIndex()) {
                    ssaBasicBlock.removeSuccessor(n2);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
    }

    public void setBackMode() {
        this.backMode = true;
        this.useList = null;
        this.definitionList = null;
    }
}

