/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Exceptions;
import com.android.dx.rop.code.FillArrayDataInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.cst.Zeroes;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaConverter;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;

public class EscapeAnalysis {
    private SsaMethod ssaMeth;
    private int regCount;
    private ArrayList<EscapeSet> latticeValues;

    private EscapeAnalysis(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
        this.regCount = ssaMethod.getRegCount();
        this.latticeValues = new ArrayList();
    }

    private int findSetIndex(RegisterSpec registerSpec) {
        int n;
        for (n = 0; n < this.latticeValues.size(); ++n) {
            EscapeSet escapeSet = this.latticeValues.get(n);
            if (!escapeSet.regSet.get(registerSpec.getReg())) continue;
            return n;
        }
        return n;
    }

    private SsaInsn getInsnForMove(SsaInsn ssaInsn) {
        int n = ssaInsn.getBlock().getPredecessors().nextSetBit(0);
        ArrayList<SsaInsn> arrayList = this.ssaMeth.getBlocks().get(n).getInsns();
        return arrayList.get(arrayList.size() - 1);
    }

    private SsaInsn getMoveForInsn(SsaInsn ssaInsn) {
        int n = ssaInsn.getBlock().getSuccessors().nextSetBit(0);
        ArrayList<SsaInsn> arrayList = this.ssaMeth.getBlocks().get(n).getInsns();
        return arrayList.get(0);
    }

    private void addEdge(EscapeSet escapeSet, EscapeSet escapeSet2) {
        if (!escapeSet2.parentSets.contains(escapeSet)) {
            escapeSet2.parentSets.add(escapeSet);
        }
        if (!escapeSet.childSets.contains(escapeSet2)) {
            escapeSet.childSets.add(escapeSet2);
        }
    }

    private void replaceNode(EscapeSet escapeSet, EscapeSet escapeSet2) {
        for (EscapeSet escapeSet3 : escapeSet2.parentSets) {
            escapeSet3.childSets.remove(escapeSet2);
            escapeSet3.childSets.add(escapeSet);
            escapeSet.parentSets.add(escapeSet3);
        }
        for (EscapeSet escapeSet3 : escapeSet2.childSets) {
            escapeSet3.parentSets.remove(escapeSet2);
            escapeSet3.parentSets.add(escapeSet);
            escapeSet.childSets.add(escapeSet3);
        }
    }

    public static void process(SsaMethod ssaMethod) {
        new EscapeAnalysis(ssaMethod).run();
    }

    private void processInsn(SsaInsn ssaInsn) {
        int n = ssaInsn.getOpcode().getOpcode();
        RegisterSpec registerSpec = ssaInsn.getResult();
        if (n == 56 && registerSpec.getTypeBearer().getBasicType() == 9) {
            EscapeSet escapeSet = this.processMoveResultPseudoInsn(ssaInsn);
            this.processRegister(registerSpec, escapeSet);
        } else if (n == 3 && registerSpec.getTypeBearer().getBasicType() == 9) {
            EscapeSet escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.NONE);
            this.latticeValues.add(escapeSet);
            this.processRegister(registerSpec, escapeSet);
        } else if (n == 55 && registerSpec.getTypeBearer().getBasicType() == 9) {
            EscapeSet escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.NONE);
            this.latticeValues.add(escapeSet);
            this.processRegister(registerSpec, escapeSet);
        }
    }

    private EscapeSet processMoveResultPseudoInsn(SsaInsn ssaInsn) {
        EscapeSet escapeSet;
        RegisterSpec registerSpec = ssaInsn.getResult();
        SsaInsn ssaInsn2 = this.getInsnForMove(ssaInsn);
        int n = ssaInsn2.getOpcode().getOpcode();
        switch (n) {
            case 5: 
            case 40: {
                escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.NONE);
                break;
            }
            case 41: 
            case 42: {
                RegisterSpec registerSpec2 = ssaInsn2.getSources().get(0);
                if (registerSpec2.getTypeBearer().isConstant()) {
                    escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.NONE);
                    escapeSet.replaceableArray = true;
                    break;
                }
                escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.GLOBAL);
                break;
            }
            case 46: {
                escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.GLOBAL);
                break;
            }
            case 38: 
            case 43: 
            case 45: {
                RegisterSpec registerSpec3 = ssaInsn2.getSources().get(0);
                int n2 = this.findSetIndex(registerSpec3);
                if (n2 != this.latticeValues.size()) {
                    EscapeSet escapeSet2 = this.latticeValues.get(n2);
                    escapeSet2.regSet.set(registerSpec.getReg());
                    return escapeSet2;
                }
                if (registerSpec3.getType() == Type.KNOWN_NULL) {
                    escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.NONE);
                    break;
                }
                escapeSet = new EscapeSet(registerSpec.getReg(), this.regCount, EscapeState.GLOBAL);
                break;
            }
            default: {
                return null;
            }
        }
        this.latticeValues.add(escapeSet);
        return escapeSet;
    }

    private void processRegister(RegisterSpec registerSpec, EscapeSet escapeSet) {
        ArrayList<RegisterSpec> arrayList = new ArrayList<RegisterSpec>();
        arrayList.add(registerSpec);
        while (!arrayList.isEmpty()) {
            int n = arrayList.size() - 1;
            RegisterSpec registerSpec2 = (RegisterSpec)arrayList.remove(n);
            List<SsaInsn> list = this.ssaMeth.getUseListForRegister(registerSpec2.getReg());
            for (SsaInsn ssaInsn : list) {
                Rop rop = ssaInsn.getOpcode();
                if (rop == null) {
                    this.processPhiUse(ssaInsn, escapeSet, arrayList);
                    continue;
                }
                this.processUse(registerSpec2, ssaInsn, escapeSet, arrayList);
            }
        }
    }

    private void processPhiUse(SsaInsn ssaInsn, EscapeSet escapeSet, ArrayList<RegisterSpec> arrayList) {
        int n = this.findSetIndex(ssaInsn.getResult());
        if (n != this.latticeValues.size()) {
            EscapeSet escapeSet2 = this.latticeValues.get(n);
            if (escapeSet2 != escapeSet) {
                escapeSet.replaceableArray = false;
                escapeSet.regSet.or(escapeSet2.regSet);
                if (escapeSet.escape.compareTo(escapeSet2.escape) < 0) {
                    escapeSet.escape = escapeSet2.escape;
                }
                this.replaceNode(escapeSet, escapeSet2);
                this.latticeValues.remove(n);
            }
        } else {
            escapeSet.regSet.set(ssaInsn.getResult().getReg());
            arrayList.add(ssaInsn.getResult());
        }
    }

    private void processUse(RegisterSpec registerSpec, SsaInsn ssaInsn, EscapeSet escapeSet, ArrayList<RegisterSpec> arrayList) {
        int n = ssaInsn.getOpcode().getOpcode();
        switch (n) {
            case 2: {
                escapeSet.regSet.set(ssaInsn.getResult().getReg());
                arrayList.add(ssaInsn.getResult());
                break;
            }
            case 7: 
            case 8: 
            case 43: {
                if (escapeSet.escape.compareTo(EscapeState.METHOD) >= 0) break;
                escapeSet.escape = EscapeState.METHOD;
                break;
            }
            case 39: {
                RegisterSpec registerSpec2 = ssaInsn.getSources().get(2);
                if (!registerSpec2.getTypeBearer().isConstant()) {
                    escapeSet.replaceableArray = false;
                }
            }
            case 47: {
                RegisterSpec registerSpec3 = ssaInsn.getSources().get(0);
                if (registerSpec3.getTypeBearer().getBasicType() != 9) break;
                escapeSet.replaceableArray = false;
                RegisterSpecList registerSpecList = ssaInsn.getSources();
                if (registerSpecList.get(0).getReg() == registerSpec.getReg()) {
                    int n2 = this.findSetIndex(registerSpecList.get(1));
                    if (n2 == this.latticeValues.size()) break;
                    EscapeSet escapeSet2 = this.latticeValues.get(n2);
                    this.addEdge(escapeSet2, escapeSet);
                    if (escapeSet.escape.compareTo(escapeSet2.escape) >= 0) break;
                    escapeSet.escape = escapeSet2.escape;
                    break;
                }
                int n3 = this.findSetIndex(registerSpecList.get(0));
                if (n3 == this.latticeValues.size()) break;
                EscapeSet escapeSet3 = this.latticeValues.get(n3);
                this.addEdge(escapeSet, escapeSet3);
                if (escapeSet3.escape.compareTo(escapeSet.escape) >= 0) break;
                escapeSet3.escape = escapeSet.escape;
                break;
            }
            case 38: {
                RegisterSpec registerSpec4 = ssaInsn.getSources().get(1);
                if (registerSpec4.getTypeBearer().isConstant()) break;
                escapeSet.replaceableArray = false;
                break;
            }
            case 48: {
                escapeSet.escape = EscapeState.GLOBAL;
                break;
            }
            case 33: 
            case 35: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                escapeSet.escape = EscapeState.INTER;
                break;
            }
        }
    }

    private void scalarReplacement() {
        for (EscapeSet escapeSet : this.latticeValues) {
            if (!escapeSet.replaceableArray || escapeSet.escape != EscapeState.NONE) continue;
            int n = escapeSet.regSet.nextSetBit(0);
            SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(n);
            SsaInsn ssaInsn2 = this.getInsnForMove(ssaInsn);
            TypeBearer typeBearer = ssaInsn2.getSources().get(0).getTypeBearer();
            int n2 = ((CstLiteralBits)typeBearer).getIntBits();
            ArrayList<RegisterSpec> arrayList = new ArrayList<RegisterSpec>(n2);
            HashSet<SsaInsn> hashSet = new HashSet<SsaInsn>();
            this.replaceDef(ssaInsn, ssaInsn2, n2, arrayList);
            hashSet.add(ssaInsn2);
            hashSet.add(ssaInsn);
            List<SsaInsn> list = this.ssaMeth.getUseListForRegister(n);
            for (SsaInsn ssaInsn3 : list) {
                this.replaceUse(ssaInsn3, ssaInsn2, arrayList, hashSet);
                hashSet.add(ssaInsn3);
            }
            this.ssaMeth.deleteInsns(hashSet);
            this.ssaMeth.onInsnsChanged();
            SsaConverter.updateSsaMethod(this.ssaMeth, this.regCount);
            this.movePropagate();
        }
    }

    private void replaceDef(SsaInsn ssaInsn, SsaInsn ssaInsn2, int n, ArrayList<RegisterSpec> arrayList) {
        Type type = ssaInsn.getResult().getType();
        for (int i = 0; i < n; ++i) {
            Constant constant = Zeroes.zeroFor(type.getComponentType());
            TypedConstant typedConstant = (TypedConstant)constant;
            RegisterSpec registerSpec = RegisterSpec.make(this.ssaMeth.makeNewSsaReg(), typedConstant);
            arrayList.add(registerSpec);
            this.insertPlainInsnBefore(ssaInsn, RegisterSpecList.EMPTY, registerSpec, 5, constant);
        }
    }

    private void replaceUse(SsaInsn ssaInsn, SsaInsn ssaInsn2, ArrayList<RegisterSpec> arrayList, HashSet<SsaInsn> hashSet) {
        int n = arrayList.size();
        switch (ssaInsn.getOpcode().getOpcode()) {
            case 38: {
                SsaInsn ssaInsn3 = this.getMoveForInsn(ssaInsn);
                RegisterSpecList registerSpecList = ssaInsn.getSources();
                CstLiteralBits cstLiteralBits = (CstLiteralBits)registerSpecList.get(1).getTypeBearer();
                int n2 = cstLiteralBits.getIntBits();
                if (n2 < n) {
                    RegisterSpec registerSpec = arrayList.get(n2);
                    RegisterSpec registerSpec2 = registerSpec.withReg(ssaInsn3.getResult().getReg());
                    this.insertPlainInsnBefore(ssaInsn3, RegisterSpecList.make(registerSpec), registerSpec2, 2, null);
                } else {
                    this.insertExceptionThrow(ssaInsn3, registerSpecList.get(1), hashSet);
                    hashSet.add(ssaInsn3.getBlock().getInsns().get(2));
                }
                hashSet.add(ssaInsn3);
                break;
            }
            case 39: {
                RegisterSpecList registerSpecList = ssaInsn.getSources();
                CstLiteralBits cstLiteralBits = (CstLiteralBits)registerSpecList.get(2).getTypeBearer();
                int n3 = cstLiteralBits.getIntBits();
                if (n3 < n) {
                    RegisterSpec registerSpec = registerSpecList.get(0);
                    RegisterSpec registerSpec3 = registerSpec.withReg(arrayList.get(n3).getReg());
                    this.insertPlainInsnBefore(ssaInsn, RegisterSpecList.make(registerSpec), registerSpec3, 2, null);
                    arrayList.set(n3, registerSpec3.withSimpleType());
                    break;
                }
                this.insertExceptionThrow(ssaInsn, registerSpecList.get(2), hashSet);
                break;
            }
            case 34: {
                TypeBearer typeBearer = ssaInsn2.getSources().get(0).getTypeBearer();
                SsaInsn ssaInsn4 = this.getMoveForInsn(ssaInsn);
                this.insertPlainInsnBefore(ssaInsn4, RegisterSpecList.EMPTY, ssaInsn4.getResult(), 5, (Constant)((Object)typeBearer));
                hashSet.add(ssaInsn4);
                break;
            }
            case 54: {
                break;
            }
            case 57: {
                Insn insn = ssaInsn.getOriginalRopInsn();
                FillArrayDataInsn fillArrayDataInsn = (FillArrayDataInsn)insn;
                ArrayList<Constant> arrayList2 = fillArrayDataInsn.getInitValues();
                for (int i = 0; i < n; ++i) {
                    RegisterSpec registerSpec = RegisterSpec.make(arrayList.get(i).getReg(), (TypeBearer)((Object)arrayList2.get(i)));
                    this.insertPlainInsnBefore(ssaInsn, RegisterSpecList.EMPTY, registerSpec, 5, arrayList2.get(i));
                    arrayList.set(i, registerSpec);
                }
                break;
            }
        }
    }

    private void movePropagate() {
        for (int i = 0; i < this.ssaMeth.getRegCount(); ++i) {
            SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(i);
            if (ssaInsn == null || ssaInsn.getOpcode() == null || ssaInsn.getOpcode().getOpcode() != 2) continue;
            ArrayList<SsaInsn>[] arrayListArray = this.ssaMeth.getUseListCopy();
            final RegisterSpec registerSpec = ssaInsn.getSources().get(0);
            final RegisterSpec registerSpec2 = ssaInsn.getResult();
            if (registerSpec.getReg() < this.regCount && registerSpec2.getReg() < this.regCount) continue;
            RegisterMapper registerMapper = new RegisterMapper(){

                @Override
                public int getNewRegisterCount() {
                    return EscapeAnalysis.this.ssaMeth.getRegCount();
                }

                @Override
                public RegisterSpec map(RegisterSpec registerSpec3) {
                    if (registerSpec3.getReg() == registerSpec2.getReg()) {
                        return registerSpec;
                    }
                    return registerSpec3;
                }
            };
            for (SsaInsn ssaInsn2 : arrayListArray[registerSpec2.getReg()]) {
                ssaInsn2.mapSourceRegisters(registerMapper);
            }
        }
    }

    private void run() {
        this.ssaMeth.forEachBlockDepthFirstDom(new SsaBasicBlock.Visitor(){

            @Override
            public void visitBlock(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
                ssaBasicBlock.forEachInsn(new SsaInsn.Visitor(){

                    @Override
                    public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
                    }

                    @Override
                    public void visitPhiInsn(PhiInsn phiInsn) {
                    }

                    @Override
                    public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
                        EscapeAnalysis.this.processInsn(normalSsaInsn);
                    }
                });
            }
        });
        for (EscapeSet escapeSet : this.latticeValues) {
            if (escapeSet.escape == EscapeState.NONE) continue;
            for (EscapeSet escapeSet2 : escapeSet.childSets) {
                if (escapeSet.escape.compareTo(escapeSet2.escape) <= 0) continue;
                escapeSet2.escape = escapeSet.escape;
            }
        }
        this.scalarReplacement();
    }

    private void insertExceptionThrow(SsaInsn ssaInsn, RegisterSpec registerSpec, HashSet<SsaInsn> hashSet) {
        CstType cstType = new CstType(Exceptions.TYPE_ArrayIndexOutOfBoundsException);
        this.insertThrowingInsnBefore(ssaInsn, RegisterSpecList.EMPTY, null, 40, cstType);
        SsaBasicBlock ssaBasicBlock = ssaInsn.getBlock();
        SsaBasicBlock ssaBasicBlock2 = ssaBasicBlock.insertNewSuccessor(ssaBasicBlock.getPrimarySuccessor());
        SsaInsn ssaInsn2 = ssaBasicBlock2.getInsns().get(0);
        RegisterSpec registerSpec2 = RegisterSpec.make(this.ssaMeth.makeNewSsaReg(), cstType);
        this.insertPlainInsnBefore(ssaInsn2, RegisterSpecList.EMPTY, registerSpec2, 56, null);
        SsaBasicBlock ssaBasicBlock3 = ssaBasicBlock2.insertNewSuccessor(ssaBasicBlock2.getPrimarySuccessor());
        SsaInsn ssaInsn3 = ssaBasicBlock3.getInsns().get(0);
        CstNat cstNat = new CstNat(new CstString("<init>"), new CstString("(I)V"));
        CstMethodRef cstMethodRef = new CstMethodRef(cstType, cstNat);
        this.insertThrowingInsnBefore(ssaInsn3, RegisterSpecList.make(registerSpec2, registerSpec), null, 52, cstMethodRef);
        hashSet.add(ssaInsn3);
        SsaBasicBlock ssaBasicBlock4 = ssaBasicBlock3.insertNewSuccessor(ssaBasicBlock3.getPrimarySuccessor());
        SsaInsn ssaInsn4 = ssaBasicBlock4.getInsns().get(0);
        this.insertThrowingInsnBefore(ssaInsn4, RegisterSpecList.make(registerSpec2), null, 35, null);
        ssaBasicBlock4.replaceSuccessor(ssaBasicBlock4.getPrimarySuccessorIndex(), this.ssaMeth.getExitBlock().getIndex());
        hashSet.add(ssaInsn4);
    }

    private void insertPlainInsnBefore(SsaInsn ssaInsn, RegisterSpecList registerSpecList, RegisterSpec registerSpec, int n, Constant constant) {
        Insn insn = ssaInsn.getOriginalRopInsn();
        Rop rop = n == 56 ? Rops.opMoveResultPseudo(registerSpec.getType()) : Rops.ropFor(n, registerSpec, registerSpecList, constant);
        Insn insn2 = constant == null ? new PlainInsn(rop, insn.getPosition(), registerSpec, registerSpecList) : new PlainCstInsn(rop, insn.getPosition(), registerSpec, registerSpecList, constant);
        NormalSsaInsn normalSsaInsn = new NormalSsaInsn(insn2, ssaInsn.getBlock());
        ArrayList<SsaInsn> arrayList = ssaInsn.getBlock().getInsns();
        arrayList.add(arrayList.lastIndexOf(ssaInsn), normalSsaInsn);
        this.ssaMeth.onInsnAdded(normalSsaInsn);
    }

    private void insertThrowingInsnBefore(SsaInsn ssaInsn, RegisterSpecList registerSpecList, RegisterSpec registerSpec, int n, Constant constant) {
        Insn insn = ssaInsn.getOriginalRopInsn();
        Rop rop = Rops.ropFor(n, registerSpec, registerSpecList, constant);
        Insn insn2 = constant == null ? new ThrowingInsn(rop, insn.getPosition(), registerSpecList, StdTypeList.EMPTY) : new ThrowingCstInsn(rop, insn.getPosition(), registerSpecList, StdTypeList.EMPTY, constant);
        NormalSsaInsn normalSsaInsn = new NormalSsaInsn(insn2, ssaInsn.getBlock());
        ArrayList<SsaInsn> arrayList = ssaInsn.getBlock().getInsns();
        arrayList.add(arrayList.lastIndexOf(ssaInsn), normalSsaInsn);
        this.ssaMeth.onInsnAdded(normalSsaInsn);
    }

    public static enum EscapeState {
        TOP,
        NONE,
        METHOD,
        INTER,
        GLOBAL;

    }

    static class EscapeSet {
        BitSet regSet;
        EscapeState escape;
        ArrayList<EscapeSet> childSets;
        ArrayList<EscapeSet> parentSets;
        boolean replaceableArray;

        EscapeSet(int n, int n2, EscapeState escapeState) {
            this.regSet = new BitSet(n2);
            this.regSet.set(n);
            this.escape = escapeState;
            this.childSets = new ArrayList();
            this.parentSets = new ArrayList();
            this.replaceableArray = false;
        }
    }
}

