/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.cst.CstString;
import com.android.dx.util.Hex;

public final class SourcePosition {
    public static final SourcePosition NO_INFO = new SourcePosition(null, -1, -1);
    private final CstString sourceFile;
    private final int address;
    private final int line;

    public SourcePosition(CstString cstString, int n, int n2) {
        if (n < -1) {
            throw new IllegalArgumentException("address < -1");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("line < -1");
        }
        this.sourceFile = cstString;
        this.address = n;
        this.line = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.sourceFile != null) {
            stringBuffer.append(this.sourceFile.toHuman());
            stringBuffer.append(":");
        }
        if (this.line >= 0) {
            stringBuffer.append(this.line);
        }
        stringBuffer.append('@');
        if (this.address < 0) {
            stringBuffer.append("????");
        } else {
            stringBuffer.append(Hex.u2(this.address));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourcePosition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SourcePosition sourcePosition = (SourcePosition)object;
        return this.address == sourcePosition.address && this.sameLineAndFile(sourcePosition);
    }

    public int hashCode() {
        return this.sourceFile.hashCode() + this.address + this.line;
    }

    public boolean sameLine(SourcePosition sourcePosition) {
        return this.line == sourcePosition.line;
    }

    public boolean sameLineAndFile(SourcePosition sourcePosition) {
        return this.line == sourcePosition.line && (this.sourceFile == sourcePosition.sourceFile || this.sourceFile != null && this.sourceFile.equals(sourcePosition.sourceFile));
    }

    public CstString getSourceFile() {
        return this.sourceFile;
    }

    public int getAddress() {
        return this.address;
    }

    public int getLine() {
        return this.line;
    }
}

