/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

public final class Opcodes {
    public static final int SPECIAL_FORMAT = -1;
    public static final int NO_NEXT = -1;
    public static final int MIN_VALUE = -1;
    public static final int MAX_VALUE = 65535;
    public static final int NOP = 0;
    public static final int MOVE = 1;
    public static final int MOVE_FROM16 = 2;
    public static final int MOVE_16 = 3;
    public static final int MOVE_WIDE = 4;
    public static final int MOVE_WIDE_FROM16 = 5;
    public static final int MOVE_WIDE_16 = 6;
    public static final int MOVE_OBJECT = 7;
    public static final int MOVE_OBJECT_FROM16 = 8;
    public static final int MOVE_OBJECT_16 = 9;
    public static final int MOVE_RESULT = 10;
    public static final int MOVE_RESULT_WIDE = 11;
    public static final int MOVE_RESULT_OBJECT = 12;
    public static final int MOVE_EXCEPTION = 13;
    public static final int RETURN_VOID = 14;
    public static final int RETURN = 15;
    public static final int RETURN_WIDE = 16;
    public static final int RETURN_OBJECT = 17;
    public static final int CONST_4 = 18;
    public static final int CONST_16 = 19;
    public static final int CONST = 20;
    public static final int CONST_HIGH16 = 21;
    public static final int CONST_WIDE_16 = 22;
    public static final int CONST_WIDE_32 = 23;
    public static final int CONST_WIDE = 24;
    public static final int CONST_WIDE_HIGH16 = 25;
    public static final int CONST_STRING = 26;
    public static final int CONST_STRING_JUMBO = 27;
    public static final int CONST_CLASS = 28;
    public static final int MONITOR_ENTER = 29;
    public static final int MONITOR_EXIT = 30;
    public static final int CHECK_CAST = 31;
    public static final int INSTANCE_OF = 32;
    public static final int ARRAY_LENGTH = 33;
    public static final int NEW_INSTANCE = 34;
    public static final int NEW_ARRAY = 35;
    public static final int FILLED_NEW_ARRAY = 36;
    public static final int FILLED_NEW_ARRAY_RANGE = 37;
    public static final int FILL_ARRAY_DATA = 38;
    public static final int THROW = 39;
    public static final int GOTO = 40;
    public static final int GOTO_16 = 41;
    public static final int GOTO_32 = 42;
    public static final int PACKED_SWITCH = 43;
    public static final int SPARSE_SWITCH = 44;
    public static final int CMPL_FLOAT = 45;
    public static final int CMPG_FLOAT = 46;
    public static final int CMPL_DOUBLE = 47;
    public static final int CMPG_DOUBLE = 48;
    public static final int CMP_LONG = 49;
    public static final int IF_EQ = 50;
    public static final int IF_NE = 51;
    public static final int IF_LT = 52;
    public static final int IF_GE = 53;
    public static final int IF_GT = 54;
    public static final int IF_LE = 55;
    public static final int IF_EQZ = 56;
    public static final int IF_NEZ = 57;
    public static final int IF_LTZ = 58;
    public static final int IF_GEZ = 59;
    public static final int IF_GTZ = 60;
    public static final int IF_LEZ = 61;
    public static final int AGET = 68;
    public static final int AGET_WIDE = 69;
    public static final int AGET_OBJECT = 70;
    public static final int AGET_BOOLEAN = 71;
    public static final int AGET_BYTE = 72;
    public static final int AGET_CHAR = 73;
    public static final int AGET_SHORT = 74;
    public static final int APUT = 75;
    public static final int APUT_WIDE = 76;
    public static final int APUT_OBJECT = 77;
    public static final int APUT_BOOLEAN = 78;
    public static final int APUT_BYTE = 79;
    public static final int APUT_CHAR = 80;
    public static final int APUT_SHORT = 81;
    public static final int IGET = 82;
    public static final int IGET_WIDE = 83;
    public static final int IGET_OBJECT = 84;
    public static final int IGET_BOOLEAN = 85;
    public static final int IGET_BYTE = 86;
    public static final int IGET_CHAR = 87;
    public static final int IGET_SHORT = 88;
    public static final int IPUT = 89;
    public static final int IPUT_WIDE = 90;
    public static final int IPUT_OBJECT = 91;
    public static final int IPUT_BOOLEAN = 92;
    public static final int IPUT_BYTE = 93;
    public static final int IPUT_CHAR = 94;
    public static final int IPUT_SHORT = 95;
    public static final int SGET = 96;
    public static final int SGET_WIDE = 97;
    public static final int SGET_OBJECT = 98;
    public static final int SGET_BOOLEAN = 99;
    public static final int SGET_BYTE = 100;
    public static final int SGET_CHAR = 101;
    public static final int SGET_SHORT = 102;
    public static final int SPUT = 103;
    public static final int SPUT_WIDE = 104;
    public static final int SPUT_OBJECT = 105;
    public static final int SPUT_BOOLEAN = 106;
    public static final int SPUT_BYTE = 107;
    public static final int SPUT_CHAR = 108;
    public static final int SPUT_SHORT = 109;
    public static final int INVOKE_VIRTUAL = 110;
    public static final int INVOKE_SUPER = 111;
    public static final int INVOKE_DIRECT = 112;
    public static final int INVOKE_STATIC = 113;
    public static final int INVOKE_INTERFACE = 114;
    public static final int INVOKE_VIRTUAL_RANGE = 116;
    public static final int INVOKE_SUPER_RANGE = 117;
    public static final int INVOKE_DIRECT_RANGE = 118;
    public static final int INVOKE_STATIC_RANGE = 119;
    public static final int INVOKE_INTERFACE_RANGE = 120;
    public static final int NEG_INT = 123;
    public static final int NOT_INT = 124;
    public static final int NEG_LONG = 125;
    public static final int NOT_LONG = 126;
    public static final int NEG_FLOAT = 127;
    public static final int NEG_DOUBLE = 128;
    public static final int INT_TO_LONG = 129;
    public static final int INT_TO_FLOAT = 130;
    public static final int INT_TO_DOUBLE = 131;
    public static final int LONG_TO_INT = 132;
    public static final int LONG_TO_FLOAT = 133;
    public static final int LONG_TO_DOUBLE = 134;
    public static final int FLOAT_TO_INT = 135;
    public static final int FLOAT_TO_LONG = 136;
    public static final int FLOAT_TO_DOUBLE = 137;
    public static final int DOUBLE_TO_INT = 138;
    public static final int DOUBLE_TO_LONG = 139;
    public static final int DOUBLE_TO_FLOAT = 140;
    public static final int INT_TO_BYTE = 141;
    public static final int INT_TO_CHAR = 142;
    public static final int INT_TO_SHORT = 143;
    public static final int ADD_INT = 144;
    public static final int SUB_INT = 145;
    public static final int MUL_INT = 146;
    public static final int DIV_INT = 147;
    public static final int REM_INT = 148;
    public static final int AND_INT = 149;
    public static final int OR_INT = 150;
    public static final int XOR_INT = 151;
    public static final int SHL_INT = 152;
    public static final int SHR_INT = 153;
    public static final int USHR_INT = 154;
    public static final int ADD_LONG = 155;
    public static final int SUB_LONG = 156;
    public static final int MUL_LONG = 157;
    public static final int DIV_LONG = 158;
    public static final int REM_LONG = 159;
    public static final int AND_LONG = 160;
    public static final int OR_LONG = 161;
    public static final int XOR_LONG = 162;
    public static final int SHL_LONG = 163;
    public static final int SHR_LONG = 164;
    public static final int USHR_LONG = 165;
    public static final int ADD_FLOAT = 166;
    public static final int SUB_FLOAT = 167;
    public static final int MUL_FLOAT = 168;
    public static final int DIV_FLOAT = 169;
    public static final int REM_FLOAT = 170;
    public static final int ADD_DOUBLE = 171;
    public static final int SUB_DOUBLE = 172;
    public static final int MUL_DOUBLE = 173;
    public static final int DIV_DOUBLE = 174;
    public static final int REM_DOUBLE = 175;
    public static final int ADD_INT_2ADDR = 176;
    public static final int SUB_INT_2ADDR = 177;
    public static final int MUL_INT_2ADDR = 178;
    public static final int DIV_INT_2ADDR = 179;
    public static final int REM_INT_2ADDR = 180;
    public static final int AND_INT_2ADDR = 181;
    public static final int OR_INT_2ADDR = 182;
    public static final int XOR_INT_2ADDR = 183;
    public static final int SHL_INT_2ADDR = 184;
    public static final int SHR_INT_2ADDR = 185;
    public static final int USHR_INT_2ADDR = 186;
    public static final int ADD_LONG_2ADDR = 187;
    public static final int SUB_LONG_2ADDR = 188;
    public static final int MUL_LONG_2ADDR = 189;
    public static final int DIV_LONG_2ADDR = 190;
    public static final int REM_LONG_2ADDR = 191;
    public static final int AND_LONG_2ADDR = 192;
    public static final int OR_LONG_2ADDR = 193;
    public static final int XOR_LONG_2ADDR = 194;
    public static final int SHL_LONG_2ADDR = 195;
    public static final int SHR_LONG_2ADDR = 196;
    public static final int USHR_LONG_2ADDR = 197;
    public static final int ADD_FLOAT_2ADDR = 198;
    public static final int SUB_FLOAT_2ADDR = 199;
    public static final int MUL_FLOAT_2ADDR = 200;
    public static final int DIV_FLOAT_2ADDR = 201;
    public static final int REM_FLOAT_2ADDR = 202;
    public static final int ADD_DOUBLE_2ADDR = 203;
    public static final int SUB_DOUBLE_2ADDR = 204;
    public static final int MUL_DOUBLE_2ADDR = 205;
    public static final int DIV_DOUBLE_2ADDR = 206;
    public static final int REM_DOUBLE_2ADDR = 207;
    public static final int ADD_INT_LIT16 = 208;
    public static final int RSUB_INT = 209;
    public static final int MUL_INT_LIT16 = 210;
    public static final int DIV_INT_LIT16 = 211;
    public static final int REM_INT_LIT16 = 212;
    public static final int AND_INT_LIT16 = 213;
    public static final int OR_INT_LIT16 = 214;
    public static final int XOR_INT_LIT16 = 215;
    public static final int ADD_INT_LIT8 = 216;
    public static final int RSUB_INT_LIT8 = 217;
    public static final int MUL_INT_LIT8 = 218;
    public static final int DIV_INT_LIT8 = 219;
    public static final int REM_INT_LIT8 = 220;
    public static final int AND_INT_LIT8 = 221;
    public static final int OR_INT_LIT8 = 222;
    public static final int XOR_INT_LIT8 = 223;
    public static final int SHL_INT_LIT8 = 224;
    public static final int SHR_INT_LIT8 = 225;
    public static final int USHR_INT_LIT8 = 226;
    public static final int PACKED_SWITCH_PAYLOAD = 256;
    public static final int SPARSE_SWITCH_PAYLOAD = 512;
    public static final int FILL_ARRAY_DATA_PAYLOAD = 768;

    private Opcodes() {
    }

    public static boolean isValidShape(int n) {
        if (n < -1) {
            return false;
        }
        if (n == -1) {
            return true;
        }
        int n2 = n & 0xFF;
        if (n2 == 0 || n2 == 255) {
            return true;
        }
        return (n & 0xFF00) == 0;
    }

    public static int extractOpcodeFromUnit(int n) {
        int n2 = n & 0xFF;
        return n2 == 0 || n2 == 255 ? n : n2;
    }
}

