/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.AnnotationSetItem;
import com.android.dx.dex.file.AnnotationSetRefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.UniformListItem;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import com.android.dx.util.ToHuman;
import java.util.ArrayList;

public final class ParameterAnnotationStruct
implements ToHuman,
Comparable<ParameterAnnotationStruct> {
    private final CstMethodRef method;
    private final AnnotationsList annotationsList;
    private final UniformListItem<AnnotationSetRefItem> annotationsItem;

    public ParameterAnnotationStruct(CstMethodRef cstMethodRef, AnnotationsList annotationsList, DexFile dexFile) {
        if (cstMethodRef == null) {
            throw new NullPointerException("method == null");
        }
        if (annotationsList == null) {
            throw new NullPointerException("annotationsList == null");
        }
        this.method = cstMethodRef;
        this.annotationsList = annotationsList;
        int n = annotationsList.size();
        ArrayList<AnnotationSetRefItem> arrayList = new ArrayList<AnnotationSetRefItem>(n);
        for (int i = 0; i < n; ++i) {
            Annotations annotations = annotationsList.get(i);
            AnnotationSetItem annotationSetItem = new AnnotationSetItem(annotations, dexFile);
            arrayList.add(new AnnotationSetRefItem(annotationSetItem));
        }
        this.annotationsItem = new UniformListItem(ItemType.TYPE_ANNOTATION_SET_REF_LIST, arrayList);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParameterAnnotationStruct)) {
            return false;
        }
        return this.method.equals(((ParameterAnnotationStruct)object).method);
    }

    @Override
    public int compareTo(ParameterAnnotationStruct parameterAnnotationStruct) {
        return this.method.compareTo(parameterAnnotationStruct.method);
    }

    public void addContents(DexFile dexFile) {
        MethodIdsSection methodIdsSection = dexFile.getMethodIds();
        MixedItemSection mixedItemSection = dexFile.getWordData();
        methodIdsSection.intern(this.method);
        mixedItemSection.add(this.annotationsItem);
    }

    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = dexFile.getMethodIds().indexOf(this.method);
        int n2 = this.annotationsItem.getAbsoluteOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, "    " + this.method.toHuman());
            annotatedOutput.annotate(4, "      method_idx:      " + Hex.u4(n));
            annotatedOutput.annotate(4, "      annotations_off: " + Hex.u4(n2));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
    }

    @Override
    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method.toHuman());
        stringBuilder.append(": ");
        boolean bl = true;
        for (AnnotationSetRefItem annotationSetRefItem : this.annotationsItem.getItems()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(annotationSetRefItem.toHuman());
        }
        return stringBuilder.toString();
    }

    public CstMethodRef getMethod() {
        return this.method;
    }

    public AnnotationsList getAnnotationsList() {
        return this.annotationsList;
    }
}

