/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IdItem;
import com.android.dx.dex.file.StringIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public abstract class MemberIdItem
extends IdItem {
    private final CstMemberRef cst;

    public MemberIdItem(CstMemberRef cstMemberRef) {
        super(cstMemberRef.getDefiningClass());
        this.cst = cstMemberRef;
    }

    @Override
    public int writeSize() {
        return 8;
    }

    @Override
    public void addContents(DexFile dexFile) {
        super.addContents(dexFile);
        StringIdsSection stringIdsSection = dexFile.getStringIds();
        stringIdsSection.intern(this.getRef().getNat().getName());
    }

    @Override
    public final void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        StringIdsSection stringIdsSection = dexFile.getStringIds();
        CstNat cstNat = this.cst.getNat();
        int n = typeIdsSection.indexOf(this.getDefiningClass());
        int n2 = stringIdsSection.indexOf(cstNat.getName());
        int n3 = this.getTypoidIdx(dexFile);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, this.indexString() + ' ' + this.cst.toHuman());
            annotatedOutput.annotate(2, "  class_idx: " + Hex.u2(n));
            annotatedOutput.annotate(2, String.format("  %-10s %s", this.getTypoidName() + ':', Hex.u2(n3)));
            annotatedOutput.annotate(4, "  name_idx:  " + Hex.u4(n2));
        }
        annotatedOutput.writeShort(n);
        annotatedOutput.writeShort(n3);
        annotatedOutput.writeInt(n2);
    }

    protected abstract int getTypoidIdx(DexFile var1);

    protected abstract String getTypoidName();

    public final CstMemberRef getRef() {
        return this.cst;
    }
}

