/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.LocalSnapshot;
import com.android.dx.dex.code.LocalStart;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.FixedSizeList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public final class LocalList
extends FixedSizeList {
    public static final LocalList EMPTY = new LocalList(0);
    private static final boolean DEBUG = false;

    public LocalList(int n) {
        super(n);
    }

    public Entry get(int n) {
        return (Entry)this.get0(n);
    }

    public void set(int n, Entry entry) {
        this.set0(n, entry);
    }

    public void debugPrint(PrintStream printStream, String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            printStream.print(string);
            printStream.println(this.get(i));
        }
    }

    public static LocalList make(DalvInsnList dalvInsnList) {
        int n = dalvInsnList.size();
        MakeState makeState = new MakeState(n);
        for (int i = 0; i < n; ++i) {
            Object object;
            DalvInsn dalvInsn = dalvInsnList.get(i);
            if (dalvInsn instanceof LocalSnapshot) {
                object = ((LocalSnapshot)dalvInsn).getLocals();
                makeState.snapshot(dalvInsn.getAddress(), (RegisterSpecSet)object);
                continue;
            }
            if (!(dalvInsn instanceof LocalStart)) continue;
            object = ((LocalStart)dalvInsn).getLocal();
            makeState.startLocal(dalvInsn.getAddress(), (RegisterSpec)object);
        }
        LocalList localList = makeState.finish();
        return localList;
    }

    private static void debugVerify(LocalList localList) {
        try {
            LocalList.debugVerify0(localList);
        }
        catch (RuntimeException runtimeException) {
            int n = localList.size();
            for (int i = 0; i < n; ++i) {
                System.err.println(localList.get(i));
            }
            throw runtimeException;
        }
    }

    private static void debugVerify0(LocalList localList) {
        int n = localList.size();
        Entry[] entryArray = new Entry[65536];
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry entry2 = localList.get(i);
            int n2 = entry2.getRegister();
            if (entry2.isStart()) {
                Entry entry3 = entryArray[n2];
                if (entry3 != null && entry2.matches(entry3)) {
                    throw new RuntimeException("redundant start at " + Integer.toHexString(entry2.getAddress()) + ": got " + entry2 + "; had " + entry3);
                }
                entryArray[n2] = entry2;
                continue;
            }
            if (entryArray[n2] == null) {
                throw new RuntimeException("redundant end at " + Integer.toHexString(entry2.getAddress()));
            }
            int n3 = entry2.getAddress();
            boolean bl = false;
            for (int j = i + 1; j < n && (entry = localList.get(j)).getAddress() == n3; ++j) {
                if (entry.getRegisterSpec().getReg() != n2) continue;
                if (entry.isStart()) {
                    if (entry2.getDisposition() != Disposition.END_REPLACED) {
                        throw new RuntimeException("improperly marked end at " + Integer.toHexString(n3));
                    }
                    bl = true;
                    continue;
                }
                throw new RuntimeException("redundant end at " + Integer.toHexString(n3));
            }
            if (!bl && entry2.getDisposition() == Disposition.END_REPLACED) {
                throw new RuntimeException("improper end replacement claim at " + Integer.toHexString(n3));
            }
            entryArray[n2] = null;
        }
    }

    public static class MakeState {
        private final ArrayList<Entry> result;
        private int nullResultCount;
        private RegisterSpecSet regs;
        private int[] endIndices;
        private int lastAddress;

        public MakeState(int n) {
            this.result = new ArrayList(n);
            this.nullResultCount = 0;
            this.regs = null;
            this.endIndices = null;
            this.lastAddress = 0;
        }

        private void aboutToProcess(int n, int n2) {
            boolean bl;
            boolean bl2 = bl = this.endIndices == null;
            if (n == this.lastAddress && !bl) {
                return;
            }
            if (n < this.lastAddress) {
                throw new RuntimeException("shouldn't happen");
            }
            if (bl || n2 >= this.endIndices.length) {
                int n3 = n2 + 1;
                RegisterSpecSet registerSpecSet = new RegisterSpecSet(n3);
                int[] nArray = new int[n3];
                Arrays.fill(nArray, -1);
                if (!bl) {
                    registerSpecSet.putAll(this.regs);
                    System.arraycopy(this.endIndices, 0, nArray, 0, this.endIndices.length);
                }
                this.regs = registerSpecSet;
                this.endIndices = nArray;
            }
        }

        public void snapshot(int n, RegisterSpecSet registerSpecSet) {
            int n2 = registerSpecSet.getMaxSize();
            this.aboutToProcess(n, n2 - 1);
            for (int i = 0; i < n2; ++i) {
                RegisterSpec registerSpec = this.regs.get(i);
                RegisterSpec registerSpec2 = MakeState.filterSpec(registerSpecSet.get(i));
                if (registerSpec == null) {
                    if (registerSpec2 == null) continue;
                    this.startLocal(n, registerSpec2);
                    continue;
                }
                if (registerSpec2 == null) {
                    this.endLocal(n, registerSpec);
                    continue;
                }
                if (registerSpec2.equalsUsingSimpleType(registerSpec)) continue;
                this.endLocal(n, registerSpec);
                this.startLocal(n, registerSpec2);
            }
        }

        public void startLocal(int n, RegisterSpec registerSpec) {
            Comparable<Entry> comparable;
            int n2 = registerSpec.getReg();
            registerSpec = MakeState.filterSpec(registerSpec);
            this.aboutToProcess(n, n2);
            RegisterSpec registerSpec2 = this.regs.get(n2);
            if (registerSpec.equalsUsingSimpleType(registerSpec2)) {
                return;
            }
            RegisterSpec registerSpec3 = this.regs.findMatchingLocal(registerSpec);
            if (registerSpec3 != null) {
                this.addOrUpdateEnd(n, Disposition.END_MOVED, registerSpec3);
            }
            int n3 = this.endIndices[n2];
            if (registerSpec2 != null) {
                this.add(n, Disposition.END_REPLACED, registerSpec2);
            } else if (n3 >= 0 && ((Entry)(comparable = this.result.get(n3))).getAddress() == n) {
                if (((Entry)comparable).matches(registerSpec)) {
                    this.result.set(n3, null);
                    ++this.nullResultCount;
                    this.regs.put(registerSpec);
                    this.endIndices[n2] = -1;
                    return;
                }
                comparable = ((Entry)comparable).withDisposition(Disposition.END_REPLACED);
                this.result.set(n3, (Entry)comparable);
            }
            if (n2 > 0 && (comparable = this.regs.get(n2 - 1)) != null && ((RegisterSpec)comparable).isCategory2()) {
                this.addOrUpdateEnd(n, Disposition.END_CLOBBERED_BY_NEXT, (RegisterSpec)comparable);
            }
            if (registerSpec.isCategory2() && (comparable = this.regs.get(n2 + 1)) != null) {
                this.addOrUpdateEnd(n, Disposition.END_CLOBBERED_BY_PREV, (RegisterSpec)comparable);
            }
            this.add(n, Disposition.START, registerSpec);
        }

        public void endLocal(int n, RegisterSpec registerSpec) {
            this.endLocal(n, registerSpec, Disposition.END_SIMPLY);
        }

        public void endLocal(int n, RegisterSpec registerSpec, Disposition disposition) {
            int n2 = registerSpec.getReg();
            registerSpec = MakeState.filterSpec(registerSpec);
            this.aboutToProcess(n, n2);
            int n3 = this.endIndices[n2];
            if (n3 >= 0) {
                return;
            }
            if (this.checkForEmptyRange(n, registerSpec)) {
                return;
            }
            this.add(n, disposition, registerSpec);
        }

        private boolean checkForEmptyRange(int n, RegisterSpec registerSpec) {
            Entry entry;
            int n2;
            for (n2 = this.result.size() - 1; n2 >= 0; --n2) {
                entry = this.result.get(n2);
                if (entry == null) continue;
                if (entry.getAddress() != n) {
                    return false;
                }
                if (entry.matches(registerSpec)) break;
            }
            this.regs.remove(registerSpec);
            this.result.set(n2, null);
            ++this.nullResultCount;
            int n3 = registerSpec.getReg();
            boolean bl = false;
            entry = null;
            --n2;
            while (n2 >= 0) {
                entry = this.result.get(n2);
                if (entry != null && entry.getRegisterSpec().getReg() == n3) {
                    bl = true;
                    break;
                }
                --n2;
            }
            if (bl) {
                this.endIndices[n3] = n2;
                if (entry.getAddress() == n) {
                    this.result.set(n2, entry.withDisposition(Disposition.END_SIMPLY));
                }
            }
            return true;
        }

        private static RegisterSpec filterSpec(RegisterSpec registerSpec) {
            if (registerSpec != null && registerSpec.getType() == Type.KNOWN_NULL) {
                return registerSpec.withType(Type.OBJECT);
            }
            return registerSpec;
        }

        private void add(int n, Disposition disposition, RegisterSpec registerSpec) {
            int n2 = registerSpec.getReg();
            this.result.add(new Entry(n, disposition, registerSpec));
            if (disposition == Disposition.START) {
                this.regs.put(registerSpec);
                this.endIndices[n2] = -1;
            } else {
                this.regs.remove(registerSpec);
                this.endIndices[n2] = this.result.size() - 1;
            }
        }

        private void addOrUpdateEnd(int n, Disposition disposition, RegisterSpec registerSpec) {
            Entry entry;
            if (disposition == Disposition.START) {
                throw new RuntimeException("shouldn't happen");
            }
            int n2 = registerSpec.getReg();
            int n3 = this.endIndices[n2];
            if (n3 >= 0 && (entry = this.result.get(n3)).getAddress() == n && entry.getRegisterSpec().equals(registerSpec)) {
                this.result.set(n3, entry.withDisposition(disposition));
                this.regs.remove(registerSpec);
                return;
            }
            this.endLocal(n, registerSpec, disposition);
        }

        public LocalList finish() {
            this.aboutToProcess(Integer.MAX_VALUE, 0);
            int n = this.result.size();
            int n2 = n - this.nullResultCount;
            if (n2 == 0) {
                return EMPTY;
            }
            Object[] objectArray = new Entry[n2];
            if (n == n2) {
                this.result.toArray(objectArray);
            } else {
                int n3 = 0;
                for (Entry entry : this.result) {
                    if (entry == null) continue;
                    objectArray[n3++] = entry;
                }
            }
            Arrays.sort(objectArray);
            LocalList localList = new LocalList(n2);
            for (int i = 0; i < n2; ++i) {
                localList.set(i, (Entry)objectArray[i]);
            }
            localList.setImmutable();
            return localList;
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        private final int address;
        private final Disposition disposition;
        private final RegisterSpec spec;
        private final CstType type;

        public Entry(int n, Disposition disposition, RegisterSpec registerSpec) {
            if (n < 0) {
                throw new IllegalArgumentException("address < 0");
            }
            if (disposition == null) {
                throw new NullPointerException("disposition == null");
            }
            try {
                if (registerSpec.getLocalItem() == null) {
                    throw new NullPointerException("spec.getLocalItem() == null");
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new NullPointerException("spec == null");
            }
            this.address = n;
            this.disposition = disposition;
            this.spec = registerSpec;
            this.type = CstType.intern(registerSpec.getType());
        }

        public String toString() {
            return Integer.toHexString(this.address) + " " + (Object)((Object)this.disposition) + " " + this.spec;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.compareTo((Entry)object) == 0;
        }

        @Override
        public int compareTo(Entry entry) {
            boolean bl;
            if (this.address < entry.address) {
                return -1;
            }
            if (this.address > entry.address) {
                return 1;
            }
            boolean bl2 = this.isStart();
            if (bl2 != (bl = entry.isStart())) {
                return bl2 ? 1 : -1;
            }
            return this.spec.compareTo(entry.spec);
        }

        public int getAddress() {
            return this.address;
        }

        public Disposition getDisposition() {
            return this.disposition;
        }

        public boolean isStart() {
            return this.disposition == Disposition.START;
        }

        public CstString getName() {
            return this.spec.getLocalItem().getName();
        }

        public CstString getSignature() {
            return this.spec.getLocalItem().getSignature();
        }

        public CstType getType() {
            return this.type;
        }

        public int getRegister() {
            return this.spec.getReg();
        }

        public RegisterSpec getRegisterSpec() {
            return this.spec;
        }

        public boolean matches(RegisterSpec registerSpec) {
            return this.spec.equalsUsingSimpleType(registerSpec);
        }

        public boolean matches(Entry entry) {
            return this.matches(entry.spec);
        }

        public Entry withDisposition(Disposition disposition) {
            if (disposition == this.disposition) {
                return this;
            }
            return new Entry(this.address, disposition, this.spec);
        }
    }

    public static enum Disposition {
        START,
        END_SIMPLY,
        END_REPLACED,
        END_MOVED,
        END_CLOBBERED_BY_PREV,
        END_CLOBBERED_BY_NEXT;

    }
}

