/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.attrib.RawAttribute;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public class AttributeFactory {
    public static final int CTX_CLASS = 0;
    public static final int CTX_FIELD = 1;
    public static final int CTX_METHOD = 2;
    public static final int CTX_CODE = 3;
    public static final int CTX_COUNT = 4;

    public final Attribute parse(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (directClassFile == null) {
            throw new NullPointerException("cf == null");
        }
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("bad context");
        }
        CstString cstString = null;
        try {
            ByteArray byteArray = directClassFile.getBytes();
            ConstantPool constantPool = directClassFile.getConstantPool();
            int n3 = byteArray.getUnsignedShort(n2);
            int n4 = byteArray.getInt(n2 + 2);
            cstString = (CstString)constantPool.get(n3);
            if (parseObserver != null) {
                parseObserver.parsed(byteArray, n2, 2, "name: " + cstString.toHuman());
                parseObserver.parsed(byteArray, n2 + 2, 4, "length: " + Hex.u4(n4));
            }
            return this.parse0(directClassFile, n, cstString.getString(), n2 + 6, n4, parseObserver);
        }
        catch (ParseException parseException) {
            parseException.addContext("...while parsing " + (cstString != null ? cstString.toHuman() + " " : "") + "attribute at offset " + Hex.u4(n2));
            throw parseException;
        }
    }

    protected Attribute parse0(DirectClassFile directClassFile, int n, String string, int n2, int n3, ParseObserver parseObserver) {
        ByteArray byteArray = directClassFile.getBytes();
        ConstantPool constantPool = directClassFile.getConstantPool();
        RawAttribute rawAttribute = new RawAttribute(string, byteArray, n2, n3, constantPool);
        if (parseObserver != null) {
            parseObserver.parsed(byteArray, n2, n3, "attribute data");
        }
        return rawAttribute;
    }
}

