/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.util.IntList;
import com.android.dx.util.MutabilityControl;

public final class SwitchList
extends MutabilityControl {
    private final IntList values;
    private final IntList targets;
    private int size;

    public SwitchList(int n) {
        super(true);
        this.values = new IntList(n);
        this.targets = new IntList(n + 1);
        this.size = n;
    }

    @Override
    public void setImmutable() {
        this.values.setImmutable();
        this.targets.setImmutable();
        super.setImmutable();
    }

    public int size() {
        return this.size;
    }

    public int getValue(int n) {
        return this.values.get(n);
    }

    public int getTarget(int n) {
        return this.targets.get(n);
    }

    public int getDefaultTarget() {
        return this.targets.get(this.size);
    }

    public IntList getTargets() {
        return this.targets;
    }

    public IntList getValues() {
        return this.values;
    }

    public void setDefaultTarget(int n) {
        this.throwIfImmutable();
        if (n < 0) {
            throw new IllegalArgumentException("target < 0");
        }
        if (this.targets.size() != this.size) {
            throw new RuntimeException("non-default elements not all set");
        }
        this.targets.add(n);
    }

    public void add(int n, int n2) {
        this.throwIfImmutable();
        if (n2 < 0) {
            throw new IllegalArgumentException("target < 0");
        }
        this.values.add(n);
        this.targets.add(n2);
    }

    public void removeSuperfluousDefaults() {
        this.throwIfImmutable();
        int n = this.size;
        if (n != this.targets.size() - 1) {
            throw new IllegalArgumentException("incomplete instance");
        }
        int n2 = this.targets.get(n);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = this.targets.get(i);
            if (n4 == n2) continue;
            if (i != n3) {
                this.targets.set(n3, n4);
                this.values.set(n3, this.values.get(i));
            }
            ++n3;
        }
        if (n3 != n) {
            this.values.shrink(n3);
            this.targets.set(n3, n2);
            this.targets.shrink(n3 + 1);
            this.size = n3;
        }
    }
}

