/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;
import com.android.dx.util.FixedSizeList;

public final class LocalVariableList
extends FixedSizeList {
    public static final LocalVariableList EMPTY = new LocalVariableList(0);

    public static LocalVariableList concat(LocalVariableList localVariableList, LocalVariableList localVariableList2) {
        int n;
        if (localVariableList == EMPTY) {
            return localVariableList2;
        }
        int n2 = localVariableList.size();
        int n3 = localVariableList2.size();
        LocalVariableList localVariableList3 = new LocalVariableList(n2 + n3);
        for (n = 0; n < n2; ++n) {
            localVariableList3.set(n, localVariableList.get(n));
        }
        for (n = 0; n < n3; ++n) {
            localVariableList3.set(n2 + n, localVariableList2.get(n));
        }
        localVariableList3.setImmutable();
        return localVariableList3;
    }

    public static LocalVariableList mergeDescriptorsAndSignatures(LocalVariableList localVariableList, LocalVariableList localVariableList2) {
        int n = localVariableList.size();
        LocalVariableList localVariableList3 = new LocalVariableList(n);
        for (int i = 0; i < n; ++i) {
            Item item = localVariableList.get(i);
            Item item2 = localVariableList2.itemToLocal(item);
            if (item2 != null) {
                CstString cstString = item2.getSignature();
                item = item.withSignature(cstString);
            }
            localVariableList3.set(i, item);
        }
        localVariableList3.setImmutable();
        return localVariableList3;
    }

    public LocalVariableList(int n) {
        super(n);
    }

    public Item get(int n) {
        return (Item)this.get0(n);
    }

    public void set(int n, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n, item);
    }

    public void set(int n, int n2, int n3, CstString cstString, CstString cstString2, CstString cstString3, int n4) {
        this.set0(n, new Item(n2, n3, cstString, cstString2, cstString3, n4));
    }

    public Item itemToLocal(Item item) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Item item2 = (Item)this.get0(i);
            if (item2 == null || !item2.matchesAllButType(item)) continue;
            return item2;
        }
        return null;
    }

    public Item pcAndIndexToLocal(int n, int n2) {
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            Item item = (Item)this.get0(i);
            if (item == null || !item.matchesPcAndIndex(n, n2)) continue;
            return item;
        }
        return null;
    }

    public static class Item {
        private final int startPc;
        private final int length;
        private final CstString name;
        private final CstString descriptor;
        private final CstString signature;
        private final int index;

        public Item(int n, int n2, CstString cstString, CstString cstString2, CstString cstString3, int n3) {
            if (n < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("length < 0");
            }
            if (cstString == null) {
                throw new NullPointerException("name == null");
            }
            if (cstString2 == null && cstString3 == null) {
                throw new NullPointerException("(descriptor == null) && (signature == null)");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("index < 0");
            }
            this.startPc = n;
            this.length = n2;
            this.name = cstString;
            this.descriptor = cstString2;
            this.signature = cstString3;
            this.index = n3;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLength() {
            return this.length;
        }

        public CstString getDescriptor() {
            return this.descriptor;
        }

        public LocalItem getLocalItem() {
            return LocalItem.make(this.name, this.signature);
        }

        private CstString getSignature() {
            return this.signature;
        }

        public int getIndex() {
            return this.index;
        }

        public Type getType() {
            return Type.intern(this.descriptor.getString());
        }

        public Item withSignature(CstString cstString) {
            return new Item(this.startPc, this.length, this.name, this.descriptor, cstString, this.index);
        }

        public boolean matchesPcAndIndex(int n, int n2) {
            return n2 == this.index && n >= this.startPc && n < this.startPc + this.length;
        }

        public boolean matchesAllButType(Item item) {
            return this.startPc == item.startPc && this.length == item.length && this.index == item.index && this.name.equals(item.name);
        }
    }
}

