/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.cf.code.ExecutionStack;
import com.android.dx.cf.code.LocalsArray;
import com.android.dx.cf.code.LocalsArraySet;
import com.android.dx.cf.code.OneLocalsArray;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.util.IntList;

public final class Frame {
    private final LocalsArray locals;
    private final ExecutionStack stack;
    private final IntList subroutines;

    private Frame(LocalsArray localsArray, ExecutionStack executionStack) {
        this(localsArray, executionStack, IntList.EMPTY);
    }

    private Frame(LocalsArray localsArray, ExecutionStack executionStack, IntList intList) {
        if (localsArray == null) {
            throw new NullPointerException("locals == null");
        }
        if (executionStack == null) {
            throw new NullPointerException("stack == null");
        }
        intList.throwIfMutable();
        this.locals = localsArray;
        this.stack = executionStack;
        this.subroutines = intList;
    }

    public Frame(int n, int n2) {
        this(new OneLocalsArray(n), new ExecutionStack(n2));
    }

    public Frame copy() {
        return new Frame(this.locals.copy(), this.stack.copy(), this.subroutines);
    }

    public void setImmutable() {
        this.locals.setImmutable();
        this.stack.setImmutable();
    }

    public void makeInitialized(Type type) {
        this.locals.makeInitialized(type);
        this.stack.makeInitialized(type);
    }

    public LocalsArray getLocals() {
        return this.locals;
    }

    public ExecutionStack getStack() {
        return this.stack;
    }

    public IntList getSubroutines() {
        return this.subroutines;
    }

    public void initializeWithParameters(StdTypeList stdTypeList) {
        int n = 0;
        int n2 = stdTypeList.size();
        for (int i = 0; i < n2; ++i) {
            Type type = stdTypeList.get(i);
            this.locals.set(n, type);
            n += type.getCategory();
        }
    }

    public Frame subFrameForLabel(int n, int n2) {
        IntList intList;
        LocalsArray localsArray = null;
        if (this.locals instanceof LocalsArraySet) {
            localsArray = ((LocalsArraySet)this.locals).subArrayForLabel(n2);
        }
        try {
            intList = this.subroutines.mutableCopy();
            if (intList.pop() != n) {
                throw new RuntimeException("returning from invalid subroutine");
            }
            intList.setImmutable();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException("returning from invalid subroutine");
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("can't return from non-subroutine");
        }
        return localsArray == null ? null : new Frame(localsArray, this.stack, intList);
    }

    public Frame mergeWith(Frame frame) {
        LocalsArray localsArray = this.getLocals().merge(frame.getLocals());
        ExecutionStack executionStack = this.getStack().merge(frame.getStack());
        IntList intList = this.mergeSubroutineLists(frame.subroutines);
        if ((localsArray = Frame.adjustLocalsForSubroutines(localsArray, intList)) == this.getLocals() && executionStack == this.getStack() && this.subroutines == intList) {
            return this;
        }
        return new Frame(localsArray, executionStack, intList);
    }

    private IntList mergeSubroutineLists(IntList intList) {
        if (this.subroutines.equals(intList)) {
            return this.subroutines;
        }
        IntList intList2 = new IntList();
        int n = this.subroutines.size();
        int n2 = intList.size();
        for (int i = 0; i < n && i < n2 && this.subroutines.get(i) == intList.get(i); ++i) {
            intList2.add(i);
        }
        intList2.setImmutable();
        return intList2;
    }

    private static LocalsArray adjustLocalsForSubroutines(LocalsArray localsArray, IntList intList) {
        if (!(localsArray instanceof LocalsArraySet)) {
            return localsArray;
        }
        LocalsArraySet localsArraySet = (LocalsArraySet)localsArray;
        if (intList.size() == 0) {
            return localsArraySet.getPrimary();
        }
        return localsArraySet;
    }

    public Frame mergeWithSubroutineCaller(Frame frame, int n, int n2) {
        IntList intList;
        LocalsArraySet localsArraySet = this.getLocals().mergeWithSubroutineCaller(frame.getLocals(), n2);
        ExecutionStack executionStack = this.getStack().merge(frame.getStack());
        IntList intList2 = frame.subroutines.mutableCopy();
        intList2.add(n);
        intList2.setImmutable();
        if (localsArraySet == this.getLocals() && executionStack == this.getStack() && this.subroutines.equals(intList2)) {
            return this;
        }
        if (this.subroutines.equals(intList2)) {
            intList = this.subroutines;
        } else {
            IntList intList3;
            if (this.subroutines.size() > intList2.size()) {
                intList = this.subroutines;
                intList3 = intList2;
            } else {
                intList = intList2;
                intList3 = this.subroutines;
            }
            int n3 = intList.size();
            int n4 = intList3.size();
            for (int i = n4 - 1; i >= 0; --i) {
                if (intList3.get(i) == intList.get(i + (n3 - n4))) continue;
                throw new RuntimeException("Incompatible merged subroutines");
            }
        }
        return new Frame(localsArraySet, executionStack, intList);
    }

    public Frame makeNewSubroutineStartFrame(int n, int n2) {
        IntList intList = this.subroutines.mutableCopy();
        intList.add(n);
        Frame frame = new Frame(this.locals.getPrimary(), this.stack, IntList.makeImmutable(n));
        return frame.mergeWithSubroutineCaller(this, n, n2);
    }

    public Frame makeExceptionHandlerStartFrame(CstType cstType) {
        ExecutionStack executionStack = this.getStack().copy();
        executionStack.clear();
        executionStack.push(cstType);
        return new Frame(this.getLocals(), executionStack, this.subroutines);
    }

    public void annotate(ExceptionWithContext exceptionWithContext) {
        this.locals.annotate(exceptionWithContext);
        this.stack.annotate(exceptionWithContext);
    }
}

