# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_tagmaker.ipynb.

# %% auto 0
__all__ = ['convert_layout', 'convert_shortcuts', 'LayoutProc']

# %% ../nbs/02_tagmaker.ipynb 3
from nbdev.config import get_config
from nbdev.process import extract_directives
from nbdev.processors import Processor
from nbdev.export import nb_export
from nbdev.doclinks import nbglob
from nbdev.sync import write_nb

from fastcore.basics import listify
from fastcore.script import call_parse
from fastcore.xtras import Path

from string import Template

# %% ../nbs/02_tagmaker.ipynb 5
_LAYOUT_STR = Template("::: {$layout}\n$content\n")
_shortcuts = {
    "margin": ".column-margin"
}

# %% ../nbs/02_tagmaker.ipynb 6
def convert_layout(cell, layout, start=False):
    "Parses cell formatted with ::: {$something}, and potentially :::"
    layout = listify(layout)
    content = cell.source
    code = cell.source.splitlines(True)
    if "end" in code[0]:
        if len(code) == 1:
            cell.source = ":::"
        else:
            cell.source += ":::"
    else:
        cell.source = _LAYOUT_STR.substitute(
            layout=" ".join(layout),
            content=content
        )
        if not start:
            cell.source += ":::"

# %% ../nbs/02_tagmaker.ipynb 10
def convert_shortcuts(cell):
    for i,directive in enumerate(cell.directives_["layout"]):
        if directive in _shortcuts.keys():
            cell.directives_["layout"][i] = _shortcuts[directive]

# %% ../nbs/02_tagmaker.ipynb 12
import re
class LayoutProc(Processor):
    """A proc that will automatically change #| layout format
    to ::: {format} ... :::
    """
    has_partial = False
    def cell(self, cell):
        if cell.cell_type == "markdown" and "layout" in cell.directives_:
            convert_shortcuts(cell)
            directives_ = cell.directives_["layout"]
            if self.has_partial and "end" in directives_:
                convert_layout(cell, directives_)
                self.has_partial = False
            else:
                if directives_[-1] == "start":
                    self.has_partial = True
                    directives_.remove("start")
                    convert_layout(cell, directives_, True)
                else:
                    convert_layout(cell, directives_)
                    cell.source += ":::"
