# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mdformat', 'mdformat._renderer']

package_data = \
{'': ['*']}

install_requires = \
['markdown-it-py>=0.4.7,<0.6.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=0.12']}

entry_points = \
{'console_scripts': ['mdformat = mdformat.__main__:run']}

setup_kwargs = {
    'name': 'mdformat',
    'version': '0.3.0',
    'description': 'CommonMark compliant Markdown formatter',
    'long_description': '[![Build Status](https://github.com/executablebooks/mdformat/workflows/Tests/badge.svg?branch=master)](<https://github.com/executablebooks/mdformat/actions?query=workflow%3ATests+branch%3Amaster+event%3Apush>)\n[![codecov.io](https://codecov.io/gh/executablebooks/mdformat/branch/master/graph/badge.svg)](<https://codecov.io/gh/executablebooks/mdformat>)\n[![PyPI version](https://badge.fury.io/py/mdformat.svg)](<https://badge.fury.io/py/mdformat>)\n\n# mdformat\n\n> CommonMark compliant Markdown formatter\n\nMdformat is an opinionated Markdown formatter that can be used to enforce a consistent style in Markdown files.\nMdformat is a Unix-style command-line tool as well as a Python library.\n\nThe features/opinions of the formatter include:\n\n- Strip trailing and leading whitespace\n- Always use ATX style headings\n- Consistent indentation for contents of block quotes and list items\n- Reformat reference links as inline links\n- Reformat indented code blocks as fenced code blocks\n- Separate blocks with a single empty line\n  (an exception being tight lists where the separator is a single newline character)\n- End the file in a single newline character\n- Use `1.` as the ordered list marker if possible, also for noninitial list items\n\nMdformat by default will not change word wrapping.\nThe rationale for this is to support techniques like\n[One Sentence Per Line](<https://asciidoctor.org/docs/asciidoc-recommended-practices/#one-sentence-per-line>)\nand\n[Semantic Line Breaks](<https://sembr.org/>).\n\n**NOTE:**\nThe formatting style produced by mdformat may change in each version.\nIt is recommended to pin mdformat dependency version.\n\n## Installing\n\n```bash\npip install mdformat\n```\n\n## Command line usage\n\n### Format files\n\nFormat files `README.md` and `CHANGELOG.md` in place\n\n```bash\nmdformat README.md CHANGELOG.md\n```\n\nFormat `.md` files in current working directory recursively\n\n```bash\nmdformat .\n```\n\nRead Markdown from standard input until `EOF`.\nWrite formatted Markdown to standard output.\n\n```bash\nmdformat -\n```\n\n### Check formatting\n\n```bash\nmdformat --check README.md CHANGELOG.md\n```\n\nThis will not apply any changes to the files.\nIf a file is not properly formatted, the exit code will be non-zero.\n\n## Python API usage\n\n### Format text\n\n```python\nimport mdformat\n\nunformatted = "\\n\\n# A header\\n\\n"\nformatted = mdformat.text(unformatted)\nassert formatted == "# A header\\n"\n```\n\n### Format a file\n\nFormat file `README.md` in place:\n\n```python\nimport mdformat\n\n# Input filepath as a string...\nmdformat.file("README.md")\n\n# ...or a pathlib.Path object\nimport pathlib\n\nfilepath = pathlib.Path("README.md")\nmdformat.file(filepath)\n```\n\n## Usage as a pre-commit hook\n\n`mdformat` can be used as a [pre-commit](<https://github.com/pre-commit/pre-commit>) hook.\nAdd the following to your project\'s `.pre-commit-config.yaml` to enable this:\n\n```yaml\n- repo: https://github.com/executablebooks/mdformat\n  rev: 0.3.0  # Use the ref you want to point at\n  hooks:\n  - id: mdformat\n```\n\n## Code formatter plugins\n\nMdformat features a plugin system to support formatting of Markdown code blocks where the coding language has been labeled.\nFor instance, if [`mdformat-black`](<https://github.com/hukkinj1/mdformat-black>) plugin is installed in the environment,\nmdformat CLI will automatically format Python code blocks with [Black](<https://github.com/psf/black>).\n\nFor stability, mdformat Python API behavior will not change simply due to a plugin being installed.\nCode formatters will have to be explicitly enabled in addition to being installed:\n\n````python\nimport mdformat\n\nunformatted = "```python\\n\'\'\'black converts quotes\'\'\'\\n```\\n"\n# Pass in `codeformatters` here! It is an iterable of coding languages\n# that should be formatted\nformatted = mdformat.text(unformatted, codeformatters={"python"})\nassert formatted == \'```python\\n"""black converts quotes"""\\n```\\n\'\n````\n\nRead the [contribution guide](<https://github.com/executablebooks/mdformat/blob/master/CONTRIBUTING.md#developing-code-formatter-plugins>)\nif you wish to implement a new code formatter plugin.\n\n### Existing formatter plugins\n\n<table>\n  <tr>\n    <th>Plugin</th>\n    <th>Supported languages</th>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/hukkinj1/mdformat-black">mdformat-black</a></td>\n    <td><code>python</code></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/hukkinj1/mdformat-config">mdformat-config</a></td>\n    <td><code>json</code>, <code>toml</code>, <code>yaml</code></td>\n  </tr>\n  <tr>\n    <td><a href="https://github.com/hukkinj1/mdformat-beautysh">mdformat-beautysh</a></td>\n    <td><code>bash</code>, <code>sh</code></td>\n  </tr>\n</table> \n',
    'author': 'Taneli Hukkinen',
    'author_email': 'hukkinj1@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/executablebooks/mdformat',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
