# Web Crawlers for Constant Enumerations

| FILE NAME                   | ENUM NAME     | DESCRIPTION                                                          | REFERENCE                                                                                                                                                               |
| :-------------------------- | :------------ | :------------------------------------------------------------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `arp_hdr`                   | `HrdType`     | Hardware Types                                                       | [Address Resolution Protocol (ARP) Parameters](https://www.iana.org/assignments/arp-parameters/arp-parameters.xhtml#arp-parameters-2)                                   |
| `arp_oper`                  | `OperType`    | Operation Codes                                                      | [Address Resolution Protocol (ARP) Parameters](https://www.iana.org/assignments/arp-parameters/arp-parameters.xhtml#arp-parameters-1)                                   |
| `ethertype`                 | `EtherType`   | Ethertype IEEE 802 Numbers                                           | [IEEE 802 Numbers](https://www.iana.org/assignments/ieee-802-numbers)                                                                                                   |
| `hip_cert_type`             | `CertType`    | HIP Certificate Types                                                | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#certificate-types)                                       |
| `hip_cipher_id`             | `CipherID`    | Cipher IDs                                                           | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-cipher-id)                                           |
| `hip_di_type`               | `DI_TYPE`     | DI-Types                                                             | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-7)                                        |
| `hip_ecdsa_curve`           | `ECDSA`       | ECDSA Curve Label                                                    | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#ecdsa-curve-label)                                       |
| `hip_ecdsa_low_curve`       | `ECDSA_LOW`   | ECDSA_LOW Curve Label                                                | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#ecdsa-low-curve-label)                                   |
| `hip_esp_suite_id`          | `ESP_SuiteID` | ESP Transform Suite IDs                                              | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#esp-transform-suite-ids)                                 |
| `hip_groud_id`              | `GroupID`     | Group IDs                                                            | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-5)                                        |
| `hip_hi_algorithm`          | `HI_ALG`      | HI Algorithm                                                         | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hi-algorithm)                                            |
| `hip_hit_suite_id`          | `HIT_SuiteID` | HIT Suite ID                                                         | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hit-suite-id)                                            |
| `hip_mode_id`               | `ModeID`      | HIP NAT Traversal Modes                                              | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#nat-traversal)                                           |
| `hip_notification_type`     | `MsgType`     | Notify Message Types                                                 | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-9)                                        |
| `hip_para`                  | `ParamType`   | HIP Parameter Types                                                  | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-4)                                        |
| `hip_reg_failure_type`      | `RegFailType` | Registration Failure Types                                           | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-13)                                       |
| `hip_reg_type`              | `RegType`     | Registration Types                                                   | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-11)                                       |
| `hip_suite_id`              | `SuiteID`     | Suite IDs                                                            | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-6)                                        |
| `hip_tp_mode_id`            | `TAT_ModeID`  | HIP Transport Modes                                                  | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#transport-modes)                                         |
| `hip_types`                 | `PktType`     | HIP Packet Types                                                     | [Host Identity Protocol (HIP) Parameters](https://www.iana.org/assignments/hip-parameters/hip-parameters.xhtml#hip-parameters-1)                                        |
| `ip_qs_func`                | `QS`          | QS Functions                                                         |                                                                                                                                                                         |
| `ipv4_classification_level` | `ClasLvl`     | Classification Level Encodings                                       |                                                                                                                                                                         |
| `ipv4_opt_class`            | `OptCls`      | Option Classes                                                       |                                                                                                                                                                         |
| `ipv4_opt_type`             | `Options`     | IP Option Numbers                                                    | [Internet Protocol Version 4 (IPv4) Parameters](https://www.iana.org/assignments/ip-parameters/ip-parameters.xhtml#ip-parameters-1)                                     |
| `ipv4_protection_authority` | `ProtAuth`    | Protection Authority Bit Assignments                                 |                                                                                                                                                                         |
| `ipv4_router_alert`         | `RT_ALT`      | IPv4 Router Alert Option Values                                      | [Internet Protocol Version 4 (IPv4) Parameters](https://www.iana.org/assignments/ip-parameters/ip-parameters.xhtml#ipv4-router-alert-option-values)                     |
| `ipv4_tos_del`              | `Delay`       | TOS (DS Field) Delay                                                 |                                                                                                                                                                         |
| `ipv4_tos_ecn`              | `ECN`         | TOS ECN FIELD                                                        |                                                                                                                                                                         |
| `ipv4_tos_pre`              | `Precedence`  | TOS (DS Field) Precedence                                            |                                                                                                                                                                         |
| `ipv4_tos_rel`              | `Relibility`  | TOS (DS Field) Relibility                                            |                                                                                                                                                                         |
| `ipv4_tos_thr`              | `Throughput`  | TOS (DS Field) Throughput                                            |                                                                                                                                                                         |
| `ipv6_ext_hdr`              | `EXT_HDR`     | IPv6 Extension Header Types                                          | [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml#protocol-numbers-1)                                                         |
| `ipv6_opt_seed`             | `SeedID`      | Seed-ID Types                                                        |                                                                                                                                                                         |
| `ipv6_opt_type`             | `Options`     | Destination Options and Hop-by-Hop Options                           | [Internet Protocol Version 6 (IPv6) Parameters](https://www.iana.org/assignments/ipv6-parameters/ipv6-parameters.xhtml#ipv6-parameters-2)                               |
| `ipv6_router_alert`         | `RT_ALT`      | IPv6 Router Alert Option Values                                      | [IPv6 Router Alert Option Values](https://www.iana.org/assignments/ipv6-routeralert-values/ipv6-routeralert-values.xhtml#ipv6-routeralert-values-1)                     |
| `ipv6_routing_type`         | `RT_TYPE`     | IPv6 Routing Types                                                   | [Internet Protocol Version 6 (IPv6) Parameters](https://www.iana.org/assignments/ipv6-parameters/ipv6-parameters.xhtml#ipv6-parameters-3)                               |
| `ipv6_tid_type`             | `TaggerID`    | TaggerID Types                                                       | [Internet Protocol Version 6 (IPv6) Parameters](https://www.iana.org/assignments/ipv6-parameters/ipv6-parameters.xhtml#taggerId-types)                                  |
| `ipx_sock`                  | `Sockets`     | Socket Types                                                         | [Internetwork Packet Exchange](https://en.wikipedia.org/wiki/Internetwork_Packet_Exchange#Socket_number)                                                                |
| `ipx_type`                  | `PktType`     | IPX Packet Types                                                     | [Internetwork Packet Exchange](https://en.wikipedia.org/wiki/Internetwork_Packet_Exchange#IPX_packet_structure)                                                         |
| `linktype`                  | `LinkType`    | Link-Layer Header Type Values                                        | [LINK-LAYER HEADER TYPES](http://www.tcpdump.org/linktypes.html)                                                                                                        |
| `mh_mobility_type`          | `PktType`     | Mobility Header Types - for the MH Type field in the Mobility Header | [Mobile IPv6 parameters](https://www.iana.org/assignments/mobility-parameters/mobility-parameters.xhtml#mobility-parameters-1)                                          |
| `ospf_auth`                 | `AuthType`    | Authentication Types                                                 | [Open Shortest Path First (OSPF) Authentication Codes](https://www.iana.org/assignments/ospf-authentication-codes/ospf-authentication-codes.xhtml#authentication-codes) |
| `ospf_type`                 | `PktType`     | OSPF Packet Types                                                    | [Open Shortest Path First (OSPF) Authentication Codes](https://www.iana.org/assignments/ospfv2-parameters/ospfv2-parameters.xhtml#ospfv2-parameters-3)                  |
| `tcp_chksum_opt`            | `ChksumOpt`   | TCP Alternate Checksum Options                                       | [RFC 1146](https://tools.ietf.org/html/rfc1146)                                                                                                                         |
| `tcp_opt_type`              | `Options`     | TCP Option Kind Numbers                                              | [Transmission Control Protocol (TCP) Parameters](https://www.iana.org/assignments/tcp-parameters/tcp-parameters.xhtml#tcp-parameters-1)                                 |
| `tp_proto`                  | `TransType`   | Transport Layer Protocol Numbers                                     | [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml#protocol-numbers-1)                                                         |
| `vlan_pcp`                  | `PrioLvl`     | priority levels defined in IEEE 802.1p                               | [IEEE P802.1p](https://en.wikipedia.org/wiki/IEEE_P802.1p#Priority_levels)                                                                                              |
