# coding: utf-8

"""
    FormsExternalService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.marketing.forms.api_client import ApiClient
from hubspot.marketing.forms.exceptions import ApiTypeError, ApiValueError


class FormsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, form_id, **kwargs):  # noqa: E501
        """Archive a form definition  # noqa: E501

        Archive a form definition. New submissions will not be accepted and the form definition will be permanently deleted after 3 months.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(form_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The ID of the form to archive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(form_id, **kwargs)  # noqa: E501

    def archive_with_http_info(self, form_id, **kwargs):  # noqa: E501
        """Archive a form definition  # noqa: E501

        Archive a form definition. New submissions will not be accepted and the form definition will be permanently deleted after 3 months.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(form_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The ID of the form to archive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["form_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'form_id' is set
        if self.api_client.client_side_validation and ("form_id" not in local_var_params or local_var_params["form_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `form_id` when calling `archive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "form_id" in local_var_params:
            path_params["formId"] = local_var_params["form_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/{formId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create(self, form_definition_create_request_base, **kwargs):  # noqa: E501
        """Create a form  # noqa: E501

        Add a new `hubspot` form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(form_definition_create_request_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FormDefinitionCreateRequestBase form_definition_create_request_base: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormDefinitionBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_with_http_info(form_definition_create_request_base, **kwargs)  # noqa: E501

    def create_with_http_info(self, form_definition_create_request_base, **kwargs):  # noqa: E501
        """Create a form  # noqa: E501

        Add a new `hubspot` form  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(form_definition_create_request_base, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FormDefinitionCreateRequestBase form_definition_create_request_base: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormDefinitionBase, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["form_definition_create_request_base"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'form_definition_create_request_base' is set
        if self.api_client.client_side_validation and (
            "form_definition_create_request_base" not in local_var_params or local_var_params["form_definition_create_request_base"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `form_definition_create_request_base` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "form_definition_create_request_base" in local_var_params:
            body_params = local_var_params["form_definition_create_request_base"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FormDefinitionBase",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, form_id, **kwargs):  # noqa: E501
        """Get a form definition  # noqa: E501

        Returns a form based on the form ID provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(form_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The unique identifier of the form (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormDefinitionBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(form_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, form_id, **kwargs):  # noqa: E501
        """Get a form definition  # noqa: E501

        Returns a form based on the form ID provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(form_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The unique identifier of the form (required)
        :param bool archived: Whether to return only results that have been archived.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormDefinitionBase, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["form_id", "archived"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'form_id' is set
        if self.api_client.client_side_validation and ("form_id" not in local_var_params or local_var_params["form_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `form_id` when calling `get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "form_id" in local_var_params:
            path_params["formId"] = local_var_params["form_id"]  # noqa: E501

        query_params = []
        if "archived" in local_var_params and local_var_params["archived"] is not None:  # noqa: E501
            query_params.append(("archived", local_var_params["archived"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/{formId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FormDefinitionBase",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_page(self, **kwargs):  # noqa: E501
        """Get a list of forms  # noqa: E501

        Returns a list of forms based on the search filters. By default, it returns the first 20 `hubspot` forms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str after: The paging cursor token of the last successfully read resource will be returned as the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to display per page.
        :param bool archived: Whether to return only results that have been archived.
        :param list[str] form_types: The form types to be included in the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseFormDefinitionBaseForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_page_with_http_info(**kwargs)  # noqa: E501

    def get_page_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of forms  # noqa: E501

        Returns a list of forms based on the search filters. By default, it returns the first 20 `hubspot` forms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str after: The paging cursor token of the last successfully read resource will be returned as the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to display per page.
        :param bool archived: Whether to return only results that have been archived.
        :param list[str] form_types: The form types to be included in the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseFormDefinitionBaseForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["after", "limit", "archived", "form_types"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_page" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "after" in local_var_params and local_var_params["after"] is not None:  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if "limit" in local_var_params and local_var_params["limit"] is not None:  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if "archived" in local_var_params and local_var_params["archived"] is not None:  # noqa: E501
            query_params.append(("archived", local_var_params["archived"]))  # noqa: E501
        if "form_types" in local_var_params and local_var_params["form_types"] is not None:  # noqa: E501
            query_params.append(("formTypes", local_var_params["form_types"]))  # noqa: E501
            collection_formats["formTypes"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseFormDefinitionBaseForwardPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def replace(self, form_id, hub_spot_form_definition, **kwargs):  # noqa: E501
        """Update a form definition  # noqa: E501

        Update all fields of a hubspot form definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace(form_id, hub_spot_form_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: (required)
        :param HubSpotFormDefinition hub_spot_form_definition: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormDefinitionBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.replace_with_http_info(form_id, hub_spot_form_definition, **kwargs)  # noqa: E501

    def replace_with_http_info(self, form_id, hub_spot_form_definition, **kwargs):  # noqa: E501
        """Update a form definition  # noqa: E501

        Update all fields of a hubspot form definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_with_http_info(form_id, hub_spot_form_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: (required)
        :param HubSpotFormDefinition hub_spot_form_definition: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormDefinitionBase, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["form_id", "hub_spot_form_definition"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method replace" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'form_id' is set
        if self.api_client.client_side_validation and ("form_id" not in local_var_params or local_var_params["form_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `form_id` when calling `replace`")  # noqa: E501
        # verify the required parameter 'hub_spot_form_definition' is set
        if self.api_client.client_side_validation and ("hub_spot_form_definition" not in local_var_params or local_var_params["hub_spot_form_definition"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `hub_spot_form_definition` when calling `replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "form_id" in local_var_params:
            path_params["formId"] = local_var_params["form_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_spot_form_definition" in local_var_params:
            body_params = local_var_params["hub_spot_form_definition"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/{formId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FormDefinitionBase",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update(self, form_id, hub_spot_form_definition_patch_request, **kwargs):  # noqa: E501
        """Partially update a form definition  # noqa: E501

        Update some of the form definition components  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(form_id, hub_spot_form_definition_patch_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The ID of the form to update. (required)
        :param HubSpotFormDefinitionPatchRequest hub_spot_form_definition_patch_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormDefinitionBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_with_http_info(form_id, hub_spot_form_definition_patch_request, **kwargs)  # noqa: E501

    def update_with_http_info(self, form_id, hub_spot_form_definition_patch_request, **kwargs):  # noqa: E501
        """Partially update a form definition  # noqa: E501

        Update some of the form definition components  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(form_id, hub_spot_form_definition_patch_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str form_id: The ID of the form to update. (required)
        :param HubSpotFormDefinitionPatchRequest hub_spot_form_definition_patch_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormDefinitionBase, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["form_id", "hub_spot_form_definition_patch_request"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method update" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'form_id' is set
        if self.api_client.client_side_validation and ("form_id" not in local_var_params or local_var_params["form_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `form_id` when calling `update`")  # noqa: E501
        # verify the required parameter 'hub_spot_form_definition_patch_request' is set
        if self.api_client.client_side_validation and (
            "hub_spot_form_definition_patch_request" not in local_var_params or local_var_params["hub_spot_form_definition_patch_request"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hub_spot_form_definition_patch_request` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "form_id" in local_var_params:
            path_params["formId"] = local_var_params["form_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_spot_form_definition_patch_request" in local_var_params:
            body_params = local_var_params["hub_spot_form_definition_patch_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/forms/{formId}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FormDefinitionBase",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
