# coding: utf-8

"""
    Marketing Events Extension

    These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.marketing.events.configuration import Configuration


class MarketingEventExternalUniqueIdentifier(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"app_id": "int", "external_account_id": "str", "external_event_id": "str"}

    attribute_map = {"app_id": "appId", "external_account_id": "externalAccountId", "external_event_id": "externalEventId"}

    def __init__(self, app_id=None, external_account_id=None, external_event_id=None, local_vars_configuration=None):  # noqa: E501
        """MarketingEventExternalUniqueIdentifier - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._app_id = None
        self._external_account_id = None
        self._external_event_id = None
        self.discriminator = None

        self.app_id = app_id
        self.external_account_id = external_account_id
        self.external_event_id = external_event_id

    @property
    def app_id(self):
        """Gets the app_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501

        The id of the application that created the marketing event in HubSpot.  # noqa: E501

        :return: The app_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :rtype: int
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id):
        """Sets the app_id of this MarketingEventExternalUniqueIdentifier.

        The id of the application that created the marketing event in HubSpot.  # noqa: E501

        :param app_id: The app_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and app_id is None:  # noqa: E501
            raise ValueError("Invalid value for `app_id`, must not be `None`")  # noqa: E501

        self._app_id = app_id

    @property
    def external_account_id(self):
        """Gets the external_account_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501

        The accountId that is associated with this marketing event in the external event application.  # noqa: E501

        :return: The external_account_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._external_account_id

    @external_account_id.setter
    def external_account_id(self, external_account_id):
        """Sets the external_account_id of this MarketingEventExternalUniqueIdentifier.

        The accountId that is associated with this marketing event in the external event application.  # noqa: E501

        :param external_account_id: The external_account_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and external_account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `external_account_id`, must not be `None`")  # noqa: E501

        self._external_account_id = external_account_id

    @property
    def external_event_id(self):
        """Gets the external_event_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501

        The id of the marketing event in the external event application.  # noqa: E501

        :return: The external_event_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._external_event_id

    @external_event_id.setter
    def external_event_id(self, external_event_id):
        """Sets the external_event_id of this MarketingEventExternalUniqueIdentifier.

        The id of the marketing event in the external event application.  # noqa: E501

        :param external_event_id: The external_event_id of this MarketingEventExternalUniqueIdentifier.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and external_event_id is None:  # noqa: E501
            raise ValueError("Invalid value for `external_event_id`, must not be `None`")  # noqa: E501

        self._external_event_id = external_event_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketingEventExternalUniqueIdentifier):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MarketingEventExternalUniqueIdentifier):
            return True

        return self.to_dict() != other.to_dict()
