# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.cms.hubdb.configuration import Configuration


class HubDbTableRowV3(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"id": "str", "values": "dict(str, object)", "path": "str", "name": "str", "child_table_id": "str", "created_at": "datetime", "updated_at": "datetime", "published_at": "datetime"}

    attribute_map = {
        "id": "id",
        "values": "values",
        "path": "path",
        "name": "name",
        "child_table_id": "childTableId",
        "created_at": "createdAt",
        "updated_at": "updatedAt",
        "published_at": "publishedAt",
    }

    def __init__(self, id=None, values=None, path=None, name=None, child_table_id=None, created_at=None, updated_at=None, published_at=None, local_vars_configuration=None):  # noqa: E501
        """HubDbTableRowV3 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._values = None
        self._path = None
        self._name = None
        self._child_table_id = None
        self._created_at = None
        self._updated_at = None
        self._published_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.values = values
        if path is not None:
            self.path = path
        if name is not None:
            self.name = name
        if child_table_id is not None:
            self.child_table_id = child_table_id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if published_at is not None:
            self.published_at = published_at

    @property
    def id(self):
        """Gets the id of this HubDbTableRowV3.  # noqa: E501

        The id of the table row  # noqa: E501

        :return: The id of this HubDbTableRowV3.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HubDbTableRowV3.

        The id of the table row  # noqa: E501

        :param id: The id of this HubDbTableRowV3.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def values(self):
        """Gets the values of this HubDbTableRowV3.  # noqa: E501

        List of key value pairs with the column name and column value  # noqa: E501

        :return: The values of this HubDbTableRowV3.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._values

    @values.setter
    def values(self, values):
        """Sets the values of this HubDbTableRowV3.

        List of key value pairs with the column name and column value  # noqa: E501

        :param values: The values of this HubDbTableRowV3.  # noqa: E501
        :type: dict(str, object)
        """
        if self.local_vars_configuration.client_side_validation and values is None:  # noqa: E501
            raise ValueError("Invalid value for `values`, must not be `None`")  # noqa: E501

        self._values = values

    @property
    def path(self):
        """Gets the path of this HubDbTableRowV3.  # noqa: E501

        Specifies the value for `hs_path` column, which will be used as slug in the dynamic pages  # noqa: E501

        :return: The path of this HubDbTableRowV3.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this HubDbTableRowV3.

        Specifies the value for `hs_path` column, which will be used as slug in the dynamic pages  # noqa: E501

        :param path: The path of this HubDbTableRowV3.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def name(self):
        """Gets the name of this HubDbTableRowV3.  # noqa: E501

        Specifies the value for `hs_name` column, which will be used as title in the dynamic pages  # noqa: E501

        :return: The name of this HubDbTableRowV3.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HubDbTableRowV3.

        Specifies the value for `hs_name` column, which will be used as title in the dynamic pages  # noqa: E501

        :param name: The name of this HubDbTableRowV3.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def child_table_id(self):
        """Gets the child_table_id of this HubDbTableRowV3.  # noqa: E501

        Specifies the value for the column child table id  # noqa: E501

        :return: The child_table_id of this HubDbTableRowV3.  # noqa: E501
        :rtype: str
        """
        return self._child_table_id

    @child_table_id.setter
    def child_table_id(self, child_table_id):
        """Sets the child_table_id of this HubDbTableRowV3.

        Specifies the value for the column child table id  # noqa: E501

        :param child_table_id: The child_table_id of this HubDbTableRowV3.  # noqa: E501
        :type: str
        """

        self._child_table_id = child_table_id

    @property
    def created_at(self):
        """Gets the created_at of this HubDbTableRowV3.  # noqa: E501

        Timestamp at which the row is created  # noqa: E501

        :return: The created_at of this HubDbTableRowV3.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this HubDbTableRowV3.

        Timestamp at which the row is created  # noqa: E501

        :param created_at: The created_at of this HubDbTableRowV3.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this HubDbTableRowV3.  # noqa: E501

        Timestamp at which the row is updated last time  # noqa: E501

        :return: The updated_at of this HubDbTableRowV3.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this HubDbTableRowV3.

        Timestamp at which the row is updated last time  # noqa: E501

        :param updated_at: The updated_at of this HubDbTableRowV3.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def published_at(self):
        """Gets the published_at of this HubDbTableRowV3.  # noqa: E501


        :return: The published_at of this HubDbTableRowV3.  # noqa: E501
        :rtype: datetime
        """
        return self._published_at

    @published_at.setter
    def published_at(self, published_at):
        """Sets the published_at of this HubDbTableRowV3.


        :param published_at: The published_at of this HubDbTableRowV3.  # noqa: E501
        :type: datetime
        """

        self._published_at = published_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HubDbTableRowV3):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HubDbTableRowV3):
            return True

        return self.to_dict() != other.to_dict()
