# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainRecordArgs', 'DomainRecord']

@pulumi.input_type
class DomainRecordArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 dns_zone: pulumi.Input[str],
                 type: pulumi.Input[str],
                 geo_ip: Optional[pulumi.Input['DomainRecordGeoIpArgs']] = None,
                 http_service: Optional[pulumi.Input['DomainRecordHttpServiceArgs']] = None,
                 keep_empty_zone: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]] = None):
        """
        The set of arguments for constructing a DomainRecord resource.
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[str] dns_zone: The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        :param pulumi.Input[str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input['DomainRecordGeoIpArgs'] geo_ip: The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        :param pulumi.Input['DomainRecordHttpServiceArgs'] http_service: The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        :param pulumi.Input[bool] keep_empty_zone: When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        :param pulumi.Input[str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[int] priority: The priority of the record (mostly used with an `MX` record)
        :param pulumi.Input[str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]] views: The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]] weighteds: You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "dns_zone", dns_zone)
        pulumi.set(__self__, "type", type)
        if geo_ip is not None:
            pulumi.set(__self__, "geo_ip", geo_ip)
        if http_service is not None:
            pulumi.set(__self__, "http_service", http_service)
        if keep_empty_zone is not None:
            pulumi.set(__self__, "keep_empty_zone", keep_empty_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if views is not None:
            pulumi.set(__self__, "views", views)
        if weighteds is not None:
            pulumi.set(__self__, "weighteds", weighteds)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The data of the view record
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> pulumi.Input[str]:
        """
        The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @dns_zone.setter
    def dns_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "dns_zone", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> Optional[pulumi.Input['DomainRecordGeoIpArgs']]:
        """
        The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        """
        return pulumi.get(self, "geo_ip")

    @geo_ip.setter
    def geo_ip(self, value: Optional[pulumi.Input['DomainRecordGeoIpArgs']]):
        pulumi.set(self, "geo_ip", value)

    @property
    @pulumi.getter(name="httpService")
    def http_service(self) -> Optional[pulumi.Input['DomainRecordHttpServiceArgs']]:
        """
        The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        """
        return pulumi.get(self, "http_service")

    @http_service.setter
    def http_service(self, value: Optional[pulumi.Input['DomainRecordHttpServiceArgs']]):
        pulumi.set(self, "http_service", value)

    @property
    @pulumi.getter(name="keepEmptyZone")
    def keep_empty_zone(self) -> Optional[pulumi.Input[bool]]:
        """
        When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        """
        return pulumi.get(self, "keep_empty_zone")

    @keep_empty_zone.setter
    def keep_empty_zone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_empty_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the record (mostly used with an `MX` record)
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]:
        """
        The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]):
        pulumi.set(self, "views", value)

    @property
    @pulumi.getter
    def weighteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]:
        """
        You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        return pulumi.get(self, "weighteds")

    @weighteds.setter
    def weighteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]):
        pulumi.set(self, "weighteds", value)


@pulumi.input_type
class _DomainRecordState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 dns_zone: Optional[pulumi.Input[str]] = None,
                 geo_ip: Optional[pulumi.Input['DomainRecordGeoIpArgs']] = None,
                 http_service: Optional[pulumi.Input['DomainRecordHttpServiceArgs']] = None,
                 keep_empty_zone: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 root_zone: Optional[pulumi.Input[bool]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainRecord resources.
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[str] dns_zone: The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        :param pulumi.Input['DomainRecordGeoIpArgs'] geo_ip: The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        :param pulumi.Input['DomainRecordHttpServiceArgs'] http_service: The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        :param pulumi.Input[bool] keep_empty_zone: When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        :param pulumi.Input[str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[int] priority: The priority of the record (mostly used with an `MX` record)
        :param pulumi.Input[str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[bool] root_zone: Does the DNS zone is the root zone or not
        :param pulumi.Input[int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]] views: The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]] weighteds: You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if dns_zone is not None:
            pulumi.set(__self__, "dns_zone", dns_zone)
        if geo_ip is not None:
            pulumi.set(__self__, "geo_ip", geo_ip)
        if http_service is not None:
            pulumi.set(__self__, "http_service", http_service)
        if keep_empty_zone is not None:
            pulumi.set(__self__, "keep_empty_zone", keep_empty_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if root_zone is not None:
            pulumi.set(__self__, "root_zone", root_zone)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if views is not None:
            pulumi.set(__self__, "views", views)
        if weighteds is not None:
            pulumi.set(__self__, "weighteds", weighteds)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        The data of the view record
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @dns_zone.setter
    def dns_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_zone", value)

    @property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> Optional[pulumi.Input['DomainRecordGeoIpArgs']]:
        """
        The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        """
        return pulumi.get(self, "geo_ip")

    @geo_ip.setter
    def geo_ip(self, value: Optional[pulumi.Input['DomainRecordGeoIpArgs']]):
        pulumi.set(self, "geo_ip", value)

    @property
    @pulumi.getter(name="httpService")
    def http_service(self) -> Optional[pulumi.Input['DomainRecordHttpServiceArgs']]:
        """
        The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        """
        return pulumi.get(self, "http_service")

    @http_service.setter
    def http_service(self, value: Optional[pulumi.Input['DomainRecordHttpServiceArgs']]):
        pulumi.set(self, "http_service", value)

    @property
    @pulumi.getter(name="keepEmptyZone")
    def keep_empty_zone(self) -> Optional[pulumi.Input[bool]]:
        """
        When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        """
        return pulumi.get(self, "keep_empty_zone")

    @keep_empty_zone.setter
    def keep_empty_zone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_empty_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the record (mostly used with an `MX` record)
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="rootZone")
    def root_zone(self) -> Optional[pulumi.Input[bool]]:
        """
        Does the DNS zone is the root zone or not
        """
        return pulumi.get(self, "root_zone")

    @root_zone.setter
    def root_zone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "root_zone", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]:
        """
        The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]):
        pulumi.set(self, "views", value)

    @property
    @pulumi.getter
    def weighteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]:
        """
        You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        return pulumi.get(self, "weighteds")

    @weighteds.setter
    def weighteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]):
        pulumi.set(self, "weighteds", value)


class DomainRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 dns_zone: Optional[pulumi.Input[str]] = None,
                 geo_ip: Optional[pulumi.Input[pulumi.InputType['DomainRecordGeoIpArgs']]] = None,
                 http_service: Optional[pulumi.Input[pulumi.InputType['DomainRecordHttpServiceArgs']]] = None,
                 keep_empty_zone: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordViewArgs']]]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordWeightedArgs']]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Domain record.\\
        For more information, see [the documentation](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        www = scaleway.DomainRecord("www",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A")
        www2 = scaleway.DomainRecord("www2",
            data="1.2.3.5",
            dns_zone="domain.tld",
            ttl=3600,
            type="A")
        mx = scaleway.DomainRecord("mx",
            data="mx.online.net.",
            dns_zone="domain.tld",
            priority=10,
            ttl=3600,
            type="MX")
        mx2 = scaleway.DomainRecord("mx2",
            data="mx-cache.online.net.",
            dns_zone="domain.tld",
            priority=20,
            ttl=3600,
            type="MX")
        ```

        ### With dynamic records

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        geo_ip = scaleway.DomainRecord("geoIp",
            data="1.2.3.4",
            dns_zone="domain.tld",
            geo_ip=scaleway.DomainRecordGeoIpArgs(
                matches=[
                    scaleway.DomainRecordGeoIpMatchArgs(
                        continents=["EU"],
                        countries=["FR"],
                        data="1.2.3.5",
                    ),
                    scaleway.DomainRecordGeoIpMatchArgs(
                        continents=["NA"],
                        data="4.3.2.1",
                    ),
                ],
            ),
            ttl=3600,
            type="A")
        http_service = scaleway.DomainRecord("httpService",
            data="1.2.3.4",
            dns_zone="domain.tld",
            http_service=scaleway.DomainRecordHttpServiceArgs(
                ips=[
                    "1.2.3.5",
                    "1.2.3.6",
                ],
                must_contain="up",
                strategy="hashed",
                url="http://mywebsite.com/health",
                user_agent="scw_service_up",
            ),
            ttl=3600,
            type="A")
        view = scaleway.DomainRecord("view",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A",
            views=[
                scaleway.DomainRecordViewArgs(
                    data="1.2.3.5",
                    subnet="100.0.0.0/16",
                ),
                scaleway.DomainRecordViewArgs(
                    data="1.2.3.6",
                    subnet="100.1.0.0/16",
                ),
            ])
        weighted = scaleway.DomainRecord("weighted",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A",
            weighteds=[
                scaleway.DomainRecordWeightedArgs(
                    ip="1.2.3.5",
                    weight=1,
                ),
                scaleway.DomainRecordWeightedArgs(
                    ip="1.2.3.6",
                    weight=2,
                ),
            ])
        ```

        ### Create an instance and add records with the new instance IP

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        config = pulumi.Config()
        project_id = config.require("projectId")
        dns_zone = config.require("dnsZone")
        public_ip = scaleway.InstanceIp("publicIp", project_id=project_id)
        web = scaleway.InstanceServer("web",
            project_id=project_id,
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "front",
                "web",
            ],
            ip_id=public_ip.id,
            root_volume=scaleway.InstanceServerRootVolumeArgs(
                size_in_gb=20,
            ))
        web_a = scaleway.DomainRecord("webA",
            dns_zone=dns_zone,
            type="A",
            data=web.public_ip,
            ttl=3600)
        web_cname = scaleway.DomainRecord("webCname",
            dns_zone=dns_zone,
            type="CNAME",
            data=f"web.{dns_zone}.",
            ttl=3600)
        web_alias = scaleway.DomainRecord("webAlias",
            dns_zone=dns_zone,
            type="ALIAS",
            data=f"web.{dns_zone}.",
            ttl=3600)
        ```

        ## Multiple records

        Some record types can have multiple `data` with the same `name` (eg: `A`, `AAAA`, `MX`, `NS`...).\\
        You can duplicate a resource `DomainRecord` with the same `name`, the records will be added.

        Please note, some record (eg: `CNAME`, Multiple dynamic records of different types...) has to be unique.

        ## Import

        Record can be imported using the `{dns_zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/domainRecord:DomainRecord www subdomain.domain.tld/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[str] dns_zone: The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        :param pulumi.Input[pulumi.InputType['DomainRecordGeoIpArgs']] geo_ip: The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        :param pulumi.Input[pulumi.InputType['DomainRecordHttpServiceArgs']] http_service: The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        :param pulumi.Input[bool] keep_empty_zone: When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        :param pulumi.Input[str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[int] priority: The priority of the record (mostly used with an `MX` record)
        :param pulumi.Input[str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordViewArgs']]]] views: The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordWeightedArgs']]]] weighteds: You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Domain record.\\
        For more information, see [the documentation](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        www = scaleway.DomainRecord("www",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A")
        www2 = scaleway.DomainRecord("www2",
            data="1.2.3.5",
            dns_zone="domain.tld",
            ttl=3600,
            type="A")
        mx = scaleway.DomainRecord("mx",
            data="mx.online.net.",
            dns_zone="domain.tld",
            priority=10,
            ttl=3600,
            type="MX")
        mx2 = scaleway.DomainRecord("mx2",
            data="mx-cache.online.net.",
            dns_zone="domain.tld",
            priority=20,
            ttl=3600,
            type="MX")
        ```

        ### With dynamic records

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        geo_ip = scaleway.DomainRecord("geoIp",
            data="1.2.3.4",
            dns_zone="domain.tld",
            geo_ip=scaleway.DomainRecordGeoIpArgs(
                matches=[
                    scaleway.DomainRecordGeoIpMatchArgs(
                        continents=["EU"],
                        countries=["FR"],
                        data="1.2.3.5",
                    ),
                    scaleway.DomainRecordGeoIpMatchArgs(
                        continents=["NA"],
                        data="4.3.2.1",
                    ),
                ],
            ),
            ttl=3600,
            type="A")
        http_service = scaleway.DomainRecord("httpService",
            data="1.2.3.4",
            dns_zone="domain.tld",
            http_service=scaleway.DomainRecordHttpServiceArgs(
                ips=[
                    "1.2.3.5",
                    "1.2.3.6",
                ],
                must_contain="up",
                strategy="hashed",
                url="http://mywebsite.com/health",
                user_agent="scw_service_up",
            ),
            ttl=3600,
            type="A")
        view = scaleway.DomainRecord("view",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A",
            views=[
                scaleway.DomainRecordViewArgs(
                    data="1.2.3.5",
                    subnet="100.0.0.0/16",
                ),
                scaleway.DomainRecordViewArgs(
                    data="1.2.3.6",
                    subnet="100.1.0.0/16",
                ),
            ])
        weighted = scaleway.DomainRecord("weighted",
            data="1.2.3.4",
            dns_zone="domain.tld",
            ttl=3600,
            type="A",
            weighteds=[
                scaleway.DomainRecordWeightedArgs(
                    ip="1.2.3.5",
                    weight=1,
                ),
                scaleway.DomainRecordWeightedArgs(
                    ip="1.2.3.6",
                    weight=2,
                ),
            ])
        ```

        ### Create an instance and add records with the new instance IP

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        config = pulumi.Config()
        project_id = config.require("projectId")
        dns_zone = config.require("dnsZone")
        public_ip = scaleway.InstanceIp("publicIp", project_id=project_id)
        web = scaleway.InstanceServer("web",
            project_id=project_id,
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "front",
                "web",
            ],
            ip_id=public_ip.id,
            root_volume=scaleway.InstanceServerRootVolumeArgs(
                size_in_gb=20,
            ))
        web_a = scaleway.DomainRecord("webA",
            dns_zone=dns_zone,
            type="A",
            data=web.public_ip,
            ttl=3600)
        web_cname = scaleway.DomainRecord("webCname",
            dns_zone=dns_zone,
            type="CNAME",
            data=f"web.{dns_zone}.",
            ttl=3600)
        web_alias = scaleway.DomainRecord("webAlias",
            dns_zone=dns_zone,
            type="ALIAS",
            data=f"web.{dns_zone}.",
            ttl=3600)
        ```

        ## Multiple records

        Some record types can have multiple `data` with the same `name` (eg: `A`, `AAAA`, `MX`, `NS`...).\\
        You can duplicate a resource `DomainRecord` with the same `name`, the records will be added.

        Please note, some record (eg: `CNAME`, Multiple dynamic records of different types...) has to be unique.

        ## Import

        Record can be imported using the `{dns_zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/domainRecord:DomainRecord www subdomain.domain.tld/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DomainRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 dns_zone: Optional[pulumi.Input[str]] = None,
                 geo_ip: Optional[pulumi.Input[pulumi.InputType['DomainRecordGeoIpArgs']]] = None,
                 http_service: Optional[pulumi.Input[pulumi.InputType['DomainRecordHttpServiceArgs']]] = None,
                 keep_empty_zone: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordViewArgs']]]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordWeightedArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainRecordArgs.__new__(DomainRecordArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            if dns_zone is None and not opts.urn:
                raise TypeError("Missing required property 'dns_zone'")
            __props__.__dict__["dns_zone"] = dns_zone
            __props__.__dict__["geo_ip"] = geo_ip
            __props__.__dict__["http_service"] = http_service
            __props__.__dict__["keep_empty_zone"] = keep_empty_zone
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["views"] = views
            __props__.__dict__["weighteds"] = weighteds
            __props__.__dict__["root_zone"] = None
        super(DomainRecord, __self__).__init__(
            'scaleway:index/domainRecord:DomainRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[str]] = None,
            dns_zone: Optional[pulumi.Input[str]] = None,
            geo_ip: Optional[pulumi.Input[pulumi.InputType['DomainRecordGeoIpArgs']]] = None,
            http_service: Optional[pulumi.Input[pulumi.InputType['DomainRecordHttpServiceArgs']]] = None,
            keep_empty_zone: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            root_zone: Optional[pulumi.Input[bool]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordViewArgs']]]]] = None,
            weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordWeightedArgs']]]]] = None) -> 'DomainRecord':
        """
        Get an existing DomainRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: The data of the view record
        :param pulumi.Input[str] dns_zone: The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        :param pulumi.Input[pulumi.InputType['DomainRecordGeoIpArgs']] geo_ip: The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        :param pulumi.Input[pulumi.InputType['DomainRecordHttpServiceArgs']] http_service: The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        :param pulumi.Input[bool] keep_empty_zone: When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        :param pulumi.Input[str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[int] priority: The priority of the record (mostly used with an `MX` record)
        :param pulumi.Input[str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[bool] root_zone: Does the DNS zone is the root zone or not
        :param pulumi.Input[int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordViewArgs']]]] views: The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainRecordWeightedArgs']]]] weighteds: You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainRecordState.__new__(_DomainRecordState)

        __props__.__dict__["data"] = data
        __props__.__dict__["dns_zone"] = dns_zone
        __props__.__dict__["geo_ip"] = geo_ip
        __props__.__dict__["http_service"] = http_service
        __props__.__dict__["keep_empty_zone"] = keep_empty_zone
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["root_zone"] = root_zone
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["views"] = views
        __props__.__dict__["weighteds"] = weighteds
        return DomainRecord(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[str]:
        """
        The data of the view record
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> pulumi.Output[str]:
        """
        The DNS Zone of the domain. If the DNS zone doesn't exist, it will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> pulumi.Output[Optional['outputs.DomainRecordGeoIp']]:
        """
        The Geo IP feature provides DNS resolution, based on the user’s geographical location. You can define a default IP that resolves if no Geo IP rule matches, and specify IPs for each geographical zone. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#geo-ip-records)
        """
        return pulumi.get(self, "geo_ip")

    @property
    @pulumi.getter(name="httpService")
    def http_service(self) -> pulumi.Output[Optional['outputs.DomainRecordHttpService']]:
        """
        The DNS service checks the provided URL on the configured IPs and resolves the request to one of the IPs by excluding the ones not responding to the given string to check. [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#healthcheck-records)
        """
        return pulumi.get(self, "http_service")

    @property
    @pulumi.getter(name="keepEmptyZone")
    def keep_empty_zone(self) -> pulumi.Output[Optional[bool]]:
        """
        When destroying a resource, if only NS records remain and this is set to `false`, the zone will be deleted. Please note, each zone not deleted will [cost you money](https://www.scaleway.com/en/dns/)
        """
        return pulumi.get(self, "keep_empty_zone")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority of the record (mostly used with an `MX` record)
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="rootZone")
    def root_zone(self) -> pulumi.Output[bool]:
        """
        Does the DNS zone is the root zone or not
        """
        return pulumi.get(self, "root_zone")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def views(self) -> pulumi.Output[Optional[Sequence['outputs.DomainRecordView']]]:
        """
        The answer to a DNS request is based on the client’s (resolver) subnet. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#views-records)
        """
        return pulumi.get(self, "views")

    @property
    @pulumi.getter
    def weighteds(self) -> pulumi.Output[Optional[Sequence['outputs.DomainRecordWeighted']]]:
        """
        You provide a list of IPs with their corresponding weights. These weights are used to proportionally direct requests to each IP. Depending on the weight of a record more or fewer requests are answered with its related IP compared to the others in the list. *(Can be more than 1)* [Documentation and usage example](https://www.scaleway.com/en/docs/network/domains-and-dns/how-to/manage-dns-records/#weight-records)
        """
        return pulumi.get(self, "weighteds")

