"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnStaticIp = exports.CfnLoadBalancerTlsCertificate = exports.CfnLoadBalancer = exports.CfnInstance = exports.CfnDistribution = exports.CfnDisk = exports.CfnDatabase = exports.CfnContainer = exports.CfnCertificate = exports.CfnBucket = exports.CfnAlarm = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-06-22T22:39:40.568Z","fingerprint":"QjlYi4X4yBOIE91x294mPhLPpllcgi/XhdIduDAC8Ro="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAlarmProps`
 *
 * @param properties - the TypeScript properties of a `CfnAlarmProps`
 *
 * @returns the result of the validation.
 */
function CfnAlarmPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('alarmName', cdk.requiredValidator)(properties.alarmName));
    errors.collect(cdk.propertyValidator('alarmName', cdk.validateString)(properties.alarmName));
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.requiredValidator)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.validateString)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('contactProtocols', cdk.listValidator(cdk.validateString))(properties.contactProtocols));
    errors.collect(cdk.propertyValidator('datapointsToAlarm', cdk.validateNumber)(properties.datapointsToAlarm));
    errors.collect(cdk.propertyValidator('evaluationPeriods', cdk.requiredValidator)(properties.evaluationPeriods));
    errors.collect(cdk.propertyValidator('evaluationPeriods', cdk.validateNumber)(properties.evaluationPeriods));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('monitoredResourceName', cdk.requiredValidator)(properties.monitoredResourceName));
    errors.collect(cdk.propertyValidator('monitoredResourceName', cdk.validateString)(properties.monitoredResourceName));
    errors.collect(cdk.propertyValidator('notificationEnabled', cdk.validateBoolean)(properties.notificationEnabled));
    errors.collect(cdk.propertyValidator('notificationTriggers', cdk.listValidator(cdk.validateString))(properties.notificationTriggers));
    errors.collect(cdk.propertyValidator('threshold', cdk.requiredValidator)(properties.threshold));
    errors.collect(cdk.propertyValidator('threshold', cdk.validateNumber)(properties.threshold));
    errors.collect(cdk.propertyValidator('treatMissingData', cdk.validateString)(properties.treatMissingData));
    return errors.wrap('supplied properties not correct for "CfnAlarmProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Alarm` resource
 *
 * @param properties - the TypeScript properties of a `CfnAlarmProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Alarm` resource.
 */
// @ts-ignore TS6133
function cfnAlarmPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAlarmPropsValidator(properties).assertSuccess();
    return {
        AlarmName: cdk.stringToCloudFormation(properties.alarmName),
        ComparisonOperator: cdk.stringToCloudFormation(properties.comparisonOperator),
        EvaluationPeriods: cdk.numberToCloudFormation(properties.evaluationPeriods),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        MonitoredResourceName: cdk.stringToCloudFormation(properties.monitoredResourceName),
        Threshold: cdk.numberToCloudFormation(properties.threshold),
        ContactProtocols: cdk.listMapper(cdk.stringToCloudFormation)(properties.contactProtocols),
        DatapointsToAlarm: cdk.numberToCloudFormation(properties.datapointsToAlarm),
        NotificationEnabled: cdk.booleanToCloudFormation(properties.notificationEnabled),
        NotificationTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationTriggers),
        TreatMissingData: cdk.stringToCloudFormation(properties.treatMissingData),
    };
}
// @ts-ignore TS6133
function CfnAlarmPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('alarmName', 'AlarmName', cfn_parse.FromCloudFormation.getString(properties.AlarmName));
    ret.addPropertyResult('comparisonOperator', 'ComparisonOperator', cfn_parse.FromCloudFormation.getString(properties.ComparisonOperator));
    ret.addPropertyResult('evaluationPeriods', 'EvaluationPeriods', cfn_parse.FromCloudFormation.getNumber(properties.EvaluationPeriods));
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('monitoredResourceName', 'MonitoredResourceName', cfn_parse.FromCloudFormation.getString(properties.MonitoredResourceName));
    ret.addPropertyResult('threshold', 'Threshold', cfn_parse.FromCloudFormation.getNumber(properties.Threshold));
    ret.addPropertyResult('contactProtocols', 'ContactProtocols', properties.ContactProtocols != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContactProtocols) : undefined);
    ret.addPropertyResult('datapointsToAlarm', 'DatapointsToAlarm', properties.DatapointsToAlarm != null ? cfn_parse.FromCloudFormation.getNumber(properties.DatapointsToAlarm) : undefined);
    ret.addPropertyResult('notificationEnabled', 'NotificationEnabled', properties.NotificationEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NotificationEnabled) : undefined);
    ret.addPropertyResult('notificationTriggers', 'NotificationTriggers', properties.NotificationTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotificationTriggers) : undefined);
    ret.addPropertyResult('treatMissingData', 'TreatMissingData', properties.TreatMissingData != null ? cfn_parse.FromCloudFormation.getString(properties.TreatMissingData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Alarm`
 *
 * The `AWS::Lightsail::Alarm` resource specifies an alarm that can be used to monitor a single metric for one of your Lightsail resources.
 *
 * @cloudformationResource AWS::Lightsail::Alarm
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-alarm.html
 */
class CfnAlarm extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Alarm`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlarm.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnAlarmProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAlarm);
            }
            throw error;
        }
        cdk.requireProperty(props, 'alarmName', this);
        cdk.requireProperty(props, 'comparisonOperator', this);
        cdk.requireProperty(props, 'evaluationPeriods', this);
        cdk.requireProperty(props, 'metricName', this);
        cdk.requireProperty(props, 'monitoredResourceName', this);
        cdk.requireProperty(props, 'threshold', this);
        this.attrAlarmArn = cdk.Token.asString(this.getAtt('AlarmArn'));
        this.attrState = cdk.Token.asString(this.getAtt('State'));
        this.alarmName = props.alarmName;
        this.comparisonOperator = props.comparisonOperator;
        this.evaluationPeriods = props.evaluationPeriods;
        this.metricName = props.metricName;
        this.monitoredResourceName = props.monitoredResourceName;
        this.threshold = props.threshold;
        this.contactProtocols = props.contactProtocols;
        this.datapointsToAlarm = props.datapointsToAlarm;
        this.notificationEnabled = props.notificationEnabled;
        this.notificationTriggers = props.notificationTriggers;
        this.treatMissingData = props.treatMissingData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAlarmPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlarm(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlarm.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            alarmName: this.alarmName,
            comparisonOperator: this.comparisonOperator,
            evaluationPeriods: this.evaluationPeriods,
            metricName: this.metricName,
            monitoredResourceName: this.monitoredResourceName,
            threshold: this.threshold,
            contactProtocols: this.contactProtocols,
            datapointsToAlarm: this.datapointsToAlarm,
            notificationEnabled: this.notificationEnabled,
            notificationTriggers: this.notificationTriggers,
            treatMissingData: this.treatMissingData,
        };
    }
    renderProperties(props) {
        return cfnAlarmPropsToCloudFormation(props);
    }
}
exports.CfnAlarm = CfnAlarm;
_a = JSII_RTTI_SYMBOL_1;
CfnAlarm[_a] = { fqn: "@aws-cdk/aws-lightsail.CfnAlarm", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlarm.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Alarm";
/**
 * Determine whether the given properties match those of a `CfnBucketProps`
 *
 * @param properties - the TypeScript properties of a `CfnBucketProps`
 *
 * @returns the result of the validation.
 */
function CfnBucketPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessRules', CfnBucket_AccessRulesPropertyValidator)(properties.accessRules));
    errors.collect(cdk.propertyValidator('bucketName', cdk.requiredValidator)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('bundleId', cdk.requiredValidator)(properties.bundleId));
    errors.collect(cdk.propertyValidator('bundleId', cdk.validateString)(properties.bundleId));
    errors.collect(cdk.propertyValidator('objectVersioning', cdk.validateBoolean)(properties.objectVersioning));
    errors.collect(cdk.propertyValidator('readOnlyAccessAccounts', cdk.listValidator(cdk.validateString))(properties.readOnlyAccessAccounts));
    errors.collect(cdk.propertyValidator('resourcesReceivingAccess', cdk.listValidator(cdk.validateString))(properties.resourcesReceivingAccess));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnBucketProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Bucket` resource
 *
 * @param properties - the TypeScript properties of a `CfnBucketProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Bucket` resource.
 */
// @ts-ignore TS6133
function cfnBucketPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBucketPropsValidator(properties).assertSuccess();
    return {
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        BundleId: cdk.stringToCloudFormation(properties.bundleId),
        AccessRules: cfnBucketAccessRulesPropertyToCloudFormation(properties.accessRules),
        ObjectVersioning: cdk.booleanToCloudFormation(properties.objectVersioning),
        ReadOnlyAccessAccounts: cdk.listMapper(cdk.stringToCloudFormation)(properties.readOnlyAccessAccounts),
        ResourcesReceivingAccess: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourcesReceivingAccess),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnBucketPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucketName', 'BucketName', cfn_parse.FromCloudFormation.getString(properties.BucketName));
    ret.addPropertyResult('bundleId', 'BundleId', cfn_parse.FromCloudFormation.getString(properties.BundleId));
    ret.addPropertyResult('accessRules', 'AccessRules', properties.AccessRules != null ? CfnBucketAccessRulesPropertyFromCloudFormation(properties.AccessRules) : undefined);
    ret.addPropertyResult('objectVersioning', 'ObjectVersioning', properties.ObjectVersioning != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ObjectVersioning) : undefined);
    ret.addPropertyResult('readOnlyAccessAccounts', 'ReadOnlyAccessAccounts', properties.ReadOnlyAccessAccounts != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ReadOnlyAccessAccounts) : undefined);
    ret.addPropertyResult('resourcesReceivingAccess', 'ResourcesReceivingAccess', properties.ResourcesReceivingAccess != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourcesReceivingAccess) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Bucket`
 *
 * The `AWS::Lightsail::Bucket` resource specifies a bucket.
 *
 * @cloudformationResource AWS::Lightsail::Bucket
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html
 */
class CfnBucket extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Bucket`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnBucket.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnBucketProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnBucket);
            }
            throw error;
        }
        cdk.requireProperty(props, 'bucketName', this);
        cdk.requireProperty(props, 'bundleId', this);
        this.attrAbleToUpdateBundle = this.getAtt('AbleToUpdateBundle');
        this.attrBucketArn = cdk.Token.asString(this.getAtt('BucketArn'));
        this.attrUrl = cdk.Token.asString(this.getAtt('Url'));
        this.bucketName = props.bucketName;
        this.bundleId = props.bundleId;
        this.accessRules = props.accessRules;
        this.objectVersioning = props.objectVersioning;
        this.readOnlyAccessAccounts = props.readOnlyAccessAccounts;
        this.resourcesReceivingAccess = props.resourcesReceivingAccess;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Bucket", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnBucketPropsFromCloudFormation(resourceProperties);
        const ret = new CfnBucket(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnBucket.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            bucketName: this.bucketName,
            bundleId: this.bundleId,
            accessRules: this.accessRules,
            objectVersioning: this.objectVersioning,
            readOnlyAccessAccounts: this.readOnlyAccessAccounts,
            resourcesReceivingAccess: this.resourcesReceivingAccess,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnBucketPropsToCloudFormation(props);
    }
}
exports.CfnBucket = CfnBucket;
_b = JSII_RTTI_SYMBOL_1;
CfnBucket[_b] = { fqn: "@aws-cdk/aws-lightsail.CfnBucket", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnBucket.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Bucket";
/**
 * Determine whether the given properties match those of a `AccessRulesProperty`
 *
 * @param properties - the TypeScript properties of a `AccessRulesProperty`
 *
 * @returns the result of the validation.
 */
function CfnBucket_AccessRulesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowPublicOverrides', cdk.validateBoolean)(properties.allowPublicOverrides));
    errors.collect(cdk.propertyValidator('objectAccess', cdk.validateString)(properties.objectAccess));
    return errors.wrap('supplied properties not correct for "AccessRulesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Bucket.AccessRules` resource
 *
 * @param properties - the TypeScript properties of a `AccessRulesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Bucket.AccessRules` resource.
 */
// @ts-ignore TS6133
function cfnBucketAccessRulesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnBucket_AccessRulesPropertyValidator(properties).assertSuccess();
    return {
        AllowPublicOverrides: cdk.booleanToCloudFormation(properties.allowPublicOverrides),
        GetObject: cdk.stringToCloudFormation(properties.objectAccess),
    };
}
// @ts-ignore TS6133
function CfnBucketAccessRulesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowPublicOverrides', 'AllowPublicOverrides', properties.AllowPublicOverrides != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowPublicOverrides) : undefined);
    ret.addPropertyResult('objectAccess', 'GetObject', properties.GetObject != null ? cfn_parse.FromCloudFormation.getString(properties.GetObject) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnCertificateProps`
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the result of the validation.
 */
function CfnCertificatePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateName', cdk.requiredValidator)(properties.certificateName));
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('subjectAlternativeNames', cdk.listValidator(cdk.validateString))(properties.subjectAlternativeNames));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnCertificateProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Certificate` resource
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Certificate` resource.
 */
// @ts-ignore TS6133
function cfnCertificatePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCertificatePropsValidator(properties).assertSuccess();
    return {
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        SubjectAlternativeNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.subjectAlternativeNames),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnCertificatePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateName', 'CertificateName', cfn_parse.FromCloudFormation.getString(properties.CertificateName));
    ret.addPropertyResult('domainName', 'DomainName', cfn_parse.FromCloudFormation.getString(properties.DomainName));
    ret.addPropertyResult('subjectAlternativeNames', 'SubjectAlternativeNames', properties.SubjectAlternativeNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubjectAlternativeNames) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Certificate`
 *
 * The `AWS::Lightsail::Certificate` resource specifies an SSL/TLS certificate that you can use with a content delivery network (CDN) distribution and a container service.
 *
 * > For information about certificates that you can use with a load balancer, see [AWS::Lightsail::LoadBalancerTlsCertificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html) .
 *
 * @cloudformationResource AWS::Lightsail::Certificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html
 */
class CfnCertificate extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCertificate.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnCertificateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnCertificate);
            }
            throw error;
        }
        cdk.requireProperty(props, 'certificateName', this);
        cdk.requireProperty(props, 'domainName', this);
        this.attrCertificateArn = cdk.Token.asString(this.getAtt('CertificateArn'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.certificateName = props.certificateName;
        this.domainName = props.domainName;
        this.subjectAlternativeNames = props.subjectAlternativeNames;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Certificate", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCertificatePropsFromCloudFormation(resourceProperties);
        const ret = new CfnCertificate(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCertificate.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            certificateName: this.certificateName,
            domainName: this.domainName,
            subjectAlternativeNames: this.subjectAlternativeNames,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnCertificatePropsToCloudFormation(props);
    }
}
exports.CfnCertificate = CfnCertificate;
_c = JSII_RTTI_SYMBOL_1;
CfnCertificate[_c] = { fqn: "@aws-cdk/aws-lightsail.CfnCertificate", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCertificate.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Certificate";
/**
 * Determine whether the given properties match those of a `CfnContainerProps`
 *
 * @param properties - the TypeScript properties of a `CfnContainerProps`
 *
 * @returns the result of the validation.
 */
function CfnContainerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerServiceDeployment', CfnContainer_ContainerServiceDeploymentPropertyValidator)(properties.containerServiceDeployment));
    errors.collect(cdk.propertyValidator('isDisabled', cdk.validateBoolean)(properties.isDisabled));
    errors.collect(cdk.propertyValidator('power', cdk.requiredValidator)(properties.power));
    errors.collect(cdk.propertyValidator('power', cdk.validateString)(properties.power));
    errors.collect(cdk.propertyValidator('publicDomainNames', cdk.listValidator(CfnContainer_PublicDomainNamePropertyValidator))(properties.publicDomainNames));
    errors.collect(cdk.propertyValidator('scale', cdk.requiredValidator)(properties.scale));
    errors.collect(cdk.propertyValidator('scale', cdk.validateNumber)(properties.scale));
    errors.collect(cdk.propertyValidator('serviceName', cdk.requiredValidator)(properties.serviceName));
    errors.collect(cdk.propertyValidator('serviceName', cdk.validateString)(properties.serviceName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnContainerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container` resource
 *
 * @param properties - the TypeScript properties of a `CfnContainerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container` resource.
 */
// @ts-ignore TS6133
function cfnContainerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainerPropsValidator(properties).assertSuccess();
    return {
        Power: cdk.stringToCloudFormation(properties.power),
        Scale: cdk.numberToCloudFormation(properties.scale),
        ServiceName: cdk.stringToCloudFormation(properties.serviceName),
        ContainerServiceDeployment: cfnContainerContainerServiceDeploymentPropertyToCloudFormation(properties.containerServiceDeployment),
        IsDisabled: cdk.booleanToCloudFormation(properties.isDisabled),
        PublicDomainNames: cdk.listMapper(cfnContainerPublicDomainNamePropertyToCloudFormation)(properties.publicDomainNames),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnContainerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('power', 'Power', cfn_parse.FromCloudFormation.getString(properties.Power));
    ret.addPropertyResult('scale', 'Scale', cfn_parse.FromCloudFormation.getNumber(properties.Scale));
    ret.addPropertyResult('serviceName', 'ServiceName', cfn_parse.FromCloudFormation.getString(properties.ServiceName));
    ret.addPropertyResult('containerServiceDeployment', 'ContainerServiceDeployment', properties.ContainerServiceDeployment != null ? CfnContainerContainerServiceDeploymentPropertyFromCloudFormation(properties.ContainerServiceDeployment) : undefined);
    ret.addPropertyResult('isDisabled', 'IsDisabled', properties.IsDisabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsDisabled) : undefined);
    ret.addPropertyResult('publicDomainNames', 'PublicDomainNames', properties.PublicDomainNames != null ? cfn_parse.FromCloudFormation.getArray(CfnContainerPublicDomainNamePropertyFromCloudFormation)(properties.PublicDomainNames) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Container`
 *
 * The `AWS::Lightsail::Container` resource specifies a container service.
 *
 * A Lightsail container service is a compute resource to which you can deploy containers.
 *
 * @cloudformationResource AWS::Lightsail::Container
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html
 */
class CfnContainer extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Container`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnContainer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnContainerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnContainer);
            }
            throw error;
        }
        cdk.requireProperty(props, 'power', this);
        cdk.requireProperty(props, 'scale', this);
        cdk.requireProperty(props, 'serviceName', this);
        this.attrContainerArn = cdk.Token.asString(this.getAtt('ContainerArn'));
        this.attrUrl = cdk.Token.asString(this.getAtt('Url'));
        this.power = props.power;
        this.scale = props.scale;
        this.serviceName = props.serviceName;
        this.containerServiceDeployment = props.containerServiceDeployment;
        this.isDisabled = props.isDisabled;
        this.publicDomainNames = props.publicDomainNames;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Container", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnContainerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnContainer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnContainer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            power: this.power,
            scale: this.scale,
            serviceName: this.serviceName,
            containerServiceDeployment: this.containerServiceDeployment,
            isDisabled: this.isDisabled,
            publicDomainNames: this.publicDomainNames,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnContainerPropsToCloudFormation(props);
    }
}
exports.CfnContainer = CfnContainer;
_d = JSII_RTTI_SYMBOL_1;
CfnContainer[_d] = { fqn: "@aws-cdk/aws-lightsail.CfnContainer", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnContainer.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Container";
/**
 * Determine whether the given properties match those of a `ContainerProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_ContainerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('command', cdk.listValidator(cdk.validateString))(properties.command));
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('environment', cdk.listValidator(CfnContainer_EnvironmentVariablePropertyValidator))(properties.environment));
    errors.collect(cdk.propertyValidator('image', cdk.validateString)(properties.image));
    errors.collect(cdk.propertyValidator('ports', cdk.listValidator(CfnContainer_PortInfoPropertyValidator))(properties.ports));
    return errors.wrap('supplied properties not correct for "ContainerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.Container` resource
 *
 * @param properties - the TypeScript properties of a `ContainerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.Container` resource.
 */
// @ts-ignore TS6133
function cfnContainerContainerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_ContainerPropertyValidator(properties).assertSuccess();
    return {
        Command: cdk.listMapper(cdk.stringToCloudFormation)(properties.command),
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        Environment: cdk.listMapper(cfnContainerEnvironmentVariablePropertyToCloudFormation)(properties.environment),
        Image: cdk.stringToCloudFormation(properties.image),
        Ports: cdk.listMapper(cfnContainerPortInfoPropertyToCloudFormation)(properties.ports),
    };
}
// @ts-ignore TS6133
function CfnContainerContainerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('command', 'Command', properties.Command != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Command) : undefined);
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getArray(CfnContainerEnvironmentVariablePropertyFromCloudFormation)(properties.Environment) : undefined);
    ret.addPropertyResult('image', 'Image', properties.Image != null ? cfn_parse.FromCloudFormation.getString(properties.Image) : undefined);
    ret.addPropertyResult('ports', 'Ports', properties.Ports != null ? cfn_parse.FromCloudFormation.getArray(CfnContainerPortInfoPropertyFromCloudFormation)(properties.Ports) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContainerServiceDeploymentProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerServiceDeploymentProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_ContainerServiceDeploymentPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containers', cdk.listValidator(CfnContainer_ContainerPropertyValidator))(properties.containers));
    errors.collect(cdk.propertyValidator('publicEndpoint', CfnContainer_PublicEndpointPropertyValidator)(properties.publicEndpoint));
    return errors.wrap('supplied properties not correct for "ContainerServiceDeploymentProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.ContainerServiceDeployment` resource
 *
 * @param properties - the TypeScript properties of a `ContainerServiceDeploymentProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.ContainerServiceDeployment` resource.
 */
// @ts-ignore TS6133
function cfnContainerContainerServiceDeploymentPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_ContainerServiceDeploymentPropertyValidator(properties).assertSuccess();
    return {
        Containers: cdk.listMapper(cfnContainerContainerPropertyToCloudFormation)(properties.containers),
        PublicEndpoint: cfnContainerPublicEndpointPropertyToCloudFormation(properties.publicEndpoint),
    };
}
// @ts-ignore TS6133
function CfnContainerContainerServiceDeploymentPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containers', 'Containers', properties.Containers != null ? cfn_parse.FromCloudFormation.getArray(CfnContainerContainerPropertyFromCloudFormation)(properties.Containers) : undefined);
    ret.addPropertyResult('publicEndpoint', 'PublicEndpoint', properties.PublicEndpoint != null ? CfnContainerPublicEndpointPropertyFromCloudFormation(properties.PublicEndpoint) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EnvironmentVariableProperty`
 *
 * @param properties - the TypeScript properties of a `EnvironmentVariableProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_EnvironmentVariablePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    errors.collect(cdk.propertyValidator('variable', cdk.validateString)(properties.variable));
    return errors.wrap('supplied properties not correct for "EnvironmentVariableProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.EnvironmentVariable` resource
 *
 * @param properties - the TypeScript properties of a `EnvironmentVariableProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.EnvironmentVariable` resource.
 */
// @ts-ignore TS6133
function cfnContainerEnvironmentVariablePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_EnvironmentVariablePropertyValidator(properties).assertSuccess();
    return {
        Value: cdk.stringToCloudFormation(properties.value),
        Variable: cdk.stringToCloudFormation(properties.variable),
    };
}
// @ts-ignore TS6133
function CfnContainerEnvironmentVariablePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addPropertyResult('variable', 'Variable', properties.Variable != null ? cfn_parse.FromCloudFormation.getString(properties.Variable) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_HealthCheckConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('healthyThreshold', cdk.validateNumber)(properties.healthyThreshold));
    errors.collect(cdk.propertyValidator('intervalSeconds', cdk.validateNumber)(properties.intervalSeconds));
    errors.collect(cdk.propertyValidator('path', cdk.validateString)(properties.path));
    errors.collect(cdk.propertyValidator('successCodes', cdk.validateString)(properties.successCodes));
    errors.collect(cdk.propertyValidator('timeoutSeconds', cdk.validateNumber)(properties.timeoutSeconds));
    errors.collect(cdk.propertyValidator('unhealthyThreshold', cdk.validateNumber)(properties.unhealthyThreshold));
    return errors.wrap('supplied properties not correct for "HealthCheckConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.HealthCheckConfig` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.HealthCheckConfig` resource.
 */
// @ts-ignore TS6133
function cfnContainerHealthCheckConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_HealthCheckConfigPropertyValidator(properties).assertSuccess();
    return {
        HealthyThreshold: cdk.numberToCloudFormation(properties.healthyThreshold),
        IntervalSeconds: cdk.numberToCloudFormation(properties.intervalSeconds),
        Path: cdk.stringToCloudFormation(properties.path),
        SuccessCodes: cdk.stringToCloudFormation(properties.successCodes),
        TimeoutSeconds: cdk.numberToCloudFormation(properties.timeoutSeconds),
        UnhealthyThreshold: cdk.numberToCloudFormation(properties.unhealthyThreshold),
    };
}
// @ts-ignore TS6133
function CfnContainerHealthCheckConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('healthyThreshold', 'HealthyThreshold', properties.HealthyThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthyThreshold) : undefined);
    ret.addPropertyResult('intervalSeconds', 'IntervalSeconds', properties.IntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.IntervalSeconds) : undefined);
    ret.addPropertyResult('path', 'Path', properties.Path != null ? cfn_parse.FromCloudFormation.getString(properties.Path) : undefined);
    ret.addPropertyResult('successCodes', 'SuccessCodes', properties.SuccessCodes != null ? cfn_parse.FromCloudFormation.getString(properties.SuccessCodes) : undefined);
    ret.addPropertyResult('timeoutSeconds', 'TimeoutSeconds', properties.TimeoutSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeoutSeconds) : undefined);
    ret.addPropertyResult('unhealthyThreshold', 'UnhealthyThreshold', properties.UnhealthyThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.UnhealthyThreshold) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PortInfoProperty`
 *
 * @param properties - the TypeScript properties of a `PortInfoProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_PortInfoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    errors.collect(cdk.propertyValidator('protocol', cdk.validateString)(properties.protocol));
    return errors.wrap('supplied properties not correct for "PortInfoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.PortInfo` resource
 *
 * @param properties - the TypeScript properties of a `PortInfoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.PortInfo` resource.
 */
// @ts-ignore TS6133
function cfnContainerPortInfoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_PortInfoPropertyValidator(properties).assertSuccess();
    return {
        Port: cdk.stringToCloudFormation(properties.port),
        Protocol: cdk.stringToCloudFormation(properties.protocol),
    };
}
// @ts-ignore TS6133
function CfnContainerPortInfoPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addPropertyResult('protocol', 'Protocol', properties.Protocol != null ? cfn_parse.FromCloudFormation.getString(properties.Protocol) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PublicDomainNameProperty`
 *
 * @param properties - the TypeScript properties of a `PublicDomainNameProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_PublicDomainNamePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('domainNames', cdk.listValidator(cdk.validateString))(properties.domainNames));
    return errors.wrap('supplied properties not correct for "PublicDomainNameProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.PublicDomainName` resource
 *
 * @param properties - the TypeScript properties of a `PublicDomainNameProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.PublicDomainName` resource.
 */
// @ts-ignore TS6133
function cfnContainerPublicDomainNamePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_PublicDomainNamePropertyValidator(properties).assertSuccess();
    return {
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        DomainNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.domainNames),
    };
}
// @ts-ignore TS6133
function CfnContainerPublicDomainNamePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateName', 'CertificateName', properties.CertificateName != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateName) : undefined);
    ret.addPropertyResult('domainNames', 'DomainNames', properties.DomainNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DomainNames) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PublicEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `PublicEndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnContainer_PublicEndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('healthCheckConfig', CfnContainer_HealthCheckConfigPropertyValidator)(properties.healthCheckConfig));
    return errors.wrap('supplied properties not correct for "PublicEndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Container.PublicEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `PublicEndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Container.PublicEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnContainerPublicEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnContainer_PublicEndpointPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        HealthCheckConfig: cfnContainerHealthCheckConfigPropertyToCloudFormation(properties.healthCheckConfig),
    };
}
// @ts-ignore TS6133
function CfnContainerPublicEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('containerPort', 'ContainerPort', properties.ContainerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort) : undefined);
    ret.addPropertyResult('healthCheckConfig', 'HealthCheckConfig', properties.HealthCheckConfig != null ? CfnContainerHealthCheckConfigPropertyFromCloudFormation(properties.HealthCheckConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDatabaseProps`
 *
 * @param properties - the TypeScript properties of a `CfnDatabaseProps`
 *
 * @returns the result of the validation.
 */
function CfnDatabasePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('backupRetention', cdk.validateBoolean)(properties.backupRetention));
    errors.collect(cdk.propertyValidator('caCertificateIdentifier', cdk.validateString)(properties.caCertificateIdentifier));
    errors.collect(cdk.propertyValidator('masterDatabaseName', cdk.requiredValidator)(properties.masterDatabaseName));
    errors.collect(cdk.propertyValidator('masterDatabaseName', cdk.validateString)(properties.masterDatabaseName));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.requiredValidator)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('relationalDatabaseBlueprintId', cdk.requiredValidator)(properties.relationalDatabaseBlueprintId));
    errors.collect(cdk.propertyValidator('relationalDatabaseBlueprintId', cdk.validateString)(properties.relationalDatabaseBlueprintId));
    errors.collect(cdk.propertyValidator('relationalDatabaseBundleId', cdk.requiredValidator)(properties.relationalDatabaseBundleId));
    errors.collect(cdk.propertyValidator('relationalDatabaseBundleId', cdk.validateString)(properties.relationalDatabaseBundleId));
    errors.collect(cdk.propertyValidator('relationalDatabaseName', cdk.requiredValidator)(properties.relationalDatabaseName));
    errors.collect(cdk.propertyValidator('relationalDatabaseName', cdk.validateString)(properties.relationalDatabaseName));
    errors.collect(cdk.propertyValidator('relationalDatabaseParameters', cdk.listValidator(CfnDatabase_RelationalDatabaseParameterPropertyValidator))(properties.relationalDatabaseParameters));
    errors.collect(cdk.propertyValidator('rotateMasterUserPassword', cdk.validateBoolean)(properties.rotateMasterUserPassword));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDatabaseProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Database` resource
 *
 * @param properties - the TypeScript properties of a `CfnDatabaseProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Database` resource.
 */
// @ts-ignore TS6133
function cfnDatabasePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatabasePropsValidator(properties).assertSuccess();
    return {
        MasterDatabaseName: cdk.stringToCloudFormation(properties.masterDatabaseName),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        RelationalDatabaseBlueprintId: cdk.stringToCloudFormation(properties.relationalDatabaseBlueprintId),
        RelationalDatabaseBundleId: cdk.stringToCloudFormation(properties.relationalDatabaseBundleId),
        RelationalDatabaseName: cdk.stringToCloudFormation(properties.relationalDatabaseName),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        BackupRetention: cdk.booleanToCloudFormation(properties.backupRetention),
        CaCertificateIdentifier: cdk.stringToCloudFormation(properties.caCertificateIdentifier),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        RelationalDatabaseParameters: cdk.listMapper(cfnDatabaseRelationalDatabaseParameterPropertyToCloudFormation)(properties.relationalDatabaseParameters),
        RotateMasterUserPassword: cdk.booleanToCloudFormation(properties.rotateMasterUserPassword),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDatabasePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('masterDatabaseName', 'MasterDatabaseName', cfn_parse.FromCloudFormation.getString(properties.MasterDatabaseName));
    ret.addPropertyResult('masterUsername', 'MasterUsername', cfn_parse.FromCloudFormation.getString(properties.MasterUsername));
    ret.addPropertyResult('relationalDatabaseBlueprintId', 'RelationalDatabaseBlueprintId', cfn_parse.FromCloudFormation.getString(properties.RelationalDatabaseBlueprintId));
    ret.addPropertyResult('relationalDatabaseBundleId', 'RelationalDatabaseBundleId', cfn_parse.FromCloudFormation.getString(properties.RelationalDatabaseBundleId));
    ret.addPropertyResult('relationalDatabaseName', 'RelationalDatabaseName', cfn_parse.FromCloudFormation.getString(properties.RelationalDatabaseName));
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('backupRetention', 'BackupRetention', properties.BackupRetention != null ? cfn_parse.FromCloudFormation.getBoolean(properties.BackupRetention) : undefined);
    ret.addPropertyResult('caCertificateIdentifier', 'CaCertificateIdentifier', properties.CaCertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CaCertificateIdentifier) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('relationalDatabaseParameters', 'RelationalDatabaseParameters', properties.RelationalDatabaseParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnDatabaseRelationalDatabaseParameterPropertyFromCloudFormation)(properties.RelationalDatabaseParameters) : undefined);
    ret.addPropertyResult('rotateMasterUserPassword', 'RotateMasterUserPassword', properties.RotateMasterUserPassword != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RotateMasterUserPassword) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Database`
 *
 * The `AWS::Lightsail::Database` resource specifies an Amazon Lightsail database.
 *
 * @cloudformationResource AWS::Lightsail::Database
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html
 */
class CfnDatabase extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Database`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDatabase.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnDatabaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDatabase);
            }
            throw error;
        }
        cdk.requireProperty(props, 'masterDatabaseName', this);
        cdk.requireProperty(props, 'masterUsername', this);
        cdk.requireProperty(props, 'relationalDatabaseBlueprintId', this);
        cdk.requireProperty(props, 'relationalDatabaseBundleId', this);
        cdk.requireProperty(props, 'relationalDatabaseName', this);
        this.attrDatabaseArn = cdk.Token.asString(this.getAtt('DatabaseArn'));
        this.masterDatabaseName = props.masterDatabaseName;
        this.masterUsername = props.masterUsername;
        this.relationalDatabaseBlueprintId = props.relationalDatabaseBlueprintId;
        this.relationalDatabaseBundleId = props.relationalDatabaseBundleId;
        this.relationalDatabaseName = props.relationalDatabaseName;
        this.availabilityZone = props.availabilityZone;
        this.backupRetention = props.backupRetention;
        this.caCertificateIdentifier = props.caCertificateIdentifier;
        this.masterUserPassword = props.masterUserPassword;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.publiclyAccessible = props.publiclyAccessible;
        this.relationalDatabaseParameters = props.relationalDatabaseParameters;
        this.rotateMasterUserPassword = props.rotateMasterUserPassword;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Database", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDatabasePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDatabase(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDatabase.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            masterDatabaseName: this.masterDatabaseName,
            masterUsername: this.masterUsername,
            relationalDatabaseBlueprintId: this.relationalDatabaseBlueprintId,
            relationalDatabaseBundleId: this.relationalDatabaseBundleId,
            relationalDatabaseName: this.relationalDatabaseName,
            availabilityZone: this.availabilityZone,
            backupRetention: this.backupRetention,
            caCertificateIdentifier: this.caCertificateIdentifier,
            masterUserPassword: this.masterUserPassword,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            publiclyAccessible: this.publiclyAccessible,
            relationalDatabaseParameters: this.relationalDatabaseParameters,
            rotateMasterUserPassword: this.rotateMasterUserPassword,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDatabasePropsToCloudFormation(props);
    }
}
exports.CfnDatabase = CfnDatabase;
_e = JSII_RTTI_SYMBOL_1;
CfnDatabase[_e] = { fqn: "@aws-cdk/aws-lightsail.CfnDatabase", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDatabase.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Database";
/**
 * Determine whether the given properties match those of a `RelationalDatabaseParameterProperty`
 *
 * @param properties - the TypeScript properties of a `RelationalDatabaseParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnDatabase_RelationalDatabaseParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowedValues', cdk.validateString)(properties.allowedValues));
    errors.collect(cdk.propertyValidator('applyMethod', cdk.validateString)(properties.applyMethod));
    errors.collect(cdk.propertyValidator('applyType', cdk.validateString)(properties.applyType));
    errors.collect(cdk.propertyValidator('dataType', cdk.validateString)(properties.dataType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('isModifiable', cdk.validateBoolean)(properties.isModifiable));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.validateString)(properties.parameterValue));
    return errors.wrap('supplied properties not correct for "RelationalDatabaseParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Database.RelationalDatabaseParameter` resource
 *
 * @param properties - the TypeScript properties of a `RelationalDatabaseParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Database.RelationalDatabaseParameter` resource.
 */
// @ts-ignore TS6133
function cfnDatabaseRelationalDatabaseParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDatabase_RelationalDatabaseParameterPropertyValidator(properties).assertSuccess();
    return {
        AllowedValues: cdk.stringToCloudFormation(properties.allowedValues),
        ApplyMethod: cdk.stringToCloudFormation(properties.applyMethod),
        ApplyType: cdk.stringToCloudFormation(properties.applyType),
        DataType: cdk.stringToCloudFormation(properties.dataType),
        Description: cdk.stringToCloudFormation(properties.description),
        IsModifiable: cdk.booleanToCloudFormation(properties.isModifiable),
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        ParameterValue: cdk.stringToCloudFormation(properties.parameterValue),
    };
}
// @ts-ignore TS6133
function CfnDatabaseRelationalDatabaseParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowedValues', 'AllowedValues', properties.AllowedValues != null ? cfn_parse.FromCloudFormation.getString(properties.AllowedValues) : undefined);
    ret.addPropertyResult('applyMethod', 'ApplyMethod', properties.ApplyMethod != null ? cfn_parse.FromCloudFormation.getString(properties.ApplyMethod) : undefined);
    ret.addPropertyResult('applyType', 'ApplyType', properties.ApplyType != null ? cfn_parse.FromCloudFormation.getString(properties.ApplyType) : undefined);
    ret.addPropertyResult('dataType', 'DataType', properties.DataType != null ? cfn_parse.FromCloudFormation.getString(properties.DataType) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('isModifiable', 'IsModifiable', properties.IsModifiable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsModifiable) : undefined);
    ret.addPropertyResult('parameterName', 'ParameterName', properties.ParameterName != null ? cfn_parse.FromCloudFormation.getString(properties.ParameterName) : undefined);
    ret.addPropertyResult('parameterValue', 'ParameterValue', properties.ParameterValue != null ? cfn_parse.FromCloudFormation.getString(properties.ParameterValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDiskProps`
 *
 * @param properties - the TypeScript properties of a `CfnDiskProps`
 *
 * @returns the result of the validation.
 */
function CfnDiskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addOns', cdk.listValidator(CfnDisk_AddOnPropertyValidator))(properties.addOns));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('diskName', cdk.requiredValidator)(properties.diskName));
    errors.collect(cdk.propertyValidator('diskName', cdk.validateString)(properties.diskName));
    errors.collect(cdk.propertyValidator('sizeInGb', cdk.requiredValidator)(properties.sizeInGb));
    errors.collect(cdk.propertyValidator('sizeInGb', cdk.validateNumber)(properties.sizeInGb));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDiskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Disk` resource
 *
 * @param properties - the TypeScript properties of a `CfnDiskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Disk` resource.
 */
// @ts-ignore TS6133
function cfnDiskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDiskPropsValidator(properties).assertSuccess();
    return {
        DiskName: cdk.stringToCloudFormation(properties.diskName),
        SizeInGb: cdk.numberToCloudFormation(properties.sizeInGb),
        AddOns: cdk.listMapper(cfnDiskAddOnPropertyToCloudFormation)(properties.addOns),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDiskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('diskName', 'DiskName', cfn_parse.FromCloudFormation.getString(properties.DiskName));
    ret.addPropertyResult('sizeInGb', 'SizeInGb', cfn_parse.FromCloudFormation.getNumber(properties.SizeInGb));
    ret.addPropertyResult('addOns', 'AddOns', properties.AddOns != null ? cfn_parse.FromCloudFormation.getArray(CfnDiskAddOnPropertyFromCloudFormation)(properties.AddOns) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Disk`
 *
 * The `AWS::Lightsail::Disk` resource specifies a disk that can be attached to an Amazon Lightsail instance that is in the same AWS Region and Availability Zone.
 *
 * @cloudformationResource AWS::Lightsail::Disk
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-disk.html
 */
class CfnDisk extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Disk`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDisk.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnDiskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDisk);
            }
            throw error;
        }
        cdk.requireProperty(props, 'diskName', this);
        cdk.requireProperty(props, 'sizeInGb', this);
        this.attrAttachedTo = cdk.Token.asString(this.getAtt('AttachedTo'));
        this.attrAttachmentState = cdk.Token.asString(this.getAtt('AttachmentState'));
        this.attrDiskArn = cdk.Token.asString(this.getAtt('DiskArn'));
        this.attrIops = cdk.Token.asNumber(this.getAtt('Iops'));
        this.attrIsAttached = this.getAtt('IsAttached');
        this.attrPath = cdk.Token.asString(this.getAtt('Path'));
        this.attrResourceType = cdk.Token.asString(this.getAtt('ResourceType'));
        this.attrState = cdk.Token.asString(this.getAtt('State'));
        this.attrSupportCode = cdk.Token.asString(this.getAtt('SupportCode'));
        this.diskName = props.diskName;
        this.sizeInGb = props.sizeInGb;
        this.addOns = props.addOns;
        this.availabilityZone = props.availabilityZone;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Disk", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDiskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDisk(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDisk.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            diskName: this.diskName,
            sizeInGb: this.sizeInGb,
            addOns: this.addOns,
            availabilityZone: this.availabilityZone,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDiskPropsToCloudFormation(props);
    }
}
exports.CfnDisk = CfnDisk;
_f = JSII_RTTI_SYMBOL_1;
CfnDisk[_f] = { fqn: "@aws-cdk/aws-lightsail.CfnDisk", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDisk.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Disk";
/**
 * Determine whether the given properties match those of a `AddOnProperty`
 *
 * @param properties - the TypeScript properties of a `AddOnProperty`
 *
 * @returns the result of the validation.
 */
function CfnDisk_AddOnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addOnType', cdk.requiredValidator)(properties.addOnType));
    errors.collect(cdk.propertyValidator('addOnType', cdk.validateString)(properties.addOnType));
    errors.collect(cdk.propertyValidator('autoSnapshotAddOnRequest', CfnDisk_AutoSnapshotAddOnPropertyValidator)(properties.autoSnapshotAddOnRequest));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "AddOnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Disk.AddOn` resource
 *
 * @param properties - the TypeScript properties of a `AddOnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Disk.AddOn` resource.
 */
// @ts-ignore TS6133
function cfnDiskAddOnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDisk_AddOnPropertyValidator(properties).assertSuccess();
    return {
        AddOnType: cdk.stringToCloudFormation(properties.addOnType),
        AutoSnapshotAddOnRequest: cfnDiskAutoSnapshotAddOnPropertyToCloudFormation(properties.autoSnapshotAddOnRequest),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnDiskAddOnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('addOnType', 'AddOnType', cfn_parse.FromCloudFormation.getString(properties.AddOnType));
    ret.addPropertyResult('autoSnapshotAddOnRequest', 'AutoSnapshotAddOnRequest', properties.AutoSnapshotAddOnRequest != null ? CfnDiskAutoSnapshotAddOnPropertyFromCloudFormation(properties.AutoSnapshotAddOnRequest) : undefined);
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AutoSnapshotAddOnProperty`
 *
 * @param properties - the TypeScript properties of a `AutoSnapshotAddOnProperty`
 *
 * @returns the result of the validation.
 */
function CfnDisk_AutoSnapshotAddOnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snapshotTimeOfDay', cdk.validateString)(properties.snapshotTimeOfDay));
    return errors.wrap('supplied properties not correct for "AutoSnapshotAddOnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Disk.AutoSnapshotAddOn` resource
 *
 * @param properties - the TypeScript properties of a `AutoSnapshotAddOnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Disk.AutoSnapshotAddOn` resource.
 */
// @ts-ignore TS6133
function cfnDiskAutoSnapshotAddOnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDisk_AutoSnapshotAddOnPropertyValidator(properties).assertSuccess();
    return {
        SnapshotTimeOfDay: cdk.stringToCloudFormation(properties.snapshotTimeOfDay),
    };
}
// @ts-ignore TS6133
function CfnDiskAutoSnapshotAddOnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snapshotTimeOfDay', 'SnapshotTimeOfDay', properties.SnapshotTimeOfDay != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotTimeOfDay) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDistributionProps`
 *
 * @param properties - the TypeScript properties of a `CfnDistributionProps`
 *
 * @returns the result of the validation.
 */
function CfnDistributionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bundleId', cdk.requiredValidator)(properties.bundleId));
    errors.collect(cdk.propertyValidator('bundleId', cdk.validateString)(properties.bundleId));
    errors.collect(cdk.propertyValidator('cacheBehaviorSettings', CfnDistribution_CacheSettingsPropertyValidator)(properties.cacheBehaviorSettings));
    errors.collect(cdk.propertyValidator('cacheBehaviors', cdk.listValidator(CfnDistribution_CacheBehaviorPerPathPropertyValidator))(properties.cacheBehaviors));
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('defaultCacheBehavior', cdk.requiredValidator)(properties.defaultCacheBehavior));
    errors.collect(cdk.propertyValidator('defaultCacheBehavior', CfnDistribution_CacheBehaviorPropertyValidator)(properties.defaultCacheBehavior));
    errors.collect(cdk.propertyValidator('distributionName', cdk.requiredValidator)(properties.distributionName));
    errors.collect(cdk.propertyValidator('distributionName', cdk.validateString)(properties.distributionName));
    errors.collect(cdk.propertyValidator('ipAddressType', cdk.validateString)(properties.ipAddressType));
    errors.collect(cdk.propertyValidator('isEnabled', cdk.validateBoolean)(properties.isEnabled));
    errors.collect(cdk.propertyValidator('origin', cdk.requiredValidator)(properties.origin));
    errors.collect(cdk.propertyValidator('origin', CfnDistribution_InputOriginPropertyValidator)(properties.origin));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDistributionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution` resource
 *
 * @param properties - the TypeScript properties of a `CfnDistributionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution` resource.
 */
// @ts-ignore TS6133
function cfnDistributionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistributionPropsValidator(properties).assertSuccess();
    return {
        BundleId: cdk.stringToCloudFormation(properties.bundleId),
        DefaultCacheBehavior: cfnDistributionCacheBehaviorPropertyToCloudFormation(properties.defaultCacheBehavior),
        DistributionName: cdk.stringToCloudFormation(properties.distributionName),
        Origin: cfnDistributionInputOriginPropertyToCloudFormation(properties.origin),
        CacheBehaviors: cdk.listMapper(cfnDistributionCacheBehaviorPerPathPropertyToCloudFormation)(properties.cacheBehaviors),
        CacheBehaviorSettings: cfnDistributionCacheSettingsPropertyToCloudFormation(properties.cacheBehaviorSettings),
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        IpAddressType: cdk.stringToCloudFormation(properties.ipAddressType),
        IsEnabled: cdk.booleanToCloudFormation(properties.isEnabled),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDistributionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bundleId', 'BundleId', cfn_parse.FromCloudFormation.getString(properties.BundleId));
    ret.addPropertyResult('defaultCacheBehavior', 'DefaultCacheBehavior', CfnDistributionCacheBehaviorPropertyFromCloudFormation(properties.DefaultCacheBehavior));
    ret.addPropertyResult('distributionName', 'DistributionName', cfn_parse.FromCloudFormation.getString(properties.DistributionName));
    ret.addPropertyResult('origin', 'Origin', CfnDistributionInputOriginPropertyFromCloudFormation(properties.Origin));
    ret.addPropertyResult('cacheBehaviors', 'CacheBehaviors', properties.CacheBehaviors != null ? cfn_parse.FromCloudFormation.getArray(CfnDistributionCacheBehaviorPerPathPropertyFromCloudFormation)(properties.CacheBehaviors) : undefined);
    ret.addPropertyResult('cacheBehaviorSettings', 'CacheBehaviorSettings', properties.CacheBehaviorSettings != null ? CfnDistributionCacheSettingsPropertyFromCloudFormation(properties.CacheBehaviorSettings) : undefined);
    ret.addPropertyResult('certificateName', 'CertificateName', properties.CertificateName != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateName) : undefined);
    ret.addPropertyResult('ipAddressType', 'IpAddressType', properties.IpAddressType != null ? cfn_parse.FromCloudFormation.getString(properties.IpAddressType) : undefined);
    ret.addPropertyResult('isEnabled', 'IsEnabled', properties.IsEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsEnabled) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Distribution`
 *
 * The `AWS::Lightsail::Distribution` resource specifies a content delivery network (CDN) distribution. You can create distributions only in the `us-east-1` AWS Region.
 *
 * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance, static content hosted on a Lightsail bucket, or through a Lightsail load balancer.
 *
 * @cloudformationResource AWS::Lightsail::Distribution
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html
 */
class CfnDistribution extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Distribution`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDistribution.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnDistributionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDistribution);
            }
            throw error;
        }
        cdk.requireProperty(props, 'bundleId', this);
        cdk.requireProperty(props, 'defaultCacheBehavior', this);
        cdk.requireProperty(props, 'distributionName', this);
        cdk.requireProperty(props, 'origin', this);
        this.attrAbleToUpdateBundle = this.getAtt('AbleToUpdateBundle');
        this.attrDistributionArn = cdk.Token.asString(this.getAtt('DistributionArn'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.bundleId = props.bundleId;
        this.defaultCacheBehavior = props.defaultCacheBehavior;
        this.distributionName = props.distributionName;
        this.origin = props.origin;
        this.cacheBehaviors = props.cacheBehaviors;
        this.cacheBehaviorSettings = props.cacheBehaviorSettings;
        this.certificateName = props.certificateName;
        this.ipAddressType = props.ipAddressType;
        this.isEnabled = props.isEnabled;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Distribution", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDistributionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDistribution(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDistribution.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            bundleId: this.bundleId,
            defaultCacheBehavior: this.defaultCacheBehavior,
            distributionName: this.distributionName,
            origin: this.origin,
            cacheBehaviors: this.cacheBehaviors,
            cacheBehaviorSettings: this.cacheBehaviorSettings,
            certificateName: this.certificateName,
            ipAddressType: this.ipAddressType,
            isEnabled: this.isEnabled,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDistributionPropsToCloudFormation(props);
    }
}
exports.CfnDistribution = CfnDistribution;
_g = JSII_RTTI_SYMBOL_1;
CfnDistribution[_g] = { fqn: "@aws-cdk/aws-lightsail.CfnDistribution", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDistribution.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Distribution";
/**
 * Determine whether the given properties match those of a `CacheBehaviorProperty`
 *
 * @param properties - the TypeScript properties of a `CacheBehaviorProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_CacheBehaviorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('behavior', cdk.validateString)(properties.behavior));
    return errors.wrap('supplied properties not correct for "CacheBehaviorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheBehavior` resource
 *
 * @param properties - the TypeScript properties of a `CacheBehaviorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheBehavior` resource.
 */
// @ts-ignore TS6133
function cfnDistributionCacheBehaviorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_CacheBehaviorPropertyValidator(properties).assertSuccess();
    return {
        Behavior: cdk.stringToCloudFormation(properties.behavior),
    };
}
// @ts-ignore TS6133
function CfnDistributionCacheBehaviorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('behavior', 'Behavior', properties.Behavior != null ? cfn_parse.FromCloudFormation.getString(properties.Behavior) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CacheBehaviorPerPathProperty`
 *
 * @param properties - the TypeScript properties of a `CacheBehaviorPerPathProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_CacheBehaviorPerPathPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('behavior', cdk.validateString)(properties.behavior));
    errors.collect(cdk.propertyValidator('path', cdk.validateString)(properties.path));
    return errors.wrap('supplied properties not correct for "CacheBehaviorPerPathProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheBehaviorPerPath` resource
 *
 * @param properties - the TypeScript properties of a `CacheBehaviorPerPathProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheBehaviorPerPath` resource.
 */
// @ts-ignore TS6133
function cfnDistributionCacheBehaviorPerPathPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_CacheBehaviorPerPathPropertyValidator(properties).assertSuccess();
    return {
        Behavior: cdk.stringToCloudFormation(properties.behavior),
        Path: cdk.stringToCloudFormation(properties.path),
    };
}
// @ts-ignore TS6133
function CfnDistributionCacheBehaviorPerPathPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('behavior', 'Behavior', properties.Behavior != null ? cfn_parse.FromCloudFormation.getString(properties.Behavior) : undefined);
    ret.addPropertyResult('path', 'Path', properties.Path != null ? cfn_parse.FromCloudFormation.getString(properties.Path) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CacheSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `CacheSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_CacheSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowedHttpMethods', cdk.validateString)(properties.allowedHttpMethods));
    errors.collect(cdk.propertyValidator('cachedHttpMethods', cdk.validateString)(properties.cachedHttpMethods));
    errors.collect(cdk.propertyValidator('defaultTtl', cdk.validateNumber)(properties.defaultTtl));
    errors.collect(cdk.propertyValidator('forwardedCookies', CfnDistribution_CookieObjectPropertyValidator)(properties.forwardedCookies));
    errors.collect(cdk.propertyValidator('forwardedHeaders', CfnDistribution_HeaderObjectPropertyValidator)(properties.forwardedHeaders));
    errors.collect(cdk.propertyValidator('forwardedQueryStrings', CfnDistribution_QueryStringObjectPropertyValidator)(properties.forwardedQueryStrings));
    errors.collect(cdk.propertyValidator('maximumTtl', cdk.validateNumber)(properties.maximumTtl));
    errors.collect(cdk.propertyValidator('minimumTtl', cdk.validateNumber)(properties.minimumTtl));
    return errors.wrap('supplied properties not correct for "CacheSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheSettings` resource
 *
 * @param properties - the TypeScript properties of a `CacheSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CacheSettings` resource.
 */
// @ts-ignore TS6133
function cfnDistributionCacheSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_CacheSettingsPropertyValidator(properties).assertSuccess();
    return {
        AllowedHTTPMethods: cdk.stringToCloudFormation(properties.allowedHttpMethods),
        CachedHTTPMethods: cdk.stringToCloudFormation(properties.cachedHttpMethods),
        DefaultTTL: cdk.numberToCloudFormation(properties.defaultTtl),
        ForwardedCookies: cfnDistributionCookieObjectPropertyToCloudFormation(properties.forwardedCookies),
        ForwardedHeaders: cfnDistributionHeaderObjectPropertyToCloudFormation(properties.forwardedHeaders),
        ForwardedQueryStrings: cfnDistributionQueryStringObjectPropertyToCloudFormation(properties.forwardedQueryStrings),
        MaximumTTL: cdk.numberToCloudFormation(properties.maximumTtl),
        MinimumTTL: cdk.numberToCloudFormation(properties.minimumTtl),
    };
}
// @ts-ignore TS6133
function CfnDistributionCacheSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowedHttpMethods', 'AllowedHTTPMethods', properties.AllowedHTTPMethods != null ? cfn_parse.FromCloudFormation.getString(properties.AllowedHTTPMethods) : undefined);
    ret.addPropertyResult('cachedHttpMethods', 'CachedHTTPMethods', properties.CachedHTTPMethods != null ? cfn_parse.FromCloudFormation.getString(properties.CachedHTTPMethods) : undefined);
    ret.addPropertyResult('defaultTtl', 'DefaultTTL', properties.DefaultTTL != null ? cfn_parse.FromCloudFormation.getNumber(properties.DefaultTTL) : undefined);
    ret.addPropertyResult('forwardedCookies', 'ForwardedCookies', properties.ForwardedCookies != null ? CfnDistributionCookieObjectPropertyFromCloudFormation(properties.ForwardedCookies) : undefined);
    ret.addPropertyResult('forwardedHeaders', 'ForwardedHeaders', properties.ForwardedHeaders != null ? CfnDistributionHeaderObjectPropertyFromCloudFormation(properties.ForwardedHeaders) : undefined);
    ret.addPropertyResult('forwardedQueryStrings', 'ForwardedQueryStrings', properties.ForwardedQueryStrings != null ? CfnDistributionQueryStringObjectPropertyFromCloudFormation(properties.ForwardedQueryStrings) : undefined);
    ret.addPropertyResult('maximumTtl', 'MaximumTTL', properties.MaximumTTL != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumTTL) : undefined);
    ret.addPropertyResult('minimumTtl', 'MinimumTTL', properties.MinimumTTL != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinimumTTL) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CookieObjectProperty`
 *
 * @param properties - the TypeScript properties of a `CookieObjectProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_CookieObjectPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cookiesAllowList', cdk.listValidator(cdk.validateString))(properties.cookiesAllowList));
    errors.collect(cdk.propertyValidator('option', cdk.validateString)(properties.option));
    return errors.wrap('supplied properties not correct for "CookieObjectProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CookieObject` resource
 *
 * @param properties - the TypeScript properties of a `CookieObjectProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.CookieObject` resource.
 */
// @ts-ignore TS6133
function cfnDistributionCookieObjectPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_CookieObjectPropertyValidator(properties).assertSuccess();
    return {
        CookiesAllowList: cdk.listMapper(cdk.stringToCloudFormation)(properties.cookiesAllowList),
        Option: cdk.stringToCloudFormation(properties.option),
    };
}
// @ts-ignore TS6133
function CfnDistributionCookieObjectPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cookiesAllowList', 'CookiesAllowList', properties.CookiesAllowList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CookiesAllowList) : undefined);
    ret.addPropertyResult('option', 'Option', properties.Option != null ? cfn_parse.FromCloudFormation.getString(properties.Option) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HeaderObjectProperty`
 *
 * @param properties - the TypeScript properties of a `HeaderObjectProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_HeaderObjectPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('headersAllowList', cdk.listValidator(cdk.validateString))(properties.headersAllowList));
    errors.collect(cdk.propertyValidator('option', cdk.validateString)(properties.option));
    return errors.wrap('supplied properties not correct for "HeaderObjectProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.HeaderObject` resource
 *
 * @param properties - the TypeScript properties of a `HeaderObjectProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.HeaderObject` resource.
 */
// @ts-ignore TS6133
function cfnDistributionHeaderObjectPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_HeaderObjectPropertyValidator(properties).assertSuccess();
    return {
        HeadersAllowList: cdk.listMapper(cdk.stringToCloudFormation)(properties.headersAllowList),
        Option: cdk.stringToCloudFormation(properties.option),
    };
}
// @ts-ignore TS6133
function CfnDistributionHeaderObjectPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('headersAllowList', 'HeadersAllowList', properties.HeadersAllowList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.HeadersAllowList) : undefined);
    ret.addPropertyResult('option', 'Option', properties.Option != null ? cfn_parse.FromCloudFormation.getString(properties.Option) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InputOriginProperty`
 *
 * @param properties - the TypeScript properties of a `InputOriginProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_InputOriginPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('protocolPolicy', cdk.validateString)(properties.protocolPolicy));
    errors.collect(cdk.propertyValidator('regionName', cdk.validateString)(properties.regionName));
    return errors.wrap('supplied properties not correct for "InputOriginProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.InputOrigin` resource
 *
 * @param properties - the TypeScript properties of a `InputOriginProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.InputOrigin` resource.
 */
// @ts-ignore TS6133
function cfnDistributionInputOriginPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_InputOriginPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ProtocolPolicy: cdk.stringToCloudFormation(properties.protocolPolicy),
        RegionName: cdk.stringToCloudFormation(properties.regionName),
    };
}
// @ts-ignore TS6133
function CfnDistributionInputOriginPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('protocolPolicy', 'ProtocolPolicy', properties.ProtocolPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.ProtocolPolicy) : undefined);
    ret.addPropertyResult('regionName', 'RegionName', properties.RegionName != null ? cfn_parse.FromCloudFormation.getString(properties.RegionName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `QueryStringObjectProperty`
 *
 * @param properties - the TypeScript properties of a `QueryStringObjectProperty`
 *
 * @returns the result of the validation.
 */
function CfnDistribution_QueryStringObjectPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('option', cdk.validateBoolean)(properties.option));
    errors.collect(cdk.propertyValidator('queryStringsAllowList', cdk.listValidator(cdk.validateString))(properties.queryStringsAllowList));
    return errors.wrap('supplied properties not correct for "QueryStringObjectProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.QueryStringObject` resource
 *
 * @param properties - the TypeScript properties of a `QueryStringObjectProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Distribution.QueryStringObject` resource.
 */
// @ts-ignore TS6133
function cfnDistributionQueryStringObjectPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDistribution_QueryStringObjectPropertyValidator(properties).assertSuccess();
    return {
        Option: cdk.booleanToCloudFormation(properties.option),
        QueryStringsAllowList: cdk.listMapper(cdk.stringToCloudFormation)(properties.queryStringsAllowList),
    };
}
// @ts-ignore TS6133
function CfnDistributionQueryStringObjectPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('option', 'Option', properties.Option != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Option) : undefined);
    ret.addPropertyResult('queryStringsAllowList', 'QueryStringsAllowList', properties.QueryStringsAllowList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.QueryStringsAllowList) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addOns', cdk.listValidator(CfnInstance_AddOnPropertyValidator))(properties.addOns));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('blueprintId', cdk.requiredValidator)(properties.blueprintId));
    errors.collect(cdk.propertyValidator('blueprintId', cdk.validateString)(properties.blueprintId));
    errors.collect(cdk.propertyValidator('bundleId', cdk.requiredValidator)(properties.bundleId));
    errors.collect(cdk.propertyValidator('bundleId', cdk.validateString)(properties.bundleId));
    errors.collect(cdk.propertyValidator('hardware', CfnInstance_HardwarePropertyValidator)(properties.hardware));
    errors.collect(cdk.propertyValidator('instanceName', cdk.requiredValidator)(properties.instanceName));
    errors.collect(cdk.propertyValidator('instanceName', cdk.validateString)(properties.instanceName));
    errors.collect(cdk.propertyValidator('keyPairName', cdk.validateString)(properties.keyPairName));
    errors.collect(cdk.propertyValidator('networking', CfnInstance_NetworkingPropertyValidator)(properties.networking));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('userData', cdk.validateString)(properties.userData));
    return errors.wrap('supplied properties not correct for "CfnInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance` resource
 *
 * @param properties - the TypeScript properties of a `CfnInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance` resource.
 */
// @ts-ignore TS6133
function cfnInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstancePropsValidator(properties).assertSuccess();
    return {
        BlueprintId: cdk.stringToCloudFormation(properties.blueprintId),
        BundleId: cdk.stringToCloudFormation(properties.bundleId),
        InstanceName: cdk.stringToCloudFormation(properties.instanceName),
        AddOns: cdk.listMapper(cfnInstanceAddOnPropertyToCloudFormation)(properties.addOns),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        Hardware: cfnInstanceHardwarePropertyToCloudFormation(properties.hardware),
        KeyPairName: cdk.stringToCloudFormation(properties.keyPairName),
        Networking: cfnInstanceNetworkingPropertyToCloudFormation(properties.networking),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        UserData: cdk.stringToCloudFormation(properties.userData),
    };
}
// @ts-ignore TS6133
function CfnInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('blueprintId', 'BlueprintId', cfn_parse.FromCloudFormation.getString(properties.BlueprintId));
    ret.addPropertyResult('bundleId', 'BundleId', cfn_parse.FromCloudFormation.getString(properties.BundleId));
    ret.addPropertyResult('instanceName', 'InstanceName', cfn_parse.FromCloudFormation.getString(properties.InstanceName));
    ret.addPropertyResult('addOns', 'AddOns', properties.AddOns != null ? cfn_parse.FromCloudFormation.getArray(CfnInstanceAddOnPropertyFromCloudFormation)(properties.AddOns) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('hardware', 'Hardware', properties.Hardware != null ? CfnInstanceHardwarePropertyFromCloudFormation(properties.Hardware) : undefined);
    ret.addPropertyResult('keyPairName', 'KeyPairName', properties.KeyPairName != null ? cfn_parse.FromCloudFormation.getString(properties.KeyPairName) : undefined);
    ret.addPropertyResult('networking', 'Networking', properties.Networking != null ? CfnInstanceNetworkingPropertyFromCloudFormation(properties.Networking) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('userData', 'UserData', properties.UserData != null ? cfn_parse.FromCloudFormation.getString(properties.UserData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::Instance`
 *
 * The `AWS::Lightsail::Instance` resource specifies an Amazon Lightsail instance.
 *
 * @cloudformationResource AWS::Lightsail::Instance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html
 */
class CfnInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnInstance);
            }
            throw error;
        }
        cdk.requireProperty(props, 'blueprintId', this);
        cdk.requireProperty(props, 'bundleId', this);
        cdk.requireProperty(props, 'instanceName', this);
        this.attrHardwareCpuCount = cdk.Token.asNumber(this.getAtt('Hardware.CpuCount'));
        this.attrHardwareRamSizeInGb = cdk.Token.asNumber(this.getAtt('Hardware.RamSizeInGb'));
        this.attrInstanceArn = cdk.Token.asString(this.getAtt('InstanceArn'));
        this.attrIsStaticIp = this.getAtt('IsStaticIp');
        this.attrLocationAvailabilityZone = cdk.Token.asString(this.getAtt('Location.AvailabilityZone'));
        this.attrLocationRegionName = cdk.Token.asString(this.getAtt('Location.RegionName'));
        this.attrNetworkingMonthlyTransferGbPerMonthAllocated = cdk.Token.asString(this.getAtt('Networking.MonthlyTransfer.GbPerMonthAllocated'));
        this.attrPrivateIpAddress = cdk.Token.asString(this.getAtt('PrivateIpAddress'));
        this.attrPublicIpAddress = cdk.Token.asString(this.getAtt('PublicIpAddress'));
        this.attrResourceType = cdk.Token.asString(this.getAtt('ResourceType'));
        this.attrSshKeyName = cdk.Token.asString(this.getAtt('SshKeyName'));
        this.attrStateCode = cdk.Token.asNumber(this.getAtt('State.Code'));
        this.attrStateName = cdk.Token.asString(this.getAtt('State.Name'));
        this.attrSupportCode = cdk.Token.asString(this.getAtt('SupportCode'));
        this.attrUserName = cdk.Token.asString(this.getAtt('UserName'));
        this.blueprintId = props.blueprintId;
        this.bundleId = props.bundleId;
        this.instanceName = props.instanceName;
        this.addOns = props.addOns;
        this.availabilityZone = props.availabilityZone;
        this.hardware = props.hardware;
        this.keyPairName = props.keyPairName;
        this.networking = props.networking;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::Instance", props.tags, { tagPropertyName: 'tags' });
        this.userData = props.userData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            blueprintId: this.blueprintId,
            bundleId: this.bundleId,
            instanceName: this.instanceName,
            addOns: this.addOns,
            availabilityZone: this.availabilityZone,
            hardware: this.hardware,
            keyPairName: this.keyPairName,
            networking: this.networking,
            tags: this.tags.renderTags(),
            userData: this.userData,
        };
    }
    renderProperties(props) {
        return cfnInstancePropsToCloudFormation(props);
    }
}
exports.CfnInstance = CfnInstance;
_h = JSII_RTTI_SYMBOL_1;
CfnInstance[_h] = { fqn: "@aws-cdk/aws-lightsail.CfnInstance", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnInstance.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::Instance";
/**
 * Determine whether the given properties match those of a `AddOnProperty`
 *
 * @param properties - the TypeScript properties of a `AddOnProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_AddOnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addOnType', cdk.requiredValidator)(properties.addOnType));
    errors.collect(cdk.propertyValidator('addOnType', cdk.validateString)(properties.addOnType));
    errors.collect(cdk.propertyValidator('autoSnapshotAddOnRequest', CfnInstance_AutoSnapshotAddOnPropertyValidator)(properties.autoSnapshotAddOnRequest));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "AddOnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.AddOn` resource
 *
 * @param properties - the TypeScript properties of a `AddOnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.AddOn` resource.
 */
// @ts-ignore TS6133
function cfnInstanceAddOnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_AddOnPropertyValidator(properties).assertSuccess();
    return {
        AddOnType: cdk.stringToCloudFormation(properties.addOnType),
        AutoSnapshotAddOnRequest: cfnInstanceAutoSnapshotAddOnPropertyToCloudFormation(properties.autoSnapshotAddOnRequest),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnInstanceAddOnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('addOnType', 'AddOnType', cfn_parse.FromCloudFormation.getString(properties.AddOnType));
    ret.addPropertyResult('autoSnapshotAddOnRequest', 'AutoSnapshotAddOnRequest', properties.AutoSnapshotAddOnRequest != null ? CfnInstanceAutoSnapshotAddOnPropertyFromCloudFormation(properties.AutoSnapshotAddOnRequest) : undefined);
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AutoSnapshotAddOnProperty`
 *
 * @param properties - the TypeScript properties of a `AutoSnapshotAddOnProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_AutoSnapshotAddOnPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snapshotTimeOfDay', cdk.validateString)(properties.snapshotTimeOfDay));
    return errors.wrap('supplied properties not correct for "AutoSnapshotAddOnProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.AutoSnapshotAddOn` resource
 *
 * @param properties - the TypeScript properties of a `AutoSnapshotAddOnProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.AutoSnapshotAddOn` resource.
 */
// @ts-ignore TS6133
function cfnInstanceAutoSnapshotAddOnPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_AutoSnapshotAddOnPropertyValidator(properties).assertSuccess();
    return {
        SnapshotTimeOfDay: cdk.stringToCloudFormation(properties.snapshotTimeOfDay),
    };
}
// @ts-ignore TS6133
function CfnInstanceAutoSnapshotAddOnPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snapshotTimeOfDay', 'SnapshotTimeOfDay', properties.SnapshotTimeOfDay != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotTimeOfDay) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DiskProperty`
 *
 * @param properties - the TypeScript properties of a `DiskProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_DiskPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attachedTo', cdk.validateString)(properties.attachedTo));
    errors.collect(cdk.propertyValidator('attachmentState', cdk.validateString)(properties.attachmentState));
    errors.collect(cdk.propertyValidator('diskName', cdk.requiredValidator)(properties.diskName));
    errors.collect(cdk.propertyValidator('diskName', cdk.validateString)(properties.diskName));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('isSystemDisk', cdk.validateBoolean)(properties.isSystemDisk));
    errors.collect(cdk.propertyValidator('path', cdk.requiredValidator)(properties.path));
    errors.collect(cdk.propertyValidator('path', cdk.validateString)(properties.path));
    errors.collect(cdk.propertyValidator('sizeInGb', cdk.validateString)(properties.sizeInGb));
    return errors.wrap('supplied properties not correct for "DiskProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Disk` resource
 *
 * @param properties - the TypeScript properties of a `DiskProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Disk` resource.
 */
// @ts-ignore TS6133
function cfnInstanceDiskPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_DiskPropertyValidator(properties).assertSuccess();
    return {
        AttachedTo: cdk.stringToCloudFormation(properties.attachedTo),
        AttachmentState: cdk.stringToCloudFormation(properties.attachmentState),
        DiskName: cdk.stringToCloudFormation(properties.diskName),
        IOPS: cdk.numberToCloudFormation(properties.iops),
        IsSystemDisk: cdk.booleanToCloudFormation(properties.isSystemDisk),
        Path: cdk.stringToCloudFormation(properties.path),
        SizeInGb: cdk.stringToCloudFormation(properties.sizeInGb),
    };
}
// @ts-ignore TS6133
function CfnInstanceDiskPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attachedTo', 'AttachedTo', properties.AttachedTo != null ? cfn_parse.FromCloudFormation.getString(properties.AttachedTo) : undefined);
    ret.addPropertyResult('attachmentState', 'AttachmentState', properties.AttachmentState != null ? cfn_parse.FromCloudFormation.getString(properties.AttachmentState) : undefined);
    ret.addPropertyResult('diskName', 'DiskName', cfn_parse.FromCloudFormation.getString(properties.DiskName));
    ret.addPropertyResult('iops', 'IOPS', properties.IOPS != null ? cfn_parse.FromCloudFormation.getNumber(properties.IOPS) : undefined);
    ret.addPropertyResult('isSystemDisk', 'IsSystemDisk', properties.IsSystemDisk != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsSystemDisk) : undefined);
    ret.addPropertyResult('path', 'Path', cfn_parse.FromCloudFormation.getString(properties.Path));
    ret.addPropertyResult('sizeInGb', 'SizeInGb', properties.SizeInGb != null ? cfn_parse.FromCloudFormation.getString(properties.SizeInGb) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HardwareProperty`
 *
 * @param properties - the TypeScript properties of a `HardwareProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_HardwarePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cpuCount', cdk.validateNumber)(properties.cpuCount));
    errors.collect(cdk.propertyValidator('disks', cdk.listValidator(CfnInstance_DiskPropertyValidator))(properties.disks));
    errors.collect(cdk.propertyValidator('ramSizeInGb', cdk.validateNumber)(properties.ramSizeInGb));
    return errors.wrap('supplied properties not correct for "HardwareProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Hardware` resource
 *
 * @param properties - the TypeScript properties of a `HardwareProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Hardware` resource.
 */
// @ts-ignore TS6133
function cfnInstanceHardwarePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_HardwarePropertyValidator(properties).assertSuccess();
    return {
        CpuCount: cdk.numberToCloudFormation(properties.cpuCount),
        Disks: cdk.listMapper(cfnInstanceDiskPropertyToCloudFormation)(properties.disks),
        RamSizeInGb: cdk.numberToCloudFormation(properties.ramSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnInstanceHardwarePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cpuCount', 'CpuCount', properties.CpuCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.CpuCount) : undefined);
    ret.addPropertyResult('disks', 'Disks', properties.Disks != null ? cfn_parse.FromCloudFormation.getArray(CfnInstanceDiskPropertyFromCloudFormation)(properties.Disks) : undefined);
    ret.addPropertyResult('ramSizeInGb', 'RamSizeInGb', properties.RamSizeInGb != null ? cfn_parse.FromCloudFormation.getNumber(properties.RamSizeInGb) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocationProperty`
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('regionName', cdk.validateString)(properties.regionName));
    return errors.wrap('supplied properties not correct for "LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Location` resource
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Location` resource.
 */
// @ts-ignore TS6133
function cfnInstanceLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_LocationPropertyValidator(properties).assertSuccess();
    return {
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        RegionName: cdk.stringToCloudFormation(properties.regionName),
    };
}
// @ts-ignore TS6133
function CfnInstanceLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('regionName', 'RegionName', properties.RegionName != null ? cfn_parse.FromCloudFormation.getString(properties.RegionName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonthlyTransferProperty`
 *
 * @param properties - the TypeScript properties of a `MonthlyTransferProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_MonthlyTransferPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('gbPerMonthAllocated', cdk.validateString)(properties.gbPerMonthAllocated));
    return errors.wrap('supplied properties not correct for "MonthlyTransferProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.MonthlyTransfer` resource
 *
 * @param properties - the TypeScript properties of a `MonthlyTransferProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.MonthlyTransfer` resource.
 */
// @ts-ignore TS6133
function cfnInstanceMonthlyTransferPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_MonthlyTransferPropertyValidator(properties).assertSuccess();
    return {
        GbPerMonthAllocated: cdk.stringToCloudFormation(properties.gbPerMonthAllocated),
    };
}
// @ts-ignore TS6133
function CfnInstanceMonthlyTransferPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gbPerMonthAllocated', 'GbPerMonthAllocated', properties.GbPerMonthAllocated != null ? cfn_parse.FromCloudFormation.getString(properties.GbPerMonthAllocated) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkingProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkingProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_NetworkingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('monthlyTransfer', cdk.validateNumber)(properties.monthlyTransfer));
    errors.collect(cdk.propertyValidator('ports', cdk.requiredValidator)(properties.ports));
    errors.collect(cdk.propertyValidator('ports', cdk.listValidator(CfnInstance_PortPropertyValidator))(properties.ports));
    return errors.wrap('supplied properties not correct for "NetworkingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Networking` resource
 *
 * @param properties - the TypeScript properties of a `NetworkingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Networking` resource.
 */
// @ts-ignore TS6133
function cfnInstanceNetworkingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_NetworkingPropertyValidator(properties).assertSuccess();
    return {
        MonthlyTransfer: cdk.numberToCloudFormation(properties.monthlyTransfer),
        Ports: cdk.listMapper(cfnInstancePortPropertyToCloudFormation)(properties.ports),
    };
}
// @ts-ignore TS6133
function CfnInstanceNetworkingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('monthlyTransfer', 'MonthlyTransfer', properties.MonthlyTransfer != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonthlyTransfer) : undefined);
    ret.addPropertyResult('ports', 'Ports', cfn_parse.FromCloudFormation.getArray(CfnInstancePortPropertyFromCloudFormation)(properties.Ports));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PortProperty`
 *
 * @param properties - the TypeScript properties of a `PortProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_PortPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessDirection', cdk.validateString)(properties.accessDirection));
    errors.collect(cdk.propertyValidator('accessFrom', cdk.validateString)(properties.accessFrom));
    errors.collect(cdk.propertyValidator('accessType', cdk.validateString)(properties.accessType));
    errors.collect(cdk.propertyValidator('cidrListAliases', cdk.listValidator(cdk.validateString))(properties.cidrListAliases));
    errors.collect(cdk.propertyValidator('cidrs', cdk.listValidator(cdk.validateString))(properties.cidrs));
    errors.collect(cdk.propertyValidator('commonName', cdk.validateString)(properties.commonName));
    errors.collect(cdk.propertyValidator('fromPort', cdk.validateNumber)(properties.fromPort));
    errors.collect(cdk.propertyValidator('ipv6Cidrs', cdk.listValidator(cdk.validateString))(properties.ipv6Cidrs));
    errors.collect(cdk.propertyValidator('protocol', cdk.validateString)(properties.protocol));
    errors.collect(cdk.propertyValidator('toPort', cdk.validateNumber)(properties.toPort));
    return errors.wrap('supplied properties not correct for "PortProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Port` resource
 *
 * @param properties - the TypeScript properties of a `PortProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.Port` resource.
 */
// @ts-ignore TS6133
function cfnInstancePortPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_PortPropertyValidator(properties).assertSuccess();
    return {
        AccessDirection: cdk.stringToCloudFormation(properties.accessDirection),
        AccessFrom: cdk.stringToCloudFormation(properties.accessFrom),
        AccessType: cdk.stringToCloudFormation(properties.accessType),
        CidrListAliases: cdk.listMapper(cdk.stringToCloudFormation)(properties.cidrListAliases),
        Cidrs: cdk.listMapper(cdk.stringToCloudFormation)(properties.cidrs),
        CommonName: cdk.stringToCloudFormation(properties.commonName),
        FromPort: cdk.numberToCloudFormation(properties.fromPort),
        Ipv6Cidrs: cdk.listMapper(cdk.stringToCloudFormation)(properties.ipv6Cidrs),
        Protocol: cdk.stringToCloudFormation(properties.protocol),
        ToPort: cdk.numberToCloudFormation(properties.toPort),
    };
}
// @ts-ignore TS6133
function CfnInstancePortPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessDirection', 'AccessDirection', properties.AccessDirection != null ? cfn_parse.FromCloudFormation.getString(properties.AccessDirection) : undefined);
    ret.addPropertyResult('accessFrom', 'AccessFrom', properties.AccessFrom != null ? cfn_parse.FromCloudFormation.getString(properties.AccessFrom) : undefined);
    ret.addPropertyResult('accessType', 'AccessType', properties.AccessType != null ? cfn_parse.FromCloudFormation.getString(properties.AccessType) : undefined);
    ret.addPropertyResult('cidrListAliases', 'CidrListAliases', properties.CidrListAliases != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CidrListAliases) : undefined);
    ret.addPropertyResult('cidrs', 'Cidrs', properties.Cidrs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Cidrs) : undefined);
    ret.addPropertyResult('commonName', 'CommonName', properties.CommonName != null ? cfn_parse.FromCloudFormation.getString(properties.CommonName) : undefined);
    ret.addPropertyResult('fromPort', 'FromPort', properties.FromPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.FromPort) : undefined);
    ret.addPropertyResult('ipv6Cidrs', 'Ipv6Cidrs', properties.Ipv6Cidrs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Ipv6Cidrs) : undefined);
    ret.addPropertyResult('protocol', 'Protocol', properties.Protocol != null ? cfn_parse.FromCloudFormation.getString(properties.Protocol) : undefined);
    ret.addPropertyResult('toPort', 'ToPort', properties.ToPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ToPort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StateProperty`
 *
 * @param properties - the TypeScript properties of a `StateProperty`
 *
 * @returns the result of the validation.
 */
function CfnInstance_StatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('code', cdk.validateNumber)(properties.code));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "StateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::Instance.State` resource
 *
 * @param properties - the TypeScript properties of a `StateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::Instance.State` resource.
 */
// @ts-ignore TS6133
function cfnInstanceStatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInstance_StatePropertyValidator(properties).assertSuccess();
    return {
        Code: cdk.numberToCloudFormation(properties.code),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnInstanceStatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('code', 'Code', properties.Code != null ? cfn_parse.FromCloudFormation.getNumber(properties.Code) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLoadBalancerProps`
 *
 * @param properties - the TypeScript properties of a `CfnLoadBalancerProps`
 *
 * @returns the result of the validation.
 */
function CfnLoadBalancerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attachedInstances', cdk.listValidator(cdk.validateString))(properties.attachedInstances));
    errors.collect(cdk.propertyValidator('healthCheckPath', cdk.validateString)(properties.healthCheckPath));
    errors.collect(cdk.propertyValidator('instancePort', cdk.requiredValidator)(properties.instancePort));
    errors.collect(cdk.propertyValidator('instancePort', cdk.validateNumber)(properties.instancePort));
    errors.collect(cdk.propertyValidator('ipAddressType', cdk.validateString)(properties.ipAddressType));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.requiredValidator)(properties.loadBalancerName));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.validateString)(properties.loadBalancerName));
    errors.collect(cdk.propertyValidator('sessionStickinessEnabled', cdk.validateBoolean)(properties.sessionStickinessEnabled));
    errors.collect(cdk.propertyValidator('sessionStickinessLbCookieDurationSeconds', cdk.validateString)(properties.sessionStickinessLbCookieDurationSeconds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('tlsPolicyName', cdk.validateString)(properties.tlsPolicyName));
    return errors.wrap('supplied properties not correct for "CfnLoadBalancerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::LoadBalancer` resource
 *
 * @param properties - the TypeScript properties of a `CfnLoadBalancerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::LoadBalancer` resource.
 */
// @ts-ignore TS6133
function cfnLoadBalancerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLoadBalancerPropsValidator(properties).assertSuccess();
    return {
        InstancePort: cdk.numberToCloudFormation(properties.instancePort),
        LoadBalancerName: cdk.stringToCloudFormation(properties.loadBalancerName),
        AttachedInstances: cdk.listMapper(cdk.stringToCloudFormation)(properties.attachedInstances),
        HealthCheckPath: cdk.stringToCloudFormation(properties.healthCheckPath),
        IpAddressType: cdk.stringToCloudFormation(properties.ipAddressType),
        SessionStickinessEnabled: cdk.booleanToCloudFormation(properties.sessionStickinessEnabled),
        SessionStickinessLBCookieDurationSeconds: cdk.stringToCloudFormation(properties.sessionStickinessLbCookieDurationSeconds),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TlsPolicyName: cdk.stringToCloudFormation(properties.tlsPolicyName),
    };
}
// @ts-ignore TS6133
function CfnLoadBalancerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instancePort', 'InstancePort', cfn_parse.FromCloudFormation.getNumber(properties.InstancePort));
    ret.addPropertyResult('loadBalancerName', 'LoadBalancerName', cfn_parse.FromCloudFormation.getString(properties.LoadBalancerName));
    ret.addPropertyResult('attachedInstances', 'AttachedInstances', properties.AttachedInstances != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AttachedInstances) : undefined);
    ret.addPropertyResult('healthCheckPath', 'HealthCheckPath', properties.HealthCheckPath != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckPath) : undefined);
    ret.addPropertyResult('ipAddressType', 'IpAddressType', properties.IpAddressType != null ? cfn_parse.FromCloudFormation.getString(properties.IpAddressType) : undefined);
    ret.addPropertyResult('sessionStickinessEnabled', 'SessionStickinessEnabled', properties.SessionStickinessEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.SessionStickinessEnabled) : undefined);
    ret.addPropertyResult('sessionStickinessLbCookieDurationSeconds', 'SessionStickinessLBCookieDurationSeconds', properties.SessionStickinessLBCookieDurationSeconds != null ? cfn_parse.FromCloudFormation.getString(properties.SessionStickinessLBCookieDurationSeconds) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('tlsPolicyName', 'TlsPolicyName', properties.TlsPolicyName != null ? cfn_parse.FromCloudFormation.getString(properties.TlsPolicyName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::LoadBalancer`
 *
 * The `AWS::Lightsail::LoadBalancer` resource specifies a load balancer that can be used with Lightsail instances.
 *
 * > You cannot attach a TLS certificate to a load balancer using the `AWS::Lightsail::LoadBalancer` resource type. Instead, use the `AWS::Lightsail::LoadBalancerTlsCertificate` resource type to create a certificate and attach it to a load balancer.
 *
 * @cloudformationResource AWS::Lightsail::LoadBalancer
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html
 */
class CfnLoadBalancer extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLoadBalancer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnLoadBalancerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLoadBalancer);
            }
            throw error;
        }
        cdk.requireProperty(props, 'instancePort', this);
        cdk.requireProperty(props, 'loadBalancerName', this);
        this.attrLoadBalancerArn = cdk.Token.asString(this.getAtt('LoadBalancerArn'));
        this.instancePort = props.instancePort;
        this.loadBalancerName = props.loadBalancerName;
        this.attachedInstances = props.attachedInstances;
        this.healthCheckPath = props.healthCheckPath;
        this.ipAddressType = props.ipAddressType;
        this.sessionStickinessEnabled = props.sessionStickinessEnabled;
        this.sessionStickinessLbCookieDurationSeconds = props.sessionStickinessLbCookieDurationSeconds;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Lightsail::LoadBalancer", props.tags, { tagPropertyName: 'tags' });
        this.tlsPolicyName = props.tlsPolicyName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLoadBalancerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLoadBalancer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLoadBalancer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            instancePort: this.instancePort,
            loadBalancerName: this.loadBalancerName,
            attachedInstances: this.attachedInstances,
            healthCheckPath: this.healthCheckPath,
            ipAddressType: this.ipAddressType,
            sessionStickinessEnabled: this.sessionStickinessEnabled,
            sessionStickinessLbCookieDurationSeconds: this.sessionStickinessLbCookieDurationSeconds,
            tags: this.tags.renderTags(),
            tlsPolicyName: this.tlsPolicyName,
        };
    }
    renderProperties(props) {
        return cfnLoadBalancerPropsToCloudFormation(props);
    }
}
exports.CfnLoadBalancer = CfnLoadBalancer;
_j = JSII_RTTI_SYMBOL_1;
CfnLoadBalancer[_j] = { fqn: "@aws-cdk/aws-lightsail.CfnLoadBalancer", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLoadBalancer.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::LoadBalancer";
/**
 * Determine whether the given properties match those of a `CfnLoadBalancerTlsCertificateProps`
 *
 * @param properties - the TypeScript properties of a `CfnLoadBalancerTlsCertificateProps`
 *
 * @returns the result of the validation.
 */
function CfnLoadBalancerTlsCertificatePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateAlternativeNames', cdk.listValidator(cdk.validateString))(properties.certificateAlternativeNames));
    errors.collect(cdk.propertyValidator('certificateDomainName', cdk.requiredValidator)(properties.certificateDomainName));
    errors.collect(cdk.propertyValidator('certificateDomainName', cdk.validateString)(properties.certificateDomainName));
    errors.collect(cdk.propertyValidator('certificateName', cdk.requiredValidator)(properties.certificateName));
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('httpsRedirectionEnabled', cdk.validateBoolean)(properties.httpsRedirectionEnabled));
    errors.collect(cdk.propertyValidator('isAttached', cdk.validateBoolean)(properties.isAttached));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.requiredValidator)(properties.loadBalancerName));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.validateString)(properties.loadBalancerName));
    return errors.wrap('supplied properties not correct for "CfnLoadBalancerTlsCertificateProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::LoadBalancerTlsCertificate` resource
 *
 * @param properties - the TypeScript properties of a `CfnLoadBalancerTlsCertificateProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::LoadBalancerTlsCertificate` resource.
 */
// @ts-ignore TS6133
function cfnLoadBalancerTlsCertificatePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLoadBalancerTlsCertificatePropsValidator(properties).assertSuccess();
    return {
        CertificateDomainName: cdk.stringToCloudFormation(properties.certificateDomainName),
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        LoadBalancerName: cdk.stringToCloudFormation(properties.loadBalancerName),
        CertificateAlternativeNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.certificateAlternativeNames),
        HttpsRedirectionEnabled: cdk.booleanToCloudFormation(properties.httpsRedirectionEnabled),
        IsAttached: cdk.booleanToCloudFormation(properties.isAttached),
    };
}
// @ts-ignore TS6133
function CfnLoadBalancerTlsCertificatePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateDomainName', 'CertificateDomainName', cfn_parse.FromCloudFormation.getString(properties.CertificateDomainName));
    ret.addPropertyResult('certificateName', 'CertificateName', cfn_parse.FromCloudFormation.getString(properties.CertificateName));
    ret.addPropertyResult('loadBalancerName', 'LoadBalancerName', cfn_parse.FromCloudFormation.getString(properties.LoadBalancerName));
    ret.addPropertyResult('certificateAlternativeNames', 'CertificateAlternativeNames', properties.CertificateAlternativeNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CertificateAlternativeNames) : undefined);
    ret.addPropertyResult('httpsRedirectionEnabled', 'HttpsRedirectionEnabled', properties.HttpsRedirectionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.HttpsRedirectionEnabled) : undefined);
    ret.addPropertyResult('isAttached', 'IsAttached', properties.IsAttached != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsAttached) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::LoadBalancerTlsCertificate`
 *
 * The `AWS::Lightsail::LoadBalancerTlsCertificate` resource specifies a TLS certificate that can be used with a Lightsail load balancer.
 *
 * @cloudformationResource AWS::Lightsail::LoadBalancerTlsCertificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html
 */
class CfnLoadBalancerTlsCertificate extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::LoadBalancerTlsCertificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLoadBalancerTlsCertificate.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnLoadBalancerTlsCertificateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLoadBalancerTlsCertificate);
            }
            throw error;
        }
        cdk.requireProperty(props, 'certificateDomainName', this);
        cdk.requireProperty(props, 'certificateName', this);
        cdk.requireProperty(props, 'loadBalancerName', this);
        this.attrLoadBalancerTlsCertificateArn = cdk.Token.asString(this.getAtt('LoadBalancerTlsCertificateArn'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.certificateDomainName = props.certificateDomainName;
        this.certificateName = props.certificateName;
        this.loadBalancerName = props.loadBalancerName;
        this.certificateAlternativeNames = props.certificateAlternativeNames;
        this.httpsRedirectionEnabled = props.httpsRedirectionEnabled;
        this.isAttached = props.isAttached;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLoadBalancerTlsCertificatePropsFromCloudFormation(resourceProperties);
        const ret = new CfnLoadBalancerTlsCertificate(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLoadBalancerTlsCertificate.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            certificateDomainName: this.certificateDomainName,
            certificateName: this.certificateName,
            loadBalancerName: this.loadBalancerName,
            certificateAlternativeNames: this.certificateAlternativeNames,
            httpsRedirectionEnabled: this.httpsRedirectionEnabled,
            isAttached: this.isAttached,
        };
    }
    renderProperties(props) {
        return cfnLoadBalancerTlsCertificatePropsToCloudFormation(props);
    }
}
exports.CfnLoadBalancerTlsCertificate = CfnLoadBalancerTlsCertificate;
_k = JSII_RTTI_SYMBOL_1;
CfnLoadBalancerTlsCertificate[_k] = { fqn: "@aws-cdk/aws-lightsail.CfnLoadBalancerTlsCertificate", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLoadBalancerTlsCertificate.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::LoadBalancerTlsCertificate";
/**
 * Determine whether the given properties match those of a `CfnStaticIpProps`
 *
 * @param properties - the TypeScript properties of a `CfnStaticIpProps`
 *
 * @returns the result of the validation.
 */
function CfnStaticIpPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attachedTo', cdk.validateString)(properties.attachedTo));
    errors.collect(cdk.propertyValidator('staticIpName', cdk.requiredValidator)(properties.staticIpName));
    errors.collect(cdk.propertyValidator('staticIpName', cdk.validateString)(properties.staticIpName));
    return errors.wrap('supplied properties not correct for "CfnStaticIpProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Lightsail::StaticIp` resource
 *
 * @param properties - the TypeScript properties of a `CfnStaticIpProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Lightsail::StaticIp` resource.
 */
// @ts-ignore TS6133
function cfnStaticIpPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStaticIpPropsValidator(properties).assertSuccess();
    return {
        StaticIpName: cdk.stringToCloudFormation(properties.staticIpName),
        AttachedTo: cdk.stringToCloudFormation(properties.attachedTo),
    };
}
// @ts-ignore TS6133
function CfnStaticIpPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('staticIpName', 'StaticIpName', cfn_parse.FromCloudFormation.getString(properties.StaticIpName));
    ret.addPropertyResult('attachedTo', 'AttachedTo', properties.AttachedTo != null ? cfn_parse.FromCloudFormation.getString(properties.AttachedTo) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Lightsail::StaticIp`
 *
 * The `AWS::Lightsail::StaticIp` resource specifies a static IP that can be attached to an Amazon Lightsail instance that is in the same AWS Region and Availability Zone.
 *
 * @cloudformationResource AWS::Lightsail::StaticIp
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html
 */
class CfnStaticIp extends cdk.CfnResource {
    /**
     * Create a new `AWS::Lightsail::StaticIp`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnStaticIp.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lightsail_CfnStaticIpProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnStaticIp);
            }
            throw error;
        }
        cdk.requireProperty(props, 'staticIpName', this);
        this.attrIpAddress = cdk.Token.asString(this.getAtt('IpAddress'));
        this.attrIsAttached = this.getAtt('IsAttached');
        this.attrStaticIpArn = cdk.Token.asString(this.getAtt('StaticIpArn'));
        this.staticIpName = props.staticIpName;
        this.attachedTo = props.attachedTo;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnStaticIpPropsFromCloudFormation(resourceProperties);
        const ret = new CfnStaticIp(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnStaticIp.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            staticIpName: this.staticIpName,
            attachedTo: this.attachedTo,
        };
    }
    renderProperties(props) {
        return cfnStaticIpPropsToCloudFormation(props);
    }
}
exports.CfnStaticIp = CfnStaticIp;
_l = JSII_RTTI_SYMBOL_1;
CfnStaticIp[_l] = { fqn: "@aws-cdk/aws-lightsail.CfnStaticIp", version: "1.161.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnStaticIp.CFN_RESOURCE_TYPE_NAME = "AWS::Lightsail::StaticIp";
//# sourceMappingURL=data:application/json;base64,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