# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_serverless_emailer']

package_data = \
{'': ['*'],
 'django_serverless_emailer': ['templates/django_serverless_emailer/*']}

install_requires = \
['Django>=3.2,<4.0']

setup_kwargs = {
    'name': 'django-serverless-emailer',
    'version': '0.2.0',
    'description': 'Provides a lambda handler for sending emails concerning errors in AWS',
    'long_description': 'Currently only supports failed step functions. This is half-baked so far\n\n# Usage\n\n```python\n# settings.py\n\nINSTALLED_APPS = [\n  "django_serverless_emailer",\n  # ...\n]\n\nAWS_REGION = "us-west-2"  # your region\n\nDEFAULT_FROM_EMAIL = "an-email@email.com"  # your sender\nEMAIL_HOST = "smtp.gmail.com"  # your host\nEMAIL_PORT = 465  # your port\nEMAIL_HOST_USER = "an-email@email.com"  # your user\nEMAIL_HOST_PASSWORD = os.getenv["EMAIL_PASSWORD"]\nEMAIL_USE_SSL = True  # if you\'re using SSL\n\nEMAIL_RECEPIENTS = "a@b.com,c@d.com"  # comma delimited list or a plain list\n```\n\n```yml\n# serverless.yml\n\nfunctions:\n  notify:\n    handler: path/to/handler.send_email\n    description: Send an email\n    layers:\n      - { Ref: PythonRequirementsLambdaLayer }\n```\n\n```python\n# handler.py\n\nimport django\nimport os\n\nos.environ.setdefault("DJANGO_SETTINGS_MODULE", "setup.settings")\ndjango.setup()\n\nfrom django_serverless_emailer import notify\n\n\ndef send_email(event, _):\n    notify(event, _)\n\n```\n',
    'author': 'Alex Drozd',
    'author_email': 'drozdster@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Kicksaw-Consulting/django-serverless-emailer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
