/**
 * (experimental) A column of a table.
 *
 * @experimental
 */
export interface Column {
    /**
     * (experimental) Name of the column.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Type of the column.
     *
     * @experimental
     */
    readonly type: Type;
    /**
     * (experimental) Coment describing the column.
     *
     * @default none
     * @experimental
     */
    readonly comment?: string;
}
/**
 * (experimental) Represents a type of a column in a table schema.
 *
 * @experimental
 */
export interface Type {
    /**
     * (experimental) Indicates whether this type is a primitive data type.
     *
     * @experimental
     */
    readonly isPrimitive: boolean;
    /**
     * (experimental) Glue InputString for this type.
     *
     * @experimental
     */
    readonly inputString: string;
}
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
export declare class Schema {
    /**
     * @experimental
     */
    static readonly BOOLEAN: Type;
    /**
     * @experimental
     */
    static readonly BINARY: Type;
    /**
     * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
     *
     * @experimental
     */
    static readonly BIG_INT: Type;
    /**
     * @experimental
     */
    static readonly DOUBLE: Type;
    /**
     * @experimental
     */
    static readonly FLOAT: Type;
    /**
     * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
     *
     * @experimental
     */
    static readonly INTEGER: Type;
    /**
     * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
     *
     * @experimental
     */
    static readonly SMALL_INT: Type;
    /**
     * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
     *
     * @experimental
     */
    static readonly TINY_INT: Type;
    /**
     * (experimental) Date type.
     *
     * @experimental
     */
    static readonly DATE: Type;
    /**
     * (experimental) Timestamp type (date and time).
     *
     * @experimental
     */
    static readonly TIMESTAMP: Type;
    /**
     * (experimental) Arbitrary-length string type.
     *
     * @experimental
     */
    static readonly STRING: Type;
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision: number, scale?: number): Type;
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length: number): Type;
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length: number): Type;
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType: Type): Type;
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType: Type, valueType: Type): Type;
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns: Column[]): Type;
}
