import * as apigateway from '@aws-cdk/aws-apigateway';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
import { CallApiGatewayEndpointBase } from './base';
import { CallApiGatewayEndpointBaseProps } from './base-types';
/**
 * Properties for calling an REST API Endpoint.
 *
 * @stability stable
 */
export interface CallApiGatewayRestApiEndpointProps extends CallApiGatewayEndpointBaseProps {
    /**
     * API to call.
     *
     * @stability stable
     */
    readonly api: apigateway.IRestApi;
    /**
     * Name of the stage where the API is deployed to in API Gateway.
     *
     * @stability stable
     */
    readonly stageName: string;
}
/**
 * Call REST API endpoint as a Task.
 *
 * Be aware that the header values must be arrays. When passing the Task Token
 * in the headers field `WAIT_FOR_TASK_TOKEN` integration, use
 * `JsonPath.array()` to wrap the token in an array:
 *
 * ```ts
 * import * as apigateway from '@aws-cdk/aws-apigateway';
 * declare const api: apigateway.RestApi;
 *
 * new tasks.CallApiGatewayRestApiEndpoint(this, 'Endpoint', {
 *    api,
 *    stageName: 'Stage',
 *    method: tasks.HttpMethod.PUT,
 *    integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
 *    headers: sfn.TaskInput.fromObject({
 *      TaskToken: sfn.JsonPath.array(sfn.JsonPath.taskToken),
 *    }),
 * });
 * ```
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
export declare class CallApiGatewayRestApiEndpoint extends CallApiGatewayEndpointBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig | undefined;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[] | undefined;
    /**
     * @stability stable
     */
    protected readonly apiEndpoint: string;
    /**
     * @stability stable
     */
    protected readonly arnForExecuteApi: string;
    /**
     * @stability stable
     */
    protected readonly stageName?: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CallApiGatewayRestApiEndpointProps);
    private getApiEndpoint;
}
