import datetime
from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.scaleway_qaas_v1_alpha_1_process_status import (
    ScalewayQaasV1Alpha1ProcessStatus,
)
from ..types import UNSET, Unset

T = TypeVar("T", bound="ScalewayQaasV1Alpha1Process")


@_attrs_define
class ScalewayQaasV1Alpha1Process:
    """
    Attributes:
        id (Union[Unset, str]): Unique ID of the process.
        name (Union[Unset, str]): Name of the process.
        application_id (Union[None, Unset, str]): Application ID for which the process has been created.
        platform_id (Union[None, Unset, str]): Platform ID for which the process has been created.
        attached_session_ids (Union[Unset, list[str]]): List of sessions generated by the process.
        created_at (Union[None, Unset, datetime.datetime]): Time at which the process was created. (RFC 3339 format)
            Example: 2022-03-22T12:34:56.123456Z.
        started_at (Union[None, Unset, datetime.datetime]): Time at which the process started. (RFC 3339 format)
            Example: 2022-03-22T12:34:56.123456Z.
        updated_at (Union[None, Unset, datetime.datetime]): Time at which the process was updated. (RFC 3339 format)
            Example: 2022-03-22T12:34:56.123456Z.
        finished_at (Union[None, Unset, datetime.datetime]): Time at which the process was finished. (RFC 3339 format)
            Example: 2022-03-22T12:34:56.123456Z.
        status (Union[Unset, ScalewayQaasV1Alpha1ProcessStatus]): Status of the process. Default:
            ScalewayQaasV1Alpha1ProcessStatus.UNKNOWN_STATUS.
        project_id (Union[Unset, str]): Project ID in which the process has been created. (UUID format) Example:
            6170692e-7363-616c-6577-61792e636f6d.
        tags (Union[Unset, list[str]]): Tags of the process.
        progress (Union[None, Unset, int]): Progress of the process, from 0 to 1.
        progress_message (Union[None, Unset, str]): Any progress of the process.
        input_ (Union[None, Unset, str]): Input payload of the process as JSON string.
    """

    id: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    application_id: Union[None, Unset, str] = UNSET
    platform_id: Union[None, Unset, str] = UNSET
    attached_session_ids: Union[Unset, list[str]] = UNSET
    created_at: Union[None, Unset, datetime.datetime] = UNSET
    started_at: Union[None, Unset, datetime.datetime] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    finished_at: Union[None, Unset, datetime.datetime] = UNSET
    status: Union[Unset, ScalewayQaasV1Alpha1ProcessStatus] = (
        ScalewayQaasV1Alpha1ProcessStatus.UNKNOWN_STATUS
    )
    project_id: Union[Unset, str] = UNSET
    tags: Union[Unset, list[str]] = UNSET
    progress: Union[None, Unset, int] = UNSET
    progress_message: Union[None, Unset, str] = UNSET
    input_: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = self.id

        name = self.name

        application_id: Union[None, Unset, str]
        if isinstance(self.application_id, Unset):
            application_id = UNSET
        else:
            application_id = self.application_id

        platform_id: Union[None, Unset, str]
        if isinstance(self.platform_id, Unset):
            platform_id = UNSET
        else:
            platform_id = self.platform_id

        attached_session_ids: Union[Unset, list[str]] = UNSET
        if not isinstance(self.attached_session_ids, Unset):
            attached_session_ids = self.attached_session_ids

        created_at: Union[None, Unset, str]
        if isinstance(self.created_at, Unset):
            created_at = UNSET
        elif isinstance(self.created_at, datetime.datetime):
            created_at = self.created_at.isoformat()
        else:
            created_at = self.created_at

        started_at: Union[None, Unset, str]
        if isinstance(self.started_at, Unset):
            started_at = UNSET
        elif isinstance(self.started_at, datetime.datetime):
            started_at = self.started_at.isoformat()
        else:
            started_at = self.started_at

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        finished_at: Union[None, Unset, str]
        if isinstance(self.finished_at, Unset):
            finished_at = UNSET
        elif isinstance(self.finished_at, datetime.datetime):
            finished_at = self.finished_at.isoformat()
        else:
            finished_at = self.finished_at

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        project_id = self.project_id

        tags: Union[Unset, list[str]] = UNSET
        if not isinstance(self.tags, Unset):
            tags = self.tags

        progress: Union[None, Unset, int]
        if isinstance(self.progress, Unset):
            progress = UNSET
        else:
            progress = self.progress

        progress_message: Union[None, Unset, str]
        if isinstance(self.progress_message, Unset):
            progress_message = UNSET
        else:
            progress_message = self.progress_message

        input_: Union[None, Unset, str]
        if isinstance(self.input_, Unset):
            input_ = UNSET
        else:
            input_ = self.input_

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if name is not UNSET:
            field_dict["name"] = name
        if application_id is not UNSET:
            field_dict["application_id"] = application_id
        if platform_id is not UNSET:
            field_dict["platform_id"] = platform_id
        if attached_session_ids is not UNSET:
            field_dict["attached_session_ids"] = attached_session_ids
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if started_at is not UNSET:
            field_dict["started_at"] = started_at
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at
        if finished_at is not UNSET:
            field_dict["finished_at"] = finished_at
        if status is not UNSET:
            field_dict["status"] = status
        if project_id is not UNSET:
            field_dict["project_id"] = project_id
        if tags is not UNSET:
            field_dict["tags"] = tags
        if progress is not UNSET:
            field_dict["progress"] = progress
        if progress_message is not UNSET:
            field_dict["progress_message"] = progress_message
        if input_ is not UNSET:
            field_dict["input"] = input_

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        id = d.pop("id", UNSET)

        name = d.pop("name", UNSET)

        def _parse_application_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        application_id = _parse_application_id(d.pop("application_id", UNSET))

        def _parse_platform_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        platform_id = _parse_platform_id(d.pop("platform_id", UNSET))

        attached_session_ids = cast(list[str], d.pop("attached_session_ids", UNSET))

        def _parse_created_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                created_at_type_0 = isoparse(data)

                return created_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        created_at = _parse_created_at(d.pop("created_at", UNSET))

        def _parse_started_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                started_at_type_0 = isoparse(data)

                return started_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        started_at = _parse_started_at(d.pop("started_at", UNSET))

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        def _parse_finished_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                finished_at_type_0 = isoparse(data)

                return finished_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        finished_at = _parse_finished_at(d.pop("finished_at", UNSET))

        _status = d.pop("status", UNSET)
        status: Union[Unset, ScalewayQaasV1Alpha1ProcessStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = ScalewayQaasV1Alpha1ProcessStatus(_status)

        project_id = d.pop("project_id", UNSET)

        tags = cast(list[str], d.pop("tags", UNSET))

        def _parse_progress(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        progress = _parse_progress(d.pop("progress", UNSET))

        def _parse_progress_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        progress_message = _parse_progress_message(d.pop("progress_message", UNSET))

        def _parse_input_(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        input_ = _parse_input_(d.pop("input", UNSET))

        scaleway_qaas_v1_alpha_1_process = cls(
            id=id,
            name=name,
            application_id=application_id,
            platform_id=platform_id,
            attached_session_ids=attached_session_ids,
            created_at=created_at,
            started_at=started_at,
            updated_at=updated_at,
            finished_at=finished_at,
            status=status,
            project_id=project_id,
            tags=tags,
            progress=progress,
            progress_message=progress_message,
            input_=input_,
        )

        scaleway_qaas_v1_alpha_1_process.additional_properties = d
        return scaleway_qaas_v1_alpha_1_process

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
