from collections.abc import Mapping
from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="ScalewayQaasV1Alpha1JobCircuit")


@_attrs_define
class ScalewayQaasV1Alpha1JobCircuit:
    """
    Attributes:
        perceval_circuit (Union[None, Unset, str]): Circuit generated by Perceval that should be executed.
        qiskit_circuit (Union[None, Unset, str]): Circuit generated by Qiskit that should be executed.
    """

    perceval_circuit: Union[None, Unset, str] = UNSET
    qiskit_circuit: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        perceval_circuit: Union[None, Unset, str]
        if isinstance(self.perceval_circuit, Unset):
            perceval_circuit = UNSET
        else:
            perceval_circuit = self.perceval_circuit

        qiskit_circuit: Union[None, Unset, str]
        if isinstance(self.qiskit_circuit, Unset):
            qiskit_circuit = UNSET
        else:
            qiskit_circuit = self.qiskit_circuit

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if perceval_circuit is not UNSET:
            field_dict["perceval_circuit"] = perceval_circuit
        if qiskit_circuit is not UNSET:
            field_dict["qiskit_circuit"] = qiskit_circuit

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)

        def _parse_perceval_circuit(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        perceval_circuit = _parse_perceval_circuit(d.pop("perceval_circuit", UNSET))

        def _parse_qiskit_circuit(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        qiskit_circuit = _parse_qiskit_circuit(d.pop("qiskit_circuit", UNSET))

        scaleway_qaas_v1_alpha_1_job_circuit = cls(
            perceval_circuit=perceval_circuit,
            qiskit_circuit=qiskit_circuit,
        )

        scaleway_qaas_v1_alpha_1_job_circuit.additional_properties = d
        return scaleway_qaas_v1_alpha_1_job_circuit

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
