# coding: utf-8
import genice2.molecules
from logging import getLogger
import numpy as np
desc = {
    "usage": "mol[thf.mol]",
    "brief": "Loader for MOL files (generated by MolView.org), e.g. mol[THF.mol]."
}

# All-atom THF model


class Molecule(genice2.molecules.Molecule):
    """
Loader for MOL files (generated by MolView.org)

    Option:
      file=name  Name of the mol file.
    """

    def __init__(self, **kwargs):
        logger = getLogger()
        for k, v in kwargs.items():
            if v:
                filename = k
            elif k == "file":
                filename = v
        sites = []
        labels = []
        with open(filename) as file:
            molname = file.readline().strip()
            file.readline()
            file.readline()
            line = file.readline()
            cols = line.split()
            natom = int(cols[0])
            for i in range(natom):
                line = file.readline()
                cols = line.split()
                sites.append([float(x) for x in cols[:3]])
                labels.append(cols[3])
        self.sites_ = np.array(sites) / 10.0  # in nm
        self.labels_ = labels
        self.name_ = molname
