# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (40,16,16,8,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        72 178
        19 132
        90 426
        289 10
        396 127
        135 273
        130 266
        267 130
        245 375
        433 185
        415 110
        440 186
        312 288
        250 382
        207 293
        95 407
        210 303
        149 140
        339 130
        219 306
        441 428
        442 430
        126 341
        347 280
        135 283
        257 322
        0 406
        429 217
        238 281
        289 108
        283 43
        381 267
        73 419
        124 209
        441 342
        435 234
        384 81
        180 412
        138 230
        111 212
        122 228
        401 231
        375 100
        418 254
        356 195
        156 375
        278 233
        222 196
        277 232
        0 250
        371 44
        1 420
        91 224
        239 176
        6 413
        63 205
        368 93
        12 140
        192 416
        41 293
        307 81
        438 129
        354 172
        267 118
        131 40
        261 120
        193 242
        116 228
        208 17
        211 144
        169 41
        413 125
        263 99
        62 274
        300 386
        428 323
        430 321
        435 322
        237 323
        207 164
        104 330
        0 292
        211 126
        367 377
        309 389
        69 14
        70 15
        133 338
        340 424
        160 306
        454 349
        421 422
        367 214
        190 410
        404 304
        176 395
        142 318
        270 126
        318 439
        352 208
        301 234
        133 419
        142 137
        418 199
        229 399
        59 348
        70 379
        243 188
        220 343
        27 151
        402 279
        396 276
        323 417
        125 425
        351 163
        314 53
        36 7
        309 341
        147 16
        367 235
        185 26
        185 25
        18 231
        3 275
        124 45
        411 298
        21 14
        365 350
        363 350
        175 145
        114 121
        117 44
        169 236
        128 304
        448 52
        338 279
        431 106
        253 357
        385 26
        169 260
        282 83
        17 254
        359 373
        333 59
        259 312
        148 421
        368 209
        225 175
        150 455
        265 7
        241 194
        364 97
        291 174
        397 139
        256 6
        242 166
        351 29
        159 66
        71 228
        123 120
        255 93
        230 173
        163 408
        144 309
        166 237
        75 316
        313 129
        227 15
        369 345
        248 174
        11 33
        294 412
        221 98
        375 168
        352 446
        332 326
        314 249
        28 414
        334 59
        0 320
        449 249
        30 155
        365 90
        161 56
        307 324
        261 132
        257 400
        240 148
        97 186
        324 145
        442 187
        394 19
        123 277
        268 275
        156 142
        191 112
        346 329
        284 65
        229 339
        331 244
        34 150
        273 376
        249 369
        430 379
        437 392
        143 453
        149 383
        76 303
        81 112
        55 251
        118 201
        39 14
        436 107
        265 382
        141 9
        297 235
        190 341
        239 179
        163 284
        213 306
        164 284
        370 88
        50 393
        238 448
        394 432
        160 232
        121 151
        113 308
        103 131
        445 306
        335 297
        287 357
        4 379
        245 329
        408 196
        191 109
        136 15
        285 394
        56 108
        250 386
        272 350
        376 119
        54 200
        226 330
        437 63
        431 449
        340 170
        50 11
        359 6
        74 205
        360 9
        274 20
        212 328
        50 200
        380 357
        60 266
        116 305
        333 86
        75 338
        173 82
        57 88
        25 128
        181 342
        211 268
        355 405
        161 100
        386 56
        436 186
        85 178
        199 271
        73 383
        280 293
        38 3
        94 345
        280 371
        217 439
        434 295
        353 370
        72 326
        69 447
        450 128
        195 374
        115 172
        197 316
        18 444
        71 377
        286 272
        441 2
        268 289
        333 87
        202 117
        55 349
        122 321
        153 91
        56 346
        403 22
        154 82
        401 119
        78 215
        255 266
        28 37
        148 155
        372 403
        150 161
        424 92
        70 439
        210 324
        428 109
        34 217
        405 89
        167 87
        414 20
        322 26
        295 19
        358 337
        424 346
        353 67
        52 363
        50 213
        204 131
        92 263
        133 96
        364 141
        286 52
        202 260
        292 82
        136 272
        53 453
        183 89
        39 109
        156 10
        159 11
        157 15
        47 425
        48 427
        158 301
        158 302
        208 425
        209 427
        110 101
        443 421
        300 214
        185 274
        355 373
        116 301
        8 104
        192 268
        173 406
        270 320
        423 391
        317 321
        192 409
        39 417
        366 284
        258 143
        377 84
        220 256
        421 415
        436 432
        240 384
        114 382
        13 46
        171 335
        102 388
        451 87
        221 438
        36 343
        380 249
        134 392
        78 401
        85 231
        307 2
        42 151
        94 143
        319 40
        138 355
        60 381
        65 420
        222 344
        179 336
        294 384
        4 187
        222 348
        133 197
        191 2
        64 32
        319 407
        190 137
        57 67
        387 299
        99 235
        302 25
        337 362
        365 338
        13 5
        77 216
        71 455
        148 425
        256 89
        143 200
        292 416
        28 93
        171 341
        218 16
        116 233
        434 86
        346 168
        45 330
        246 433
        12 407
        245 317
        18 106
        4 227
        360 194
        134 146
        212 160
        340 292
        361 88
        80 313
        229 356
        138 154
        34 317
        309 297
        150 329
        22 287
        30 22
        434 196
        450 35
        293 24
        237 336
        238 339
        164 194
        122 234
        36 154
        231 328
        233 329
        431 85
        157 321
        189 413
        264 118
        171 409
        46 16
        219 328
        398 203
        91 46
        264 96
        205 343
        420 127
        290 203
        54 345
        395 125
        93 206
        364 31
        80 443
        378 395
        335 224
        411 165
        99 389
        331 102
        193 252
        247 198
        454 104
        423 65
        336 129
        366 368
        357 53
        253 30
        41 32
        181 447
        55 322
        448 62
        376 85
        167 207
        387 354
        3 137
        264 344
        430 281
        264 408
        325 95
        159 103
        295 204
        177 168
        29 397
        440 402
        12 283
        75 118
        257 301
        313 166
        122 227
        423 139
        370 298
        446 452
        101 296
        415 165
        57 188
        273 444
        428 447
        123 200
        450 389
        431 447
        113 361
        21 336
        255 246
        331 81
        454 83
        30 443
        332 328
        277 66
        408 316
        134 165
        14 112
        318 251
        392 438
        58 262
        269 51
        442 234
        108 410
        57 308
        73 348
        393 244
        113 47
        359 296
        206 75
        383 387
        315 364
        239 183
        43 288
        307 225
        49 400
        31 374
        286 281
        411 437
        259 291
        49 137
        232 261
        263 233
        63 154
        134 337
        61 313
        107 260
        115 201
        255 139
        28 363
        23 105
        110 17
        358 98
        358 361
        351 96
        352 98
        304 410
        333 19
        131 44
        426 9
        320 79
        95 291
        393 252
        453 310
        83 227
        23 305
        390 384
        358 205
        77 2
        47 189
        245 228
        67 297
        135 260
        319 120
        391 1
        49 55
        111 117
        100 300
        411 446
        12 312
        427 127
        444 43
        381 96
        366 48
        445 33
        377 305
        426 279
        127 141
        265 151
        352 113
        324 393
        147 452
        176 388
        41 186
        226 1
        387 64
        8 385
        90 356
        270 386
        452 308
        121 46
        439 62
        397 37
        42 189
        312 40
        241 451
        315 440
        451 432
        99 84
        79 211
        360 374
        417 287
        76 213
        220 230
        373 412
        61 22
        223 298
        114 92
        180 254
        111 33
        136 339
        193 80
        385 37
        241 48
        146 443
        265 406
        153 298
        6 378
        158 278
        106 314
        388 225
        295 371
        193 262
        273 72
        453 252
        400 305
        157 51
        442 330
        4 455
        181 178
        206 350
        239 323
        78 299
        296 27
        291 120
        319 334
        362 89
        168 289
        140 222
        69 310
        147 101
        201 311
        288 174
        290 175
        278 455
        210 11
        271 7
        445 202
        414 251
        332 33
        382 214
        32 172
        429 410
        422 203
        111 103
        149 434
        370 79
        285 182
        397 60
        398 61
        369 248
        115 279
        68 224
        285 215
        360 115
        253 145
        138 392
        8 139
        344 419
        18 326
        140 64
        110 446
        101 418
        240 395
        164 31
        72 445
        327 87
        302 349
        299 107
        181 112
        257 25
        146 129
        79 416
        218 82
        152 371
        285 107
        380 242
        267 356
        119 174
        223 416
        218 7
        184 399
        435 45
        369 66
        158 187
        398 155
        216 342
        253 252
        448 266
        49 35
        243 409
        162 36
        303 66
        195 201
        259 149
        223 243
        420 31
        325 119
        126 108
        433 349
        60 363
        454 187
        226 396
        160 182
        414 26
        188 335
        226 399
        175 155
        29 427
        153 452
        436 354
        207 97
        152 196
        247 276
        169 347
        9 276
        361 165
        229 198
        236 283
        340 177
        290 262
        246 251
        39 53
        29 65
        146 403
        429 142
        162 256
        246 62
        422 17
        42 271
        315 426
        54 40
        259 204
        327 48
        240 225
        236 64
        311 32
        194 24
        183 378
        135 325
        300 177
        183 372
        220 337
        258 449
        166 287
        219 178
        274 404
        344 311
        177 192
        236 78
        67 121
        190 450
        277 213
        171 275
        80 203
        144 68
        223 63
        413 199
        94 314
        153 188
        21 372
        244 262
        320 74
        331 342
        184 90
        327 197
        359 230
        69 237
        38 128
        70 238
        182 132
        345 288
        167 152
        294 378
        124 396
        23 5
        269 317
        401 43
        380 58
        13 92
        347 215
        179 412
        332 77
        304 10
        100 71
        422 390
        95 383
        441 388
        294 21
        76 244
        106 109
        417 372
        68 275
        367 5
        202 182
        51 20
        52 20
        170 218
        145 58
        390 102
        391 104
        124 282
        250 424
        197 86
        209 37
        217 404
        438 405
        161 429
        327 351
        325 299
        176 180
        38 105
        373 418
        105 389
        353 144
        172 24
        173 27
        343 406
        407 348
        354 402
        163 167
        27 16
        215 212
        162 355
        366 316
        315 195
        368 423
        381 365
        94 444
        198 374
        34 379
        73 86
        74 88
        38 400
        347 117
        449 310
        437 98
        125 254
        419 402
        76 216
        3 10
        35 84
        390 180
        147 271
        435 83
        432 24
        204 261
        13 170
        334 44
        219 216
        353 91
        102 290
        8 433
        247 136
        157 286
        415 47
        68 105
        269 404
        206 130
        270 409
        74 243
        58 303
        451 97
        334 132
        399 281
        278 84
        362 403
        162 199
        184 276
        258 376
        224 5
        179 405
        184 272
        394 280
        103 232
        42 308
        310 242
        398 208
        170 214
        1 198
        23 263
        210 77
        258 248
        191 326
        61 221
        247 282
        114 235
        269 156
        440 311
        385 45
        189 296
        123 248
        221 362
        152 59
        318 51
        302 35
        241 141
        159 54
        391 282
        """

        self.waters = """
        0.125 0.27501 0.06399
        0.19578 0.59565 0.35588
        0.30422 0.98795 0.35382
        0.67922 0.39424 0.75
        0.32078 0.47684 0.25
        0.67856 0.33432 0.43939
        0.18459 0.14662 0.25
        0.5 0.24163 0.25
        0.125 0.54453 0.58442
        0.68459 0.64662 0.25
        0.80422 0.40435 0.85588
        0.17922 0.92432 0.56045
        0.18459 0.81647 0.93562
        0.80356 0.31098 0.35702
        0.0 0.02099 0.125
        0.5 0.52099 0.125
        0.81541 0.24592 0.375
        0.69644 0.13213 0.54486
        0.30356 0.92198 0.14692
        0.69041 0.7791 0.56102
        0.80422 0.51205 0.85382
        0.0 0.06419 0.12368
        0.30356 0.07803 0.85308
        0.80356 0.36787 0.45514
        0.5 0.7278 0.32899
        0.0 0.45703 0.62426
        0.80422 0.51205 0.64618
        0.0 0.2278 0.32899
        0.67856 0.56716 0.75
        0.0 0.63354 0.62722
        0.17856 0.06716 0.75
        0.19041 0.65908 0.35662
        0.31541 0.74592 0.125
        0.17856 0.90132 0.43545
        0.125 0.45548 0.08442
        0.32078 0.42432 0.56045
        0.5 0.21672 0.14001
        0.80356 0.57803 0.64692
        0.80422 0.40435 0.64413
        0.17922 0.0105 0.0625
        0.18459 0.85338 0.75
        0.19041 0.75985 0.25
        0.30959 0.2209 0.43899
        0.30356 0.86787 0.04486
        0.18459 0.81647 0.56439
        0.80422 0.54359 0.45942
        0.875 0.27501 0.43602
        0.17856 0.16568 0.56062
        0.67856 0.66568 0.56062
        0.5 0.43581 0.62368
        0.0 0.93581 0.62368
        0.67922 0.48951 0.9375
        0.875 0.54453 0.91558
        0.17922 0.98951 0.9375
        0.17922 0.89424 0.75
        0.5 0.47901 0.625
        0.19644 0.36787 0.04486
        0.31541 0.25409 0.625
        0.5 0.99045 0.6875
        0.0 0.7722 0.67101
        0.0 0.60042 0.81176
        0.5 0.10042 0.81176
        0.19578 0.51205 0.85382
        0.625 0.22499 0.93602
        0.375 0.77501 0.06399
        0.19644 0.63213 0.54486
        0.5 0.92595 0.68676
        0.19041 0.2791 0.56102
        0.80959 0.34092 0.64338
        0.82078 0.0105 0.0625
        0.32078 0.5105 0.0625
        0.5 0.41078 0.25
        0.0 0.91078 0.25
        0.81541 0.75409 0.875
        0.31541 0.25409 0.875
        0.5 0.65463 0.87837
        0.69578 0.95642 0.54058
        0.375 0.95548 0.41558
        0.5 0.83301 0.18899
        0.0 0.28329 0.85999
        0.82144 0.06716 0.75
        0.0 0.02099 0.375
        0.81541 0.24592 0.125
        0.5 0.52099 0.375
        0.32144 0.40132 0.43545
        0.69644 0.92198 0.14692
        0.69041 0.74016 0.75
        0.875 0.72499 0.56399
        0.19041 0.24016 0.75
        0.375 0.12971 0.08014
        0.875 0.62971 0.08014
        0.80959 0.2791 0.56102
        0.0 0.33301 0.31102
        0.5 0.58922 0.75
        0.17922 0.92432 0.93956
        0.81541 0.81647 0.93562
        0.0 0.66699 0.81102
        0.0 0.71672 0.35999
        0.5 0.16699 0.81102
        0.19644 0.36787 0.45514
        0.5 0.3898 0.12632
        0.81541 0.18353 0.43562
        0.69578 0.04359 0.45942
        0.375 0.87029 0.58014
        0.19578 0.54359 0.45942
        0.875 0.37029 0.58014
        0.375 0.95548 0.08442
        0.82144 0.8 0.25
        0.125 0.37029 0.91986
        0.30422 0.98795 0.14618
        0.82144 0.16568 0.56062
        0.30356 0.86787 0.45514
        0.0 0.99877 0.25
        0.30356 0.18902 0.64298
        0.19644 0.31098 0.35702
        0.5 0.69032 0.12837
        0.80356 0.42198 0.35308
        0.17856 0.83432 0.43939
        0.32144 0.66568 0.93939
        0.69644 0.86787 0.04486
        0.81541 0.85338 0.75
        0.125 0.27501 0.43602
        0.67922 0.47684 0.25
        0.82078 0.89424 0.75
        0.67922 0.57568 0.43956
        0.375 0.12971 0.41986
        0.19041 0.34092 0.85662
        0.875 0.62971 0.41986
        0.0 0.42595 0.68676
        0.82144 0.09868 0.93545
        0.32144 0.59868 0.93545
        0.30959 0.84092 0.64338
        0.81541 0.81647 0.56439
        0.80356 0.68902 0.85702
        0.0 0.15463 0.87837
        0.0 0.84537 0.12163
        0.5 0.56419 0.12368
        0.5 0.41483 0.75
        0.81541 0.18353 0.06439
        0.19644 0.57803 0.64692
        0.30959 0.7791 0.93899
        0.80959 0.65908 0.35662
        0.5 0.43581 0.87632
        0.0 0.93581 0.87632
        0.0 0.32167 0.68602
        0.30422 0.01205 0.64618
        0.0 0.1102 0.87368
        0.69041 0.2209 0.43899
        0.17856 0.09868 0.56456
        0.5 0.78329 0.85999
        0.19644 0.42198 0.14692
        0.18459 0.24592 0.375
        0.18459 0.75409 0.625
        0.68459 0.25409 0.625
        0.69041 0.2209 0.06102
        0.30356 0.07803 0.64692
        0.67922 0.42432 0.93956
        0.67922 0.5105 0.0625
        0.125 0.45548 0.41558
        0.30422 0.90435 0.64413
        0.69644 0.86787 0.45514
        0.32144 0.40132 0.06456
        0.5 0.17834 0.18602
        0.19644 0.68902 0.64298
        0.31541 0.68353 0.43562
        0.0 0.17807 0.75
        0.625 0.04453 0.91558
        0.125 0.72499 0.56399
        0.80356 0.36787 0.04486
        0.17856 0.8 0.25
        0.67856 0.3 0.25
        0.5 0.33312 0.75
        0.5 0.7278 0.17101
        0.0 0.2278 0.17101
        0.625 0.87029 0.91986
        0.375 0.04453 0.58442
        0.5 0.07406 0.31324
        0.67856 0.33432 0.06062
        0.82144 0.93285 0.25
        0.69578 0.09565 0.14413
        0.69578 0.09565 0.35588
        0.82078 0.97684 0.25
        0.82144 0.83432 0.43939
        0.30422 0.09565 0.14413
        0.80422 0.59565 0.14413
        0.0 0.49045 0.6875
        0.0 0.74163 0.25
        0.19578 0.48795 0.35382
        0.5 0.2722 0.67101
        0.18459 0.18353 0.43562
        0.32078 0.39424 0.75
        0.17922 0.97684 0.25
        0.68459 0.31647 0.93562
        0.82078 0.02316 0.75
        0.5 0.69032 0.37163
        0.19041 0.65908 0.14338
        0.30959 0.74016 0.75
        0.67856 0.7 0.75
        0.32078 0.60577 0.25
        0.5 0.17834 0.31399
        0.0 0.91483 0.75
        0.31541 0.68353 0.06439
        0.0 0.84537 0.37837
        0.69644 0.07803 0.64692
        0.5 0.82167 0.68602
        0.375 0.22499 0.93602
        0.5 0.6102 0.87368
        0.19041 0.7209 0.43899
        0.5 0.13354 0.62722
        0.67856 0.59868 0.56456
        0.30422 0.95642 0.54058
        0.0 0.32167 0.81399
        0.5 0.86647 0.37278
        0.82078 0.92432 0.56045
        0.5 0.32193 0.25
        0.5 0.83301 0.31102
        0.625 0.95548 0.41558
        0.19578 0.45642 0.95942
        0.69041 0.25985 0.25
        0.69644 0.92198 0.35308
        0.18459 0.18353 0.06439
        0.5 0.13354 0.87278
        0.18459 0.75409 0.875
        0.68459 0.25409 0.875
        0.68459 0.31647 0.56439
        0.30422 0.04359 0.45942
        0.0 0.57406 0.31324
        0.5 0.49877 0.25
        0.67856 0.43285 0.25
        0.19578 0.59565 0.14413
        0.0 0.19032 0.12837
        0.5 0.89959 0.18824
        0.625 0.87029 0.58014
        0.0 0.39959 0.31176
        0.80422 0.48795 0.35382
        0.32144 0.33432 0.43939
        0.30356 0.81098 0.14298
        0.69578 0.04359 0.04058
        0.19578 0.54359 0.04058
        0.5 0.07406 0.18676
        0.17922 0.07568 0.43956
        0.68459 0.68353 0.43562
        0.69578 0.01205 0.85382
        0.5 0.2722 0.82899
        0.82078 0.98951 0.5625
        0.80356 0.42198 0.14692
        0.32078 0.52316 0.75
        0.5 0.58518 0.25
        0.69578 0.90435 0.85588
        0.5 0.95703 0.87574
        0.19644 0.31098 0.14298
        0.5 0.50123 0.75
        0.0 0.00123 0.75
        0.17922 0.02316 0.75
        0.625 0.12971 0.41986
        0.32144 0.56716 0.75
        0.30959 0.15908 0.14338
        0.80422 0.45642 0.54058
        0.82078 0.92432 0.93956
        0.5 0.82167 0.81399
        0.0 0.82193 0.25
        0.69041 0.84092 0.64338
        0.69578 0.01205 0.64618
        0.0 0.36647 0.37278
        0.19644 0.68902 0.85702
        0.30959 0.25985 0.25
        0.19644 0.57803 0.85308
        0.19644 0.63213 0.95514
        0.80959 0.34092 0.85662
        0.80422 0.45642 0.95942
        0.31541 0.31647 0.93562
        0.5 0.21672 0.35999
        0.67922 0.57568 0.06045
        0.0 0.8898 0.12632
        0.0 0.49045 0.8125
        0.68459 0.35338 0.75
        0.67922 0.60577 0.25
        0.69578 0.90435 0.64413
        0.19644 0.42198 0.35308
        0.68459 0.68353 0.06439
        0.375 0.77501 0.43602
        0.0 0.54297 0.12426
        0.5 0.56419 0.37632
        0.17856 0.83432 0.06062
        0.32144 0.66568 0.56062
        0.69644 0.81098 0.35702
        0.80422 0.54359 0.04058
        0.375 0.04453 0.91558
        0.375 0.87029 0.91986
        0.875 0.37029 0.91986
        0.625 0.04453 0.58442
        0.69041 0.84092 0.85662
        0.875 0.27501 0.06399
        0.31541 0.74592 0.375
        0.0 0.08518 0.25
        0.5 0.78329 0.64001
        0.0 0.19032 0.37163
        0.31541 0.31647 0.56439
        0.80959 0.24016 0.75
        0.69644 0.81098 0.14298
        0.5 0.34537 0.12163
        0.875 0.45548 0.41558
        0.19578 0.45642 0.54058
        0.5 0.95703 0.62426
        0.0 0.42595 0.81324
        0.67856 0.40132 0.43545
        0.82144 0.90132 0.43545
        0.17922 0.0105 0.4375
        0.375 0.22499 0.56399
        0.19041 0.34092 0.64338
        0.82078 0.98951 0.9375
        0.19041 0.7209 0.06102
        0.30959 0.84092 0.85662
        0.69644 0.07803 0.85308
        0.30422 0.95642 0.95942
        0.0 0.67834 0.18602
        0.5 0.67807 0.75
        0.875 0.45548 0.08442
        0.5 0.47901 0.875
        0.0 0.83312 0.75
        0.19041 0.2791 0.93899
        0.80422 0.48795 0.14618
        0.67922 0.48951 0.5625
        0.5 0.04297 0.12426
        0.17922 0.98951 0.5625
        0.82144 0.83432 0.06062
        0.17856 0.93285 0.25
        0.80356 0.68902 0.64298
        0.5 0.89959 0.31176
        0.0 0.39959 0.18824
        0.0 0.54297 0.37574
        0.82078 0.0105 0.4375
        0.30356 0.92198 0.35308
        0.81541 0.75409 0.625
        0.0 0.80968 0.62837
        0.5 0.30968 0.62837
        0.82078 0.07568 0.06045
        0.17856 0.16568 0.93939
        0.67856 0.66568 0.93939
        0.32078 0.57568 0.06045
        0.80356 0.31098 0.14298
        0.31541 0.35338 0.75
        0.69578 0.98795 0.35382
        0.30959 0.2209 0.06102
        0.125 0.72499 0.93602
        0.30422 0.90435 0.85588
        0.0 0.36647 0.12722
        0.30356 0.81098 0.35702
        0.0 0.7722 0.82899
        0.32078 0.48951 0.5625
        0.67856 0.59868 0.93545
        0.0 0.66699 0.68899
        0.5 0.16699 0.68899
        0.0 0.28329 0.64001
        0.68459 0.74592 0.125
        0.69041 0.15908 0.14338
        0.125 0.62971 0.08014
        0.30422 0.01205 0.85382
        0.30356 0.18902 0.85702
        0.0 0.16688 0.25
        0.5 0.66688 0.25
        0.17856 0.2 0.75
        0.30356 0.13213 0.95514
        0.80356 0.57803 0.85308
        0.0 0.67834 0.31399
        0.80356 0.63213 0.95514
        0.5 0.65463 0.62163
        0.5 0.34537 0.37837
        0.5 0.6102 0.62632
        0.5 0.92595 0.81324
        0.0 0.25838 0.75
        0.30959 0.7791 0.56102
        0.17922 0.07568 0.06045
        0.81541 0.14662 0.25
        0.31541 0.64662 0.25
        0.67856 0.40132 0.06456
        0.82144 0.90132 0.06456
        0.5 0.3898 0.37368
        0.17922 0.10577 0.25
        0.19578 0.48795 0.14618
        0.5 0.99045 0.8125
        0.0 0.63354 0.87278
        0.32144 0.3 0.25
        0.69041 0.7791 0.93899
        0.0 0.06419 0.37632
        0.875 0.54453 0.58442
        0.32144 0.33432 0.06062
        0.625 0.77501 0.06399
        0.5 0.04297 0.37574
        0.125 0.37029 0.58014
        0.82078 0.07568 0.43956
        0.32078 0.57568 0.43956
        0.82144 0.16568 0.93939
        0.0 0.97901 0.625
        0.625 0.77501 0.43602
        0.30422 0.09565 0.35588
        0.80422 0.59565 0.35588
        0.0 0.60042 0.68824
        0.5 0.10042 0.68824
        0.0 0.57406 0.18676
        0.67922 0.42432 0.56045
        0.5 0.86647 0.12722
        0.80959 0.7209 0.06102
        0.17856 0.09868 0.93545
        0.0 0.45703 0.87574
        0.625 0.12971 0.08014
        0.18459 0.24592 0.125
        0.0 0.80968 0.87163
        0.32144 0.7 0.75
        0.5 0.30968 0.87163
        0.19578 0.40435 0.85588
        0.82144 0.2 0.75
        0.82078 0.10577 0.25
        0.30959 0.15908 0.35662
        0.67922 0.52316 0.75
        0.0 0.15463 0.62163
        0.80959 0.2791 0.93899
        0.30422 0.04359 0.04058
        0.69041 0.15908 0.35662
        0.875 0.72499 0.93602
        0.125 0.62971 0.41986
        0.0 0.1102 0.62632
        0.82144 0.09868 0.56456
        0.32144 0.59868 0.56456
        0.0 0.33301 0.18899
        0.30356 0.13213 0.54486
        0.80959 0.65908 0.14338
        0.80356 0.63213 0.54486
        0.5 0.00956 0.1875
        0.32078 0.42432 0.93956
        0.0 0.50956 0.1875
        0.625 0.95548 0.08442
        0.68459 0.74592 0.375
        0.19578 0.51205 0.64618
        0.5 0.75838 0.75
        0.67922 0.5105 0.4375
        0.80959 0.75985 0.25
        0.69644 0.18902 0.85702
        0.69644 0.13213 0.95514
        0.32078 0.48951 0.9375
        0.0 0.71672 0.14001
        0.5 0.00956 0.3125
        0.0 0.50956 0.3125
        0.0 0.08922 0.75
        0.17856 0.90132 0.06456
        0.0 0.8898 0.37368
        0.69644 0.18902 0.64298
        0.69578 0.98795 0.14618
        0.125 0.54453 0.91558
        0.69578 0.95642 0.95942
        0.19578 0.40435 0.64413
        0.80959 0.7209 0.43899
        0.625 0.22499 0.56399
        0.0 0.97901 0.875
        0.32078 0.5105 0.4375
        0.32144 0.43285 0.25
        """

        self.coord = "relative"

        self.cages = """
        12 -0.5 -0.22173 1.25
        14 -0.21689 0.04198 0.25
        14 0.71689 0.45802 -0.25
        15 1.0 1.12837 0.07945
        15 0.5 0.45556 0.08472
        12 0.5 0.12434 0.25
        12 -0.23835 0.20539 0.25
        14 0.21424 0.866 0.25
        12 0.0 -0.45426 0.75
        15 0.0 1.12837 0.42055
        14 0.28576 -0.366 -0.25
        12 0.23835 0.20539 0.25
        12 -0.5 -0.17822 -0.50594
        14 -0.21689 -0.04198 0.75
        12 0.26165 0.70539 0.25
        12 0.0 0.45426 0.25
        14 0.21424 0.134 0.75
        12 0.0 0.67822 -0.00594
        12 -0.5 -0.08792 1.00295
        15 0.0 -0.12837 -0.07945
        14 0.28311 0.54198 0.25
        14 -0.28576 0.366 0.25
        14 0.28576 0.366 0.25
        15 -0.5 -0.62837 -0.07945
        12 1.0 0.72173 0.75
        12 0.23835 -0.20539 -0.25
        16 -0.5 -0.27786 -0.06597
        15 -0.5 0.45556 0.41528
        12 0.0 0.41208 -0.50295
        16 0.5 0.27786 0.06597
        12 -0.5 0.17822 -0.00594
        15 0.0 0.95556 0.41528
        12 0.73835 0.70539 0.25
        12 1.0 0.67822 0.50594
        14 0.71689 0.54198 0.25
        12 1.0 0.62434 0.25
        16 -0.5 0.27786 0.43403
        12 0.5 0.95426 0.25
        12 -0.5 -0.17822 1.00594
        15 -0.5 -0.45556 0.58472
        16 0.0 0.22214 0.56597
        12 0.5 0.17822 0.50594
        12 0.26165 0.29461 0.75
        12 0.5 0.0 0.0
        15 0.5 0.62837 0.07945
        15 1.0 0.95556 0.08472
        12 -0.5 0.08792 -0.00295
        16 -0.5 -0.27786 0.56597
        12 -0.5 -0.08792 -0.50295
        12 0.5 0.04574 0.75
        16 1.0 0.77786 0.06597
        15 0.0 -0.12837 0.57945
        14 0.78576 0.866 0.25
        12 0.0 0.5 0.5
        12 0.0 0.58792 -0.00295
        16 0.0 0.77786 0.43403
        14 0.28311 0.45802 0.75
        12 0.5 0.08792 0.50295
        15 -0.5 0.62837 0.42055
        16 0.0 0.22214 -0.06597
        12 -0.5 -0.12434 0.75
        12 0.0 0.27827 1.25
        12 -0.23835 -0.20539 0.75
        14 0.21689 -0.04198 -0.25
        12 1.0 0.5 0.0
        12 0.5 0.22173 0.75
        12 0.73835 0.29461 -0.25
        12 -0.5 0.0 0.5
        15 -0.5 -0.62837 0.57945
        14 -0.28576 -0.366 0.75
        12 0.0 0.32178 1.00594
        12 1.0 0.58792 0.50295
        14 0.78576 0.134 -0.25
        12 0.0 0.32178 -0.50594
        15 -0.5 -0.45556 -0.08472
        14 0.21689 0.04198 0.25
        12 0.0 0.41208 1.00295
        15 0.0 0.04444 -0.08472
        12 0.0 0.37566 0.75
        15 0.0 0.04444 0.58472
        """

        self.bondlen = 3

        self.cell = """
        13.692458685072577 76.91336635680119 22.86407363601791
        """

        self.density = 0.5660564289434464

        self.cell = cellvectors(a=13.692458685072577,
                                b=76.91336635680119,
                                c=22.86407363601791)
